(ns daifu.diagnosis.result)

(defrecord Result [])

(defmethod print-method Result
  [v w]
  (.write w (str (if (:raw v)
                   (into {} (select-keys v [:raw :value]))
                   (:value v)))))

(defn result?
  "checks whether input is of type result
   (result? 1)
   => false
   (result? (result 1))
   => true"
  {:added "0.2"}
  [x]
  (instance? Result x))

(defn result
  "constructs a result datatype
   (->> (result 1)
        (into {}))
   => {:data 1}
   (->> (result {:file \"hello/example.clj\" :data 1})
        (into {}))
   => {:file \"hello/example.clj\", :data 1}
   (->> (result 1)
        (result)
        (into {}))
   => {:value 1}"
  {:added "0.2"}
  [x]
  (cond (result? x)
        x

        (map? x)
        (map->Result x)

        :else
        (result {:value x})))

(defn ->results
  "constructs an array of results
   (->> (->results 1)
        (mapv #(into {} %)))
   => [{:value 1}]
   (->> (->results [1 2 3 4])
        (mapv #(into {} %)))
   => [{:value 1} {:value 2} {:value 3} {:value 4}]"
  {:added "0.2"}
  [x]
  (cond (vector? x)
        (vec (mapcat ->results x))

        :else
        [(result x)]))
