/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GPLNativeCodeLoader {
    public static final String LIBRARY_NAME = "gplcompression";
    public static final String USE_BINARIES_ON_LIB_PATH = "com.hadoop.compression.lzo.use.libpath";
    private static final Log LOG = LogFactory.getLog(GPLNativeCodeLoader.class);
    private static boolean nativeLibraryLoaded = false;

    public static boolean isNativeCodeLoaded() {
        return nativeLibraryLoaded;
    }

    private static boolean useBinariesOnLibPath() {
        return Boolean.getBoolean(USE_BINARIES_ON_LIB_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File unpackBinaries() {
        String fileName = System.mapLibraryName(LIBRARY_NAME);
        String directory = GPLNativeCodeLoader.getDirectoryLocation();
        InputStream is = GPLNativeCodeLoader.class.getResourceAsStream(directory + "/" + fileName);
        if (is == null) {
            if (GPLNativeCodeLoader.getOsName().contains("Mac")) {
                if (fileName.endsWith(".dylib")) {
                    fileName = fileName.replace(".dylib", ".jnilib");
                } else if (fileName.endsWith(".jnilib")) {
                    fileName = fileName.replace(".jnilib", ".dylib");
                }
                is = GPLNativeCodeLoader.class.getResourceAsStream(directory + "/" + fileName);
            }
            if (is == null) {
                return null;
            }
        }
        byte[] buffer = new byte[8192];
        OutputStream os = null;
        try {
            File unpackedFile = File.createTempFile("unpacked-", "-" + fileName);
            unpackedFile.deleteOnExit();
            os = new FileOutputStream(unpackedFile);
            int read = 0;
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            unpackedFile.setExecutable(true, false);
            LOG.debug((Object)("temporary unpacked path: " + unpackedFile));
            File file = unpackedFile;
            return file;
        }
        catch (IOException e) {
            LOG.error((Object)"could not unpack the binaries", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getDirectoryLocation() {
        String osName = GPLNativeCodeLoader.getOsName().replace(' ', '_');
        boolean windows = osName.toLowerCase().contains("windows");
        if (!windows) {
            String location = "/native/" + osName + "-" + System.getProperty("os.arch") + "-" + System.getProperty("sun.arch.data.model") + "/lib";
            LOG.debug((Object)("location: " + location));
            return location;
        }
        String location = "/native/" + System.getenv("OS") + "-" + System.getenv("PLATFORM") + "/lib";
        LOG.debug((Object)("location: " + location));
        return location;
    }

    private static String getOsName() {
        return System.getProperty("os.name");
    }

    static {
        try {
            if (!GPLNativeCodeLoader.useBinariesOnLibPath()) {
                File unpackedFile = GPLNativeCodeLoader.unpackBinaries();
                if (unpackedFile != null) {
                    String path = unpackedFile.getAbsolutePath();
                    System.load(path);
                    LOG.info((Object)"Loaded native gpl library from the embedded binaries");
                } else {
                    System.loadLibrary(LIBRARY_NAME);
                    LOG.info((Object)"Loaded native gpl library from the library path");
                }
            } else {
                System.loadLibrary(LIBRARY_NAME);
                LOG.info((Object)"Loaded native gpl library from the library path");
            }
            nativeLibraryLoaded = true;
        }
        catch (Throwable t) {
            LOG.error((Object)"Could not load native gpl library", t);
            nativeLibraryLoaded = false;
        }
    }
}

