/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.GPLNativeCodeLoader;
import com.hadoop.compression.lzo.LzoCompressor;
import com.hadoop.compression.lzo.LzoDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class LzoCodec
implements Configurable,
CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)LzoCodec.class.getName());
    public static final String LZO_COMPRESSOR_KEY = "io.compression.codec.lzo.compressor";
    public static final String LZO_DECOMPRESSOR_KEY = "io.compression.codec.lzo.decompressor";
    public static final String LZO_COMPRESSION_LEVEL_KEY = "io.compression.codec.lzo.compression.level";
    public static final String LZO_BUFFER_SIZE_KEY = "io.compression.codec.lzo.buffersize";
    public static final int DEFAULT_LZO_BUFFER_SIZE = 262144;
    public static final int MAX_BLOCK_SIZE = 0x4000000;
    public static final int UNDEFINED_COMPRESSION_LEVEL = -999;
    private Configuration conf;
    private static boolean nativeLzoLoaded = false;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeLzoLoaded(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return nativeLzoLoaded && conf.getBoolean("hadoop.native.lib", true);
    }

    public static String getRevisionHash() {
        try {
            Properties p = new Properties();
            p.load(LzoCodec.class.getResourceAsStream("/build.properties"));
            return p.getProperty("build_revision");
        }
        catch (IOException e) {
            LOG.error((Object)"Could not find build properties file with revision hash");
            return "UNKNOWN";
        }
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        LzoCompressor.CompressionStrategy strategy = LzoCodec.getCompressionStrategy(this.conf);
        int bufferSize = LzoCodec.getBufferSize(this.conf);
        int compressionOverhead = strategy.name().contains("LZO1") ? (bufferSize >> 4) + 64 + 3 : (bufferSize >> 3) + 128 + 3;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    public Class<? extends Compressor> getCompressorType() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return LzoCompressor.class;
    }

    public Compressor createCompressor() {
        assert (this.conf != null) : "Configuration cannot be null! You must call setConf() before creating a compressor.";
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new LzoCompressor(this.conf);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt(LZO_BUFFER_SIZE_KEY, 262144));
    }

    public Class<? extends Decompressor> getDecompressorType() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return LzoDecompressor.class;
    }

    public Decompressor createDecompressor() {
        if (!LzoCodec.isNativeLzoLoaded(this.conf)) {
            throw new RuntimeException("native-lzo library not available");
        }
        return new LzoDecompressor(LzoCodec.getDecompressionStrategy(this.conf), LzoCodec.getBufferSize(this.conf));
    }

    public String getDefaultExtension() {
        return ".lzo_deflate";
    }

    static LzoCompressor.CompressionStrategy getCompressionStrategy(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return LzoCompressor.CompressionStrategy.valueOf(conf.get(LZO_COMPRESSOR_KEY, LzoCompressor.CompressionStrategy.LZO1X_1.name()));
    }

    static LzoDecompressor.CompressionStrategy getDecompressionStrategy(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return LzoDecompressor.CompressionStrategy.valueOf(conf.get(LZO_DECOMPRESSOR_KEY, LzoDecompressor.CompressionStrategy.LZO1X.name()));
    }

    static int getCompressionLevel(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return conf.getInt(LZO_COMPRESSION_LEVEL_KEY, -999);
    }

    static int getBufferSize(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return conf.getInt(LZO_BUFFER_SIZE_KEY, 262144);
    }

    public static void setCompressionStrategy(Configuration conf, LzoCompressor.CompressionStrategy strategy) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.set(LZO_COMPRESSOR_KEY, strategy.name());
    }

    public static void setDecompressionStrategy(Configuration conf, LzoDecompressor.CompressionStrategy strategy) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.set(LZO_DECOMPRESSOR_KEY, strategy.name());
    }

    public static void setCompressionLevel(Configuration conf, int compressionLevel) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.setInt(LZO_COMPRESSION_LEVEL_KEY, compressionLevel);
    }

    public static void setBufferSize(Configuration conf, int bufferSize) {
        assert (conf != null) : "Configuration cannot be null!";
        conf.setInt(LZO_BUFFER_SIZE_KEY, bufferSize);
    }

    static {
        if (GPLNativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeLzoLoaded = LzoCompressor.isNativeLzoLoaded() && LzoDecompressor.isNativeLzoLoaded();
            if (nativeLzoLoaded) {
                LOG.info((Object)("Successfully loaded & initialized native-lzo library [hadoop-lzo rev " + LzoCodec.getRevisionHash() + "]"));
            } else {
                LOG.error((Object)"Failed to load/initialize native-lzo library");
            }
        } else {
            LOG.error((Object)"Cannot load native-lzo without native-hadoop");
        }
    }
}

