/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.compression.lzo;

import com.hadoop.compression.lzo.CChecksum;
import com.hadoop.compression.lzo.DChecksum;
import com.hadoop.compression.lzo.LzoDecompressor;
import java.io.IOException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.zip.Checksum;

public class LzopDecompressor
extends LzoDecompressor {
    private final EnumMap<DChecksum, Checksum> chkDMap = new EnumMap(DChecksum.class);
    private final EnumMap<CChecksum, Checksum> chkCMap = new EnumMap(CChecksum.class);

    public LzopDecompressor(int bufferSize) {
        super(LzoDecompressor.CompressionStrategy.LZO1X_SAFE, bufferSize);
    }

    public void initHeaderFlags(EnumSet<DChecksum> dflags, EnumSet<CChecksum> cflags) {
        try {
            for (DChecksum dChecksum : dflags) {
                this.chkDMap.put(dChecksum, dChecksum.getChecksumClass().newInstance());
            }
            for (CChecksum cChecksum : cflags) {
                this.chkCMap.put(cChecksum, cChecksum.getChecksumClass().newInstance());
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Internal error", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Internal error", e);
        }
    }

    public int getChecksumsCount() {
        return this.getCompressedChecksumsCount() + this.getDecompressedChecksumsCount();
    }

    public int getCompressedChecksumsCount() {
        return this.chkCMap.size();
    }

    public int getDecompressedChecksumsCount() {
        return this.chkDMap.size();
    }

    public synchronized void resetChecksum() {
        for (Checksum chk : this.chkDMap.values()) {
            chk.reset();
        }
        for (Checksum chk : this.chkCMap.values()) {
            chk.reset();
        }
    }

    public synchronized boolean verifyDChecksum(DChecksum typ, int checksum) {
        return checksum == (int)this.chkDMap.get((Object)typ).getValue();
    }

    public synchronized boolean verifyCChecksum(CChecksum typ, int checksum) {
        return checksum == (int)this.chkCMap.get((Object)typ).getValue();
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (!this.isCurrentBlockUncompressed()) {
            for (Checksum chk : this.chkCMap.values()) {
                chk.update(b, off, len);
            }
        }
        super.setInput(b, off, len);
    }

    @Override
    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        int ret = super.decompress(b, off, len);
        if (ret > 0) {
            for (Checksum chk : this.chkDMap.values()) {
                chk.update(b, off, ret);
            }
        }
        return ret;
    }
}

