/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class SecorConfig {
    private final PropertiesConfiguration mProperties;
    private static final ThreadLocal<SecorConfig> mSecorConfig = new ThreadLocal<SecorConfig>(){

        @Override
        protected SecorConfig initialValue() {
            PropertiesConfiguration properties;
            Properties systemProperties = System.getProperties();
            String configProperty = systemProperties.getProperty("config");
            try {
                properties = new PropertiesConfiguration(configProperty);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading configuration from " + configProperty);
            }
            for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
                properties.setProperty(entry.getKey().toString(), entry.getValue());
            }
            return new SecorConfig(properties);
        }
    };

    public static SecorConfig load() throws ConfigurationException {
        return mSecorConfig.get();
    }

    public SecorConfig(PropertiesConfiguration properties) {
        this.mProperties = properties;
    }

    public String getKafkaSeedBrokerHost() {
        return this.getString("kafka.seed.broker.host");
    }

    public int getKafkaSeedBrokerPort() {
        return this.getInt("kafka.seed.broker.port");
    }

    public String getKafkaZookeeperPath() {
        return this.getString("kafka.zookeeper.path");
    }

    public String getZookeeperQuorum() {
        return StringUtils.join((Object[])this.getStringArray("zookeeper.quorum"), (char)',');
    }

    public int getConsumerTimeoutMs() {
        return this.getInt("kafka.consumer.timeout.ms");
    }

    public String getRebalanceMaxRetries() {
        return this.getString("kafka.rebalance.max.retries");
    }

    public String getFetchMessageMaxBytes() {
        return this.getString("kafka.fetch.message.max.bytes");
    }

    public String getSocketReceieveBufferBytes() {
        return this.getString("kafka.socket.receive.buffer.bytes");
    }

    public int getGeneration() {
        return this.getInt("secor.generation");
    }

    public int getConsumerThreads() {
        return this.getInt("secor.consumer.threads");
    }

    public long getMaxFileSizeBytes() {
        return this.getLong("secor.max.file.size.bytes");
    }

    public long getMaxFileAgeSeconds() {
        return this.getLong("secor.max.file.age.seconds");
    }

    public long getOffsetsPerPartition() {
        return this.getLong("secor.offsets.per.partition");
    }

    public int getMessagesPerSecond() {
        return this.getInt("secor.messages.per.second");
    }

    public String getS3Bucket() {
        return this.getString("secor.s3.bucket");
    }

    public String getS3Path() {
        return this.getString("secor.s3.path");
    }

    public String getLocalPath() {
        return this.getString("secor.local.path");
    }

    public String getKafkaTopicFilter() {
        return this.getString("secor.kafka.topic_filter");
    }

    public String getKafkaGroup() {
        return this.getString("secor.kafka.group");
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.getInt("zookeeper.session.timeout.ms");
    }

    public int getZookeeperSyncTimeMs() {
        return this.getInt("zookeeper.sync.time.ms");
    }

    public String getMessageParserClass() {
        return this.getString("secor.message.parser.class");
    }

    public int getTopicPartitionForgetSeconds() {
        return this.getInt("secor.topic_partition.forget.seconds");
    }

    public int getLocalLogDeleteAgeHours() {
        return this.getInt("secor.local.log.delete.age.hours");
    }

    public int getOstrichPort() {
        return this.getInt("ostrich.port");
    }

    public String getAwsAccessKey() {
        return this.getString("aws.access.key");
    }

    public String getAwsSecretKey() {
        return this.getString("aws.secret.key");
    }

    public String getQuboleApiToken() {
        return this.getString("qubole.api.token");
    }

    public String getTsdbHostport() {
        return this.getString("tsdb.hostport");
    }

    public String getTsdbBlacklistTopics() {
        return this.getString("tsdb.blacklist.topics");
    }

    public String getMessageTimestampName() {
        return this.getString("message.timestamp.name");
    }

    public String getMessageTimestampInputPattern() {
        return this.getString("message.timestamp.input.pattern");
    }

    public String getCompressionCodec() {
        return this.getString("secor.compression.codec");
    }

    public int getMaxMessageSizeBytes() {
        return this.getInt("secor.max.message.size.bytes");
    }

    public String getFileReaderWriter() {
        return this.getString("secor.file.reader.writer");
    }

    public String getPerfTestTopicPrefix() {
        return this.getString("secor.kafka.perf_topic_prefix");
    }

    private void checkProperty(String name) {
        if (!this.mProperties.containsKey(name)) {
            throw new RuntimeException("Failed to find required configuration option '" + name + "'.");
        }
    }

    private String getString(String name) {
        this.checkProperty(name);
        return this.mProperties.getString(name);
    }

    private int getInt(String name) {
        this.checkProperty(name);
        return this.mProperties.getInt(name);
    }

    private long getLong(String name) {
        return this.mProperties.getLong(name);
    }

    private String[] getStringArray(String name) {
        return this.mProperties.getStringArray(name);
    }
}

