/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.io.impl;

import com.google.common.io.CountingOutputStream;
import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.io.FileReaderWriter;
import com.pinterest.secor.io.KeyValue;
import com.pinterest.secor.util.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;

public class DelimitedTextFileReaderWriter
implements FileReaderWriter {
    private static final byte DELIMITER = 10;
    private final CountingOutputStream mCountingStream;
    private final BufferedOutputStream mWriter;
    private final BufferedInputStream mReader;
    private long mOffset;

    public DelimitedTextFileReaderWriter(LogFilePath path, CompressionCodec codec, FileReaderWriter.Type type) throws FileNotFoundException, IOException {
        Path fsPath = new Path(path.getLogFilePath());
        FileSystem fs = FileUtil.getFileSystem(path.getLogFilePath());
        if (type == FileReaderWriter.Type.Reader) {
            FSDataInputStream inputStream = fs.open(fsPath);
            this.mReader = codec == null ? new BufferedInputStream((InputStream)inputStream) : new BufferedInputStream((InputStream)codec.createInputStream((InputStream)inputStream));
            this.mOffset = path.getOffset();
            this.mCountingStream = null;
            this.mWriter = null;
        } else if (type == FileReaderWriter.Type.Writer) {
            this.mCountingStream = new CountingOutputStream((OutputStream)fs.create(fsPath));
            this.mWriter = codec == null ? new BufferedOutputStream((OutputStream)this.mCountingStream) : new BufferedOutputStream((OutputStream)codec.createOutputStream((OutputStream)this.mCountingStream));
            this.mReader = null;
        } else {
            throw new IllegalArgumentException("Undefined File Type: " + (Object)((Object)type));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWriter != null) {
            this.mWriter.close();
        }
        if (this.mReader != null) {
            this.mReader.close();
        }
    }

    @Override
    public long getLength() throws IOException {
        assert (this.mCountingStream != null);
        return this.mCountingStream.getCount();
    }

    @Override
    public void write(KeyValue keyValue) throws IOException {
        assert (this.mWriter != null);
        this.mWriter.write(keyValue.getValue());
        this.mWriter.write(10);
    }

    @Override
    public KeyValue next() throws IOException {
        int nextByte;
        assert (this.mReader != null);
        ByteArrayOutputStream messageBuffer = new ByteArrayOutputStream();
        while ((nextByte = this.mReader.read()) != 10) {
            if (nextByte == -1) {
                if (messageBuffer.size() == 0) {
                    return null;
                }
                throw new EOFException("Non-empty message without delimiter");
            }
            messageBuffer.write(nextByte);
        }
        return new KeyValue(this.mOffset++, messageBuffer.toByteArray());
    }
}

