/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.io.impl;

import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.io.FileReaderWriter;
import com.pinterest.secor.io.KeyValue;
import com.pinterest.secor.util.FileUtil;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;

public class SequenceFileReaderWriter
implements FileReaderWriter {
    private final SequenceFile.Writer mWriter;
    private final SequenceFile.Reader mReader;
    private final LongWritable mKey;
    private final BytesWritable mValue;

    public SequenceFileReaderWriter(LogFilePath path, CompressionCodec codec, FileReaderWriter.Type type) throws Exception {
        Configuration config = new Configuration();
        Path fsPath = new Path(path.getLogFilePath());
        FileSystem fs = FileUtil.getFileSystem(path.getLogFilePath());
        if (type == FileReaderWriter.Type.Reader) {
            this.mReader = new SequenceFile.Reader(fs, fsPath, config);
            this.mKey = (LongWritable)this.mReader.getKeyClass().newInstance();
            this.mValue = (BytesWritable)this.mReader.getValueClass().newInstance();
            this.mWriter = null;
        } else if (type == FileReaderWriter.Type.Writer) {
            this.mWriter = codec != null ? SequenceFile.createWriter((FileSystem)fs, (Configuration)config, (Path)fsPath, LongWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec) : SequenceFile.createWriter((FileSystem)fs, (Configuration)config, (Path)fsPath, LongWritable.class, BytesWritable.class);
            this.mReader = null;
            this.mKey = null;
            this.mValue = null;
        } else {
            throw new IllegalArgumentException("Undefined File Type: " + (Object)((Object)type));
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mWriter != null) {
            this.mWriter.close();
        }
        if (this.mReader != null) {
            this.mReader.close();
        }
    }

    @Override
    public long getLength() throws IOException {
        return this.mWriter.getLength();
    }

    @Override
    public void write(KeyValue keyValue) throws IOException {
        LongWritable writeableKey = new LongWritable(keyValue.getKey());
        BytesWritable writeableValue = new BytesWritable(keyValue.getValue());
        this.mWriter.append((Writable)writeableKey, (Writable)writeableValue);
    }

    @Override
    public KeyValue next() throws IOException {
        if (this.mReader.next((Writable)this.mKey, (Writable)this.mValue)) {
            return new KeyValue(this.mKey.get(), this.mValue.getBytes());
        }
        return null;
    }
}

