/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.main;

import com.pinterest.secor.tools.TestLogMessageProducer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogMessageProducerMain {
    private static final Logger LOG = LoggerFactory.getLogger(TestLogMessageProducerMain.class);

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"topic");
        OptionBuilder.withDescription((String)"topic to post to");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<topic>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"messages");
        OptionBuilder.withDescription((String)"number of messages per producer to post");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<num_messages>");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"producers");
        OptionBuilder.withDescription((String)"number of producer threads");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<num_producer_threads>");
        OptionBuilder.withType(Number.class);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"type");
        OptionBuilder.withDescription((String)"type of producer - [json, binary]");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"<type>");
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"type"));
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    public static void main(String[] args) {
        try {
            CommandLine commandLine = TestLogMessageProducerMain.parseArgs(args);
            String topic = commandLine.getOptionValue("topic");
            int messages = ((Number)commandLine.getParsedOptionValue("messages")).intValue();
            int producers = ((Number)commandLine.getParsedOptionValue("producers")).intValue();
            String type = commandLine.getOptionValue("type");
            for (int i = 0; i < producers; ++i) {
                TestLogMessageProducer producer = new TestLogMessageProducer(topic, messages, type);
                producer.start();
            }
        }
        catch (Throwable t) {
            LOG.error("Log message producer failed", t);
            System.exit(1);
        }
    }
}

