/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.MessageParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class TimestampedMessageParser
extends MessageParser {
    private static final ThreadLocal<SimpleDateFormat> mFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            format.setTimeZone(TimeZone.getTimeZone("UTC"));
            return format;
        }
    };

    public TimestampedMessageParser(SecorConfig config) {
        super(config);
    }

    public abstract long extractTimestampMillis(Message var1) throws Exception;

    protected static long toMillis(long timestamp) {
        long nanosecondDivider = (long)Math.pow(10.0, 18.0);
        long millisecondDivider = (long)Math.pow(10.0, 12.0);
        long timestampMillis = timestamp / nanosecondDivider > 0L ? timestamp / (long)Math.pow(10.0, 6.0) : (timestamp / millisecondDivider > 0L ? timestamp : timestamp * 1000L);
        return timestampMillis;
    }

    @Override
    public String[] extractPartitions(Message message) throws Exception {
        long timestampMillis = this.extractTimestampMillis(message);
        Date date = new Date(timestampMillis);
        String[] result = new String[]{"dt=" + mFormatter.get().format(date)};
        return result;
    }
}

