/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.io.impl;

import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.io.FileReader;
import com.pinterest.secor.io.FileReaderWriterFactory;
import com.pinterest.secor.io.FileWriter;
import com.pinterest.secor.io.KeyValue;
import com.pinterest.secor.util.FileUtil;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;

public class SequenceFileReaderWriterFactory
implements FileReaderWriterFactory {
    @Override
    public FileReader BuildFileReader(LogFilePath logFilePath, CompressionCodec codec) throws Exception {
        return new SequenceFileReader(logFilePath);
    }

    @Override
    public FileWriter BuildFileWriter(LogFilePath logFilePath, CompressionCodec codec) throws IOException {
        return new SequenceFileWriter(logFilePath, codec);
    }

    protected class SequenceFileWriter
    implements FileWriter {
        private final SequenceFile.Writer mWriter;
        private final LongWritable mKey;
        private final BytesWritable mValue;

        public SequenceFileWriter(LogFilePath path, CompressionCodec codec) throws IOException {
            Configuration config = new Configuration();
            Path fsPath = new Path(path.getLogFilePath());
            FileSystem fs = FileUtil.getFileSystem(path.getLogFilePath());
            this.mWriter = codec != null ? SequenceFile.createWriter((FileSystem)fs, (Configuration)config, (Path)fsPath, LongWritable.class, BytesWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec) : SequenceFile.createWriter((FileSystem)fs, (Configuration)config, (Path)fsPath, LongWritable.class, BytesWritable.class);
            this.mKey = new LongWritable();
            this.mValue = new BytesWritable();
        }

        @Override
        public long getLength() throws IOException {
            return this.mWriter.getLength();
        }

        @Override
        public void write(KeyValue keyValue) throws IOException {
            this.mKey.set(keyValue.getKey());
            this.mValue.set(keyValue.getValue(), 0, keyValue.getValue().length);
            this.mWriter.append((Writable)this.mKey, (Writable)this.mValue);
        }

        @Override
        public void close() throws IOException {
            this.mWriter.close();
        }
    }

    protected class SequenceFileReader
    implements FileReader {
        private final SequenceFile.Reader mReader;
        private final LongWritable mKey;
        private final BytesWritable mValue;

        public SequenceFileReader(LogFilePath path) throws Exception {
            Configuration config = new Configuration();
            Path fsPath = new Path(path.getLogFilePath());
            FileSystem fs = FileUtil.getFileSystem(path.getLogFilePath());
            this.mReader = new SequenceFile.Reader(fs, fsPath, config);
            this.mKey = (LongWritable)this.mReader.getKeyClass().newInstance();
            this.mValue = (BytesWritable)this.mReader.getValueClass().newInstance();
        }

        @Override
        public KeyValue next() throws IOException {
            if (this.mReader.next((Writable)this.mKey, (Writable)this.mValue)) {
                return new KeyValue(this.mKey.get(), Arrays.copyOfRange(this.mValue.getBytes(), 0, this.mValue.getLength()));
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.mReader.close();
        }
    }
}

