/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.MessageParser;
import com.pinterest.secor.parser.Partitioner;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimestampedMessageParser
extends MessageParser
implements Partitioner {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampedMessageParser.class);
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final SimpleDateFormat mDtFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat mHrFormatter = new SimpleDateFormat("HH");
    private static final SimpleDateFormat mDtHrFormatter = new SimpleDateFormat("yyyy-MM-dd-HH");
    private final boolean mUsingHourly;

    public TimestampedMessageParser(SecorConfig config) {
        super(config);
        this.mUsingHourly = TimestampedMessageParser.usingHourly(config);
        LOG.info("UsingHourly: {}", (Object)this.mUsingHourly);
    }

    public abstract long extractTimestampMillis(Message var1) throws Exception;

    static boolean usingHourly(SecorConfig config) {
        return config.getBoolean("partitioner.granularity.hour", false);
    }

    protected static long toMillis(long timestamp) {
        long nanosecondDivider = (long)Math.pow(10.0, 18.0);
        long millisecondDivider = (long)Math.pow(10.0, 12.0);
        long timestampMillis = timestamp / nanosecondDivider > 0L ? timestamp / (long)Math.pow(10.0, 6.0) : (timestamp / millisecondDivider > 0L ? timestamp : timestamp * 1000L);
        return timestampMillis;
    }

    protected String[] generatePartitions(long timestampMillis, boolean usingHourly) throws Exception {
        Date date = new Date(timestampMillis);
        String dt = "dt=" + mDtFormatter.format(date);
        String hr = "hr=" + mHrFormatter.format(date);
        if (usingHourly) {
            return new String[]{dt, hr};
        }
        return new String[]{dt};
    }

    protected long parsePartitions(String[] partitions) throws Exception {
        String dtValue = partitions[0].split("=")[1];
        String hrValue = partitions.length > 1 ? partitions[1].split("=")[1] : "00";
        String value = dtValue + "-" + hrValue;
        Date date = mDtHrFormatter.parse(value);
        return date.getTime();
    }

    @Override
    public String[] extractPartitions(Message message) throws Exception {
        long timestampMillis = this.extractTimestampMillis(message);
        return this.generatePartitions(timestampMillis, this.mUsingHourly);
    }

    private long getFinalizedTimestampMillis(Message lastMessage, Message committedMessage) throws Exception {
        long lastTimestamp = this.extractTimestampMillis(lastMessage);
        long committedTimestamp = this.extractTimestampMillis(committedMessage);
        long now = System.currentTimeMillis();
        if (lastTimestamp == committedTimestamp && now - lastTimestamp > 3600000L) {
            LOG.info("No new message coming, use the current time: " + now);
            return now;
        }
        return committedTimestamp;
    }

    @Override
    public String[] getFinalizedUptoPartitions(List<Message> lastMessages, List<Message> committedMessages) throws Exception {
        if (lastMessages == null || committedMessages == null) {
            LOG.error("Either: {} and {} is null", lastMessages, committedMessages);
            return null;
        }
        assert (lastMessages.size() == committedMessages.size());
        long minMillis = Long.MAX_VALUE;
        for (int i = 0; i < lastMessages.size(); ++i) {
            long millis = this.getFinalizedTimestampMillis(lastMessages.get(i), committedMessages.get(i));
            if (millis >= minMillis) continue;
            minMillis = millis;
        }
        if (minMillis == Long.MAX_VALUE) {
            LOG.error("No valid timestamps among messages: {} and {}", lastMessages, committedMessages);
            return null;
        }
        LOG.info("adjusted millis {}", (Object)(minMillis -= 3600000L));
        return this.generatePartitions(minMillis, this.mUsingHourly);
    }

    @Override
    public String[] getPreviousPartitions(String[] partitions) throws Exception {
        long millis = this.parsePartitions(partitions);
        boolean usingHourly = this.mUsingHourly;
        if (this.mUsingHourly && millis % 86400000L == 0L) {
            if (partitions.length == 2) {
                usingHourly = false;
                millis -= 86400000L;
            } else {
                usingHourly = true;
                millis += 86400000L;
                millis -= 3600000L;
            }
        } else {
            long delta = this.mUsingHourly ? 3600000L : 86400000L;
            millis -= delta;
        }
        return this.generatePartitions(millis, usingHourly);
    }

    static {
        mDtFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        mHrFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        mDtHrFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

