/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.uploader;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.Upload;
import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.uploader.Handle;
import com.pinterest.secor.uploader.S3UploadHandle;
import com.pinterest.secor.uploader.UploadManager;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3UploadManager
extends UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3UploadManager.class);
    private TransferManager mManager;

    public S3UploadManager(SecorConfig config) {
        super(config);
        String accessKey = this.mConfig.getAwsAccessKey();
        String secretKey = this.mConfig.getAwsSecretKey();
        String endpoint = this.mConfig.getAwsEndpoint();
        String region = this.mConfig.getAwsRegion();
        AmazonS3Client client = accessKey.isEmpty() || secretKey.isEmpty() ? new AmazonS3Client() : new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
        if (!endpoint.isEmpty()) {
            client.setEndpoint(endpoint);
        } else if (!region.isEmpty()) {
            client.setRegion(Region.getRegion((Regions)Regions.fromName((String)region)));
        }
        this.mManager = new TransferManager((AmazonS3)client);
    }

    @Override
    public Handle<?> upload(LogFilePath localPath) throws Exception {
        String s3Bucket = this.mConfig.getS3Bucket();
        String s3Key = localPath.withPrefix(this.mConfig.getS3Path()).getLogFilePath();
        File localFile = new File(localPath.getLogFilePath());
        LOG.info("uploading file {} to s3://{}/{}", new Object[]{localFile, s3Bucket, s3Key});
        Upload upload = this.mManager.upload(s3Bucket, s3Key, localFile);
        return new S3UploadHandle(upload);
    }
}

