/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.util;

import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.io.FileReader;
import com.pinterest.secor.io.FileReaderWriterFactory;
import com.pinterest.secor.io.FileWriter;
import com.pinterest.secor.parser.MessageParser;
import com.pinterest.secor.uploader.UploadManager;
import org.apache.hadoop.io.compress.CompressionCodec;

public class ReflectionUtil {
    public static UploadManager createUploadManager(String className, SecorConfig config) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (!UploadManager.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("The class '%s' is not assignable to '%s'.", className, UploadManager.class.getName()));
        }
        return (UploadManager)clazz.getConstructor(SecorConfig.class).newInstance(config);
    }

    public static MessageParser createMessageParser(String className, SecorConfig config) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (!MessageParser.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("The class '%s' is not assignable to '%s'.", className, MessageParser.class.getName()));
        }
        return (MessageParser)clazz.getConstructor(SecorConfig.class).newInstance(config);
    }

    private static FileReaderWriterFactory createFileReaderWriterFactory(String className) throws Exception {
        Class<?> clazz = Class.forName(className);
        if (!FileReaderWriterFactory.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format("The class '%s' is not assignable to '%s'.", className, FileReaderWriterFactory.class.getName()));
        }
        return (FileReaderWriterFactory)clazz.newInstance();
    }

    public static FileWriter createFileWriter(String className, LogFilePath logFilePath, CompressionCodec codec) throws Exception {
        return ReflectionUtil.createFileReaderWriterFactory(className).BuildFileWriter(logFilePath, codec);
    }

    public static FileReader createFileReader(String className, LogFilePath logFilePath, CompressionCodec codec) throws Exception {
        return ReflectionUtil.createFileReaderWriterFactory(className).BuildFileReader(logFilePath, codec);
    }
}

