/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import com.pinterest.secor.message.ParsedMessage;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class LogFilePath {
    private final String mPrefix;
    private final String mTopic;
    private final String[] mPartitions;
    private final int mGeneration;
    private final int mKafkaPartition;
    private final long mOffset;
    private final String mExtension;

    public LogFilePath(String prefix, int generation, long lastCommittedOffset, ParsedMessage message, String extension) {
        this.mPrefix = prefix;
        this.mTopic = message.getTopic();
        this.mPartitions = message.getPartitions();
        this.mGeneration = generation;
        this.mKafkaPartition = message.getKafkaPartition();
        this.mOffset = lastCommittedOffset;
        this.mExtension = extension;
    }

    public LogFilePath(String prefix, String topic, String[] partitions, int generation, int kafkaPartition, long offset, String extension) {
        this.mPrefix = prefix;
        this.mTopic = topic;
        this.mPartitions = partitions;
        this.mGeneration = generation;
        this.mKafkaPartition = kafkaPartition;
        this.mOffset = offset;
        this.mExtension = extension;
    }

    private static String[] subArray(String[] array, int startIndex, int endIndex) {
        String[] result = new String[endIndex - startIndex + 1];
        for (int i = startIndex; i <= endIndex; ++i) {
            result[i - startIndex] = array[i];
        }
        return result;
    }

    public LogFilePath(String prefix, String path) {
        assert (path.startsWith(prefix)) : path + ".startsWith(" + prefix + ")";
        this.mPrefix = prefix;
        int prefixLength = prefix.length();
        if (!prefix.endsWith("/")) {
            ++prefixLength;
        }
        String suffix = path.substring(prefixLength);
        Object[] pathElements = suffix.split("/");
        assert (pathElements.length >= 3) : Arrays.toString(pathElements) + ".length >= 3";
        this.mTopic = pathElements[0];
        this.mPartitions = LogFilePath.subArray((String[])pathElements, 1, pathElements.length - 2);
        Object basename = pathElements[pathElements.length - 1];
        int lastIndexOf = ((String)basename).lastIndexOf(46);
        if (lastIndexOf >= 0) {
            this.mExtension = ((String)basename).substring(lastIndexOf, ((String)basename).length());
            basename = ((String)basename).substring(0, lastIndexOf);
        } else {
            this.mExtension = "";
        }
        String[] basenameElements = ((String)basename).split("_");
        assert (basenameElements.length == 3) : Integer.toString(basenameElements.length) + " == 3";
        this.mGeneration = Integer.parseInt(basenameElements[0]);
        this.mKafkaPartition = Integer.parseInt(basenameElements[1]);
        this.mOffset = Long.parseLong(basenameElements[2]);
    }

    public LogFilePath withPrefix(String prefix) {
        return new LogFilePath(prefix, this.mTopic, this.mPartitions, this.mGeneration, this.mKafkaPartition, this.mOffset, this.mExtension);
    }

    public String getLogFileParentDir() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(this.mPrefix);
        elements.add(this.mTopic);
        return StringUtils.join(elements, (String)"/");
    }

    public String getLogFileDir() {
        ArrayList<String> elements = new ArrayList<String>();
        elements.add(this.getLogFileParentDir());
        for (String partition : this.mPartitions) {
            elements.add(partition);
        }
        return StringUtils.join(elements, (String)"/");
    }

    private String getLogFileBasename() {
        ArrayList<String> basenameElements = new ArrayList<String>();
        basenameElements.add(Integer.toString(this.mGeneration));
        basenameElements.add(Integer.toString(this.mKafkaPartition));
        basenameElements.add(String.format("%020d", this.mOffset));
        return StringUtils.join(basenameElements, (String)"_");
    }

    public String getLogFilePath() {
        String basename = this.getLogFileBasename();
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add(this.getLogFileDir());
        pathElements.add(basename);
        return StringUtils.join(pathElements, (String)"/") + this.mExtension;
    }

    public String getLogFileCrcPath() {
        String basename = "." + this.getLogFileBasename() + ".crc";
        ArrayList<String> pathElements = new ArrayList<String>();
        pathElements.add(this.getLogFileDir());
        pathElements.add(basename);
        return StringUtils.join(pathElements, (String)"/");
    }

    public String getTopic() {
        return this.mTopic;
    }

    public String[] getPartitions() {
        return this.mPartitions;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public int getKafkaPartition() {
        return this.mKafkaPartition;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public String getExtension() {
        return this.mExtension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogFilePath that = (LogFilePath)o;
        if (this.mGeneration != that.mGeneration) {
            return false;
        }
        if (this.mKafkaPartition != that.mKafkaPartition) {
            return false;
        }
        if (this.mOffset != that.mOffset) {
            return false;
        }
        if (!Arrays.equals(this.mPartitions, that.mPartitions)) {
            return false;
        }
        if (this.mPrefix != null ? !this.mPrefix.equals(that.mPrefix) : that.mPrefix != null) {
            return false;
        }
        return !(this.mTopic != null ? !this.mTopic.equals(that.mTopic) : that.mTopic != null);
    }

    public int hashCode() {
        int result = this.mPrefix != null ? this.mPrefix.hashCode() : 0;
        result = 31 * result + (this.mTopic != null ? this.mTopic.hashCode() : 0);
        result = 31 * result + (this.mPartitions != null ? Arrays.hashCode(this.mPartitions) : 0);
        result = 31 * result + this.mGeneration;
        result = 31 * result + this.mKafkaPartition;
        result = 31 * result + (int)(this.mOffset ^ this.mOffset >>> 32);
        return result;
    }

    public String toString() {
        return this.getLogFilePath();
    }
}

