/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.uploader;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.pinterest.secor.common.LogFilePath;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.uploader.FutureHandle;
import com.pinterest.secor.uploader.Handle;
import com.pinterest.secor.uploader.UploadManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsUploadManager
extends UploadManager {
    private static final Logger LOG = LoggerFactory.getLogger(GsUploadManager.class);
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final ExecutorService executor = Executors.newFixedThreadPool(256);
    private static Storage mStorageService;
    private Storage mClient;

    public GsUploadManager(SecorConfig config) throws Exception {
        super(config);
        this.mClient = GsUploadManager.getService(this.mConfig.getGsCredentialsPath(), this.mConfig.getGsConnectTimeoutInMs(), this.mConfig.getGsReadTimeoutInMs());
    }

    @Override
    public Handle<?> upload(LogFilePath localPath) throws Exception {
        final String gsBucket = this.mConfig.getGsBucket();
        final String gsKey = localPath.withPrefix(this.mConfig.getGsPath()).getLogFilePath();
        final File localFile = new File(localPath.getLogFilePath());
        LOG.info("uploading file {} to gs://{}/{}", new Object[]{localFile, gsBucket, gsKey});
        final StorageObject storageObject = new StorageObject().setName(gsKey);
        final FileContent storageContent = new FileContent(Files.probeContentType(localFile.toPath()), localFile);
        Future<?> f = executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Storage.Objects.Insert request = GsUploadManager.this.mClient.objects().insert(gsBucket, storageObject, (AbstractInputStreamContent)storageContent);
                    request.getMediaHttpUploader().setProgressListener(new MediaHttpUploaderProgressListener(){

                        public void progressChanged(MediaHttpUploader uploader) throws IOException {
                            LOG.debug("[{} %] upload file {} to gs://{}/{}", new Object[]{(int)uploader.getProgress() * 100, localFile, gsBucket, gsKey});
                        }
                    });
                    request.execute();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return new FutureHandle(f);
    }

    private static Storage getService(String credentialsPath, int connectTimeoutMs, int readTimeoutMs) throws Exception {
        if (mStorageService == null) {
            GoogleCredential credential;
            NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
            try {
                credential = credentialsPath != null ? GoogleCredential.fromStream((InputStream)new FileInputStream(credentialsPath), (HttpTransport)httpTransport, (JsonFactory)JSON_FACTORY).createScoped(Collections.singleton("https://www.googleapis.com/auth/cloud-platform")) : GoogleCredential.getApplicationDefault((HttpTransport)httpTransport, (JsonFactory)JSON_FACTORY);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load Google credentials : " + credentialsPath, e);
            }
            mStorageService = new Storage.Builder((HttpTransport)httpTransport, JSON_FACTORY, GsUploadManager.setHttpBackoffTimeout((HttpRequestInitializer)credential, connectTimeoutMs, readTimeoutMs)).setApplicationName("com.pinterest.secor").build();
        }
        return mStorageService;
    }

    private static HttpRequestInitializer setHttpBackoffTimeout(final HttpRequestInitializer requestInitializer, final int connectTimeoutMs, final int readTimeoutMs) {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                requestInitializer.initialize(httpRequest);
                ExponentialBackOff backoff = new ExponentialBackOff();
                HttpBackOffUnsuccessfulResponseHandler backoffHandler = new HttpBackOffUnsuccessfulResponseHandler((BackOff)backoff).setBackOffRequired(HttpBackOffUnsuccessfulResponseHandler.BackOffRequired.ALWAYS);
                httpRequest.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)backoffHandler);
                httpRequest.setConnectTimeout(connectTimeoutMs);
                httpRequest.setReadTimeout(readTimeoutMs);
            }
        };
    }
}

