/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.DateMessageParser;
import com.pinterest.secor.parser.MessageParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Iso8601MessageParser
extends MessageParser {
    private static final Logger LOG = LoggerFactory.getLogger(DateMessageParser.class);
    protected static final String defaultDate = "dt=1970-01-01";
    protected static final String defaultFormatter = "yyyy-MM-dd";
    protected static final SimpleDateFormat outputFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public Iso8601MessageParser(SecorConfig config) {
        super(config);
        outputFormatter.setTimeZone(config.getTimeZone());
    }

    @Override
    public String[] extractPartitions(Message message) throws Exception {
        JSONObject jsonObject = (JSONObject)JSONValue.parse((byte[])message.getPayload());
        String[] result = new String[]{defaultDate};
        if (jsonObject != null) {
            Object fieldValue = this.getJsonFieldValue(jsonObject);
            if (fieldValue == null) {
                LOG.warn("Missing field value. Using default partition = {}", (Object)defaultDate);
            } else {
                try {
                    Date dateFormat = DatatypeConverter.parseDateTime((String)fieldValue.toString()).getTime();
                    result[0] = "dt=" + outputFormatter.format(dateFormat);
                }
                catch (Exception e) {
                    LOG.warn("Impossible to convert date = {} as ISO-8601. Using date default = {}", (Object)fieldValue.toString(), (Object)result[0]);
                }
            }
        }
        return result;
    }
}

