/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.TimestampedMessageParser;
import java.util.HashMap;
import org.msgpack.jackson.dataformat.MessagePackFactory;

public class MessagePackParser
extends TimestampedMessageParser {
    private ObjectMapper mMessagePackObjectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());
    private TypeReference mTypeReference = new TypeReference<HashMap<String, Object>>(){};

    public MessagePackParser(SecorConfig config) {
        super(config);
    }

    @Override
    public long extractTimestampMillis(Message message) throws Exception {
        HashMap msgHash = (HashMap)this.mMessagePackObjectMapper.readValue(message.getPayload(), this.mTypeReference);
        Object timestampValue = msgHash.get(this.mConfig.getMessageTimestampName());
        if (timestampValue instanceof Number) {
            return MessagePackParser.toMillis(((Number)timestampValue).longValue());
        }
        if (timestampValue instanceof String) {
            return MessagePackParser.toMillis(Long.parseLong((String)timestampValue));
        }
        return MessagePackParser.toMillis((Long)timestampValue);
    }
}

