/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.tools;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.util.FileUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFileDeleter {
    private static final Logger LOG = LoggerFactory.getLogger(LogFileDeleter.class);
    private SecorConfig mConfig;

    public LogFileDeleter(SecorConfig config) throws IOException {
        this.mConfig = config;
    }

    public void deleteOldLogs() throws Exception {
        if (this.mConfig.getLocalLogDeleteAgeHours() <= 0) {
            return;
        }
        String[] consumerDirs = FileUtil.list(this.mConfig.getLocalPath());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        format.setTimeZone(this.mConfig.getTimeZone());
        for (String consumerDir : consumerDirs) {
            long modificationTime = FileUtil.getModificationTimeMsRecursive(consumerDir);
            String modificationTimeStr = format.format(modificationTime);
            LOG.info("Consumer log dir {} last modified at {}", (Object)consumerDir, (Object)modificationTimeStr);
            long localLogDeleteAgeMs = (long)this.mConfig.getLocalLogDeleteAgeHours() * 60L * 60L * 1000L;
            if (System.currentTimeMillis() - modificationTime <= localLogDeleteAgeMs) continue;
            LOG.info("Deleting directory {} last modified at {}", (Object)consumerDir, (Object)modificationTimeStr);
            FileUtil.delete(consumerDir);
        }
    }
}

