/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.common;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

public class SecorConfig {
    private final PropertiesConfiguration mProperties;
    private static final ThreadLocal<SecorConfig> mSecorConfig = new ThreadLocal<SecorConfig>(){

        @Override
        protected SecorConfig initialValue() {
            PropertiesConfiguration properties;
            Properties systemProperties = System.getProperties();
            String configProperty = systemProperties.getProperty("config");
            try {
                properties = new PropertiesConfiguration(configProperty);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException("Error loading configuration from " + configProperty);
            }
            for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
                properties.setProperty(entry.getKey().toString(), entry.getValue());
            }
            return new SecorConfig(properties);
        }
    };

    public static SecorConfig load() throws ConfigurationException {
        return mSecorConfig.get();
    }

    public SecorConfig(PropertiesConfiguration properties) {
        this.mProperties = properties;
    }

    public String getKafkaSeedBrokerHost() {
        return this.getString("kafka.seed.broker.host");
    }

    public int getKafkaSeedBrokerPort() {
        return this.getInt("kafka.seed.broker.port");
    }

    public String getKafkaZookeeperPath() {
        return this.getString("kafka.zookeeper.path");
    }

    public String getZookeeperQuorum() {
        return StringUtils.join((Object[])this.getStringArray("zookeeper.quorum"), (char)',');
    }

    public int getConsumerTimeoutMs() {
        return this.getInt("kafka.consumer.timeout.ms");
    }

    public String getPartitionAssignmentStrategy() {
        return this.getString("kafka.partition.assignment.strategy");
    }

    public String getRebalanceMaxRetries() {
        return this.getString("kafka.rebalance.max.retries");
    }

    public String getRebalanceBackoffMs() {
        return this.getString("kafka.rebalance.backoff.ms");
    }

    public String getFetchMessageMaxBytes() {
        return this.getString("kafka.fetch.message.max.bytes");
    }

    public String getSocketReceiveBufferBytes() {
        return this.getString("kafka.socket.receive.buffer.bytes");
    }

    public String getFetchMinBytes() {
        return this.getString("kafka.fetch.min.bytes");
    }

    public String getFetchWaitMaxMs() {
        return this.getString("kafka.fetch.wait.max.ms");
    }

    public String getDualCommitEnabled() {
        return this.getString("kafka.dual.commit.enabled");
    }

    public String getOffsetsStorage() {
        return this.getString("kafka.offsets.storage");
    }

    public int getGeneration() {
        return this.getInt("secor.generation");
    }

    public int getConsumerThreads() {
        return this.getInt("secor.consumer.threads");
    }

    public long getMaxFileSizeBytes() {
        return this.getLong("secor.max.file.size.bytes");
    }

    public long getMaxFileAgeSeconds() {
        return this.getLong("secor.max.file.age.seconds");
    }

    public long getOffsetsPerPartition() {
        return this.getLong("secor.offsets.per.partition");
    }

    public int getMessagesPerSecond() {
        return this.getInt("secor.messages.per.second");
    }

    public String getS3FileSystem() {
        return this.getString("secor.s3.filesystem");
    }

    public boolean getSeparateContainersForTopics() {
        return this.getString("secor.swift.containers.for.each.topic").toLowerCase().equals("true");
    }

    public String getSwiftContainer() {
        return this.getString("secor.swift.container");
    }

    public String getSwiftPath() {
        return this.getString("secor.swift.path");
    }

    public String getS3Bucket() {
        return this.getString("secor.s3.bucket");
    }

    public String getS3Path() {
        return this.getString("secor.s3.path");
    }

    public String getS3AlternativePath() {
        return this.getString("secor.s3.alternative.path");
    }

    public String getS3AlterPathDate() {
        return this.getString("secor.s3.alter.path.date");
    }

    public String getS3Prefix() {
        return this.getS3FileSystem() + "://" + this.getS3Bucket() + "/" + this.getS3Path();
    }

    public String getLocalPath() {
        return this.getString("secor.local.path");
    }

    public String getKafkaTopicFilter() {
        return this.getString("secor.kafka.topic_filter");
    }

    public String getKafkaTopicBlacklist() {
        return this.getString("secor.kafka.topic_blacklist");
    }

    public String getKafkaTopicUploadAtMinuteMarkFilter() {
        return this.getString("secor.kafka.upload_at_minute_mark.topic_filter");
    }

    public int getUploadMinuteMark() {
        return this.getInt("secor.upload.minute_mark");
    }

    public String getKafkaGroup() {
        return this.getString("secor.kafka.group");
    }

    public int getZookeeperSessionTimeoutMs() {
        return this.getInt("zookeeper.session.timeout.ms");
    }

    public int getZookeeperSyncTimeMs() {
        return this.getInt("zookeeper.sync.time.ms");
    }

    public String getMessageParserClass() {
        return this.getString("secor.message.parser.class");
    }

    public String getUploaderClass() {
        return this.getString("secor.upload.class", "com.pinterest.secor.uploader.Uploader");
    }

    public String getUploadManagerClass() {
        return this.getString("secor.upload.manager.class");
    }

    public String getMessageTransformerClass() {
        return this.getString("secor.message.transformer.class");
    }

    public int getTopicPartitionForgetSeconds() {
        return this.getInt("secor.topic_partition.forget.seconds");
    }

    public int getLocalLogDeleteAgeHours() {
        return this.getInt("secor.local.log.delete.age.hours");
    }

    public String getFileExtension() {
        return this.getString("secor.file.extension");
    }

    public int getOstrichPort() {
        return this.getInt("ostrich.port");
    }

    public String getCloudService() {
        return this.getString("cloud.service");
    }

    public String getAwsAccessKey() {
        return this.getString("aws.access.key");
    }

    public String getAwsSecretKey() {
        return this.getString("aws.secret.key");
    }

    public String getAwsEndpoint() {
        return this.getString("aws.endpoint");
    }

    public String getAwsRole() {
        return this.getString("aws.role");
    }

    public boolean getAwsProxyEnabled() {
        return this.getBoolean("aws.proxy.isEnabled");
    }

    public String getAwsProxyHttpHost() {
        return this.getString("aws.proxy.http.host");
    }

    public int getAwsProxyHttpPort() {
        return this.getInt("aws.proxy.http.port");
    }

    public String getAwsRegion() {
        return this.getString("aws.region");
    }

    public String getAwsSseType() {
        return this.getString("aws.sse.type");
    }

    public String getAwsSseKmsKey() {
        return this.getString("aws.sse.kms.key");
    }

    public String getAwsSseCustomerKey() {
        return this.getString("aws.sse.customer.key");
    }

    public String getSwiftTenant() {
        return this.getString("swift.tenant");
    }

    public String getSwiftUsername() {
        return this.getString("swift.username");
    }

    public String getSwiftPassword() {
        return this.getString("swift.password");
    }

    public String getSwiftAuthUrl() {
        return this.getString("swift.auth.url");
    }

    public String getSwiftPublic() {
        return this.getString("swift.public");
    }

    public String getSwiftPort() {
        return this.getString("swift.port");
    }

    public String getSwiftGetAuth() {
        return this.getString("swift.use.get.auth");
    }

    public String getSwiftApiKey() {
        return this.getString("swift.api.key");
    }

    public String getQuboleApiToken() {
        return this.getString("qubole.api.token");
    }

    public String getTsdbHostport() {
        return this.getString("tsdb.hostport");
    }

    public String getStatsDHostPort() {
        return this.getString("statsd.hostport");
    }

    public String getMonitoringBlacklistTopics() {
        return this.getString("monitoring.blacklist.topics");
    }

    public String getMonitoringPrefix() {
        return this.getString("monitoring.prefix");
    }

    public String getMessageTimestampName() {
        return this.getString("message.timestamp.name");
    }

    public String getMessageTimestampNameSeparator() {
        return this.getString("message.timestamp.name.separator");
    }

    public int getMessageTimestampId() {
        return this.getInt("message.timestamp.id");
    }

    public String getMessageTimestampType() {
        return this.getString("message.timestamp.type");
    }

    public String getMessageTimestampInputPattern() {
        return this.getString("message.timestamp.input.pattern");
    }

    public boolean isMessageTimestampRequired() {
        return this.mProperties.getBoolean("message.timestamp.required");
    }

    public int getFinalizerLookbackPeriods() {
        return this.getInt("secor.finalizer.lookback.periods", 10);
    }

    public String getHivePrefix() {
        return this.getString("secor.hive.prefix");
    }

    public String getHiveTableName(String topic) {
        String key = "secor.hive.table.name." + topic;
        return this.mProperties.getString(key, null);
    }

    public String getCompressionCodec() {
        return this.getString("secor.compression.codec");
    }

    public int getMaxMessageSizeBytes() {
        return this.getInt("secor.max.message.size.bytes");
    }

    public String getFileReaderWriterFactory() {
        return this.getString("secor.file.reader.writer.factory");
    }

    public String getPerfTestTopicPrefix() {
        return this.getString("secor.kafka.perf_topic_prefix");
    }

    public String getZookeeperPath() {
        return this.getString("secor.zookeeper.path");
    }

    public String getGsCredentialsPath() {
        return this.getString("secor.gs.credentials.path");
    }

    public String getGsBucket() {
        return this.getString("secor.gs.bucket");
    }

    public String getGsPath() {
        return this.getString("secor.gs.path");
    }

    public int getGsConnectTimeoutInMs() {
        return this.getInt("secor.gs.connect.timeout.ms", 180000);
    }

    public int getGsReadTimeoutInMs() {
        return this.getInt("secor.gs.read.timeout.ms", 180000);
    }

    public boolean getGsDirectUpload() {
        return this.getBoolean("secor.gs.upload.direct");
    }

    public int getFinalizerDelaySeconds() {
        return this.getInt("partitioner.finalizer.delay.seconds");
    }

    public boolean getS3MD5HashPrefix() {
        return this.getBoolean("secor.s3.prefix.md5hash");
    }

    public String getAzureEndpointsProtocol() {
        return this.getString("secor.azure.endpoints.protocol");
    }

    public String getAzureAccountName() {
        return this.getString("secor.azure.account.name");
    }

    public String getAzureAccountKey() {
        return this.getString("secor.azure.account.key");
    }

    public String getAzureContainer() {
        return this.getString("secor.azure.container.name");
    }

    public String getAzurePath() {
        return this.getString("secor.azure.path");
    }

    public String getAzureSASKey() {
        return this.getString("secor.azure.sas.key");
    }

    public String getAzureBaseURI() {
        return this.getString("secor.azure.base.uri");
    }

    public String getHadoopConfPath() {
        return this.getString("hadoop.conf.path", "");
    }

    public Map<String, String> getProtobufMessageClassPerTopic() {
        String prefix = "secor.protobuf.message.class";
        Iterator keys = this.mProperties.getKeys(prefix);
        HashMap<String, String> protobufClasses = new HashMap<String, String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String className = this.mProperties.getString(key);
            protobufClasses.put(key.substring(prefix.length() + 1), className);
        }
        return protobufClasses;
    }

    public TimeZone getTimeZone() {
        String timezone = this.getString("secor.parser.timezone");
        return Strings.isNullOrEmpty((String)timezone) ? TimeZone.getTimeZone("UTC") : TimeZone.getTimeZone(timezone);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return this.mProperties.getBoolean(name, defaultValue);
    }

    public boolean getBoolean(String name) {
        return this.mProperties.getBoolean(name);
    }

    public void checkProperty(String name) {
        if (!this.mProperties.containsKey(name)) {
            throw new RuntimeException("Failed to find required configuration option '" + name + "'.");
        }
    }

    public String getString(String name) {
        this.checkProperty(name);
        return this.mProperties.getString(name);
    }

    public String getString(String name, String defaultValue) {
        return this.mProperties.getString(name, defaultValue);
    }

    public int getInt(String name) {
        this.checkProperty(name);
        return this.mProperties.getInt(name);
    }

    public int getInt(String name, int defaultValue) {
        return this.mProperties.getInt(name, defaultValue);
    }

    public long getLong(String name) {
        return this.mProperties.getLong(name);
    }

    public String[] getStringArray(String name) {
        return this.mProperties.getStringArray(name);
    }
}

