/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.secor.parser;

import com.pinterest.secor.common.SecorConfig;
import com.pinterest.secor.message.Message;
import com.pinterest.secor.parser.TimestampedMessageParser;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;

public class ThriftMessageParser
extends TimestampedMessageParser {
    private final TDeserializer mDeserializer = new TDeserializer();
    private final ThriftPath mThriftPath = new ThriftPath(this.mConfig.getMessageTimestampName(), (short)this.mConfig.getMessageTimestampId());
    private final String mTimestampType = this.mConfig.getMessageTimestampType();

    public ThriftMessageParser(SecorConfig config) {
        super(config);
    }

    @Override
    public long extractTimestampMillis(Message message) throws TException {
        long timestamp = "i32".equals(this.mTimestampType) ? (long)this.mDeserializer.partialDeserializeI32(message.getPayload(), (TFieldIdEnum)this.mThriftPath, new TFieldIdEnum[0]).intValue() : this.mDeserializer.partialDeserializeI64(message.getPayload(), (TFieldIdEnum)this.mThriftPath, new TFieldIdEnum[0]);
        return ThriftMessageParser.toMillis(timestamp);
    }

    class ThriftPath
    implements TFieldIdEnum {
        private final String mFieldName;
        private final short mFieldId;

        public ThriftPath(String fieldName, short fieldId) {
            this.mFieldName = fieldName;
            this.mFieldId = fieldId;
        }

        public short getThriftFieldId() {
            return this.mFieldId;
        }

        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

