(ns spongeblob.util)


(defn process-map
  [m & {:keys [key-fn val-fn]
        :or {key-fn identity
             val-fn identity}}]
  (reduce-kv (fn [ret k v]
               (assoc ret (key-fn k) (val-fn v)))
             (empty m)
             m))

(defn acl
  "Given a map with metadata map {:acl ...}, extract the value."
  [m]
  (-> m meta :acl))
