(ns spongeblob.util)


(defn process-map
  [m & {:keys [key-fn val-fn]
        :or {key-fn identity
             val-fn identity}}]
  (reduce-kv (fn [ret k v]
               (assoc ret (key-fn k) (val-fn v)))
             (empty m)
             m))


(defn set-meta
  "Converts given map to namespace level meta property map for spongeblob.core
   and set as meta for user-meta."
  [user-meta opts]
  (when-let [ns-meta (reduce-kv (fn [pm k v]
                                  (assoc pm
                                         (keyword "spongeblob.core" (name k)) v))
                                {}
                                opts)]
    (with-meta (or user-meta {}) ns-meta)))


(defn- fetch-meta
  "Given a map with metadata map, extract the value for given key."
  [m k]
  (-> m meta k))


(defn acl
  "Given a map with metadata map {:acl ...}, extract the value."
  [m]
  (fetch-meta m :spongeblob.core/acl))


(defn encryption
  "Given a map with metadata map, extract the value for :spongeblob.core/encryption."
  [m]
  (fetch-meta m :spongeblob.core/encryption))


(defn set-default-acl?
  "Given a map with metadata map, extract the value for :spongeblob.core/set-default-acl"
  [m]
  (fetch-meta m :spongeblob.core/set-default-acl?))


(defn starts-with?
  "True if s starts with substr. This is backported from `clojure.string` for
   version compatibility reasons."
  [^CharSequence s ^String substr]
  (.startsWith (.toString s) substr))
