(ns spongeblob.protocols
  (:refer-clojure :exclude [get]))

(defprotocol BlobStore
  (put [this key meta bytes] "Put bytes into storage under key with meta.")
  (get [this key] "Retrieve blob from storage.")
  (url [this key] "Return the storage URL for a given blob.")
  (cdn-url [this key] "Return the CDN URL for a given blob.")
  (exists? [this key] "Check if a key exists or not.")
  (get-metadata [this key] "Fetches the metadata for a given blob."))
