(ns heroku.datum
 (:use
   [clojure.string :as string :only [join split]]
   [clj-time.format :as tformat]
   [clj-time.coerce :as tcoerce]))

(defonce data-format "[user_data]{%s}\n")
(defonce data-pattern #"(\d\d\d\d-\d\d-\d\dT\d\d:\d\d:\d\d[\-\+]\d\d:00) .*\[user_data\]\{(.+)\}")

(defn- map-to-string [m]
  (string/join
    (drop-last
      (reduce
        #(str %1 (name (first %2)) ":" (second %2) ",")
        ""
        m))))

(defn- string-to-map [s]
  (if-let [matches (rest (re-matches data-pattern s))]
    (let [t (tformat/parse (tformat/formatter "yyyy-MM-dd'T'HH:mm:ssZ") (first matches)) data (second matches)]
      (reduce
        conj
        {}
        (map
          #(let [kv (split %1 #":")] [(first kv) {:time (tcoerce/to-long t) :value (second kv)}])
          (split data #","))))
    ""))

(defn write-map [m stream]
  (binding [*out* stream]
    (printf data-format (map-to-string m))
    (flush)))

(defn read-map [s]
  (string-to-map s))
