(ns heroku.datum
 (:use
   [clojure.string :as string :only [join split]]))

(defonce data-format "[user_data]{%s}\n")
(defonce data-pattern (re-pattern ".*\\[user_data\\]\\{(.+)\\}"))

(defn- map-to-string [m]
  (string/join 
    (drop-last 
      (reduce
        #(str %1 (name (first %2)) ":" (second %2) ",")
        ""
        m))))

(defn- string-to-map [s]
  (if-let [matches (re-matches data-pattern s)]
    (let [data (second matches)]
      (reduce 
        conj
        {}
        (map
          #(split %1 #":")
          (split data #","))))
    ""))

(defn write-map [m stream]
  (binding [*out* stream] 
    (printf data-format (map-to-string m))
    (flush)))

(defn read-map [s]
  (string-to-map s))