/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;

public class ImportKey {
    private static InputStream fullStream(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        byte[] byArray = new byte[dataInputStream.available()];
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public static void main(String[] stringArray) {
        String string = "importkey";
        String string2 = "importkey";
        String string3 = System.getProperty("keystore");
        if (string3 == null) {
            string3 = System.getProperty("user.home") + System.getProperty("file.separator") + "keystore.ImportKey";
        }
        String string4 = "";
        String string5 = "";
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("Usage: java comu.ImportKey keyfile certfile [alias]");
            System.exit(0);
        } else {
            string4 = stringArray[0];
            string5 = stringArray[1];
            if (stringArray.length > 2) {
                string2 = stringArray[2];
            }
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
            keyStore.load(null, string.toCharArray());
            System.out.println("Using keystore-file : " + string3);
            keyStore.store(new FileOutputStream(string3), string.toCharArray());
            keyStore.load(new FileInputStream(string3), string.toCharArray());
            InputStream inputStream = ImportKey.fullStream(string4);
            byte[] byArray = new byte[inputStream.available()];
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            inputStream.read(byArray, 0, inputStream.available());
            inputStream.close();
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            PrivateKey privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            InputStream inputStream2 = ImportKey.fullStream(string5);
            Collection<? extends Certificate> collection = certificateFactory.generateCertificates(inputStream2);
            Certificate[] certificateArray = new Certificate[collection.toArray().length];
            if (collection.size() == 1) {
                Certificate certificate;
                inputStream2 = ImportKey.fullStream(string5);
                System.out.println("One certificate, no chain.");
                certificateArray[0] = certificate = certificateFactory.generateCertificate(inputStream2);
            } else {
                System.out.println("Certificate chain length: " + collection.size());
                certificateArray = (Certificate[])collection.toArray();
            }
            keyStore.setKeyEntry(string2, privateKey, string.toCharArray(), certificateArray);
            System.out.println("Key and certificate stored.");
            System.out.println("Alias:" + string2 + "  Password:" + string);
            keyStore.store(new FileOutputStream(string3), string.toCharArray());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

