(ns herolabs.apns.scrapbook
  (:use [clojure.tools.logging]
        [herolabs.apns.ssl :only (keystore ssl-context naive-trust-managers)]
        [herolabs.apns.push :only (dev-address create-connection send-to future-listener)]
        [herolabs.apns.feedback :only (feedback)]
        [herolabs.apns.feedback :rename {dev-address feedback-dev-address}]))

(defonce counter (atom 1))

(def current-count (swap! counter inc))

(def completed (future-listener [f]
                 (if (and f (.isSuccess f))
                   (println "Sucess")
                   (println (.cause f) "Failed")
                   )))

(def connection (let [ssl-keystore (keystore :key-path "/Users/niclas/Software/work/herolabs/hero11-api/resources/keys/hero11acm-dev.p12"
                                     :key-pass "Hero11"
                                     :cert-path "/Users/niclas/Software/work/herolabs/hero11-api/resources/keys/hero11acm-dev.cer")
                      ssl-context (ssl-context :keystore ssl-keystore :trust-managers (naive-trust-managers :trace false))
                      ] (create-connection (dev-address) ssl-context :time-out 5 :error-handler (fn [e] (println "Error:"e)))))

#_ (def feedbacks (let [ssl-keystore (keystore :key-path "/Users/niclas/Software/work/herolabs/hero11-api/resources/keys/hero11acm-dev.p12"
                                       :key-pass "Hero11"
                                       :cert-path "/Users/niclas/Software/work/herolabs/hero11-api/resources/keys/hero11acm-dev.cer")
                        ssl-context (ssl-context :keystore ssl-keystore :trust-managers (naive-trust-managers :trace false))
                        ] (feedback (feedback-dev-address) ssl-context :time-out 5)))


(info "Counter:" current-count)

(def p0 (send-to connection "884ab36f7c74165386684395c15b097f0b0714cfc7e0a9ab450e0caa57544bb9" {:aps {:alert (str "From Scrapbook " current-count ".1")}}
          ))

(def p1 (send-to connection "884ab36f7c74165386684395c15b097f0b0714cfc7e0a9ab450e0caa57544bb0" {:aps {:alert (str "From Scrapbook " current-count ".2")}}
             ))

(doseq [i (range 3 10)]
     (do                                      ()
       (send-to connection "884ab36f7c74165386684395c15b097f0b0714cfc7e0a9ab450e0caa57544bb9"
         {:aps {:alert (str "From Scrapbook " current-count "." i)}})
       ))


