var hitokotonushiMessages = {
  "areYouSure": "Are you sure?"
};

function language() {
  return $("html").attr("lang");
}

function initDateTimePickers() {
  $(".as-date").
    datetimepicker(
      {
        "pickTime":   false,
        "useCurrent": false
      });

  $(".as-timestamp").
    datetimepicker(
      {
        "useCurrent": false,
        "useSeconds": true
      });
}

function initButtons() {
  $(".as-dangerous").
    click(
      function(event) {
        if (!window.confirm(hitokotonushiMessages.areYouSure)) {
          event.preventDefault();
        }
      });
  
  $("button[type=button].as-submit").
    click(
      function(event) {
        if (!event.isDefaultPrevented()) {
          $(this).parents("form").
            append("<input type='hidden' name='" + $(this).attr("name") + "' value='" + $(this).val() + "'>").
            submit();
        }
      });
}

function initDataTables() {
  $(".as-datatable").
    addClass("stripe").
    dataTable(
      {
        "info":         false,
        "jQueryUI":     true,
        "lengthChange": false,
        "pageLength":   20,
        "pagingType":   "full_numbers",
        "columnDefs":   [
          {
            "sortable": false,
            "targets":  [-1]
          }
        ]
      });
}

function initFocus() {
  var firstControl = $("input,select,textarea,button").eq(0);

  if (firstControl.hasClass("as-date") || firstControl.hasClass("as-timestamp")) {
    return;
  }

  firstControl.focus();
}

$(document).ready(
  function() {
    initDateTimePickers();
    initButtons();
    initDataTables();

    initFocus();
  }
);
