/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;

public class HiveConf
extends Configuration {
    protected String hiveJar;
    protected Properties origProp;
    protected String auxJars;
    private static final Log l4j = LogFactory.getLog(HiveConf.class);
    public static final ConfVars[] metaVars = new ConfVars[]{ConfVars.METASTOREDIRECTORY, ConfVars.METASTOREWAREHOUSE, ConfVars.METASTOREURIS};

    public static int getIntVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Integer.class);
        return conf.getInt(var.varname, var.defaultIntVal);
    }

    public int getIntVar(ConfVars var) {
        return HiveConf.getIntVar(this, var);
    }

    public static long getLongVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Long.class);
        return conf.getLong(var.varname, var.defaultLongVal);
    }

    public long getLongVar(ConfVars var) {
        return HiveConf.getLongVar(this, var);
    }

    public static float getFloatVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Float.class);
        return conf.getFloat(var.varname, var.defaultFloatVal);
    }

    public float getFloatVar(ConfVars var) {
        return HiveConf.getFloatVar(this, var);
    }

    public static boolean getBoolVar(Configuration conf, ConfVars var) {
        assert (var.valClass == Boolean.class);
        return conf.getBoolean(var.varname, var.defaultBoolVal);
    }

    public boolean getBoolVar(ConfVars var) {
        return HiveConf.getBoolVar(this, var);
    }

    public static String getVar(Configuration conf, ConfVars var) {
        assert (var.valClass == String.class);
        return conf.get(var.varname, var.defaultVal);
    }

    public static void setVar(Configuration conf, ConfVars var, String val) {
        assert (var.valClass == String.class);
        conf.set(var.varname, val);
    }

    public String getVar(ConfVars var) {
        return HiveConf.getVar(this, var);
    }

    public void setVar(ConfVars var, String val) {
        HiveConf.setVar(this, var, val);
    }

    public void logVars(PrintStream ps) {
        for (ConfVars one : ConfVars.values()) {
            ps.println(one.varname + "=" + (this.get(one.varname) != null ? this.get(one.varname) : ""));
        }
    }

    public HiveConf() {
    }

    public HiveConf(Class<?> cls) {
        this.initialize(cls);
    }

    public HiveConf(Configuration other, Class<?> cls) {
        super(other);
        this.initialize(cls);
    }

    private Properties getUnderlyingProps() {
        Iterator iter = this.iterator();
        Properties p = new Properties();
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            p.setProperty((String)e.getKey(), (String)e.getValue());
        }
        return p;
    }

    private void initialize(Class<?> cls) {
        this.hiveJar = new JobConf(cls).getJar();
        this.origProp = this.getUnderlyingProps();
        URL hconfurl = this.getClassLoader().getResource("hive-default.xml");
        if (hconfurl == null) {
            l4j.debug((Object)"hive-default.xml not found.");
        } else {
            this.addResource(hconfurl);
        }
        URL hsiteurl = this.getClassLoader().getResource("hive-site.xml");
        if (hsiteurl == null) {
            l4j.debug((Object)"hive-site.xml not found.");
        } else {
            this.addResource(hsiteurl);
        }
        URL hadoopconfurl = this.getClassLoader().getResource("hadoop-default.xml");
        if (hadoopconfurl == null) {
            hadoopconfurl = this.getClassLoader().getResource("hadoop-site.xml");
        }
        if (hadoopconfurl != null) {
            String conffile = hadoopconfurl.getPath();
            this.setVar(ConfVars.HADOOPCONF, conffile.substring(0, conffile.lastIndexOf(47)));
        }
        this.applySystemProperties();
        if (this.hiveJar == null) {
            this.hiveJar = this.get(ConfVars.HIVEJAR.varname);
        }
        if (this.auxJars == null) {
            this.auxJars = this.get(ConfVars.HIVEAUXJARS.varname);
        }
    }

    public void applySystemProperties() {
        for (ConfVars oneVar : ConfVars.values()) {
            if (System.getProperty(oneVar.varname) == null || System.getProperty(oneVar.varname).length() <= 0) continue;
            this.set(oneVar.varname, System.getProperty(oneVar.varname));
        }
    }

    public Properties getChangedProperties() {
        Properties ret = new Properties();
        Properties newProp = this.getUnderlyingProps();
        for (Object one : newProp.keySet()) {
            String oneProp = (String)one;
            String oldValue = this.origProp.getProperty(oneProp);
            if (StringUtils.equals((String)oldValue, (String)newProp.getProperty(oneProp))) continue;
            ret.setProperty(oneProp, newProp.getProperty(oneProp));
        }
        return ret;
    }

    public Properties getAllProperties() {
        return this.getUnderlyingProps();
    }

    public String getJar() {
        return this.hiveJar;
    }

    public String getAuxJars() {
        return this.auxJars;
    }

    public void setAuxJars(String auxJars) {
        this.auxJars = auxJars;
        HiveConf.setVar(this, ConfVars.HIVEAUXJARS, auxJars);
    }

    public String getUser() throws IOException {
        try {
            UserGroupInformation ugi = UserGroupInformation.readFrom((Configuration)this);
            if (ugi == null) {
                ugi = UserGroupInformation.login((Configuration)this);
            }
            return ugi.getUserName();
        }
        catch (LoginException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    public static String getColumnInternalName(int pos) {
        return "_col" + pos;
    }

    public static enum ConfVars {
        SCRIPTWRAPPER("hive.exec.script.wrapper", null),
        PLAN("hive.exec.plan", null),
        SCRATCHDIR("hive.exec.scratchdir", "/tmp/" + System.getProperty("user.name") + "/hive"),
        SUBMITVIACHILD("hive.exec.submitviachild", false),
        SCRIPTERRORLIMIT("hive.exec.script.maxerrsize", 100000),
        ALLOWPARTIALCONSUMP("hive.exec.script.allow.partial.consumption", false),
        COMPRESSRESULT("hive.exec.compress.output", false),
        COMPRESSINTERMEDIATE("hive.exec.compress.intermediate", false),
        COMPRESSINTERMEDIATECODEC("hive.intermediate.compression.codec", ""),
        COMPRESSINTERMEDIATETYPE("hive.intermediate.compression.type", ""),
        BYTESPERREDUCER("hive.exec.reducers.bytes.per.reducer", 1000000000L),
        MAXREDUCERS("hive.exec.reducers.max", 999),
        PREEXECHOOKS("hive.exec.pre.hooks", ""),
        POSTEXECHOOKS("hive.exec.post.hooks", ""),
        EXECPARALLEL("hive.exec.parallel", false),
        HIVESPECULATIVEEXECREDUCERS("hive.mapred.reduce.tasks.speculative.execution", true),
        HADOOPBIN("hadoop.bin.path", System.getenv("HADOOP_HOME") + "/bin/hadoop"),
        HADOOPCONF("hadoop.config.dir", System.getenv("HADOOP_HOME") + "/conf"),
        HADOOPFS("fs.default.name", "file:///"),
        HADOOPMAPFILENAME("map.input.file", null),
        HADOOPJT("mapred.job.tracker", "local"),
        HADOOPNUMREDUCERS("mapred.reduce.tasks", 1),
        HADOOPJOBNAME("mapred.job.name", null),
        HADOOPSPECULATIVEEXECREDUCERS("mapred.reduce.tasks.speculative.execution", false),
        METASTOREDIRECTORY("hive.metastore.metadb.dir", ""),
        METASTOREWAREHOUSE("hive.metastore.warehouse.dir", ""),
        METASTOREURIS("hive.metastore.uris", ""),
        METASTOREPWD("javax.jdo.option.ConnectionPassword", ""),
        CLIIGNOREERRORS("hive.cli.errors.ignore", false),
        HIVESESSIONID("hive.session.id", ""),
        HIVEQUERYSTRING("hive.query.string", ""),
        HIVEQUERYID("hive.query.id", ""),
        HIVEPLANID("hive.query.planid", ""),
        HIVEJOBNAMELENGTH("hive.jobname.length", 50),
        HIVEJAR("hive.jar.path", ""),
        HIVEAUXJARS("hive.aux.jars.path", ""),
        HIVEADDEDFILES("hive.added.files.path", ""),
        HIVEADDEDJARS("hive.added.jars.path", ""),
        HIVEADDEDARCHIVES("hive.added.archives.path", ""),
        HIVETABLENAME("hive.table.name", ""),
        HIVEPARTITIONNAME("hive.partition.name", ""),
        HIVESCRIPTAUTOPROGRESS("hive.script.auto.progress", false),
        HIVESCRIPTIDENVVAR("hive.script.operator.id.env.var", "HIVE_SCRIPT_OPERATOR_ID"),
        HIVEMAPREDMODE("hive.mapred.mode", "nonstrict"),
        HIVEALIAS("hive.alias", ""),
        HIVEMAPSIDEAGGREGATE("hive.map.aggr", "true"),
        HIVEGROUPBYSKEW("hive.groupby.skewindata", "false"),
        HIVEJOINEMITINTERVAL("hive.join.emit.interval", 1000),
        HIVEJOINCACHESIZE("hive.join.cache.size", 25000),
        HIVEMAPJOINBUCKETCACHESIZE("hive.mapjoin.bucket.cache.size", 100),
        HIVEMAPJOINROWSIZE("hive.mapjoin.size.key", 10000),
        HIVEMAPJOINCACHEROWS("hive.mapjoin.cache.numrows", 25000),
        HIVEGROUPBYMAPINTERVAL("hive.groupby.mapaggr.checkinterval", 100000),
        HIVEMAPAGGRHASHMEMORY("hive.map.aggr.hash.percentmemory", 0.5f),
        HIVEMAPAGGRHASHMINREDUCTION("hive.map.aggr.hash.min.reduction", 0.5f),
        HIVEUDTFAUTOPROGRESS("hive.udtf.auto.progress", false),
        HIVEDEFAULTFILEFORMAT("hive.default.fileformat", "TextFile"),
        HIVECHECKFILEFORMAT("hive.fileformat.check", true),
        HIVEHISTORYFILELOC("hive.querylog.location", "/tmp/" + System.getProperty("user.name")),
        HIVESCRIPTSERDE("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe"),
        HIVESCRIPTRECORDREADER("hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader"),
        HIVESCRIPTRECORDWRITER("hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter"),
        HIVEHWILISTENHOST("hive.hwi.listen.host", "0.0.0.0"),
        HIVEHWILISTENPORT("hive.hwi.listen.port", "9999"),
        HIVEHWIWARFILE("hive.hwi.war.file", System.getenv("HWI_WAR_FILE")),
        HIVEHADOOPMAXMEM("hive.mapred.local.mem", 0),
        HIVETESTMODE("hive.test.mode", false),
        HIVETESTMODEPREFIX("hive.test.mode.prefix", "test_"),
        HIVETESTMODESAMPLEFREQ("hive.test.mode.samplefreq", 32),
        HIVETESTMODENOSAMPLE("hive.test.mode.nosamplelist", ""),
        HIVEMERGEMAPFILES("hive.merge.mapfiles", true),
        HIVEMERGEMAPREDFILES("hive.merge.mapredfiles", false),
        HIVEMERGEMAPFILESSIZE("hive.merge.size.per.task", 256000000L),
        HIVEMERGEMAPFILESAVGSIZE("hive.merge.smallfiles.avgsize", 16000000L),
        HIVESENDHEARTBEAT("hive.heartbeat.interval", 1000),
        HIVEMAXMAPJOINSIZE("hive.mapjoin.maxsize", 100000),
        HIVEJOBPROGRESS("hive.task.progress", false),
        HIVEINPUTFORMAT("hive.input.format", ""),
        HIVEOPTCP("hive.optimize.cp", true),
        HIVEOPTPPD("hive.optimize.ppd", true),
        HIVEOPTGROUPBY("hive.optimize.groupby", true);

        public final String varname;
        public final String defaultVal;
        public final int defaultIntVal;
        public final long defaultLongVal;
        public final float defaultFloatVal;
        public final Class<?> valClass;
        public final boolean defaultBoolVal;

        private ConfVars(String varname, String defaultVal) {
            this.varname = varname;
            this.valClass = String.class;
            this.defaultVal = defaultVal;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, int defaultIntVal) {
            this.varname = varname;
            this.valClass = Integer.class;
            this.defaultVal = null;
            this.defaultIntVal = defaultIntVal;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, long defaultLongVal) {
            this.varname = varname;
            this.valClass = Long.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = defaultLongVal;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, float defaultFloatVal) {
            this.varname = varname;
            this.valClass = Float.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = defaultFloatVal;
            this.defaultBoolVal = false;
        }

        private ConfVars(String varname, boolean defaultBoolVal) {
            this.varname = varname;
            this.valClass = Boolean.class;
            this.defaultVal = null;
            this.defaultIntVal = -1;
            this.defaultLongVal = -1L;
            this.defaultFloatVal = -1.0f;
            this.defaultBoolVal = defaultBoolVal;
        }

        public String toString() {
            return this.varname;
        }
    }
}

