/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class StorageDescriptor
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("StorageDescriptor");
    private static final TField COLS_FIELD_DESC = new TField("cols", 15, 1);
    private static final TField LOCATION_FIELD_DESC = new TField("location", 11, 2);
    private static final TField INPUT_FORMAT_FIELD_DESC = new TField("inputFormat", 11, 3);
    private static final TField OUTPUT_FORMAT_FIELD_DESC = new TField("outputFormat", 11, 4);
    private static final TField COMPRESSED_FIELD_DESC = new TField("compressed", 2, 5);
    private static final TField NUM_BUCKETS_FIELD_DESC = new TField("numBuckets", 8, 6);
    private static final TField SERDE_INFO_FIELD_DESC = new TField("serdeInfo", 12, 7);
    private static final TField BUCKET_COLS_FIELD_DESC = new TField("bucketCols", 15, 8);
    private static final TField SORT_COLS_FIELD_DESC = new TField("sortCols", 15, 9);
    private static final TField PARAMETERS_FIELD_DESC = new TField("parameters", 13, 10);
    private List<FieldSchema> cols;
    public static final int COLS = 1;
    private String location;
    public static final int LOCATION = 2;
    private String inputFormat;
    public static final int INPUTFORMAT = 3;
    private String outputFormat;
    public static final int OUTPUTFORMAT = 4;
    private boolean compressed;
    public static final int COMPRESSED = 5;
    private int numBuckets;
    public static final int NUMBUCKETS = 6;
    private SerDeInfo serdeInfo;
    public static final int SERDEINFO = 7;
    private List<String> bucketCols;
    public static final int BUCKETCOLS = 8;
    private List<Order> sortCols;
    public static final int SORTCOLS = 9;
    private Map<String, String> parameters;
    public static final int PARAMETERS = 10;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("cols", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
            this.put(2, new FieldMetaData("location", 3, new FieldValueMetaData(11)));
            this.put(3, new FieldMetaData("inputFormat", 3, new FieldValueMetaData(11)));
            this.put(4, new FieldMetaData("outputFormat", 3, new FieldValueMetaData(11)));
            this.put(5, new FieldMetaData("compressed", 3, new FieldValueMetaData(2)));
            this.put(6, new FieldMetaData("numBuckets", 3, new FieldValueMetaData(8)));
            this.put(7, new FieldMetaData("serdeInfo", 3, (FieldValueMetaData)new StructMetaData(12, SerDeInfo.class)));
            this.put(8, new FieldMetaData("bucketCols", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
            this.put(9, new FieldMetaData("sortCols", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, Order.class))));
            this.put(10, new FieldMetaData("parameters", 3, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        }
    });

    public StorageDescriptor() {
    }

    public StorageDescriptor(List<FieldSchema> cols, String location, String inputFormat, String outputFormat, boolean compressed, int numBuckets, SerDeInfo serdeInfo, List<String> bucketCols, List<Order> sortCols, Map<String, String> parameters) {
        this();
        this.cols = cols;
        this.location = location;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
        this.compressed = compressed;
        this.__isset.compressed = true;
        this.numBuckets = numBuckets;
        this.__isset.numBuckets = true;
        this.serdeInfo = serdeInfo;
        this.bucketCols = bucketCols;
        this.sortCols = sortCols;
        this.parameters = parameters;
    }

    public StorageDescriptor(StorageDescriptor other) {
        if (other.isSetCols()) {
            ArrayList<FieldSchema> __this__cols = new ArrayList<FieldSchema>();
            for (FieldSchema fieldSchema : other.cols) {
                __this__cols.add(new FieldSchema(fieldSchema));
            }
            this.cols = __this__cols;
        }
        if (other.isSetLocation()) {
            this.location = other.location;
        }
        if (other.isSetInputFormat()) {
            this.inputFormat = other.inputFormat;
        }
        if (other.isSetOutputFormat()) {
            this.outputFormat = other.outputFormat;
        }
        this.__isset.compressed = other.__isset.compressed;
        this.compressed = other.compressed;
        this.__isset.numBuckets = other.__isset.numBuckets;
        this.numBuckets = other.numBuckets;
        if (other.isSetSerdeInfo()) {
            this.serdeInfo = new SerDeInfo(other.serdeInfo);
        }
        if (other.isSetBucketCols()) {
            ArrayList<String> __this__bucketCols = new ArrayList<String>();
            for (String string : other.bucketCols) {
                __this__bucketCols.add(string);
            }
            this.bucketCols = __this__bucketCols;
        }
        if (other.isSetSortCols()) {
            ArrayList<Order> __this__sortCols = new ArrayList<Order>();
            for (Order order : other.sortCols) {
                __this__sortCols.add(new Order(order));
            }
            this.sortCols = __this__sortCols;
        }
        if (other.isSetParameters()) {
            HashMap<String, String> __this__parameters = new HashMap<String, String>();
            for (Map.Entry entry : other.parameters.entrySet()) {
                String other_element_key = (String)entry.getKey();
                String other_element_value = (String)entry.getValue();
                String __this__parameters_copy_key = other_element_key;
                String __this__parameters_copy_value = other_element_value;
                __this__parameters.put(__this__parameters_copy_key, __this__parameters_copy_value);
            }
            this.parameters = __this__parameters;
        }
    }

    public StorageDescriptor clone() {
        return new StorageDescriptor(this);
    }

    public int getColsSize() {
        return this.cols == null ? 0 : this.cols.size();
    }

    public Iterator<FieldSchema> getColsIterator() {
        return this.cols == null ? null : this.cols.iterator();
    }

    public void addToCols(FieldSchema elem) {
        if (this.cols == null) {
            this.cols = new ArrayList<FieldSchema>();
        }
        this.cols.add(elem);
    }

    public List<FieldSchema> getCols() {
        return this.cols;
    }

    public void setCols(List<FieldSchema> cols) {
        this.cols = cols;
    }

    public void unsetCols() {
        this.cols = null;
    }

    public boolean isSetCols() {
        return this.cols != null;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void unsetLocation() {
        this.location = null;
    }

    public boolean isSetLocation() {
        return this.location != null;
    }

    public String getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public void unsetInputFormat() {
        this.inputFormat = null;
    }

    public boolean isSetInputFormat() {
        return this.inputFormat != null;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void unsetOutputFormat() {
        this.outputFormat = null;
    }

    public boolean isSetOutputFormat() {
        return this.outputFormat != null;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
        this.__isset.compressed = true;
    }

    public void unsetCompressed() {
        this.__isset.compressed = false;
    }

    public boolean isSetCompressed() {
        return this.__isset.compressed;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public void setNumBuckets(int numBuckets) {
        this.numBuckets = numBuckets;
        this.__isset.numBuckets = true;
    }

    public void unsetNumBuckets() {
        this.__isset.numBuckets = false;
    }

    public boolean isSetNumBuckets() {
        return this.__isset.numBuckets;
    }

    public SerDeInfo getSerdeInfo() {
        return this.serdeInfo;
    }

    public void setSerdeInfo(SerDeInfo serdeInfo) {
        this.serdeInfo = serdeInfo;
    }

    public void unsetSerdeInfo() {
        this.serdeInfo = null;
    }

    public boolean isSetSerdeInfo() {
        return this.serdeInfo != null;
    }

    public int getBucketColsSize() {
        return this.bucketCols == null ? 0 : this.bucketCols.size();
    }

    public Iterator<String> getBucketColsIterator() {
        return this.bucketCols == null ? null : this.bucketCols.iterator();
    }

    public void addToBucketCols(String elem) {
        if (this.bucketCols == null) {
            this.bucketCols = new ArrayList<String>();
        }
        this.bucketCols.add(elem);
    }

    public List<String> getBucketCols() {
        return this.bucketCols;
    }

    public void setBucketCols(List<String> bucketCols) {
        this.bucketCols = bucketCols;
    }

    public void unsetBucketCols() {
        this.bucketCols = null;
    }

    public boolean isSetBucketCols() {
        return this.bucketCols != null;
    }

    public int getSortColsSize() {
        return this.sortCols == null ? 0 : this.sortCols.size();
    }

    public Iterator<Order> getSortColsIterator() {
        return this.sortCols == null ? null : this.sortCols.iterator();
    }

    public void addToSortCols(Order elem) {
        if (this.sortCols == null) {
            this.sortCols = new ArrayList<Order>();
        }
        this.sortCols.add(elem);
    }

    public List<Order> getSortCols() {
        return this.sortCols;
    }

    public void setSortCols(List<Order> sortCols) {
        this.sortCols = sortCols;
    }

    public void unsetSortCols() {
        this.sortCols = null;
    }

    public boolean isSetSortCols() {
        return this.sortCols != null;
    }

    public int getParametersSize() {
        return this.parameters == null ? 0 : this.parameters.size();
    }

    public void putToParameters(String key, String val) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, val);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void unsetParameters() {
        this.parameters = null;
    }

    public boolean isSetParameters() {
        return this.parameters != null;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetCols();
                    break;
                }
                this.setCols((List)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetLocation();
                    break;
                }
                this.setLocation((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetInputFormat();
                    break;
                }
                this.setInputFormat((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetOutputFormat();
                    break;
                }
                this.setOutputFormat((String)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetCompressed();
                    break;
                }
                this.setCompressed((Boolean)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetNumBuckets();
                    break;
                }
                this.setNumBuckets((Integer)value);
                break;
            }
            case 7: {
                if (value == null) {
                    this.unsetSerdeInfo();
                    break;
                }
                this.setSerdeInfo((SerDeInfo)value);
                break;
            }
            case 8: {
                if (value == null) {
                    this.unsetBucketCols();
                    break;
                }
                this.setBucketCols((List)value);
                break;
            }
            case 9: {
                if (value == null) {
                    this.unsetSortCols();
                    break;
                }
                this.setSortCols((List)value);
                break;
            }
            case 10: {
                if (value == null) {
                    this.unsetParameters();
                    break;
                }
                this.setParameters((Map)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getCols();
            }
            case 2: {
                return this.getLocation();
            }
            case 3: {
                return this.getInputFormat();
            }
            case 4: {
                return this.getOutputFormat();
            }
            case 5: {
                return new Boolean(this.isCompressed());
            }
            case 6: {
                return new Integer(this.getNumBuckets());
            }
            case 7: {
                return this.getSerdeInfo();
            }
            case 8: {
                return this.getBucketCols();
            }
            case 9: {
                return this.getSortCols();
            }
            case 10: {
                return this.getParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetCols();
            }
            case 2: {
                return this.isSetLocation();
            }
            case 3: {
                return this.isSetInputFormat();
            }
            case 4: {
                return this.isSetOutputFormat();
            }
            case 5: {
                return this.isSetCompressed();
            }
            case 6: {
                return this.isSetNumBuckets();
            }
            case 7: {
                return this.isSetSerdeInfo();
            }
            case 8: {
                return this.isSetBucketCols();
            }
            case 9: {
                return this.isSetSortCols();
            }
            case 10: {
                return this.isSetParameters();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof StorageDescriptor) {
            return this.equals((StorageDescriptor)that);
        }
        return false;
    }

    public boolean equals(StorageDescriptor that) {
        if (that == null) {
            return false;
        }
        boolean this_present_cols = this.isSetCols();
        boolean that_present_cols = that.isSetCols();
        if (this_present_cols || that_present_cols) {
            if (!this_present_cols || !that_present_cols) {
                return false;
            }
            if (!((Object)this.cols).equals(that.cols)) {
                return false;
            }
        }
        boolean this_present_location = this.isSetLocation();
        boolean that_present_location = that.isSetLocation();
        if (this_present_location || that_present_location) {
            if (!this_present_location || !that_present_location) {
                return false;
            }
            if (!this.location.equals(that.location)) {
                return false;
            }
        }
        boolean this_present_inputFormat = this.isSetInputFormat();
        boolean that_present_inputFormat = that.isSetInputFormat();
        if (this_present_inputFormat || that_present_inputFormat) {
            if (!this_present_inputFormat || !that_present_inputFormat) {
                return false;
            }
            if (!this.inputFormat.equals(that.inputFormat)) {
                return false;
            }
        }
        boolean this_present_outputFormat = this.isSetOutputFormat();
        boolean that_present_outputFormat = that.isSetOutputFormat();
        if (this_present_outputFormat || that_present_outputFormat) {
            if (!this_present_outputFormat || !that_present_outputFormat) {
                return false;
            }
            if (!this.outputFormat.equals(that.outputFormat)) {
                return false;
            }
        }
        boolean this_present_compressed = true;
        boolean that_present_compressed = true;
        if (this_present_compressed || that_present_compressed) {
            if (!this_present_compressed || !that_present_compressed) {
                return false;
            }
            if (this.compressed != that.compressed) {
                return false;
            }
        }
        boolean this_present_numBuckets = true;
        boolean that_present_numBuckets = true;
        if (this_present_numBuckets || that_present_numBuckets) {
            if (!this_present_numBuckets || !that_present_numBuckets) {
                return false;
            }
            if (this.numBuckets != that.numBuckets) {
                return false;
            }
        }
        boolean this_present_serdeInfo = this.isSetSerdeInfo();
        boolean that_present_serdeInfo = that.isSetSerdeInfo();
        if (this_present_serdeInfo || that_present_serdeInfo) {
            if (!this_present_serdeInfo || !that_present_serdeInfo) {
                return false;
            }
            if (!this.serdeInfo.equals(that.serdeInfo)) {
                return false;
            }
        }
        boolean this_present_bucketCols = this.isSetBucketCols();
        boolean that_present_bucketCols = that.isSetBucketCols();
        if (this_present_bucketCols || that_present_bucketCols) {
            if (!this_present_bucketCols || !that_present_bucketCols) {
                return false;
            }
            if (!((Object)this.bucketCols).equals(that.bucketCols)) {
                return false;
            }
        }
        boolean this_present_sortCols = this.isSetSortCols();
        boolean that_present_sortCols = that.isSetSortCols();
        if (this_present_sortCols || that_present_sortCols) {
            if (!this_present_sortCols || !that_present_sortCols) {
                return false;
            }
            if (!((Object)this.sortCols).equals(that.sortCols)) {
                return false;
            }
        }
        boolean this_present_parameters = this.isSetParameters();
        boolean that_present_parameters = that.isSetParameters();
        if (this_present_parameters || that_present_parameters) {
            if (!this_present_parameters || !that_present_parameters) {
                return false;
            }
            if (!((Object)this.parameters).equals(that.parameters)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 15) {
                        TList _list9 = iprot.readListBegin();
                        this.cols = new ArrayList<FieldSchema>(_list9.size);
                        for (int _i10 = 0; _i10 < _list9.size; ++_i10) {
                            FieldSchema _elem11 = new FieldSchema();
                            _elem11.read(iprot);
                            this.cols.add(_elem11);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.location = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.inputFormat = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.outputFormat = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 2) {
                        this.compressed = iprot.readBool();
                        this.__isset.compressed = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.numBuckets = iprot.readI32();
                        this.__isset.numBuckets = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 7: {
                    if (field.type == 12) {
                        this.serdeInfo = new SerDeInfo();
                        this.serdeInfo.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 8: {
                    if (field.type == 15) {
                        TList _list12 = iprot.readListBegin();
                        this.bucketCols = new ArrayList<String>(_list12.size);
                        for (int _i13 = 0; _i13 < _list12.size; ++_i13) {
                            String _elem14 = iprot.readString();
                            this.bucketCols.add(_elem14);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 9: {
                    if (field.type == 15) {
                        TList _list15 = iprot.readListBegin();
                        this.sortCols = new ArrayList<Order>(_list15.size);
                        for (int _i16 = 0; _i16 < _list15.size; ++_i16) {
                            Order _elem17 = new Order();
                            _elem17.read(iprot);
                            this.sortCols.add(_elem17);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 10: {
                    if (field.type == 13) {
                        TMap _map18 = iprot.readMapBegin();
                        this.parameters = new HashMap<String, String>(2 * _map18.size);
                        for (int _i19 = 0; _i19 < _map18.size; ++_i19) {
                            String _key20 = iprot.readString();
                            String _val21 = iprot.readString();
                            this.parameters.put(_key20, _val21);
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.cols != null) {
            oprot.writeFieldBegin(COLS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.cols.size()));
            for (FieldSchema fieldSchema : this.cols) {
                fieldSchema.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.location != null) {
            oprot.writeFieldBegin(LOCATION_FIELD_DESC);
            oprot.writeString(this.location);
            oprot.writeFieldEnd();
        }
        if (this.inputFormat != null) {
            oprot.writeFieldBegin(INPUT_FORMAT_FIELD_DESC);
            oprot.writeString(this.inputFormat);
            oprot.writeFieldEnd();
        }
        if (this.outputFormat != null) {
            oprot.writeFieldBegin(OUTPUT_FORMAT_FIELD_DESC);
            oprot.writeString(this.outputFormat);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(COMPRESSED_FIELD_DESC);
        oprot.writeBool(this.compressed);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_BUCKETS_FIELD_DESC);
        oprot.writeI32(this.numBuckets);
        oprot.writeFieldEnd();
        if (this.serdeInfo != null) {
            oprot.writeFieldBegin(SERDE_INFO_FIELD_DESC);
            this.serdeInfo.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.bucketCols != null) {
            oprot.writeFieldBegin(BUCKET_COLS_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.bucketCols.size()));
            for (String string : this.bucketCols) {
                oprot.writeString(string);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.sortCols != null) {
            oprot.writeFieldBegin(SORT_COLS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.sortCols.size()));
            for (Order order : this.sortCols) {
                order.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.parameters != null) {
            oprot.writeFieldBegin(PARAMETERS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 11, this.parameters.size()));
            for (Map.Entry entry : this.parameters.entrySet()) {
                oprot.writeString((String)entry.getKey());
                oprot.writeString((String)entry.getValue());
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StorageDescriptor(");
        boolean first = true;
        sb.append("cols:");
        if (this.cols == null) {
            sb.append("null");
        } else {
            sb.append(this.cols);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("location:");
        if (this.location == null) {
            sb.append("null");
        } else {
            sb.append(this.location);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("inputFormat:");
        if (this.inputFormat == null) {
            sb.append("null");
        } else {
            sb.append(this.inputFormat);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("outputFormat:");
        if (this.outputFormat == null) {
            sb.append("null");
        } else {
            sb.append(this.outputFormat);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("compressed:");
        sb.append(this.compressed);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("numBuckets:");
        sb.append(this.numBuckets);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("serdeInfo:");
        if (this.serdeInfo == null) {
            sb.append("null");
        } else {
            sb.append(this.serdeInfo);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("bucketCols:");
        if (this.bucketCols == null) {
            sb.append("null");
        } else {
            sb.append(this.bucketCols);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("sortCols:");
        if (this.sortCols == null) {
            sb.append("null");
        } else {
            sb.append(this.sortCols);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("parameters:");
        if (this.parameters == null) {
            sb.append("null");
        } else {
            sb.append(this.parameters);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(StorageDescriptor.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean compressed = false;
        public boolean numBuckets = false;

        private Isset() {
        }
    }
}

