/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class Type
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("Type");
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 1);
    private static final TField TYPE1_FIELD_DESC = new TField("type1", 11, 2);
    private static final TField TYPE2_FIELD_DESC = new TField("type2", 11, 3);
    private static final TField FIELDS_FIELD_DESC = new TField("fields", 15, 4);
    private String name;
    public static final int NAME = 1;
    private String type1;
    public static final int TYPE1 = 2;
    private String type2;
    public static final int TYPE2 = 3;
    private List<FieldSchema> fields;
    public static final int FIELDS = 4;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
            this.put(2, new FieldMetaData("type1", 2, new FieldValueMetaData(11)));
            this.put(3, new FieldMetaData("type2", 2, new FieldValueMetaData(11)));
            this.put(4, new FieldMetaData("fields", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, FieldSchema.class))));
        }
    });

    public Type() {
    }

    public Type(String name, String type1, String type2, List<FieldSchema> fields) {
        this();
        this.name = name;
        this.type1 = type1;
        this.type2 = type2;
        this.fields = fields;
    }

    public Type(Type other) {
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetType1()) {
            this.type1 = other.type1;
        }
        if (other.isSetType2()) {
            this.type2 = other.type2;
        }
        if (other.isSetFields()) {
            ArrayList<FieldSchema> __this__fields = new ArrayList<FieldSchema>();
            for (FieldSchema other_element : other.fields) {
                __this__fields.add(new FieldSchema(other_element));
            }
            this.fields = __this__fields;
        }
    }

    public Type clone() {
        return new Type(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public String getType1() {
        return this.type1;
    }

    public void setType1(String type1) {
        this.type1 = type1;
    }

    public void unsetType1() {
        this.type1 = null;
    }

    public boolean isSetType1() {
        return this.type1 != null;
    }

    public String getType2() {
        return this.type2;
    }

    public void setType2(String type2) {
        this.type2 = type2;
    }

    public void unsetType2() {
        this.type2 = null;
    }

    public boolean isSetType2() {
        return this.type2 != null;
    }

    public int getFieldsSize() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public Iterator<FieldSchema> getFieldsIterator() {
        return this.fields == null ? null : this.fields.iterator();
    }

    public void addToFields(FieldSchema elem) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldSchema>();
        }
        this.fields.add(elem);
    }

    public List<FieldSchema> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldSchema> fields) {
        this.fields = fields;
    }

    public void unsetFields() {
        this.fields = null;
    }

    public boolean isSetFields() {
        return this.fields != null;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetType1();
                    break;
                }
                this.setType1((String)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetType2();
                    break;
                }
                this.setType2((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetFields();
                    break;
                }
                this.setFields((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getType1();
            }
            case 3: {
                return this.getType2();
            }
            case 4: {
                return this.getFields();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetName();
            }
            case 2: {
                return this.isSetType1();
            }
            case 3: {
                return this.isSetType2();
            }
            case 4: {
                return this.isSetFields();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof Type) {
            return this.equals((Type)that);
        }
        return false;
    }

    public boolean equals(Type that) {
        if (that == null) {
            return false;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_type1 = this.isSetType1();
        boolean that_present_type1 = that.isSetType1();
        if (this_present_type1 || that_present_type1) {
            if (!this_present_type1 || !that_present_type1) {
                return false;
            }
            if (!this.type1.equals(that.type1)) {
                return false;
            }
        }
        boolean this_present_type2 = this.isSetType2();
        boolean that_present_type2 = that.isSetType2();
        if (this_present_type2 || that_present_type2) {
            if (!this_present_type2 || !that_present_type2) {
                return false;
            }
            if (!this.type2.equals(that.type2)) {
                return false;
            }
        }
        boolean this_present_fields = this.isSetFields();
        boolean that_present_fields = that.isSetFields();
        if (this_present_fields || that_present_fields) {
            if (!this_present_fields || !that_present_fields) {
                return false;
            }
            if (!((Object)this.fields).equals(that.fields)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 11) {
                        this.name = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.type1 = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.type2 = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 15) {
                        TList _list0 = iprot.readListBegin();
                        this.fields = new ArrayList<FieldSchema>(_list0.size);
                        for (int _i1 = 0; _i1 < _list0.size; ++_i1) {
                            FieldSchema _elem2 = new FieldSchema();
                            _elem2.read(iprot);
                            this.fields.add(_elem2);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.name != null) {
            oprot.writeFieldBegin(NAME_FIELD_DESC);
            oprot.writeString(this.name);
            oprot.writeFieldEnd();
        }
        if (this.type1 != null && this.isSetType1()) {
            oprot.writeFieldBegin(TYPE1_FIELD_DESC);
            oprot.writeString(this.type1);
            oprot.writeFieldEnd();
        }
        if (this.type2 != null && this.isSetType2()) {
            oprot.writeFieldBegin(TYPE2_FIELD_DESC);
            oprot.writeString(this.type2);
            oprot.writeFieldEnd();
        }
        if (this.fields != null && this.isSetFields()) {
            oprot.writeFieldBegin(FIELDS_FIELD_DESC);
            oprot.writeListBegin(new TList(12, this.fields.size()));
            for (FieldSchema _iter3 : this.fields) {
                _iter3.write(oprot);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Type(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (this.isSetType1()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("type1:");
            if (this.type1 == null) {
                sb.append("null");
            } else {
                sb.append(this.type1);
            }
            first = false;
        }
        if (this.isSetType2()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("type2:");
            if (this.type2 == null) {
                sb.append("null");
            } else {
                sb.append(this.type2);
            }
            first = false;
        }
        if (this.isSetFields()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fields:");
            if (this.fields == null) {
                sb.append("null");
            } else {
                sb.append(this.fields);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        FieldMetaData.addStructMetaDataMap(Type.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        private Isset() {
        }
    }
}

