/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyArray;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyListObjectInspector
implements ListObjectInspector {
    public static final Log LOG = LogFactory.getLog((String)LazyListObjectInspector.class.getName());
    ObjectInspector listElementObjectInspector;
    byte separator;
    Text nullSequence;
    boolean escaped;
    byte escapeChar;

    protected LazyListObjectInspector(ObjectInspector listElementObjectInspector, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        this.listElementObjectInspector = listElementObjectInspector;
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.escaped = escaped;
        this.escapeChar = escapeChar;
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }

    @Override
    public ObjectInspector getListElementObjectInspector() {
        return this.listElementObjectInspector;
    }

    @Override
    public Object getListElement(Object data, int index) {
        if (data == null) {
            return null;
        }
        LazyArray array = (LazyArray)data;
        return array.getListElementObject(index);
    }

    @Override
    public int getListLength(Object data) {
        if (data == null) {
            return -1;
        }
        LazyArray array = (LazyArray)data;
        return array.getListLength();
    }

    @Override
    public List<?> getList(Object data) {
        if (data == null) {
            return null;
        }
        LazyArray array = (LazyArray)data;
        return array.getList();
    }

    @Override
    public String getTypeName() {
        return "array<" + this.listElementObjectInspector.getTypeName() + ">";
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.nullSequence;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }
}

