/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.service.JobTrackerState;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class HiveClusterStatus
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("HiveClusterStatus");
    private static final TField TASK_TRACKERS_FIELD_DESC = new TField("taskTrackers", 8, 1);
    private static final TField MAP_TASKS_FIELD_DESC = new TField("mapTasks", 8, 2);
    private static final TField REDUCE_TASKS_FIELD_DESC = new TField("reduceTasks", 8, 3);
    private static final TField MAX_MAP_TASKS_FIELD_DESC = new TField("maxMapTasks", 8, 4);
    private static final TField MAX_REDUCE_TASKS_FIELD_DESC = new TField("maxReduceTasks", 8, 5);
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 6);
    private int taskTrackers;
    public static final int TASKTRACKERS = 1;
    private int mapTasks;
    public static final int MAPTASKS = 2;
    private int reduceTasks;
    public static final int REDUCETASKS = 3;
    private int maxMapTasks;
    public static final int MAXMAPTASKS = 4;
    private int maxReduceTasks;
    public static final int MAXREDUCETASKS = 5;
    private int state;
    public static final int STATE = 6;
    private final Isset __isset = new Isset();
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(1, new FieldMetaData("taskTrackers", 3, new FieldValueMetaData(8)));
            this.put(2, new FieldMetaData("mapTasks", 3, new FieldValueMetaData(8)));
            this.put(3, new FieldMetaData("reduceTasks", 3, new FieldValueMetaData(8)));
            this.put(4, new FieldMetaData("maxMapTasks", 3, new FieldValueMetaData(8)));
            this.put(5, new FieldMetaData("maxReduceTasks", 3, new FieldValueMetaData(8)));
            this.put(6, new FieldMetaData("state", 3, new FieldValueMetaData(8)));
        }
    });

    public HiveClusterStatus() {
    }

    public HiveClusterStatus(int taskTrackers, int mapTasks, int reduceTasks, int maxMapTasks, int maxReduceTasks, int state) {
        this();
        this.taskTrackers = taskTrackers;
        this.__isset.taskTrackers = true;
        this.mapTasks = mapTasks;
        this.__isset.mapTasks = true;
        this.reduceTasks = reduceTasks;
        this.__isset.reduceTasks = true;
        this.maxMapTasks = maxMapTasks;
        this.__isset.maxMapTasks = true;
        this.maxReduceTasks = maxReduceTasks;
        this.__isset.maxReduceTasks = true;
        this.state = state;
        this.__isset.state = true;
    }

    public HiveClusterStatus(HiveClusterStatus other) {
        this.__isset.taskTrackers = other.__isset.taskTrackers;
        this.taskTrackers = other.taskTrackers;
        this.__isset.mapTasks = other.__isset.mapTasks;
        this.mapTasks = other.mapTasks;
        this.__isset.reduceTasks = other.__isset.reduceTasks;
        this.reduceTasks = other.reduceTasks;
        this.__isset.maxMapTasks = other.__isset.maxMapTasks;
        this.maxMapTasks = other.maxMapTasks;
        this.__isset.maxReduceTasks = other.__isset.maxReduceTasks;
        this.maxReduceTasks = other.maxReduceTasks;
        this.__isset.state = other.__isset.state;
        this.state = other.state;
    }

    public HiveClusterStatus clone() {
        return new HiveClusterStatus(this);
    }

    public int getTaskTrackers() {
        return this.taskTrackers;
    }

    public void setTaskTrackers(int taskTrackers) {
        this.taskTrackers = taskTrackers;
        this.__isset.taskTrackers = true;
    }

    public void unsetTaskTrackers() {
        this.__isset.taskTrackers = false;
    }

    public boolean isSetTaskTrackers() {
        return this.__isset.taskTrackers;
    }

    public int getMapTasks() {
        return this.mapTasks;
    }

    public void setMapTasks(int mapTasks) {
        this.mapTasks = mapTasks;
        this.__isset.mapTasks = true;
    }

    public void unsetMapTasks() {
        this.__isset.mapTasks = false;
    }

    public boolean isSetMapTasks() {
        return this.__isset.mapTasks;
    }

    public int getReduceTasks() {
        return this.reduceTasks;
    }

    public void setReduceTasks(int reduceTasks) {
        this.reduceTasks = reduceTasks;
        this.__isset.reduceTasks = true;
    }

    public void unsetReduceTasks() {
        this.__isset.reduceTasks = false;
    }

    public boolean isSetReduceTasks() {
        return this.__isset.reduceTasks;
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public void setMaxMapTasks(int maxMapTasks) {
        this.maxMapTasks = maxMapTasks;
        this.__isset.maxMapTasks = true;
    }

    public void unsetMaxMapTasks() {
        this.__isset.maxMapTasks = false;
    }

    public boolean isSetMaxMapTasks() {
        return this.__isset.maxMapTasks;
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public void setMaxReduceTasks(int maxReduceTasks) {
        this.maxReduceTasks = maxReduceTasks;
        this.__isset.maxReduceTasks = true;
    }

    public void unsetMaxReduceTasks() {
        this.__isset.maxReduceTasks = false;
    }

    public boolean isSetMaxReduceTasks() {
        return this.__isset.maxReduceTasks;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
        this.__isset.state = true;
    }

    public void unsetState() {
        this.__isset.state = false;
    }

    public boolean isSetState() {
        return this.__isset.state;
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 1: {
                if (value == null) {
                    this.unsetTaskTrackers();
                    break;
                }
                this.setTaskTrackers((Integer)value);
                break;
            }
            case 2: {
                if (value == null) {
                    this.unsetMapTasks();
                    break;
                }
                this.setMapTasks((Integer)value);
                break;
            }
            case 3: {
                if (value == null) {
                    this.unsetReduceTasks();
                    break;
                }
                this.setReduceTasks((Integer)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetMaxMapTasks();
                    break;
                }
                this.setMaxMapTasks((Integer)value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetMaxReduceTasks();
                    break;
                }
                this.setMaxReduceTasks((Integer)value);
                break;
            }
            case 6: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((Integer)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Integer(this.getTaskTrackers());
            }
            case 2: {
                return new Integer(this.getMapTasks());
            }
            case 3: {
                return new Integer(this.getReduceTasks());
            }
            case 4: {
                return new Integer(this.getMaxMapTasks());
            }
            case 5: {
                return new Integer(this.getMaxReduceTasks());
            }
            case 6: {
                return this.getState();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.isSetTaskTrackers();
            }
            case 2: {
                return this.isSetMapTasks();
            }
            case 3: {
                return this.isSetReduceTasks();
            }
            case 4: {
                return this.isSetMaxMapTasks();
            }
            case 5: {
                return this.isSetMaxReduceTasks();
            }
            case 6: {
                return this.isSetState();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HiveClusterStatus) {
            return this.equals((HiveClusterStatus)that);
        }
        return false;
    }

    public boolean equals(HiveClusterStatus that) {
        if (that == null) {
            return false;
        }
        boolean this_present_taskTrackers = true;
        boolean that_present_taskTrackers = true;
        if (this_present_taskTrackers || that_present_taskTrackers) {
            if (!this_present_taskTrackers || !that_present_taskTrackers) {
                return false;
            }
            if (this.taskTrackers != that.taskTrackers) {
                return false;
            }
        }
        boolean this_present_mapTasks = true;
        boolean that_present_mapTasks = true;
        if (this_present_mapTasks || that_present_mapTasks) {
            if (!this_present_mapTasks || !that_present_mapTasks) {
                return false;
            }
            if (this.mapTasks != that.mapTasks) {
                return false;
            }
        }
        boolean this_present_reduceTasks = true;
        boolean that_present_reduceTasks = true;
        if (this_present_reduceTasks || that_present_reduceTasks) {
            if (!this_present_reduceTasks || !that_present_reduceTasks) {
                return false;
            }
            if (this.reduceTasks != that.reduceTasks) {
                return false;
            }
        }
        boolean this_present_maxMapTasks = true;
        boolean that_present_maxMapTasks = true;
        if (this_present_maxMapTasks || that_present_maxMapTasks) {
            if (!this_present_maxMapTasks || !that_present_maxMapTasks) {
                return false;
            }
            if (this.maxMapTasks != that.maxMapTasks) {
                return false;
            }
        }
        boolean this_present_maxReduceTasks = true;
        boolean that_present_maxReduceTasks = true;
        if (this_present_maxReduceTasks || that_present_maxReduceTasks) {
            if (!this_present_maxReduceTasks || !that_present_maxReduceTasks) {
                return false;
            }
            if (this.maxReduceTasks != that.maxReduceTasks) {
                return false;
            }
        }
        boolean this_present_state = true;
        boolean that_present_state = true;
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (this.state != that.state) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.taskTrackers = iprot.readI32();
                        this.__isset.taskTrackers = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.mapTasks = iprot.readI32();
                        this.__isset.mapTasks = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.reduceTasks = iprot.readI32();
                        this.__isset.reduceTasks = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.maxMapTasks = iprot.readI32();
                        this.__isset.maxMapTasks = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.maxReduceTasks = iprot.readI32();
                        this.__isset.maxReduceTasks = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.state = iprot.readI32();
                        this.__isset.state = true;
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TASK_TRACKERS_FIELD_DESC);
        oprot.writeI32(this.taskTrackers);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAP_TASKS_FIELD_DESC);
        oprot.writeI32(this.mapTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(REDUCE_TASKS_FIELD_DESC);
        oprot.writeI32(this.reduceTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAX_MAP_TASKS_FIELD_DESC);
        oprot.writeI32(this.maxMapTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAX_REDUCE_TASKS_FIELD_DESC);
        oprot.writeI32(this.maxReduceTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(STATE_FIELD_DESC);
        oprot.writeI32(this.state);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HiveClusterStatus(");
        boolean first = true;
        sb.append("taskTrackers:");
        sb.append(this.taskTrackers);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("mapTasks:");
        sb.append(this.mapTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("reduceTasks:");
        sb.append(this.reduceTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxMapTasks:");
        sb.append(this.maxMapTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxReduceTasks:");
        sb.append(this.maxReduceTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("state:");
        String state_name = JobTrackerState.VALUES_TO_NAMES.get(this.state);
        if (state_name != null) {
            sb.append(state_name);
            sb.append(" (");
        }
        sb.append(this.state);
        if (state_name != null) {
            sb.append(")");
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.isSetState() && !JobTrackerState.VALID_VALUES.contains(this.state)) {
            throw new TProtocolException("The field 'state' has been assigned the invalid value " + this.state);
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(HiveClusterStatus.class, metaDataMap);
    }

    private static final class Isset
    implements Serializable {
        public boolean taskTrackers = false;
        public boolean mapTasks = false;
        public boolean reduceTasks = false;
        public boolean maxMapTasks = false;
        public boolean maxReduceTasks = false;
        public boolean state = false;

        private Isset() {
        }
    }
}

