(defproject hjdserver.exchange "0.1.0-SNAPSHOT"
  :description "黄金岛兑换活动服务,不支持同时开启多个兑换活动."
  :license "Copyright 4A Volcano. 2015."
  :dependencies [[org.clojure/clojure "1.7.0"]
                 [org.clojure/core.async "0.2.371"]
                 [org.clojure/data.priority-map "0.0.7"]
                 [prismatic/schema "1.0.3"]
                 ; 定时器
                 [clojurewerkz/quartzite "2.0.0"]
                 ; web
                 [ring                      "1.4.0"]
                 [ring/ring-defaults        "0.1.5"]
                 [compojure                 "1.4.0"]
                 [clj-http                  "2.0.0"]
                 ; rpc
                 [clj-rpc                   "0.3.4"]
                 ; rmi
                 [hjdserver/rmi-service "1.1.0-SNAPSHOT"]
                 [hjdserver/datacenter-api "0.1.1"]
                 ; datomic
                 [earthworm "0.2.1" :exclusions [com.datomic/datomic-pro]]
                 [com.datomic/datomic-free "0.9.5130" :exclusions [org.slf4j/slf4j-nop org.slf4j/slf4j-log4j12 joda-time]]
                 ; system
                 [com.stuartsierra/component "0.3.0"]
                 ; log
                 [org.clojure/tools.logging "0.3.1"]
                 [ch.qos.logback/logback-classic "1.1.2"]
                 [net.logstash.logback/logstash-logback-encoder "3.3-utf-8"]
                 ; json
                 [cheshire "5.5.0"]
                 ; time
                 [clj-time "0.11.0"]]
  :profiles {:dev {:resource-paths ["etc"]
                   :dependencies   [[midje "1.6.3"]]
                   :plugins        [[lein-midje "3.1.3"]
                                    [lein-aws-maven "0.1.0" :exclusions [joda-time]]
                                    ]}}

  :repositories [["releases" {:url "s3://volcano-maven/releases" :username :env :password :env :sign-releases false}]
                 ["snapshots" {:url "s3://volcano-maven/snapshots" :username :env :password :env :sign-releases false}]]

  )
