;; $Author: lt $
;; $Id: service_client.clj 20 2009-09-07 06:45:44Z lt $
(ns #^{:doc "黄金岛 rmi 服务调用函数"
       :rev "$Rev: 20 $"}
  rmi-service.client
  (:use [rmi-service.utils])
  (:import [com.basecity.hjd.service.authenticate IAuthenticateService PlayerInformationBean]
	   [com.basecity.hjd.service.level ILevelService]
	   [com.basecity.hjd.service.friend IFriendService]
	   [com.basecity.hjd.service.server IServerService]
	   [com.basecity.hjd.service.user IAccountProtectionService]
	   [com.basecity.hjd.service.finance IBankService]
           [com.basecity.hjd.service.finance IFinanceService]
	   [com.basecity.hjd.service.region IRegionService]
	   [com.basecity.hjd.service.accountcontrol IAccountControlService]
           [com.basecity.hjd.service.user IUserService UserRegisterInfoBean]
           [com.basecity.hjd.service.pet IPetService PetInfoBean]
           [com.basecity.hjd ImageBean]
           [com.basecity.web.vipservice IVipService]
           [com.basecity.web.service.bankactive IBankActiveService]
           [com.basecity.web.mobileprotect.service IMobileProtectService]
           [com.basecity.hjd.service.namevalidation IRealNameValidationService]
           [com.basecity.hjd.service.kk IUserInfoRefresher]
           [com.basecity.hjd.service.team ITeamAdminService]
           [com.basecity.hjd.service.kingrace IKingRaceDataService]
           [com.basecity.hjd.service.kingrace.beans LastKingInfo]
           [com.basecity.web.payservice.whsmsdata.limit IMonthLimitPayService CoinValueLimitBean]
           [com.basecity.web.payservice.order IOrderService]
           [com.basecity.web.payservice.vip IHandleVipCentService]
           [com.basecity.hjd.service.user IUserService]
           [com.basecity.hjd ImageBean]
           [com.basecity.web.service.bankactive IBankActiveService]
           [com.basecity.game.server.achievementServer.apns IDeviceTokenService IGameCenterService DeviceTokenInfoModel]
           [com.basecity.hjd.service IUser3DAccountService]
           [com.basecity.hjd.service.server I3DServerService Server3DInformationBean]
           [com.basecity.web.limit.service.ydmobile IYdMobileLimitService]))

;;this unit is extracted from service_client in entryServer
;;TODO add more rmi functions here.
(defn login
  "登入系统"
  {:service :authenticateService}
  [service-url username password]
  (let [^IAuthenticateService service (get-service IAuthenticateService service-url)
	^PlayerInformationBean info (.login service username password)
	image (.getImage info)]
    (assoc (bean-without-class info) :image (bean-without-class image))))

(defn authenticate
  "验证用户身份"
  {:service :authenticateService}
  [service-url username password]
  (let [^IAuthenticateService service (get-service IAuthenticateService service-url)]
    (.authenticate service username password)))

(defn disable-user
  "暂时停用用户帐号"
  {:service :authenticateService}
  [service-url username]
  (let [^IAuthenticateService service (get-service IAuthenticateService service-url)]
    (.disableUser service username)))

(defn enable-user
  "启用用户帐号"
  {:service :authenticateService}
  [service-url username]
  (let [^IAuthenticateService service (get-service IAuthenticateService service-url)]
    (.enableUser service username)))

(defn change-password
  "修改用户密码, 返回nil"
  {:service :authenticateService}
  [service-url username new-password]
  (let [^IAuthenticateService service (get-service IAuthenticateService service-url)]
    (.changePassword service username new-password)))

(defn user-level
  "获得用户级别信息"
  {:service :levelService}
  [service-url username game-sign]
  (let [^ILevelService service (get-service ILevelService service-url)
	level (.getUserLevel service username game-sign)]
    (bean-without-class level)))

(defn change-exp
  "修改用户游戏的经验值，返回用户级别信息"
  {:service :levelService}
  [service-url username game-sign change-value]
  (let [^ILevelService service (get-service ILevelService service-url)
	level (.changeExp service username game-sign change-value)]
    (bean-without-class level)))

(defn friend-list
  "获得好友列表"
  {:service :friendService}
  [service-url username]
  (let [^IFriendService service (get-service IFriendService service-url)]
    (seq (.getFriends service username))))

(defn all-servers
  "获得服务器列表"
  {:service :serverService}
  [service-url]
  (let [^IServerService service (get-service IServerService service-url)
	servers (.getAllServers service)]
    (map bean-without-class servers)))

(defn all-3d-servers
  "获取3D服务器列表"
  {:service :hjd3DServerService}
  [service-url]
  (let [^I3DServerService service (get-service I3DServerService service-url)
        servers (.getAllServers service)]
    (map bean-without-class servers)))

(defn refresh-3d-server-info
  "更新3D服务器列表信息"
  {:service :hjd3DServerService}
  [service-url #^Server3DInformationBean info]
  (let [^I3DServerService service (get-service I3DServerService service-url)]
    (.refreshInformation service info)))

(defn is-protected?
  "是否有帐号保护"
  {:service :accountProtectionService}
  [service-url username]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)]
    (.isProtectionEnabled service username)))

(defn protection-info
  "获得帐号保护资料"
  {:service :accountProtectionService}
  [service-url username]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)]
    (bean-without-class (.getProtectionInfo service username))))

(defn is-second-password-correct?
  "是否二级密码正确"
  {:service :accountProtectionService}
  [service-url username second-password]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)]
    (.isSecondPasswordCorrect service username second-password)))

(defn is-password-answer-correct?
  "是否密码问题和答案正确"
  {:service :accountProtectionService}
  [service-url username question answer]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)]
    (.isPasswordAnswerCorrect service username question answer)))

(defn change-second-password
  "修改二级密码"
  {:service :accountProtectionService}
  [service-url username second-password]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)]
    (.changeSecondPassword service username second-password)))

(defn bank-balance
  "获得用户金币"
  {:service :bankService}
  [service-url username]
  (let [^IBankService service (get-service IBankService service-url)]
    (.getUserBankBalance service username)))

(defn deposite-to-bank
  "存金币"
  {:service :bankService}
  [service-url username money]
  (let [^IBankService service (get-service IBankService service-url)]
    (.depositeToBank service username money)))

(defn spend-from-bank
  "转金币到悟性"
  {:service :bankService}
  [service-url username money]
  (let [^IBankService service (get-service IBankService service-url)]
    (.spendFromBank service username money)))

(defn finance-balance
  "获得用户悟性"
  {:service :financeService}
  [service-url username]
  (let [^IFinanceService service (get-service IFinanceService service-url)]
    (.getUserBalance service username)))

(defn deposite
  "存悟性"
  {:service :financeService}
  [service-url username money]
  (let [^IFinanceService service (get-service IFinanceService service-url)]
    (.deposite service username money)))

(defn spend
  "扣悟性"
  {:service :financeService}
  [service-url username money]
  (let [^IFinanceService service (get-service IFinanceService service-url)]
    (.spend service username money)))

(defn user-region
  "获得用户区域信息, 返回 like {:region-id \"00\" :region-name \"湖南\"}"
  {:service :regionService}
  [service-url username]
  (let [^IRegionService service (get-service IRegionService service-url)]
    {:region-id (.getRegionId service username)
     :region-name (.getRegionName service username)}))

(defn change-user-region
  "修改用户区域信息"
  {:service :regionService}
  [service-url username region-id]
  (let [^IRegionService service (get-service IRegionService service-url)]
    (.changeUserRegion service username region-id)))

(defn clear-server-lock
  "解锁用户"
  {:service :accountControlService}
  [service-url server-sign]
  (let [^IAccountControlService service (get-service IAccountControlService service-url)]
    (.clearServerLock service server-sign)))

(defn lock-user
  "锁住用户"
  {:service :accountControlService}
  [service-url server-sign server-name game-type username]
  (let [^IAccountControlService service (get-service IAccountControlService service-url)]
    (.lock service username server-sign game-type server-name)))

(defn lock-info
  "用户帐号控制信息"
  {:service :accountControlService}
  [service-url username]
  (let [^IAccountControlService service (get-service IAccountControlService service-url)]
    (.getLockInfo service username)))

(defn user-info
  "获得用户信息"
  {:service :userService}
  [service-url ^String username]
  (let [^IUserService service (get-service IUserService service-url)
        info (.getInfo service username)
        img (.getImage info)]
    (assoc (bean-without-class info) :image (bean-without-class img) )))

(defn user-info-by-id
  "通过用户id获得用户信息"
  {:service :userService}
  [service-url user-id]
  (let [^IUserService service (get-service IUserService service-url)
        info (.getInfo service user-id)
        img (.getImage info)]
    (assoc (bean-without-class info) :image (bean-without-class img) )))

(defn change-image
  "改变用户头像 ,  image 格式必须是: {:bodyIndex 0, :decoratorIndex 3, :faceIndex 0, :hairIndex 0, :hairIndex2 0, :male false}"
  {:service :userService}
  [service-url username image]
  (let [^IUserService service (get-service IUserService service-url)
        #^ImageBean image-bean (gen-image-bean image)]
    (.changeImage service username image-bean)))

(defn is-vip
  "是否是vip用户"
  {:service :vipService}
  [service-url username]
  (let [^IVipService service (get-service IVipService service-url)]
    (.isVip service username)))

(defn desposite-vip-cent
  "增加vip积分"
  {:service :handleVipCentService}
  [service-url user-id coin-value tag]
  (let [^IHandleVipCentService service (get-service IHandleVipCentService service-url)]
    (.depositeVipCent service user-id coin-value tag)))

(defn notify-mobileprotect-user
  "使用手机短信通知密码修改，需要是会员用户并且开通密保功能"
  {:service :mobileProtectService}
  [service-url user-id message-content]
  (let [^IMobileProtectService service (get-service IMobileProtectService service-url)]
    (.notifyMobileProtectUser service user-id message-content)))

(defn user-all-level
  "获得用户总级别信息"
  {:service :levelService}
  [service-url username]
  (let [^ILevelService service (get-service ILevelService service-url)
        level (.getUserAllLevel service username)]
    (bean-without-class level)))

(defn user-pets
  "获得用户宠物信息"
  {:service :petService}
  [service-url username]
  (let [^IPetService service (get-service IPetService service-url)
        pets (.getUserPets service username)]
    (for [idx (range 0 (count pets))]
      (bean-without-class (aget pets idx)))))

(defn change-pet-name
  "修改用户宠物昵称"
  {:service :petService}
  [service-url username game-type pet-name]
  (let [^IPetService service (get-service IPetService service-url)]
    (.changePetName service username game-type pet-name)
    (user-pets service-url username)))

(defn user-reg
  "用户注册基本信息"
  {:service :userService}
  [service-url username password image]
  (let [^IUserService service (get-service IUserService service-url)
        #^ImageBean image-bean (gen-image-bean image)
        info (doto (UserRegisterInfoBean.)
               (.setUsername username)
               (.setPassword password)
               (.setImage image-bean))]
    (.register service info)))

(defn user-protect-account
  "设置用户帐号保护资料"
  {:service :accountProtectionService}
  [service-url username  protection-info]
  (let [^IAccountProtectionService service
	(get-service IAccountProtectionService service-url)
        #^ProtectionInfoBean protection-bean (gen-protection-info-bean protection-info)]
    (.protectAccount service username protection-bean)))

(defn user-reset-protect
  "重置用户帐号保护资料"
  {:service :accountProtectionService}
  [service-url username]
  (let [^IAccountProtectionService service
        (get-service IAccountProtectionService service-url)]
    (.resetProtectionInfo service username)))

(defn user-idno-realname-validation
  "推送实名认证服务"
  {:service :nameValidationService}
  [service-url username id-number realname]
  (let [^IRealNameValidationService service
        (get-service IRealNameValidationService service-url)]
    (.pushIdentityNumAndNameToValidation service username id-number realname)))

(defn user-passed-validation?
  "实名验证是否已经通过验证，true 通过 false 没有通过 能进入游戏认证通过，不能进入游戏认证未通过"
  {:service :nameValidationService}
  [service-url username]
  (let [^IRealNameValidationService service
        (get-service IRealNameValidationService service-url)]
    (.checkUserIsContinueGame service username)))

(defn get-identity-num-to-validation-bean
  "查询实名验证的各种状态数据
   没有记录时 抛出NoSuchUserException
   没有记录 可当作是验证通过"
  {:service :nameValidationService}
  [service-url username]
  (let [^IRealNameValidationService service
        (get-service IRealNameValidationService service-url)
        info (.getIdentityNumToValidationBean service username)]
    (bean-without-class info)))

(defn user-update-idno-realname-validation
  "更新实名认证身份证和真实姓名，返回result==-2你的实名认证期限已过，result>0你还剩下次实名认证result修改的机会 result==-3数据更新异常"
  {:service :nameValidationService}
  [service-url username id-number realname]
  (let [^IRealNameValidationService service
        (get-service IRealNameValidationService service-url)]
    (.updateIdentityNumAndName service username id-number realname)))

(defn is-open-kk?
  "FIXME:看看服务初始上线不是对所有用户开放的，要检查是否存在在joinPenson中，现在已经对所有用户开放了，这个逻辑也可以去掉了
   return joinPensons.isEmpty() || joinPensons.contains(username)"
  {:service :userInfoRefresherService}
  [service-url username]
  (let [^IUserInfoRefresher service
        (get-service IUserInfoRefresher service-url)]
    (.isOpenKk service username)))

(defn user-info-changed
  "如果KK中用户存在，更新用户信息[user.home,user.team,user.face,user.male,user.levels,user.friends,user.teams]"
  {:service :userInfoRefresherService}
  [service-url username]
  (let [^IUserInfoRefresher service
        (get-service IUserInfoRefresher service-url)]
    (.userInfoChanged service username)))

(defn team-member-info
  "获取工会成员信息,返回nil or TeamMemberInfoBean"
  {:service :teamAdminService}
  [service-url username]
  (let [^ITeamAdminService service
        (get-service ITeamAdminService service-url)]
    (.getTeamMemberInfo service username)))

(defn team-info
  "获取工会信息,返回 nil or TeamInfoBean"
  {:service :teamAdminService}
  [service-url team-name]
  (let [^ITeamAdminService service
        (get-service ITeamAdminService service-url)]
    (.getTeamByName service team-name)))

(defn last-king-info
  {:service :kingRaceDataService}
  [service-url game-sign]
  (let [^IKingRaceDataService service (get-service IKingRaceDataService service-url)]
    ;(println (str "LastKingInfo:" game-sign (.getLastKingInfo service game-sign)))
    (when-let [^LastKingInfo lastKingInfo (.getLastKingInfo service game-sign)]
          ;(println (.getTeamName lastKingInfo))
          (bean lastKingInfo))))

(defn has-kingrace-mission
  {:service :kingRaceDataService}
  [service-url game-sign]
  (let [^IKingRaceDataService service (get-service IKingRaceDataService service-url)]
    (.hasMission service game-sign)))

(defn query-current-mission
  {:service :kingRaceDataService}
  [service-url game-sign]
  (let [^IKingRaceDataService service (get-service IKingRaceDataService service-url)]
    (.queryCurrentMission service game-sign)))

(defn get-not-active-device-certain-days
  "查询一定天数没有活动的用户"
  {:service :deviceTokenService}
  [service-url days appid]
  (let [^IDeviceTokenService service (get-service IDeviceTokenService service-url)]
    (map bean-without-class (seq (.getDeivceNotUsedInCertainTime service days appid)))))

(defn get-ios-user-last-active-time
  "获取ios 用户最近一次的活动时间"
  {:service :deviceTokenService}
  [service-url username]
  (let [^IDeviceTokenService service (get-service IDeviceTokenService service-url)]
    (.getLastActiveTime service username)))

(defn get-device-info
  "获取ios 用户的设备信息"
  {:service :deviceTokenService}
  [service-url username]
  (let [^IDeviceTokenService service (get-service IDeviceTokenService service-url)]
    (bean-without-class (.getDviceTokenByHjdUserName service username))))

(defn get-game-center-friends
  "获取ios 用户的gamecenter 好友列表"
  {:service :gameCenterService}
  [service-url username]
  (let [^IGameCenterService service (get-service IGameCenterService service-url)]
      (seq (.getFriendListOfGameCenterByHjdName service username))))

(defn get-device-under-version
  "获取低于某版本的设备"
  {:service :deviceTokenService}
  [service-url version appid]
  (let [^IDeviceTokenService service (get-service IDeviceTokenService service-url)]
    (map bean-without-class (seq (.getDevicesUnderVersion service version appid)))))

(defn coin-value-limit-of-user-id
  "查询用户当月已充值金币,如果没有记录返回nil"
  {:service :monthLimitPayService}
  [service-url user-id]
  (let [^IMonthLimitPayService service (get-service IMonthLimitPayService service-url)
        coin-value-bean (.findCoinValueLimitByUserId service user-id)]
    (when coin-value-bean
      (bean-without-class coin-value-bean))))

(defn save-user-coin-value
  "保存当月已充值金币"
  {:service :monthLimitPayService}
  [service-url user-id pay-coin-value]
  (let [^IMonthLimitPayService service (get-service IMonthLimitPayService service-url)
        coin-value-bean (.findCoinValueLimitByUserId service user-id)]
    (->> (if coin-value-bean
           (doto coin-value-bean
             (.setCoinValue (+ pay-coin-value (.getCoinValue coin-value-bean))))
           (doto (CoinValueLimitBean.)
                 (.setUserId user-id)
                 (.setCoinValue pay-coin-value)))
         (.saveUserCoinValue service))
    (bean-without-class (.findCoinValueLimitByUserId service user-id))))

(defn create-pay-order
  "充值中心创建支付订单，仅适用于非短信电话渠道。返回order-id"
  {:service :orderService}
  [service-url username card-code num from-channel]
  (let [^IOrderService service (get-service IOrderService service-url)]
    (.createOrder service username card-code num from-channel)))

(defn order-of-id
  "根据订单号查询订单信息,如果找不到订单会抛出异常"
  {:service :orderService}
  [service-url order-id]
  (let [^IOrderService service (get-service IOrderService service-url)]
    (bean-without-class (.findOrderById service order-id))))

(defn setup-order-status
  "更新数据库中的订单状态,将状态n改成y，如果找不到订单会抛出异常"
  {:service :orderService}
  [service-url order-id status]
  (let [^IOrderService service (get-service IOrderService service-url)]
    (.setupOrderStatus service order-id status)
    (bean-without-class (.findOrderById service order-id))))

(defn deposite-vip-cent
  "充值成功后需要给会员加上积分"
  {:service :handleVipCentService}
  [service-url user-id coin-value from-channel]
  (let [^IHandleVipCentService service (get-service IHandleVipCentService service-url)]
    (.depositeVipCent service user-id coin-value from-channel)))

(defn get-wucaichou
  "获取3D玩家的五彩筹"
  {:service :user3DAccountService}
  [service-url username]
  (let [^IUser3DAccountService service (get-service IUser3DAccountService service-url)]
    (.getWucaichouBalance service username)))

(defn get-shayuan
  "获取3D玩家的沙圆"
  {:service :user3DAccountService}
  [service-url username]
  (let [^IUser3DAccountService service (get-service IUser3DAccountService service-url)]
    (.getShayuanBalance service username)))

(defn change-wucaichou
  "修改3D玩家的五彩筹"
  {:service :user3DAccountService}
  [service-url username money-change]
  (let [^IUser3DAccountService service (get-service IUser3DAccountService service-url)]
    (.changeWucaichou service username money-change)))

(defn change-shayuan
  "修改3D玩家的沙圆"
  {:service :user3DAccountService}
  [service-url username money-change]
  (let [^IUser3DAccountService service (get-service IUser3DAccountService service-url)]
    (.changeShayuan service username money-change)))

(defn is-available-mobile-phone
  "是否合法的充值号码（符合充值限制）"
  {:service :ydMobileLimitService}
  [service-url user-id mobile]
  (let [^IYdMobileLimitService service (get-service IYdMobileLimitService service-url)]
    (try
      (let [result (.isAvailableMobilePhone service user-id mobile)]
        result)
      (catch Exception e false))))

(defn add-mobile-phone
  "添加充值用户手机号信息"
  {:service :ydMobileLimitService}
  [service-url user-id mobile]
  (let [^IYdMobileLimitService service (get-service IYdMobileLimitService service-url)]
    (.addMobilePhone service user-id mobile)))

;;examples
;;(all-3d-servers "rmi://192.168.0.111:2399/hjd3DServerService")
;;(get-shayuan "rmi://192.168.0.111:2398/user3DAccountService"  "158")
;;(change-wucaichou "rmi://192.168.0.111:2398/user3DAccountService"  "158" 1000)
;;(get-wucaichou "rmi://192.168.0.111:2398/user3DAccountService"  "158")
;;(get-identity-num-to-validation-bean "rmi://192.168.0.111:1379/nameValidationService" "sdds")
;;(change-exp "rmi://192.168.0.111:1399/levelService" "测试650" "DDZ" 100)
;;(get-service IAuthenticateService "rmi://192.168.0.136:1399/authenticateService");;(login "rmi://192.168.0.136:1399/authenticateService" "测试114" (.toLowerCase "E0C10F451217B93F76C2654B2B729B85"))
;;(user-level "rmi://192.168.0.136:1399/levelService" "测试114" "DDZ")
;;(friend-list "rmi://192.168.0.136:1399/friendService" "测试114")
;;(all-servers "rmi://192.168.0.136:1399/serverService")
;;(protection-info "rmi://192.168.0.136:1399/accountProtectionService" "测试114")
;;(bank-balance "rmi://192.168.0.136:1399/bankService" "测试114")
;;(user-region "rmi://192.168.0.136:1399/regionService" "测试114")
;;(authenticate "rmi://192.168.0.111:1399/authenticateService" "marxpane" (.toLowerCase "E0C10F451217B93F76C2654B2B729B85"))
;;(user-pets "rmi://192.168.0.111:1399/petService" "测试650")
;;(change-pet-name "rmi://192.168.0.111:1399/petService" "测试650" "CDD" "小黑")
;;(user-info "rmi://192.168.0.111:1399/userService" "marxpane")
;;(user-reg  "rmi://192.168.0.111:1399/userService" "marxpane31" "111aaa" {:bodyIndex -1, :decoratorIndex 0, :faceIndex -126, :hairIndex -127, :hairIndex2 -127, :male false})
;;(user-protect-account "rmi://192.168.0.111:1399/accountProtectionService" "marxpane31" {:idNumber "4202122133443332" :realName "tjy" :secondPassword "222aaa" })
;;(user-reset-protect "rmi://192.168.0.111:1399/accountProtectionService" "marxpane31")
;;(is-open-kk? "rmi://192.168.0.111:1600/userInfoRefresher" "测试650")
;;(user-info-changed "rmi://192.168.0.111:1600/userInfoRefresher" "测试650")
;;(last-king-info "rmi://192.168.0.111:1599/kingRaceDataService" "DDZ")
;;(team-member-info "rmi://192.168.0.71:1599/teamAdminService" "测试114")
;;(has-kingrace-mission "rmi://192.168.0.71:1599/kingRaceDataService" "DDZ")
;;(query-current-mission "rmi://192.168.0.71:1599/kingRaceDataService" "DDZ")
;; (get-not-active-device-certain-days "rmi://192.168.0.111:1899/deviceTokenService" 10 "IPADDDZ")
;;(get-device-under-version "rmi://192.168.0.111:1899/deviceTokenService" "4.00" "IPADDDZ")

;;(coin-value-limit-of-user-id "rmi://192.168.0.111:1499/monthLimitPayService" 159)
;;(save-user-coin-value  "rmi://192.168.0.111:1499/monthLimitPayService" 159 20000)
;;(create-pay-order "rmi://192.168.0.111:1499/orderService" "marxpane" 27 1 "test")
;;(order-of-id "rmi://192.168.0.111:1499/orderService" 159)
;;(setup-order-status "rmi://192.168.0.111:1499/orderService" 179 "y")
;;(deposite-vip-cent "rmi://192.168.0.111:1499/handleVipCentService" 159 10000000 "sfpay")
