(ns rmi-service.simple
  (:require [rmi-service.client]
            [rmi-service.utils :as utils]
            [rmi-config]
            [clojure.tools.logging :as log]))

;;users use this unit can use all the function in the rmi-client
;;without the first parameters service-url

(defn mk-new-function!
  "定义同名的函数，去掉第一个参数"
  [name var-fn]
  (eval
   `(def ~name
         (partial ~var-fn
                  (utils/get-url-of-varfn rmi-config/config ~var-fn)))))

(defn partial-service
  "make new function that invoke rmi-client function
   without the service_url parameter
   service_url comes from config file
   make it convient to use."
  [sym-ns]
  (let [fs (ns-publics sym-ns)
        simple-filter-fn (fn [[name func]] (utils/has-simple-config? rmi-config/config func))
        to-simple-fs (filter simple-filter-fn fs)
        none-simple-fs (remove simple-filter-fn fs)]
    (log/info 'to-simple-fs to-simple-fs 'none-simple-fs none-simple-fs)
    (map (fn [ [name func] ] (mk-new-function! (symbol name) func))
          to-simple-fs)))

;;定义rmi-service.client 中对应的partial 函数
;;use dorun to make it don't lazy
(dorun (partial-service 'rmi-service.client))

