(ns hoplon.indexed-db
  (:require [javelin.core :as j]
            [hoplon.indexed-db.factory :as factory]
            [hoplon.indexed-db.opendbrequest :as req]
            [hoplon.indexed-db.database :as db]
            [hoplon.indexed-db.transaction :as tx])
  (:require-macros hoplon.indexed-db))

(def indexedDB (.-indexedDB js/window))

(def open-database (partial factory/open indexedDB))

(def database-error req/onerror)

(def database-success req/onsuccess)

(def database-upgrade req/onupgradeneeded)

(def object-store tx/objectStore)

(def object-stores db/objectStoreNames)

(def create-store db/createObjectStore)

(def delete-store db/deleteObjectStore)

(def transaction db/transaction)
