(ns hoplon.indexed-db
  (:require [javelin.core :as j]
            [hoplon.indexed-db.factory :as factory]
            [hoplon.indexed-db.opendbrequest :as req]
            [hoplon.indexed-db.database :as db]
            [hoplon.indexed-db.transaction :as tx])
  (:require-macros hoplon.indexed-db))

(def indexedDB (.-indexedDB js/window))

(def open-database (partial factory/open indexedDB))

(def upgrade-database req/onupgradeneeded)

(defn create-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store stores]
      (when-not (.contains current store)
        (db/createObjectStore db store)))))

(defn delete-stores [db stores]
  (let [current (db/objectStoreNames db)]
    (doseq [store current]
      (when-not (contains? (set stores) store)
        (db/deleteObjectStore db store)))))

(defn get-result [event]
  (.-result (.-target event)))

(defn when-success [tx callback]
  (.addEventListener tx "success" callback))

(defn when-error [tx callback]
  (.addEventListener tx "error" callback))

(defn when-upgrading [tx callback]
  (.addEventListener tx "upgradeneeded" callback))

(defn object-store= [db store key]
  (let [ostore (j/cell nil)
        ostore! (partial reset! ostore)]
    (when-success db
      (fn [event]
        (let [store (-> event (get-result) (db/transaction store) (tx/objectStore store))]
          (when-success (.get store key)
            (fn [event]
              (let [result (get-result event)]
                (ostore! (js->clj result :keywordize-keys true))))))))
    (j/cell= ostore
      (fn [val]
        (when-success db
          (fn [event]
            (let [store (-> event (get-result) (db/transaction store "readwrite") (tx/objectStore store))]
              (when-success (.put store val key)
                (fn [event]
                  (let [result (get-result event)]
                    (ostore! (js->clj result :keywordize-keys true))))))))))))
