/*
 * Decompiled with CFR 0.152.
 */
package hoptoad;

import hoptoad.BacktraceLine;
import hoptoad.ValidBacktraces;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Backtrace
implements Iterable<String> {
    private final List<String> backtrace = new LinkedList<String>();
    private final List<String> ignoreRules = new LinkedList<String>();
    private final List<String> filteredBacktrace = new LinkedList<String>();

    protected Backtrace() {
    }

    public Backtrace(List<String> backtrace) {
        this.backtrace.addAll(backtrace);
        this.ignore();
        this.filter();
    }

    public Backtrace(Throwable throwable) {
        this.toBacktrace(throwable);
        this.ignore(".*" + Pattern.quote(this.messageIn(throwable)) + ".*");
        this.ignore();
        this.filter();
    }

    private String causedBy(Throwable throwable) {
        return MessageFormat.format("Caused by {0}", this.messageIn(throwable));
    }

    protected void filter() {
        this.filter(this.backtrace);
    }

    private final List<String> filter(List<String> backtrace) {
        ListIterator<String> iterator = backtrace.listIterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.mustBeIgnored(string)) continue;
            if (ValidBacktraces.notValidBacktrace(string)) {
                string = this.removeDobuleDot(string);
            }
            this.filteredBacktrace.add(string);
        }
        return this.filteredBacktrace;
    }

    protected void ignore() {
        this.ignoreEmptyCause();
    }

    protected void ignore(String ignoreRule) {
        this.ignoreRules.add(ignoreRule);
    }

    protected void ignoreCocoon() {
        this.ignore(".*org.apache.cocoon.components.expression.*");
        this.ignore(".*org.apache.cocoon.template.script.*");
        this.ignore(".*org.apache.cocoon.template.instruction.*");
        this.ignore(".*org.apache.cocoon.template.JXTemplateGenerator.*");
        this.ignore(".*org.apache.cocoon.components.pipeline.AbstractProcessingPipeline.*");
        this.ignore(".*org.apache.cocoon.components.treeprocessor.*");
        this.ignore(".*org.apache.cocoon.environment.ForwardRedirector.*");
        this.ignore(".*org.apache.cocoon.components.flow.AbstractInterpreter.*");
        this.ignore(".*org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptInterpreter.*");
        this.ignore(".*org.apache.cocoon.components.flow.javascript.fom.FOM_Cocoon.*");
        this.ignore(".*org.apache.commons.jexl.util.introspection.*");
        this.ignore(".*org.apache.commons.jexl.parser.ASTMethod.*");
        this.ignore(".*org.apache.commons.jexl.parser.ASTReference.*");
        this.ignore(".*org.apache.commons.jexl.ExpressionImpl.*");
        this.ignore(".*org.apache.cocoon.template.expression.*");
        this.ignore(".*org.apache.cocoon.Cocoon.*");
        this.ignore(".*org.apache.cocoon.servlet.*");
    }

    protected void ignoreEclipse() {
        this.ignore(".*org.eclipse.jdt.internal.junit4.runner.*");
        this.ignore(".*org.eclipse.jdt.internal.junit.runner.*");
    }

    private void ignoreEmptyCause() {
        this.ignore("^Caused by $");
    }

    protected void ignoreJunit() {
        this.ignore(".*.*org.junit.internal.runners.*");
    }

    protected void ignoreMortbayJetty() {
        this.ignore(".*org.mortbay.jetty.handler.ContextHandlerCollection.*");
        this.ignore(".*org.mortbay.jetty.handler.ContextHandler.*");
        this.ignore(".*org.mortbay.jetty.handler.HandlerCollection.*");
        this.ignore(".*org.mortbay.jetty.handler.HandlerWrapper.*");
        this.ignore(".*org.mortbay.jetty.HttpConnection.*");
        this.ignore(".*org.mortbay.jetty.HttpParser.*");
        this.ignore(".*org.mortbay.jetty.security.SecurityHandler.*");
        this.ignore(".*org.mortbay.jetty.Server.*");
        this.ignore(".*org.mortbay.jetty.servlet.ServletHandler.*");
        this.ignore(".*org.mortbay.jetty.servlet.ServletHolder.*");
        this.ignore(".*org.mortbay.jetty.servlet.SessionHandler.*");
        this.ignore(".*org.mortbay.jetty.webapp.WebAppContext.*");
        this.ignore(".*org.mortbay.io.nio.*");
        this.ignore(".*org.mortbay.thread.*");
    }

    protected void ignoreMozilla() {
        this.ignore(".*org.mozilla.javascript.FunctionObject.*");
        this.ignore(".*org.mozilla.javascript.ScriptRuntime.*");
        this.ignore(".*org.mozilla.javascript.continuations.*");
        this.ignore(".*org.mozilla.javascript.ScriptRuntime.*");
        this.ignore(".*org.mozilla.javascript.ScriptableObject.*");
        this.ignore(".*org.mozilla.javascript.FunctionObject.*");
    }

    protected void ignoreNoise() {
        this.ignore(".*inv1.invoke.*");
        this.ignore(".*javax.servlet.http.HttpServlet.*");
        this.ignore(".*sun.reflect.*");
        this.ignore(".*java.lang.reflect.Method.*");
    }

    protected void ignoreSpringSecurity() {
        this.ignore(".*org.springframework.security.context.HttpSessionContextIntegrationFilter.*");
        this.ignore(".*org.springframework.security.intercept.web.FilterSecurityInterceptor.*");
        this.ignore(".*org.springframework.security.providers.anonymous.AnonymousProcessingFilter.*");
        this.ignore(".*org.springframework.security.ui.AbstractProcessingFilter.*");
        this.ignore(".*org.springframework.security.ui.basicauth.BasicProcessingFilter.*");
        this.ignore(".*org.springframework.security.ui.ExceptionTranslationFilter.*");
        this.ignore(".*org.springframework.security.ui.logout.LogoutFilter.*");
        this.ignore(".*org.springframework.security.ui.rememberme.RememberMeProcessingFilter.*");
        this.ignore(".*org.springframework.security.ui.SessionFixationProtectionFilter.*");
        this.ignore(".*org.springframework.security.ui.SpringSecurityFilter.*");
        this.ignore(".*org.springframework.security.util.FilterChainProxy.*");
        this.ignore(".*org.springframework.security.wrapper.SecurityContextHolderAwareRequestFilter.*");
        this.ignore(".*org.springframework.web.filter.DelegatingFilterProxy.*");
    }

    @Override
    public Iterator<String> iterator() {
        if (this.needToBeFiltered()) {
            this.filter(this.backtrace);
        }
        return this.filteredBacktrace.iterator();
    }

    private String messageIn(Throwable throwable) {
        String message = throwable.getMessage();
        if (message == null) {
            message = throwable.getClass().getName();
        }
        return message;
    }

    private boolean mustBeIgnored(String string) {
        for (String ignore : this.ignoreRules) {
            if (!string.matches(ignore)) continue;
            return true;
        }
        return false;
    }

    private boolean needToBeFiltered() {
        return this.filteredBacktrace.isEmpty();
    }

    public Backtrace newBacktrace(Throwable throwable) {
        return new Backtrace(throwable);
    }

    private String removeDobuleDot(String string) {
        return string.replaceAll(":", "");
    }

    private String toBacktrace(StackTraceElement element) {
        return this.toBacktrace(element.getClassName(), element.getFileName(), element.getLineNumber(), element.getMethodName());
    }

    protected String toBacktrace(String className, String fileName, int lineNumber, String methodName) {
        return new BacktraceLine(className, fileName, lineNumber, methodName).toString();
    }

    private void toBacktrace(Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.backtrace.add(this.causedBy(throwable));
        for (StackTraceElement element : throwable.getStackTrace()) {
            this.backtrace.add(this.toBacktrace(element));
        }
        this.toBacktrace(throwable.getCause());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.filteredBacktrace) {
            stringBuilder.append(string).append("\n");
        }
        return stringBuilder.toString();
    }
}

