/*
 * Decompiled with CFR 0.152.
 */
package hoptoad;

import hoptoad.BacktraceLine;
import hoptoad.HoptoadNotice;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoticeApi2 {
    private final StringBuilder stringBuilder = new StringBuilder();

    public NoticeApi2(HoptoadNotice notice) {
        this.notice("2.0");
        this.apikey(notice);
        this.notifier();
        this.name("hoptoad");
        this.version("1.7-socrata-SNAPSHOT");
        this.url("http://hoptoad.googlecode.com");
        this.end("notifier");
        this.error();
        this.tag("class", notice.errorClass());
        this.tag("message", notice.errorMessage());
        this.backtrace();
        for (String backtrace : notice.backtrace()) {
            this.line(backtrace);
        }
        this.end("backtrace");
        this.end("error");
        if (notice.hasRequest()) {
            this.addRequest(notice);
        }
        this.server_environment();
        this.tag("project-root", notice.projectRoot());
        this.tag("environment-name", notice.env());
        this.end("server-environment");
        this.end("notice");
    }

    private void addRequest(HoptoadNotice notice) {
        this.request();
        this.tag("url", notice.url());
        this.tag("component", notice.component());
        this.vars("params", notice.request());
        this.vars("session", notice.session());
        this.vars("cgi-data", notice.environment());
        this.end("request");
    }

    private void vars(String sectionName, Map<String, Object> vars) {
        if (vars.isEmpty()) {
            return;
        }
        this.tag(sectionName);
        for (Map.Entry<String, Object> var : vars.entrySet()) {
            this.append("<var key=\"" + var.getKey() + "\">");
            this.text(var.getValue().toString());
            this.append("</var>");
        }
        this.end(sectionName);
    }

    private void request() {
        this.tag("request");
    }

    private void apikey(HoptoadNotice notice) {
        this.tag("api-key");
        this.append(notice.apiKey());
        this.end("api-key");
    }

    private void append(String str) {
        this.stringBuilder.append(str);
    }

    private void backtrace() {
        this.tag("backtrace");
    }

    private void end(String string) {
        this.append("</" + string + ">");
    }

    private void error() {
        this.tag("error");
    }

    private void server_environment() {
        this.tag("server-environment");
    }

    private void line(String backtrace) {
        this.append(new BacktraceLine(backtrace).toXml());
    }

    private void name(String name) {
        this.tag("name", name);
    }

    private void notice(String string) {
        this.append("<?xml version=\"1.0\"?>");
        this.append("<notice version=\"" + string + "\">");
    }

    private void notifier() {
        this.tag("notifier");
    }

    private NoticeApi2 tag(String string) {
        this.append("<" + string + ">");
        return this;
    }

    private void tag(String string, String contents) {
        this.tag(string).text(contents).end(string);
    }

    private NoticeApi2 text(String string) {
        this.append(StringEscapeUtils.escapeXml((String)string));
        return this;
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    private void url(String url) {
        this.tag("url", url);
    }

    private void version(String version) {
        this.tag("version", version);
    }
}

