// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.9.518";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if(typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined'){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
if(typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = (function cljs$core$_STAR_print_err_fn_STAR_(_){
throw (new Error("No *print-err-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__10225__delegate = function (args){
return console.log.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__10225 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10226__i = 0, G__10226__a = new Array(arguments.length -  0);
while (G__10226__i < G__10226__a.length) {G__10226__a[G__10226__i] = arguments[G__10226__i + 0]; ++G__10226__i;}
  args = new cljs.core.IndexedSeq(G__10226__a,0);
} 
return G__10225__delegate.call(this,args);};
G__10225.cljs$lang$maxFixedArity = 0;
G__10225.cljs$lang$applyTo = (function (arglist__10227){
var args = cljs.core.seq(arglist__10227);
return G__10225__delegate(args);
});
G__10225.cljs$core$IFn$_invoke$arity$variadic = G__10225__delegate;
return G__10225;
})()
;

cljs.core._STAR_print_err_fn_STAR_ = (function() { 
var G__10228__delegate = function (args){
return console.error.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__10228 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10229__i = 0, G__10229__a = new Array(arguments.length -  0);
while (G__10229__i < G__10229__a.length) {G__10229__a[G__10229__i] = arguments[G__10229__i + 0]; ++G__10229__i;}
  args = new cljs.core.IndexedSeq(G__10229__a,0);
} 
return G__10228__delegate.call(this,args);};
G__10228.cljs$lang$maxFixedArity = 0;
G__10228.cljs$lang$applyTo = (function (arglist__10230){
var args = cljs.core.seq(arglist__10230);
return G__10228__delegate(args);
});
G__10228.cljs$core$IFn$_invoke$arity$variadic = G__10228__delegate;
return G__10228;
})()
;

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return (typeof x === 'string') && (((1) === x.length));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__7277__auto__ = ty;
if(cljs.core.truth_(and__7277__auto__)){
return ty.cljs$lang$type;
} else {
return and__7277__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4655__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4655__auto__)){
var s = temp__4655__auto__;
return s;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && ((goog.typeOf(Symbol) === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((typeof performance !== 'undefined') && (!((performance.now == null)))){
return performance.now();
} else {
if((typeof process !== 'undefined') && (!((process.hrtime == null)))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var args10231 = [];
var len__8402__auto___10237 = arguments.length;
var i__8403__auto___10238 = (0);
while(true){
if((i__8403__auto___10238 < len__8402__auto___10237)){
args10231.push((arguments[i__8403__auto___10238]));

var G__10239 = (i__8403__auto___10238 + (1));
i__8403__auto___10238 = G__10239;
continue;
} else {
}
break;
}

var G__10236 = args10231.length;
switch (G__10236) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10231.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__8212__auto___10241 = dimarray.length;
var i_10242 = (0);
while(true){
if((i_10242 < n__8212__auto___10241)){
(dimarray[i_10242] = (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims) : cljs.core.apply.call(null,cljs.core.make_array,null,dims)));

var G__10243 = (i_10242 + (1));
i_10242 = G__10243;
continue;
} else {
}
break;
}

return dimarray;
});

cljs.core.make_array.cljs$lang$applyTo = (function (seq10232){
var G__10233 = cljs.core.first(seq10232);
var seq10232__$1 = cljs.core.next(seq10232);
var G__10234 = cljs.core.first(seq10232__$1);
var seq10232__$2 = cljs.core.next(seq10232__$1);
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic(G__10233,G__10234,seq10232__$2);
});

cljs.core.make_array.cljs$lang$maxFixedArity = (2);

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__8212__auto___10244 = len;
var i_10245 = (0);
while(true){
if((i_10245 < n__8212__auto___10244)){
(new_arr[i_10245] = (arr[i_10245]));

var G__10246 = (i_10245 + (1));
i_10245 = G__10246;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__10247 = (i + (1));
i = G__10247;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var args10248 = [];
var len__8402__auto___10257 = arguments.length;
var i__8403__auto___10258 = (0);
while(true){
if((i__8403__auto___10258 < len__8402__auto___10257)){
args10248.push((arguments[i__8403__auto___10258]));

var G__10259 = (i__8403__auto___10258 + (1));
i__8403__auto___10258 = G__10259;
continue;
} else {
}
break;
}

var G__10253 = args10248.length;
switch (G__10253) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10248.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__10254 = cljs.core.aget;
var G__10255 = (array[i]);
var G__10256 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__10254,G__10255,G__10256) : cljs.core.apply.call(null,G__10254,G__10255,G__10256));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq10249){
var G__10250 = cljs.core.first(seq10249);
var seq10249__$1 = cljs.core.next(seq10249);
var G__10251 = cljs.core.first(seq10249__$1);
var seq10249__$2 = cljs.core.next(seq10249__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__10250,G__10251,seq10249__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);

/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var args10261 = [];
var len__8402__auto___10272 = arguments.length;
var i__8403__auto___10273 = (0);
while(true){
if((i__8403__auto___10273 < len__8402__auto___10272)){
args10261.push((arguments[i__8403__auto___10273]));

var G__10274 = (i__8403__auto___10273 + (1));
i__8403__auto___10273 = G__10274;
continue;
} else {
}
break;
}

var G__10267 = args10261.length;
switch (G__10267) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10261.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__10268 = cljs.core.aset;
var G__10269 = (array[idx]);
var G__10270 = idx2;
var G__10271 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__10268,G__10269,G__10270,G__10271) : cljs.core.apply.call(null,G__10268,G__10269,G__10270,G__10271));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq10262){
var G__10263 = cljs.core.first(seq10262);
var seq10262__$1 = cljs.core.next(seq10262);
var G__10264 = cljs.core.first(seq10262__$1);
var seq10262__$2 = cljs.core.next(seq10262__$1);
var G__10265 = cljs.core.first(seq10262__$2);
var seq10262__$3 = cljs.core.next(seq10262__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__10263,G__10264,G__10265,seq10262__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var args10276 = [];
var len__8402__auto___10282 = arguments.length;
var i__8403__auto___10283 = (0);
while(true){
if((i__8403__auto___10283 < len__8402__auto___10282)){
args10276.push((arguments[i__8403__auto___10283]));

var G__10284 = (i__8403__auto___10283 + (1));
i__8403__auto___10283 = G__10284;
continue;
} else {
}
break;
}

var G__10278 = args10276.length;
switch (G__10278) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10276.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__10279 = (function (a,x){
a.push(x);

return a;
});
var G__10280 = [];
var G__10281 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__10279,G__10280,G__10281) : cljs.core.reduce.call(null,G__10279,G__10280,G__10281));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__8409__auto__ = [];
var len__8402__auto___10289 = arguments.length;
var i__8403__auto___10290 = (0);
while(true){
if((i__8403__auto___10290 < len__8402__auto___10289)){
args__8409__auto__.push((arguments[i__8403__auto___10290]));

var G__10291 = (i__8403__auto___10290 + (1));
i__8403__auto___10290 = G__10291;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq10286){
var G__10287 = cljs.core.first(seq10286);
var seq10286__$1 = cljs.core.next(seq10286);
var G__10288 = cljs.core.first(seq10286__$1);
var seq10286__$2 = cljs.core.next(seq10286__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__10287,G__10288,seq10286__$2);
});


/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var args10292 = [];
var len__8402__auto___10295 = arguments.length;
var i__8403__auto___10296 = (0);
while(true){
if((i__8403__auto___10296 < len__8402__auto___10295)){
args10292.push((arguments[i__8403__auto___10296]));

var G__10297 = (i__8403__auto___10296 + (1));
i__8403__auto___10296 = G__10297;
continue;
} else {
}
break;
}

var G__10294 = args10292.length;
switch (G__10294) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10292.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$1 == null)))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7958__auto__.call(null,this$));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7958__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$2 == null)))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7958__auto__.call(null,this$,a));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__7958__auto____$1.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$3 == null)))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7958__auto__.call(null,this$,a,b));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__7958__auto____$1.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$4 == null)))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7958__auto__.call(null,this$,a,b,c));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__7958__auto____$1.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$5 == null)))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7958__auto__.call(null,this$,a,b,c,d));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__7958__auto____$1.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$6 == null)))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$6 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7958__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__7958__auto____$1.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$7 == null)))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$7 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7958__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$8 == null)))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$8 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$9 == null)))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$9 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$10 == null)))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$10 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$11 == null)))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$11 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$12 == null)))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$12 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$13 == null)))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$13 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$14 == null)))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$14 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$15 == null)))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$15 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$16 == null)))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$16 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$17 == null)))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$17 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$18 == null)))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$18 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$19 == null)))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$19 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$20 == null)))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$20 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$21 == null)))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$21 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$22 == null)))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._invoke[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$22 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7958__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__7958__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__7958__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((!((value == null))) && (!((value.cljs$core$ICloneable$_clone$arity$1 == null)))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__7957__auto__ = (((value == null))?null:value);
var m__7958__auto__ = (cljs.core._clone[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__7958__auto__.call(null,value));
} else {
var m__7958__auto____$1 = (cljs.core._clone["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__7958__auto____$1.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((!((coll == null))) && (!((coll.cljs$core$ICounted$_count$arity$1 == null)))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._count[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._count["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._empty[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._empty["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((!((coll == null))) && (!((coll.cljs$core$ICollection$_conj$arity$2 == null)))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._conj[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7958__auto__.call(null,coll,o));
} else {
var m__7958__auto____$1 = (cljs.core._conj["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__7958__auto____$1.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var args10299 = [];
var len__8402__auto___10302 = arguments.length;
var i__8403__auto___10303 = (0);
while(true){
if((i__8403__auto___10303 < len__8402__auto___10302)){
args10299.push((arguments[i__8403__auto___10303]));

var G__10304 = (i__8403__auto___10303 + (1));
i__8403__auto___10303 = G__10304;
continue;
} else {
}
break;
}

var G__10301 = args10299.length;
switch (G__10301) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10299.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._nth[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7958__auto__.call(null,coll,n));
} else {
var m__7958__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__7958__auto____$1.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._nth[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7958__auto__.call(null,coll,n,not_found));
} else {
var m__7958__auto____$1 = (cljs.core._nth["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__7958__auto____$1.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_first$arity$1 == null)))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._first[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._first["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_rest$arity$1 == null)))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._rest[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._rest["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$INext$_next$arity$1 == null)))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._next[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._next["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var args10306 = [];
var len__8402__auto___10309 = arguments.length;
var i__8403__auto___10310 = (0);
while(true){
if((i__8403__auto___10310 < len__8402__auto___10309)){
args10306.push((arguments[i__8403__auto___10310]));

var G__10311 = (i__8403__auto___10310 + (1));
i__8403__auto___10310 = G__10311;
continue;
} else {
}
break;
}

var G__10308 = args10306.length;
switch (G__10308) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10306.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$2 == null)))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._lookup[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__7958__auto__.call(null,o,k));
} else {
var m__7958__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__7958__auto____$1.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$3 == null)))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._lookup[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7958__auto__.call(null,o,k,not_found));
} else {
var m__7958__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__7958__auto____$1.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto__.call(null,coll,k));
} else {
var m__7958__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._assoc[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7958__auto__.call(null,coll,k,v));
} else {
var m__7958__auto____$1 = (cljs.core._assoc["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__7958__auto____$1.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

cljs.core._find = (function cljs$core$_find(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IFind$_find$arity$2 == null)))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._find[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto__.call(null,coll,k));
} else {
var m__7958__auto____$1 = (cljs.core._find["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._dissoc[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto__.call(null,coll,k));
} else {
var m__7958__auto____$1 = (cljs.core._dissoc["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__7958__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._key[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._key["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._val[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._val["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((!((coll == null))) && (!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._disjoin[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7958__auto__.call(null,coll,v));
} else {
var m__7958__auto____$1 = (cljs.core._disjoin["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__7958__auto____$1.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_peek$arity$1 == null)))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._peek[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._peek["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_pop$arity$1 == null)))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._pop[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._pop["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((!((coll == null))) && (!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._assoc_n[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7958__auto__.call(null,coll,n,val));
} else {
var m__7958__auto____$1 = (cljs.core._assoc_n["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__7958__auto____$1.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((!((o == null))) && (!((o.cljs$core$IDeref$_deref$arity$1 == null)))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._deref[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto__.call(null,o));
} else {
var m__7958__auto____$1 = (cljs.core._deref["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((!((o == null))) && (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7958__auto__.call(null,o,msec,timeout_val));
} else {
var m__7958__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__7958__auto____$1.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((!((o == null))) && (!((o.cljs$core$IMeta$_meta$arity$1 == null)))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._meta[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto__.call(null,o));
} else {
var m__7958__auto____$1 = (cljs.core._meta["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((!((o == null))) && (!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._with_meta[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7958__auto__.call(null,o,meta));
} else {
var m__7958__auto____$1 = (cljs.core._with_meta["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__7958__auto____$1.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var args10313 = [];
var len__8402__auto___10316 = arguments.length;
var i__8403__auto___10317 = (0);
while(true){
if((i__8403__auto___10317 < len__8402__auto___10316)){
args10313.push((arguments[i__8403__auto___10317]));

var G__10318 = (i__8403__auto___10317 + (1));
i__8403__auto___10317 = G__10318;
continue;
} else {
}
break;
}

var G__10315 = args10313.length;
switch (G__10315) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10313.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._reduce[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7958__auto__.call(null,coll,f));
} else {
var m__7958__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__7958__auto____$1.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._reduce[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7958__auto__.call(null,coll,f,start));
} else {
var m__7958__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__7958__auto____$1.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((!((coll == null))) && (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7958__auto__.call(null,coll,f,init));
} else {
var m__7958__auto____$1 = (cljs.core._kv_reduce["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__7958__auto____$1.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((!((o == null))) && (!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._equiv[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__7958__auto__.call(null,o,other));
} else {
var m__7958__auto____$1 = (cljs.core._equiv["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__7958__auto____$1.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((!((o == null))) && (!((o.cljs$core$IHash$_hash$arity$1 == null)))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._hash[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto__.call(null,o));
} else {
var m__7958__auto____$1 = (cljs.core._hash["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((!((o == null))) && (!((o.cljs$core$ISeqable$_seq$arity$1 == null)))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._seq[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto__.call(null,o));
} else {
var m__7958__auto____$1 = (cljs.core._seq["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__7958__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((!((coll == null))) && (!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._rseq[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._rseq["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7958__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core._sorted_seq["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__7958__auto____$1.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7958__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__7958__auto____$1.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._entry_key[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7958__auto__.call(null,coll,entry));
} else {
var m__7958__auto____$1 = (cljs.core._entry_key["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__7958__auto____$1.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._comparator[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._comparator["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_write$arity$2 == null)))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__7957__auto__ = (((writer == null))?null:writer);
var m__7958__auto__ = (cljs.core._write[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7958__auto__.call(null,writer,s));
} else {
var m__7958__auto____$1 = (cljs.core._write["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__7958__auto____$1.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_flush$arity$1 == null)))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__7957__auto__ = (((writer == null))?null:writer);
var m__7958__auto__ = (cljs.core._flush[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__7958__auto__.call(null,writer));
} else {
var m__7958__auto____$1 = (cljs.core._flush["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__7958__auto____$1.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((!((o == null))) && (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._pr_writer[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7958__auto__.call(null,o,writer,opts));
} else {
var m__7958__auto____$1 = (cljs.core._pr_writer["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__7958__auto____$1.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((!((x == null))) && (!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
var x__7957__auto__ = (((x == null))?null:x);
var m__7958__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto__.call(null,x));
} else {
var m__7958__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._notify_watches[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7958__auto__.call(null,this$,oldval,newval));
} else {
var m__7958__auto____$1 = (cljs.core._notify_watches["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__7958__auto____$1.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._add_watch[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7958__auto__.call(null,this$,key,f));
} else {
var m__7958__auto____$1 = (cljs.core._add_watch["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__7958__auto____$1.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core._remove_watch[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7958__auto__.call(null,this$,key));
} else {
var m__7958__auto____$1 = (cljs.core._remove_watch["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__7958__auto____$1.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._as_transient[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._as_transient["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7958__auto__.call(null,tcoll,val));
} else {
var m__7958__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__7958__auto____$1.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7958__auto__.call(null,tcoll));
} else {
var m__7958__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7958__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7958__auto__.call(null,tcoll,key,val));
} else {
var m__7958__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__7958__auto____$1.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7958__auto__.call(null,tcoll,key));
} else {
var m__7958__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__7958__auto____$1.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7958__auto__.call(null,tcoll,n,val));
} else {
var m__7958__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__7958__auto____$1.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7958__auto__.call(null,tcoll));
} else {
var m__7958__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__7958__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__7957__auto__ = (((tcoll == null))?null:tcoll);
var m__7958__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7958__auto__.call(null,tcoll,v));
} else {
var m__7958__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__7958__auto____$1.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((!((x == null))) && (!((x.cljs$core$IComparable$_compare$arity$2 == null)))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__7957__auto__ = (((x == null))?null:x);
var m__7958__auto__ = (cljs.core._compare[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__7958__auto__.call(null,x,y));
} else {
var m__7958__auto____$1 = (cljs.core._compare["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__7958__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._drop_first[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._drop_first["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._chunked_first[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._chunked_first["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._chunked_rest["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._chunked_next[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._chunked_next["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_name$arity$1 == null)))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__7957__auto__ = (((x == null))?null:x);
var m__7958__auto__ = (cljs.core._name[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto__.call(null,x));
} else {
var m__7958__auto____$1 = (cljs.core._name["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_namespace$arity$1 == null)))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__7957__auto__ = (((x == null))?null:x);
var m__7958__auto__ = (cljs.core._namespace[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto__.call(null,x));
} else {
var m__7958__auto____$1 = (cljs.core._namespace["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__7958__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7958__auto__.call(null,o,new_value));
} else {
var m__7958__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7958__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var args10320 = [];
var len__8402__auto___10323 = arguments.length;
var i__8403__auto___10324 = (0);
while(true){
if((i__8403__auto___10324 < len__8402__auto___10323)){
args10320.push((arguments[i__8403__auto___10324]));

var G__10325 = (i__8403__auto___10324 + (1));
i__8403__auto___10324 = G__10325;
continue;
} else {
}
break;
}

var G__10322 = args10320.length;
switch (G__10322) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10320.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__7958__auto__.call(null,o,f));
} else {
var m__7958__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__7958__auto____$1.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7958__auto__.call(null,o,f,a));
} else {
var m__7958__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__7958__auto____$1.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7958__auto__.call(null,o,f,a,b));
} else {
var m__7958__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__7958__auto____$1.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$5 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7958__auto__.call(null,o,f,a,b,xs));
} else {
var m__7958__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__7958__auto____$1.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__7957__auto__ = (((o == null))?null:o);
var m__7958__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7958__auto__.call(null,o,new_value));
} else {
var m__7958__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__7958__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((!((coll == null))) && (!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__7957__auto__ = (((coll == null))?null:coll);
var m__7958__auto__ = (cljs.core._iterator[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto__.call(null,coll));
} else {
var m__7958__auto____$1 = (cljs.core._iterator["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__7958__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!((Math.imul((4294967295),(5)) === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__10327 = (i + (2));
var G__10328 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__10327;
h1 = G__10328;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__10331 = (i + (1));
var G__10332 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__10331;
hash = G__10332;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = {};

cljs.core.string_hash_cache_count = (0);
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$)))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__10340 = o;
switch (G__10340) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__7277__auto__ = cljs.core.not(a.ns);
if(and__7277__auto__){
return b.ns;
} else {
return and__7277__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__10348 = a.ns;
var G__10349 = b.ns;
return goog.array.defaultCompare(G__10348,G__10349);
})();
if(((0) === nsc)){
var G__10350 = a.name;
var G__10351 = b.name;
return goog.array.defaultCompare(G__10350,G__10351);
} else {
return nsc;
}
}
} else {
var G__10352 = a.name;
var G__10353 = b.name;
return goog.array.defaultCompare(G__10352,G__10353);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__10355 = null;
var G__10355__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});
var G__10355__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});
G__10355 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__10355__2.call(this,self__,coll);
case 3:
return G__10355__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10355.cljs$core$IFn$_invoke$arity$2 = G__10355__2;
G__10355.cljs$core$IFn$_invoke$arity$3 = G__10355__3;
return G__10355;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args10354){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10354)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__7729__auto__ = self__._hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns a Symbol with the given namespace and name.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var args10356 = [];
var len__8402__auto___10359 = arguments.length;
var i__8403__auto___10360 = (0);
while(true){
if((i__8403__auto___10360 < len__8402__auto___10359)){
args10356.push((arguments[i__8403__auto___10360]));

var G__10361 = (i__8403__auto___10360 + (1));
i__8403__auto___10360 = G__10361;
continue;
} else {
}
break;
}

var G__10358 = args10356.length;
switch (G__10358) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10356.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("#'"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__10364 = this$__$1.sym;
var G__10365 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__10364,G__10365) : cljs.core._EQ_.call(null,G__10364,G__10365));
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
});

cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Var.prototype.call = (function() {
var G__10410 = null;
var G__10410__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});
var G__10410__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});
var G__10410__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});
var G__10410__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});
var G__10410__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});
var G__10410__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});
var G__10410__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});
var G__10410__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});
var G__10410__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});
var G__10410__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});
var G__10410__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__10410__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__10410__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__10410__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__10410__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__10410__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__10410__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__10410__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__10410__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__10410__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__10410__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__10410__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__10366 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__10367 = a;
var G__10368 = b;
var G__10369 = c;
var G__10370 = d;
var G__10371 = e;
var G__10372 = f;
var G__10373 = g;
var G__10374 = h;
var G__10375 = i;
var G__10376 = j;
var G__10377 = k;
var G__10378 = l;
var G__10379 = m;
var G__10380 = n;
var G__10381 = o;
var G__10382 = p;
var G__10383 = q;
var G__10384 = r;
var G__10385 = s;
var G__10386 = t;
var G__10387 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__10366,G__10367,G__10368,G__10369,G__10370,G__10371,G__10372,G__10373,G__10374,G__10375,G__10376,G__10377,G__10378,G__10379,G__10380,G__10381,G__10382,G__10383,G__10384,G__10385,G__10386,G__10387) : cljs.core.apply.call(null,G__10366,G__10367,G__10368,G__10369,G__10370,G__10371,G__10372,G__10373,G__10374,G__10375,G__10376,G__10377,G__10378,G__10379,G__10380,G__10381,G__10382,G__10383,G__10384,G__10385,G__10386,G__10387));
});
G__10410 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__10410__1.call(this,self__);
case 2:
return G__10410__2.call(this,self__,a);
case 3:
return G__10410__3.call(this,self__,a,b);
case 4:
return G__10410__4.call(this,self__,a,b,c);
case 5:
return G__10410__5.call(this,self__,a,b,c,d);
case 6:
return G__10410__6.call(this,self__,a,b,c,d,e);
case 7:
return G__10410__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__10410__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__10410__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__10410__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__10410__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__10410__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__10410__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__10410__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__10410__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__10410__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__10410__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__10410__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__10410__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__10410__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__10410__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__10410__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10410.cljs$core$IFn$_invoke$arity$1 = G__10410__1;
G__10410.cljs$core$IFn$_invoke$arity$2 = G__10410__2;
G__10410.cljs$core$IFn$_invoke$arity$3 = G__10410__3;
G__10410.cljs$core$IFn$_invoke$arity$4 = G__10410__4;
G__10410.cljs$core$IFn$_invoke$arity$5 = G__10410__5;
G__10410.cljs$core$IFn$_invoke$arity$6 = G__10410__6;
G__10410.cljs$core$IFn$_invoke$arity$7 = G__10410__7;
G__10410.cljs$core$IFn$_invoke$arity$8 = G__10410__8;
G__10410.cljs$core$IFn$_invoke$arity$9 = G__10410__9;
G__10410.cljs$core$IFn$_invoke$arity$10 = G__10410__10;
G__10410.cljs$core$IFn$_invoke$arity$11 = G__10410__11;
G__10410.cljs$core$IFn$_invoke$arity$12 = G__10410__12;
G__10410.cljs$core$IFn$_invoke$arity$13 = G__10410__13;
G__10410.cljs$core$IFn$_invoke$arity$14 = G__10410__14;
G__10410.cljs$core$IFn$_invoke$arity$15 = G__10410__15;
G__10410.cljs$core$IFn$_invoke$arity$16 = G__10410__16;
G__10410.cljs$core$IFn$_invoke$arity$17 = G__10410__17;
G__10410.cljs$core$IFn$_invoke$arity$18 = G__10410__18;
G__10410.cljs$core$IFn$_invoke$arity$19 = G__10410__19;
G__10410.cljs$core$IFn$_invoke$arity$20 = G__10410__20;
G__10410.cljs$core$IFn$_invoke$arity$21 = G__10410__21;
G__10410.cljs$core$IFn$_invoke$arity$22 = G__10410__22;
return G__10410;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args10363){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10363)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__10388 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__10389 = a;
var G__10390 = b;
var G__10391 = c;
var G__10392 = d;
var G__10393 = e;
var G__10394 = f;
var G__10395 = g;
var G__10396 = h;
var G__10397 = i;
var G__10398 = j;
var G__10399 = k;
var G__10400 = l;
var G__10401 = m;
var G__10402 = n;
var G__10403 = o;
var G__10404 = p;
var G__10405 = q;
var G__10406 = r;
var G__10407 = s;
var G__10408 = t;
var G__10409 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__10388,G__10389,G__10390,G__10391,G__10392,G__10393,G__10394,G__10395,G__10396,G__10397,G__10398,G__10399,G__10400,G__10401,G__10402,G__10403,G__10404,G__10405,G__10406,G__10407,G__10408,G__10409) : cljs.core.apply.call(null,G__10388,G__10389,G__10390,G__10391,G__10392,G__10393,G__10394,G__10395,G__10396,G__10397,G__10398,G__10399,G__10400,G__10401,G__10402,G__10403,G__10404,G__10405,G__10406,G__10407,G__10408,G__10409));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});


/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if(!((value == null))){
if(((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$)))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var args10423 = [];
var len__8402__auto___10429 = arguments.length;
var i__8403__auto___10430 = (0);
while(true){
if((i__8403__auto___10430 < len__8402__auto___10429)){
args10423.push((arguments[i__8403__auto___10430]));

var G__10431 = (i__8403__auto___10430 + (1));
i__8403__auto___10430 = G__10431;
continue;
} else {
}
break;
}

var G__10428 = args10423.length;
switch (G__10428) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10423.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__10433 = y;
var G__10434 = cljs.core.first(more);
var G__10435 = cljs.core.next(more);
x = G__10433;
y = G__10434;
more = G__10435;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq10424){
var G__10425 = cljs.core.first(seq10424);
var seq10424__$1 = cljs.core.next(seq10424);
var G__10426 = cljs.core.first(seq10424__$1);
var seq10424__$2 = cljs.core.next(seq10424__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10425,G__10426,seq10424__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__10436 = (n + (1));
var G__10437 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__10438 = cljs.core.next(coll__$1);
n = G__10436;
hash_code = G__10437;
coll__$1 = G__10438;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__10439 = (n + (1));
var G__10440 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__10441 = cljs.core.next(coll__$1);
n = G__10439;
hash_code = G__10440;
coll__$1 = G__10441;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__10442 = this$__$1.valueOf();
var G__10443 = other.valueOf();
return goog.array.defaultCompare(G__10442,G__10443);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
});

/**
 * @interface
 */
cljs.core.Inst = function(){};

cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((!((inst == null))) && (!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
var x__7957__auto__ = (((inst == null))?null:inst);
var m__7958__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__7958__auto__.call(null,inst));
} else {
var m__7958__auto____$1 = (cljs.core.inst_ms_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(inst) : m__7958__auto____$1.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
}
});

Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL;

Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
});
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var args10446 = [];
var len__8402__auto___10455 = arguments.length;
var i__8403__auto___10456 = (0);
while(true){
if((i__8403__auto___10456 < len__8402__auto___10455)){
args10446.push((arguments[i__8403__auto___10456]));

var G__10457 = (i__8403__auto___10456 + (1));
i__8403__auto___10456 = G__10457;
continue;
} else {
}
break;
}

var G__10448 = args10446.length;
switch (G__10448) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10446.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__10449 = val;
var G__10450 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10449,G__10450) : f.call(null,G__10449,G__10450));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10459 = nval;
var G__10460 = (n + (1));
val = G__10459;
n = G__10460;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__10451 = val__$1;
var G__10452 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10451,G__10452) : f.call(null,G__10451,G__10452));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10461 = nval;
var G__10462 = (n + (1));
val__$1 = G__10461;
n = G__10462;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__10453 = val__$1;
var G__10454 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10453,G__10454) : f.call(null,G__10453,G__10454));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10463 = nval;
var G__10464 = (n + (1));
val__$1 = G__10463;
n = G__10464;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var args10465 = [];
var len__8402__auto___10474 = arguments.length;
var i__8403__auto___10475 = (0);
while(true){
if((i__8403__auto___10475 < len__8402__auto___10474)){
args10465.push((arguments[i__8403__auto___10475]));

var G__10476 = (i__8403__auto___10475 + (1));
i__8403__auto___10475 = G__10476;
continue;
} else {
}
break;
}

var G__10467 = args10465.length;
switch (G__10467) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10465.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__10468 = val;
var G__10469 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10468,G__10469) : f.call(null,G__10468,G__10469));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10478 = nval;
var G__10479 = (n + (1));
val = G__10478;
n = G__10479;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__10470 = val__$1;
var G__10471 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10470,G__10471) : f.call(null,G__10470,G__10471));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10480 = nval;
var G__10481 = (n + (1));
val__$1 = G__10480;
n = G__10481;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__10472 = val__$1;
var G__10473 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10472,G__10473) : f.call(null,G__10472,G__10473));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10482 = nval;
var G__10483 = (n + (1));
val__$1 = G__10482;
n = G__10483;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var args10488 = [];
var len__8402__auto___10491 = arguments.length;
var i__8403__auto___10492 = (0);
while(true){
if((i__8403__auto___10492 < len__8402__auto___10491)){
args10488.push((arguments[i__8403__auto___10492]));

var G__10493 = (i__8403__auto___10492 + (1));
i__8403__auto___10492 = G__10493;
continue;
} else {
}
break;
}

var G__10490 = args10488.length;
switch (G__10490) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10488.length)].join('')));

}
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});

cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__7625__auto__ = (0);
var y__7626__auto__ = (start + len);
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__10495 = (idx + (1));
idx = G__10495;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._indexOf.cljs$lang$maxFixedArity = 3;

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var args10496 = [];
var len__8402__auto___10499 = arguments.length;
var i__8403__auto___10500 = (0);
while(true){
if((i__8403__auto___10500 < len__8402__auto___10499)){
args10496.push((arguments[i__8403__auto___10500]));

var G__10501 = (i__8403__auto___10500 + (1));
i__8403__auto___10500 = G__10501;
continue;
} else {
}
break;
}

var G__10498 = args10496.length;
switch (G__10498) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10496.length)].join('')));

}
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});

cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = (cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll));
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__7632__auto__ = (len - (1));
var y__7633__auto__ = start;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.nth.cljs$core$IFn$_invoke$arity$2 ? cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx) : cljs.core.nth.call(null,coll,idx)),x)){
return idx;
} else {
var G__10503 = (idx - (1));
idx = G__10503;
continue;
}
} else {
return (-1);
}
break;
}
}
});

cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3;


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__10504 = null;
var G__10504__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__10504__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__10504 = function(x,start){
switch(arguments.length){
case 1:
return G__10504__1.call(this,x);
case 2:
return G__10504__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10504.cljs$core$IFn$_invoke$arity$1 = G__10504__1;
G__10504.cljs$core$IFn$_invoke$arity$2 = G__10504__2;
return G__10504;
})()
;

cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__10505 = null;
var G__10505__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__10505__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__10505 = function(x,start){
switch(arguments.length){
case 1:
return G__10505__1.call(this,x);
case 2:
return G__10505__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10505.cljs$core$IFn$_invoke$arity$1 = G__10505__1;
G__10505.cljs$core$IFn$_invoke$arity$2 = G__10505__2;
return G__10505;
})()
;

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((((0) <= i__$1)) && ((i__$1 < self__.arr.length))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((((0) <= i__$1)) && ((i__$1 < self__.arr.length))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__7625__auto__ = (0);
var y__7626__auto__ = (self__.arr.length - self__.i);
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var args10506 = [];
var len__8402__auto___10509 = arguments.length;
var i__8403__auto___10510 = (0);
while(true){
if((i__8403__auto___10510 < len__8402__auto___10509)){
args10506.push((arguments[i__8403__auto___10510]));

var G__10511 = (i__8403__auto___10510 + (1));
i__8403__auto___10510 = G__10511;
continue;
} else {
}
break;
}

var G__10508 = args10506.length;
switch (G__10508) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10506.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var args10513 = [];
var len__8402__auto___10516 = arguments.length;
var i__8403__auto___10517 = (0);
while(true){
if((i__8403__auto___10517 < len__8402__auto___10516)){
args10513.push((arguments[i__8403__auto___10517]));

var G__10518 = (i__8403__auto___10517 + (1));
i__8403__auto___10517 = G__10518;
continue;
} else {
}
break;
}

var G__10515 = args10513.length;
switch (G__10515) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10513.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.indexOf = (function() {
var G__10522 = null;
var G__10522__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__10522__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__10522 = function(x,start){
switch(arguments.length){
case 1:
return G__10522__1.call(this,x);
case 2:
return G__10522__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10522.cljs$core$IFn$_invoke$arity$1 = G__10522__1;
G__10522.cljs$core$IFn$_invoke$arity$2 = G__10522__2;
return G__10522;
})()
;

cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__10523 = null;
var G__10523__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(cljs.core.count.cljs$core$IFn$_invoke$arity$1 ? cljs.core.count.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.count.call(null,coll)));
});
var G__10523__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__10523 = function(x,start){
switch(arguments.length){
case 1:
return G__10523__1.call(this,x);
case 2:
return G__10523__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10523.cljs$core$IFn$_invoke$arity$1 = G__10523__1;
G__10523.cljs$core$IFn$_invoke$arity$2 = G__10523__2;
return G__10523;
})()
;

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__10520 = cljs.core.List.EMPTY;
var G__10521 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__10520,G__10521) : cljs.core.with_meta.call(null,G__10520,G__10521));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__10524 = sn;
s = G__10524;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var args10525 = [];
var len__8402__auto___10531 = arguments.length;
var i__8403__auto___10532 = (0);
while(true){
if((i__8403__auto___10532 < len__8402__auto___10531)){
args10525.push((arguments[i__8403__auto___10532]));

var G__10533 = (i__8403__auto___10532 + (1));
i__8403__auto___10532 = G__10533;
continue;
} else {
}
break;
}

var G__10530 = args10525.length;
switch (G__10530) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10525.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
var x__8131__auto__ = x;
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto__);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__10535 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__10536 = cljs.core.first(xs);
var G__10537 = cljs.core.next(xs);
coll = G__10535;
x = G__10536;
xs = G__10537;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq10526){
var G__10527 = cljs.core.first(seq10526);
var seq10526__$1 = cljs.core.next(seq10526);
var G__10528 = cljs.core.first(seq10526__$1);
var seq10526__$2 = cljs.core.next(seq10526__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__10527,G__10528,seq10526__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__10538 = cljs.core.next(s);
var G__10539 = (acc + (1));
s = G__10538;
acc = G__10539;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$)))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$)))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var args10544 = [];
var len__8402__auto___10547 = arguments.length;
var i__8403__auto___10548 = (0);
while(true){
if((i__8403__auto___10548 < len__8402__auto___10547)){
args10544.push((arguments[i__8403__auto___10548]));

var G__10549 = (i__8403__auto___10548 + (1));
i__8403__auto___10548 = G__10549;
continue;
} else {
}
break;
}

var G__10546 = args10544.length;
switch (G__10546) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10544.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__10551 = cljs.core.next(coll);
var G__10552 = (n - (1));
coll = G__10551;
n = G__10552;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__10553 = cljs.core.next(coll);
var G__10554 = (n - (1));
var G__10555 = not_found;
coll = G__10553;
n = G__10554;
not_found = G__10555;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var args10556 = [];
var len__8402__auto___10563 = arguments.length;
var i__8403__auto___10564 = (0);
while(true){
if((i__8403__auto___10564 < len__8402__auto___10563)){
args10556.push((arguments[i__8403__auto___10564]));

var G__10565 = (i__8403__auto___10564 + (1));
i__8403__auto___10564 = G__10565;
continue;
} else {
}
break;
}

var G__10558 = args10556.length;
switch (G__10558) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10556.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$)))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((n >= (0))) && ((n < coll.length))){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((n >= (0))) && ((n < coll.length))){
return coll.charAt(n);
} else {
return not_found;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$)))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("nth not supported on this type "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__10567 = (n__$1 - (1));
var G__10568 = cljs.core.rest(xs);
n__$1 = G__10567;
xs = G__10568;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var args10569 = [];
var len__8402__auto___10574 = arguments.length;
var i__8403__auto___10575 = (0);
while(true){
if((i__8403__auto___10575 < len__8402__auto___10574)){
args10569.push((arguments[i__8403__auto___10575]));

var G__10576 = (i__8403__auto___10575 + (1));
i__8403__auto___10575 = G__10576;
continue;
} else {
}
break;
}

var G__10571 = args10569.length;
switch (G__10571) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10569.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((!((k == null))) && ((k < o.length))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((!((k == null))) && ((k < o.length))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$)))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((!((k == null))) && ((k >= (0))) && ((k < o.length))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((!((k == null))) && ((k >= (0))) && ((k < o.length))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;


/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var args10578 = [];
var len__8402__auto___10585 = arguments.length;
var i__8403__auto___10586 = (0);
while(true){
if((i__8403__auto___10586 < len__8402__auto___10585)){
args10578.push((arguments[i__8403__auto___10586]));

var G__10587 = (i__8403__auto___10586 + (1));
i__8403__auto___10586 = G__10587;
continue;
} else {
}
break;
}

var G__10584 = args10578.length;
switch (G__10584) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10578.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__10589 = ret;
var G__10590 = cljs.core.first(kvs);
var G__10591 = cljs.core.second(kvs);
var G__10592 = cljs.core.nnext(kvs);
coll = G__10589;
k = G__10590;
v = G__10591;
kvs = G__10592;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq10579){
var G__10580 = cljs.core.first(seq10579);
var seq10579__$1 = cljs.core.next(seq10579);
var G__10581 = cljs.core.first(seq10579__$1);
var seq10579__$2 = cljs.core.next(seq10579__$1);
var G__10582 = cljs.core.first(seq10579__$2);
var seq10579__$3 = cljs.core.next(seq10579__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__10580,G__10581,G__10582,seq10579__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var args10593 = [];
var len__8402__auto___10599 = arguments.length;
var i__8403__auto___10600 = (0);
while(true){
if((i__8403__auto___10600 < len__8402__auto___10599)){
args10593.push((arguments[i__8403__auto___10600]));

var G__10601 = (i__8403__auto___10600 + (1));
i__8403__auto___10600 = G__10601;
continue;
} else {
}
break;
}

var G__10598 = args10593.length;
switch (G__10598) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10593.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__10603 = ret;
var G__10604 = cljs.core.first(ks);
var G__10605 = cljs.core.next(ks);
coll = G__10603;
k = G__10604;
ks = G__10605;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq10594){
var G__10595 = cljs.core.first(seq10594);
var seq10594__$1 = cljs.core.next(seq10594);
var G__10596 = cljs.core.first(seq10594__$1);
var seq10594__$2 = cljs.core.next(seq10594__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__10595,G__10596,seq10594__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__7289__auto__ = goog.isFunction(f);
if(or__7289__auto__){
return or__7289__auto__;
} else {
if(!((f == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.MetaFn.prototype.call = (function() {
var G__10611 = null;
var G__10611__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__10611__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__10611__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__10611__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__10611__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__10611__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__10611__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__10611__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__10611__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__10611__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__10611__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__10611__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__10611__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__10611__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__10611__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__10611__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__10611__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__10611__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__10611__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__10611__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__10611__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__10611__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});
G__10611 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__10611__1.call(this,self__);
case 2:
return G__10611__2.call(this,self__,a);
case 3:
return G__10611__3.call(this,self__,a,b);
case 4:
return G__10611__4.call(this,self__,a,b,c);
case 5:
return G__10611__5.call(this,self__,a,b,c,d);
case 6:
return G__10611__6.call(this,self__,a,b,c,d,e);
case 7:
return G__10611__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__10611__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__10611__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__10611__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__10611__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__10611__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__10611__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__10611__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__10611__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__10611__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__10611__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__10611__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__10611__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__10611__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__10611__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__10611__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10611.cljs$core$IFn$_invoke$arity$1 = G__10611__1;
G__10611.cljs$core$IFn$_invoke$arity$2 = G__10611__2;
G__10611.cljs$core$IFn$_invoke$arity$3 = G__10611__3;
G__10611.cljs$core$IFn$_invoke$arity$4 = G__10611__4;
G__10611.cljs$core$IFn$_invoke$arity$5 = G__10611__5;
G__10611.cljs$core$IFn$_invoke$arity$6 = G__10611__6;
G__10611.cljs$core$IFn$_invoke$arity$7 = G__10611__7;
G__10611.cljs$core$IFn$_invoke$arity$8 = G__10611__8;
G__10611.cljs$core$IFn$_invoke$arity$9 = G__10611__9;
G__10611.cljs$core$IFn$_invoke$arity$10 = G__10611__10;
G__10611.cljs$core$IFn$_invoke$arity$11 = G__10611__11;
G__10611.cljs$core$IFn$_invoke$arity$12 = G__10611__12;
G__10611.cljs$core$IFn$_invoke$arity$13 = G__10611__13;
G__10611.cljs$core$IFn$_invoke$arity$14 = G__10611__14;
G__10611.cljs$core$IFn$_invoke$arity$15 = G__10611__15;
G__10611.cljs$core$IFn$_invoke$arity$16 = G__10611__16;
G__10611.cljs$core$IFn$_invoke$arity$17 = G__10611__17;
G__10611.cljs$core$IFn$_invoke$arity$18 = G__10611__18;
G__10611.cljs$core$IFn$_invoke$arity$19 = G__10611__19;
G__10611.cljs$core$IFn$_invoke$arity$20 = G__10611__20;
G__10611.cljs$core$IFn$_invoke$arity$21 = G__10611__21;
G__10611.cljs$core$IFn$_invoke$arity$22 = G__10611__22;
return G__10611;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args10610){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args10610)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__7277__auto__ = !((o == null));
if(and__7277__auto__){
if(!((o == null))){
if(((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$))){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__7277__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var args10616 = [];
var len__8402__auto___10622 = arguments.length;
var i__8403__auto___10623 = (0);
while(true){
if((i__8403__auto___10623 < len__8402__auto___10622)){
args10616.push((arguments[i__8403__auto___10623]));

var G__10624 = (i__8403__auto___10623 + (1));
i__8403__auto___10623 = G__10624;
continue;
} else {
}
break;
}

var G__10621 = args10616.length;
switch (G__10621) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10616.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__10626 = ret;
var G__10627 = cljs.core.first(ks);
var G__10628 = cljs.core.next(ks);
coll = G__10626;
k = G__10627;
ks = G__10628;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq10617){
var G__10618 = cljs.core.first(seq10617);
var seq10617__$1 = cljs.core.next(seq10617);
var G__10619 = cljs.core.first(seq10617__$1);
var seq10617__$2 = cljs.core.next(seq10617__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__10618,G__10619,seq10617__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if(!((x == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var args10651 = [];
var len__8402__auto___10657 = arguments.length;
var i__8403__auto___10658 = (0);
while(true){
if((i__8403__auto___10658 < len__8402__auto___10657)){
args10651.push((arguments[i__8403__auto___10658]));

var G__10659 = (i__8403__auto___10658 + (1));
i__8403__auto___10658 = G__10659;
continue;
} else {
}
break;
}

var G__10654 = args10651.length;
switch (G__10654) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10651.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__8421__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return {};
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq10652){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq10652));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__10663_10665 = obj;
var G__10664_10666 = ((function (G__10663_10665,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__10663_10665,keys))
;
goog.object.forEach(G__10663_10665,G__10664_10666);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__10667 = (i__$1 + (1));
var G__10668 = (j__$1 + (1));
var G__10669 = (len__$1 - (1));
i__$1 = G__10667;
j__$1 = G__10668;
len__$1 = G__10669;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__10670 = (i__$1 - (1));
var G__10671 = (j__$1 - (1));
var G__10672 = (len__$1 - (1));
i__$1 = G__10670;
j__$1 = G__10671;
len__$1 = G__10672;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return (x === true) || (x === false);
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__7289__auto__ = ((!((s == null)))?((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$)))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__7289__auto__){
return or__7289__auto__;
} else {
return (cljs.core.array_QMARK_(s)) || (typeof s === 'string');
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__7289__auto__ = cljs.core.fn_QMARK_(f);
if(or__7289__auto__){
return or__7289__auto__;
} else {
if(!((f == null))){
if(((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (!(isNaN(n))) && (!((n === Infinity))) && ((parseFloat(n) === parseInt(n,(10))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
if((x instanceof goog.math.Long)){
return (cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero()));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0)))) || ((x === (0)));
} else {
if((x instanceof goog.math.Integer)){
var or__7289__auto__ = cljs.core.not(x.isNegative());
if(or__7289__auto__){
return or__7289__auto__;
} else {
return x.isZero();
}
} else {
if((x instanceof goog.math.Long)){
var or__7289__auto__ = cljs.core.not(x.isNegative());
if(or__7289__auto__){
return or__7289__auto__;
} else {
return x.isZero();
}
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return ((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
}
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var args10685 = [];
var len__8402__auto___10691 = arguments.length;
var i__8403__auto___10692 = (0);
while(true){
if((i__8403__auto___10692 < len__8402__auto___10691)){
args10685.push((arguments[i__8403__auto___10692]));

var G__10693 = (i__8403__auto___10692 + (1));
i__8403__auto___10692 = G__10693;
continue;
} else {
}
break;
}

var G__10690 = args10685.length;
switch (G__10690) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10685.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__10695 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__10696 = etc;
s = G__10695;
xs = G__10696;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq10686){
var G__10687 = cljs.core.first(seq10686);
var seq10686__$1 = cljs.core.next(seq10686);
var G__10688 = cljs.core.first(seq10686__$1);
var seq10686__$2 = cljs.core.next(seq10686__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__10687,G__10688,seq10686__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$)))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot compare "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" to "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var args10699 = [];
var len__8402__auto___10702 = arguments.length;
var i__8403__auto___10703 = (0);
while(true){
if((i__8403__auto___10703 < len__8402__auto___10702)){
args10699.push((arguments[i__8403__auto___10703]));

var G__10704 = (i__8403__auto___10703 + (1));
i__8403__auto___10703 = G__10704;
continue;
} else {
}
break;
}

var G__10701 = args10699.length;
switch (G__10701) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10699.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__10706 = xs;
var G__10707 = ys;
var G__10708 = len;
var G__10709 = (n + (1));
xs = G__10706;
ys = G__10707;
len = G__10708;
n = G__10709;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var args10710 = [];
var len__8402__auto___10715 = arguments.length;
var i__8403__auto___10716 = (0);
while(true){
if((i__8403__auto___10716 < len__8402__auto___10715)){
args10710.push((arguments[i__8403__auto___10716]));

var G__10717 = (i__8403__auto___10716 + (1));
i__8403__auto___10716 = G__10717;
continue;
} else {
}
break;
}

var G__10712 = args10710.length;
switch (G__10712) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10710.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
var G__10713_10719 = a;
var G__10714_10720 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__10713_10719,G__10714_10720);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var args10721 = [];
var len__8402__auto___10724 = arguments.length;
var i__8403__auto___10725 = (0);
while(true){
if((i__8403__auto___10725 < len__8402__auto___10724)){
args10721.push((arguments[i__8403__auto___10725]));

var G__10726 = (i__8403__auto___10725 + (1));
i__8403__auto___10725 = G__10726;
continue;
} else {
}
break;
}

var G__10723 = args10721.length;
switch (G__10723) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10721.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x)),(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y)));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var args10728 = [];
var len__8402__auto___10736 = arguments.length;
var i__8403__auto___10737 = (0);
while(true){
if((i__8403__auto___10737 < len__8402__auto___10736)){
args10728.push((arguments[i__8403__auto___10737]));

var G__10738 = (i__8403__auto___10737 + (1));
i__8403__auto___10737 = G__10738;
continue;
} else {
}
break;
}

var G__10730 = args10728.length;
switch (G__10730) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10728.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
var G__10731 = f;
var G__10732 = cljs.core.first(s);
var G__10733 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__10731,G__10732,G__10733) : cljs.core.reduce.call(null,G__10731,G__10732,G__10733));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__10734 = val__$1;
var G__10735 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__10734,G__10735) : f.call(null,G__10734,G__10735));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__10740 = nval;
var G__10741 = cljs.core.next(coll__$1);
val__$1 = G__10740;
coll__$1 = G__10741;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
goog.array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var args10742 = [];
var len__8402__auto___10747 = arguments.length;
var i__8403__auto___10748 = (0);
while(true){
if((i__8403__auto___10748 < len__8402__auto___10747)){
args10742.push((arguments[i__8403__auto___10748]));

var G__10749 = (i__8403__auto___10748 + (1));
i__8403__auto___10748 = G__10749;
continue;
} else {
}
break;
}

var G__10744 = args10742.length;
switch (G__10744) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10742.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$)))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var args10751 = [];
var len__8402__auto___10754 = arguments.length;
var i__8403__auto___10755 = (0);
while(true){
if((i__8403__auto___10755 < len__8402__auto___10754)){
args10751.push((arguments[i__8403__auto___10755]));

var G__10756 = (i__8403__auto___10755 + (1));
i__8403__auto___10755 = G__10756;
continue;
} else {
}
break;
}

var G__10753 = args10751.length;
switch (G__10753) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10751.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__10758 = null;
var G__10758__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__10758__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__10758__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__10758 = function(x,y){
switch(arguments.length){
case 0:
return G__10758__0.call(this);
case 1:
return G__10758__1.call(this,x);
case 2:
return G__10758__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__10758.cljs$core$IFn$_invoke$arity$0 = G__10758__0;
G__10758.cljs$core$IFn$_invoke$arity$1 = G__10758__1;
G__10758.cljs$core$IFn$_invoke$arity$2 = G__10758__2;
return G__10758;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var args10759 = [];
var len__8402__auto___10762 = arguments.length;
var i__8403__auto___10763 = (0);
while(true){
if((i__8403__auto___10763 < len__8402__auto___10762)){
args10759.push((arguments[i__8403__auto___10763]));

var G__10764 = (i__8403__auto___10763 + (1));
i__8403__auto___10763 = G__10764;
continue;
} else {
}
break;
}

var G__10761 = args10759.length;
switch (G__10761) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args10759.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var args10766 = [];
var len__8402__auto___10772 = arguments.length;
var i__8403__auto___10773 = (0);
while(true){
if((i__8403__auto___10773 < len__8402__auto___10772)){
args10766.push((arguments[i__8403__auto___10773]));

var G__10774 = (i__8403__auto___10773 + (1));
i__8403__auto___10773 = G__10774;
continue;
} else {
}
break;
}

var G__10771 = args10766.length;
switch (G__10771) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10766.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq10767){
var G__10768 = cljs.core.first(seq10767);
var seq10767__$1 = cljs.core.next(seq10767);
var G__10769 = cljs.core.first(seq10767__$1);
var seq10767__$2 = cljs.core.next(seq10767__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__10768,G__10769,seq10767__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var args10776 = [];
var len__8402__auto___10782 = arguments.length;
var i__8403__auto___10783 = (0);
while(true){
if((i__8403__auto___10783 < len__8402__auto___10782)){
args10776.push((arguments[i__8403__auto___10783]));

var G__10784 = (i__8403__auto___10783 + (1));
i__8403__auto___10783 = G__10784;
continue;
} else {
}
break;
}

var G__10781 = args10776.length;
switch (G__10781) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10776.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq10777){
var G__10778 = cljs.core.first(seq10777);
var seq10777__$1 = cljs.core.next(seq10777);
var G__10779 = cljs.core.first(seq10777__$1);
var seq10777__$2 = cljs.core.next(seq10777__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__10778,G__10779,seq10777__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var args10786 = [];
var len__8402__auto___10792 = arguments.length;
var i__8403__auto___10793 = (0);
while(true){
if((i__8403__auto___10793 < len__8402__auto___10792)){
args10786.push((arguments[i__8403__auto___10793]));

var G__10794 = (i__8403__auto___10793 + (1));
i__8403__auto___10793 = G__10794;
continue;
} else {
}
break;
}

var G__10791 = args10786.length;
switch (G__10791) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10786.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq10787){
var G__10788 = cljs.core.first(seq10787);
var seq10787__$1 = cljs.core.next(seq10787);
var G__10789 = cljs.core.first(seq10787__$1);
var seq10787__$2 = cljs.core.next(seq10787__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__10788,G__10789,seq10787__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var args10796 = [];
var len__8402__auto___10802 = arguments.length;
var i__8403__auto___10803 = (0);
while(true){
if((i__8403__auto___10803 < len__8402__auto___10802)){
args10796.push((arguments[i__8403__auto___10803]));

var G__10804 = (i__8403__auto___10803 + (1));
i__8403__auto___10803 = G__10804;
continue;
} else {
}
break;
}

var G__10801 = args10796.length;
switch (G__10801) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10796.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq10797){
var G__10798 = cljs.core.first(seq10797);
var seq10797__$1 = cljs.core.next(seq10797);
var G__10799 = cljs.core.first(seq10797__$1);
var seq10797__$2 = cljs.core.next(seq10797__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__10798,G__10799,seq10797__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var args10806 = [];
var len__8402__auto___10812 = arguments.length;
var i__8403__auto___10813 = (0);
while(true){
if((i__8403__auto___10813 < len__8402__auto___10812)){
args10806.push((arguments[i__8403__auto___10813]));

var G__10814 = (i__8403__auto___10813 + (1));
i__8403__auto___10813 = G__10814;
continue;
} else {
}
break;
}

var G__10811 = args10806.length;
switch (G__10811) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10806.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__10816 = y;
var G__10817 = cljs.core.first(more);
var G__10818 = cljs.core.next(more);
x = G__10816;
y = G__10817;
more = G__10818;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq10807){
var G__10808 = cljs.core.first(seq10807);
var seq10807__$1 = cljs.core.next(seq10807);
var G__10809 = cljs.core.first(seq10807__$1);
var seq10807__$2 = cljs.core.next(seq10807__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__10808,G__10809,seq10807__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var args10819 = [];
var len__8402__auto___10825 = arguments.length;
var i__8403__auto___10826 = (0);
while(true){
if((i__8403__auto___10826 < len__8402__auto___10825)){
args10819.push((arguments[i__8403__auto___10826]));

var G__10827 = (i__8403__auto___10826 + (1));
i__8403__auto___10826 = G__10827;
continue;
} else {
}
break;
}

var G__10824 = args10819.length;
switch (G__10824) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10819.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__10829 = y;
var G__10830 = cljs.core.first(more);
var G__10831 = cljs.core.next(more);
x = G__10829;
y = G__10830;
more = G__10831;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq10820){
var G__10821 = cljs.core.first(seq10820);
var seq10820__$1 = cljs.core.next(seq10820);
var G__10822 = cljs.core.first(seq10820__$1);
var seq10820__$2 = cljs.core.next(seq10820__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10821,G__10822,seq10820__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var args10832 = [];
var len__8402__auto___10838 = arguments.length;
var i__8403__auto___10839 = (0);
while(true){
if((i__8403__auto___10839 < len__8402__auto___10838)){
args10832.push((arguments[i__8403__auto___10839]));

var G__10840 = (i__8403__auto___10839 + (1));
i__8403__auto___10839 = G__10840;
continue;
} else {
}
break;
}

var G__10837 = args10832.length;
switch (G__10837) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10832.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__10842 = y;
var G__10843 = cljs.core.first(more);
var G__10844 = cljs.core.next(more);
x = G__10842;
y = G__10843;
more = G__10844;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq10833){
var G__10834 = cljs.core.first(seq10833);
var seq10833__$1 = cljs.core.next(seq10833);
var G__10835 = cljs.core.first(seq10833__$1);
var seq10833__$2 = cljs.core.next(seq10833__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__10834,G__10835,seq10833__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var args10845 = [];
var len__8402__auto___10851 = arguments.length;
var i__8403__auto___10852 = (0);
while(true){
if((i__8403__auto___10852 < len__8402__auto___10851)){
args10845.push((arguments[i__8403__auto___10852]));

var G__10853 = (i__8403__auto___10852 + (1));
i__8403__auto___10852 = G__10853;
continue;
} else {
}
break;
}

var G__10850 = args10845.length;
switch (G__10850) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10845.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__10855 = y;
var G__10856 = cljs.core.first(more);
var G__10857 = cljs.core.next(more);
x = G__10855;
y = G__10856;
more = G__10857;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq10846){
var G__10847 = cljs.core.first(seq10846);
var seq10846__$1 = cljs.core.next(seq10846);
var G__10848 = cljs.core.first(seq10846__$1);
var seq10846__$2 = cljs.core.next(seq10846__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10847,G__10848,seq10846__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var args10858 = [];
var len__8402__auto___10864 = arguments.length;
var i__8403__auto___10865 = (0);
while(true){
if((i__8403__auto___10865 < len__8402__auto___10864)){
args10858.push((arguments[i__8403__auto___10865]));

var G__10866 = (i__8403__auto___10865 + (1));
i__8403__auto___10865 = G__10866;
continue;
} else {
}
break;
}

var G__10863 = args10858.length;
switch (G__10863) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10858.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__7625__auto__ = x;
var y__7626__auto__ = y;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__7625__auto__ = x;
var y__7626__auto__ = y;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq10859){
var G__10860 = cljs.core.first(seq10859);
var seq10859__$1 = cljs.core.next(seq10859);
var G__10861 = cljs.core.first(seq10859__$1);
var seq10859__$2 = cljs.core.next(seq10859__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__10860,G__10861,seq10859__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var args10868 = [];
var len__8402__auto___10874 = arguments.length;
var i__8403__auto___10875 = (0);
while(true){
if((i__8403__auto___10875 < len__8402__auto___10874)){
args10868.push((arguments[i__8403__auto___10875]));

var G__10876 = (i__8403__auto___10875 + (1));
i__8403__auto___10875 = G__10876;
continue;
} else {
}
break;
}

var G__10873 = args10868.length;
switch (G__10873) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10868.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__7632__auto__ = x;
var y__7633__auto__ = y;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__7632__auto__ = x;
var y__7633__auto__ = y;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq10869){
var G__10870 = cljs.core.first(seq10869);
var seq10869__$1 = cljs.core.next(seq10869);
var G__10871 = cljs.core.first(seq10869__$1);
var seq10869__$2 = cljs.core.next(seq10869__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__10870,G__10871,seq10869__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var args10878 = [];
var len__8402__auto___10884 = arguments.length;
var i__8403__auto___10885 = (0);
while(true){
if((i__8403__auto___10885 < len__8402__auto___10884)){
args10878.push((arguments[i__8403__auto___10885]));

var G__10886 = (i__8403__auto___10885 + (1));
i__8403__auto___10885 = G__10886;
continue;
} else {
}
break;
}

var G__10883 = args10878.length;
switch (G__10883) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10878.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq10879){
var G__10880 = cljs.core.first(seq10879);
var seq10879__$1 = cljs.core.next(seq10879);
var G__10881 = cljs.core.first(seq10879__$1);
var seq10879__$2 = cljs.core.next(seq10879__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__10880,G__10881,seq10879__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var args10888 = [];
var len__8402__auto___10894 = arguments.length;
var i__8403__auto___10895 = (0);
while(true){
if((i__8403__auto___10895 < len__8402__auto___10894)){
args10888.push((arguments[i__8403__auto___10895]));

var G__10896 = (i__8403__auto___10895 + (1));
i__8403__auto___10895 = G__10896;
continue;
} else {
}
break;
}

var G__10893 = args10888.length;
switch (G__10893) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10888.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq10889){
var G__10890 = cljs.core.first(seq10889);
var seq10889__$1 = cljs.core.next(seq10889);
var G__10891 = cljs.core.first(seq10889__$1);
var seq10889__$2 = cljs.core.next(seq10889__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__10890,G__10891,seq10889__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var args10898 = [];
var len__8402__auto___10904 = arguments.length;
var i__8403__auto___10905 = (0);
while(true){
if((i__8403__auto___10905 < len__8402__auto___10904)){
args10898.push((arguments[i__8403__auto___10905]));

var G__10906 = (i__8403__auto___10905 + (1));
i__8403__auto___10905 = G__10906;
continue;
} else {
}
break;
}

var G__10903 = args10898.length;
switch (G__10903) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10898.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq10899){
var G__10900 = cljs.core.first(seq10899);
var seq10899__$1 = cljs.core.next(seq10899);
var G__10901 = cljs.core.first(seq10899__$1);
var seq10899__$2 = cljs.core.next(seq10899__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__10900,G__10901,seq10899__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var args10908 = [];
var len__8402__auto___10914 = arguments.length;
var i__8403__auto___10915 = (0);
while(true){
if((i__8403__auto___10915 < len__8402__auto___10914)){
args10908.push((arguments[i__8403__auto___10915]));

var G__10916 = (i__8403__auto___10915 + (1));
i__8403__auto___10915 = G__10916;
continue;
} else {
}
break;
}

var G__10913 = args10908.length;
switch (G__10913) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10908.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq10909){
var G__10910 = cljs.core.first(seq10909);
var seq10909__$1 = cljs.core.next(seq10909);
var G__10911 = cljs.core.first(seq10909__$1);
var seq10909__$2 = cljs.core.next(seq10909__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__10910,G__10911,seq10909__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var args10918 = [];
var len__8402__auto___10924 = arguments.length;
var i__8403__auto___10925 = (0);
while(true){
if((i__8403__auto___10925 < len__8402__auto___10924)){
args10918.push((arguments[i__8403__auto___10925]));

var G__10926 = (i__8403__auto___10925 + (1));
i__8403__auto___10925 = G__10926;
continue;
} else {
}
break;
}

var G__10923 = args10918.length;
switch (G__10923) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10918.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq10919){
var G__10920 = cljs.core.first(seq10919);
var seq10919__$1 = cljs.core.next(seq10919);
var G__10921 = cljs.core.first(seq10919__$1);
var seq10919__$2 = cljs.core.next(seq10919__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__10920,G__10921,seq10919__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var args10928 = [];
var len__8402__auto___10934 = arguments.length;
var i__8403__auto___10935 = (0);
while(true){
if((i__8403__auto___10935 < len__8402__auto___10934)){
args10928.push((arguments[i__8403__auto___10935]));

var G__10936 = (i__8403__auto___10935 + (1));
i__8403__auto___10935 = G__10936;
continue;
} else {
}
break;
}

var G__10933 = args10928.length;
switch (G__10933) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10928.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq10929){
var G__10930 = cljs.core.first(seq10929);
var seq10929__$1 = cljs.core.next(seq10929);
var G__10931 = cljs.core.first(seq10929__$1);
var seq10929__$2 = cljs.core.next(seq10929__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__10930,G__10931,seq10929__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var args10938 = [];
var len__8402__auto___10944 = arguments.length;
var i__8403__auto___10945 = (0);
while(true){
if((i__8403__auto___10945 < len__8402__auto___10944)){
args10938.push((arguments[i__8403__auto___10945]));

var G__10946 = (i__8403__auto___10945 + (1));
i__8403__auto___10945 = G__10946;
continue;
} else {
}
break;
}

var G__10943 = args10938.length;
switch (G__10943) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10938.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq10939){
var G__10940 = cljs.core.first(seq10939);
var seq10939__$1 = cljs.core.next(seq10939);
var G__10941 = cljs.core.first(seq10939__$1);
var seq10939__$2 = cljs.core.next(seq10939__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__10940,G__10941,seq10939__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var args10948 = [];
var len__8402__auto___10954 = arguments.length;
var i__8403__auto___10955 = (0);
while(true){
if((i__8403__auto___10955 < len__8402__auto___10954)){
args10948.push((arguments[i__8403__auto___10955]));

var G__10956 = (i__8403__auto___10955 + (1));
i__8403__auto___10955 = G__10956;
continue;
} else {
}
break;
}

var G__10953 = args10948.length;
switch (G__10953) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10948.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq10949){
var G__10950 = cljs.core.first(seq10949);
var seq10949__$1 = cljs.core.next(seq10949);
var G__10951 = cljs.core.first(seq10949__$1);
var seq10949__$2 = cljs.core.next(seq10949__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__10950,G__10951,seq10949__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var args10958 = [];
var len__8402__auto___10964 = arguments.length;
var i__8403__auto___10965 = (0);
while(true){
if((i__8403__auto___10965 < len__8402__auto___10964)){
args10958.push((arguments[i__8403__auto___10965]));

var G__10966 = (i__8403__auto___10965 + (1));
i__8403__auto___10965 = G__10966;
continue;
} else {
}
break;
}

var G__10963 = args10958.length;
switch (G__10963) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10958.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq10959){
var G__10960 = cljs.core.first(seq10959);
var seq10959__$1 = cljs.core.next(seq10959);
var G__10961 = cljs.core.first(seq10959__$1);
var seq10959__$2 = cljs.core.next(seq10959__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__10960,G__10961,seq10959__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var args10968 = [];
var len__8402__auto___10974 = arguments.length;
var i__8403__auto___10975 = (0);
while(true){
if((i__8403__auto___10975 < len__8402__auto___10974)){
args10968.push((arguments[i__8403__auto___10975]));

var G__10976 = (i__8403__auto___10975 + (1));
i__8403__auto___10975 = G__10976;
continue;
} else {
}
break;
}

var G__10973 = args10968.length;
switch (G__10973) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10968.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq10969){
var G__10970 = cljs.core.first(seq10969);
var seq10969__$1 = cljs.core.next(seq10969);
var G__10971 = cljs.core.first(seq10969__$1);
var seq10969__$2 = cljs.core.next(seq10969__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__10970,G__10971,seq10969__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var args10978 = [];
var len__8402__auto___10984 = arguments.length;
var i__8403__auto___10985 = (0);
while(true){
if((i__8403__auto___10985 < len__8402__auto___10984)){
args10978.push((arguments[i__8403__auto___10985]));

var G__10986 = (i__8403__auto___10985 + (1));
i__8403__auto___10985 = G__10986;
continue;
} else {
}
break;
}

var G__10983 = args10978.length;
switch (G__10983) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10978.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq10979){
var G__10980 = cljs.core.first(seq10979);
var seq10979__$1 = cljs.core.next(seq10979);
var G__10981 = cljs.core.first(seq10979__$1);
var seq10979__$2 = cljs.core.next(seq10979__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__10980,G__10981,seq10979__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var args10988 = [];
var len__8402__auto___10994 = arguments.length;
var i__8403__auto___10995 = (0);
while(true){
if((i__8403__auto___10995 < len__8402__auto___10994)){
args10988.push((arguments[i__8403__auto___10995]));

var G__10996 = (i__8403__auto___10995 + (1));
i__8403__auto___10995 = G__10996;
continue;
} else {
}
break;
}

var G__10993 = args10988.length;
switch (G__10993) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args10988.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__10998 = y;
var G__10999 = cljs.core.first(more);
var G__11000 = cljs.core.next(more);
x = G__10998;
y = G__10999;
more = G__11000;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq10989){
var G__10990 = cljs.core.first(seq10989);
var seq10989__$1 = cljs.core.next(seq10989);
var G__10991 = cljs.core.first(seq10989__$1);
var seq10989__$2 = cljs.core.next(seq10989__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__10990,G__10991,seq10989__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__11001 = (n__$1 - (1));
var G__11002 = cljs.core.next(xs);
n__$1 = G__11001;
xs = G__11002;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var args11003 = [];
var len__8402__auto___11008 = arguments.length;
var i__8403__auto___11009 = (0);
while(true){
if((i__8403__auto___11009 < len__8402__auto___11008)){
args11003.push((arguments[i__8403__auto___11009]));

var G__11010 = (i__8403__auto___11009 + (1));
i__8403__auto___11009 = G__11010;
continue;
} else {
}
break;
}

var G__11007 = args11003.length;
switch (G__11007) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11003.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8421__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__11012 = sb.append([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more))].join(''));
var G__11013 = cljs.core.next(more);
sb = G__11012;
more = G__11013;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq11004){
var G__11005 = cljs.core.first(seq11004);
var seq11004__$1 = cljs.core.next(seq11004);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__11005,seq11004__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var args11014 = [];
var len__8402__auto___11017 = arguments.length;
var i__8403__auto___11018 = (0);
while(true){
if((i__8403__auto___11018 < len__8402__auto___11017)){
args11014.push((arguments[i__8403__auto___11018]));

var G__11019 = (i__8403__auto___11018 + (1));
i__8403__auto___11018 = G__11019;
continue;
} else {
}
break;
}

var G__11016 = args11014.length;
switch (G__11016) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11014.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__11021 = cljs.core.next(xs);
var G__11022 = cljs.core.next(ys);
xs = G__11021;
ys = G__11022;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__11023 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__11024 = cljs.core.next(s);
res = G__11023;
s = G__11024;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__11025 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__11026 = cljs.core.next(s);
h = G__11025;
s = G__11026;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__11027 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__11028 = cljs.core.next(s__$1);
h = G__11027;
s__$1 = G__11028;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__11039_11049 = cljs.core.seq(fn_map);
var chunk__11040_11050 = null;
var count__11041_11051 = (0);
var i__11042_11052 = (0);
while(true){
if((i__11042_11052 < count__11041_11051)){
var vec__11043_11053 = chunk__11040_11050.cljs$core$IIndexed$_nth$arity$2(null,i__11042_11052);
var key_name_11054 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11043_11053,(0),null);
var f_11055 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11043_11053,(1),null);
var str_name_11056 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_11054) : cljs.core.name.call(null,key_name_11054));
(obj[str_name_11056] = f_11055);

var G__11057 = seq__11039_11049;
var G__11058 = chunk__11040_11050;
var G__11059 = count__11041_11051;
var G__11060 = (i__11042_11052 + (1));
seq__11039_11049 = G__11057;
chunk__11040_11050 = G__11058;
count__11041_11051 = G__11059;
i__11042_11052 = G__11060;
continue;
} else {
var temp__4657__auto___11061 = cljs.core.seq(seq__11039_11049);
if(temp__4657__auto___11061){
var seq__11039_11062__$1 = temp__4657__auto___11061;
if(cljs.core.chunked_seq_QMARK_(seq__11039_11062__$1)){
var c__8108__auto___11063 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__11039_11062__$1) : cljs.core.chunk_first.call(null,seq__11039_11062__$1));
var G__11064 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__11039_11062__$1) : cljs.core.chunk_rest.call(null,seq__11039_11062__$1));
var G__11065 = c__8108__auto___11063;
var G__11066 = cljs.core.count(c__8108__auto___11063);
var G__11067 = (0);
seq__11039_11049 = G__11064;
chunk__11040_11050 = G__11065;
count__11041_11051 = G__11066;
i__11042_11052 = G__11067;
continue;
} else {
var vec__11046_11068 = cljs.core.first(seq__11039_11062__$1);
var key_name_11069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11046_11068,(0),null);
var f_11070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11046_11068,(1),null);
var str_name_11071 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_11069) : cljs.core.name.call(null,key_name_11069));
(obj[str_name_11071] = f_11070);

var G__11072 = cljs.core.next(seq__11039_11062__$1);
var G__11073 = null;
var G__11074 = (0);
var G__11075 = (0);
seq__11039_11049 = G__11072;
chunk__11040_11050 = G__11073;
count__11041_11051 = G__11074;
i__11042_11052 = G__11075;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.indexOf = (function() {
var G__11076 = null;
var G__11076__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11076__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11076 = function(x,start){
switch(arguments.length){
case 1:
return G__11076__1.call(this,x);
case 2:
return G__11076__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11076.cljs$core$IFn$_invoke$arity$1 = G__11076__1;
G__11076.cljs$core$IFn$_invoke$arity$2 = G__11076__2;
return G__11076;
})()
;

cljs.core.List.prototype.lastIndexOf = (function() {
var G__11077 = null;
var G__11077__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__11077__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11077 = function(x,start){
switch(arguments.length){
case 1:
return G__11077__1.call(this,x);
case 2:
return G__11077__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11077.cljs$core$IFn$_invoke$arity$1 = G__11077__1;
G__11077.cljs$core$IFn$_invoke$arity$2 = G__11077__2;
return G__11077;
})()
;

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.indexOf = (function() {
var G__11080 = null;
var G__11080__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11080__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11080 = function(x,start){
switch(arguments.length){
case 1:
return G__11080__1.call(this,x);
case 2:
return G__11080__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11080.cljs$core$IFn$_invoke$arity$1 = G__11080__1;
G__11080.cljs$core$IFn$_invoke$arity$2 = G__11080__2;
return G__11080;
})()
;

cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__11081 = null;
var G__11081__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__11081__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11081 = function(x,start){
switch(arguments.length){
case 1:
return G__11081__1.call(this,x);
case 2:
return G__11081__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11081.cljs$core$IFn$_invoke$arity$1 = G__11081__1;
G__11081.cljs$core$IFn$_invoke$arity$2 = G__11081__2;
return G__11081;
})()
;

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__8409__auto__ = [];
var len__8402__auto___11085 = arguments.length;
var i__8403__auto___11086 = (0);
while(true){
if((i__8403__auto___11086 < len__8402__auto___11085)){
args__8409__auto__.push((arguments[i__8403__auto___11086]));

var G__11087 = (i__8403__auto___11086 + (1));
i__8403__auto___11086 = G__11087;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__11088 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__11088;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__11089 = (i - (1));
var G__11090 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__11089;
r = G__11090;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq11084){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq11084));
});


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.indexOf = (function() {
var G__11091 = null;
var G__11091__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11091__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11091 = function(x,start){
switch(arguments.length){
case 1:
return G__11091__1.call(this,x);
case 2:
return G__11091__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11091.cljs$core$IFn$_invoke$arity$1 = G__11091__1;
G__11091.cljs$core$IFn$_invoke$arity$2 = G__11091__2;
return G__11091;
})()
;

cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__11092 = null;
var G__11092__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__11092__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11092 = function(x,start){
switch(arguments.length){
case 1:
return G__11092__1.call(this,x);
case 2:
return G__11092__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11092.cljs$core$IFn$_invoke$arity$1 = G__11092__1;
G__11092.cljs$core$IFn$_invoke$arity$2 = G__11092__2;
return G__11092;
})()
;

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__7289__auto__ = (coll == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__7277__auto__ = cljs.core.not(a.ns);
if(and__7277__auto__){
return b.ns;
} else {
return and__7277__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__11103 = a.ns;
var G__11104 = b.ns;
return goog.array.defaultCompare(G__11103,G__11104);
})();
if(((0) === nsc)){
var G__11105 = a.name;
var G__11106 = b.name;
return goog.array.defaultCompare(G__11105,G__11106);
} else {
return nsc;
}
}
} else {
var G__11107 = a.name;
var G__11108 = b.name;
return goog.array.defaultCompare(G__11107,G__11108);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__11110 = null;
var G__11110__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__11110__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__11110 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__11110__2.call(this,self__,coll);
case 3:
return G__11110__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11110.cljs$core$IFn$_invoke$arity$2 = G__11110__2;
G__11110.cljs$core$IFn$_invoke$arity$3 = G__11110__3;
return G__11110;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args11109){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args11109)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__7729__auto__ = self__._hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(":"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Doesn't support namespace: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return (cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
var and__7277__auto__ = cljs.core.ident_QMARK_(x);
if(and__7277__auto__){
var and__7277__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__7277__auto____$1)){
return true;
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return ((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
var and__7277__auto__ = (x instanceof cljs.core.Symbol);
if(and__7277__auto__){
var and__7277__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__7277__auto____$1)){
return true;
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
var and__7277__auto__ = (x instanceof cljs.core.Keyword);
if(and__7277__auto__){
var and__7277__auto____$1 = cljs.core.namespace(x);
if(cljs.core.truth_(and__7277__auto____$1)){
return true;
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var args11113 = [];
var len__8402__auto___11116 = arguments.length;
var i__8403__auto___11117 = (0);
while(true){
if((i__8403__auto___11117 < len__8402__auto___11116)){
args11113.push((arguments[i__8403__auto___11117]));

var G__11118 = (i__8403__auto___11117 + (1));
i__8403__auto___11117 = G__11118;
continue;
} else {
}
break;
}

var G__11115 = args11113.length;
switch (G__11115) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11113.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):(((ns instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(ns) : cljs.core.name.call(null,ns)):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):(((name instanceof cljs.core.Symbol))?(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/")].join(''):null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.indexOf = (function() {
var G__11120 = null;
var G__11120__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11120__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11120 = function(x,start){
switch(arguments.length){
case 1:
return G__11120__1.call(this,x);
case 2:
return G__11120__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11120.cljs$core$IFn$_invoke$arity$1 = G__11120__1;
G__11120.cljs$core$IFn$_invoke$arity$2 = G__11120__2;
return G__11120;
})()
;

cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__11121 = null;
var G__11121__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__11121__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11121 = function(x,start){
switch(arguments.length){
case 1:
return G__11121__1.call(this,x);
case 2:
return G__11121__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11121.cljs$core$IFn$_invoke$arity$1 = G__11121__1;
G__11121.cljs$core$IFn$_invoke$arity$2 = G__11121__2;
return G__11121;
})()
;

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__11122 = ls.sval();
ls = G__11122;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var args11123 = [];
var len__8402__auto___11126 = arguments.length;
var i__8403__auto___11127 = (0);
while(true){
if((i__8403__auto___11127 < len__8402__auto___11126)){
args11123.push((arguments[i__8403__auto___11127]));

var G__11128 = (i__8403__auto___11127 + (1));
i__8403__auto___11127 = G__11128;
continue;
} else {
}
break;
}

var G__11125 = args11123.length;
switch (G__11125) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11123.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__11130 = null;
var G__11130__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11130__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11130 = function(x,start){
switch(arguments.length){
case 1:
return G__11130__1.call(this,x);
case 2:
return G__11130__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11130.cljs$core$IFn$_invoke$arity$1 = G__11130__1;
G__11130.cljs$core$IFn$_invoke$arity$2 = G__11130__2;
return G__11130;
})()
;

cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__11131 = null;
var G__11131__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__11131__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11131 = function(x,start){
switch(arguments.length){
case 1:
return G__11131__1.call(this,x);
case 2:
return G__11131__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11131.cljs$core$IFn$_invoke$arity$1 = G__11131__1;
G__11131.cljs$core$IFn$_invoke$arity$2 = G__11131__2;
return G__11131;
})()
;

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if(((!((s == null)))?((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$)))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__11134 = cljs.core.next(s__$1);
s__$1 = G__11134;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_11135 = (0);
var xs_11136 = cljs.core.seq(coll);
while(true){
if(xs_11136){
(ret[i_11135] = cljs.core.to_array(cljs.core.first(xs_11136)));

var G__11137 = (i_11135 + (1));
var G__11138 = cljs.core.next(xs_11136);
i_11135 = G__11137;
xs_11136 = G__11138;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var args11139 = [];
var len__8402__auto___11142 = arguments.length;
var i__8403__auto___11143 = (0);
while(true){
if((i__8403__auto___11143 < len__8402__auto___11142)){
args11139.push((arguments[i__8403__auto___11143]));

var G__11144 = (i__8403__auto___11143 + (1));
i__8403__auto___11143 = G__11144;
continue;
} else {
}
break;
}

var G__11141 = args11139.length;
switch (G__11141) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11139.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__11146 = (i + (1));
var G__11147 = cljs.core.next(s__$1);
i = G__11146;
s__$1 = G__11147;
continue;
} else {
return a;
}
break;
}
} else {
var n__8212__auto___11148 = size;
var i_11149 = (0);
while(true){
if((i_11149 < n__8212__auto___11148)){
(a[i_11149] = init_val_or_seq);

var G__11150 = (i_11149 + (1));
i_11149 = G__11150;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var args11151 = [];
var len__8402__auto___11154 = arguments.length;
var i__8403__auto___11155 = (0);
while(true){
if((i__8403__auto___11155 < len__8402__auto___11154)){
args11151.push((arguments[i__8403__auto___11155]));

var G__11156 = (i__8403__auto___11155 + (1));
i__8403__auto___11155 = G__11156;
continue;
} else {
}
break;
}

var G__11153 = args11151.length;
switch (G__11153) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11151.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__11158 = (i + (1));
var G__11159 = cljs.core.next(s__$1);
i = G__11158;
s__$1 = G__11159;
continue;
} else {
return a;
}
break;
}
} else {
var n__8212__auto___11160 = size;
var i_11161 = (0);
while(true){
if((i_11161 < n__8212__auto___11160)){
(a[i_11161] = init_val_or_seq);

var G__11162 = (i_11161 + (1));
i_11161 = G__11162;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var args11163 = [];
var len__8402__auto___11166 = arguments.length;
var i__8403__auto___11167 = (0);
while(true){
if((i__8403__auto___11167 < len__8402__auto___11166)){
args11163.push((arguments[i__8403__auto___11167]));

var G__11168 = (i__8403__auto___11167 + (1));
i__8403__auto___11167 = G__11168;
continue;
} else {
}
break;
}

var G__11165 = args11163.length;
switch (G__11165) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11163.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__11170 = (i + (1));
var G__11171 = cljs.core.next(s__$1);
i = G__11170;
s__$1 = G__11171;
continue;
} else {
return a;
}
break;
}
} else {
var n__8212__auto___11172 = size;
var i_11173 = (0);
while(true){
if((i_11173 < n__8212__auto___11172)){
(a[i_11173] = init_val_or_seq);

var G__11174 = (i_11173 + (1));
i_11173 = G__11174;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var args11175 = [];
var len__8402__auto___11178 = arguments.length;
var i__8403__auto___11179 = (0);
while(true){
if((i__8403__auto___11179 < len__8402__auto___11178)){
args11175.push((arguments[i__8403__auto___11179]));

var G__11180 = (i__8403__auto___11179 + (1));
i__8403__auto___11179 = G__11180;
continue;
} else {
}
break;
}

var G__11177 = args11175.length;
switch (G__11177) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11175.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__11182 = (i + (1));
var G__11183 = cljs.core.next(s__$1);
i = G__11182;
s__$1 = G__11183;
continue;
} else {
return a;
}
break;
}
} else {
var n__8212__auto___11184 = size;
var i_11185 = (0);
while(true){
if((i_11185 < n__8212__auto___11184)){
(a[i_11185] = init_val_or_seq);

var G__11186 = (i_11185 + (1));
i_11185 = G__11186;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((!((s == null))) && ((i < n))){
var G__11187 = (i + (1));
var G__11188 = cljs.core.next(s);
i = G__11187;
s = G__11188;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(function (){var G__11190 = cljs.core.next(arglist);
return (cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(G__11190) : cljs.core.spread.call(null,G__11190));
})());

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var args11191 = [];
var len__8402__auto___11203 = arguments.length;
var i__8403__auto___11204 = (0);
while(true){
if((i__8403__auto___11204 < len__8402__auto___11203)){
args11191.push((arguments[i__8403__auto___11204]));

var G__11205 = (i__8403__auto___11204 + (1));
i__8403__auto___11204 = G__11205;
continue;
} else {
}
break;
}

var G__11196 = args11191.length;
switch (G__11196) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11191.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq11192){
var G__11193 = cljs.core.first(seq11192);
var seq11192__$1 = cljs.core.next(seq11192);
var G__11194 = cljs.core.first(seq11192__$1);
var seq11192__$2 = cljs.core.next(seq11192__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__11193,G__11194,seq11192__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var args11207 = [];
var len__8402__auto___11215 = arguments.length;
var i__8403__auto___11216 = (0);
while(true){
if((i__8403__auto___11216 < len__8402__auto___11215)){
args11207.push((arguments[i__8403__auto___11216]));

var G__11217 = (i__8403__auto___11216 + (1));
i__8403__auto___11216 = G__11217;
continue;
} else {
}
break;
}

var G__11214 = args11207.length;
switch (G__11214) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11207.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__8421__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq11208){
var G__11209 = cljs.core.first(seq11208);
var seq11208__$1 = cljs.core.next(seq11208);
var G__11210 = cljs.core.first(seq11208__$1);
var seq11208__$2 = cljs.core.next(seq11208__$1);
var G__11211 = cljs.core.first(seq11208__$2);
var seq11208__$3 = cljs.core.next(seq11208__$2);
var G__11212 = cljs.core.first(seq11208__$3);
var seq11208__$4 = cljs.core.next(seq11208__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__11209,G__11210,G__11211,G__11212,seq11208__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var args11219 = [];
var len__8402__auto___11225 = arguments.length;
var i__8403__auto___11226 = (0);
while(true){
if((i__8403__auto___11226 < len__8402__auto___11225)){
args11219.push((arguments[i__8403__auto___11226]));

var G__11227 = (i__8403__auto___11226 + (1));
i__8403__auto___11226 = G__11227;
continue;
} else {
}
break;
}

var G__11224 = args11219.length;
switch (G__11224) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11219.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__11229 = ntcoll;
var G__11230 = cljs.core.first(vals);
var G__11231 = cljs.core.next(vals);
tcoll = G__11229;
val = G__11230;
vals = G__11231;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq11220){
var G__11221 = cljs.core.first(seq11220);
var seq11220__$1 = cljs.core.next(seq11220);
var G__11222 = cljs.core.first(seq11220__$1);
var seq11220__$2 = cljs.core.next(seq11220__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11221,G__11222,seq11220__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var args11232 = [];
var len__8402__auto___11239 = arguments.length;
var i__8403__auto___11240 = (0);
while(true){
if((i__8403__auto___11240 < len__8402__auto___11239)){
args11232.push((arguments[i__8403__auto___11240]));

var G__11241 = (i__8403__auto___11240 + (1));
i__8403__auto___11240 = G__11241;
continue;
} else {
}
break;
}

var G__11238 = args11232.length;
switch (G__11238) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11232.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__11243 = ntcoll;
var G__11244 = cljs.core.first(kvs);
var G__11245 = cljs.core.second(kvs);
var G__11246 = cljs.core.nnext(kvs);
tcoll = G__11243;
key = G__11244;
val = G__11245;
kvs = G__11246;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq11233){
var G__11234 = cljs.core.first(seq11233);
var seq11233__$1 = cljs.core.next(seq11233);
var G__11235 = cljs.core.first(seq11233__$1);
var seq11233__$2 = cljs.core.next(seq11233__$1);
var G__11236 = cljs.core.first(seq11233__$2);
var seq11233__$3 = cljs.core.next(seq11233__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11234,G__11235,G__11236,seq11233__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var args11247 = [];
var len__8402__auto___11253 = arguments.length;
var i__8403__auto___11254 = (0);
while(true){
if((i__8403__auto___11254 < len__8402__auto___11253)){
args11247.push((arguments[i__8403__auto___11254]));

var G__11255 = (i__8403__auto___11254 + (1));
i__8403__auto___11254 = G__11255;
continue;
} else {
}
break;
}

var G__11252 = args11247.length;
switch (G__11252) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11247.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__11257 = ntcoll;
var G__11258 = cljs.core.first(ks);
var G__11259 = cljs.core.next(ks);
tcoll = G__11257;
key = G__11258;
ks = G__11259;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq11248){
var G__11249 = cljs.core.first(seq11248);
var seq11248__$1 = cljs.core.next(seq11248);
var G__11250 = cljs.core.first(seq11248__$1);
var seq11248__$2 = cljs.core.next(seq11248__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11249,G__11250,seq11248__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var args11260 = [];
var len__8402__auto___11266 = arguments.length;
var i__8403__auto___11267 = (0);
while(true){
if((i__8403__auto___11267 < len__8402__auto___11266)){
args11260.push((arguments[i__8403__auto___11267]));

var G__11268 = (i__8403__auto___11267 + (1));
i__8403__auto___11267 = G__11268;
continue;
} else {
}
break;
}

var G__11265 = args11260.length;
switch (G__11265) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11260.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__11270 = ntcoll;
var G__11271 = cljs.core.first(vals);
var G__11272 = cljs.core.next(vals);
tcoll = G__11270;
val = G__11271;
vals = G__11272;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq11261){
var G__11262 = cljs.core.first(seq11261);
var seq11261__$1 = cljs.core.next(seq11261);
var G__11263 = cljs.core.first(seq11261__$1);
var seq11261__$2 = cljs.core.next(seq11261__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11262,G__11263,seq11261__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a8256 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a8256);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a8256) : f.call(null,a8256));
}
} else {
var b8257 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a8256,b8257);
} else {
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a8256,b8257) : f.call(null,a8256,b8257));
}
} else {
var c8258 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a8256,b8257,c8258);
} else {
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a8256,b8257,c8258) : f.call(null,a8256,b8257,c8258));
}
} else {
var d8259 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a8256,b8257,c8258,d8259);
} else {
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a8256,b8257,c8258,d8259) : f.call(null,a8256,b8257,c8258,d8259));
}
} else {
var e8260 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a8256,b8257,c8258,d8259,e8260);
} else {
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a8256,b8257,c8258,d8259,e8260) : f.call(null,a8256,b8257,c8258,d8259,e8260));
}
} else {
var f8261 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a8256,b8257,c8258,d8259,e8260,f8261);
} else {
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a8256,b8257,c8258,d8259,e8260,f8261) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261));
}
} else {
var g8262 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a8256,b8257,c8258,d8259,e8260,f8261,g8262);
} else {
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a8256,b8257,c8258,d8259,e8260,f8261,g8262) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262));
}
} else {
var h8263 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263);
} else {
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263));
}
} else {
var i8264 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264);
} else {
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264));
}
} else {
var j8265 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265);
} else {
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265));
}
} else {
var k8266 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266);
} else {
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266));
}
} else {
var l8267 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267);
} else {
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267));
}
} else {
var m8268 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268);
} else {
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268));
}
} else {
var n8269 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269);
} else {
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269));
}
} else {
var o8270 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270);
} else {
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270));
}
} else {
var p8271 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271);
} else {
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271));
}
} else {
var q8272 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272);
} else {
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272));
}
} else {
var r8273 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273);
} else {
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273));
}
} else {
var s8274 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274);
} else {
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274));
}
} else {
var t8275 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274,t8275);
} else {
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274,t8275) : f.call(null,a8256,b8257,c8258,d8259,e8260,f8261,g8262,h8263,i8264,j8265,k8266,l8267,m8268,n8269,o8270,p8271,q8272,r8273,s8274,t8275));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var args11273 = [];
var len__8402__auto___11282 = arguments.length;
var i__8403__auto___11283 = (0);
while(true){
if((i__8403__auto___11283 < len__8402__auto___11282)){
args11273.push((arguments[i__8403__auto___11283]));

var G__11284 = (i__8403__auto___11283 + (1));
i__8403__auto___11283 = G__11284;
continue;
} else {
}
break;
}

var G__11281 = args11273.length;
switch (G__11281) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11273.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__8421__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count((fixed_arity + (1)),arglist);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq11274){
var G__11275 = cljs.core.first(seq11274);
var seq11274__$1 = cljs.core.next(seq11274);
var G__11276 = cljs.core.first(seq11274__$1);
var seq11274__$2 = cljs.core.next(seq11274__$1);
var G__11277 = cljs.core.first(seq11274__$2);
var seq11274__$3 = cljs.core.next(seq11274__$2);
var G__11278 = cljs.core.first(seq11274__$3);
var seq11274__$4 = cljs.core.next(seq11274__$3);
var G__11279 = cljs.core.first(seq11274__$4);
var seq11274__$5 = cljs.core.next(seq11274__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__11275,G__11276,G__11277,G__11278,G__11279,seq11274__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);

/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var args11286 = [];
var len__8402__auto___11311 = arguments.length;
var i__8403__auto___11312 = (0);
while(true){
if((i__8403__auto___11312 < len__8402__auto___11311)){
args11286.push((arguments[i__8403__auto___11312]));

var G__11313 = (i__8403__auto___11312 + (1));
i__8403__auto___11312 = G__11313;
continue;
} else {
}
break;
}

var G__11295 = args11286.length;
switch (G__11295) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11286.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__8421__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__11296 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11296) : f.call(null,G__11296));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__11297 = cljs.core.meta(obj);
var G__11298 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11297,G__11298) : f.call(null,G__11297,G__11298));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__11299 = cljs.core.meta(obj);
var G__11300 = a;
var G__11301 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11299,G__11300,G__11301) : f.call(null,G__11299,G__11300,G__11301));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__11302 = cljs.core.meta(obj);
var G__11303 = a;
var G__11304 = b;
var G__11305 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11302,G__11303,G__11304,G__11305) : f.call(null,G__11302,G__11303,G__11304,G__11305));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__11306 = cljs.core.meta(obj);
var G__11307 = a;
var G__11308 = b;
var G__11309 = c;
var G__11310 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__11306,G__11307,G__11308,G__11309,G__11310) : f.call(null,G__11306,G__11307,G__11308,G__11309,G__11310));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq11287){
var G__11288 = cljs.core.first(seq11287);
var seq11287__$1 = cljs.core.next(seq11287);
var G__11289 = cljs.core.first(seq11287__$1);
var seq11287__$2 = cljs.core.next(seq11287__$1);
var G__11290 = cljs.core.first(seq11287__$2);
var seq11287__$3 = cljs.core.next(seq11287__$2);
var G__11291 = cljs.core.first(seq11287__$3);
var seq11287__$4 = cljs.core.next(seq11287__$3);
var G__11292 = cljs.core.first(seq11287__$4);
var seq11287__$5 = cljs.core.next(seq11287__$4);
var G__11293 = cljs.core.first(seq11287__$5);
var seq11287__$6 = cljs.core.next(seq11287__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__11288,G__11289,G__11290,G__11291,G__11292,G__11293,seq11287__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var args11315 = [];
var len__8402__auto___11321 = arguments.length;
var i__8403__auto___11322 = (0);
while(true){
if((i__8403__auto___11322 < len__8402__auto___11321)){
args11315.push((arguments[i__8403__auto___11322]));

var G__11323 = (i__8403__auto___11322 + (1));
i__8403__auto___11322 = G__11323;
continue;
} else {
}
break;
}

var G__11320 = args11315.length;
switch (G__11320) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11315.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq11316){
var G__11317 = cljs.core.first(seq11316);
var seq11316__$1 = cljs.core.next(seq11316);
var G__11318 = cljs.core.first(seq11316__$1);
var seq11316__$2 = cljs.core.next(seq11316__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__11317,G__11318,seq11316__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t_cljs$core11328 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core11328 = (function (meta11329){
this.meta11329 = meta11329;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t_cljs$core11328.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11330,meta11329__$1){
var self__ = this;
var _11330__$1 = this;
return (new cljs.core.t_cljs$core11328(meta11329__$1));
});

cljs.core.t_cljs$core11328.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11330){
var self__ = this;
var _11330__$1 = this;
return self__.meta11329;
});

cljs.core.t_cljs$core11328.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core11328.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core11328.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core11328.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta11329], null);
});

cljs.core.t_cljs$core11328.cljs$lang$type = true;

cljs.core.t_cljs$core11328.cljs$lang$ctorStr = "cljs.core/t_cljs$core11328";

cljs.core.t_cljs$core11328.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/t_cljs$core11328");
});

cljs.core.__GT_t_cljs$core11328 = (function cljs$core$nil_iter_$___GT_t_cljs$core11328(meta11329){
return (new cljs.core.t_cljs$core11328(meta11329));
});

}

return (new cljs.core.t_cljs$core11328(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(!(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Cannot create iterator from "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__7277__auto__ = !((lt.stepper == null));
if(and__7277__auto__){
return self__.iter.hasNext();
} else {
return and__7277__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__11331 = lt;
var G__11332 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__11331,G__11332) : self__.xform.call(null,G__11331,G__11332));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iter], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(!(iter.hasNext())){
return false;
} else {
var G__11333 = cljs.core.next(iters__$1);
iters__$1 = G__11333;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__8212__auto___11334 = self__.iters.length;
var i_11335 = (0);
while(true){
if((i_11335 < n__8212__auto___11334)){
(self__.nexts[i_11335] = (self__.iters[i_11335]).next());

var G__11336 = (i_11335 + (1));
i_11335 = G__11336;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__7277__auto__ = !((lt.stepper == null));
if(and__7277__auto__){
return this$.hasNext();
} else {
return and__7277__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iters,cljs.core.cst$sym$nexts], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(var_args){
var args11337 = [];
var len__8402__auto___11340 = arguments.length;
var i__8403__auto___11341 = (0);
while(true){
if((i__8403__auto___11341 < len__8402__auto___11340)){
args11337.push((arguments[i__8403__auto___11341]));

var G__11342 = (i__8403__auto___11341 + (1));
i__8403__auto___11341 = G__11342;
continue;
} else {
}
break;
}

var G__11339 = args11337.length;
switch (G__11339) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11337.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.indexOf = (function() {
var G__11344 = null;
var G__11344__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__11344__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11344 = function(x,start){
switch(arguments.length){
case 1:
return G__11344__1.call(this,x);
case 2:
return G__11344__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11344.cljs$core$IFn$_invoke$arity$1 = G__11344__1;
G__11344.cljs$core$IFn$_invoke$arity$2 = G__11344__2;
return G__11344;
})()
;

cljs.core.LazyTransformer.prototype.lastIndexOf = (function() {
var G__11345 = null;
var G__11345__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__11345__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__11345 = function(x,start){
switch(arguments.length){
case 1:
return G__11345__1.call(this,x);
case 2:
return G__11345__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11345.cljs$core$IFn$_invoke$arity$1 = G__11345__1;
G__11345.cljs$core$IFn$_invoke$arity$2 = G__11345__2;
return G__11345;
})()
;

cljs.core.LazyTransformer.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
this$__$1.cljs$core$ISeqable$_seq$arity$1(null);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1.cljs$core$ISeqable$_seq$arity$1(null));
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$stepper,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$meta], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__11346_11350 = cljs.core.seq(colls);
var chunk__11347_11351 = null;
var count__11348_11352 = (0);
var i__11349_11353 = (0);
while(true){
if((i__11349_11353 < count__11348_11352)){
var coll_11354 = chunk__11347_11351.cljs$core$IIndexed$_nth$arity$2(null,i__11349_11353);
iters.push(cljs.core.iter(coll_11354));

var G__11355 = seq__11346_11350;
var G__11356 = chunk__11347_11351;
var G__11357 = count__11348_11352;
var G__11358 = (i__11349_11353 + (1));
seq__11346_11350 = G__11355;
chunk__11347_11351 = G__11356;
count__11348_11352 = G__11357;
i__11349_11353 = G__11358;
continue;
} else {
var temp__4657__auto___11359 = cljs.core.seq(seq__11346_11350);
if(temp__4657__auto___11359){
var seq__11346_11360__$1 = temp__4657__auto___11359;
if(cljs.core.chunked_seq_QMARK_(seq__11346_11360__$1)){
var c__8108__auto___11361 = cljs.core.chunk_first(seq__11346_11360__$1);
var G__11362 = cljs.core.chunk_rest(seq__11346_11360__$1);
var G__11363 = c__8108__auto___11361;
var G__11364 = cljs.core.count(c__8108__auto___11361);
var G__11365 = (0);
seq__11346_11350 = G__11362;
chunk__11347_11351 = G__11363;
count__11348_11352 = G__11364;
i__11349_11353 = G__11365;
continue;
} else {
var coll_11366 = cljs.core.first(seq__11346_11360__$1);
iters.push(cljs.core.iter(coll_11366));

var G__11367 = cljs.core.next(seq__11346_11360__$1);
var G__11368 = null;
var G__11369 = (0);
var G__11370 = (0);
seq__11346_11350 = G__11367;
chunk__11347_11351 = G__11368;
count__11348_11352 = G__11369;
i__11349_11353 = G__11370;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var args11371 = [];
var len__8402__auto___11377 = arguments.length;
var i__8403__auto___11378 = (0);
while(true){
if((i__8403__auto___11378 < len__8402__auto___11377)){
args11371.push((arguments[i__8403__auto___11378]));

var G__11379 = (i__8403__auto___11378 + (1));
i__8403__auto___11378 = G__11379;
continue;
} else {
}
break;
}

var G__11376 = args11371.length;
switch (G__11376) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11371.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__7289__auto__ = cljs.core.seq(coll);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq11372){
var G__11373 = cljs.core.first(seq11372);
var seq11372__$1 = cljs.core.next(seq11372);
var G__11374 = cljs.core.first(seq11372__$1);
var seq11372__$2 = cljs.core.next(seq11372__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__11373,G__11374,seq11372__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__11382 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11382) : pred.call(null,G__11382));
})())){
var G__11383 = pred;
var G__11384 = cljs.core.next(coll);
pred = G__11383;
coll = G__11384;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__7289__auto__ = (function (){var G__11388 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11388) : pred.call(null,G__11388));
})();
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var G__11389 = pred;
var G__11390 = cljs.core.next(coll);
pred = G__11389;
coll = G__11390;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Argument must be an integer: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__11391 = null;
var G__11391__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__11391__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__11391__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__11391__3 = (function() { 
var G__11392__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__11392 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__11393__i = 0, G__11393__a = new Array(arguments.length -  2);
while (G__11393__i < G__11393__a.length) {G__11393__a[G__11393__i] = arguments[G__11393__i + 2]; ++G__11393__i;}
  zs = new cljs.core.IndexedSeq(G__11393__a,0);
} 
return G__11392__delegate.call(this,x,y,zs);};
G__11392.cljs$lang$maxFixedArity = 2;
G__11392.cljs$lang$applyTo = (function (arglist__11394){
var x = cljs.core.first(arglist__11394);
arglist__11394 = cljs.core.next(arglist__11394);
var y = cljs.core.first(arglist__11394);
var zs = cljs.core.rest(arglist__11394);
return G__11392__delegate(x,y,zs);
});
G__11392.cljs$core$IFn$_invoke$arity$variadic = G__11392__delegate;
return G__11392;
})()
;
G__11391 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__11391__0.call(this);
case 1:
return G__11391__1.call(this,x);
case 2:
return G__11391__2.call(this,x,y);
default:
var G__11395 = null;
if (arguments.length > 2) {
var G__11396__i = 0, G__11396__a = new Array(arguments.length -  2);
while (G__11396__i < G__11396__a.length) {G__11396__a[G__11396__i] = arguments[G__11396__i + 2]; ++G__11396__i;}
G__11395 = new cljs.core.IndexedSeq(G__11396__a,0);
}
return G__11391__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__11395);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11391.cljs$lang$maxFixedArity = 2;
G__11391.cljs$lang$applyTo = G__11391__3.cljs$lang$applyTo;
G__11391.cljs$core$IFn$_invoke$arity$0 = G__11391__0;
G__11391.cljs$core$IFn$_invoke$arity$1 = G__11391__1;
G__11391.cljs$core$IFn$_invoke$arity$2 = G__11391__2;
G__11391.cljs$core$IFn$_invoke$arity$variadic = G__11391__3.cljs$core$IFn$_invoke$arity$variadic;
return G__11391;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__11397__delegate = function (args){
return x;
};
var G__11397 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11398__i = 0, G__11398__a = new Array(arguments.length -  0);
while (G__11398__i < G__11398__a.length) {G__11398__a[G__11398__i] = arguments[G__11398__i + 0]; ++G__11398__i;}
  args = new cljs.core.IndexedSeq(G__11398__a,0);
} 
return G__11397__delegate.call(this,args);};
G__11397.cljs$lang$maxFixedArity = 0;
G__11397.cljs$lang$applyTo = (function (arglist__11399){
var args = cljs.core.seq(arglist__11399);
return G__11397__delegate(args);
});
G__11397.cljs$core$IFn$_invoke$arity$variadic = G__11397__delegate;
return G__11397;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var args11400 = [];
var len__8402__auto___11422 = arguments.length;
var i__8403__auto___11423 = (0);
while(true){
if((i__8403__auto___11423 < len__8402__auto___11422)){
args11400.push((arguments[i__8403__auto___11423]));

var G__11424 = (i__8403__auto___11423 + (1));
i__8403__auto___11423 = G__11424;
continue;
} else {
}
break;
}

var G__11406 = args11400.length;
switch (G__11406) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11400.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__11426 = null;
var G__11426__0 = (function (){
var G__11407 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11407) : f.call(null,G__11407));
});
var G__11426__1 = (function (x){
var G__11408 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11408) : f.call(null,G__11408));
});
var G__11426__2 = (function (x,y){
var G__11409 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11409) : f.call(null,G__11409));
});
var G__11426__3 = (function (x,y,z){
var G__11410 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11410) : f.call(null,G__11410));
});
var G__11426__4 = (function() { 
var G__11427__delegate = function (x,y,z,args){
var G__11411 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11411) : f.call(null,G__11411));
};
var G__11427 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11428__i = 0, G__11428__a = new Array(arguments.length -  3);
while (G__11428__i < G__11428__a.length) {G__11428__a[G__11428__i] = arguments[G__11428__i + 3]; ++G__11428__i;}
  args = new cljs.core.IndexedSeq(G__11428__a,0);
} 
return G__11427__delegate.call(this,x,y,z,args);};
G__11427.cljs$lang$maxFixedArity = 3;
G__11427.cljs$lang$applyTo = (function (arglist__11429){
var x = cljs.core.first(arglist__11429);
arglist__11429 = cljs.core.next(arglist__11429);
var y = cljs.core.first(arglist__11429);
arglist__11429 = cljs.core.next(arglist__11429);
var z = cljs.core.first(arglist__11429);
var args = cljs.core.rest(arglist__11429);
return G__11427__delegate(x,y,z,args);
});
G__11427.cljs$core$IFn$_invoke$arity$variadic = G__11427__delegate;
return G__11427;
})()
;
G__11426 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11426__0.call(this);
case 1:
return G__11426__1.call(this,x);
case 2:
return G__11426__2.call(this,x,y);
case 3:
return G__11426__3.call(this,x,y,z);
default:
var G__11430 = null;
if (arguments.length > 3) {
var G__11431__i = 0, G__11431__a = new Array(arguments.length -  3);
while (G__11431__i < G__11431__a.length) {G__11431__a[G__11431__i] = arguments[G__11431__i + 3]; ++G__11431__i;}
G__11430 = new cljs.core.IndexedSeq(G__11431__a,0);
}
return G__11426__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11430);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11426.cljs$lang$maxFixedArity = 3;
G__11426.cljs$lang$applyTo = G__11426__4.cljs$lang$applyTo;
G__11426.cljs$core$IFn$_invoke$arity$0 = G__11426__0;
G__11426.cljs$core$IFn$_invoke$arity$1 = G__11426__1;
G__11426.cljs$core$IFn$_invoke$arity$2 = G__11426__2;
G__11426.cljs$core$IFn$_invoke$arity$3 = G__11426__3;
G__11426.cljs$core$IFn$_invoke$arity$variadic = G__11426__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11426;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__11432 = null;
var G__11432__0 = (function (){
var G__11412 = (function (){var G__11413 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11413) : g.call(null,G__11413));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11412) : f.call(null,G__11412));
});
var G__11432__1 = (function (x){
var G__11414 = (function (){var G__11415 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11415) : g.call(null,G__11415));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11414) : f.call(null,G__11414));
});
var G__11432__2 = (function (x,y){
var G__11416 = (function (){var G__11417 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11417) : g.call(null,G__11417));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11416) : f.call(null,G__11416));
});
var G__11432__3 = (function (x,y,z){
var G__11418 = (function (){var G__11419 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11419) : g.call(null,G__11419));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11418) : f.call(null,G__11418));
});
var G__11432__4 = (function() { 
var G__11433__delegate = function (x,y,z,args){
var G__11420 = (function (){var G__11421 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__11421) : g.call(null,G__11421));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11420) : f.call(null,G__11420));
};
var G__11433 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11434__i = 0, G__11434__a = new Array(arguments.length -  3);
while (G__11434__i < G__11434__a.length) {G__11434__a[G__11434__i] = arguments[G__11434__i + 3]; ++G__11434__i;}
  args = new cljs.core.IndexedSeq(G__11434__a,0);
} 
return G__11433__delegate.call(this,x,y,z,args);};
G__11433.cljs$lang$maxFixedArity = 3;
G__11433.cljs$lang$applyTo = (function (arglist__11435){
var x = cljs.core.first(arglist__11435);
arglist__11435 = cljs.core.next(arglist__11435);
var y = cljs.core.first(arglist__11435);
arglist__11435 = cljs.core.next(arglist__11435);
var z = cljs.core.first(arglist__11435);
var args = cljs.core.rest(arglist__11435);
return G__11433__delegate(x,y,z,args);
});
G__11433.cljs$core$IFn$_invoke$arity$variadic = G__11433__delegate;
return G__11433;
})()
;
G__11432 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11432__0.call(this);
case 1:
return G__11432__1.call(this,x);
case 2:
return G__11432__2.call(this,x,y);
case 3:
return G__11432__3.call(this,x,y,z);
default:
var G__11436 = null;
if (arguments.length > 3) {
var G__11437__i = 0, G__11437__a = new Array(arguments.length -  3);
while (G__11437__i < G__11437__a.length) {G__11437__a[G__11437__i] = arguments[G__11437__i + 3]; ++G__11437__i;}
G__11436 = new cljs.core.IndexedSeq(G__11437__a,0);
}
return G__11432__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11436);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11432.cljs$lang$maxFixedArity = 3;
G__11432.cljs$lang$applyTo = G__11432__4.cljs$lang$applyTo;
G__11432.cljs$core$IFn$_invoke$arity$0 = G__11432__0;
G__11432.cljs$core$IFn$_invoke$arity$1 = G__11432__1;
G__11432.cljs$core$IFn$_invoke$arity$2 = G__11432__2;
G__11432.cljs$core$IFn$_invoke$arity$3 = G__11432__3;
G__11432.cljs$core$IFn$_invoke$arity$variadic = G__11432__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11432;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__11438__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__11439 = cljs.core.first(fs__$2).call(null,ret);
var G__11440 = cljs.core.next(fs__$2);
ret = G__11439;
fs__$2 = G__11440;
continue;
} else {
return ret;
}
break;
}
};
var G__11438 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11441__i = 0, G__11441__a = new Array(arguments.length -  0);
while (G__11441__i < G__11441__a.length) {G__11441__a[G__11441__i] = arguments[G__11441__i + 0]; ++G__11441__i;}
  args = new cljs.core.IndexedSeq(G__11441__a,0);
} 
return G__11438__delegate.call(this,args);};
G__11438.cljs$lang$maxFixedArity = 0;
G__11438.cljs$lang$applyTo = (function (arglist__11442){
var args = cljs.core.seq(arglist__11442);
return G__11438__delegate(args);
});
G__11438.cljs$core$IFn$_invoke$arity$variadic = G__11438__delegate;
return G__11438;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq11401){
var G__11402 = cljs.core.first(seq11401);
var seq11401__$1 = cljs.core.next(seq11401);
var G__11403 = cljs.core.first(seq11401__$1);
var seq11401__$2 = cljs.core.next(seq11401__$1);
var G__11404 = cljs.core.first(seq11401__$2);
var seq11401__$3 = cljs.core.next(seq11401__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__11402,G__11403,G__11404,seq11401__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var args11443 = [];
var len__8402__auto___11451 = arguments.length;
var i__8403__auto___11452 = (0);
while(true){
if((i__8403__auto___11452 < len__8402__auto___11451)){
args11443.push((arguments[i__8403__auto___11452]));

var G__11453 = (i__8403__auto___11452 + (1));
i__8403__auto___11452 = G__11453;
continue;
} else {
}
break;
}

var G__11450 = args11443.length;
switch (G__11450) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11443.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__8421__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__11455 = null;
var G__11455__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__11455__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__11455__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__11455__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__11455__4 = (function() { 
var G__11456__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__11456 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11457__i = 0, G__11457__a = new Array(arguments.length -  3);
while (G__11457__i < G__11457__a.length) {G__11457__a[G__11457__i] = arguments[G__11457__i + 3]; ++G__11457__i;}
  args = new cljs.core.IndexedSeq(G__11457__a,0);
} 
return G__11456__delegate.call(this,x,y,z,args);};
G__11456.cljs$lang$maxFixedArity = 3;
G__11456.cljs$lang$applyTo = (function (arglist__11458){
var x = cljs.core.first(arglist__11458);
arglist__11458 = cljs.core.next(arglist__11458);
var y = cljs.core.first(arglist__11458);
arglist__11458 = cljs.core.next(arglist__11458);
var z = cljs.core.first(arglist__11458);
var args = cljs.core.rest(arglist__11458);
return G__11456__delegate(x,y,z,args);
});
G__11456.cljs$core$IFn$_invoke$arity$variadic = G__11456__delegate;
return G__11456;
})()
;
G__11455 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11455__0.call(this);
case 1:
return G__11455__1.call(this,x);
case 2:
return G__11455__2.call(this,x,y);
case 3:
return G__11455__3.call(this,x,y,z);
default:
var G__11459 = null;
if (arguments.length > 3) {
var G__11460__i = 0, G__11460__a = new Array(arguments.length -  3);
while (G__11460__i < G__11460__a.length) {G__11460__a[G__11460__i] = arguments[G__11460__i + 3]; ++G__11460__i;}
G__11459 = new cljs.core.IndexedSeq(G__11460__a,0);
}
return G__11455__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11459);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11455.cljs$lang$maxFixedArity = 3;
G__11455.cljs$lang$applyTo = G__11455__4.cljs$lang$applyTo;
G__11455.cljs$core$IFn$_invoke$arity$0 = G__11455__0;
G__11455.cljs$core$IFn$_invoke$arity$1 = G__11455__1;
G__11455.cljs$core$IFn$_invoke$arity$2 = G__11455__2;
G__11455.cljs$core$IFn$_invoke$arity$3 = G__11455__3;
G__11455.cljs$core$IFn$_invoke$arity$variadic = G__11455__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11455;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__11461 = null;
var G__11461__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__11461__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__11461__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__11461__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__11461__4 = (function() { 
var G__11462__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__11462 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11463__i = 0, G__11463__a = new Array(arguments.length -  3);
while (G__11463__i < G__11463__a.length) {G__11463__a[G__11463__i] = arguments[G__11463__i + 3]; ++G__11463__i;}
  args = new cljs.core.IndexedSeq(G__11463__a,0);
} 
return G__11462__delegate.call(this,x,y,z,args);};
G__11462.cljs$lang$maxFixedArity = 3;
G__11462.cljs$lang$applyTo = (function (arglist__11464){
var x = cljs.core.first(arglist__11464);
arglist__11464 = cljs.core.next(arglist__11464);
var y = cljs.core.first(arglist__11464);
arglist__11464 = cljs.core.next(arglist__11464);
var z = cljs.core.first(arglist__11464);
var args = cljs.core.rest(arglist__11464);
return G__11462__delegate(x,y,z,args);
});
G__11462.cljs$core$IFn$_invoke$arity$variadic = G__11462__delegate;
return G__11462;
})()
;
G__11461 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11461__0.call(this);
case 1:
return G__11461__1.call(this,x);
case 2:
return G__11461__2.call(this,x,y);
case 3:
return G__11461__3.call(this,x,y,z);
default:
var G__11465 = null;
if (arguments.length > 3) {
var G__11466__i = 0, G__11466__a = new Array(arguments.length -  3);
while (G__11466__i < G__11466__a.length) {G__11466__a[G__11466__i] = arguments[G__11466__i + 3]; ++G__11466__i;}
G__11465 = new cljs.core.IndexedSeq(G__11466__a,0);
}
return G__11461__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11465);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11461.cljs$lang$maxFixedArity = 3;
G__11461.cljs$lang$applyTo = G__11461__4.cljs$lang$applyTo;
G__11461.cljs$core$IFn$_invoke$arity$0 = G__11461__0;
G__11461.cljs$core$IFn$_invoke$arity$1 = G__11461__1;
G__11461.cljs$core$IFn$_invoke$arity$2 = G__11461__2;
G__11461.cljs$core$IFn$_invoke$arity$3 = G__11461__3;
G__11461.cljs$core$IFn$_invoke$arity$variadic = G__11461__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11461;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__11467 = null;
var G__11467__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__11467__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__11467__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__11467__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__11467__4 = (function() { 
var G__11468__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__11468 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11469__i = 0, G__11469__a = new Array(arguments.length -  3);
while (G__11469__i < G__11469__a.length) {G__11469__a[G__11469__i] = arguments[G__11469__i + 3]; ++G__11469__i;}
  args = new cljs.core.IndexedSeq(G__11469__a,0);
} 
return G__11468__delegate.call(this,x,y,z,args);};
G__11468.cljs$lang$maxFixedArity = 3;
G__11468.cljs$lang$applyTo = (function (arglist__11470){
var x = cljs.core.first(arglist__11470);
arglist__11470 = cljs.core.next(arglist__11470);
var y = cljs.core.first(arglist__11470);
arglist__11470 = cljs.core.next(arglist__11470);
var z = cljs.core.first(arglist__11470);
var args = cljs.core.rest(arglist__11470);
return G__11468__delegate(x,y,z,args);
});
G__11468.cljs$core$IFn$_invoke$arity$variadic = G__11468__delegate;
return G__11468;
})()
;
G__11467 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__11467__0.call(this);
case 1:
return G__11467__1.call(this,x);
case 2:
return G__11467__2.call(this,x,y);
case 3:
return G__11467__3.call(this,x,y,z);
default:
var G__11471 = null;
if (arguments.length > 3) {
var G__11472__i = 0, G__11472__a = new Array(arguments.length -  3);
while (G__11472__i < G__11472__a.length) {G__11472__a[G__11472__i] = arguments[G__11472__i + 3]; ++G__11472__i;}
G__11471 = new cljs.core.IndexedSeq(G__11472__a,0);
}
return G__11467__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11471);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11467.cljs$lang$maxFixedArity = 3;
G__11467.cljs$lang$applyTo = G__11467__4.cljs$lang$applyTo;
G__11467.cljs$core$IFn$_invoke$arity$0 = G__11467__0;
G__11467.cljs$core$IFn$_invoke$arity$1 = G__11467__1;
G__11467.cljs$core$IFn$_invoke$arity$2 = G__11467__2;
G__11467.cljs$core$IFn$_invoke$arity$3 = G__11467__3;
G__11467.cljs$core$IFn$_invoke$arity$variadic = G__11467__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11467;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__11473__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__11473 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__11474__i = 0, G__11474__a = new Array(arguments.length -  0);
while (G__11474__i < G__11474__a.length) {G__11474__a[G__11474__i] = arguments[G__11474__i + 0]; ++G__11474__i;}
  args = new cljs.core.IndexedSeq(G__11474__a,0);
} 
return G__11473__delegate.call(this,args);};
G__11473.cljs$lang$maxFixedArity = 0;
G__11473.cljs$lang$applyTo = (function (arglist__11475){
var args = cljs.core.seq(arglist__11475);
return G__11473__delegate(args);
});
G__11473.cljs$core$IFn$_invoke$arity$variadic = G__11473__delegate;
return G__11473;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq11444){
var G__11445 = cljs.core.first(seq11444);
var seq11444__$1 = cljs.core.next(seq11444);
var G__11446 = cljs.core.first(seq11444__$1);
var seq11444__$2 = cljs.core.next(seq11444__$1);
var G__11447 = cljs.core.first(seq11444__$2);
var seq11444__$3 = cljs.core.next(seq11444__$2);
var G__11448 = cljs.core.first(seq11444__$3);
var seq11444__$4 = cljs.core.next(seq11444__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__11445,G__11446,G__11447,G__11448,seq11444__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var args11476 = [];
var len__8402__auto___11495 = arguments.length;
var i__8403__auto___11496 = (0);
while(true){
if((i__8403__auto___11496 < len__8402__auto___11495)){
args11476.push((arguments[i__8403__auto___11496]));

var G__11497 = (i__8403__auto___11496 + (1));
i__8403__auto___11496 = G__11497;
continue;
} else {
}
break;
}

var G__11478 = args11476.length;
switch (G__11478) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11476.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__11499 = null;
var G__11499__1 = (function (a){
var G__11479 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11479) : f.call(null,G__11479));
});
var G__11499__2 = (function (a,b){
var G__11480 = (((a == null))?x:a);
var G__11481 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11480,G__11481) : f.call(null,G__11480,G__11481));
});
var G__11499__3 = (function (a,b,c){
var G__11482 = (((a == null))?x:a);
var G__11483 = b;
var G__11484 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11482,G__11483,G__11484) : f.call(null,G__11482,G__11483,G__11484));
});
var G__11499__4 = (function() { 
var G__11500__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__11500 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__11501__i = 0, G__11501__a = new Array(arguments.length -  3);
while (G__11501__i < G__11501__a.length) {G__11501__a[G__11501__i] = arguments[G__11501__i + 3]; ++G__11501__i;}
  ds = new cljs.core.IndexedSeq(G__11501__a,0);
} 
return G__11500__delegate.call(this,a,b,c,ds);};
G__11500.cljs$lang$maxFixedArity = 3;
G__11500.cljs$lang$applyTo = (function (arglist__11502){
var a = cljs.core.first(arglist__11502);
arglist__11502 = cljs.core.next(arglist__11502);
var b = cljs.core.first(arglist__11502);
arglist__11502 = cljs.core.next(arglist__11502);
var c = cljs.core.first(arglist__11502);
var ds = cljs.core.rest(arglist__11502);
return G__11500__delegate(a,b,c,ds);
});
G__11500.cljs$core$IFn$_invoke$arity$variadic = G__11500__delegate;
return G__11500;
})()
;
G__11499 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__11499__1.call(this,a);
case 2:
return G__11499__2.call(this,a,b);
case 3:
return G__11499__3.call(this,a,b,c);
default:
var G__11503 = null;
if (arguments.length > 3) {
var G__11504__i = 0, G__11504__a = new Array(arguments.length -  3);
while (G__11504__i < G__11504__a.length) {G__11504__a[G__11504__i] = arguments[G__11504__i + 3]; ++G__11504__i;}
G__11503 = new cljs.core.IndexedSeq(G__11504__a,0);
}
return G__11499__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__11503);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11499.cljs$lang$maxFixedArity = 3;
G__11499.cljs$lang$applyTo = G__11499__4.cljs$lang$applyTo;
G__11499.cljs$core$IFn$_invoke$arity$1 = G__11499__1;
G__11499.cljs$core$IFn$_invoke$arity$2 = G__11499__2;
G__11499.cljs$core$IFn$_invoke$arity$3 = G__11499__3;
G__11499.cljs$core$IFn$_invoke$arity$variadic = G__11499__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11499;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__11505 = null;
var G__11505__2 = (function (a,b){
var G__11485 = (((a == null))?x:a);
var G__11486 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11485,G__11486) : f.call(null,G__11485,G__11486));
});
var G__11505__3 = (function (a,b,c){
var G__11487 = (((a == null))?x:a);
var G__11488 = (((b == null))?y:b);
var G__11489 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11487,G__11488,G__11489) : f.call(null,G__11487,G__11488,G__11489));
});
var G__11505__4 = (function() { 
var G__11506__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__11506 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__11507__i = 0, G__11507__a = new Array(arguments.length -  3);
while (G__11507__i < G__11507__a.length) {G__11507__a[G__11507__i] = arguments[G__11507__i + 3]; ++G__11507__i;}
  ds = new cljs.core.IndexedSeq(G__11507__a,0);
} 
return G__11506__delegate.call(this,a,b,c,ds);};
G__11506.cljs$lang$maxFixedArity = 3;
G__11506.cljs$lang$applyTo = (function (arglist__11508){
var a = cljs.core.first(arglist__11508);
arglist__11508 = cljs.core.next(arglist__11508);
var b = cljs.core.first(arglist__11508);
arglist__11508 = cljs.core.next(arglist__11508);
var c = cljs.core.first(arglist__11508);
var ds = cljs.core.rest(arglist__11508);
return G__11506__delegate(a,b,c,ds);
});
G__11506.cljs$core$IFn$_invoke$arity$variadic = G__11506__delegate;
return G__11506;
})()
;
G__11505 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__11505__2.call(this,a,b);
case 3:
return G__11505__3.call(this,a,b,c);
default:
var G__11509 = null;
if (arguments.length > 3) {
var G__11510__i = 0, G__11510__a = new Array(arguments.length -  3);
while (G__11510__i < G__11510__a.length) {G__11510__a[G__11510__i] = arguments[G__11510__i + 3]; ++G__11510__i;}
G__11509 = new cljs.core.IndexedSeq(G__11510__a,0);
}
return G__11505__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__11509);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11505.cljs$lang$maxFixedArity = 3;
G__11505.cljs$lang$applyTo = G__11505__4.cljs$lang$applyTo;
G__11505.cljs$core$IFn$_invoke$arity$2 = G__11505__2;
G__11505.cljs$core$IFn$_invoke$arity$3 = G__11505__3;
G__11505.cljs$core$IFn$_invoke$arity$variadic = G__11505__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11505;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__11511 = null;
var G__11511__2 = (function (a,b){
var G__11490 = (((a == null))?x:a);
var G__11491 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11490,G__11491) : f.call(null,G__11490,G__11491));
});
var G__11511__3 = (function (a,b,c){
var G__11492 = (((a == null))?x:a);
var G__11493 = (((b == null))?y:b);
var G__11494 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11492,G__11493,G__11494) : f.call(null,G__11492,G__11493,G__11494));
});
var G__11511__4 = (function() { 
var G__11512__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__11512 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__11513__i = 0, G__11513__a = new Array(arguments.length -  3);
while (G__11513__i < G__11513__a.length) {G__11513__a[G__11513__i] = arguments[G__11513__i + 3]; ++G__11513__i;}
  ds = new cljs.core.IndexedSeq(G__11513__a,0);
} 
return G__11512__delegate.call(this,a,b,c,ds);};
G__11512.cljs$lang$maxFixedArity = 3;
G__11512.cljs$lang$applyTo = (function (arglist__11514){
var a = cljs.core.first(arglist__11514);
arglist__11514 = cljs.core.next(arglist__11514);
var b = cljs.core.first(arglist__11514);
arglist__11514 = cljs.core.next(arglist__11514);
var c = cljs.core.first(arglist__11514);
var ds = cljs.core.rest(arglist__11514);
return G__11512__delegate(a,b,c,ds);
});
G__11512.cljs$core$IFn$_invoke$arity$variadic = G__11512__delegate;
return G__11512;
})()
;
G__11511 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__11511__2.call(this,a,b);
case 3:
return G__11511__3.call(this,a,b,c);
default:
var G__11515 = null;
if (arguments.length > 3) {
var G__11516__i = 0, G__11516__a = new Array(arguments.length -  3);
while (G__11516__i < G__11516__a.length) {G__11516__a[G__11516__i] = arguments[G__11516__i + 3]; ++G__11516__i;}
G__11515 = new cljs.core.IndexedSeq(G__11516__a,0);
}
return G__11511__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__11515);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11511.cljs$lang$maxFixedArity = 3;
G__11511.cljs$lang$applyTo = G__11511__4.cljs$lang$applyTo;
G__11511.cljs$core$IFn$_invoke$arity$2 = G__11511__2;
G__11511.cljs$core$IFn$_invoke$arity$3 = G__11511__3;
G__11511.cljs$core$IFn$_invoke$arity$variadic = G__11511__4.cljs$core$IFn$_invoke$arity$variadic;
return G__11511;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var args11517 = [];
var len__8402__auto___11548 = arguments.length;
var i__8403__auto___11549 = (0);
while(true){
if((i__8403__auto___11549 < len__8402__auto___11548)){
args11517.push((arguments[i__8403__auto___11549]));

var G__11550 = (i__8403__auto___11549 + (1));
i__8403__auto___11549 = G__11550;
continue;
} else {
}
break;
}

var G__11519 = args11517.length;
switch (G__11519) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11517.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return ((function (i){
return (function() {
var G__11552 = null;
var G__11552__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11552__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11552__2 = (function (result,input){
var G__11520 = result;
var G__11521 = (function (){var G__11522 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__11523 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11522,G__11523) : f.call(null,G__11522,G__11523));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11520,G__11521) : rf.call(null,G__11520,G__11521));
});
G__11552 = function(result,input){
switch(arguments.length){
case 0:
return G__11552__0.call(this);
case 1:
return G__11552__1.call(this,result);
case 2:
return G__11552__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11552.cljs$core$IFn$_invoke$arity$0 = G__11552__0;
G__11552.cljs$core$IFn$_invoke$arity$1 = G__11552__1;
G__11552.cljs$core$IFn$_invoke$arity$2 = G__11552__2;
return G__11552;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__8212__auto___11553 = size;
var i_11554 = (0);
while(true){
if((i_11554 < n__8212__auto___11553)){
cljs.core.chunk_append(b,(function (){var G__11544 = (idx + i_11554);
var G__11545 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11554);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11544,G__11545) : f.call(null,G__11544,G__11545));
})());

var G__11555 = (i_11554 + (1));
i_11554 = G__11555;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__11546 = idx;
var G__11547 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11546,G__11547) : f.call(null,G__11546,G__11547));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var args11556 = [];
var len__8402__auto___11561 = arguments.length;
var i__8403__auto___11562 = (0);
while(true){
if((i__8403__auto___11562 < len__8402__auto___11561)){
args11556.push((arguments[i__8403__auto___11562]));

var G__11563 = (i__8403__auto___11562 + (1));
i__8403__auto___11562 = G__11563;
continue;
} else {
}
break;
}

var G__11558 = args11556.length;
switch (G__11558) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11556.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__11565 = null;
var G__11565__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11565__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11565__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__11565 = function(result,input){
switch(arguments.length){
case 0:
return G__11565__0.call(this);
case 1:
return G__11565__1.call(this,result);
case 2:
return G__11565__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11565.cljs$core$IFn$_invoke$arity$0 = G__11565__0;
G__11565.cljs$core$IFn$_invoke$arity$1 = G__11565__1;
G__11565.cljs$core$IFn$_invoke$arity$2 = G__11565__2;
return G__11565;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__8212__auto___11566 = size;
var i_11567 = (0);
while(true){
if((i_11567 < n__8212__auto___11566)){
var x_11568 = (function (){var G__11559 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11567);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11559) : f.call(null,G__11559));
})();
if((x_11568 == null)){
} else {
cljs.core.chunk_append(b,x_11568);
}

var G__11569 = (i_11567 + (1));
i_11567 = G__11569;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__11560 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11560) : f.call(null,G__11560));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__11570 = cljs.core.seq(self__.watches);
var chunk__11571 = null;
var count__11572 = (0);
var i__11573 = (0);
while(true){
if((i__11573 < count__11572)){
var vec__11574 = chunk__11571.cljs$core$IIndexed$_nth$arity$2(null,i__11573);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11574,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11574,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__11580 = seq__11570;
var G__11581 = chunk__11571;
var G__11582 = count__11572;
var G__11583 = (i__11573 + (1));
seq__11570 = G__11580;
chunk__11571 = G__11581;
count__11572 = G__11582;
i__11573 = G__11583;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__11570);
if(temp__4657__auto__){
var seq__11570__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11570__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__11570__$1);
var G__11584 = cljs.core.chunk_rest(seq__11570__$1);
var G__11585 = c__8108__auto__;
var G__11586 = cljs.core.count(c__8108__auto__);
var G__11587 = (0);
seq__11570 = G__11584;
chunk__11571 = G__11585;
count__11572 = G__11586;
i__11573 = G__11587;
continue;
} else {
var vec__11577 = cljs.core.first(seq__11570__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11577,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11577,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__11588 = cljs.core.next(seq__11570__$1);
var G__11589 = null;
var G__11590 = (0);
var G__11591 = (0);
seq__11570 = G__11588;
chunk__11571 = G__11589;
count__11572 = G__11590;
i__11573 = G__11591;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will be come the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var args11592 = [];
var len__8402__auto___11600 = arguments.length;
var i__8403__auto___11601 = (0);
while(true){
if((i__8403__auto___11601 < len__8402__auto___11600)){
args11592.push((arguments[i__8403__auto___11601]));

var G__11602 = (i__8403__auto___11601 + (1));
i__8403__auto___11601 = G__11602;
continue;
} else {
}
break;
}

var G__11596 = args11592.length;
switch (G__11596) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11592.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8421__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__11597){
var map__11598 = p__11597;
var map__11598__$1 = ((((!((map__11598 == null)))?((((map__11598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11598.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__11598):map__11598);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11598__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11598__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq11593){
var G__11594 = cljs.core.first(seq11593);
var seq11593__$1 = cljs.core.next(seq11593);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__11594,seq11593__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var args11604 = [];
var len__8402__auto___11618 = arguments.length;
var i__8403__auto___11619 = (0);
while(true){
if((i__8403__auto___11619 < len__8402__auto___11618)){
args11604.push((arguments[i__8403__auto___11619]));

var G__11620 = (i__8403__auto___11619 + (1));
i__8403__auto___11619 = G__11620;
continue;
} else {
}
break;
}

var G__11611 = args11604.length;
switch (G__11611) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11604.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__8421__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__11612 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11612) : f.call(null,G__11612));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__11613 = a.state;
var G__11614 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11613,G__11614) : f.call(null,G__11613,G__11614));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__11615 = a.state;
var G__11616 = x;
var G__11617 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11615,G__11616,G__11617) : f.call(null,G__11615,G__11616,G__11617));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq11605){
var G__11606 = cljs.core.first(seq11605);
var seq11605__$1 = cljs.core.next(seq11605);
var G__11607 = cljs.core.first(seq11605__$1);
var seq11605__$2 = cljs.core.next(seq11605__$1);
var G__11608 = cljs.core.first(seq11605__$2);
var seq11605__$3 = cljs.core.next(seq11605__$2);
var G__11609 = cljs.core.first(seq11605__$3);
var seq11605__$4 = cljs.core.next(seq11605__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11606,G__11607,G__11608,G__11609,seq11605__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var args11622 = [];
var len__8402__auto___11653 = arguments.length;
var i__8403__auto___11654 = (0);
while(true){
if((i__8403__auto___11654 < len__8402__auto___11653)){
args11622.push((arguments[i__8403__auto___11654]));

var G__11655 = (i__8403__auto___11654 + (1));
i__8403__auto___11654 = G__11655;
continue;
} else {
}
break;
}

var G__11624 = args11622.length;
switch (G__11624) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11622.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__11657 = null;
var G__11657__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11657__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11657__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__11657 = function(result,input){
switch(arguments.length){
case 0:
return G__11657__0.call(this);
case 1:
return G__11657__1.call(this,result);
case 2:
return G__11657__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11657.cljs$core$IFn$_invoke$arity$0 = G__11657__0;
G__11657.cljs$core$IFn$_invoke$arity$1 = G__11657__1;
G__11657.cljs$core$IFn$_invoke$arity$2 = G__11657__2;
return G__11657;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__8212__auto___11658 = size;
var i_11659 = (0);
while(true){
if((i_11659 < n__8212__auto___11658)){
var x_11660 = (function (){var G__11649 = (idx + i_11659);
var G__11650 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11659);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11649,G__11650) : f.call(null,G__11649,G__11650));
})();
if((x_11660 == null)){
} else {
cljs.core.chunk_append(b,x_11660);
}

var G__11661 = (i_11659 + (1));
i_11659 = G__11661;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__11651 = idx;
var G__11652 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11651,G__11652) : f.call(null,G__11651,G__11652));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var args11668 = [];
var len__8402__auto___11675 = arguments.length;
var i__8403__auto___11676 = (0);
while(true){
if((i__8403__auto___11676 < len__8402__auto___11675)){
args11668.push((arguments[i__8403__auto___11676]));

var G__11677 = (i__8403__auto___11676 + (1));
i__8403__auto___11676 = G__11677;
continue;
} else {
}
break;
}

var G__11674 = args11668.length;
switch (G__11674) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11668.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__7277__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__11679__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__7277__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__7277__auto__;
}
})());
};
var G__11679 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11680__i = 0, G__11680__a = new Array(arguments.length -  3);
while (G__11680__i < G__11680__a.length) {G__11680__a[G__11680__i] = arguments[G__11680__i + 3]; ++G__11680__i;}
  args = new cljs.core.IndexedSeq(G__11680__a,0);
} 
return G__11679__delegate.call(this,x,y,z,args);};
G__11679.cljs$lang$maxFixedArity = 3;
G__11679.cljs$lang$applyTo = (function (arglist__11681){
var x = cljs.core.first(arglist__11681);
arglist__11681 = cljs.core.next(arglist__11681);
var y = cljs.core.first(arglist__11681);
arglist__11681 = cljs.core.next(arglist__11681);
var z = cljs.core.first(arglist__11681);
var args = cljs.core.rest(arglist__11681);
return G__11679__delegate(x,y,z,args);
});
G__11679.cljs$core$IFn$_invoke$arity$variadic = G__11679__delegate;
return G__11679;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__11682 = null;
if (arguments.length > 3) {
var G__11683__i = 0, G__11683__a = new Array(arguments.length -  3);
while (G__11683__i < G__11683__a.length) {G__11683__a[G__11683__i] = arguments[G__11683__i + 3]; ++G__11683__i;}
G__11682 = new cljs.core.IndexedSeq(G__11683__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11682);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__7277__auto____$1)){
var and__7277__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__7277__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__7277__auto____$1)){
var and__7277__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__7277__auto____$2)){
var and__7277__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__7277__auto____$3)){
var and__7277__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__7277__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__7277__auto____$4;
}
} else {
return and__7277__auto____$3;
}
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__11684__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__7277__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.every_QMARK_(((function (and__7277__auto__){
return (function (p1__11662_SHARP_){
var and__7277__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__11662_SHARP_) : p1.call(null,p1__11662_SHARP_));
if(cljs.core.truth_(and__7277__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__11662_SHARP_) : p2.call(null,p1__11662_SHARP_));
} else {
return and__7277__auto____$1;
}
});})(and__7277__auto__))
,args);
} else {
return and__7277__auto__;
}
})());
};
var G__11684 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11685__i = 0, G__11685__a = new Array(arguments.length -  3);
while (G__11685__i < G__11685__a.length) {G__11685__a[G__11685__i] = arguments[G__11685__i + 3]; ++G__11685__i;}
  args = new cljs.core.IndexedSeq(G__11685__a,0);
} 
return G__11684__delegate.call(this,x,y,z,args);};
G__11684.cljs$lang$maxFixedArity = 3;
G__11684.cljs$lang$applyTo = (function (arglist__11686){
var x = cljs.core.first(arglist__11686);
arglist__11686 = cljs.core.next(arglist__11686);
var y = cljs.core.first(arglist__11686);
arglist__11686 = cljs.core.next(arglist__11686);
var z = cljs.core.first(arglist__11686);
var args = cljs.core.rest(arglist__11686);
return G__11684__delegate(x,y,z,args);
});
G__11684.cljs$core$IFn$_invoke$arity$variadic = G__11684__delegate;
return G__11684;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__11687 = null;
if (arguments.length > 3) {
var G__11688__i = 0, G__11688__a = new Array(arguments.length -  3);
while (G__11688__i < G__11688__a.length) {G__11688__a[G__11688__i] = arguments[G__11688__i + 3]; ++G__11688__i;}
G__11687 = new cljs.core.IndexedSeq(G__11688__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11687);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__7277__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__7277__auto____$1)){
var and__7277__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__7277__auto____$2)){
var and__7277__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__7277__auto____$3)){
var and__7277__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__7277__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__7277__auto____$4;
}
} else {
return and__7277__auto____$3;
}
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__7277__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__7277__auto____$1)){
var and__7277__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__7277__auto____$2)){
var and__7277__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__7277__auto____$3)){
var and__7277__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__7277__auto____$4)){
var and__7277__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__7277__auto____$5)){
var and__7277__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__7277__auto____$6)){
var and__7277__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__7277__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__7277__auto____$7;
}
} else {
return and__7277__auto____$6;
}
} else {
return and__7277__auto____$5;
}
} else {
return and__7277__auto____$4;
}
} else {
return and__7277__auto____$3;
}
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__11689__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__7277__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.every_QMARK_(((function (and__7277__auto__){
return (function (p1__11663_SHARP_){
var and__7277__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__11663_SHARP_) : p1.call(null,p1__11663_SHARP_));
if(cljs.core.truth_(and__7277__auto____$1)){
var and__7277__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__11663_SHARP_) : p2.call(null,p1__11663_SHARP_));
if(cljs.core.truth_(and__7277__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__11663_SHARP_) : p3.call(null,p1__11663_SHARP_));
} else {
return and__7277__auto____$2;
}
} else {
return and__7277__auto____$1;
}
});})(and__7277__auto__))
,args);
} else {
return and__7277__auto__;
}
})());
};
var G__11689 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11690__i = 0, G__11690__a = new Array(arguments.length -  3);
while (G__11690__i < G__11690__a.length) {G__11690__a[G__11690__i] = arguments[G__11690__i + 3]; ++G__11690__i;}
  args = new cljs.core.IndexedSeq(G__11690__a,0);
} 
return G__11689__delegate.call(this,x,y,z,args);};
G__11689.cljs$lang$maxFixedArity = 3;
G__11689.cljs$lang$applyTo = (function (arglist__11691){
var x = cljs.core.first(arglist__11691);
arglist__11691 = cljs.core.next(arglist__11691);
var y = cljs.core.first(arglist__11691);
arglist__11691 = cljs.core.next(arglist__11691);
var z = cljs.core.first(arglist__11691);
var args = cljs.core.rest(arglist__11691);
return G__11689__delegate(x,y,z,args);
});
G__11689.cljs$core$IFn$_invoke$arity$variadic = G__11689__delegate;
return G__11689;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__11692 = null;
if (arguments.length > 3) {
var G__11693__i = 0, G__11693__a = new Array(arguments.length -  3);
while (G__11693__i < G__11693__a.length) {G__11693__a[G__11693__i] = arguments[G__11693__i + 3]; ++G__11693__i;}
G__11692 = new cljs.core.IndexedSeq(G__11693__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11692);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__11664_SHARP_){
return (p1__11664_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11664_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11664_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__11665_SHARP_){
var and__7277__auto__ = (p1__11665_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11665_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11665_SHARP_.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
return (p1__11665_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11665_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__11665_SHARP_.call(null,y));
} else {
return and__7277__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__11666_SHARP_){
var and__7277__auto__ = (p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11666_SHARP_.call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = (p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__11666_SHARP_.call(null,y));
if(cljs.core.truth_(and__7277__auto____$1)){
return (p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11666_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__11666_SHARP_.call(null,z));
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__11694__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__7277__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.every_QMARK_(((function (and__7277__auto__,ps__$1){
return (function (p1__11667_SHARP_){
return cljs.core.every_QMARK_(p1__11667_SHARP_,args);
});})(and__7277__auto__,ps__$1))
,ps__$1);
} else {
return and__7277__auto__;
}
})());
};
var G__11694 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11695__i = 0, G__11695__a = new Array(arguments.length -  3);
while (G__11695__i < G__11695__a.length) {G__11695__a[G__11695__i] = arguments[G__11695__i + 3]; ++G__11695__i;}
  args = new cljs.core.IndexedSeq(G__11695__a,0);
} 
return G__11694__delegate.call(this,x,y,z,args);};
G__11694.cljs$lang$maxFixedArity = 3;
G__11694.cljs$lang$applyTo = (function (arglist__11696){
var x = cljs.core.first(arglist__11696);
arglist__11696 = cljs.core.next(arglist__11696);
var y = cljs.core.first(arglist__11696);
arglist__11696 = cljs.core.next(arglist__11696);
var z = cljs.core.first(arglist__11696);
var args = cljs.core.rest(arglist__11696);
return G__11694__delegate(x,y,z,args);
});
G__11694.cljs$core$IFn$_invoke$arity$variadic = G__11694__delegate;
return G__11694;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__11697 = null;
if (arguments.length > 3) {
var G__11698__i = 0, G__11698__a = new Array(arguments.length -  3);
while (G__11698__i < G__11698__a.length) {G__11698__a[G__11698__i] = arguments[G__11698__i + 3]; ++G__11698__i;}
G__11697 = new cljs.core.IndexedSeq(G__11698__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11697);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq11669){
var G__11670 = cljs.core.first(seq11669);
var seq11669__$1 = cljs.core.next(seq11669);
var G__11671 = cljs.core.first(seq11669__$1);
var seq11669__$2 = cljs.core.next(seq11669__$1);
var G__11672 = cljs.core.first(seq11669__$2);
var seq11669__$3 = cljs.core.next(seq11669__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__11670,G__11671,G__11672,seq11669__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var args11705 = [];
var len__8402__auto___11712 = arguments.length;
var i__8403__auto___11713 = (0);
while(true){
if((i__8403__auto___11713 < len__8402__auto___11712)){
args11705.push((arguments[i__8403__auto___11713]));

var G__11714 = (i__8403__auto___11713 + (1));
i__8403__auto___11713 = G__11714;
continue;
} else {
}
break;
}

var G__11711 = args11705.length;
switch (G__11711) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11705.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__7289__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__7289__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__11716__delegate = function (x,y,z,args){
var or__7289__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__11716 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11717__i = 0, G__11717__a = new Array(arguments.length -  3);
while (G__11717__i < G__11717__a.length) {G__11717__a[G__11717__i] = arguments[G__11717__i + 3]; ++G__11717__i;}
  args = new cljs.core.IndexedSeq(G__11717__a,0);
} 
return G__11716__delegate.call(this,x,y,z,args);};
G__11716.cljs$lang$maxFixedArity = 3;
G__11716.cljs$lang$applyTo = (function (arglist__11718){
var x = cljs.core.first(arglist__11718);
arglist__11718 = cljs.core.next(arglist__11718);
var y = cljs.core.first(arglist__11718);
arglist__11718 = cljs.core.next(arglist__11718);
var z = cljs.core.first(arglist__11718);
var args = cljs.core.rest(arglist__11718);
return G__11716__delegate(x,y,z,args);
});
G__11716.cljs$core$IFn$_invoke$arity$variadic = G__11716__delegate;
return G__11716;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__11719 = null;
if (arguments.length > 3) {
var G__11720__i = 0, G__11720__a = new Array(arguments.length -  3);
while (G__11720__i < G__11720__a.length) {G__11720__a[G__11720__i] = arguments[G__11720__i + 3]; ++G__11720__i;}
G__11719 = new cljs.core.IndexedSeq(G__11720__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11719);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
var or__7289__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__7289__auto____$3)){
return or__7289__auto____$3;
} else {
var or__7289__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__7289__auto____$4)){
return or__7289__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__11721__delegate = function (x,y,z,args){
var or__7289__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.some(((function (or__7289__auto__){
return (function (p1__11699_SHARP_){
var or__7289__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__11699_SHARP_) : p1.call(null,p1__11699_SHARP_));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__11699_SHARP_) : p2.call(null,p1__11699_SHARP_));
}
});})(or__7289__auto__))
,args);
}
};
var G__11721 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11722__i = 0, G__11722__a = new Array(arguments.length -  3);
while (G__11722__i < G__11722__a.length) {G__11722__a[G__11722__i] = arguments[G__11722__i + 3]; ++G__11722__i;}
  args = new cljs.core.IndexedSeq(G__11722__a,0);
} 
return G__11721__delegate.call(this,x,y,z,args);};
G__11721.cljs$lang$maxFixedArity = 3;
G__11721.cljs$lang$applyTo = (function (arglist__11723){
var x = cljs.core.first(arglist__11723);
arglist__11723 = cljs.core.next(arglist__11723);
var y = cljs.core.first(arglist__11723);
arglist__11723 = cljs.core.next(arglist__11723);
var z = cljs.core.first(arglist__11723);
var args = cljs.core.rest(arglist__11723);
return G__11721__delegate(x,y,z,args);
});
G__11721.cljs$core$IFn$_invoke$arity$variadic = G__11721__delegate;
return G__11721;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__11724 = null;
if (arguments.length > 3) {
var G__11725__i = 0, G__11725__a = new Array(arguments.length -  3);
while (G__11725__i < G__11725__a.length) {G__11725__a[G__11725__i] = arguments[G__11725__i + 3]; ++G__11725__i;}
G__11724 = new cljs.core.IndexedSeq(G__11725__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11724);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
var or__7289__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__7289__auto____$3)){
return or__7289__auto____$3;
} else {
var or__7289__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__7289__auto____$4)){
return or__7289__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__7289__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
var or__7289__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__7289__auto____$3)){
return or__7289__auto____$3;
} else {
var or__7289__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__7289__auto____$4)){
return or__7289__auto____$4;
} else {
var or__7289__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__7289__auto____$5)){
return or__7289__auto____$5;
} else {
var or__7289__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__7289__auto____$6)){
return or__7289__auto____$6;
} else {
var or__7289__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__7289__auto____$7)){
return or__7289__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__11726__delegate = function (x,y,z,args){
var or__7289__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.some(((function (or__7289__auto__){
return (function (p1__11700_SHARP_){
var or__7289__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__11700_SHARP_) : p1.call(null,p1__11700_SHARP_));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__11700_SHARP_) : p2.call(null,p1__11700_SHARP_));
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__11700_SHARP_) : p3.call(null,p1__11700_SHARP_));
}
}
});})(or__7289__auto__))
,args);
}
};
var G__11726 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11727__i = 0, G__11727__a = new Array(arguments.length -  3);
while (G__11727__i < G__11727__a.length) {G__11727__a[G__11727__i] = arguments[G__11727__i + 3]; ++G__11727__i;}
  args = new cljs.core.IndexedSeq(G__11727__a,0);
} 
return G__11726__delegate.call(this,x,y,z,args);};
G__11726.cljs$lang$maxFixedArity = 3;
G__11726.cljs$lang$applyTo = (function (arglist__11728){
var x = cljs.core.first(arglist__11728);
arglist__11728 = cljs.core.next(arglist__11728);
var y = cljs.core.first(arglist__11728);
arglist__11728 = cljs.core.next(arglist__11728);
var z = cljs.core.first(arglist__11728);
var args = cljs.core.rest(arglist__11728);
return G__11726__delegate(x,y,z,args);
});
G__11726.cljs$core$IFn$_invoke$arity$variadic = G__11726__delegate;
return G__11726;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__11729 = null;
if (arguments.length > 3) {
var G__11730__i = 0, G__11730__a = new Array(arguments.length -  3);
while (G__11730__i < G__11730__a.length) {G__11730__a[G__11730__i] = arguments[G__11730__i + 3]; ++G__11730__i;}
G__11729 = new cljs.core.IndexedSeq(G__11730__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11729);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__11701_SHARP_){
return (p1__11701_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11701_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11701_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__11702_SHARP_){
var or__7289__auto__ = (p1__11702_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11702_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11702_SHARP_.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (p1__11702_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11702_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__11702_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__11703_SHARP_){
var or__7289__auto__ = (p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__11703_SHARP_.call(null,x));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__11703_SHARP_.call(null,y));
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return (p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__11703_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__11703_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__11731__delegate = function (x,y,z,args){
var or__7289__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.some(((function (or__7289__auto__,ps__$1){
return (function (p1__11704_SHARP_){
return cljs.core.some(p1__11704_SHARP_,args);
});})(or__7289__auto__,ps__$1))
,ps__$1);
}
};
var G__11731 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__11732__i = 0, G__11732__a = new Array(arguments.length -  3);
while (G__11732__i < G__11732__a.length) {G__11732__a[G__11732__i] = arguments[G__11732__i + 3]; ++G__11732__i;}
  args = new cljs.core.IndexedSeq(G__11732__a,0);
} 
return G__11731__delegate.call(this,x,y,z,args);};
G__11731.cljs$lang$maxFixedArity = 3;
G__11731.cljs$lang$applyTo = (function (arglist__11733){
var x = cljs.core.first(arglist__11733);
arglist__11733 = cljs.core.next(arglist__11733);
var y = cljs.core.first(arglist__11733);
arglist__11733 = cljs.core.next(arglist__11733);
var z = cljs.core.first(arglist__11733);
var args = cljs.core.rest(arglist__11733);
return G__11731__delegate(x,y,z,args);
});
G__11731.cljs$core$IFn$_invoke$arity$variadic = G__11731__delegate;
return G__11731;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__11734 = null;
if (arguments.length > 3) {
var G__11735__i = 0, G__11735__a = new Array(arguments.length -  3);
while (G__11735__i < G__11735__a.length) {G__11735__a[G__11735__i] = arguments[G__11735__i + 3]; ++G__11735__i;}
G__11734 = new cljs.core.IndexedSeq(G__11735__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__11734);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq11706){
var G__11707 = cljs.core.first(seq11706);
var seq11706__$1 = cljs.core.next(seq11706);
var G__11708 = cljs.core.first(seq11706__$1);
var seq11706__$2 = cljs.core.next(seq11706__$1);
var G__11709 = cljs.core.first(seq11706__$2);
var seq11706__$3 = cljs.core.next(seq11706__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__11707,G__11708,G__11709,seq11706__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var args11737 = [];
var len__8402__auto___11757 = arguments.length;
var i__8403__auto___11758 = (0);
while(true){
if((i__8403__auto___11758 < len__8402__auto___11757)){
args11737.push((arguments[i__8403__auto___11758]));

var G__11759 = (i__8403__auto___11758 + (1));
i__8403__auto___11758 = G__11759;
continue;
} else {
}
break;
}

var G__11744 = args11737.length;
switch (G__11744) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11737.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__8421__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__11761 = null;
var G__11761__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11761__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11761__2 = (function (result,input){
var G__11745 = result;
var G__11746 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11745,G__11746) : rf.call(null,G__11745,G__11746));
});
var G__11761__3 = (function() { 
var G__11762__delegate = function (result,input,inputs){
var G__11747 = result;
var G__11748 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__11747,G__11748) : rf.call(null,G__11747,G__11748));
};
var G__11762 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__11763__i = 0, G__11763__a = new Array(arguments.length -  2);
while (G__11763__i < G__11763__a.length) {G__11763__a[G__11763__i] = arguments[G__11763__i + 2]; ++G__11763__i;}
  inputs = new cljs.core.IndexedSeq(G__11763__a,0);
} 
return G__11762__delegate.call(this,result,input,inputs);};
G__11762.cljs$lang$maxFixedArity = 2;
G__11762.cljs$lang$applyTo = (function (arglist__11764){
var result = cljs.core.first(arglist__11764);
arglist__11764 = cljs.core.next(arglist__11764);
var input = cljs.core.first(arglist__11764);
var inputs = cljs.core.rest(arglist__11764);
return G__11762__delegate(result,input,inputs);
});
G__11762.cljs$core$IFn$_invoke$arity$variadic = G__11762__delegate;
return G__11762;
})()
;
G__11761 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__11761__0.call(this);
case 1:
return G__11761__1.call(this,result);
case 2:
return G__11761__2.call(this,result,input);
default:
var G__11765 = null;
if (arguments.length > 2) {
var G__11766__i = 0, G__11766__a = new Array(arguments.length -  2);
while (G__11766__i < G__11766__a.length) {G__11766__a[G__11766__i] = arguments[G__11766__i + 2]; ++G__11766__i;}
G__11765 = new cljs.core.IndexedSeq(G__11766__a,0);
}
return G__11761__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__11765);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11761.cljs$lang$maxFixedArity = 2;
G__11761.cljs$lang$applyTo = G__11761__3.cljs$lang$applyTo;
G__11761.cljs$core$IFn$_invoke$arity$0 = G__11761__0;
G__11761.cljs$core$IFn$_invoke$arity$1 = G__11761__1;
G__11761.cljs$core$IFn$_invoke$arity$2 = G__11761__2;
G__11761.cljs$core$IFn$_invoke$arity$variadic = G__11761__3.cljs$core$IFn$_invoke$arity$variadic;
return G__11761;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__8212__auto___11767 = size;
var i_11768 = (0);
while(true){
if((i_11768 < n__8212__auto___11767)){
cljs.core.chunk_append(b,(function (){var G__11749 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11768);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11749) : f.call(null,G__11749));
})());

var G__11769 = (i_11768 + (1));
i_11768 = G__11769;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__11750 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11750) : f.call(null,G__11750));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__11751 = cljs.core.first(s1);
var G__11752 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11751,G__11752) : f.call(null,G__11751,G__11752));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__11753 = cljs.core.first(s1);
var G__11754 = cljs.core.first(s2);
var G__11755 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11753,G__11754,G__11755) : f.call(null,G__11753,G__11754,G__11755));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__11736_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__11736_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq11738){
var G__11739 = cljs.core.first(seq11738);
var seq11738__$1 = cljs.core.next(seq11738);
var G__11740 = cljs.core.first(seq11738__$1);
var seq11738__$2 = cljs.core.next(seq11738__$1);
var G__11741 = cljs.core.first(seq11738__$2);
var seq11738__$3 = cljs.core.next(seq11738__$2);
var G__11742 = cljs.core.first(seq11738__$3);
var seq11738__$4 = cljs.core.next(seq11738__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__11739,G__11740,G__11741,G__11742,seq11738__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var args11770 = [];
var len__8402__auto___11773 = arguments.length;
var i__8403__auto___11774 = (0);
while(true){
if((i__8403__auto___11774 < len__8402__auto___11773)){
args11770.push((arguments[i__8403__auto___11774]));

var G__11775 = (i__8403__auto___11774 + (1));
i__8403__auto___11774 = G__11775;
continue;
} else {
}
break;
}

var G__11772 = args11770.length;
switch (G__11772) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11770.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11777 = null;
var G__11777__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11777__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11777__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__11777 = function(result,input){
switch(arguments.length){
case 0:
return G__11777__0.call(this);
case 1:
return G__11777__1.call(this,result);
case 2:
return G__11777__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11777.cljs$core$IFn$_invoke$arity$0 = G__11777__0;
G__11777.cljs$core$IFn$_invoke$arity$1 = G__11777__1;
G__11777.cljs$core$IFn$_invoke$arity$2 = G__11777__2;
return G__11777;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var args11778 = [];
var len__8402__auto___11781 = arguments.length;
var i__8403__auto___11782 = (0);
while(true){
if((i__8403__auto___11782 < len__8402__auto___11781)){
args11778.push((arguments[i__8403__auto___11782]));

var G__11783 = (i__8403__auto___11782 + (1));
i__8403__auto___11782 = G__11783;
continue;
} else {
}
break;
}

var G__11780 = args11778.length;
switch (G__11780) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11778.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__11785 = null;
var G__11785__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11785__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11785__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__11785 = function(result,input){
switch(arguments.length){
case 0:
return G__11785__0.call(this);
case 1:
return G__11785__1.call(this,result);
case 2:
return G__11785__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11785.cljs$core$IFn$_invoke$arity$0 = G__11785__0;
G__11785.cljs$core$IFn$_invoke$arity$1 = G__11785__1;
G__11785.cljs$core$IFn$_invoke$arity$2 = G__11785__2;
return G__11785;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__11786 = (n__$1 - (1));
var G__11787 = cljs.core.rest(s);
n__$1 = G__11786;
coll__$1 = G__11787;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var args11788 = [];
var len__8402__auto___11791 = arguments.length;
var i__8403__auto___11792 = (0);
while(true){
if((i__8403__auto___11792 < len__8402__auto___11791)){
args11788.push((arguments[i__8403__auto___11792]));

var G__11793 = (i__8403__auto___11792 + (1));
i__8403__auto___11792 = G__11793;
continue;
} else {
}
break;
}

var G__11790 = args11788.length;
switch (G__11790) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11788.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__11795 = cljs.core.next(s);
var G__11796 = cljs.core.next(lead);
s = G__11795;
lead = G__11796;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var args11797 = [];
var len__8402__auto___11802 = arguments.length;
var i__8403__auto___11803 = (0);
while(true){
if((i__8403__auto___11803 < len__8402__auto___11802)){
args11797.push((arguments[i__8403__auto___11803]));

var G__11804 = (i__8403__auto___11803 + (1));
i__8403__auto___11803 = G__11804;
continue;
} else {
}
break;
}

var G__11799 = args11797.length;
switch (G__11799) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11797.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__11806 = null;
var G__11806__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11806__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11806__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__7277__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__7277__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__7277__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__11806 = function(result,input){
switch(arguments.length){
case 0:
return G__11806__0.call(this);
case 1:
return G__11806__1.call(this,result);
case 2:
return G__11806__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11806.cljs$core$IFn$_invoke$arity$0 = G__11806__0;
G__11806.cljs$core$IFn$_invoke$arity$1 = G__11806__1;
G__11806.cljs$core$IFn$_invoke$arity$2 = G__11806__2;
return G__11806;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__7277__auto__ = s;
if(and__7277__auto__){
var G__11801 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__11801) : pred__$1.call(null,G__11801));
} else {
return and__7277__auto__;
}
})())){
var G__11807 = pred__$1;
var G__11808 = cljs.core.rest(s);
pred__$1 = G__11807;
coll__$1 = G__11808;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,(cljs.core.cycle.cljs$core$IFn$_invoke$arity$1 ? cljs.core.cycle.cljs$core$IFn$_invoke$arity$1(s) : cljs.core.cycle.call(null,s)));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var args11809 = [];
var len__8402__auto___11812 = arguments.length;
var i__8403__auto___11813 = (0);
while(true){
if((i__8403__auto___11813 < len__8402__auto___11812)){
args11809.push((arguments[i__8403__auto___11813]));

var G__11814 = (i__8403__auto___11813 + (1));
i__8403__auto___11813 = G__11814;
continue;
} else {
}
break;
}

var G__11811 = args11809.length;
switch (G__11811) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11809.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var args11816 = [];
var len__8402__auto___11819 = arguments.length;
var i__8403__auto___11820 = (0);
while(true){
if((i__8403__auto___11820 < len__8402__auto___11819)){
args11816.push((arguments[i__8403__auto___11820]));

var G__11821 = (i__8403__auto___11820 + (1));
i__8403__auto___11820 = G__11821;
continue;
} else {
}
break;
}

var G__11818 = args11816.length;
switch (G__11818) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11816.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
var G__11825 = f;
var G__11826 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x));
return (cljs.core.iterate.cljs$core$IFn$_invoke$arity$2 ? cljs.core.iterate.cljs$core$IFn$_invoke$arity$2(G__11825,G__11826) : cljs.core.iterate.call(null,G__11825,G__11826));
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var args11827 = [];
var len__8402__auto___11833 = arguments.length;
var i__8403__auto___11834 = (0);
while(true){
if((i__8403__auto___11834 < len__8402__auto___11833)){
args11827.push((arguments[i__8403__auto___11834]));

var G__11835 = (i__8403__auto___11834 + (1));
i__8403__auto___11834 = G__11835;
continue;
} else {
}
break;
}

var G__11832 = args11827.length;
switch (G__11832) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11827.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq11828){
var G__11829 = cljs.core.first(seq11828);
var seq11828__$1 = cljs.core.next(seq11828);
var G__11830 = cljs.core.first(seq11828__$1);
var seq11828__$2 = cljs.core.next(seq11828__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__11829,G__11830,seq11828__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var args11837 = [];
var len__8402__auto___11840 = arguments.length;
var i__8403__auto___11841 = (0);
while(true){
if((i__8403__auto___11841 < len__8402__auto___11840)){
args11837.push((arguments[i__8403__auto___11841]));

var G__11842 = (i__8403__auto___11841 + (1));
i__8403__auto___11841 = G__11842;
continue;
} else {
}
break;
}

var G__11839 = args11837.length;
switch (G__11839) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11837.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__11844 = null;
var G__11844__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11844__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11844__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__11844 = function(result,input){
switch(arguments.length){
case 0:
return G__11844__0.call(this);
case 1:
return G__11844__1.call(this,result);
case 2:
return G__11844__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11844.cljs$core$IFn$_invoke$arity$0 = G__11844__0;
G__11844.cljs$core$IFn$_invoke$arity$1 = G__11844__1;
G__11844.cljs$core$IFn$_invoke$arity$2 = G__11844__2;
return G__11844;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var coll__$1 = temp__4655__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var args11853 = [];
var len__8402__auto___11858 = arguments.length;
var i__8403__auto___11859 = (0);
while(true){
if((i__8403__auto___11859 < len__8402__auto___11858)){
args11853.push((arguments[i__8403__auto___11859]));

var G__11860 = (i__8403__auto___11859 + (1));
i__8403__auto___11859 = G__11860;
continue;
} else {
}
break;
}

var G__11857 = args11853.length;
switch (G__11857) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11853.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8421__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq11854){
var G__11855 = cljs.core.first(seq11854);
var seq11854__$1 = cljs.core.next(seq11854);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__11855,seq11854__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var args11862 = [];
var len__8402__auto___11866 = arguments.length;
var i__8403__auto___11867 = (0);
while(true){
if((i__8403__auto___11867 < len__8402__auto___11866)){
args11862.push((arguments[i__8403__auto___11867]));

var G__11868 = (i__8403__auto___11867 + (1));
i__8403__auto___11867 = G__11868;
continue;
} else {
}
break;
}

var G__11864 = args11862.length;
switch (G__11864) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11862.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__11870 = null;
var G__11870__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__11870__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__11870__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__11870 = function(result,input){
switch(arguments.length){
case 0:
return G__11870__0.call(this);
case 1:
return G__11870__1.call(this,result);
case 2:
return G__11870__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__11870.cljs$core$IFn$_invoke$arity$0 = G__11870__0;
G__11870.cljs$core$IFn$_invoke$arity$1 = G__11870__1;
G__11870.cljs$core$IFn$_invoke$arity$2 = G__11870__2;
return G__11870;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__8212__auto___11871 = size;
var i_11872 = (0);
while(true){
if((i_11872 < n__8212__auto___11871)){
if(cljs.core.truth_((function (){var G__11865 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11872);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__11865) : pred.call(null,G__11865));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_11872));
} else {
}

var G__11873 = (i_11872 + (1));
i_11872 = G__11873;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var args11874 = [];
var len__8402__auto___11877 = arguments.length;
var i__8403__auto___11878 = (0);
while(true){
if((i__8403__auto___11878 < len__8402__auto___11877)){
args11874.push((arguments[i__8403__auto___11878]));

var G__11879 = (i__8403__auto___11878 + (1));
i__8403__auto___11878 = G__11879;
continue;
} else {
}
break;
}

var G__11876 = args11874.length;
switch (G__11876) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11874.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__11881_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__11881_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var args11882 = [];
var len__8402__auto___11887 = arguments.length;
var i__8403__auto___11888 = (0);
while(true){
if((i__8403__auto___11888 < len__8402__auto___11887)){
args11882.push((arguments[i__8403__auto___11888]));

var G__11889 = (i__8403__auto___11888 + (1));
i__8403__auto___11888 = G__11889;
continue;
} else {
}
break;
}

var G__11884 = args11882.length;
switch (G__11884) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11882.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$)))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var args11891 = [];
var len__8402__auto___11899 = arguments.length;
var i__8403__auto___11900 = (0);
while(true){
if((i__8403__auto___11900 < len__8402__auto___11899)){
args11891.push((arguments[i__8403__auto___11900]));

var G__11901 = (i__8403__auto___11900 + (1));
i__8403__auto___11900 = G__11901;
continue;
} else {
}
break;
}

var G__11898 = args11891.length;
switch (G__11898) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11891.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__8421__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq11892){
var G__11893 = cljs.core.first(seq11892);
var seq11892__$1 = cljs.core.next(seq11892);
var G__11894 = cljs.core.first(seq11892__$1);
var seq11892__$2 = cljs.core.next(seq11892__$1);
var G__11895 = cljs.core.first(seq11892__$2);
var seq11892__$3 = cljs.core.next(seq11892__$2);
var G__11896 = cljs.core.first(seq11892__$3);
var seq11892__$4 = cljs.core.next(seq11892__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__11893,G__11894,G__11895,G__11896,seq11892__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var args11903 = [];
var len__8402__auto___11906 = arguments.length;
var i__8403__auto___11907 = (0);
while(true){
if((i__8403__auto___11907 < len__8402__auto___11906)){
args11903.push((arguments[i__8403__auto___11907]));

var G__11908 = (i__8403__auto___11907 + (1));
i__8403__auto___11907 = G__11908;
continue;
} else {
}
break;
}

var G__11905 = args11903.length;
switch (G__11905) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11903.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
var x__8131__auto__ = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad));
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto__);
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var args11910 = [];
var len__8402__auto___11913 = arguments.length;
var i__8403__auto___11914 = (0);
while(true){
if((i__8403__auto___11914 < len__8402__auto___11913)){
args11910.push((arguments[i__8403__auto___11914]));

var G__11915 = (i__8403__auto___11914 + (1));
i__8403__auto___11914 = G__11915;
continue;
} else {
}
break;
}

var G__11912 = args11910.length;
switch (G__11912) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11910.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(!((ks__$1 == null))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__11917 = sentinel;
var G__11918 = m__$2;
var G__11919 = cljs.core.next(ks__$1);
sentinel = G__11917;
m__$1 = G__11918;
ks__$1 = G__11919;
continue;
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__11920,v){
var vec__11927 = p__11920;
var seq__11928 = cljs.core.seq(vec__11927);
var first__11929 = cljs.core.first(seq__11928);
var seq__11928__$1 = cljs.core.next(seq__11928);
var k = first__11929;
var ks = seq__11928__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11931 = ks;
var G__11932 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__11930,G__11931,G__11932) : cljs.core.assoc_in.call(null,G__11930,G__11931,G__11932));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var args11933 = [];
var len__8402__auto___11973 = arguments.length;
var i__8403__auto___11974 = (0);
while(true){
if((i__8403__auto___11974 < len__8402__auto___11973)){
args11933.push((arguments[i__8403__auto___11974]));

var G__11975 = (i__8403__auto___11974 + (1));
i__8403__auto___11974 = G__11975;
continue;
} else {
}
break;
}

var G__11942 = args11933.length;
switch (G__11942) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11933.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__8421__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__11943,f){
var vec__11944 = p__11943;
var seq__11945 = cljs.core.seq(vec__11944);
var first__11946 = cljs.core.first(seq__11945);
var seq__11945__$1 = cljs.core.next(seq__11945);
var k = first__11946;
var ks = seq__11945__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11947) : f.call(null,G__11947));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__11948,f,a){
var vec__11949 = p__11948;
var seq__11950 = cljs.core.seq(vec__11949);
var first__11951 = cljs.core.first(seq__11950);
var seq__11950__$1 = cljs.core.next(seq__11950);
var k = first__11951;
var ks = seq__11950__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11952 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11953 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11952,G__11953) : f.call(null,G__11952,G__11953));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__11954,f,a,b){
var vec__11955 = p__11954;
var seq__11956 = cljs.core.seq(vec__11955);
var first__11957 = cljs.core.first(seq__11956);
var seq__11956__$1 = cljs.core.next(seq__11956);
var k = first__11957;
var ks = seq__11956__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11958 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11959 = a;
var G__11960 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11958,G__11959,G__11960) : f.call(null,G__11958,G__11959,G__11960));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__11961,f,a,b,c){
var vec__11962 = p__11961;
var seq__11963 = cljs.core.seq(vec__11962);
var first__11964 = cljs.core.first(seq__11963);
var seq__11963__$1 = cljs.core.next(seq__11963);
var k = first__11964;
var ks = seq__11963__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11965 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11966 = a;
var G__11967 = b;
var G__11968 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11965,G__11966,G__11967,G__11968) : f.call(null,G__11965,G__11966,G__11967,G__11968));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__11969,f,a,b,c,args){
var vec__11970 = p__11969;
var seq__11971 = cljs.core.seq(vec__11970);
var first__11972 = cljs.core.first(seq__11971);
var seq__11971__$1 = cljs.core.next(seq__11971);
var k = first__11972;
var ks = seq__11971__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq11934){
var G__11935 = cljs.core.first(seq11934);
var seq11934__$1 = cljs.core.next(seq11934);
var G__11936 = cljs.core.first(seq11934__$1);
var seq11934__$2 = cljs.core.next(seq11934__$1);
var G__11937 = cljs.core.first(seq11934__$2);
var seq11934__$3 = cljs.core.next(seq11934__$2);
var G__11938 = cljs.core.first(seq11934__$3);
var seq11934__$4 = cljs.core.next(seq11934__$3);
var G__11939 = cljs.core.first(seq11934__$4);
var seq11934__$5 = cljs.core.next(seq11934__$4);
var G__11940 = cljs.core.first(seq11934__$5);
var seq11934__$6 = cljs.core.next(seq11934__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__11935,G__11936,G__11937,G__11938,G__11939,G__11940,seq11934__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var args11977 = [];
var len__8402__auto___11997 = arguments.length;
var i__8403__auto___11998 = (0);
while(true){
if((i__8403__auto___11998 < len__8402__auto___11997)){
args11977.push((arguments[i__8403__auto___11998]));

var G__11999 = (i__8403__auto___11998 + (1));
i__8403__auto___11998 = G__11999;
continue;
} else {
}
break;
}

var G__11986 = args11977.length;
switch (G__11986) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args11977.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__8421__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11987 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__11987) : f.call(null,G__11987));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11988 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11989 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__11988,G__11989) : f.call(null,G__11988,G__11989));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11990 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11991 = x;
var G__11992 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__11990,G__11991,G__11992) : f.call(null,G__11990,G__11991,G__11992));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__11993 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__11994 = x;
var G__11995 = y;
var G__11996 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__11993,G__11994,G__11995,G__11996) : f.call(null,G__11993,G__11994,G__11995,G__11996));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq11978){
var G__11979 = cljs.core.first(seq11978);
var seq11978__$1 = cljs.core.next(seq11978);
var G__11980 = cljs.core.first(seq11978__$1);
var seq11978__$2 = cljs.core.next(seq11978__$1);
var G__11981 = cljs.core.first(seq11978__$2);
var seq11978__$3 = cljs.core.next(seq11978__$2);
var G__11982 = cljs.core.first(seq11978__$3);
var seq11978__$4 = cljs.core.next(seq11978__$3);
var G__11983 = cljs.core.first(seq11978__$4);
var seq11978__$5 = cljs.core.next(seq11978__$4);
var G__11984 = cljs.core.first(seq11978__$5);
var seq11978__$6 = cljs.core.next(seq11978__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__11979,G__11980,G__11981,G__11982,G__11983,G__11984,seq11978__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__12001 = (ll - (5));
var G__12002 = r;
ll = G__12001;
ret = G__12002;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = (function (){var G__12007 = pv;
var G__12008 = (level - (5));
var G__12009 = child;
var G__12010 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__12007,G__12008,G__12009,G__12010) : cljs.core.push_tail.call(null,G__12007,G__12008,G__12009,G__12010));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No item "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(i),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" in vector of length "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__12011 = cljs.core.pv_aget(node,(0));
var G__12012 = (level - (5));
node = G__12011;
level = G__12012;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__12013 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__12014 = (level - (5));
node = G__12013;
level = G__12014;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__12020 = pv;
var G__12021 = (level - (5));
var G__12022 = cljs.core.pv_aget(node,subidx);
var G__12023 = i;
var G__12024 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__12020,G__12021,G__12022,G__12023,G__12024) : cljs.core.do_assoc.call(null,G__12020,G__12021,G__12022,G__12023,G__12024));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__12028 = pv;
var G__12029 = (level - (5));
var G__12030 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__12028,G__12029,G__12030) : cljs.core.pop_tail.call(null,G__12028,G__12029,G__12030));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1,k)], null);
});

cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__12041 = null;
var G__12041__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12041__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12041 = function(x,start){
switch(arguments.length){
case 1:
return G__12041__1.call(this,x);
case 2:
return G__12041__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12041.cljs$core$IFn$_invoke$arity$1 = G__12041__1;
G__12041.cljs$core$IFn$_invoke$arity$2 = G__12041__2;
return G__12041;
})()
;

cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__12042 = null;
var G__12042__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12042__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12042 = function(x,start){
switch(arguments.length){
case 1:
return G__12042__1.call(this,x);
case 2:
return G__12042__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12042.cljs$core$IFn$_invoke$arity$1 = G__12042__1;
G__12042.cljs$core$IFn$_invoke$arity$2 = G__12042__2;
return G__12042;
})()
;

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__12032 = init__$2;
var G__12033 = (j + i);
var G__12034 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12032,G__12033,G__12034) : f.call(null,G__12032,G__12033,G__12034));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__12043 = (j + (1));
var G__12044 = init__$3;
j = G__12043;
init__$2 = G__12044;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12045 = (i + len);
var G__12046 = init__$2;
i = G__12045;
init__$1 = G__12046;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds  [0,"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = cljs.core._iterator(other);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__12035 = init__$2;
var G__12036 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12035,G__12036) : f.call(null,G__12035,G__12036));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__12047 = (j + (1));
var G__12048 = init__$3;
j = G__12047;
init__$2 = G__12048;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12049 = (i + len);
var G__12050 = init__$2;
i = G__12049;
init__$1 = G__12050;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
var G__12037 = coll__$1;
var G__12038 = cljs.core.first_array_for_longvec(coll__$1);
var G__12039 = (0);
var G__12040 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__12037,G__12038,G__12039,G__12040) : cljs.core.chunked_seq.call(null,G__12037,G__12038,G__12039,G__12040));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__8212__auto___12051 = len;
var i_12052 = (0);
while(true){
if((i_12052 < n__8212__auto___12051)){
(new_tail[i_12052] = (self__.tail[i_12052]));

var G__12053 = (i_12052 + (1));
i_12052 = G__12053;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__12054 = null;
var G__12054__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__12054__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__12054 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12054__2.call(this,self__,k);
case 3:
return G__12054__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12054.cljs$core$IFn$_invoke$arity$2 = G__12054__2;
G__12054.cljs$core$IFn$_invoke$arity$3 = G__12054__3;
return G__12054;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args12031){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12031)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__12055 = (i + (1));
var G__12056 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__12055;
out = G__12056;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12058 = arguments.length;
var i__8403__auto___12059 = (0);
while(true){
if((i__8403__auto___12059 < len__8402__auto___12058)){
args__8409__auto__.push((arguments[i__8403__auto___12059]));

var G__12060 = (i__8403__auto___12059 + (1));
i__8403__auto___12059 = G__12060;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq12057){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12057));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__12083 = null;
var G__12083__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12083__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12083 = function(x,start){
switch(arguments.length){
case 1:
return G__12083__1.call(this,x);
case 2:
return G__12083__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12083.cljs$core$IFn$_invoke$arity$1 = G__12083__1;
G__12083.cljs$core$IFn$_invoke$arity$2 = G__12083__2;
return G__12083;
})()
;

cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__12084 = null;
var G__12084__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12084__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12084 = function(x,start){
switch(arguments.length){
case 1:
return G__12084__1.call(this,x);
case 2:
return G__12084__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12084.cljs$core$IFn$_invoke$arity$1 = G__12084__1;
G__12084.cljs$core$IFn$_invoke$arity$2 = G__12084__2;
return G__12084;
})()
;

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__12061 = self__.vec;
var G__12062 = self__.node;
var G__12063 = self__.i;
var G__12064 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__12061,G__12062,G__12063,G__12064) : cljs.core.chunked_seq.call(null,G__12061,G__12062,G__12063,G__12064));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__12065 = self__.vec;
var G__12066 = (self__.i + self__.off);
var G__12067 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__12065,G__12066,G__12067) : cljs.core.subvec.call(null,G__12065,G__12066,G__12067));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__12068 = self__.vec;
var G__12069 = (self__.i + self__.off);
var G__12070 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__12068,G__12069,G__12070) : cljs.core.subvec.call(null,G__12068,G__12069,G__12070));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__12071 = self__.vec;
var G__12072 = self__.node;
var G__12073 = self__.i;
var G__12074 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__12071,G__12072,G__12073,G__12074) : cljs.core.chunked_seq.call(null,G__12071,G__12072,G__12073,G__12074));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__12075 = self__.vec;
var G__12076 = cljs.core.unchecked_array_for(self__.vec,end);
var G__12077 = end;
var G__12078 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__12075,G__12076,G__12077,G__12078) : cljs.core.chunked_seq.call(null,G__12075,G__12076,G__12077,G__12078));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,m));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__12079 = self__.vec;
var G__12080 = cljs.core.unchecked_array_for(self__.vec,end);
var G__12081 = end;
var G__12082 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__12079,G__12080,G__12081,G__12082) : cljs.core.chunked_seq.call(null,G__12079,G__12080,G__12081,G__12082));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var args12085 = [];
var len__8402__auto___12088 = arguments.length;
var i__8403__auto___12089 = (0);
while(true){
if((i__8403__auto___12089 < len__8402__auto___12088)){
args12085.push((arguments[i__8403__auto___12089]));

var G__12090 = (i__8403__auto___12089 + (1));
i__8403__auto___12089 = G__12090;
continue;
} else {
}
break;
}

var G__12087 = args12085.length;
switch (G__12087) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12085.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,key){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1,key)], null);
});

cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.indexOf = (function() {
var G__12112 = null;
var G__12112__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12112__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__12112 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__12112__1.call(this,x);
case 2:
return G__12112__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12112.cljs$core$IFn$_invoke$arity$1 = G__12112__1;
G__12112.cljs$core$IFn$_invoke$arity$2 = G__12112__2;
return G__12112;
})()
;

cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__12113 = null;
var G__12113__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12113__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__12113 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__12113__1.call(this,x);
case 2:
return G__12113__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12113.cljs$core$IFn$_invoke$arity$1 = G__12113__1;
G__12113.cljs$core$IFn$_invoke$arity$2 = G__12113__2;
return G__12113;
})()
;

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__12093 = init__$1;
var G__12094 = j;
var G__12095 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12093,G__12094,G__12095) : f.call(null,G__12093,G__12094,G__12095));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12114 = (i + (1));
var G__12115 = (j + (1));
var G__12116 = init__$2;
i = G__12114;
j = G__12115;
init__$1 = G__12116;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if(((n < (0))) || (((self__.end + (1)) <= v_pos))){
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds [0,"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1("]")].join('')));
} else {
var G__12096 = self__.meta;
var G__12097 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__12098 = self__.start;
var G__12099 = (function (){var x__7625__auto__ = self__.end;
var y__7626__auto__ = (v_pos + (1));
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
})();
var G__12100 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__12096,G__12097,G__12098,G__12099,G__12100) : cljs.core.build_subvec.call(null,G__12096,G__12097,G__12098,G__12099,G__12100));
}
});

cljs.core.Subvec.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__12101 = self__.meta;
var G__12102 = self__.v;
var G__12103 = self__.start;
var G__12104 = (self__.end - (1));
var G__12105 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__12101,G__12102,G__12103,G__12104,G__12105) : cljs.core.build_subvec.call(null,G__12101,G__12102,G__12103,G__12104,G__12105));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,meta__$1,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__12107 = self__.meta;
var G__12108 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__12109 = self__.start;
var G__12110 = (self__.end + (1));
var G__12111 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__12107,G__12108,G__12109,G__12110,G__12111) : cljs.core.build_subvec.call(null,G__12107,G__12108,G__12109,G__12110,G__12111));
});

cljs.core.Subvec.prototype.call = (function() {
var G__12117 = null;
var G__12117__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__12117__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__12117 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12117__2.call(this,self__,k);
case 3:
return G__12117__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12117.cljs$core$IFn$_invoke$arity$2 = G__12117__2;
G__12117.cljs$core$IFn$_invoke$arity$3 = G__12117__3;
return G__12117;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args12092){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12092)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__12118 = meta;
var G__12119 = v.v;
var G__12120 = (v.start + start);
var G__12121 = (v.start + end);
var G__12122 = __hash;
meta = G__12118;
v = G__12119;
start = G__12120;
end = G__12121;
__hash = G__12122;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var args12123 = [];
var len__8402__auto___12126 = arguments.length;
var i__8403__auto___12127 = (0);
while(true){
if((i__8403__auto___12127 < len__8402__auto___12126)){
args12123.push((arguments[i__8403__auto___12127]));

var G__12128 = (i__8403__auto___12127 + (1));
i__8403__auto___12127 = G__12128;
continue;
} else {
}
break;
}

var G__12125 = args12123.length;
switch (G__12125) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12123.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode({},cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
var G__12138 = tv;
var G__12139 = (level - (5));
var G__12140 = child;
var G__12141 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__12138,G__12139,G__12140,G__12141) : cljs.core.tv_push_tail.call(null,G__12138,G__12139,G__12140,G__12141));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__12145 = tv;
var G__12146 = (level - (5));
var G__12147 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__12145,G__12146,G__12147) : cljs.core.tv_pop_tail.call(null,G__12145,G__12146,G__12147));
})();
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__12148 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__12149 = (level - (5));
node = G__12148;
level = G__12149;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Index "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" out of bounds for TransientVector of length"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__12153 = null;
var G__12153__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12153__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12153 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12153__2.call(this,self__,k);
case 3:
return G__12153__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12153.cljs$core$IFn$_invoke$arity$2 = G__12153__2;
G__12153.cljs$core$IFn$_invoke$arity$3 = G__12153__3;
return G__12153;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args12150){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12150)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
})
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__7289__auto__ = (!((self__.fseq == null))) && (cljs.core.seq(self__.fseq));
if(or__7289__auto__){
return or__7289__auto__;
} else {
var and__7277__auto__ = !((self__.riter == null));
if(and__7277__auto__){
return self__.riter.hasNext();
} else {
return and__7277__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.fseq == null))){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((!((self__.riter == null))) && (self__.riter.hasNext())){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentQueueIter");
});

cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__12154 = null;
var G__12154__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12154__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12154 = function(x,start){
switch(arguments.length){
case 1:
return G__12154__1.call(this,x);
case 2:
return G__12154__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12154.cljs$core$IFn$_invoke$arity$1 = G__12154__1;
G__12154.cljs$core$IFn$_invoke$arity$2 = G__12154__2;
return G__12154;
})()
;

cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__12155 = null;
var G__12155__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12155__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12155 = function(x,start){
switch(arguments.length){
case 1:
return G__12155__1.call(this,x);
case 2:
return G__12155__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12155.cljs$core$IFn$_invoke$arity$1 = G__12155__1;
G__12155.cljs$core$IFn$_invoke$arity$2 = G__12155__2;
return G__12155;
})()
;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__12156 = null;
var G__12156__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12156__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12156 = function(x,start){
switch(arguments.length){
case 1:
return G__12156__1.call(this,x);
case 2:
return G__12156__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12156.cljs$core$IFn$_invoke$arity$1 = G__12156__1;
G__12156.cljs$core$IFn$_invoke$arity$2 = G__12156__2;
return G__12156;
})()
;

cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__12157 = null;
var G__12157__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__12157__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12157 = function(x,start){
switch(arguments.length){
case 1:
return G__12157__1.call(this,x);
case 2:
return G__12157__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12157.cljs$core$IFn$_invoke$arity$1 = G__12157__1;
G__12157.cljs$core$IFn$_invoke$arity$2 = G__12157__2;
return G__12157;
})()
;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__7289__auto__ = self__.front;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = self__.rear;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 *   false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__12158 = (i + incr);
i = G__12158;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__12159 = (i + (1));
var G__12160 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__12159;
out = G__12160;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = {};
var l = ks.length;
var i_12165 = (0);
while(true){
if((i_12165 < l)){
var k_12166 = (ks[i_12165]);
(new_obj[k_12166] = (obj[k_12166]));

var G__12167 = (i_12165 + (1));
i_12165 = G__12167;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1,k)], null);
});

cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__12170 = init__$1;
var G__12171 = k;
var G__12172 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12170,G__12171,G__12172) : f.call(null,G__12170,G__12171,G__12172));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12173 = cljs.core.rest(keys__$1);
var G__12174 = init__$2;
keys__$1 = G__12173;
init__$1 = G__12174;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__12168_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__12168_SHARP_,(self__.strobj[p1__12168_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__12175 = null;
var G__12175__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12175__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12175 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12175__2.call(this,self__,k);
case 3:
return G__12175__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12175.cljs$core$IFn$_invoke$arity$2 = G__12175__2;
G__12175.cljs$core$IFn$_invoke$arity$3 = G__12175__3;
return G__12175;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args12169){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12169)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
})
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__7289__auto__ = (self__.i < self__.base_count);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k)], null);
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/RecordIter");
});

cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__12178 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12178,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12178,(1),null);
self__.s = cljs.core.next(self__.s);

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__12181 = (i + (2));
i = G__12181;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn))){
return i;
} else {
var G__12182 = (i + (2));
i = G__12182;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str))){
return i;
} else {
var G__12183 = (i + (2));
i = G__12183;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__12184 = (i + (2));
i = G__12184;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__12185 = (i + (2));
i = G__12185;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if((goog.isString(k)) || (typeof k === 'number')){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_12186 = (0);
while(true){
if((i_12186 < l)){
(narr[i_12186] = (arr[i_12186]));

var G__12187 = (i_12186 + (1));
i_12186 = G__12187;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__12188 = null;
var G__12188__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12188__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12188 = function(x,start){
switch(arguments.length){
case 1:
return G__12188__1.call(this,x);
case 2:
return G__12188__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12188.cljs$core$IFn$_invoke$arity$1 = G__12188__1;
G__12188.cljs$core$IFn$_invoke$arity$2 = G__12188__2;
return G__12188;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__12189 = null;
var G__12189__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12189__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12189 = function(x,start){
switch(arguments.length){
case 1:
return G__12189__1.call(this,x);
case 2:
return G__12189__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12189.cljs$core$IFn$_invoke$arity$1 = G__12189__1;
G__12189.cljs$core$IFn$_invoke$arity$2 = G__12189__2;
return G__12189;
})()
;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll__$1,k)], null);
});

cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__12191 = cljs.core.seq(coll);
var chunk__12192 = null;
var count__12193 = (0);
var i__12194 = (0);
while(true){
if((i__12194 < count__12193)){
var vec__12195 = chunk__12192.cljs$core$IIndexed$_nth$arity$2(null,i__12194);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12195,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12195,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12208 = seq__12191;
var G__12209 = chunk__12192;
var G__12210 = count__12193;
var G__12211 = (i__12194 + (1));
seq__12191 = G__12208;
chunk__12192 = G__12209;
count__12193 = G__12210;
i__12194 = G__12211;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__12191);
if(temp__4657__auto__){
var seq__12191__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12191__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__12191__$1);
var G__12212 = cljs.core.chunk_rest(seq__12191__$1);
var G__12213 = c__8108__auto__;
var G__12214 = cljs.core.count(c__8108__auto__);
var G__12215 = (0);
seq__12191 = G__12212;
chunk__12192 = G__12213;
count__12193 = G__12214;
i__12194 = G__12215;
continue;
} else {
var vec__12198 = cljs.core.first(seq__12191__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12198,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12198,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12216 = cljs.core.next(seq__12191__$1);
var G__12217 = null;
var G__12218 = (0);
var G__12219 = (0);
seq__12191 = G__12216;
chunk__12192 = G__12217;
count__12193 = G__12218;
i__12194 = G__12219;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__12201 = init__$1;
var G__12202 = (self__.arr[i]);
var G__12203 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12201,G__12202,G__12203) : f.call(null,G__12201,G__12202,G__12203));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12220 = (i + (2));
var G__12221 = init__$2;
i = G__12220;
init__$1 = G__12221;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((!((other == null)))?((((other.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === other.cljs$core$IMap$)))?true:false):false)){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__12222 = (i + (2));
i = G__12222;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap({},self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__12223 = (s + (2));
var G__12224 = d;
s = G__12223;
d = G__12224;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__12225 = (s + (2));
var G__12226 = (d + (2));
s = G__12225;
d = G__12226;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__12207 = cljs.core.aclone(self__.arr);
(G__12207[(idx + (1))] = v);

return G__12207;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__12227 = ret.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__12228 = cljs.core.next(es);
ret = G__12227;
es = G__12228;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__12229 = null;
var G__12229__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12229__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12229 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12229__2.call(this,self__,k);
case 3:
return G__12229__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12229.cljs$core$IFn$_invoke$arity$2 = G__12229__2;
G__12229.cljs$core$IFn$_invoke$arity$3 = G__12229__3;
return G__12229;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args12190){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12190)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_12230 = (0);
while(true){
if((i_12230 < arr__$1.length)){
var k_12231 = (arr__$1[i_12230]);
var v_12232 = (arr__$1[(i_12230 + (1))]);
var idx_12233 = cljs.core.array_index_of(ret,k_12231);
if((idx_12233 === (-1))){
ret.push(k_12231);

ret.push(v_12232);
} else {
}

var G__12234 = (i_12230 + (2));
i_12230 = G__12234;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
});
cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_12236 = (0);
while(true){
if((i_12236 < arr.length)){
var k_12237 = (arr[i_12236]);
var v_12238 = (arr[(i_12236 + (1))]);
var idx_12239 = cljs.core.array_index_of(ret,k_12237);
if((idx_12239 === (-1))){
var G__12235_12240 = ret;
G__12235_12240.push(k_12237);

G__12235_12240.push(v_12238);

} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Duplicate key: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_12237)].join('')));
}

var G__12241 = (i_12236 + (2));
i_12236 = G__12241;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
});
cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (arr){
var ret = [];
var i_12243 = (0);
while(true){
if((i_12243 < arr.length)){
var k_12244 = (arr[i_12243]);
var v_12245 = (arr[(i_12243 + (1))]);
var idx_12246 = cljs.core.array_index_of(ret,k_12244);
if((idx_12246 === (-1))){
var G__12242_12247 = ret;
G__12242_12247.push(k_12244);

G__12242_12247.push(v_12245);

} else {
(ret[(idx_12246 + (1))] = v_12245);
}

var G__12248 = (i_12243 + (2));
i_12243 = G__12248;
continue;
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(ret.length / (2)),ret,null));
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__12251 = cljs.core.next(es);
var G__12252 = tcoll__$2.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__12251;
tcoll__$2 = G__12252;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__12250_12253 = self__.arr;
G__12250_12253.pop();

G__12250_12253.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__12254 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__12255 = (i + (2));
out = G__12254;
i = G__12255;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var args12256 = [];
var len__8402__auto___12261 = arguments.length;
var i__8403__auto___12262 = (0);
while(true){
if((i__8403__auto___12262 < len__8402__auto___12261)){
args12256.push((arguments[i__8403__auto___12262]));

var G__12263 = (i__8403__auto___12262 + (1));
i__8403__auto___12262 = G__12263;
continue;
} else {
}
break;
}

var G__12258 = args12256.length;
switch (G__12258) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12256.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__12259 = cljs.core.aclone(arr);
(G__12259[i] = a);

return G__12259;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__12260 = cljs.core.aclone(arr);
(G__12260[i] = a);

(G__12260[j] = b);

return G__12260;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var args12265 = [];
var len__8402__auto___12268 = arguments.length;
var i__8403__auto___12269 = (0);
while(true){
if((i__8403__auto___12269 < len__8402__auto___12268)){
args12265.push((arguments[i__8403__auto___12269]));

var G__12270 = (i__8403__auto___12269 + (1));
i__8403__auto___12269 = G__12270;
continue;
} else {
}
break;
}

var G__12267 = args12265.length;
switch (G__12267) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12265.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__12275 = init__$1;
var G__12276 = k;
var G__12277 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12275,G__12276,G__12277) : f.call(null,G__12275,G__12276,G__12277));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12278 = (i + (2));
var G__12279 = init__$2;
i = G__12278;
init__$1 = G__12279;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
})
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = ((!((key == null)))?self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,node_or_val], null):((!((node_or_val == null)))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__7289__auto__ = !((self__.next_entry == null));
if(or__7289__auto__){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = !((self__.next_iter == null));
if(or__7289__auto____$1){
return or__7289__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(!((self__.next_entry == null))){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if(!((self__.next_iter == null))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/NodeIterator");
});

cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
removed_leaf_QMARK_.val = true;

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_12293 = (0);
var j_12294 = (0);
while(true){
if((i_12293 < (32))){
if((((self__.bitmap >>> i_12293) & (1)) === (0))){
var G__12295 = (i_12293 + (1));
var G__12296 = j_12294;
i_12293 = G__12295;
j_12294 = G__12296;
continue;
} else {
(nodes[i_12293] = ((!(((self__.arr[j_12294]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_12294])),(self__.arr[j_12294]),(self__.arr[(j_12294 + (1))]),added_leaf_QMARK_):(self__.arr[(j_12294 + (1))])));

var G__12297 = (i_12293 + (1));
var G__12298 = (j_12294 + (2));
i_12293 = G__12297;
j_12294 = G__12298;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__12280 = edit__$1;
var G__12281 = (shift + (5));
var G__12282 = key_or_nil;
var G__12283 = val_or_node;
var G__12284 = hash;
var G__12285 = key;
var G__12286 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__12280,G__12281,G__12282,G__12283,G__12284,G__12285,G__12286) : cljs.core.create_node.call(null,G__12280,G__12281,G__12282,G__12283,G__12284,G__12285,G__12286));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_12299 = (0);
var j_12300 = (0);
while(true){
if((i_12299 < (32))){
if((((self__.bitmap >>> i_12299) & (1)) === (0))){
var G__12301 = (i_12299 + (1));
var G__12302 = j_12300;
i_12299 = G__12301;
j_12300 = G__12302;
continue;
} else {
(nodes[i_12299] = ((!(((self__.arr[j_12300]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_12300])),(self__.arr[j_12300]),(self__.arr[(j_12300 + (1))]),added_leaf_QMARK_):(self__.arr[(j_12300 + (1))])));

var G__12303 = (i_12299 + (1));
var G__12304 = (j_12300 + (2));
i_12299 = G__12303;
j_12300 = G__12304;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__12287 = (shift + (5));
var G__12288 = key_or_nil;
var G__12289 = val_or_node;
var G__12290 = hash;
var G__12291 = key;
var G__12292 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__12287,G__12288,G__12289,G__12290,G__12291,G__12292) : cljs.core.create_node.call(null,G__12287,G__12288,G__12289,G__12290,G__12291,G__12292));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__12305 = (i + (1));
var G__12306 = (j + (2));
var G__12307 = (bitmap | ((1) << i));
i = G__12305;
j = G__12306;
bitmap = G__12307;
continue;
} else {
var G__12308 = (i + (1));
var G__12309 = j;
var G__12310 = bitmap;
i = G__12308;
j = G__12309;
bitmap = G__12310;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
})
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if(!((!((self__.next_iter == null))) && (self__.next_iter.hasNext()))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if(!((node == null))){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayNodeIterator");
});

cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__12311 = (i + (1));
var G__12312 = init__$2;
i = G__12311;
init__$1 = G__12312;
continue;
}
} else {
var G__12313 = (i + (1));
var G__12314 = init__$1;
i = G__12313;
init__$1 = G__12314;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__12315 = (i + (2));
i = G__12315;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
removed_leaf_QMARK_.val = true;

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var args12316 = [];
var len__8402__auto___12319 = arguments.length;
var i__8403__auto___12320 = (0);
while(true){
if((i__8403__auto___12320 < len__8402__auto___12319)){
args12316.push((arguments[i__8403__auto___12320]));

var G__12321 = (i__8403__auto___12320 + (1));
i__8403__auto___12320 = G__12321;
continue;
} else {
}
break;
}

var G__12318 = args12316.length;
switch (G__12318) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12316.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__12329 = null;
var G__12329__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12329__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12329 = function(x,start){
switch(arguments.length){
case 1:
return G__12329__1.call(this,x);
case 2:
return G__12329__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12329.cljs$core$IFn$_invoke$arity$1 = G__12329__1;
G__12329.cljs$core$IFn$_invoke$arity$2 = G__12329__2;
return G__12329;
})()
;

cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__12330 = null;
var G__12330__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12330__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12330 = function(x,start){
switch(arguments.length){
case 1:
return G__12330__1.call(this,x);
case 2:
return G__12330__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12330.cljs$core$IFn$_invoke$arity$1 = G__12330__1;
G__12330.cljs$core$IFn$_invoke$arity$2 = G__12330__2;
return G__12330;
})()
;

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?(function (){var G__12323 = self__.nodes;
var G__12324 = (self__.i + (2));
var G__12325 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__12323,G__12324,G__12325) : cljs.core.create_inode_seq.call(null,G__12323,G__12324,G__12325));
})():(function (){var G__12326 = self__.nodes;
var G__12327 = self__.i;
var G__12328 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__12326,G__12327,G__12328) : cljs.core.create_inode_seq.call(null,G__12326,G__12327,G__12328));
})());
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var args12331 = [];
var len__8402__auto___12334 = arguments.length;
var i__8403__auto___12335 = (0);
while(true){
if((i__8403__auto___12335 < len__8402__auto___12334)){
args12331.push((arguments[i__8403__auto___12335]));

var G__12336 = (i__8403__auto___12335 + (1));
i__8403__auto___12335 = G__12336;
continue;
} else {
}
break;
}

var G__12333 = args12331.length;
switch (G__12333) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12331.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4655__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4655__auto__)){
var node = temp__4655__auto__;
var temp__4655__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var node_seq = temp__4655__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__12338 = (j + (2));
j = G__12338;
continue;
}
} else {
var G__12339 = (j + (2));
j = G__12339;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__12344 = null;
var G__12344__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12344__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12344 = function(x,start){
switch(arguments.length){
case 1:
return G__12344__1.call(this,x);
case 2:
return G__12344__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12344.cljs$core$IFn$_invoke$arity$1 = G__12344__1;
G__12344.cljs$core$IFn$_invoke$arity$2 = G__12344__2;
return G__12344;
})()
;

cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__12345 = null;
var G__12345__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12345__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12345 = function(x,start){
switch(arguments.length){
case 1:
return G__12345__1.call(this,x);
case 2:
return G__12345__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12345.cljs$core$IFn$_invoke$arity$1 = G__12345__1;
G__12345.cljs$core$IFn$_invoke$arity$2 = G__12345__2;
return G__12345;
})()
;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (function (){var G__12340 = null;
var G__12341 = self__.nodes;
var G__12342 = self__.i;
var G__12343 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__12340,G__12341,G__12342,G__12343) : cljs.core.create_array_node_seq.call(null,G__12340,G__12341,G__12342,G__12343));
})();
if(!((ret == null))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var args12346 = [];
var len__8402__auto___12349 = arguments.length;
var i__8403__auto___12350 = (0);
while(true){
if((i__8403__auto___12350 < len__8402__auto___12349)){
args12346.push((arguments[i__8403__auto___12350]));

var G__12351 = (i__8403__auto___12350 + (1));
i__8403__auto___12350 = G__12351;
continue;
} else {
}
break;
}

var G__12348 = args12346.length;
switch (G__12348) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12346.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4655__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4655__auto__)){
var nj = temp__4655__auto__;
var temp__4655__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var ns = temp__4655__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__12353 = (j + (1));
j = G__12353;
continue;
}
} else {
var G__12354 = (j + (1));
j = G__12354;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
})
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (!(self__.seen)) || (self__.root_iter.hasNext());
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!(self__.seen)){
self__.seen = true;

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null);
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/HashMapIter");
});

cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(self__.has_nil_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null);
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);
}
});

cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__12356 = cljs.core.seq(coll);
var chunk__12357 = null;
var count__12358 = (0);
var i__12359 = (0);
while(true){
if((i__12359 < count__12358)){
var vec__12360 = chunk__12357.cljs$core$IIndexed$_nth$arity$2(null,i__12359);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12360,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12360,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12368 = seq__12356;
var G__12369 = chunk__12357;
var G__12370 = count__12358;
var G__12371 = (i__12359 + (1));
seq__12356 = G__12368;
chunk__12357 = G__12369;
count__12358 = G__12370;
i__12359 = G__12371;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__12356);
if(temp__4657__auto__){
var seq__12356__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12356__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__12356__$1);
var G__12372 = cljs.core.chunk_rest(seq__12356__$1);
var G__12373 = c__8108__auto__;
var G__12374 = cljs.core.count(c__8108__auto__);
var G__12375 = (0);
seq__12356 = G__12372;
chunk__12357 = G__12373;
count__12358 = G__12374;
i__12359 = G__12375;
continue;
} else {
var vec__12363 = cljs.core.first(seq__12356__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12363,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12363,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12376 = cljs.core.next(seq__12356__$1);
var G__12377 = null;
var G__12378 = (0);
var G__12379 = (0);
seq__12356 = G__12376;
chunk__12357 = G__12377;
count__12358 = G__12378;
i__12359 = G__12379;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap({},self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__12380 = ret.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__12381 = cljs.core.next(es);
ret = G__12380;
es = G__12381;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__12382 = null;
var G__12382__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12382__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12382 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12382__2.call(this,self__,k);
case 3:
return G__12382__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12382.cljs$core$IFn$_invoke$arity$2 = G__12382__2;
G__12382.cljs$core$IFn$_invoke$arity$3 = G__12382__3;
return G__12382;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args12355){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12355)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__12383 = (i + (2));
var G__12384 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__12383;
ret = G__12384;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__12385 = (i + (1));
var G__12386 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__12385;
out = G__12386;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_12387 = (0);
while(true){
if((i_12387 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_12387]),(arr[(i_12387 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_12387 / (2)) + (1)))){
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Duplicate key: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_12387]))].join('')));
} else {
var G__12388 = (i_12387 + (2));
i_12387 = G__12388;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMapEntry$)))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__12390 = cljs.core.next(es);
var G__12391 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__12390;
tcoll__$1 = G__12391;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(removed_leaf_QMARK_.val){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__12392 = ((ascending_QMARK_)?t.left:t.right);
var G__12393 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__12392;
stack__$1 = G__12393;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__12394 = null;
var G__12394__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12394__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12394 = function(x,start){
switch(arguments.length){
case 1:
return G__12394__1.call(this,x);
case 2:
return G__12394__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12394.cljs$core$IFn$_invoke$arity$1 = G__12394__1;
G__12394.cljs$core$IFn$_invoke$arity$2 = G__12394__2;
return G__12394;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__12395 = null;
var G__12395__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12395__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12395 = function(x,start){
switch(arguments.length){
case 1:
return G__12395__1.call(this,x);
case 2:
return G__12395__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12395.cljs$core$IFn$_invoke$arity$1 = G__12395__1;
G__12395.cljs$core$IFn$_invoke$arity$2 = G__12395__2;
return G__12395;
})()
;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?(function (){var G__12405 = node.left;
var G__12406 = f;
var G__12407 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__12405,G__12406,G__12407) : cljs.core.tree_map_kv_reduce.call(null,G__12405,G__12406,G__12407));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
var init__$2 = (function (){var G__12408 = init__$1;
var G__12409 = node.key;
var G__12410 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__12408,G__12409,G__12410) : f.call(null,G__12408,G__12409,G__12410));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var init__$3 = ((!((node.right == null)))?(function (){var G__12411 = node.right;
var G__12412 = f;
var G__12413 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__12411,G__12412,G__12413) : cljs.core.tree_map_kv_reduce.call(null,G__12411,G__12412,G__12413));
})():init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null,init__$3));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null);
});

cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__12415 = null;
var G__12415__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12415__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12415 = function(x,start){
switch(arguments.length){
case 1:
return G__12415__1.call(this,x);
case 2:
return G__12415__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12415.cljs$core$IFn$_invoke$arity$1 = G__12415__1;
G__12415.cljs$core$IFn$_invoke$arity$2 = G__12415__2;
return G__12415;
})()
;

cljs.core.BlackNode.prototype.indexOf = (function() {
var G__12416 = null;
var G__12416__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12416__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12416 = function(x,start){
switch(arguments.length){
case 1:
return G__12416__1.call(this,x);
case 2:
return G__12416__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12416.cljs$core$IFn$_invoke$arity$1 = G__12416__1;
G__12416.cljs$core$IFn$_invoke$arity$2 = G__12416__2;
return G__12416;
})()
;

cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__8131__auto__ = self__.key;
return cljs.core._conj((function (){var x__8131__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto____$1);
})(),x__8131__auto__);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__12417 = null;
var G__12417__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12417__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12417 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12417__2.call(this,self__,k);
case 3:
return G__12417__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12417.cljs$core$IFn$_invoke$arity$2 = G__12417__2;
G__12417.cljs$core$IFn$_invoke$arity$3 = G__12417__3;
return G__12417;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args12414){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12414)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null);
});

cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__12419 = null;
var G__12419__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12419__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12419 = function(x,start){
switch(arguments.length){
case 1:
return G__12419__1.call(this,x);
case 2:
return G__12419__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12419.cljs$core$IFn$_invoke$arity$1 = G__12419__1;
G__12419.cljs$core$IFn$_invoke$arity$2 = G__12419__2;
return G__12419;
})()
;

cljs.core.RedNode.prototype.indexOf = (function() {
var G__12420 = null;
var G__12420__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12420__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12420 = function(x,start){
switch(arguments.length){
case 1:
return G__12420__1.call(this,x);
case 2:
return G__12420__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12420.cljs$core$IFn$_invoke$arity$1 = G__12420__1;
G__12420.cljs$core$IFn$_invoke$arity$2 = G__12420__2;
return G__12420;
})()
;

cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
var x__8131__auto__ = self__.key;
return cljs.core._conj((function (){var x__8131__auto____$1 = self__.val;
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto____$1);
})(),x__8131__auto__);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__12421 = null;
var G__12421__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12421__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12421 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12421__2.call(this,self__,k);
case 3:
return G__12421__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12421.cljs$core$IFn$_invoke$arity$2 = G__12421__2;
G__12421.cljs$core$IFn$_invoke$arity$3 = G__12421__3;
return G__12421;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args12418){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12418)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__12434 = k;
var G__12435 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12434,G__12435) : comp.call(null,G__12434,G__12435));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__12436 = comp;
var G__12437 = tree.left;
var G__12438 = k;
var G__12439 = v;
var G__12440 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__12436,G__12437,G__12438,G__12439,G__12440) : cljs.core.tree_map_add.call(null,G__12436,G__12437,G__12438,G__12439,G__12440));
})();
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__12441 = comp;
var G__12442 = tree.right;
var G__12443 = k;
var G__12444 = v;
var G__12445 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__12441,G__12442,G__12443,G__12444,G__12445) : cljs.core.tree_map_add.call(null,G__12441,G__12442,G__12443,G__12444,G__12445));
})();
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__12454 = left.right;
var G__12455 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__12454,G__12455) : cljs.core.tree_map_append.call(null,G__12454,G__12455));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__12456 = left.right;
var G__12457 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__12456,G__12457) : cljs.core.tree_map_append.call(null,G__12456,G__12457));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__12458 = left;
var G__12459 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__12458,G__12459) : cljs.core.tree_map_append.call(null,G__12458,G__12459));
})(),right.right,null));
} else {
var app = (function (){var G__12460 = left.right;
var G__12461 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__12460,G__12461) : cljs.core.tree_map_append.call(null,G__12460,G__12461));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__12472 = k;
var G__12473 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12472,G__12473) : comp.call(null,G__12472,G__12473));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__12474 = comp;
var G__12475 = tree.left;
var G__12476 = k;
var G__12477 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__12474,G__12475,G__12476,G__12477) : cljs.core.tree_map_remove.call(null,G__12474,G__12475,G__12476,G__12477));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__12478 = comp;
var G__12479 = tree.right;
var G__12480 = k;
var G__12481 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__12478,G__12479,G__12480,G__12481) : cljs.core.tree_map_remove.call(null,G__12478,G__12479,G__12480,G__12481));
})();
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__12490 = comp;
var G__12491 = tree.left;
var G__12492 = k;
var G__12493 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__12490,G__12491,G__12492,G__12493) : cljs.core.tree_map_replace.call(null,G__12490,G__12491,G__12492,G__12493));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__12494 = comp;
var G__12495 = tree.right;
var G__12496 = k;
var G__12497 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__12494,G__12495,G__12496,G__12497) : cljs.core.tree_map_replace.call(null,G__12494,G__12495,G__12496,G__12497));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
});

cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__12499 = cljs.core.seq(coll);
var chunk__12500 = null;
var count__12501 = (0);
var i__12502 = (0);
while(true){
if((i__12502 < count__12501)){
var vec__12503 = chunk__12500.cljs$core$IIndexed$_nth$arity$2(null,i__12502);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12503,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12503,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12513 = seq__12499;
var G__12514 = chunk__12500;
var G__12515 = count__12501;
var G__12516 = (i__12502 + (1));
seq__12499 = G__12513;
chunk__12500 = G__12514;
count__12501 = G__12515;
i__12502 = G__12516;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__12499);
if(temp__4657__auto__){
var seq__12499__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12499__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__12499__$1);
var G__12517 = cljs.core.chunk_rest(seq__12499__$1);
var G__12518 = c__8108__auto__;
var G__12519 = cljs.core.count(c__8108__auto__);
var G__12520 = (0);
seq__12499 = G__12517;
chunk__12500 = G__12518;
count__12501 = G__12519;
i__12502 = G__12520;
continue;
} else {
var vec__12506 = cljs.core.first(seq__12499__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12506,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12521 = cljs.core.next(seq__12499__$1);
var G__12522 = null;
var G__12523 = (0);
var G__12524 = (0);
seq__12499 = G__12521;
chunk__12500 = G__12522;
count__12501 = G__12523;
i__12502 = G__12524;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__12509 = k;
var G__12510 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__12509,G__12510) : self__.comp.call(null,G__12509,G__12510));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__12525 = t.left;
t = G__12525;
continue;
} else {
var G__12526 = t.right;
t = G__12526;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__12527 = ret.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__12528 = cljs.core.next(es);
ret = G__12527;
es = G__12528;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__12529 = null;
var G__12529__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12529__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12529 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12529__2.call(this,self__,k);
case 3:
return G__12529__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12529.cljs$core$IFn$_invoke$arity$2 = G__12529__2;
G__12529.cljs$core$IFn$_invoke$arity$3 = G__12529__3;
return G__12529;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args12498){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12498)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__12511 = k;
var G__12512 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__12511,G__12512) : self__.comp.call(null,G__12511,G__12512));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__12530 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__12531 = t.left;
stack = G__12530;
t = G__12531;
continue;
} else {
var G__12532 = stack;
var G__12533 = t.right;
stack = G__12532;
t = G__12533;
continue;
}
} else {
if((c > (0))){
var G__12534 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__12535 = t.right;
stack = G__12534;
t = G__12535;
continue;
} else {
var G__12536 = stack;
var G__12537 = t.left;
stack = G__12536;
t = G__12537;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12539 = arguments.length;
var i__8403__auto___12540 = (0);
while(true){
if((i__8403__auto___12540 < len__8402__auto___12539)){
args__8409__auto__.push((arguments[i__8403__auto___12540]));

var G__12541 = (i__8403__auto___12540 + (1));
i__8403__auto___12540 = G__12541;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__12542 = cljs.core.nnext(in$);
var G__12543 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__12542;
out = G__12543;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq12538){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12538));
});

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12545 = arguments.length;
var i__8403__auto___12546 = (0);
while(true){
if((i__8403__auto___12546 < len__8402__auto___12545)){
args__8409__auto__.push((arguments[i__8403__auto___12546]));

var G__12547 = (i__8403__auto___12546 + (1));
i__8403__auto___12546 = G__12547;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq12544){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12544));
});

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12551 = arguments.length;
var i__8403__auto___12552 = (0);
while(true){
if((i__8403__auto___12552 < len__8402__auto___12551)){
args__8409__auto__.push((arguments[i__8403__auto___12552]));

var G__12553 = (i__8403__auto___12552 + (1));
i__8403__auto___12552 = G__12553;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = {};
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__12554 = cljs.core.nnext(kvs);
kvs = G__12554;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq12548){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12548));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12556 = arguments.length;
var i__8403__auto___12557 = (0);
while(true){
if((i__8403__auto___12557 < len__8402__auto___12556)){
args__8409__auto__.push((arguments[i__8403__auto___12557]));

var G__12558 = (i__8403__auto___12557 + (1));
i__8403__auto___12557 = G__12558;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__12559 = cljs.core.nnext(in$);
var G__12560 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__12559;
out = G__12560;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq12555){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12555));
});

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12563 = arguments.length;
var i__8403__auto___12564 = (0);
while(true){
if((i__8403__auto___12564 < len__8402__auto___12563)){
args__8409__auto__.push((arguments[i__8403__auto___12564]));

var G__12565 = (i__8403__auto___12564 + (1));
i__8403__auto___12564 = G__12565;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__12566 = cljs.core.nnext(in$);
var G__12567 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__12566;
out = G__12567;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq12561){
var G__12562 = cljs.core.first(seq12561);
var seq12561__$1 = cljs.core.next(seq12561);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__12562,seq12561__$1);
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.indexOf = (function() {
var G__12570 = null;
var G__12570__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12570__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12570 = function(x,start){
switch(arguments.length){
case 1:
return G__12570__1.call(this,x);
case 2:
return G__12570__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12570.cljs$core$IFn$_invoke$arity$1 = G__12570__1;
G__12570.cljs$core$IFn$_invoke$arity$2 = G__12570__2;
return G__12570;
})()
;

cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__12571 = null;
var G__12571__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12571__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12571 = function(x,start){
switch(arguments.length){
case 1:
return G__12571__1.call(this,x);
case 2:
return G__12571__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12571.cljs$core$IFn$_invoke$arity$1 = G__12571__1;
G__12571.cljs$core$IFn$_invoke$arity$2 = G__12571__2;
return G__12571;
})()
;

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.indexOf = (function() {
var G__12574 = null;
var G__12574__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12574__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12574 = function(x,start){
switch(arguments.length){
case 1:
return G__12574__1.call(this,x);
case 2:
return G__12574__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12574.cljs$core$IFn$_invoke$arity$1 = G__12574__1;
G__12574.cljs$core$IFn$_invoke$arity$2 = G__12574__2;
return G__12574;
})()
;

cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__12575 = null;
var G__12575__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12575__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__12575 = function(x,start){
switch(arguments.length){
case 1:
return G__12575__1.call(this,x);
case 2:
return G__12575__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12575.cljs$core$IFn$_invoke$arity$1 = G__12575__1;
G__12575.cljs$core$IFn$_invoke$arity$2 = G__12575__2;
return G__12575;
})()
;

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$)))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12579 = arguments.length;
var i__8403__auto___12580 = (0);
while(true){
if((i__8403__auto___12580 < len__8402__auto___12579)){
args__8409__auto__.push((arguments[i__8403__auto___12580]));

var G__12581 = (i__8403__auto___12580 + (1));
i__8403__auto___12580 = G__12581;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__12576_SHARP_,p2__12577_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = p1__12576_SHARP_;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__12577_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq12578){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12578));
});

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12586 = arguments.length;
var i__8403__auto___12587 = (0);
while(true){
if((i__8403__auto___12587 < len__8402__auto___12586)){
args__8409__auto__.push((arguments[i__8403__auto___12587]));

var G__12588 = (i__8403__auto___12587 + (1));
i__8403__auto___12587 = G__12588;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__12584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__12585 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12584,G__12585) : f.call(null,G__12584,G__12585));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__7289__auto__ = m1;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq12582){
var G__12583 = cljs.core.first(seq12582);
var seq12582__$1 = cljs.core.next(seq12582);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__12583,seq12582__$1);
});

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__12589 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__12590 = cljs.core.next(keys);
ret = G__12589;
keys = G__12590;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
})
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return (self__.iter.next().tail[(0)]);
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/HashSetIter");
});

cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__12593 = cljs.core.seq(coll);
var chunk__12594 = null;
var count__12595 = (0);
var i__12596 = (0);
while(true){
if((i__12596 < count__12595)){
var vec__12597 = chunk__12594.cljs$core$IIndexed$_nth$arity$2(null,i__12596);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12597,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12597,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12603 = seq__12593;
var G__12604 = chunk__12594;
var G__12605 = count__12595;
var G__12606 = (i__12596 + (1));
seq__12593 = G__12603;
chunk__12594 = G__12604;
count__12595 = G__12605;
i__12596 = G__12606;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__12593);
if(temp__4657__auto__){
var seq__12593__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12593__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__12593__$1);
var G__12607 = cljs.core.chunk_rest(seq__12593__$1);
var G__12608 = c__8108__auto__;
var G__12609 = cljs.core.count(c__8108__auto__);
var G__12610 = (0);
seq__12593 = G__12607;
chunk__12594 = G__12608;
count__12595 = G__12609;
i__12596 = G__12610;
continue;
} else {
var vec__12600 = cljs.core.first(seq__12593__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12600,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12600,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12611 = cljs.core.next(seq__12593__$1);
var G__12612 = null;
var G__12613 = (0);
var G__12614 = (0);
seq__12593 = G__12611;
chunk__12594 = G__12612;
count__12595 = G__12613;
i__12596 = G__12614;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__12591_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__12591_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__12615 = null;
var G__12615__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12615__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12615 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12615__2.call(this,self__,k);
case 3:
return G__12615__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12615.cljs$core$IFn$_invoke$arity$2 = G__12615__2;
G__12615.cljs$core$IFn$_invoke$arity$3 = G__12615__3;
return G__12615;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args12592){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12592)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__12616 = (i + (1));
var G__12617 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__12616;
out = G__12617;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__12618 = (i + (1));
var G__12619 = cljs.core._conj_BANG_(out,(items[i]));
i = G__12618;
out = G__12619;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
cljs.core.PersistentHashSet.createWithCheck = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__8212__auto___12620 = len;
var i_12621 = (0);
while(true){
if((i_12621 < n__8212__auto___12620)){
cljs.core._conj_BANG_(t,(items[i_12621]));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(t),(i_12621 + (1)))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Duplicate key: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((items[i_12621]))].join('')));
}

var G__12622 = (i_12621 + (1));
i_12621 = G__12622;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
});
cljs.core.PersistentHashSet.createAsIfByAssoc = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__8212__auto___12623 = len;
var i_12624 = (0);
while(true){
if((i_12624 < n__8212__auto___12623)){
cljs.core._conj_BANG_(t,(items[i_12624]));

var G__12625 = (i_12624 + (1));
i_12624 = G__12625;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__12627 = null;
var G__12627__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__12627__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__12627 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12627__2.call(this,self__,k);
case 3:
return G__12627__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12627.cljs$core$IFn$_invoke$arity$2 = G__12627__2;
G__12627.cljs$core$IFn$_invoke$arity$3 = G__12627__3;
return G__12627;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args12626){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12626)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__12630 = cljs.core.seq(coll);
var chunk__12631 = null;
var count__12632 = (0);
var i__12633 = (0);
while(true){
if((i__12633 < count__12632)){
var vec__12634 = chunk__12631.cljs$core$IIndexed$_nth$arity$2(null,i__12633);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12634,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12634,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12640 = seq__12630;
var G__12641 = chunk__12631;
var G__12642 = count__12632;
var G__12643 = (i__12633 + (1));
seq__12630 = G__12640;
chunk__12631 = G__12641;
count__12632 = G__12642;
i__12633 = G__12643;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__12630);
if(temp__4657__auto__){
var seq__12630__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12630__$1)){
var c__8108__auto__ = cljs.core.chunk_first(seq__12630__$1);
var G__12644 = cljs.core.chunk_rest(seq__12630__$1);
var G__12645 = c__8108__auto__;
var G__12646 = cljs.core.count(c__8108__auto__);
var G__12647 = (0);
seq__12630 = G__12644;
chunk__12631 = G__12645;
count__12632 = G__12646;
i__12633 = G__12647;
continue;
} else {
var vec__12637 = cljs.core.first(seq__12630__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12637,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__12648 = cljs.core.next(seq__12630__$1);
var G__12649 = null;
var G__12650 = (0);
var G__12651 = (0);
seq__12630 = G__12648;
chunk__12631 = G__12649;
count__12632 = G__12650;
i__12633 = G__12651;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__12628_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__12628_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__12652 = null;
var G__12652__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__12652__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__12652 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__12652__2.call(this,self__,k);
case 3:
return G__12652__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12652.cljs$core$IFn$_invoke$arity$2 = G__12652__2;
G__12652.cljs$core$IFn$_invoke$arity$3 = G__12652__3;
return G__12652;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args12629){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args12629)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__8206__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__8206__auto__.length)){
var G__12653 = (i + (1));
var G__12654 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__12653;
res = G__12654;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.PersistentHashSet.createAsIfByAssoc(in$.arr);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__12655 = cljs.core.next(in$__$1);
var G__12656 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__12655;
out = G__12656;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var args12657 = [];
var len__8402__auto___12661 = arguments.length;
var i__8403__auto___12662 = (0);
while(true){
if((i__8403__auto___12662 < len__8402__auto___12661)){
args12657.push((arguments[i__8403__auto___12662]));

var G__12663 = (i__8403__auto___12662 + (1));
i__8403__auto___12662 = G__12663;
continue;
} else {
}
break;
}

var G__12660 = args12657.length;
switch (G__12660) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args12657.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__8421__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq12658){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12658));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12666 = arguments.length;
var i__8403__auto___12667 = (0);
while(true){
if((i__8403__auto___12667 < len__8402__auto___12666)){
args__8409__auto__.push((arguments[i__8403__auto___12667]));

var G__12668 = (i__8403__auto___12667 + (1));
i__8403__auto___12667 = G__12668;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq12665){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq12665));
});

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__8409__auto__ = [];
var len__8402__auto___12671 = arguments.length;
var i__8403__auto___12672 = (0);
while(true){
if((i__8403__auto___12672 < len__8402__auto___12671)){
args__8409__auto__.push((arguments[i__8403__auto___12672]));

var G__12673 = (i__8403__auto___12672 + (1));
i__8403__auto___12672 = G__12673;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq12669){
var G__12670 = cljs.core.first(seq12669);
var seq12669__$1 = cljs.core.next(seq12669);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__12670,seq12669__$1);
});

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var args12676 = [];
var len__8402__auto___12679 = arguments.length;
var i__8403__auto___12680 = (0);
while(true){
if((i__8403__auto___12680 < len__8402__auto___12679)){
args12676.push((arguments[i__8403__auto___12680]));

var G__12681 = (i__8403__auto___12680 + (1));
i__8403__auto___12680 = G__12681;
continue;
} else {
}
break;
}

var G__12678 = args12676.length;
switch (G__12678) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12676.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__12674_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__12674_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.val(e);
} else {
return p1__12674_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4655__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12675_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__12675_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.second(e);
} else {
return p1__12675_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var args12683 = [];
var len__8402__auto___12696 = arguments.length;
var i__8403__auto___12697 = (0);
while(true){
if((i__8403__auto___12697 < len__8402__auto___12696)){
args12683.push((arguments[i__8403__auto___12697]));

var G__12698 = (i__8403__auto___12697 + (1));
i__8403__auto___12697 = G__12698;
continue;
} else {
}
break;
}

var G__12685 = args12683.length;
switch (G__12685) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12683.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__12700 = null;
var G__12700__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12700__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__12700__2 = (function (result,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen) : cljs.core.deref.call(null,seen)),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__12700 = function(result,input){
switch(arguments.length){
case 0:
return G__12700__0.call(this);
case 1:
return G__12700__1.call(this,result);
case 2:
return G__12700__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12700.cljs$core$IFn$_invoke$arity$0 = G__12700__0;
G__12700.cljs$core$IFn$_invoke$arity$1 = G__12700__1;
G__12700.cljs$core$IFn$_invoke$arity$2 = G__12700__2;
return G__12700;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__12692,seen__$1){
while(true){
var vec__12693 = p__12692;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12693,(0),null);
var xs__$1 = vec__12693;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__12701 = cljs.core.rest(s);
var G__12702 = seen__$1;
p__12692 = G__12701;
seen__$1 = G__12702;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__12703 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__12704 = cljs.core.next(s__$1);
ret = G__12703;
s__$1 = G__12704;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$)))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Doesn't support name: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__12707 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__12708 = cljs.core.next(ks);
var G__12709 = cljs.core.next(vs);
map = G__12707;
ks = G__12708;
vs = G__12709;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var args12712 = [];
var len__8402__auto___12719 = arguments.length;
var i__8403__auto___12720 = (0);
while(true){
if((i__8403__auto___12720 < len__8402__auto___12719)){
args12712.push((arguments[i__8403__auto___12720]));

var G__12721 = (i__8403__auto___12720 + (1));
i__8403__auto___12720 = G__12721;
continue;
} else {
}
break;
}

var G__12718 = args12712.length;
switch (G__12718) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args12712.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__12710_SHARP_,p2__12711_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__12710_SHARP_,p2__12711_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq12713){
var G__12714 = cljs.core.first(seq12713);
var seq12713__$1 = cljs.core.next(seq12713);
var G__12715 = cljs.core.first(seq12713__$1);
var seq12713__$2 = cljs.core.next(seq12713__$1);
var G__12716 = cljs.core.first(seq12713__$2);
var seq12713__$3 = cljs.core.next(seq12713__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__12714,G__12715,G__12716,seq12713__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);

/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var args12725 = [];
var len__8402__auto___12732 = arguments.length;
var i__8403__auto___12733 = (0);
while(true){
if((i__8403__auto___12733 < len__8402__auto___12732)){
args12725.push((arguments[i__8403__auto___12733]));

var G__12734 = (i__8403__auto___12733 + (1));
i__8403__auto___12733 = G__12734;
continue;
} else {
}
break;
}

var G__12731 = args12725.length;
switch (G__12731) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args12725.slice((3)),(0),null));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__12723_SHARP_,p2__12724_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__12723_SHARP_,p2__12724_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq12726){
var G__12727 = cljs.core.first(seq12726);
var seq12726__$1 = cljs.core.next(seq12726);
var G__12728 = cljs.core.first(seq12726__$1);
var seq12726__$2 = cljs.core.next(seq12726__$1);
var G__12729 = cljs.core.first(seq12726__$2);
var seq12726__$3 = cljs.core.next(seq12726__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__12727,G__12728,G__12729,seq12726__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);


/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var args12736 = [];
var len__8402__auto___12739 = arguments.length;
var i__8403__auto___12740 = (0);
while(true){
if((i__8403__auto___12740 < len__8402__auto___12739)){
args12736.push((arguments[i__8403__auto___12740]));

var G__12741 = (i__8403__auto___12740 + (1));
i__8403__auto___12740 = G__12741;
continue;
} else {
}
break;
}

var G__12738 = args12736.length;
switch (G__12738) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12736.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__12743 = null;
var G__12743__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12743__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__12743__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__12743 = function(result,input){
switch(arguments.length){
case 0:
return G__12743__0.call(this);
case 1:
return G__12743__1.call(this,result);
case 2:
return G__12743__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12743.cljs$core$IFn$_invoke$arity$0 = G__12743__0;
G__12743.cljs$core$IFn$_invoke$arity$1 = G__12743__1;
G__12743.cljs$core$IFn$_invoke$arity$2 = G__12743__2;
return G__12743;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var args12744 = [];
var len__8402__auto___12748 = arguments.length;
var i__8403__auto___12749 = (0);
while(true){
if((i__8403__auto___12749 < len__8402__auto___12748)){
args12744.push((arguments[i__8403__auto___12749]));

var G__12750 = (i__8403__auto___12749 + (1));
i__8403__auto___12749 = G__12750;
continue;
} else {
}
break;
}

var G__12746 = args12744.length;
switch (G__12746) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12744.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__12752 = null;
var G__12752__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12752__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__12752__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__12752 = function(result,input){
switch(arguments.length){
case 0:
return G__12752__0.call(this);
case 1:
return G__12752__1.call(this,result);
case 2:
return G__12752__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12752.cljs$core$IFn$_invoke$arity$0 = G__12752__0;
G__12752.cljs$core$IFn$_invoke$arity$1 = G__12752__1;
G__12752.cljs$core$IFn$_invoke$arity$2 = G__12752__2;
return G__12752;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.truth_((function (){var G__12747 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__12747) : pred.call(null,G__12747));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;

cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__12757 = (function (){var G__12759 = cljs.core._entry_key(sc,e);
var G__12760 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__12759,G__12760) : comp.call(null,G__12759,G__12760));
})();
var G__12758 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__12757,G__12758) : test.call(null,G__12757,G__12758));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var args12761 = [];
var len__8402__auto___12770 = arguments.length;
var i__8403__auto___12771 = (0);
while(true){
if((i__8403__auto___12771 < len__8402__auto___12770)){
args12761.push((arguments[i__8403__auto___12771]));

var G__12772 = (i__8403__auto___12771 + (1));
i__8403__auto___12771 = G__12772;
continue;
} else {
}
break;
}

var G__12763 = args12761.length;
switch (G__12763) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12761.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__12764 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12764,(0),null);
var s = vec__12764;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__12767 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12767,(0),null);
var s = vec__12767;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;

/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var args12774 = [];
var len__8402__auto___12783 = arguments.length;
var i__8403__auto___12784 = (0);
while(true){
if((i__8403__auto___12784 < len__8402__auto___12783)){
args12774.push((arguments[i__8403__auto___12784]));

var G__12785 = (i__8403__auto___12784 + (1));
i__8403__auto___12784 = G__12785;
continue;
} else {
}
break;
}

var G__12776 = args12774.length;
switch (G__12776) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12774.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.createAsIfByAssoc([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__12777 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12777,(0),null);
var s = vec__12777;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__12780 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12780,(0),null);
var s = vec__12780;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;


/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$end,cljs.core.cst$sym$step], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.indexOf = (function() {
var G__12788 = null;
var G__12788__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__12788__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__12788 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__12788__1.call(this,x);
case 2:
return G__12788__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12788.cljs$core$IFn$_invoke$arity$1 = G__12788__1;
G__12788.cljs$core$IFn$_invoke$arity$2 = G__12788__2;
return G__12788;
})()
;

cljs.core.Range.prototype.lastIndexOf = (function() {
var G__12789 = null;
var G__12789__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__12789__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__12789 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__12789__1.call(this,x);
case 2:
return G__12789__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12789.cljs$core$IFn$_invoke$arity$1 = G__12789__1;
G__12789.cljs$core$IFn$_invoke$arity$2 = G__12789__2;
return G__12789;
})()
;

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < rng__$1.cljs$core$ICounted$_count$arity$1(null))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < rng__$1.cljs$core$ICounted$_count$arity$1(null))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(rng__$1.cljs$core$ISeqable$_seq$arity$1(null))){
return (0);
} else {
var G__12787 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__12787);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,i) : f.call(null,ret,i));
if(cljs.core.reduced_QMARK_(ret__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret__$1) : cljs.core.deref.call(null,ret__$1));
} else {
var G__12790 = (i + self__.step);
var G__12791 = ret__$1;
i = G__12790;
ret = G__12791;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((rng__$1.cljs$core$ISeqable$_seq$arity$1(null) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((rng__$1.cljs$core$ISeqable$_seq$arity$1(null) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.step < (0))){
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start === self__.end)){
return null;
} else {
return rng__$1;
}

}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__8303__auto__ = this;
return cljs.core.es6_iterator(this__8303__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var args12792 = [];
var len__8402__auto___12795 = arguments.length;
var i__8403__auto___12796 = (0);
while(true){
if((i__8403__auto___12796 < len__8402__auto___12795)){
args12792.push((arguments[i__8403__auto___12796]));

var G__12797 = (i__8403__auto___12796 + (1));
i__8403__auto___12796 = G__12797;
continue;
} else {
}
break;
}

var G__12794 = args12792.length;
switch (G__12794) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12792.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;

/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var args12799 = [];
var len__8402__auto___12802 = arguments.length;
var i__8403__auto___12803 = (0);
while(true){
if((i__8403__auto___12803 < len__8402__auto___12802)){
args12799.push((arguments[i__8403__auto___12803]));

var G__12804 = (i__8403__auto___12803 + (1));
i__8403__auto___12803 = G__12804;
continue;
} else {
}
break;
}

var G__12801 = args12799.length;
switch (G__12801) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12799.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__12806 = null;
var G__12806__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12806__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__12806__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__12806 = function(result,input){
switch(arguments.length){
case 0:
return G__12806__0.call(this);
case 1:
return G__12806__1.call(this,result);
case 2:
return G__12806__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12806.cljs$core$IFn$_invoke$arity$0 = G__12806__0;
G__12806.cljs$core$IFn$_invoke$arity$1 = G__12806__1;
G__12806.cljs$core$IFn$_invoke$arity$2 = G__12806__2;
return G__12806;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;

/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var args12808 = [];
var len__8402__auto___12811 = arguments.length;
var i__8403__auto___12812 = (0);
while(true){
if((i__8403__auto___12812 < len__8402__auto___12811)){
args12808.push((arguments[i__8403__auto___12812]));

var G__12813 = (i__8403__auto___12812 + (1));
i__8403__auto___12812 = G__12813;
continue;
} else {
}
break;
}

var G__12810 = args12808.length;
switch (G__12810) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12808.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(cljs.core.cst$kw$cljs$core_SLASH_none);
return ((function (a,pa){
return (function() {
var G__12815 = null;
var G__12815__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__12815__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__12815__2 = (function (result,input){
var pval = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
var val = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,cljs.core.cst$kw$cljs$core_SLASH_none)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__12815 = function(result,input){
switch(arguments.length){
case 0:
return G__12815__0.call(this);
case 1:
return G__12815__1.call(this,result);
case 2:
return G__12815__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12815.cljs$core$IFn$_invoke$arity$0 = G__12815__0;
G__12815.cljs$core$IFn$_invoke$arity$1 = G__12815__1;
G__12815.cljs$core$IFn$_invoke$arity$2 = G__12815__2;
return G__12815;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var fst = cljs.core.first(s);
var fv = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(fst) : f.call(null,fst));
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4657__auto__){
return (function (p1__12807_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(p1__12807_SHARP_) : f.call(null,p1__12807_SHARP_)));
});})(fst,fv,s,temp__4657__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;

/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var args12816 = [];
var len__8402__auto___12821 = arguments.length;
var i__8403__auto___12822 = (0);
while(true){
if((i__8403__auto___12822 < len__8402__auto___12821)){
args12816.push((arguments[i__8403__auto___12822]));

var G__12823 = (i__8403__auto___12822 + (1));
i__8403__auto___12822 = G__12823;
continue;
} else {
}
break;
}

var G__12818 = args12816.length;
switch (G__12818) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12816.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
var x__8131__auto__ = (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto__);
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
if(cljs.core.reduced_QMARK_(init)){
var x__8131__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init) : cljs.core.deref.call(null,init));
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto__);
} else {
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__12819 = init;
var G__12820 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__12819,G__12820) : f.call(null,G__12819,G__12820));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
}
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;

/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var args12835 = [];
var len__8402__auto___12842 = arguments.length;
var i__8403__auto___12843 = (0);
while(true){
if((i__8403__auto___12843 < len__8402__auto___12842)){
args12835.push((arguments[i__8403__auto___12843]));

var G__12844 = (i__8403__auto___12843 + (1));
i__8403__auto___12843 = G__12844;
continue;
} else {
}
break;
}

var G__12841 = args12835.length;
switch (G__12841) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args12835.slice((3)),(0),null));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__12846 = null;
var G__12846__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))],null));
});
var G__12846__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x))],null));
});
var G__12846__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y))],null));
});
var G__12846__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z))],null));
});
var G__12846__4 = (function() { 
var G__12847__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__12847 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12848__i = 0, G__12848__a = new Array(arguments.length -  3);
while (G__12848__i < G__12848__a.length) {G__12848__a[G__12848__i] = arguments[G__12848__i + 3]; ++G__12848__i;}
  args = new cljs.core.IndexedSeq(G__12848__a,0);
} 
return G__12847__delegate.call(this,x,y,z,args);};
G__12847.cljs$lang$maxFixedArity = 3;
G__12847.cljs$lang$applyTo = (function (arglist__12849){
var x = cljs.core.first(arglist__12849);
arglist__12849 = cljs.core.next(arglist__12849);
var y = cljs.core.first(arglist__12849);
arglist__12849 = cljs.core.next(arglist__12849);
var z = cljs.core.first(arglist__12849);
var args = cljs.core.rest(arglist__12849);
return G__12847__delegate(x,y,z,args);
});
G__12847.cljs$core$IFn$_invoke$arity$variadic = G__12847__delegate;
return G__12847;
})()
;
G__12846 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12846__0.call(this);
case 1:
return G__12846__1.call(this,x);
case 2:
return G__12846__2.call(this,x,y);
case 3:
return G__12846__3.call(this,x,y,z);
default:
var G__12850 = null;
if (arguments.length > 3) {
var G__12851__i = 0, G__12851__a = new Array(arguments.length -  3);
while (G__12851__i < G__12851__a.length) {G__12851__a[G__12851__i] = arguments[G__12851__i + 3]; ++G__12851__i;}
G__12850 = new cljs.core.IndexedSeq(G__12851__a,0);
}
return G__12846__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12850);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12846.cljs$lang$maxFixedArity = 3;
G__12846.cljs$lang$applyTo = G__12846__4.cljs$lang$applyTo;
G__12846.cljs$core$IFn$_invoke$arity$0 = G__12846__0;
G__12846.cljs$core$IFn$_invoke$arity$1 = G__12846__1;
G__12846.cljs$core$IFn$_invoke$arity$2 = G__12846__2;
G__12846.cljs$core$IFn$_invoke$arity$3 = G__12846__3;
G__12846.cljs$core$IFn$_invoke$arity$variadic = G__12846__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12846;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__12852 = null;
var G__12852__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null))],null));
});
var G__12852__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x))],null));
});
var G__12852__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y))],null));
});
var G__12852__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z))],null));
});
var G__12852__4 = (function() { 
var G__12853__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__12853 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12854__i = 0, G__12854__a = new Array(arguments.length -  3);
while (G__12854__i < G__12854__a.length) {G__12854__a[G__12854__i] = arguments[G__12854__i + 3]; ++G__12854__i;}
  args = new cljs.core.IndexedSeq(G__12854__a,0);
} 
return G__12853__delegate.call(this,x,y,z,args);};
G__12853.cljs$lang$maxFixedArity = 3;
G__12853.cljs$lang$applyTo = (function (arglist__12855){
var x = cljs.core.first(arglist__12855);
arglist__12855 = cljs.core.next(arglist__12855);
var y = cljs.core.first(arglist__12855);
arglist__12855 = cljs.core.next(arglist__12855);
var z = cljs.core.first(arglist__12855);
var args = cljs.core.rest(arglist__12855);
return G__12853__delegate(x,y,z,args);
});
G__12853.cljs$core$IFn$_invoke$arity$variadic = G__12853__delegate;
return G__12853;
})()
;
G__12852 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__12852__0.call(this);
case 1:
return G__12852__1.call(this,x);
case 2:
return G__12852__2.call(this,x,y);
case 3:
return G__12852__3.call(this,x,y,z);
default:
var G__12856 = null;
if (arguments.length > 3) {
var G__12857__i = 0, G__12857__a = new Array(arguments.length -  3);
while (G__12857__i < G__12857__a.length) {G__12857__a[G__12857__i] = arguments[G__12857__i + 3]; ++G__12857__i;}
G__12856 = new cljs.core.IndexedSeq(G__12857__a,0);
}
return G__12852__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__12856);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__12852.cljs$lang$maxFixedArity = 3;
G__12852.cljs$lang$applyTo = G__12852__4.cljs$lang$applyTo;
G__12852.cljs$core$IFn$_invoke$arity$0 = G__12852__0;
G__12852.cljs$core$IFn$_invoke$arity$1 = G__12852__1;
G__12852.cljs$core$IFn$_invoke$arity$2 = G__12852__2;
G__12852.cljs$core$IFn$_invoke$arity$3 = G__12852__3;
G__12852.cljs$core$IFn$_invoke$arity$variadic = G__12852__4.cljs$core$IFn$_invoke$arity$variadic;
return G__12852;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__12858 = null;
var G__12858__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null)),(h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null))],null));
});
var G__12858__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x)),(h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x))],null));
});
var G__12858__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y)),(h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y))],null));
});
var G__12858__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z)),(h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z))],null));
});
var G__12858__4 = (function() { 
var G__12859__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__12859 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__12860__i = 0, G__12860__a = new Array(arguments.length -  3);
while (G__12860__i < G__12860__a.length) {G__12860__a[G__12860__i] = arguments[G__12860__i + 3]; ++G__12860__i;}
  args = new cljs.core.IndexedSeq(G__12860__a,0);
} 
return G__12859__dele