// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.reader');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('goog.string.StringBuffer');
goog.require('goog.events');
goog.require('goog.net.XhrIo');
goog.require('goog.net.XhrIoPool');
goog.require('goog.Uri.QueryData');
goog.require('goog.structs');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = 1.35;
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
if((taoensso.encore.encore_version < min_version)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((taoensso.encore.format.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$3("Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version) : taoensso.encore.format.call(null,"Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_version,min_version,cljs.core.cst$kw$this_DASH_version,taoensso.encore.encore_version], null));
} else {
return null;
}
});
taoensso.encore.read_edn = (function taoensso$encore$read_edn(s){
return cljs.reader.read_string(s);
});
/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__25428 = ((typeof cljs.core.first(macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args),cljs.core.next(macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25428,(0),null);
var macro_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25428,(1),null);
var vec__25431 = ((cljs.core.map_QMARK_(cljs.core.first(macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args__$1),cljs.core.next(macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25431,(0),null);
var macro_args__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25431,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(attr,cljs.core.cst$kw$doc,docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta(name))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.meta(name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(name,attr__$2),macro_args__$2], null);
});
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform.
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__4657__auto__ = (function (){var or__7289__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var data_map = temp__4657__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$err_DASH_type,cljs.core.type(err),cljs.core.cst$kw$err_DASH_msg,err.message,cljs.core.cst$kw$err_DASH_cause,err.cause], null);
})(),data_map], 0));
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return !(clojure.string.blank_QMARK_(x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),n));
});
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_((2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_((3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_(x)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),cljs.core.count((taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1(x) : taoensso.encore.set_STAR_.call(null,x)))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (!(clojure.string.blank_QMARK_(x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(clojure.string.blank_QMARK_(x)){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"false")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"FALSE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"0"))){
return false;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(1))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"true")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"TRUE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$(x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var args25436 = [];
var len__8402__auto___25442 = arguments.length;
var i__8403__auto___25443 = (0);
while(true){
if((i__8403__auto___25443 < len__8402__auto___25442)){
args25436.push((arguments[i__8403__auto___25443]));

var G__25444 = (i__8403__auto___25443 + (1));
i__8403__auto___25443 = G__25444;
continue;
} else {
}
break;
}

var G__25441 = args25436.length;
switch (G__25441) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25436.slice((2)),(0),null));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__7277__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return and__7277__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__7277__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more);
} else {
return and__7277__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq25437){
var G__25438 = cljs.core.first(seq25437);
var seq25437__$1 = cljs.core.next(seq25437);
var G__25439 = cljs.core.first(seq25437__$1);
var seq25437__$2 = cljs.core.next(seq25437__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__25438,G__25439,seq25437__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);

taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return cljs.core.vec(x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_(x)){
return x;
} else {
return cljs.core.set(x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_((function (p1__25446_SHARP_){
return taoensso.encore.nnil_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,p1__25446_SHARP_));
}),ks);
});
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
/**
 * Implementation detail.
 */
taoensso.encore.hthrow = (function taoensso$encore$hthrow(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25457 = arguments.length;
var i__8403__auto___25458 = (0);
while(true){
if((i__8403__auto___25458 < len__8402__auto___25457)){
args__8409__auto__.push((arguments[i__8403__auto___25458]));

var G__25459 = (i__8403__auto___25458 + (1));
i__8403__auto___25458 = G__25459;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((5) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((5)),(0),null)):null);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__8410__auto__);
});

taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic = (function (hard_QMARK_,ns_str,_QMARK_line,form,val,p__25453){
var vec__25454 = p__25453;
var _QMARK_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25454,(0),null);
var pattern = "Condition failed in `%s:%s` [pred-form, val]: [%s, %s]";
var line_str = (function (){var or__7289__auto__ = _QMARK_line;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7289__auto__ = form;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "<nil>";
}
})())].join('');
var val_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7289__auto__ = val;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "<nil>";
}
})())].join('');
var _QMARK_err_str = (function (){var temp__4657__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__4657__auto__)){
var e = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('');
} else {
return null;
}
})();
var msg = (function (){var m = (taoensso.encore.format.cljs$core$IFn$_invoke$arity$5 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$5(pattern,ns_str,line_str,form_str,val_str) : taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str));
if(cljs.core.not(_QMARK_err_str)){
return m;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\nPredicate error: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err_str)].join('');
}
})();
throw ((cljs.core.not(hard_QMARK_))?taoensso.encore.assertion_error(msg):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$ns,ns_str,cljs.core.cst$kw$_QMARK_line,_QMARK_line,cljs.core.cst$kw$form,form,cljs.core.cst$kw$val,val,cljs.core.cst$kw$_QMARK_err,_QMARK_err], null)));
});

taoensso.encore.hthrow.cljs$lang$maxFixedArity = (5);

taoensso.encore.hthrow.cljs$lang$applyTo = (function (seq25447){
var G__25448 = cljs.core.first(seq25447);
var seq25447__$1 = cljs.core.next(seq25447);
var G__25449 = cljs.core.first(seq25447__$1);
var seq25447__$2 = cljs.core.next(seq25447__$1);
var G__25450 = cljs.core.first(seq25447__$2);
var seq25447__$3 = cljs.core.next(seq25447__$2);
var G__25451 = cljs.core.first(seq25447__$3);
var seq25447__$4 = cljs.core.next(seq25447__$3);
var G__25452 = cljs.core.first(seq25447__$4);
var seq25447__$5 = cljs.core.next(seq25447__$4);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(G__25448,G__25449,G__25450,G__25451,G__25452,seq25447__$5);
});

taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
var vec__25464 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x))], null);
}catch (e25467){if((e25467 instanceof Error)){
var e__24591__auto__ = e25467;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__24591__auto__], null);
} else {
throw e25467;

}
}})();
var _QMARK_r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25464,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25464,(1),null);
return _QMARK_r;
});
});
/**
 * Implementation detail.
 */
taoensso.encore.hpred = (function taoensso$encore$hpred(pred_form){
if(!(cljs.core.vector_QMARK_(pred_form))){
return pred_form;
} else {
var vec__25475 = pred_form;
var seq__25476 = cljs.core.seq(vec__25475);
var first__25477 = cljs.core.first(seq__25476);
var seq__25476__$1 = cljs.core.next(seq__25476);
var type = first__25477;
var first__25477__$1 = cljs.core.first(seq__25476__$1);
var seq__25476__$2 = cljs.core.next(seq__25476__$1);
var p1 = first__25477__$1;
var first__25477__$2 = cljs.core.first(seq__25476__$2);
var seq__25476__$3 = cljs.core.next(seq__25476__$2);
var p2 = first__25477__$2;
var more = seq__25476__$3;
var G__25478 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__25478) {
case "el":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "not=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "ks-nnil?":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "ks<=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "or":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
var or__7289__auto__ = (cljs.core.truth_(p1)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1))).call(null,x):null);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (cljs.core.truth_(p2)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2))).call(null,x):null);
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
return cljs.core.some(((function (or__7289__auto____$1,or__7289__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (p1__25469_SHARP_){
return taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__25469_SHARP_) : taoensso.encore.hpred.call(null,p1__25469_SHARP_))).call(null,x);
});})(or__7289__auto____$1,or__7289__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))
,more);
}
}
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "not":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
var and__7277__auto__ = ((cljs.core.not(p1))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x)));
if(and__7277__auto__){
var and__7277__auto____$1 = ((cljs.core.not(p2))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x)));
if(and__7277__auto____$1){
return cljs.core.every_QMARK_(((function (and__7277__auto____$1,and__7277__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (p1__25468_SHARP_){
return cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__25468_SHARP_) : taoensso.encore.hpred.call(null,p1__25468_SHARP_)).call(null,x));
});})(and__7277__auto____$1,and__7277__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))
,more);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "ks=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "and":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
var and__7277__auto__ = ((cljs.core.not(p1))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x));
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = ((cljs.core.not(p2))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x));
if(cljs.core.truth_(and__7277__auto____$1)){
return cljs.core.every_QMARK_(((function (and__7277__auto____$1,and__7277__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (p1__25470_SHARP_){
return (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__25470_SHARP_) : taoensso.encore.hpred.call(null,p1__25470_SHARP_)).call(null,x);
});})(and__7277__auto____$1,and__7277__auto__,G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))
,more);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "ks>=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "not-in":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "not-el":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "set<=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return clojure.set.subset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "set>=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return clojure.set.superset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "set=":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
case "in":
return ((function (G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__25478,vec__25475,seq__25476,first__25477,seq__25476__$1,type,first__25477__$1,seq__25476__$2,p1,first__25477__$2,seq__25476__$3,p2,more))

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}
}
});
/**
 * Implementation detail.
 */
taoensso.encore.hcond = (function taoensso$encore$hcond(hard_QMARK_,ns_str,line,x_,x_form,pred,pred_form){
var vec__25488 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x_) : cljs.core.deref.call(null,x_))], null);
}catch (e25494){if((e25494 instanceof Error)){
var e__24591__auto__ = e25494;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__24591__auto__], null);
} else {
throw e25494;

}
}})();
var _QMARK_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25488,(0),null);
var _QMARK_x_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25488,(1),null);
var have_x_QMARK_ = (_QMARK_x_err == null);
var vec__25491 = ((have_x_QMARK_)?(function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hpred(pred).call(null,_QMARK_x)], null);
}catch (e25495){if((e25495 instanceof Error)){
var e__24591__auto__ = e25495;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__24591__auto__], null);
} else {
throw e25495;

}
}})():null);
var pass_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25491,(0),null);
var _QMARK_pred_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25491,(1),null);
if(cljs.core.truth_(pass_QMARK_)){
return _QMARK_x;
} else {
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(hard_QMARK_,ns_str,line,(function (){var x__8131__auto__ = pred_form;
return cljs.core._conj((function (){var x__8131__auto____$1 = x_form;
return cljs.core._conj(cljs.core.List.EMPTY,x__8131__auto____$1);
})(),x__8131__auto__);
})(),((have_x_QMARK_)?_QMARK_x:_QMARK_x_err),cljs.core.array_seq([_QMARK_pred_err], 0));
}
});
/**
 * Like `name` but fully qualified: includes namespace in string when present.
 */
taoensso.encore.fq_name = (function taoensso$encore$fq_name(x){
if(typeof x === 'string'){
return x;
} else {
var n = cljs.core.name(x);
var temp__4655__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__4655__auto__)){
var ns = temp__4655__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
} else {
return n;
}
}
});
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(taoensso.encore.fq_name(k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25502 = arguments.length;
var i__8403__auto___25503 = (0);
while(true){
if((i__8403__auto___25503 < len__8402__auto___25502)){
args__8409__auto__.push((arguments[i__8403__auto___25503]));

var G__25504 = (i__8403__auto___25503 + (1));
i__8403__auto___25503 = G__25504;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__25498){
var vec__25499 = p__25498;
var no_slash_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25499,(0),null);
var parts = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.explode_keyword,cljs.core.filterv(cljs.core.identity,ks)));
if(cljs.core.empty_QMARK_(parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",parts));
} else {
var ppop = cljs.core.pop(parts);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(((cljs.core.empty_QMARK_(ppop))?null:clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ppop)),cljs.core.peek(parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq25496){
var G__25497 = cljs.core.first(seq25496);
var seq25496__$1 = cljs.core.next(seq25496);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__25497,seq25496__$1);
});

taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25512 = arguments.length;
var i__8403__auto___25513 = (0);
while(true){
if((i__8403__auto___25513 < len__8402__auto___25512)){
args__8409__auto__.push((arguments[i__8403__auto___25513]));

var G__25514 = (i__8403__auto___25513 + (1));
i__8403__auto___25513 = G__25514;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__25507){
var vec__25508 = p__25507;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25508,(0),null);
var nplaces = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25508,(1),null);
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not(modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__25511 = ((((function (){var or__7289__auto__ = type;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.cst$kw$round;
}
})() instanceof cljs.core.Keyword))?(function (){var or__7289__auto__ = type;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.cst$kw$round;
}
})().fqn:null);
switch (G__25511) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$(n_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,type], null));

}
})();
if(cljs.core.not(modifier)){
return cljs.core.long$(rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq25505){
var G__25506 = cljs.core.first(seq25505);
var seq25505__$1 = cljs.core.next(seq25505);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__25506,seq25505__$1);
});

taoensso.encore.round_STAR_ = taoensso.encore.round;
/**
 * Optimized common case.
 */
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return ((function (){var G__25517 = (n * 10.0);
return Math.round(G__25517);
})() / 10.0);
});
/**
 * Optimized common case.
 */
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return ((function (){var G__25519 = (n * 100.0);
return Math.round(G__25519);
})() / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25530 = arguments.length;
var i__8403__auto___25531 = (0);
while(true){
if((i__8403__auto___25531 < len__8402__auto___25530)){
args__8409__auto__.push((arguments[i__8403__auto___25531]));

var G__25532 = (i__8403__auto___25531 + (1));
i__8403__auto___25531 = G__25532;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__25522){
var vec__25523 = p__25522;
var map__25526 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25523,(0),null);
var map__25526__$1 = ((((!((map__25526 == null)))?((((map__25526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25526.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25526):map__25526);
var min_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25526__$1,cljs.core.cst$kw$min);
var max_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25526__$1,cljs.core.cst$kw$max);
var factor = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__25526__$1,cljs.core.cst$kw$factor,(1000));
var binary_exp = (function (){var G__25528 = (2);
var G__25529 = (nattempt - (1));
return Math.pow(G__25528,G__25529);
})();
var time = (((binary_exp + cljs.core.rand.cljs$core$IFn$_invoke$arity$1(binary_exp)) * 0.5) * factor);
return cljs.core.long$((function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__7625__auto__ = min_SINGLEQUOTE_;
var y__7626__auto__ = time;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__7632__auto__ = max_SINGLEQUOTE_;
var y__7633__auto__ = time__$1;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq25520){
var G__25521 = cljs.core.first(seq25520);
var seq25520__$1 = cljs.core.next(seq25520);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__25521,seq25520__$1);
});

taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
/**
 * Useful for testing.
 */
taoensso.encore.now_udt_mock_fn = (function taoensso$encore$now_udt_mock_fn(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25538 = arguments.length;
var i__8403__auto___25539 = (0);
while(true){
if((i__8403__auto___25539 < len__8402__auto___25538)){
args__8409__auto__.push((arguments[i__8403__auto___25539]));

var G__25540 = (i__8403__auto___25539 + (1));
i__8403__auto___25539 = G__25540;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p__25534){
var vec__25535 = p__25534;
var mock_udts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25535,(0),null);
var mock_udts__$1 = (function (){var or__7289__auto__ = mock_udts;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}
})();
var idx = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.atom.call(null,(-1)));
return ((function (mock_udts__$1,idx,vec__25535,mock_udts){
return (function (){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mock_udts__$1,cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.inc));
});
;})(mock_udts__$1,idx,vec__25535,mock_udts))
});

taoensso.encore.now_udt_mock_fn.cljs$lang$maxFixedArity = (0);

taoensso.encore.now_udt_mock_fn.cljs$lang$applyTo = (function (seq25533){
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25533));
});

taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return cljs.core.long$((secs * 1000.0));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot(ms,(1000));
});
/**
 * Returns number of milliseconds in period defined by given args.
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25546 = arguments.length;
var i__8403__auto___25547 = (0);
while(true){
if((i__8403__auto___25547 < len__8402__auto___25546)){
args__8409__auto__.push((arguments[i__8403__auto___25547]));

var G__25548 = (i__8403__auto___25547 + (1));
i__8403__auto___25547 = G__25548;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__25542){
var map__25543 = p__25542;
var map__25543__$1 = ((((!((map__25543 == null)))?((((map__25543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25543.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25543):map__25543);
var opts = map__25543__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$months);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$weeks);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$hours);
var mins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$mins);
var secs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$secs);
var msecs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$msecs);
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,cljs.core.cst$kw$ms);
if(cljs.core.truth_(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__25543,map__25543__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (have_in__25545){
return taoensso.encore.hcond(false,"taoensso.encore",666,(new cljs.core.Delay(((function (map__25543,map__25543__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (){
return have_in__25545;
});})(map__25543,map__25543__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,null)),cljs.core.cst$sym$have_DASH_in__25545,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null));
});})(map__25543,map__25543__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys(opts)))){
} else {
throw (new Error("Assert failed: (have #{:msecs :secs :months :days :mins :hours :years :ms :weeks} :in (keys opts))"));
}

return taoensso.encore.round((((((((((cljs.core.truth_(years)?(((((years * (1000)) * (60)) * (60)) * (24)) * (365)):0.0) + (cljs.core.truth_(months)?(((((months * (1000)) * (60)) * (60)) * (24)) * 29.53):0.0)) + (cljs.core.truth_(weeks)?(((((weeks * (1000)) * (60)) * (60)) * (24)) * (7)):0.0)) + (cljs.core.truth_(days)?((((days * (1000)) * (60)) * (60)) * (24)):0.0)) + (cljs.core.truth_(hours)?(((hours * (1000)) * (60)) * (60)):0.0)) + (cljs.core.truth_(mins)?((mins * (1000)) * (60)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq25541){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25541));
});

taoensso.encore.secs = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(taoensso.encore.ms__GT_secs,taoensso.encore.ms);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(coll),(1));
} else {
return cljs.core.not(cljs.core.next(coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_(coll))){
var vec__25556 = coll;
var c1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25556,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
if(cljs.core.sequential_QMARK_(x)){
return cljs.core.vec(x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var vec__25562 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25562,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((cljs.core.count(v) > (1)))?cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(v,(1)):null)], null);
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var args25565 = [];
var len__8402__auto___25571 = arguments.length;
var i__8403__auto___25572 = (0);
while(true){
if((i__8403__auto___25572 < len__8402__auto___25571)){
args25565.push((arguments[i__8403__auto___25572]));

var G__25573 = (i__8403__auto___25572 + (1));
i__8403__auto___25572 = G__25573;
continue;
} else {
}
break;
}

var G__25570 = args25565.length;
switch (G__25570) {
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25565.slice((2)),(0),null));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_(_QMARK_x))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso.encore.conj_some,taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq25566){
var G__25567 = cljs.core.first(seq25566);
var seq25566__$1 = cljs.core.next(seq25566);
var G__25568 = cljs.core.first(seq25566__$1);
var seq25566__$2 = cljs.core.next(seq25566__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__25567,G__25568,seq25566__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);

/**
 * `run!` from Clojure 1.7+
 */
taoensso.encore.backport_run_BANG_ = (function taoensso$encore$backport_run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__25576_SHARP_,p2__25575_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__25575_SHARP_) : proc.call(null,p2__25575_SHARP_));
}),null,coll);
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__7632__auto__ = signed_idx;
var y__7633__auto__ = max_idx;
return ((x__7632__auto__ < y__7633__auto__) ? x__7632__auto__ : y__7633__auto__);
} else {
var x__7625__auto__ = (0);
var y__7626__auto__ = (signed_idx + max_idx);
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25583 = arguments.length;
var i__8403__auto___25584 = (0);
while(true){
if((i__8403__auto___25584 < len__8402__auto___25583)){
args__8409__auto__.push((arguments[i__8403__auto___25584]));

var G__25585 = (i__8403__auto___25584 + (1));
i__8403__auto___25584 = G__25585;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__25580){
var map__25581 = p__25580;
var map__25581__$1 = ((((!((map__25581 == null)))?((((map__25581.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25581.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25581):map__25581);
var max_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25581__$1,cljs.core.cst$kw$max_DASH_len);
var end_idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25581__$1,cljs.core.cst$kw$end_DASH_idx);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__25581,map__25581__$1,max_len,end_idx){
return (function (){
return max_len;
});})(map__25581,map__25581__$1,max_len,end_idx))
,null)),cljs.core.cst$sym$max_DASH_len,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] max-len)"));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count(x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx(start_idx__$1,xlen);
var end_idx_STAR_ = (cljs.core.truth_(max_len)?(function (){var n1__24768__auto__ = (start_idx_STAR_ + max_len);
var n2__24769__auto__ = xlen;
if((n1__24768__auto__ > n2__24769__auto__)){
return n2__24769__auto__;
} else {
return n1__24768__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx(end_idx,xlen) + (1)):xlen
));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq25577){
var G__25578 = cljs.core.first(seq25577);
var seq25577__$1 = cljs.core.next(seq25577);
var G__25579 = cljs.core.first(seq25577__$1);
var seq25577__$2 = cljs.core.next(seq25577__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__25578,G__25579,seq25577__$2);
});

/**
 * Like `subvec` but uses `sub-indexes`.
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25596 = arguments.length;
var i__8403__auto___25597 = (0);
while(true){
if((i__8403__auto___25597 < len__8402__auto___25596)){
args__8409__auto__.push((arguments[i__8403__auto___25597]));

var G__25598 = (i__8403__auto___25597 + (1));
i__8403__auto___25597 = G__25598;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__25589){
var vec__25590 = p__25589;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25590,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25590,_QMARK_max_len){
return (function (){
return v;
});})(vec__25590,_QMARK_max_len))
,null)),cljs.core.cst$sym$v,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? vector? v)"));
}

var vec__25593 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(v,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25593,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25593,(1),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq25586){
var G__25587 = cljs.core.first(seq25586);
var seq25586__$1 = cljs.core.next(seq25586);
var G__25588 = cljs.core.first(seq25586__$1);
var seq25586__$2 = cljs.core.next(seq25586__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__25587,G__25588,seq25586__$2);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7916__auto__,k__7917__auto__){
var self__ = this;
var this__7916__auto____$1 = this;
return this__7916__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__7917__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7918__auto__,k25600,else__7919__auto__){
var self__ = this;
var this__7918__auto____$1 = this;
var G__25602 = (((k25600 instanceof cljs.core.Keyword))?k25600.fqn:null);
switch (G__25602) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k25600,else__7919__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7930__auto__,writer__7931__auto__,opts__7932__auto__){
var self__ = this;
var this__7930__auto____$1 = this;
var pr_pair__7933__auto__ = ((function (this__7930__auto____$1){
return (function (keyval__7934__auto__){
return cljs.core.pr_sequential_writer(writer__7931__auto__,cljs.core.pr_writer,""," ","",opts__7932__auto__,keyval__7934__auto__);
});})(this__7930__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7931__auto__,pr_pair__7933__auto__,"#taoensso.encore.Swapped{",", ","}",opts__7932__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__25599){
var self__ = this;
var G__25599__$1 = this;
return (new cljs.core.RecordIter((0),G__25599__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val,cljs.core.cst$kw$return_DASH_val], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7914__auto__){
var self__ = this;
var this__7914__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7910__auto__){
var self__ = this;
var this__7910__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7920__auto__){
var self__ = this;
var this__7920__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7911__auto__){
var self__ = this;
var this__7911__auto____$1 = this;
var h__7729__auto__ = self__.__hash;
if(!((h__7729__auto__ == null))){
return h__7729__auto__;
} else {
var h__7729__auto____$1 = cljs.core.hash_imap(this__7911__auto____$1);
self__.__hash = h__7729__auto____$1;

return h__7729__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7912__auto__,other__7913__auto__){
var self__ = this;
var this__7912__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7277__auto__ = other__7913__auto__;
if(cljs.core.truth_(and__7277__auto__)){
return ((this__7912__auto____$1.constructor === other__7913__auto__.constructor)) && (cljs.core.equiv_map(this__7912__auto____$1,other__7913__auto__));
} else {
return and__7277__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7925__auto__,k__7926__auto__){
var self__ = this;
var this__7925__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$return_DASH_val,null,cljs.core.cst$kw$new_DASH_val,null], null), null),k__7926__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7925__auto____$1),self__.__meta),k__7926__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7926__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7923__auto__,k__7924__auto__,G__25599){
var self__ = this;
var this__7923__auto____$1 = this;
var pred__25603 = cljs.core.keyword_identical_QMARK_;
var expr__25604 = k__7924__auto__;
if(cljs.core.truth_((function (){var G__25606 = cljs.core.cst$kw$new_DASH_val;
var G__25607 = expr__25604;
return (pred__25603.cljs$core$IFn$_invoke$arity$2 ? pred__25603.cljs$core$IFn$_invoke$arity$2(G__25606,G__25607) : pred__25603.call(null,G__25606,G__25607));
})())){
return (new taoensso.encore.Swapped(G__25599,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__25608 = cljs.core.cst$kw$return_DASH_val;
var G__25609 = expr__25604;
return (pred__25603.cljs$core$IFn$_invoke$arity$2 ? pred__25603.cljs$core$IFn$_invoke$arity$2(G__25608,G__25609) : pred__25603.call(null,G__25608,G__25609));
})())){
return (new taoensso.encore.Swapped(self__.new_val,G__25599,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7924__auto__,G__25599),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7928__auto__){
var self__ = this;
var this__7928__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7915__auto__,G__25599){
var self__ = this;
var this__7915__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__25599,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7921__auto__,entry__7922__auto__){
var self__ = this;
var this__7921__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7922__auto__)){
return this__7921__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7922__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7921__auto____$1,entry__7922__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$new_DASH_val,cljs.core.cst$sym$return_DASH_val], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__7950__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__7950__auto__,writer__7951__auto__){
return cljs.core._write(writer__7951__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__25601){
return (new taoensso.encore.Swapped(cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(G__25601),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(G__25601),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__25601,cljs.core.cst$kw$new_DASH_val,cljs.core.array_seq([cljs.core.cst$kw$return_DASH_val], 0)),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_(x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(x),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_((function (){var G__25624 = f;
var G__25625 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25624,G__25625) : taoensso.encore.kw_identical_QMARK_.call(null,G__25624,G__25625));
})())){
return taoensso.encore.swapped_STAR_((function (){var G__25626 = m;
var G__25627 = cljs.core.butlast(ks);
var G__25628 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__25626,G__25627,G__25628) : taoensso.encore.dissoc_in.call(null,G__25626,G__25627,G__25628));
})());
} else {
var old_val_in = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks);
var vec__25629 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val_in) : f.call(null,old_val_in)));
var new_val_in = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25629,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25629,(1),null);
var new_val = (cljs.core.truth_((function (){var G__25632 = new_val_in;
var G__25633 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25632,G__25633) : taoensso.encore.kw_identical_QMARK_.call(null,G__25632,G__25633));
})())?(function (){var G__25634 = m;
var G__25635 = cljs.core.butlast(ks);
var G__25636 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__25634,G__25635,G__25636) : taoensso.encore.dissoc_in.call(null,G__25634,G__25635,G__25636));
})():cljs.core.assoc_in(m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops.
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (accum,_QMARK_op){
if(cljs.core.not(_QMARK_op)){
return accum;
} else {
var vec__25641 = ((cljs.core.not(_QMARK_vf_type))?_QMARK_op:cljs.core.cons(_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25641,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25641,(1),null);
var valf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25641,(2),null);
var G__25644 = (((vf_type instanceof cljs.core.Keyword))?vf_type.fqn:null);
switch (G__25644) {
case "reset":
if(cljs.core.empty_QMARK_(ks)){
return valf;
} else {
return cljs.core.assoc_in(accum,ks,valf);
}

break;
case "swap":
if(cljs.core.empty_QMARK_(ks)){
return (valf.cljs$core$IFn$_invoke$arity$1 ? valf.cljs$core$IFn$_invoke$arity$1(accum) : valf.call(null,accum));
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taoensso.encore.swapped_STAR__in(accum,ks,valf),(0));
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(vf_type)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25648 = arguments.length;
var i__8403__auto___25649 = (0);
while(true){
if((i__8403__auto___25649 < len__8402__auto___25648)){
args__8409__auto__.push((arguments[i__8403__auto___25649]));

var G__25650 = (i__8403__auto___25649 + (1));
i__8403__auto___25649 = G__25650;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_(null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq25646){
var G__25647 = cljs.core.first(seq25646);
var seq25646__$1 = cljs.core.next(seq25646);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__25647,seq25646__$1);
});

/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var args25651 = [];
var len__8402__auto___25664 = arguments.length;
var i__8403__auto___25665 = (0);
while(true){
if((i__8403__auto___25665 < len__8402__auto___25664)){
args25651.push((arguments[i__8403__auto___25665]));

var G__25666 = (i__8403__auto___25665 + (1));
i__8403__auto___25665 = G__25666;
continue;
} else {
}
break;
}

var G__25657 = args25651.length;
switch (G__25657) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25651.slice((3)),(0),null));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_(ks)){
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__25658 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val) : f.call(null,old_val)));
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25658,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25658,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__25661 = taoensso.encore.swapped_STAR__in(old_val,ks,f);
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25661,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25661,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$swap,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq25652){
var G__25653 = cljs.core.first(seq25652);
var seq25652__$1 = cljs.core.next(seq25652);
var G__25654 = cljs.core.first(seq25652__$1);
var seq25652__$2 = cljs.core.next(seq25652__$1);
var G__25655 = cljs.core.first(seq25652__$2);
var seq25652__$3 = cljs.core.next(seq25652__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25653,G__25654,G__25655,seq25652__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Is to `reset!` as `swap-in!` is to `swap!`.
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var args25668 = [];
var len__8402__auto___25675 = arguments.length;
var i__8403__auto___25676 = (0);
while(true){
if((i__8403__auto___25676 < len__8402__auto___25675)){
args25668.push((arguments[i__8403__auto___25676]));

var G__25677 = (i__8403__auto___25676 + (1));
i__8403__auto___25676 = G__25677;
continue;
} else {
}
break;
}

var G__25674 = args25668.length;
switch (G__25674) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25668.slice((3)),(0),null));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8421__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_(ks)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,new_val) : cljs.core.reset_BANG_.call(null,atom_,new_val));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,(function (old_val){
return cljs.core.assoc_in(old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val__$1 = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$reset,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq25669){
var G__25670 = cljs.core.first(seq25669);
var seq25669__$1 = cljs.core.next(seq25669);
var G__25671 = cljs.core.first(seq25669__$1);
var seq25669__$2 = cljs.core.next(seq25669__$1);
var G__25672 = cljs.core.first(seq25669__$2);
var seq25669__$3 = cljs.core.next(seq25669__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25670,G__25671,G__25672,seq25669__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25682 = arguments.length;
var i__8403__auto___25683 = (0);
while(true){
if((i__8403__auto___25683 < len__8402__auto___25682)){
args__8409__auto__.push((arguments[i__8403__auto___25683]));

var G__25684 = (i__8403__auto___25683 + (1));
i__8403__auto___25683 = G__25684;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m,dissoc_ks);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,m,ks,cljs.core.dissoc,dissoc_ks);
}
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq25679){
var G__25680 = cljs.core.first(seq25679);
var seq25679__$1 = cljs.core.next(seq25679);
var G__25681 = cljs.core.first(seq25679__$1);
var seq25679__$2 = cljs.core.next(seq25679__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__25680,G__25681,seq25679__$2);
});

taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.butlast(ks)),cljs.core.last(ks));
});
/**
 * Assocs each kv iff its value is not nil.
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25705 = arguments.length;
var i__8403__auto___25706 = (0);
while(true){
if((i__8403__auto___25706 < len__8402__auto___25705)){
args__8409__auto__.push((arguments[i__8403__auto___25706]));

var G__25707 = (i__8403__auto___25706 + (1));
i__8403__auto___25706 = G__25707;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = m;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8077__auto__ = (function taoensso$encore$iter__25687(s__25688){
return (new cljs.core.LazySeq(null,(function (){
var s__25688__$1 = s__25688;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__25688__$1);
if(temp__4657__auto__){
var s__25688__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25688__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__25688__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__25690 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__25689 = (0);
while(true){
if((i__25689 < size__8076__auto__)){
var vec__25699 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__25689);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25699,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25699,(1),null);
if(!((v == null))){
cljs.core.chunk_append(b__25690,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__25708 = (i__25689 + (1));
i__25689 = G__25708;
continue;
} else {
var G__25709 = (i__25689 + (1));
i__25689 = G__25709;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25690),taoensso$encore$iter__25687(cljs.core.chunk_rest(s__25688__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25690),null);
}
} else {
var vec__25702 = cljs.core.first(s__25688__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25702,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25702,(1),null);
if(!((v == null))){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__25687(cljs.core.rest(s__25688__$2)));
} else {
var G__25710 = cljs.core.rest(s__25688__$2);
s__25688__$1 = G__25710;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8077__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq25685){
var G__25686 = cljs.core.first(seq25685);
var seq25685__$1 = cljs.core.next(seq25685);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__25686,seq25685__$1);
});

/**
 * Assocs each kv iff its val is truthy.
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25731 = arguments.length;
var i__8403__auto___25732 = (0);
while(true){
if((i__8403__auto___25732 < len__8402__auto___25731)){
args__8409__auto__.push((arguments[i__8403__auto___25732]));

var G__25733 = (i__8403__auto___25732 + (1));
i__8403__auto___25732 = G__25733;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7289__auto__ = m;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8077__auto__ = (function taoensso$encore$iter__25713(s__25714){
return (new cljs.core.LazySeq(null,(function (){
var s__25714__$1 = s__25714;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__25714__$1);
if(temp__4657__auto__){
var s__25714__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__25714__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__25714__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__25716 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__25715 = (0);
while(true){
if((i__25715 < size__8076__auto__)){
var vec__25725 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__25715);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25725,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25725,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append(b__25716,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__25734 = (i__25715 + (1));
i__25715 = G__25734;
continue;
} else {
var G__25735 = (i__25715 + (1));
i__25715 = G__25735;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__25716),taoensso$encore$iter__25713(cljs.core.chunk_rest(s__25714__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__25716),null);
}
} else {
var vec__25728 = cljs.core.first(s__25714__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25728,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25728,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__25713(cljs.core.rest(s__25714__$2)));
} else {
var G__25736 = cljs.core.rest(s__25714__$2);
s__25714__$1 = G__25736;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8077__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq25711){
var G__25712 = cljs.core.first(seq25711);
var seq25711__$1 = cljs.core.next(seq25711);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__25712,seq25711__$1);
});

taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue.
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var args25737 = [];
var len__8402__auto___25740 = arguments.length;
var i__8403__auto___25741 = (0);
while(true){
if((i__8403__auto___25741 < len__8402__auto___25740)){
args25737.push((arguments[i__8403__auto___25741]));

var G__25742 = (i__8403__auto___25741 + (1));
i__8403__auto___25741 = G__25742;
continue;
} else {
}
break;
}

var G__25739 = args25737.length;
switch (G__25739) {
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args25737.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0(),coll);
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;

taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25745 = arguments.length;
var i__8403__auto___25746 = (0);
while(true){
if((i__8403__auto___25746 < len__8402__auto___25745)){
args__8409__auto__.push((arguments[i__8403__auto___25746]));

var G__25747 = (i__8403__auto___25746 + (1));
i__8403__auto___25746 = G__25747;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1(items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq25744){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25744));
});

/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25751 = arguments.length;
var i__8403__auto___25752 = (0);
while(true){
if((i__8403__auto___25752 < len__8402__auto___25751)){
args__8409__auto__.push((arguments[i__8403__auto___25752]));

var G__25753 = (i__8403__auto___25752 + (1));
i__8403__auto___25752 = G__25753;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(args),(function (){var G__25750 = cljs.core.last(args);
return (taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1(G__25750) : taoensso.encore.seq_kvs.call(null,G__25750));
})()));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq25748){
var G__25749 = cljs.core.first(seq25748);
var seq25748__$1 = cljs.core.next(seq25748);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__25749,seq25748__$1);
});

/**
 * Workaround for Clojure versions [1.4, 1.5) that blow up on `reduce-kv`s
 *   against a nil coll, Ref. http://dev.clojure.org/jira/browse/CLJ-1098.
 */
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__7289__auto__ = x;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var kf__$1 = ((cljs.core.not((function (){var G__25758 = kf;
var G__25759 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25758,G__25759) : taoensso.encore.kw_identical_QMARK_.call(null,G__25758,G__25759));
})()))?kf:(function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
}));
var vf__$1 = ((cljs.core.not((function (){var G__25760 = vf;
var G__25761 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25760,G__25761) : taoensso.encore.kw_identical_QMARK_.call(null,G__25760,G__25761));
})()))?vf:((function (kf__$1){
return (function (_,v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(kf__$1))
);
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kf__$1,vf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,(cljs.core.truth_(kf__$1)?(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : kf__$1.call(null,k,v)):k),(cljs.core.truth_(vf__$1)?(vf__$1.cljs$core$IFn$_invoke$arity$2 ? vf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : vf__$1.call(null,k,v)):v));
});})(kf__$1,vf__$1))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs((function (k,_){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null,k));
}),null,m);
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs(null,(function (_,v){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v));
}),m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__7277__auto__ = (predk.cljs$core$IFn$_invoke$arity$1 ? predk.cljs$core$IFn$_invoke$arity$1(k) : predk.call(null,k));
if(cljs.core.truth_(and__7277__auto__)){
return (predv.cljs$core$IFn$_invoke$arity$1 ? predv.cljs$core$IFn$_invoke$arity$1(v) : predv.call(null,v));
} else {
return and__7277__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs(pred,cljs.core.constantly(true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs(cljs.core.constantly(true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
/**
 * Cross between `hash-map` & `map-kvs`.
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25780 = arguments.length;
var i__8403__auto___25781 = (0);
while(true){
if((i__8403__auto___25781 < len__8402__auto___25780)){
args__8409__auto__.push((arguments[i__8403__auto___25781]));

var G__25782 = (i__8403__auto___25781 + (1));
i__8403__auto___25781 = G__25782;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__25764){
var vec__25765 = p__25764;
var kf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25765,(0),null);
var vf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25765,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25765,kf,vf){
return (function (){
return kvs;
});})(vec__25765,kf,vf))
,null)),cljs.core.cst$sym$kvs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.sequential_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$sequential_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? sequential?] kvs)"));
}

if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25765,kf,vf){
return (function (){
return kf;
});})(vec__25765,kf,vf))
,null)),cljs.core.cst$sym$kf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null)),taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25765,kf,vf){
return (function (){
return vf;
});})(vec__25765,kf,vf))
,null)),cljs.core.cst$sym$vf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null))], null);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? ifn?] kf vf)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(kvs))?cljs.core.PersistentArrayMap.EMPTY:(function (){var kf__$1 = ((cljs.core.not((function (){var G__25768 = kf;
var G__25769 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25768,G__25769) : taoensso.encore.kw_identical_QMARK_.call(null,G__25768,G__25769));
})()))?kf:((function (vec__25765,kf,vf){
return (function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
});})(vec__25765,kf,vf))
);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var G__25773 = kvs;
var vec__25774 = G__25773;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25774,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25774,(1),null);
var s = vec__25774;
var m__$1 = m;
var G__25773__$1 = G__25773;
while(true){
var m__$2 = m__$1;
var vec__25777 = G__25773__$1;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25777,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25777,(1),null);
var s__$1 = vec__25777;
var k__$2 = ((cljs.core.not(kf__$1))?k__$1:(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k__$1,v__$1) : kf__$1.call(null,k__$1,v__$1)));
var v__$2 = ((cljs.core.not(vf))?v__$1:(vf.cljs$core$IFn$_invoke$arity$2 ? vf.cljs$core$IFn$_invoke$arity$2(k__$2,v__$1) : vf.call(null,k__$2,v__$1)));
var new_m = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$2,k__$2,v__$2);
var temp__4655__auto__ = cljs.core.nnext(s__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var n = temp__4655__auto__;
var G__25783 = new_m;
var G__25784 = n;
m__$1 = G__25783;
G__25773__$1 = G__25784;
continue;
} else {
return cljs.core.persistent_BANG_(new_m);
}
break;
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__25765,kf,vf){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__25765,kf,vf))
,null)),cljs.core.cst$sym$_PERCENT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] %)"));
}

return _PERCENT_;
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq25762){
var G__25763 = cljs.core.first(seq25762);
var seq25762__$1 = cljs.core.next(seq25762);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__25763,seq25762__$1);
});

/**
 * Faster `zipmap` using transients.
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq(ks);
var vs__$1 = cljs.core.seq(vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_(m);
} else {
var G__25785 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core.first(ks__$1),cljs.core.first(vs__$1));
var G__25786 = cljs.core.next(ks__$1);
var G__25787 = cljs.core.next(vs__$1);
m = G__25785;
ks__$1 = G__25786;
vs__$1 = G__25787;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s.
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var args25788 = [];
var len__8402__auto___25794 = arguments.length;
var i__8403__auto___25795 = (0);
while(true){
if((i__8403__auto___25795 < len__8402__auto___25794)){
args25788.push((arguments[i__8403__auto___25795]));

var G__25796 = (i__8403__auto___25795 + (1));
i__8403__auto___25795 = G__25796;
continue;
} else {
}
break;
}

var G__25793 = args25788.length;
switch (G__25793) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25788.slice((2)),(0),null));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq25789){
var G__25790 = cljs.core.first(seq25789);
var seq25789__$1 = cljs.core.next(seq25789);
var G__25791 = cljs.core.first(seq25789__$1);
var seq25789__$2 = cljs.core.next(seq25789__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__25790,G__25791,seq25789__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);

/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb.
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var args25798 = [];
var len__8402__auto___25804 = arguments.length;
var i__8403__auto___25805 = (0);
while(true){
if((i__8403__auto___25805 < len__8402__auto___25804)){
args25798.push((arguments[i__8403__auto___25805]));

var G__25806 = (i__8403__auto___25805 + (1));
i__8403__auto___25805 = G__25806;
continue;
} else {
}
break;
}

var G__25803 = args25798.length;
switch (G__25803) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__8421__auto__ = (new cljs.core.IndexedSeq(args25798.slice((2)),(0),null));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8421__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0))));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.encore.interleave_all,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq25799){
var G__25800 = cljs.core.first(seq25799);
var seq25799__$1 = cljs.core.next(seq25799);
var G__25801 = cljs.core.first(seq25799__$1);
var seq25799__$2 = cljs.core.next(seq25799__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__25800,G__25801,seq25799__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);

taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_(coll)){
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(coll,(0),cljs.core.array_seq([n], 0));
} else {
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll));
}
});
/**
 * Prefer `set` when order doesn't matter (much faster).
 */
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var args25808 = [];
var len__8402__auto___25819 = arguments.length;
var i__8403__auto___25820 = (0);
while(true){
if((i__8403__auto___25820 < len__8402__auto___25819)){
args25808.push((arguments[i__8403__auto___25820]));

var G__25821 = (i__8403__auto___25820 + (1));
i__8403__auto___25820 = G__25821;
continue;
} else {
}
break;
}

var G__25810 = args25808.length;
switch (G__25810) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args25808.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__25811,in$){
var vec__25812 = p__25811;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25812,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25812,(1),null);
if(!(cljs.core.contains_QMARK_(seen,in$))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in$)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__25815,in$){
var vec__25816 = p__25815;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25816,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25816,(1),null);
var in_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(in$) : keyfn.call(null,in$));
if(!(cljs.core.contains_QMARK_(seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;

/**
 * Like `sort-by` for distinct. Based on clojure.core/distinct.
 */
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__25839,seen__$1){
while(true){
var vec__25840 = p__25839;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25840,(0),null);
var xs__$1 = vec__25840;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var v_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(v) : keyfn.call(null,v));
if(cljs.core.contains_QMARK_(seen__$1,v_STAR_)){
var G__25843 = cljs.core.rest(s);
var G__25844 = seen__$1;
p__25839 = G__25843;
seen__$1 = G__25844;
continue;
} else {
return cljs.core.cons(v,taoensso$encore$distinct_by_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv(cljs.core.complement(pred),coll);
});

/**
 * distinctv` transducer.
 */
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var args25849 = [];
var len__8402__auto___25854 = arguments.length;
var i__8403__auto___25855 = (0);
while(true){
if((i__8403__auto___25855 < len__8402__auto___25854)){
args25849.push((arguments[i__8403__auto___25855]));

var G__25856 = (i__8403__auto___25855 + (1));
i__8403__auto___25855 = G__25856;
continue;
} else {
}
break;
}

var G__25851 = args25849.length;
switch (G__25851) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args25849.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen_ = (function (){var G__25852 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25852) : cljs.core.atom.call(null,G__25852));
})();
return ((function (seen_){
return (function() {
var G__25858 = null;
var G__25858__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__25858__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__25858__2 = (function (acc,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),input)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,input);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__25858 = function(acc,input){
switch(arguments.length){
case 0:
return G__25858__0.call(this);
case 1:
return G__25858__1.call(this,acc);
case 2:
return G__25858__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__25858.cljs$core$IFn$_invoke$arity$0 = G__25858__0;
G__25858.cljs$core$IFn$_invoke$arity$1 = G__25858__1;
G__25858.cljs$core$IFn$_invoke$arity$2 = G__25858__2;
return G__25858;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = (function (){var G__25853 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25853) : cljs.core.atom.call(null,G__25853));
})();
return ((function (seen_){
return (function() {
var G__25859 = null;
var G__25859__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__25859__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__25859__2 = (function (acc,input){
var k = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(input) : keyfn.call(null,input));
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),k)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,k);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__25859 = function(acc,input){
switch(arguments.length){
case 0:
return G__25859__0.call(this);
case 1:
return G__25859__1.call(this,acc);
case 2:
return G__25859__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__25859.cljs$core$IFn$_invoke$arity$0 = G__25859__0;
G__25859.cljs$core$IFn$_invoke$arity$1 = G__25859__1;
G__25859.cljs$core$IFn$_invoke$arity$2 = G__25859__2;
return G__25859;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1(keyfn),coll);
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 2;

/**
 * Reverse comparator.
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare(y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25862 = arguments.length;
var i__8403__auto___25863 = (0);
while(true){
if((i__8403__auto___25863 < len__8402__auto___25862)){
args__8409__auto__.push((arguments[i__8403__auto___25863]));

var G__25864 = (i__8403__auto___25863 + (1));
i__8403__auto___25863 = G__25864;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var rv = cljs.core.val(e);
if(!(cljs.core.contains_QMARK_(m,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,rv);
} else {
var lv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if((cljs.core.map_QMARK_(lv)) && (cljs.core.map_QMARK_(rv))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.array_seq([lv,rv], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(lv,rv) : f.call(null,lv,rv)));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__7289__auto__ = m1;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq25860){
var G__25861 = cljs.core.first(seq25860);
var seq25860__$1 = cljs.core.next(seq25860);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__25861,seq25860__$1);
});

taoensso.encore.nested_merge = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_(x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Returns the 'greatest' element in coll in O(n) time.
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25873 = arguments.length;
var i__8403__auto___25874 = (0);
while(true){
if((i__8403__auto___25874 < len__8402__auto___25873)){
args__8409__auto__.push((arguments[i__8403__auto___25874]));

var G__25875 = (i__8403__auto___25874 + (1));
i__8403__auto___25874 = G__25875;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__25869){
var vec__25870 = p__25869;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25870,(0),null);
var comparator = (function (){var or__7289__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__25870,_QMARK_comparator){
return (function (p1__25865_SHARP_,p2__25866_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__25865_SHARP_,p2__25866_SHARP_) : comparator.call(null,p1__25865_SHARP_,p2__25866_SHARP_)) > (0))){
return p2__25866_SHARP_;
} else {
return p1__25865_SHARP_;
}
});})(comparator,vec__25870,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq25867){
var G__25868 = cljs.core.first(seq25867);
var seq25867__$1 = cljs.core.next(seq25867);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__25868,seq25867__$1);
});

/**
 * Returns the 'least' element in coll in O(n) time.
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25884 = arguments.length;
var i__8403__auto___25885 = (0);
while(true){
if((i__8403__auto___25885 < len__8402__auto___25884)){
args__8409__auto__.push((arguments[i__8403__auto___25885]));

var G__25886 = (i__8403__auto___25885 + (1));
i__8403__auto___25885 = G__25886;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__25880){
var vec__25881 = p__25880;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25881,(0),null);
var comparator = (function (){var or__7289__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__25881,_QMARK_comparator){
return (function (p1__25876_SHARP_,p2__25877_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__25876_SHARP_,p2__25877_SHARP_) : comparator.call(null,p1__25876_SHARP_,p2__25877_SHARP_)) < (0))){
return p2__25877_SHARP_;
} else {
return p1__25876_SHARP_;
}
});})(comparator,vec__25881,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq25878){
var G__25879 = cljs.core.first(seq25878);
var seq25878__$1 = cljs.core.next(seq25878);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__25879,seq25878__$1);
});

/**
 * Like `repeatedly` but faster and `conj`s items into given collection.
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((coll instanceof clojure.lang.IEditableCollection)){
var v = cljs.core.transient$(coll);
var idx = (0);
while(true){
if((idx >= n)){
return cljs.core.persistent_BANG_(v);
} else {
var G__25887 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__25888 = (idx + (1));
v = G__25887;
idx = G__25888;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx >= n)){
return v;
} else {
var G__25889 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__25890 = (idx + (1));
v = G__25889;
idx = G__25890;
continue;
}
break;
}
}
});
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__7289__auto__ = fmt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25893 = arguments.length;
var i__8403__auto___25894 = (0);
while(true){
if((i__8403__auto___25894 < len__8402__auto___25893)){
args__8409__auto__.push((arguments[i__8403__auto___25894]));

var G__25895 = (i__8403__auto___25894 + (1));
i__8403__auto___25894 = G__25895;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_(fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq25891){
var G__25892 = cljs.core.first(seq25891);
var seq25891__$1 = cljs.core.next(seq25891);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__25892,seq25891__$1);
});

/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`.
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25906 = arguments.length;
var i__8403__auto___25907 = (0);
while(true){
if((i__8403__auto___25907 < len__8402__auto___25906)){
args__8409__auto__.push((arguments[i__8403__auto___25907]));

var G__25908 = (i__8403__auto___25907 + (1));
i__8403__auto___25907 = G__25908;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__25899){
var vec__25900 = p__25899;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25900,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__25900,_QMARK_max_len){
return (function (){
return s;
});})(vec__25900,_QMARK_max_len))
,null)),cljs.core.cst$sym$s,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? string? s)"));
}

var vec__25903 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(s,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25903,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25903,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq25896){
var G__25897 = cljs.core.first(seq25896);
var seq25896__$1 = cljs.core.next(seq25896);
var G__25898 = cljs.core.first(seq25896__$1);
var seq25896__$2 = cljs.core.next(seq25896__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__25897,G__25898,seq25896__$2);
});

taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25916 = arguments.length;
var i__8403__auto___25917 = (0);
while(true){
if((i__8403__auto___25917 < len__8402__auto___25916)){
args__8409__auto__.push((arguments[i__8403__auto___25917]));

var G__25918 = (i__8403__auto___25917 + (1));
i__8403__auto___25917 = G__25918;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__25912){
var vec__25913 = p__25912;
var start_idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25913,(0),null);
var last_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25913,(1),null);
var start_idx__$1 = ((function (){var or__7289__auto__ = start_idx;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq25909){
var G__25910 = cljs.core.first(seq25909);
var seq25909__$1 = cljs.core.next(seq25909);
var G__25911 = cljs.core.first(seq25909__$1);
var seq25909__$2 = cljs.core.next(seq25909__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__25910,G__25911,seq25909__$2);
});

/**
 * Like `clojure.string/join` but ensures no double separators.
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25921 = arguments.length;
var i__8403__auto___25922 = (0);
while(true){
if((i__8403__auto___25922 < len__8402__auto___25921)){
args__8409__auto__.push((arguments[i__8403__auto___25922]));

var G__25923 = (i__8403__auto___25922 + (1));
i__8403__auto___25922 = G__25923;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s1,s2){
var s1__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1)].join('');
var s2__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_(s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s1__$1,"")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s2__$1,""))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(separator),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq25919){
var G__25920 = cljs.core.first(seq25919);
var seq25919__$1 = cljs.core.next(seq25919);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__25920,seq25919__$1);
});

/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition.
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25925 = arguments.length;
var i__8403__auto___25926 = (0);
while(true){
if((i__8403__auto___25926 < len__8402__auto___25925)){
args__8409__auto__.push((arguments[i__8403__auto___25926]));

var G__25927 = (i__8403__auto___25926 + (1));
i__8403__auto___25926 = G__25927;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq25924){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq25924));
});

/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space.
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(clojure.string.blank_QMARK_(s)){
return (0);
} else {
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var args25928 = [];
var len__8402__auto___25931 = arguments.length;
var i__8403__auto___25932 = (0);
while(true){
if((i__8403__auto___25932 < len__8402__auto___25931)){
args25928.push((arguments[i__8403__auto___25932]));

var G__25933 = (i__8403__auto___25932 + (1));
i__8403__auto___25932 = G__25933;
continue;
} else {
}
break;
}

var G__25930 = args25928.length;
switch (G__25930) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args25928.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0(),(0),cljs.core.array_seq([max_length], 0));
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int((15)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int((14)))).toString((16));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("4"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rhex),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex())].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;

taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0() <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value.
 *   Specialized, fast `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_v = (function (){var G__25936 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(old_m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__25936) : f.call(null,G__25936));
})();
var new_m = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_(atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * As `clojure.core/memoize` but uses delays to avoid write races.
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = (function (){var G__25939 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25939) : cljs.core.atom.call(null,G__25939));
})();
return ((function (cache_){
return (function() { 
var G__25941__delegate = function (args){
var G__25940 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args,((function (or__7289__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7289__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7289__auto__,cache_))
,null));
}
});})(or__7289__auto__,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25940) : cljs.core.deref.call(null,G__25940));
};
var G__25941 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25942__i = 0, G__25942__a = new Array(arguments.length -  0);
while (G__25942__i < G__25942__a.length) {G__25942__a[G__25942__i] = arguments[G__25942__i + 0]; ++G__25942__i;}
  args = new cljs.core.IndexedSeq(G__25942__a,0);
} 
return G__25941__delegate.call(this,args);};
G__25941.cljs$lang$maxFixedArity = 0;
G__25941.cljs$lang$applyTo = (function (arglist__25943){
var args = cljs.core.seq(arglist__25943);
return G__25941__delegate(args);
});
G__25941.cljs$core$IFn$_invoke$arity$variadic = G__25941__delegate;
return G__25941;
})()
;
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = (function (){var G__25946 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25946) : cljs.core.atom.call(null,G__25946));
})();
return ((function (cache_){
return (function() { 
var G__25948__delegate = function (args){
var G__25947 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache_,((function (or__7289__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([args,(new cljs.core.Delay(((function (or__7289__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7289__auto__,cache_))
,null))]);
}
});})(or__7289__auto__,cache_))
),args);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25947) : cljs.core.deref.call(null,G__25947));
};
var G__25948 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25949__i = 0, G__25949__a = new Array(arguments.length -  0);
while (G__25949__i < G__25949__a.length) {G__25949__a[G__25949__i] = arguments[G__25949__i + 0]; ++G__25949__i;}
  args = new cljs.core.IndexedSeq(G__25949__a,0);
} 
return G__25948__delegate.call(this,args);};
G__25948.cljs$lang$maxFixedArity = 0;
G__25948.cljs$lang$applyTo = (function (arglist__25950){
var args = cljs.core.seq(arglist__25950);
return G__25948__delegate(args);
});
G__25948.cljs$core$IFn$_invoke$arity$variadic = G__25948__delegate;
return G__25948;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments.
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__8409__auto__ = [];
var len__8402__auto___25956 = arguments.length;
var i__8403__auto___25957 = (0);
while(true){
if((i__8403__auto___25957 < len__8402__auto___25956)){
args__8409__auto__.push((arguments[i__8403__auto___25957]));

var G__25958 = (i__8403__auto___25957 + (1));
i__8403__auto___25957 = G__25958;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((2) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((2)),(0),null)):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8410__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not(cache)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
} else {
var G__25955 = taoensso.encore.swap_val_BANG_(cache,args,(function (p1__25951_SHARP_){
if(cljs.core.truth_(p1__25951_SHARP_)){
return p1__25951_SHARP_;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}),null));
}
}));
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25955) : cljs.core.deref.call(null,G__25955));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq25952){
var G__25953 = cljs.core.first(seq25952);
var seq25952__$1 = cljs.core.next(seq25952);
var G__25954 = cljs.core.first(seq25952__$1);
var seq25952__$2 = cljs.core.next(seq25952__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__25953,G__25954,seq25952__$2);
});

/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var args25961 = [];
var len__8402__auto___26042 = arguments.length;
var i__8403__auto___26043 = (0);
while(true){
if((i__8403__auto___26043 < len__8402__auto___26042)){
args25961.push((arguments[i__8403__auto___26043]));

var G__26044 = (i__8403__auto___26043 + (1));
i__8403__auto___26043 = G__26044;
continue;
} else {
}
break;
}

var G__25963 = args25961.length;
switch (G__25963) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args25961.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = (function (){var G__25964 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25964) : cljs.core.atom.call(null,G__25964));
})();
return ((function (cache_){
return (function() { 
var G__26046__delegate = function (p__25965){
var vec__25966 = p__25965;
var seq__25967 = cljs.core.seq(vec__25966);
var first__25968 = cljs.core.first(seq__25967);
var seq__25967__$1 = cljs.core.next(seq__25967);
var arg1 = first__25968;
var argn = seq__25967__$1;
var args = vec__25966;
if(cljs.core.truth_((function (){var G__25969 = arg1;
var G__25970 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25969,G__25970) : taoensso.encore.kw_identical_QMARK_.call(null,G__25969,G__25970));
})())){
if(cljs.core.truth_((function (){var G__25971 = cljs.core.first(argn);
var G__25972 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25971,G__25972) : taoensso.encore.kw_identical_QMARK_.call(null,G__25971,G__25972));
})())){
var G__25973_26047 = cache_;
var G__25974_26048 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__25973_26047,G__25974_26048) : cljs.core.reset_BANG_.call(null,G__25973_26047,G__25974_26048));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = (function (){var G__25975 = arg1;
var G__25976 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25975,G__25976) : taoensso.encore.kw_identical_QMARK_.call(null,G__25975,G__25976));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var G__25977 = (function (){var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args__$1);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args__$1,((function (or__7289__auto__,fresh_QMARK_,args__$1,vec__25966,seq__25967,first__25968,seq__25967__$1,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.not(fresh_QMARK_);
} else {
return and__7277__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7289__auto__,fresh_QMARK_,args__$1,vec__25966,seq__25967,first__25968,seq__25967__$1,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(or__7289__auto__,fresh_QMARK_,args__$1,vec__25966,seq__25967,first__25968,seq__25967__$1,arg1,argn,args,cache_))
,null));
}
});})(or__7289__auto__,fresh_QMARK_,args__$1,vec__25966,seq__25967,first__25968,seq__25967__$1,arg1,argn,args,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__25977) : cljs.core.deref.call(null,G__25977));
}
};
var G__26046 = function (var_args){
var p__25965 = null;
if (arguments.length > 0) {
var G__26049__i = 0, G__26049__a = new Array(arguments.length -  0);
while (G__26049__i < G__26049__a.length) {G__26049__a[G__26049__i] = arguments[G__26049__i + 0]; ++G__26049__i;}
  p__25965 = new cljs.core.IndexedSeq(G__26049__a,0);
} 
return G__26046__delegate.call(this,p__25965);};
G__26046.cljs$lang$maxFixedArity = 0;
G__26046.cljs$lang$applyTo = (function (arglist__26050){
var p__25965 = cljs.core.seq(arglist__26050);
return G__26046__delegate(p__25965);
});
G__26046.cljs$core$IFn$_invoke$arity$variadic = G__26046__delegate;
return G__26046;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


var cache = (function (){var G__25978 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25978) : cljs.core.atom.call(null,G__25978));
})();
return ((function (cache){
return (function() { 
var G__26051__delegate = function (p__25979){
var vec__25980 = p__25979;
var seq__25981 = cljs.core.seq(vec__25980);
var first__25982 = cljs.core.first(seq__25981);
var seq__25981__$1 = cljs.core.next(seq__25981);
var arg1 = first__25982;
var argn = seq__25981__$1;
var args = vec__25980;
if(cljs.core.truth_((function (){var G__25983 = arg1;
var G__25984 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25983,G__25984) : taoensso.encore.kw_identical_QMARK_.call(null,G__25983,G__25984));
})())){
if(cljs.core.truth_((function (){var G__25985 = cljs.core.first(argn);
var G__25986 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25985,G__25986) : taoensso.encore.kw_identical_QMARK_.call(null,G__25985,G__25986));
})())){
var G__25987_26052 = cache;
var G__25988_26053 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__25987_26052,G__25988_26053) : cljs.core.reset_BANG_.call(null,G__25987_26052,G__25988_26053));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_26054 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache,((function (instant_26054,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache){
return (function (m){
return cljs.core.reduce_kv(((function (instant_26054,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache){
return (function (m_STAR_,k,p__25989){
var vec__25990 = p__25989;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25990,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25990,(1),null);
var cv = vec__25990;
if(((instant_26054 - udt) > ttl_ms)){
return m_STAR_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR_,k,cv);
}
});})(instant_26054,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m));
});})(instant_26054,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache))
);
} else {
}

var fresh_QMARK_ = (function (){var G__25996 = arg1;
var G__25997 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__25996,G__25997) : taoensso.encore.kw_identical_QMARK_.call(null,G__25996,G__25997));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt();
var vec__25993 = taoensso.encore.swap_val_BANG_(cache,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7277__auto____$1){
var vec__26001 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26001,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26001,(1),null);
return ((instant - udt) < ttl_ms);
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__25980,seq__25981,first__25982,seq__25981__$1,arg1,argn,args,cache))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25993,(0),null);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__26051 = function (var_args){
var p__25979 = null;
if (arguments.length > 0) {
var G__26055__i = 0, G__26055__a = new Array(arguments.length -  0);
while (G__26055__i < G__26055__a.length) {G__26055__a[G__26055__i] = arguments[G__26055__i + 0]; ++G__26055__i;}
  p__25979 = new cljs.core.IndexedSeq(G__26055__a,0);
} 
return G__26051__delegate.call(this,p__25979);};
G__26051.cljs$lang$maxFixedArity = 0;
G__26051.cljs$lang$applyTo = (function (arglist__26056){
var p__25979 = cljs.core.seq(arglist__26056);
return G__26051__delegate(p__25979);
});
G__26051.cljs$core$IFn$_invoke$arity$variadic = G__26051__delegate;
return G__26051;
})()
;
;})(cache))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cache_size;
}),null)),cljs.core.cst$sym$cache_DASH_size,taoensso.encore.pos_int_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_);


var state = (function (){var G__26004 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26004) : cljs.core.atom.call(null,G__26004));
})();
return ((function (state){
return (function() { 
var G__26057__delegate = function (p__26005){
var vec__26006 = p__26005;
var seq__26007 = cljs.core.seq(vec__26006);
var first__26008 = cljs.core.first(seq__26007);
var seq__26007__$1 = cljs.core.next(seq__26007);
var arg1 = first__26008;
var argn = seq__26007__$1;
var args = vec__26006;
if(cljs.core.truth_((function (){var G__26009 = arg1;
var G__26010 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26009,G__26010) : taoensso.encore.kw_identical_QMARK_.call(null,G__26009,G__26010));
})())){
if(cljs.core.truth_((function (){var G__26011 = cljs.core.first(argn);
var G__26012 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26011,G__26012) : taoensso.encore.kw_identical_QMARK_.call(null,G__26011,G__26012));
})())){
var G__26013_26058 = state;
var G__26014_26059 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__26013_26058,G__26014_26059) : cljs.core.reset_BANG_.call(null,G__26013_26058,G__26014_26059));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_26060 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (m){
var m_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,cljs.core.cst$kw$tick);
var m_STAR___$1 = ((cljs.core.not(ttl_ms))?m_STAR_:cljs.core.reduce_kv(((function (m_STAR_,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (m_STAR___$1,k,p__26015){
var vec__26016 = p__26015;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26016,(3),null);
var cv = vec__26016;
if(((instant_26060 - udt) > ttl_ms)){
return m_STAR___$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$1,k,cv);
}
});})(m_STAR_,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m_STAR_)));
var n_to_prune = (cljs.core.count(m_STAR___$1) - cache_size);
var m_STAR___$2 = ((!((n_to_prune > (0))))?m_STAR___$1:cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m_STAR___$1,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (p1__25960_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25960_SHARP_,(1));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n_to_prune,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (p1__25959_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__25959_SHARP_,(0));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (k){
var vec__26019 = (m_STAR___$1.cljs$core$IFn$_invoke$arity$1 ? m_STAR___$1.cljs$core$IFn$_invoke$arity$1(k) : m_STAR___$1.call(null,k));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26019,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26019,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26019,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26019,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(tick_lru + tick_lfu),k], null);
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
,cljs.core.keys(m_STAR___$1)))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$2,cljs.core.cst$kw$tick,cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(m));
});})(instant_26060,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
);
} else {
}

var fresh_QMARK_ = (function (){var G__26025 = arg1;
var G__26026 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__26025,G__26026) : taoensso.encore.kw_identical_QMARK_.call(null,G__26025,G__26026));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var _QMARK_instant = (cljs.core.truth_(ttl_ms)?taoensso.encore.now_udt():null);
var tick_SINGLEQUOTE_ = cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)));
var vec__26022 = taoensso.encore.swap_val_BANG_(state,args__$1,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7277__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7277__auto__)){
var and__7277__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7277__auto____$1){
var or__7289__auto__ = (_QMARK_instant == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
var vec__26036 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26036,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26036,(1),null);
return ((_QMARK_instant - udt) < ttl_ms);
}
} else {
return and__7277__auto____$1;
}
} else {
return and__7277__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
,null)),_QMARK_instant,tick_SINGLEQUOTE_,(1)], null);
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26022,(0),null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26022,dv,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state){
return (function (m){
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,args__$1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__26039 = temp__4657__auto__;
var dv__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26039,(0),null);
var _QMARK_udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26039,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26039,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26039,(3),null);
var cv = vec__26039;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.cst$kw$tick,(tick_SINGLEQUOTE_ + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick_SINGLEQUOTE_,(tick_lfu + (1))], null)])], 0));
} else {
return null;
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__26022,dv,vec__26006,seq__26007,first__26008,seq__26007__$1,arg1,argn,args,state))
);

return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__26057 = function (var_args){
var p__26005 = null;
if (arguments.length > 0) {
var G__26061__i = 0, G__26061__a = new Array(arguments.length -  0);
while (G__26061__i < G__26061__a.length) {G__26061__a[G__26061__i] = arguments[G__26061__i + 0]; ++G__26061__i;}
  p__26005 = new cljs.core.IndexedSeq(G__26061__a,0);
} 
return G__26057__delegate.call(this,p__26005);};
G__26057.cljs$lang$maxFixedArity = 0;
G__26057.cljs$lang$applyTo = (function (arglist__26062){
var p__26005 = cljs.core.seq(arglist__26062);
return G__26057__delegate(p__26005);
});
G__26057.cljs$core$IFn$_invoke$arity$variadic = G__26057__delegate;
return G__26057;
})()
;
;})(state))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_(specs)){
return cljs.core.constantly(null);
} else {
var vspecs = cljs.core.vec(specs);
var vstates_ = (function (){var G__26151 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26151) : cljs.core.atom.call(null,G__26151));
})();
var max_win_ms = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vspecs,vstates_){
return (function (p__26152){
var vec__26153 = p__26152;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26153,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26153,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26153,(2),null);
var spec = vec__26153;
return win_ms;
});})(vspecs,vstates_))
,vspecs));
var nspecs = cljs.core.count(vspecs);
var nid_specs = cljs.core.count(cljs.core.filterv(((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__26156){
var vec__26157 = p__26156;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26157,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26157,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26157,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(nid_specs,nspecs)))?null:(function(){throw (new Error("Assert failed: (or (zero? nid-specs) (= nid-specs nspecs))"))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__26160){
var vec__26200 = p__26160;
var req_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26200,(0),null);
var instant = taoensso.encore.now_udt();
if(cljs.core.truth_((function (){var and__7277__auto__ = req_id;
if(cljs.core.truth_(and__7277__auto__)){
return taoensso.encore.gc_now_QMARK_();
} else {
return and__7277__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
var m__$1 = taoensso.encore.clj1098(m);
return cljs.core.reduce_kv(((function (m__$1,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__26207){
var vec__26208 = p__26207;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26208,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26208,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26208,(2),null);
var x__7625__auto__ = acc;
var y__7626__auto__ = udt;
return ((x__7625__auto__ > y__7626__auto__) ? x__7625__auto__ : y__7626__auto__);
});})(m__$1,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(m__$1,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m__$1,m__$1);
});})(instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not(_QMARK_vstate)){
return taoensso.encore.swapped(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__26211 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__26214 = in_vspecs;
var seq__26215 = cljs.core.seq(vec__26214);
var first__26216 = cljs.core.first(seq__26215);
var seq__26215__$1 = cljs.core.next(seq__26215);
var vec__26217 = first__26216;
var ncalls_limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26217,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26217,(1),null);
var _QMARK_spec_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26217,(2),null);
var next_in_vspecs = seq__26215__$1;
var vec__26220 = in_vstate;
var seq__26221 = cljs.core.seq(vec__26220);
var first__26222 = cljs.core.first(seq__26221);
var seq__26221__$1 = cljs.core.next(seq__26221);
var vec__26223 = first__26222;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26223,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26223,(1),null);
var next_in_vstate = seq__26221__$1;
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__7289__auto__ = (_QMARK_worst_limit_offence == null);
if(or__7289__auto__){
return or__7289__auto__;
} else {
var vec__26229 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26229,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26229,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not(next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__26239 = next_in_vspecs;
var G__26240 = next_in_vstate;
var G__26241 = new_out_vstate;
var G__26242 = new__QMARK_worst_limit_offence;
in_vspecs = G__26239;
in_vstate = G__26240;
out_vstate = G__26241;
_QMARK_worst_limit_offence = G__26242;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26211,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26211,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__26211,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__26232){
var vec__26233 = p__26232;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26233,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26233,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__26211,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__4657__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__4657__auto__)){
var wlo = temp__4657__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__26236 = wlo;
var ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26236,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26236,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped(new_vstate,result);
}
});})(instant,vec__26200,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__26160 = null;
if (arguments.length > 0) {
var G__26243__i = 0, G__26243__a = new Array(arguments.length -  0);
while (G__26243__i < G__26243__a.length) {G__26243__a[G__26243__i] = arguments[G__26243__i + 0]; ++G__26243__i;}
  p__26160 = new cljs.core.IndexedSeq(G__26243__a,0);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__26160);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__26244){
var p__26160 = cljs.core.seq(arglist__26244);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__26160);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_(specs);
return ((function (rl){
return (function() { 
var G__26245__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff = temp__4655__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),null], null);
}
};
var G__26245 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26246__i = 0, G__26246__a = new Array(arguments.length -  0);
while (G__26246__i < G__26246__a.length) {G__26246__a[G__26246__i] = arguments[G__26246__i + 0]; ++G__26246__i;}
  args = new cljs.core.IndexedSeq(G__26246__a,0);
} 
return G__26245__delegate.call(this,args);};
G__26245.cljs$lang$maxFixedArity = 0;
G__26245.cljs$lang$applyTo = (function (arglist__26247){
var args = cljs.core.seq(arglist__26247);
return G__26245__delegate(args);
});
G__26245.cljs$core$IFn$_invoke$arity$variadic = G__26245__delegate;
return G__26245;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__4655__auto__ = (function (){var and__7277__auto__ = typeof window !== 'undefined';
if(and__7277__auto__){
return (window["performance"]);
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var perf = temp__4655__auto__;
var temp__4655__auto____$1 = (function (){var or__7289__auto__ = (perf["now"]);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
var or__7289__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__7289__auto____$1)){
return or__7289__auto____$1;
} else {
var or__7289__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__7289__auto____$2)){
return or__7289__auto____$2;
} else {
var or__7289__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__7289__auto____$3)){
return or__7289__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__4655__auto____$1)){
var f = temp__4655__auto____$1;
return ((function (f,temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return cljs.core.long$((1000000.0 * f.call(perf)));
});
;})(f,temp__4655__auto____$1,perf,temp__4655__auto__))
} else {
return ((function (temp__4655__auto____$1,perf,temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto____$1,perf,temp__4655__auto__))
}
} else {
return ((function (temp__4655__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__4655__auto__))
}
})();
taoensso.encore.qb_min_times = (function taoensso$encore$qb_min_times(times){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,times);
});
taoensso.encore.console_log = (function (){var temp__4655__auto__ = (function (){var and__7277__auto__ = typeof console !== 'undefined';
if(and__7277__auto__){
return console.log;
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var f = temp__4655__auto__;
return ((function (f,temp__4655__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(xs));
});
;})(f,temp__4655__auto__))
} else {
return ((function (temp__4655__auto__){
return (function (xs){
return null;
});
;})(temp__4655__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26259 = arguments.length;
var i__8403__auto___26260 = (0);
while(true){
if((i__8403__auto___26260 < len__8402__auto___26259)){
args__8409__auto__.push((arguments[i__8403__auto___26260]));

var G__26261 = (i__8403__auto___26260 + (1));
i__8403__auto___26260 = G__26261;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(xs) : taoensso.encore.console_log.call(null,xs));
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq26248){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26248));
});


taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26262 = arguments.length;
var i__8403__auto___26263 = (0);
while(true){
if((i__8403__auto___26263 < len__8402__auto___26262)){
args__8409__auto__.push((arguments[i__8403__auto___26263]));

var G__26264 = (i__8403__auto___26263 + (1));
i__8403__auto___26263 = G__26264;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__26250 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str(xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__26250) : taoensso.encore.console_log.call(null,G__26250));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq26249){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26249));
});


taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26265 = arguments.length;
var i__8403__auto___26266 = (0);
while(true){
if((i__8403__auto___26266 < len__8402__auto___26265)){
args__8409__auto__.push((arguments[i__8403__auto___26266]));

var G__26267 = (i__8403__auto___26266 + (1));
i__8403__auto___26266 = G__26267;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__26253 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_(fmt,xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__26253) : taoensso.encore.console_log.call(null,G__26253));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq26251){
var G__26252 = cljs.core.first(seq26251);
var seq26251__$1 = cljs.core.next(seq26251);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__26252,seq26251__$1);
});


taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26268 = arguments.length;
var i__8403__auto___26269 = (0);
while(true){
if((i__8403__auto___26269 < len__8402__auto___26268)){
args__8409__auto__.push((arguments[i__8403__auto___26269]));

var G__26270 = (i__8403__auto___26269 + (1));
i__8403__auto___26269 = G__26270;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((0) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((0)),(0),null)):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__8410__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__26255 = taoensso.encore.spaced_str(xs);
return alert(G__26255);
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq26254){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq26254));
});


taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26271 = arguments.length;
var i__8403__auto___26272 = (0);
while(true){
if((i__8403__auto___26272 < len__8402__auto___26271)){
args__8409__auto__.push((arguments[i__8403__auto___26272]));

var G__26273 = (i__8403__auto___26272 + (1));
i__8403__auto___26272 = G__26273;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__26258 = taoensso.encore.format_STAR_(fmt,xs);
return alert(G__26258);
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq26256){
var G__26257 = cljs.core.first(seq26256);
var seq26256__$1 = cljs.core.next(seq26256);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__26257,seq26256__$1);
});

/**
 * Returns browser window's current location. Forgeable.
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$href,loc_STAR_.href,cljs.core.cst$kw$protocol,loc_STAR_.protocol,cljs.core.cst$kw$hostname,loc_STAR_.hostname,cljs.core.cst$kw$host,loc_STAR_.host,cljs.core.cst$kw$pathname,loc_STAR_.pathname,cljs.core.cst$kw$search,loc_STAR_.search,cljs.core.cst$kw$hash,loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return params;
}),null)),cljs.core.cst$sym$params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] params)"));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_(params))?null:(function (){var s = (function (){var G__26276 = (new goog.structs.Map(cljs.core.clj__GT_js(params)));
return goog.Uri.QueryData.createFromMap(G__26276);
})().toString();
if(clojure.string.blank_QMARK_(s)){
return null;
} else {
return s;
}
})());
var G__26277 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__26277) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__26281,callback){
var map__26312 = p__26281;
var map__26312__$1 = ((((!((map__26312 == null)))?((((map__26312.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__26312.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__26312):map__26312);
var opts = map__26312__$1;
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26312__$1,cljs.core.cst$kw$method,cljs.core.cst$kw$get);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,cljs.core.cst$kw$params);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,cljs.core.cst$kw$headers);
var timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26312__$1,cljs.core.cst$kw$timeout_DASH_ms,(10000));
var resp_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26312__$1,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$auto);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var progress_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__26312__$1,cljs.core.cst$kw$progress_DASH_fn);
var errorf = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__26312__$1,cljs.core.cst$kw$errorf,taoensso.encore.logf);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (){
return timeout_ms;
});})(map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
,null)),cljs.core.cst$sym$timeout_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] timeout-ms)"));
}

var temp__4655__auto__ = taoensso.encore.get_pooled_xhr_BANG_();
if(cljs.core.truth_(temp__4655__auto__)){
var xhr = temp__4655__auto__;
try{var timeout_ms__$1 = (function (){var or__7289__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__26318 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__26318) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys(cljs.core.name,params);
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys(cljs.core.name,headers)], 0));
var vec__26315 = taoensso.encore.coerce_xhr_params(uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26315,(0),null);
var post_content_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26315,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js(((cljs.core.not(post_content_STAR_))?headers__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__26319_26343 = xhr;
var G__26320_26344 = G__26319_26343;
var G__26321_26345 = goog.net.EventType.READY;
var G__26322_26346 = ((function (G__26320_26344,G__26321_26345,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);
});})(G__26320_26344,G__26321_26345,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__26320_26344,G__26321_26345,G__26322_26346);

var G__26323_26347 = G__26319_26343;
var G__26324_26348 = goog.net.EventType.COMPLETE;
var G__26325_26349 = ((function (G__26323_26347,G__26324_26348,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp_type,cljs.core.cst$kw$auto)))?resp_type:(function (){var pred__26331 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__26323_26347,G__26324_26348,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__26280_SHARP_,p2__26279_SHARP_){
return taoensso.encore.str_contains_QMARK_(p2__26279_SHARP_,p1__26280_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__26323_26347,G__26324_26348,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__26332 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__26331("/edn",expr__26332))){
return cljs.core.cst$kw$edn;
} else {
if(cljs.core.truth_(pred__26331("/json",expr__26332))){
return cljs.core.cst$kw$json;
} else {
if(cljs.core.truth_(pred__26331("/xml",expr__26332))){
return cljs.core.cst$kw$xml;
} else {
if(cljs.core.truth_(pred__26331("/html",expr__26332))){
return cljs.core.cst$kw$text;
} else {
return cljs.core.cst$kw$text;
}
}
}
}
})());
try{var G__26335 = (((resp_type__$1 instanceof cljs.core.Keyword))?resp_type__$1.fqn:null);
switch (G__26335) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return cljs.reader.read_string(xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp_type__$1)].join('')));

}
}catch (e26334){if((e26334 instanceof Error)){
var e = e26334;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ajax_SLASH_bad_DASH_response_DASH_type,resp_type__$1,cljs.core.cst$kw$ajax_SLASH_resp_DASH_as_DASH_text,xhr.getResponseText()], null);
} else {
throw e26334;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$raw_DASH_resp,resp,cljs.core.cst$kw$xhr,xhr,cljs.core.cst$kw$success_QMARK_,success_QMARK_,cljs.core.cst$kw$_QMARK_content_DASH_type,(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),cljs.core.cst$kw$_QMARK_content,_QMARK_content,cljs.core.cst$kw$_QMARK_status,_QMARK_http_status,cljs.core.cst$kw$_QMARK_error,(function (){var or__7289__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.createAsIfByAssoc([goog.net.ErrorCode.EXCEPTION,cljs.core.cst$kw$exception,goog.net.ErrorCode.HTTP_ERROR,cljs.core.cst$kw$http_DASH_error,goog.net.ErrorCode.ABORT,cljs.core.cst$kw$abort,goog.net.ErrorCode.TIMEOUT,cljs.core.cst$kw$timeout]),xhr.getLastErrorCode(),cljs.core.cst$kw$unknown));
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null).call(null,_QMARK_http_status)))){
return cljs.core.cst$kw$no_DASH_content;
} else {
return null;
}
}
})()], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(cb_arg) : callback.call(null,cb_arg));
});})(G__26323_26347,G__26324_26348,G__26319_26343,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__26323_26347,G__26324_26348,G__26325_26349);


var temp__4657__auto___26351 = progress_fn;
if(cljs.core.truth_(temp__4657__auto___26351)){
var pf_26352 = temp__4657__auto___26351;
var G__26336_26353 = xhr;
var G__26337_26354 = goog.net.EventType.PROGRESS;
var G__26338_26355 = ((function (G__26336_26353,G__26337_26354,pf_26352,temp__4657__auto___26351,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__7277__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(total,(0));
} else {
return and__7277__auto__;
}
})())?(loaded / total):null);
var G__26339 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$_QMARK_ratio,_QMARK_ratio,cljs.core.cst$kw$length_DASH_computable_QMARK_,length_computable_QMARK_,cljs.core.cst$kw$loaded,loaded,cljs.core.cst$kw$total,total,cljs.core.cst$kw$ev,ev], null);
return (pf_26352.cljs$core$IFn$_invoke$arity$1 ? pf_26352.cljs$core$IFn$_invoke$arity$1(G__26339) : pf_26352.call(null,G__26339));
});})(G__26336_26353,G__26337_26354,pf_26352,temp__4657__auto___26351,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__26315,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__4655__auto__,map__26312,map__26312__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listen(G__26336_26353,G__26337_26354,G__26338_26355);
} else {
}

var G__26340_26356 = xhr;
var temp__4657__auto___26357 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___26357)){
var x_26358 = temp__4657__auto___26357;
G__26340_26356.setTimeoutInterval((function (){var or__7289__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__4657__auto___26359 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__4657__auto___26359)){
var x_26360 = temp__4657__auto___26359;
G__26340_26356.setWithCredentials(true);
} else {
}

var temp__4657__auto___26361 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__4657__auto___26361)){
var x_26362 = temp__4657__auto___26361;
G__26340_26356.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e26314){if((e26314 instanceof Error)){
var e = e26314;
(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);

return null;
} else {
throw e26314;

}
}} else {
var G__26341_26363 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_QMARK_error,cljs.core.cst$kw$xhr_DASH_pool_DASH_depleted], null);
(callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__26341_26363) : callback.call(null,G__26341_26363));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace(clojure.string.replace((function (){var G__26366 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
var G__26367 = s;
return encodeURIComponent(G__26366,G__26367);
})(),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26374 = arguments.length;
var i__8403__auto___26375 = (0);
while(true){
if((i__8403__auto___26375 < len__8402__auto___26374)){
args__8409__auto__.push((arguments[i__8403__auto___26375]));

var G__26376 = (i__8403__auto___26375 + (1));
i__8403__auto___26375 = G__26376;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__26370){
var vec__26371 = p__26370;
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26371,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq26368){
var G__26369 = cljs.core.first(seq26368);
var seq26368__$1 = cljs.core.next(seq26368);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__26369,seq26368__$1);
});

taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(cljs.core.name(k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(v))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_(m)){
return null;
} else {
return join((function (){var iter__8077__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__26395(s__26396){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__26396__$1 = s__26396;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__26396__$1);
if(temp__4657__auto__){
var s__26396__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__26396__$2)){
var c__8075__auto__ = cljs.core.chunk_first(s__26396__$2);
var size__8076__auto__ = cljs.core.count(c__8075__auto__);
var b__26398 = cljs.core.chunk_buffer(size__8076__auto__);
if((function (){var i__26397 = (0);
while(true){
if((i__26397 < size__8076__auto__)){
var vec__26407 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8075__auto__,i__26397);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26407,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26407,(1),null);
cljs.core.chunk_append(b__26398,((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7289__auto__ = cljs.core.seq(v);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)));

var G__26413 = (i__26397 + (1));
i__26397 = G__26413;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__26398),taoensso$encore$format_query_string_$_iter__26395(cljs.core.chunk_rest(s__26396__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__26398),null);
}
} else {
var vec__26410 = cljs.core.first(s__26396__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26410,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26410,(1),null);
return cljs.core.cons(((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7289__auto__ = cljs.core.seq(v);
if(or__7289__auto__){
return or__7289__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)),taoensso$encore$format_query_string_$_iter__26395(cljs.core.rest(s__26396__$2)));
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__8077__auto__(m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var temp__4655__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__4655__auto__)){
var cur = temp__4655__auto__;
if(cljs.core.vector_QMARK_(cur)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`.
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26423 = arguments.length;
var i__8403__auto___26424 = (0);
while(true){
if((i__8403__auto___26424 < len__8402__auto___26423)){
args__8409__auto__.push((arguments[i__8403__auto___26424]));

var G__26425 = (i__8403__auto___26424 + (1));
i__8403__auto___26424 = G__26425;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__26416){
var vec__26417 = p__26416;
var keywordize_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26417,(0),null);
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26417,(1),null);
var _PERCENT_ = ((clojure.string.blank_QMARK_(s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s,"?"))?taoensso.encore.substr(s,(1)):s);
if(cljs.core.not(taoensso.encore.str_contains_QMARK_(s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__$1,vec__26417,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__4655__auto__ = clojure.string.split.cljs$core$IFn$_invoke$arity$3(param,/=/,(2));
if(cljs.core.truth_(temp__4655__auto__)){
var vec__26420 = temp__4655__auto__;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26420,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26420,(1),null);
return taoensso.encore.assoc_conj(m,taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.array_seq([encoding], 0)),taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(v,cljs.core.array_seq([encoding], 0)));
} else {
return m;
}
});})(s__$1,vec__26417,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,/&/));
if(cljs.core.not(keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map(m);
}
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__26417,keywordize_QMARK_,encoding){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__26417,keywordize_QMARK_,encoding))
,null)),cljs.core.cst$sym$_PERCENT_,cljs.core.map_QMARK_,cljs.core.cst$sym$map_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? map? %)"));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq26414){
var G__26415 = cljs.core.first(seq26414);
var seq26414__$1 = cljs.core.next(seq26414);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__26415,seq26414__$1);
});

taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__26429 = clojure.string.split.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26429,(0),null);
var _QMARK_qstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26429,(1),null);
var qmap = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map(taoensso.encore.parse_query_params(_QMARK_qstr)):null),taoensso.encore.keywordize_map(m)], 0));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(url__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__4657__auto__ = taoensso.encore.format_query_string(qmap);
if(cljs.core.truth_(temp__4657__auto__)){
var qstr = temp__4657__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(qstr)].join('');
} else {
return null;
}
})())].join('');
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = (function (){var G__26432 = cljs.core.cst$kw$debug;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__26432) : cljs.core.atom.call(null,G__26432));
})();
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26439 = arguments.length;
var i__8403__auto___26440 = (0);
while(true){
if((i__8403__auto___26440 < len__8402__auto___26439)){
args__8409__auto__.push((arguments[i__8403__auto___26440]));

var G__26441 = (i__8403__auto___26440 + (1));
i__8403__auto___26440 = G__26441;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__26435){
var vec__26436 = p__26435;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26436,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__7289__auto__ = nattempt;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq26433){
var G__26434 = cljs.core.first(seq26433);
var seq26433__$1 = cljs.core.next(seq26433);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__26434,seq26433__$1);
});

taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_(ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_(ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_(ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_(ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2173,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_bool(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_bool,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2174,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_int(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_int,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2175,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_float(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_float,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__26442__delegate = function (args){
var temp__4655__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__4655__auto__)){
var backoff_ms = temp__4655__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$backoff_DASH_ms,backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))], null);
}
};
var G__26442 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__26443__i = 0, G__26443__a = new Array(arguments.length -  0);
while (G__26443__i < G__26443__a.length) {G__26443__a[G__26443__i] = arguments[G__26443__i + 0]; ++G__26443__i;}
  args = new cljs.core.IndexedSeq(G__26443__a,0);
} 
return G__26442__delegate.call(this,args);};
G__26442.cljs$lang$maxFixedArity = 0;
G__26442.cljs$lang$applyTo = (function (arglist__26444){
var args = cljs.core.seq(arglist__26444);
return G__26442__delegate(args);
});
G__26442.cljs$core$IFn$_invoke$arity$variadic = G__26442__delegate;
return G__26442;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = cljs.core.cst$kw$debug;
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$trace,(1),cljs.core.cst$kw$debug,(2),cljs.core.cst$kw$info,(3),cljs.core.cst$kw$warn,(4),cljs.core.cst$kw$error,(5),cljs.core.cst$kw$fatal,(6),cljs.core.cst$kw$report,(7)], null);
return ((function (__GT_n){
return (function (level){
return ((__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(level) : __GT_n.call(null,level)) >= (__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(taoensso.encore._STAR_log_level_STAR_) : __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_)));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26466 = arguments.length;
var i__8403__auto___26467 = (0);
while(true){
if((i__8403__auto___26467 < len__8402__auto___26466)){
args__8409__auto__.push((arguments[i__8403__auto___26467]));

var G__26468 = (i__8403__auto___26467 + (1));
i__8403__auto___26467 = G__26468;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26447 = cljs.core.cst$kw$trace;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26447) : taoensso.encore.log_QMARK_.call(null,G__26447));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq26445){
var G__26446 = cljs.core.first(seq26445);
var seq26445__$1 = cljs.core.next(seq26445);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__26446,seq26445__$1);
});


taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26469 = arguments.length;
var i__8403__auto___26470 = (0);
while(true){
if((i__8403__auto___26470 < len__8402__auto___26469)){
args__8409__auto__.push((arguments[i__8403__auto___26470]));

var G__26471 = (i__8403__auto___26470 + (1));
i__8403__auto___26470 = G__26471;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26450 = cljs.core.cst$kw$debug;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26450) : taoensso.encore.log_QMARK_.call(null,G__26450));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq26448){
var G__26449 = cljs.core.first(seq26448);
var seq26448__$1 = cljs.core.next(seq26448);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__26449,seq26448__$1);
});


taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26472 = arguments.length;
var i__8403__auto___26473 = (0);
while(true){
if((i__8403__auto___26473 < len__8402__auto___26472)){
args__8409__auto__.push((arguments[i__8403__auto___26473]));

var G__26474 = (i__8403__auto___26473 + (1));
i__8403__auto___26473 = G__26474;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26453 = cljs.core.cst$kw$info;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26453) : taoensso.encore.log_QMARK_.call(null,G__26453));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq26451){
var G__26452 = cljs.core.first(seq26451);
var seq26451__$1 = cljs.core.next(seq26451);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__26452,seq26451__$1);
});


taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26475 = arguments.length;
var i__8403__auto___26476 = (0);
while(true){
if((i__8403__auto___26476 < len__8402__auto___26475)){
args__8409__auto__.push((arguments[i__8403__auto___26476]));

var G__26477 = (i__8403__auto___26476 + (1));
i__8403__auto___26476 = G__26477;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26456 = cljs.core.cst$kw$warn;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26456) : taoensso.encore.log_QMARK_.call(null,G__26456));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("WARN: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq26454){
var G__26455 = cljs.core.first(seq26454);
var seq26454__$1 = cljs.core.next(seq26454);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__26455,seq26454__$1);
});


taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26478 = arguments.length;
var i__8403__auto___26479 = (0);
while(true){
if((i__8403__auto___26479 < len__8402__auto___26478)){
args__8409__auto__.push((arguments[i__8403__auto___26479]));

var G__26480 = (i__8403__auto___26479 + (1));
i__8403__auto___26479 = G__26480;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26459 = cljs.core.cst$kw$error;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26459) : taoensso.encore.log_QMARK_.call(null,G__26459));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ERROR: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq26457){
var G__26458 = cljs.core.first(seq26457);
var seq26457__$1 = cljs.core.next(seq26457);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__26458,seq26457__$1);
});


taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26481 = arguments.length;
var i__8403__auto___26482 = (0);
while(true){
if((i__8403__auto___26482 < len__8402__auto___26481)){
args__8409__auto__.push((arguments[i__8403__auto___26482]));

var G__26483 = (i__8403__auto___26482 + (1));
i__8403__auto___26482 = G__26483;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26462 = cljs.core.cst$kw$fatal;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26462) : taoensso.encore.log_QMARK_.call(null,G__26462));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FATAL: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq26460){
var G__26461 = cljs.core.first(seq26460);
var seq26460__$1 = cljs.core.next(seq26460);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__26461,seq26460__$1);
});


taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__8409__auto__ = [];
var len__8402__auto___26484 = arguments.length;
var i__8403__auto___26485 = (0);
while(true){
if((i__8403__auto___26485 < len__8402__auto___26484)){
args__8409__auto__.push((arguments[i__8403__auto___26485]));

var G__26486 = (i__8403__auto___26485 + (1));
i__8403__auto___26485 = G__26486;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__26465 = cljs.core.cst$kw$report;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__26465) : taoensso.encore.log_QMARK_.call(null,G__26465));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq26463){
var G__26464 = cljs.core.first(seq26463);
var seq26463__$1 = cljs.core.next(seq26463);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__26464,seq26463__$1);
});

