// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args15092 = [];
var len__8402__auto___15098 = arguments.length;
var i__8403__auto___15099 = (0);
while(true){
if((i__8403__auto___15099 < len__8402__auto___15098)){
args15092.push((arguments[i__8403__auto___15099]));

var G__15100 = (i__8403__auto___15099 + (1));
i__8403__auto___15099 = G__15100;
continue;
} else {
}
break;
}

var G__15094 = args15092.length;
switch (G__15094) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15092.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async15095 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15095 = (function (f,blockable,meta15096){
this.f = f;
this.blockable = blockable;
this.meta15096 = meta15096;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15097,meta15096__$1){
var self__ = this;
var _15097__$1 = this;
return (new cljs.core.async.t_cljs$core$async15095(self__.f,self__.blockable,meta15096__$1));
});

cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15097){
var self__ = this;
var _15097__$1 = this;
return self__.meta15096;
});

cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async15095.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async15095.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta15096], null);
});

cljs.core.async.t_cljs$core$async15095.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15095.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15095";

cljs.core.async.t_cljs$core$async15095.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15095");
});

cljs.core.async.__GT_t_cljs$core$async15095 = (function cljs$core$async$__GT_t_cljs$core$async15095(f__$1,blockable__$1,meta15096){
return (new cljs.core.async.t_cljs$core$async15095(f__$1,blockable__$1,meta15096));
});

}

return (new cljs.core.async.t_cljs$core$async15095(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args15104 = [];
var len__8402__auto___15107 = arguments.length;
var i__8403__auto___15108 = (0);
while(true){
if((i__8403__auto___15108 < len__8402__auto___15107)){
args15104.push((arguments[i__8403__auto___15108]));

var G__15109 = (i__8403__auto___15108 + (1));
i__8403__auto___15108 = G__15109;
continue;
} else {
}
break;
}

var G__15106 = args15104.length;
switch (G__15106) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15104.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args15111 = [];
var len__8402__auto___15114 = arguments.length;
var i__8403__auto___15115 = (0);
while(true){
if((i__8403__auto___15115 < len__8402__auto___15114)){
args15111.push((arguments[i__8403__auto___15115]));

var G__15116 = (i__8403__auto___15115 + (1));
i__8403__auto___15115 = G__15116;
continue;
} else {
}
break;
}

var G__15113 = args15111.length;
switch (G__15113) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15111.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args15118 = [];
var len__8402__auto___15121 = arguments.length;
var i__8403__auto___15122 = (0);
while(true){
if((i__8403__auto___15122 < len__8402__auto___15121)){
args15118.push((arguments[i__8403__auto___15122]));

var G__15123 = (i__8403__auto___15122 + (1));
i__8403__auto___15122 = G__15123;
continue;
} else {
}
break;
}

var G__15120 = args15118.length;
switch (G__15120) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15118.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_15125 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15125) : fn1.call(null,val_15125));
} else {
cljs.core.async.impl.dispatch.run(((function (val_15125,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_15125) : fn1.call(null,val_15125));
});})(val_15125,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args15126 = [];
var len__8402__auto___15129 = arguments.length;
var i__8403__auto___15130 = (0);
while(true){
if((i__8403__auto___15130 < len__8402__auto___15129)){
args15126.push((arguments[i__8403__auto___15130]));

var G__15131 = (i__8403__auto___15130 + (1));
i__8403__auto___15130 = G__15131;
continue;
} else {
}
break;
}

var G__15128 = args15126.length;
switch (G__15128) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15126.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__8212__auto___15133 = n;
var x_15134 = (0);
while(true){
if((x_15134 < n__8212__auto___15133)){
(a[x_15134] = (0));

var G__15135 = (x_15134 + (1));
x_15134 = G__15135;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__15136 = (i + (1));
i = G__15136;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async15140 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15140 = (function (flag,meta15141){
this.flag = flag;
this.meta15141 = meta15141;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_15142,meta15141__$1){
var self__ = this;
var _15142__$1 = this;
return (new cljs.core.async.t_cljs$core$async15140(self__.flag,meta15141__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_15142){
var self__ = this;
var _15142__$1 = this;
return self__.meta15141;
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta15141], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async15140.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15140.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15140";

cljs.core.async.t_cljs$core$async15140.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15140");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async15140 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async15140(flag__$1,meta15141){
return (new cljs.core.async.t_cljs$core$async15140(flag__$1,meta15141));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async15140(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async15146 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15146 = (function (flag,cb,meta15147){
this.flag = flag;
this.cb = cb;
this.meta15147 = meta15147;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15148,meta15147__$1){
var self__ = this;
var _15148__$1 = this;
return (new cljs.core.async.t_cljs$core$async15146(self__.flag,self__.cb,meta15147__$1));
});

cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15148){
var self__ = this;
var _15148__$1 = this;
return self__.meta15147;
});

cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async15146.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async15146.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta15147], null);
});

cljs.core.async.t_cljs$core$async15146.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async15146.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15146";

cljs.core.async.t_cljs$core$async15146.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async15146");
});

cljs.core.async.__GT_t_cljs$core$async15146 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async15146(flag__$1,cb__$1,meta15147){
return (new cljs.core.async.t_cljs$core$async15146(flag__$1,cb__$1,meta15147));
});

}

return (new cljs.core.async.t_cljs$core$async15146(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15149_SHARP_){
var G__15153 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15149_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15153) : fret.call(null,G__15153));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__15150_SHARP_){
var G__15154 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__15150_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__15154) : fret.call(null,G__15154));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__7289__auto__ = wport;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return port;
}
})()], null));
} else {
var G__15155 = (i + (1));
i = G__15155;
continue;
}
} else {
return null;
}
break;
}
})();
var or__7289__auto__ = ret;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__7277__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__7277__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___15161 = arguments.length;
var i__8403__auto___15162 = (0);
while(true){
if((i__8403__auto___15162 < len__8402__auto___15161)){
args__8409__auto__.push((arguments[i__8403__auto___15162]));

var G__15163 = (i__8403__auto___15162 + (1));
i__8403__auto___15162 = G__15163;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((1) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8410__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__15158){
var map__15159 = p__15158;
var map__15159__$1 = ((((!((map__15159 == null)))?((((map__15159.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15159.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15159):map__15159);
var opts = map__15159__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq15156){
var G__15157 = cljs.core.first(seq15156);
var seq15156__$1 = cljs.core.next(seq15156);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__15157,seq15156__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args15164 = [];
var len__8402__auto___15214 = arguments.length;
var i__8403__auto___15215 = (0);
while(true){
if((i__8403__auto___15215 < len__8402__auto___15214)){
args15164.push((arguments[i__8403__auto___15215]));

var G__15216 = (i__8403__auto___15215 + (1));
i__8403__auto___15215 = G__15216;
continue;
} else {
}
break;
}

var G__15166 = args15164.length;
switch (G__15166) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15164.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__15047__auto___15218 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___15218){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___15218){
return (function (state_15190){
var state_val_15191 = (state_15190[(1)]);
if((state_val_15191 === (7))){
var inst_15186 = (state_15190[(2)]);
var state_15190__$1 = state_15190;
var statearr_15192_15219 = state_15190__$1;
(statearr_15192_15219[(2)] = inst_15186);

(statearr_15192_15219[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (1))){
var state_15190__$1 = state_15190;
var statearr_15193_15220 = state_15190__$1;
(statearr_15193_15220[(2)] = null);

(statearr_15193_15220[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (4))){
var inst_15169 = (state_15190[(7)]);
var inst_15169__$1 = (state_15190[(2)]);
var inst_15170 = (inst_15169__$1 == null);
var state_15190__$1 = (function (){var statearr_15194 = state_15190;
(statearr_15194[(7)] = inst_15169__$1);

return statearr_15194;
})();
if(cljs.core.truth_(inst_15170)){
var statearr_15195_15221 = state_15190__$1;
(statearr_15195_15221[(1)] = (5));

} else {
var statearr_15196_15222 = state_15190__$1;
(statearr_15196_15222[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (13))){
var state_15190__$1 = state_15190;
var statearr_15197_15223 = state_15190__$1;
(statearr_15197_15223[(2)] = null);

(statearr_15197_15223[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (6))){
var inst_15169 = (state_15190[(7)]);
var state_15190__$1 = state_15190;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15190__$1,(11),to,inst_15169);
} else {
if((state_val_15191 === (3))){
var inst_15188 = (state_15190[(2)]);
var state_15190__$1 = state_15190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15190__$1,inst_15188);
} else {
if((state_val_15191 === (12))){
var state_15190__$1 = state_15190;
var statearr_15198_15224 = state_15190__$1;
(statearr_15198_15224[(2)] = null);

(statearr_15198_15224[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (2))){
var state_15190__$1 = state_15190;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15190__$1,(4),from);
} else {
if((state_val_15191 === (11))){
var inst_15179 = (state_15190[(2)]);
var state_15190__$1 = state_15190;
if(cljs.core.truth_(inst_15179)){
var statearr_15199_15225 = state_15190__$1;
(statearr_15199_15225[(1)] = (12));

} else {
var statearr_15200_15226 = state_15190__$1;
(statearr_15200_15226[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (9))){
var state_15190__$1 = state_15190;
var statearr_15201_15227 = state_15190__$1;
(statearr_15201_15227[(2)] = null);

(statearr_15201_15227[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (5))){
var state_15190__$1 = state_15190;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15202_15228 = state_15190__$1;
(statearr_15202_15228[(1)] = (8));

} else {
var statearr_15203_15229 = state_15190__$1;
(statearr_15203_15229[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (14))){
var inst_15184 = (state_15190[(2)]);
var state_15190__$1 = state_15190;
var statearr_15204_15230 = state_15190__$1;
(statearr_15204_15230[(2)] = inst_15184);

(statearr_15204_15230[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (10))){
var inst_15176 = (state_15190[(2)]);
var state_15190__$1 = state_15190;
var statearr_15205_15231 = state_15190__$1;
(statearr_15205_15231[(2)] = inst_15176);

(statearr_15205_15231[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15191 === (8))){
var inst_15173 = cljs.core.async.close_BANG_(to);
var state_15190__$1 = state_15190;
var statearr_15206_15232 = state_15190__$1;
(statearr_15206_15232[(2)] = inst_15173);

(statearr_15206_15232[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___15218))
;
return ((function (switch__14923__auto__,c__15047__auto___15218){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_15210 = [null,null,null,null,null,null,null,null];
(statearr_15210[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_15210[(1)] = (1));

return statearr_15210;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_15190){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15190);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15211){if((e15211 instanceof Object)){
var ex__14927__auto__ = e15211;
var statearr_15212_15233 = state_15190;
(statearr_15212_15233[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15190);

return cljs.core.cst$kw$recur;
} else {
throw e15211;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15234 = state_15190;
state_15190 = G__15234;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_15190){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_15190);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___15218))
})();
var state__15049__auto__ = (function (){var statearr_15213 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15213[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15218);

return statearr_15213;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___15218))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__15422){
var vec__15423 = p__15422;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15423,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15423,(1),null);
var job = vec__15423;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__15047__auto___15609 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results){
return (function (state_15430){
var state_val_15431 = (state_15430[(1)]);
if((state_val_15431 === (1))){
var state_15430__$1 = state_15430;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15430__$1,(2),res,v);
} else {
if((state_val_15431 === (2))){
var inst_15427 = (state_15430[(2)]);
var inst_15428 = cljs.core.async.close_BANG_(res);
var state_15430__$1 = (function (){var statearr_15432 = state_15430;
(statearr_15432[(7)] = inst_15427);

return statearr_15432;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15430__$1,inst_15428);
} else {
return null;
}
}
});})(c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results))
;
return ((function (switch__14923__auto__,c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_15436 = [null,null,null,null,null,null,null,null];
(statearr_15436[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__);

(statearr_15436[(1)] = (1));

return statearr_15436;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1 = (function (state_15430){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15430);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15437){if((e15437 instanceof Object)){
var ex__14927__auto__ = e15437;
var statearr_15438_15610 = state_15430;
(statearr_15438_15610[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15430);

return cljs.core.cst$kw$recur;
} else {
throw e15437;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15611 = state_15430;
state_15430 = G__15611;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = function(state_15430){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1.call(this,state_15430);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results))
})();
var state__15049__auto__ = (function (){var statearr_15439 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15439[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15609);

return statearr_15439;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___15609,res,vec__15423,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__15440){
var vec__15441 = p__15440;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15441,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15441,(1),null);
var job = vec__15441;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__8212__auto___15612 = n;
var __15613 = (0);
while(true){
if((__15613 < n__8212__auto___15612)){
var G__15444_15614 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__15444_15614) {
case "compute":
var c__15047__auto___15616 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15613,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (__15613,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function (state_15457){
var state_val_15458 = (state_15457[(1)]);
if((state_val_15458 === (1))){
var state_15457__$1 = state_15457;
var statearr_15459_15617 = state_15457__$1;
(statearr_15459_15617[(2)] = null);

(statearr_15459_15617[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15458 === (2))){
var state_15457__$1 = state_15457;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15457__$1,(4),jobs);
} else {
if((state_val_15458 === (3))){
var inst_15455 = (state_15457[(2)]);
var state_15457__$1 = state_15457;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15457__$1,inst_15455);
} else {
if((state_val_15458 === (4))){
var inst_15447 = (state_15457[(2)]);
var inst_15448 = process(inst_15447);
var state_15457__$1 = state_15457;
if(cljs.core.truth_(inst_15448)){
var statearr_15460_15618 = state_15457__$1;
(statearr_15460_15618[(1)] = (5));

} else {
var statearr_15461_15619 = state_15457__$1;
(statearr_15461_15619[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15458 === (5))){
var state_15457__$1 = state_15457;
var statearr_15462_15620 = state_15457__$1;
(statearr_15462_15620[(2)] = null);

(statearr_15462_15620[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15458 === (6))){
var state_15457__$1 = state_15457;
var statearr_15463_15621 = state_15457__$1;
(statearr_15463_15621[(2)] = null);

(statearr_15463_15621[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15458 === (7))){
var inst_15453 = (state_15457[(2)]);
var state_15457__$1 = state_15457;
var statearr_15464_15622 = state_15457__$1;
(statearr_15464_15622[(2)] = inst_15453);

(statearr_15464_15622[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15613,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
;
return ((function (__15613,switch__14923__auto__,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_15468 = [null,null,null,null,null,null,null];
(statearr_15468[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__);

(statearr_15468[(1)] = (1));

return statearr_15468;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1 = (function (state_15457){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15457);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15469){if((e15469 instanceof Object)){
var ex__14927__auto__ = e15469;
var statearr_15470_15623 = state_15457;
(statearr_15470_15623[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15457);

return cljs.core.cst$kw$recur;
} else {
throw e15469;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15624 = state_15457;
state_15457 = G__15624;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = function(state_15457){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1.call(this,state_15457);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__;
})()
;})(__15613,switch__14923__auto__,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
})();
var state__15049__auto__ = (function (){var statearr_15471 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15471[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15616);

return statearr_15471;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(__15613,c__15047__auto___15616,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
);


break;
case "async":
var c__15047__auto___15625 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__15613,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (__15613,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function (state_15484){
var state_val_15485 = (state_15484[(1)]);
if((state_val_15485 === (1))){
var state_15484__$1 = state_15484;
var statearr_15486_15626 = state_15484__$1;
(statearr_15486_15626[(2)] = null);

(statearr_15486_15626[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15485 === (2))){
var state_15484__$1 = state_15484;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15484__$1,(4),jobs);
} else {
if((state_val_15485 === (3))){
var inst_15482 = (state_15484[(2)]);
var state_15484__$1 = state_15484;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15484__$1,inst_15482);
} else {
if((state_val_15485 === (4))){
var inst_15474 = (state_15484[(2)]);
var inst_15475 = async(inst_15474);
var state_15484__$1 = state_15484;
if(cljs.core.truth_(inst_15475)){
var statearr_15487_15627 = state_15484__$1;
(statearr_15487_15627[(1)] = (5));

} else {
var statearr_15488_15628 = state_15484__$1;
(statearr_15488_15628[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15485 === (5))){
var state_15484__$1 = state_15484;
var statearr_15489_15629 = state_15484__$1;
(statearr_15489_15629[(2)] = null);

(statearr_15489_15629[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15485 === (6))){
var state_15484__$1 = state_15484;
var statearr_15490_15630 = state_15484__$1;
(statearr_15490_15630[(2)] = null);

(statearr_15490_15630[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15485 === (7))){
var inst_15480 = (state_15484[(2)]);
var state_15484__$1 = state_15484;
var statearr_15491_15631 = state_15484__$1;
(statearr_15491_15631[(2)] = inst_15480);

(statearr_15491_15631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__15613,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
;
return ((function (__15613,switch__14923__auto__,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_15495 = [null,null,null,null,null,null,null];
(statearr_15495[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__);

(statearr_15495[(1)] = (1));

return statearr_15495;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1 = (function (state_15484){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15484);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15496){if((e15496 instanceof Object)){
var ex__14927__auto__ = e15496;
var statearr_15497_15632 = state_15484;
(statearr_15497_15632[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15484);

return cljs.core.cst$kw$recur;
} else {
throw e15496;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15633 = state_15484;
state_15484 = G__15633;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = function(state_15484){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1.call(this,state_15484);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__;
})()
;})(__15613,switch__14923__auto__,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
})();
var state__15049__auto__ = (function (){var statearr_15498 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15498[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15625);

return statearr_15498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(__15613,c__15047__auto___15625,G__15444_15614,n__8212__auto___15612,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__15634 = (__15613 + (1));
__15613 = G__15634;
continue;
} else {
}
break;
}

var c__15047__auto___15635 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___15635,jobs,results,process,async){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___15635,jobs,results,process,async){
return (function (state_15520){
var state_val_15521 = (state_15520[(1)]);
if((state_val_15521 === (1))){
var state_15520__$1 = state_15520;
var statearr_15522_15636 = state_15520__$1;
(statearr_15522_15636[(2)] = null);

(statearr_15522_15636[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15521 === (2))){
var state_15520__$1 = state_15520;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15520__$1,(4),from);
} else {
if((state_val_15521 === (3))){
var inst_15518 = (state_15520[(2)]);
var state_15520__$1 = state_15520;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15520__$1,inst_15518);
} else {
if((state_val_15521 === (4))){
var inst_15501 = (state_15520[(7)]);
var inst_15501__$1 = (state_15520[(2)]);
var inst_15502 = (inst_15501__$1 == null);
var state_15520__$1 = (function (){var statearr_15523 = state_15520;
(statearr_15523[(7)] = inst_15501__$1);

return statearr_15523;
})();
if(cljs.core.truth_(inst_15502)){
var statearr_15524_15637 = state_15520__$1;
(statearr_15524_15637[(1)] = (5));

} else {
var statearr_15525_15638 = state_15520__$1;
(statearr_15525_15638[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15521 === (5))){
var inst_15504 = cljs.core.async.close_BANG_(jobs);
var state_15520__$1 = state_15520;
var statearr_15526_15639 = state_15520__$1;
(statearr_15526_15639[(2)] = inst_15504);

(statearr_15526_15639[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15521 === (6))){
var inst_15506 = (state_15520[(8)]);
var inst_15501 = (state_15520[(7)]);
var inst_15506__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_15507 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15508 = [inst_15501,inst_15506__$1];
var inst_15509 = (new cljs.core.PersistentVector(null,2,(5),inst_15507,inst_15508,null));
var state_15520__$1 = (function (){var statearr_15527 = state_15520;
(statearr_15527[(8)] = inst_15506__$1);

return statearr_15527;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15520__$1,(8),jobs,inst_15509);
} else {
if((state_val_15521 === (7))){
var inst_15516 = (state_15520[(2)]);
var state_15520__$1 = state_15520;
var statearr_15528_15640 = state_15520__$1;
(statearr_15528_15640[(2)] = inst_15516);

(statearr_15528_15640[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15521 === (8))){
var inst_15506 = (state_15520[(8)]);
var inst_15511 = (state_15520[(2)]);
var state_15520__$1 = (function (){var statearr_15529 = state_15520;
(statearr_15529[(9)] = inst_15511);

return statearr_15529;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15520__$1,(9),results,inst_15506);
} else {
if((state_val_15521 === (9))){
var inst_15513 = (state_15520[(2)]);
var state_15520__$1 = (function (){var statearr_15530 = state_15520;
(statearr_15530[(10)] = inst_15513);

return statearr_15530;
})();
var statearr_15531_15641 = state_15520__$1;
(statearr_15531_15641[(2)] = null);

(statearr_15531_15641[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___15635,jobs,results,process,async))
;
return ((function (switch__14923__auto__,c__15047__auto___15635,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_15535 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15535[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__);

(statearr_15535[(1)] = (1));

return statearr_15535;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1 = (function (state_15520){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15520);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15536){if((e15536 instanceof Object)){
var ex__14927__auto__ = e15536;
var statearr_15537_15642 = state_15520;
(statearr_15537_15642[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15520);

return cljs.core.cst$kw$recur;
} else {
throw e15536;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15643 = state_15520;
state_15520 = G__15643;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = function(state_15520){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1.call(this,state_15520);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___15635,jobs,results,process,async))
})();
var state__15049__auto__ = (function (){var statearr_15538 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15538[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15635);

return statearr_15538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___15635,jobs,results,process,async))
);


var c__15047__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto__,jobs,results,process,async){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto__,jobs,results,process,async){
return (function (state_15576){
var state_val_15577 = (state_15576[(1)]);
if((state_val_15577 === (7))){
var inst_15572 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
var statearr_15578_15644 = state_15576__$1;
(statearr_15578_15644[(2)] = inst_15572);

(statearr_15578_15644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (20))){
var state_15576__$1 = state_15576;
var statearr_15579_15645 = state_15576__$1;
(statearr_15579_15645[(2)] = null);

(statearr_15579_15645[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (1))){
var state_15576__$1 = state_15576;
var statearr_15580_15646 = state_15576__$1;
(statearr_15580_15646[(2)] = null);

(statearr_15580_15646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (4))){
var inst_15541 = (state_15576[(7)]);
var inst_15541__$1 = (state_15576[(2)]);
var inst_15542 = (inst_15541__$1 == null);
var state_15576__$1 = (function (){var statearr_15581 = state_15576;
(statearr_15581[(7)] = inst_15541__$1);

return statearr_15581;
})();
if(cljs.core.truth_(inst_15542)){
var statearr_15582_15647 = state_15576__$1;
(statearr_15582_15647[(1)] = (5));

} else {
var statearr_15583_15648 = state_15576__$1;
(statearr_15583_15648[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (15))){
var inst_15554 = (state_15576[(8)]);
var state_15576__$1 = state_15576;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15576__$1,(18),to,inst_15554);
} else {
if((state_val_15577 === (21))){
var inst_15567 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
var statearr_15584_15649 = state_15576__$1;
(statearr_15584_15649[(2)] = inst_15567);

(statearr_15584_15649[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (13))){
var inst_15569 = (state_15576[(2)]);
var state_15576__$1 = (function (){var statearr_15585 = state_15576;
(statearr_15585[(9)] = inst_15569);

return statearr_15585;
})();
var statearr_15586_15650 = state_15576__$1;
(statearr_15586_15650[(2)] = null);

(statearr_15586_15650[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (6))){
var inst_15541 = (state_15576[(7)]);
var state_15576__$1 = state_15576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15576__$1,(11),inst_15541);
} else {
if((state_val_15577 === (17))){
var inst_15562 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
if(cljs.core.truth_(inst_15562)){
var statearr_15587_15651 = state_15576__$1;
(statearr_15587_15651[(1)] = (19));

} else {
var statearr_15588_15652 = state_15576__$1;
(statearr_15588_15652[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (3))){
var inst_15574 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15576__$1,inst_15574);
} else {
if((state_val_15577 === (12))){
var inst_15551 = (state_15576[(10)]);
var state_15576__$1 = state_15576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15576__$1,(14),inst_15551);
} else {
if((state_val_15577 === (2))){
var state_15576__$1 = state_15576;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15576__$1,(4),results);
} else {
if((state_val_15577 === (19))){
var state_15576__$1 = state_15576;
var statearr_15589_15653 = state_15576__$1;
(statearr_15589_15653[(2)] = null);

(statearr_15589_15653[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (11))){
var inst_15551 = (state_15576[(2)]);
var state_15576__$1 = (function (){var statearr_15590 = state_15576;
(statearr_15590[(10)] = inst_15551);

return statearr_15590;
})();
var statearr_15591_15654 = state_15576__$1;
(statearr_15591_15654[(2)] = null);

(statearr_15591_15654[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (9))){
var state_15576__$1 = state_15576;
var statearr_15592_15655 = state_15576__$1;
(statearr_15592_15655[(2)] = null);

(statearr_15592_15655[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (5))){
var state_15576__$1 = state_15576;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15593_15656 = state_15576__$1;
(statearr_15593_15656[(1)] = (8));

} else {
var statearr_15594_15657 = state_15576__$1;
(statearr_15594_15657[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (14))){
var inst_15556 = (state_15576[(11)]);
var inst_15554 = (state_15576[(8)]);
var inst_15554__$1 = (state_15576[(2)]);
var inst_15555 = (inst_15554__$1 == null);
var inst_15556__$1 = cljs.core.not(inst_15555);
var state_15576__$1 = (function (){var statearr_15595 = state_15576;
(statearr_15595[(11)] = inst_15556__$1);

(statearr_15595[(8)] = inst_15554__$1);

return statearr_15595;
})();
if(inst_15556__$1){
var statearr_15596_15658 = state_15576__$1;
(statearr_15596_15658[(1)] = (15));

} else {
var statearr_15597_15659 = state_15576__$1;
(statearr_15597_15659[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (16))){
var inst_15556 = (state_15576[(11)]);
var state_15576__$1 = state_15576;
var statearr_15598_15660 = state_15576__$1;
(statearr_15598_15660[(2)] = inst_15556);

(statearr_15598_15660[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (10))){
var inst_15548 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
var statearr_15599_15661 = state_15576__$1;
(statearr_15599_15661[(2)] = inst_15548);

(statearr_15599_15661[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (18))){
var inst_15559 = (state_15576[(2)]);
var state_15576__$1 = state_15576;
var statearr_15600_15662 = state_15576__$1;
(statearr_15600_15662[(2)] = inst_15559);

(statearr_15600_15662[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15577 === (8))){
var inst_15545 = cljs.core.async.close_BANG_(to);
var state_15576__$1 = state_15576;
var statearr_15601_15663 = state_15576__$1;
(statearr_15601_15663[(2)] = inst_15545);

(statearr_15601_15663[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto__,jobs,results,process,async))
;
return ((function (switch__14923__auto__,c__15047__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_15605 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15605[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__);

(statearr_15605[(1)] = (1));

return statearr_15605;
});
var cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1 = (function (state_15576){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15576);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15606){if((e15606 instanceof Object)){
var ex__14927__auto__ = e15606;
var statearr_15607_15664 = state_15576;
(statearr_15607_15664[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15576);

return cljs.core.cst$kw$recur;
} else {
throw e15606;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15665 = state_15576;
state_15576 = G__15665;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__ = function(state_15576){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1.call(this,state_15576);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto__,jobs,results,process,async))
})();
var state__15049__auto__ = (function (){var statearr_15608 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15608[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto__);

return statearr_15608;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto__,jobs,results,process,async))
);

return c__15047__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args15666 = [];
var len__8402__auto___15669 = arguments.length;
var i__8403__auto___15670 = (0);
while(true){
if((i__8403__auto___15670 < len__8402__auto___15669)){
args15666.push((arguments[i__8403__auto___15670]));

var G__15671 = (i__8403__auto___15670 + (1));
i__8403__auto___15670 = G__15671;
continue;
} else {
}
break;
}

var G__15668 = args15666.length;
switch (G__15668) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15666.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args15673 = [];
var len__8402__auto___15676 = arguments.length;
var i__8403__auto___15677 = (0);
while(true){
if((i__8403__auto___15677 < len__8402__auto___15676)){
args15673.push((arguments[i__8403__auto___15677]));

var G__15678 = (i__8403__auto___15677 + (1));
i__8403__auto___15677 = G__15678;
continue;
} else {
}
break;
}

var G__15675 = args15673.length;
switch (G__15675) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15673.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args15680 = [];
var len__8402__auto___15733 = arguments.length;
var i__8403__auto___15734 = (0);
while(true){
if((i__8403__auto___15734 < len__8402__auto___15733)){
args15680.push((arguments[i__8403__auto___15734]));

var G__15735 = (i__8403__auto___15734 + (1));
i__8403__auto___15734 = G__15735;
continue;
} else {
}
break;
}

var G__15682 = args15680.length;
switch (G__15682) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15680.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__15047__auto___15737 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___15737,tc,fc){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___15737,tc,fc){
return (function (state_15708){
var state_val_15709 = (state_15708[(1)]);
if((state_val_15709 === (7))){
var inst_15704 = (state_15708[(2)]);
var state_15708__$1 = state_15708;
var statearr_15710_15738 = state_15708__$1;
(statearr_15710_15738[(2)] = inst_15704);

(statearr_15710_15738[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (1))){
var state_15708__$1 = state_15708;
var statearr_15711_15739 = state_15708__$1;
(statearr_15711_15739[(2)] = null);

(statearr_15711_15739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (4))){
var inst_15685 = (state_15708[(7)]);
var inst_15685__$1 = (state_15708[(2)]);
var inst_15686 = (inst_15685__$1 == null);
var state_15708__$1 = (function (){var statearr_15712 = state_15708;
(statearr_15712[(7)] = inst_15685__$1);

return statearr_15712;
})();
if(cljs.core.truth_(inst_15686)){
var statearr_15713_15740 = state_15708__$1;
(statearr_15713_15740[(1)] = (5));

} else {
var statearr_15714_15741 = state_15708__$1;
(statearr_15714_15741[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (13))){
var state_15708__$1 = state_15708;
var statearr_15715_15742 = state_15708__$1;
(statearr_15715_15742[(2)] = null);

(statearr_15715_15742[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (6))){
var inst_15685 = (state_15708[(7)]);
var inst_15691 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15685) : p.call(null,inst_15685));
var state_15708__$1 = state_15708;
if(cljs.core.truth_(inst_15691)){
var statearr_15716_15743 = state_15708__$1;
(statearr_15716_15743[(1)] = (9));

} else {
var statearr_15717_15744 = state_15708__$1;
(statearr_15717_15744[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (3))){
var inst_15706 = (state_15708[(2)]);
var state_15708__$1 = state_15708;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15708__$1,inst_15706);
} else {
if((state_val_15709 === (12))){
var state_15708__$1 = state_15708;
var statearr_15718_15745 = state_15708__$1;
(statearr_15718_15745[(2)] = null);

(statearr_15718_15745[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (2))){
var state_15708__$1 = state_15708;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15708__$1,(4),ch);
} else {
if((state_val_15709 === (11))){
var inst_15685 = (state_15708[(7)]);
var inst_15695 = (state_15708[(2)]);
var state_15708__$1 = state_15708;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15708__$1,(8),inst_15695,inst_15685);
} else {
if((state_val_15709 === (9))){
var state_15708__$1 = state_15708;
var statearr_15719_15746 = state_15708__$1;
(statearr_15719_15746[(2)] = tc);

(statearr_15719_15746[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (5))){
var inst_15688 = cljs.core.async.close_BANG_(tc);
var inst_15689 = cljs.core.async.close_BANG_(fc);
var state_15708__$1 = (function (){var statearr_15720 = state_15708;
(statearr_15720[(8)] = inst_15688);

return statearr_15720;
})();
var statearr_15721_15747 = state_15708__$1;
(statearr_15721_15747[(2)] = inst_15689);

(statearr_15721_15747[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (14))){
var inst_15702 = (state_15708[(2)]);
var state_15708__$1 = state_15708;
var statearr_15722_15748 = state_15708__$1;
(statearr_15722_15748[(2)] = inst_15702);

(statearr_15722_15748[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (10))){
var state_15708__$1 = state_15708;
var statearr_15723_15749 = state_15708__$1;
(statearr_15723_15749[(2)] = fc);

(statearr_15723_15749[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15709 === (8))){
var inst_15697 = (state_15708[(2)]);
var state_15708__$1 = state_15708;
if(cljs.core.truth_(inst_15697)){
var statearr_15724_15750 = state_15708__$1;
(statearr_15724_15750[(1)] = (12));

} else {
var statearr_15725_15751 = state_15708__$1;
(statearr_15725_15751[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___15737,tc,fc))
;
return ((function (switch__14923__auto__,c__15047__auto___15737,tc,fc){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_15729 = [null,null,null,null,null,null,null,null,null];
(statearr_15729[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_15729[(1)] = (1));

return statearr_15729;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_15708){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15708);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15730){if((e15730 instanceof Object)){
var ex__14927__auto__ = e15730;
var statearr_15731_15752 = state_15708;
(statearr_15731_15752[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15708);

return cljs.core.cst$kw$recur;
} else {
throw e15730;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15753 = state_15708;
state_15708 = G__15753;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_15708){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_15708);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___15737,tc,fc))
})();
var state__15049__auto__ = (function (){var statearr_15732 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15732[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___15737);

return statearr_15732;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___15737,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__15047__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto__){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto__){
return (function (state_15817){
var state_val_15818 = (state_15817[(1)]);
if((state_val_15818 === (7))){
var inst_15813 = (state_15817[(2)]);
var state_15817__$1 = state_15817;
var statearr_15819_15840 = state_15817__$1;
(statearr_15819_15840[(2)] = inst_15813);

(statearr_15819_15840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (1))){
var inst_15797 = init;
var state_15817__$1 = (function (){var statearr_15820 = state_15817;
(statearr_15820[(7)] = inst_15797);

return statearr_15820;
})();
var statearr_15821_15841 = state_15817__$1;
(statearr_15821_15841[(2)] = null);

(statearr_15821_15841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (4))){
var inst_15800 = (state_15817[(8)]);
var inst_15800__$1 = (state_15817[(2)]);
var inst_15801 = (inst_15800__$1 == null);
var state_15817__$1 = (function (){var statearr_15822 = state_15817;
(statearr_15822[(8)] = inst_15800__$1);

return statearr_15822;
})();
if(cljs.core.truth_(inst_15801)){
var statearr_15823_15842 = state_15817__$1;
(statearr_15823_15842[(1)] = (5));

} else {
var statearr_15824_15843 = state_15817__$1;
(statearr_15824_15843[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (6))){
var inst_15804 = (state_15817[(9)]);
var inst_15800 = (state_15817[(8)]);
var inst_15797 = (state_15817[(7)]);
var inst_15804__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_15797,inst_15800) : f.call(null,inst_15797,inst_15800));
var inst_15805 = cljs.core.reduced_QMARK_(inst_15804__$1);
var state_15817__$1 = (function (){var statearr_15825 = state_15817;
(statearr_15825[(9)] = inst_15804__$1);

return statearr_15825;
})();
if(inst_15805){
var statearr_15826_15844 = state_15817__$1;
(statearr_15826_15844[(1)] = (8));

} else {
var statearr_15827_15845 = state_15817__$1;
(statearr_15827_15845[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (3))){
var inst_15815 = (state_15817[(2)]);
var state_15817__$1 = state_15817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15817__$1,inst_15815);
} else {
if((state_val_15818 === (2))){
var state_15817__$1 = state_15817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15817__$1,(4),ch);
} else {
if((state_val_15818 === (9))){
var inst_15804 = (state_15817[(9)]);
var inst_15797 = inst_15804;
var state_15817__$1 = (function (){var statearr_15828 = state_15817;
(statearr_15828[(7)] = inst_15797);

return statearr_15828;
})();
var statearr_15829_15846 = state_15817__$1;
(statearr_15829_15846[(2)] = null);

(statearr_15829_15846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (5))){
var inst_15797 = (state_15817[(7)]);
var state_15817__$1 = state_15817;
var statearr_15830_15847 = state_15817__$1;
(statearr_15830_15847[(2)] = inst_15797);

(statearr_15830_15847[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (10))){
var inst_15811 = (state_15817[(2)]);
var state_15817__$1 = state_15817;
var statearr_15831_15848 = state_15817__$1;
(statearr_15831_15848[(2)] = inst_15811);

(statearr_15831_15848[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15818 === (8))){
var inst_15804 = (state_15817[(9)]);
var inst_15807 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_15804) : cljs.core.deref.call(null,inst_15804));
var state_15817__$1 = state_15817;
var statearr_15832_15849 = state_15817__$1;
(statearr_15832_15849[(2)] = inst_15807);

(statearr_15832_15849[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto__))
;
return ((function (switch__14923__auto__,c__15047__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__14924__auto__ = null;
var cljs$core$async$reduce_$_state_machine__14924__auto____0 = (function (){
var statearr_15836 = [null,null,null,null,null,null,null,null,null,null];
(statearr_15836[(0)] = cljs$core$async$reduce_$_state_machine__14924__auto__);

(statearr_15836[(1)] = (1));

return statearr_15836;
});
var cljs$core$async$reduce_$_state_machine__14924__auto____1 = (function (state_15817){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15817);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15837){if((e15837 instanceof Object)){
var ex__14927__auto__ = e15837;
var statearr_15838_15850 = state_15817;
(statearr_15838_15850[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15817);

return cljs.core.cst$kw$recur;
} else {
throw e15837;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15851 = state_15817;
state_15817 = G__15851;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__14924__auto__ = function(state_15817){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__14924__auto____1.call(this,state_15817);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__14924__auto____0;
cljs$core$async$reduce_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__14924__auto____1;
return cljs$core$async$reduce_$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto__))
})();
var state__15049__auto__ = (function (){var statearr_15839 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15839[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto__);

return statearr_15839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto__))
);

return c__15047__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__15047__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto__,f__$1){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto__,f__$1){
return (function (state_15871){
var state_val_15872 = (state_15871[(1)]);
if((state_val_15872 === (1))){
var inst_15866 = cljs.core.async.reduce(f__$1,init,ch);
var state_15871__$1 = state_15871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15871__$1,(2),inst_15866);
} else {
if((state_val_15872 === (2))){
var inst_15868 = (state_15871[(2)]);
var inst_15869 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_15868) : f__$1.call(null,inst_15868));
var state_15871__$1 = state_15871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15871__$1,inst_15869);
} else {
return null;
}
}
});})(c__15047__auto__,f__$1))
;
return ((function (switch__14923__auto__,c__15047__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__14924__auto__ = null;
var cljs$core$async$transduce_$_state_machine__14924__auto____0 = (function (){
var statearr_15876 = [null,null,null,null,null,null,null];
(statearr_15876[(0)] = cljs$core$async$transduce_$_state_machine__14924__auto__);

(statearr_15876[(1)] = (1));

return statearr_15876;
});
var cljs$core$async$transduce_$_state_machine__14924__auto____1 = (function (state_15871){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15871);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15877){if((e15877 instanceof Object)){
var ex__14927__auto__ = e15877;
var statearr_15878_15880 = state_15871;
(statearr_15878_15880[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15871);

return cljs.core.cst$kw$recur;
} else {
throw e15877;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15881 = state_15871;
state_15871 = G__15881;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__14924__auto__ = function(state_15871){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__14924__auto____1.call(this,state_15871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__14924__auto____0;
cljs$core$async$transduce_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__14924__auto____1;
return cljs$core$async$transduce_$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto__,f__$1))
})();
var state__15049__auto__ = (function (){var statearr_15879 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15879[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto__);

return statearr_15879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto__,f__$1))
);

return c__15047__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args15882 = [];
var len__8402__auto___15934 = arguments.length;
var i__8403__auto___15935 = (0);
while(true){
if((i__8403__auto___15935 < len__8402__auto___15934)){
args15882.push((arguments[i__8403__auto___15935]));

var G__15936 = (i__8403__auto___15935 + (1));
i__8403__auto___15935 = G__15936;
continue;
} else {
}
break;
}

var G__15884 = args15882.length;
switch (G__15884) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args15882.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__15047__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto__){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto__){
return (function (state_15909){
var state_val_15910 = (state_15909[(1)]);
if((state_val_15910 === (7))){
var inst_15891 = (state_15909[(2)]);
var state_15909__$1 = state_15909;
var statearr_15911_15938 = state_15909__$1;
(statearr_15911_15938[(2)] = inst_15891);

(statearr_15911_15938[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (1))){
var inst_15885 = cljs.core.seq(coll);
var inst_15886 = inst_15885;
var state_15909__$1 = (function (){var statearr_15912 = state_15909;
(statearr_15912[(7)] = inst_15886);

return statearr_15912;
})();
var statearr_15913_15939 = state_15909__$1;
(statearr_15913_15939[(2)] = null);

(statearr_15913_15939[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (4))){
var inst_15886 = (state_15909[(7)]);
var inst_15889 = cljs.core.first(inst_15886);
var state_15909__$1 = state_15909;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15909__$1,(7),ch,inst_15889);
} else {
if((state_val_15910 === (13))){
var inst_15903 = (state_15909[(2)]);
var state_15909__$1 = state_15909;
var statearr_15914_15940 = state_15909__$1;
(statearr_15914_15940[(2)] = inst_15903);

(statearr_15914_15940[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (6))){
var inst_15894 = (state_15909[(2)]);
var state_15909__$1 = state_15909;
if(cljs.core.truth_(inst_15894)){
var statearr_15915_15941 = state_15909__$1;
(statearr_15915_15941[(1)] = (8));

} else {
var statearr_15916_15942 = state_15909__$1;
(statearr_15916_15942[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (3))){
var inst_15907 = (state_15909[(2)]);
var state_15909__$1 = state_15909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15909__$1,inst_15907);
} else {
if((state_val_15910 === (12))){
var state_15909__$1 = state_15909;
var statearr_15917_15943 = state_15909__$1;
(statearr_15917_15943[(2)] = null);

(statearr_15917_15943[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (2))){
var inst_15886 = (state_15909[(7)]);
var state_15909__$1 = state_15909;
if(cljs.core.truth_(inst_15886)){
var statearr_15918_15944 = state_15909__$1;
(statearr_15918_15944[(1)] = (4));

} else {
var statearr_15919_15945 = state_15909__$1;
(statearr_15919_15945[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (11))){
var inst_15900 = cljs.core.async.close_BANG_(ch);
var state_15909__$1 = state_15909;
var statearr_15920_15946 = state_15909__$1;
(statearr_15920_15946[(2)] = inst_15900);

(statearr_15920_15946[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (9))){
var state_15909__$1 = state_15909;
if(cljs.core.truth_(close_QMARK_)){
var statearr_15921_15947 = state_15909__$1;
(statearr_15921_15947[(1)] = (11));

} else {
var statearr_15922_15948 = state_15909__$1;
(statearr_15922_15948[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (5))){
var inst_15886 = (state_15909[(7)]);
var state_15909__$1 = state_15909;
var statearr_15923_15949 = state_15909__$1;
(statearr_15923_15949[(2)] = inst_15886);

(statearr_15923_15949[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (10))){
var inst_15905 = (state_15909[(2)]);
var state_15909__$1 = state_15909;
var statearr_15924_15950 = state_15909__$1;
(statearr_15924_15950[(2)] = inst_15905);

(statearr_15924_15950[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15910 === (8))){
var inst_15886 = (state_15909[(7)]);
var inst_15896 = cljs.core.next(inst_15886);
var inst_15886__$1 = inst_15896;
var state_15909__$1 = (function (){var statearr_15925 = state_15909;
(statearr_15925[(7)] = inst_15886__$1);

return statearr_15925;
})();
var statearr_15926_15951 = state_15909__$1;
(statearr_15926_15951[(2)] = null);

(statearr_15926_15951[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto__))
;
return ((function (switch__14923__auto__,c__15047__auto__){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_15930 = [null,null,null,null,null,null,null,null];
(statearr_15930[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_15930[(1)] = (1));

return statearr_15930;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_15909){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_15909);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e15931){if((e15931 instanceof Object)){
var ex__14927__auto__ = e15931;
var statearr_15932_15952 = state_15909;
(statearr_15932_15952[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_15909);

return cljs.core.cst$kw$recur;
} else {
throw e15931;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__15953 = state_15909;
state_15909 = G__15953;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_15909){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_15909);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto__))
})();
var state__15049__auto__ = (function (){var statearr_15933 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_15933[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto__);

return statearr_15933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto__))
);

return c__15047__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7957__auto__ = (((_ == null))?null:_);
var m__7958__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__7958__auto__.call(null,_));
} else {
var m__7958__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__7958__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7958__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__7958__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto__.call(null,m));
} else {
var m__7958__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__16182 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16182) : cljs.core.atom.call(null,G__16182));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16183 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16183 = (function (ch,cs,meta16184){
this.ch = ch;
this.cs = cs;
this.meta16184 = meta16184;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_16185,meta16184__$1){
var self__ = this;
var _16185__$1 = this;
return (new cljs.core.async.t_cljs$core$async16183(self__.ch,self__.cs,meta16184__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_16185){
var self__ = this;
var _16185__$1 = this;
return self__.meta16184;
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16186_16410 = self__.cs;
var G__16187_16411 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16186_16410,G__16187_16411) : cljs.core.reset_BANG_.call(null,G__16186_16410,G__16187_16411));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta16184], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async16183.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16183.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16183";

cljs.core.async.t_cljs$core$async16183.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16183");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async16183 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async16183(ch__$1,cs__$1,meta16184){
return (new cljs.core.async.t_cljs$core$async16183(ch__$1,cs__$1,meta16184));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async16183(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__15047__auto___16412 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___16412,cs,m,dchan,dctr,done){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___16412,cs,m,dchan,dctr,done){
return (function (state_16322){
var state_val_16323 = (state_16322[(1)]);
if((state_val_16323 === (7))){
var inst_16318 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16324_16413 = state_16322__$1;
(statearr_16324_16413[(2)] = inst_16318);

(statearr_16324_16413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (20))){
var inst_16221 = (state_16322[(7)]);
var inst_16233 = cljs.core.first(inst_16221);
var inst_16234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16233,(0),null);
var inst_16235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16233,(1),null);
var state_16322__$1 = (function (){var statearr_16325 = state_16322;
(statearr_16325[(8)] = inst_16234);

return statearr_16325;
})();
if(cljs.core.truth_(inst_16235)){
var statearr_16326_16414 = state_16322__$1;
(statearr_16326_16414[(1)] = (22));

} else {
var statearr_16327_16415 = state_16322__$1;
(statearr_16327_16415[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (27))){
var inst_16265 = (state_16322[(9)]);
var inst_16263 = (state_16322[(10)]);
var inst_16190 = (state_16322[(11)]);
var inst_16270 = (state_16322[(12)]);
var inst_16270__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16263,inst_16265);
var inst_16271 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16270__$1,inst_16190,done);
var state_16322__$1 = (function (){var statearr_16328 = state_16322;
(statearr_16328[(12)] = inst_16270__$1);

return statearr_16328;
})();
if(cljs.core.truth_(inst_16271)){
var statearr_16329_16416 = state_16322__$1;
(statearr_16329_16416[(1)] = (30));

} else {
var statearr_16330_16417 = state_16322__$1;
(statearr_16330_16417[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (1))){
var state_16322__$1 = state_16322;
var statearr_16331_16418 = state_16322__$1;
(statearr_16331_16418[(2)] = null);

(statearr_16331_16418[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (24))){
var inst_16221 = (state_16322[(7)]);
var inst_16240 = (state_16322[(2)]);
var inst_16241 = cljs.core.next(inst_16221);
var inst_16199 = inst_16241;
var inst_16200 = null;
var inst_16201 = (0);
var inst_16202 = (0);
var state_16322__$1 = (function (){var statearr_16332 = state_16322;
(statearr_16332[(13)] = inst_16200);

(statearr_16332[(14)] = inst_16240);

(statearr_16332[(15)] = inst_16199);

(statearr_16332[(16)] = inst_16201);

(statearr_16332[(17)] = inst_16202);

return statearr_16332;
})();
var statearr_16333_16419 = state_16322__$1;
(statearr_16333_16419[(2)] = null);

(statearr_16333_16419[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (39))){
var state_16322__$1 = state_16322;
var statearr_16337_16420 = state_16322__$1;
(statearr_16337_16420[(2)] = null);

(statearr_16337_16420[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (4))){
var inst_16190 = (state_16322[(11)]);
var inst_16190__$1 = (state_16322[(2)]);
var inst_16191 = (inst_16190__$1 == null);
var state_16322__$1 = (function (){var statearr_16338 = state_16322;
(statearr_16338[(11)] = inst_16190__$1);

return statearr_16338;
})();
if(cljs.core.truth_(inst_16191)){
var statearr_16339_16421 = state_16322__$1;
(statearr_16339_16421[(1)] = (5));

} else {
var statearr_16340_16422 = state_16322__$1;
(statearr_16340_16422[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (15))){
var inst_16200 = (state_16322[(13)]);
var inst_16199 = (state_16322[(15)]);
var inst_16201 = (state_16322[(16)]);
var inst_16202 = (state_16322[(17)]);
var inst_16217 = (state_16322[(2)]);
var inst_16218 = (inst_16202 + (1));
var tmp16334 = inst_16200;
var tmp16335 = inst_16199;
var tmp16336 = inst_16201;
var inst_16199__$1 = tmp16335;
var inst_16200__$1 = tmp16334;
var inst_16201__$1 = tmp16336;
var inst_16202__$1 = inst_16218;
var state_16322__$1 = (function (){var statearr_16341 = state_16322;
(statearr_16341[(13)] = inst_16200__$1);

(statearr_16341[(15)] = inst_16199__$1);

(statearr_16341[(16)] = inst_16201__$1);

(statearr_16341[(18)] = inst_16217);

(statearr_16341[(17)] = inst_16202__$1);

return statearr_16341;
})();
var statearr_16342_16423 = state_16322__$1;
(statearr_16342_16423[(2)] = null);

(statearr_16342_16423[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (21))){
var inst_16244 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16346_16424 = state_16322__$1;
(statearr_16346_16424[(2)] = inst_16244);

(statearr_16346_16424[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (31))){
var inst_16270 = (state_16322[(12)]);
var inst_16274 = done(null);
var inst_16275 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16270);
var state_16322__$1 = (function (){var statearr_16347 = state_16322;
(statearr_16347[(19)] = inst_16274);

return statearr_16347;
})();
var statearr_16348_16425 = state_16322__$1;
(statearr_16348_16425[(2)] = inst_16275);

(statearr_16348_16425[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (32))){
var inst_16265 = (state_16322[(9)]);
var inst_16262 = (state_16322[(20)]);
var inst_16263 = (state_16322[(10)]);
var inst_16264 = (state_16322[(21)]);
var inst_16277 = (state_16322[(2)]);
var inst_16278 = (inst_16265 + (1));
var tmp16343 = inst_16262;
var tmp16344 = inst_16263;
var tmp16345 = inst_16264;
var inst_16262__$1 = tmp16343;
var inst_16263__$1 = tmp16344;
var inst_16264__$1 = tmp16345;
var inst_16265__$1 = inst_16278;
var state_16322__$1 = (function (){var statearr_16349 = state_16322;
(statearr_16349[(9)] = inst_16265__$1);

(statearr_16349[(20)] = inst_16262__$1);

(statearr_16349[(10)] = inst_16263__$1);

(statearr_16349[(21)] = inst_16264__$1);

(statearr_16349[(22)] = inst_16277);

return statearr_16349;
})();
var statearr_16350_16426 = state_16322__$1;
(statearr_16350_16426[(2)] = null);

(statearr_16350_16426[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (40))){
var inst_16290 = (state_16322[(23)]);
var inst_16294 = done(null);
var inst_16295 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_16290);
var state_16322__$1 = (function (){var statearr_16351 = state_16322;
(statearr_16351[(24)] = inst_16294);

return statearr_16351;
})();
var statearr_16352_16427 = state_16322__$1;
(statearr_16352_16427[(2)] = inst_16295);

(statearr_16352_16427[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (33))){
var inst_16281 = (state_16322[(25)]);
var inst_16283 = cljs.core.chunked_seq_QMARK_(inst_16281);
var state_16322__$1 = state_16322;
if(inst_16283){
var statearr_16353_16428 = state_16322__$1;
(statearr_16353_16428[(1)] = (36));

} else {
var statearr_16354_16429 = state_16322__$1;
(statearr_16354_16429[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (13))){
var inst_16211 = (state_16322[(26)]);
var inst_16214 = cljs.core.async.close_BANG_(inst_16211);
var state_16322__$1 = state_16322;
var statearr_16355_16430 = state_16322__$1;
(statearr_16355_16430[(2)] = inst_16214);

(statearr_16355_16430[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (22))){
var inst_16234 = (state_16322[(8)]);
var inst_16237 = cljs.core.async.close_BANG_(inst_16234);
var state_16322__$1 = state_16322;
var statearr_16356_16431 = state_16322__$1;
(statearr_16356_16431[(2)] = inst_16237);

(statearr_16356_16431[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (36))){
var inst_16281 = (state_16322[(25)]);
var inst_16285 = cljs.core.chunk_first(inst_16281);
var inst_16286 = cljs.core.chunk_rest(inst_16281);
var inst_16287 = cljs.core.count(inst_16285);
var inst_16262 = inst_16286;
var inst_16263 = inst_16285;
var inst_16264 = inst_16287;
var inst_16265 = (0);
var state_16322__$1 = (function (){var statearr_16357 = state_16322;
(statearr_16357[(9)] = inst_16265);

(statearr_16357[(20)] = inst_16262);

(statearr_16357[(10)] = inst_16263);

(statearr_16357[(21)] = inst_16264);

return statearr_16357;
})();
var statearr_16358_16432 = state_16322__$1;
(statearr_16358_16432[(2)] = null);

(statearr_16358_16432[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (41))){
var inst_16281 = (state_16322[(25)]);
var inst_16297 = (state_16322[(2)]);
var inst_16298 = cljs.core.next(inst_16281);
var inst_16262 = inst_16298;
var inst_16263 = null;
var inst_16264 = (0);
var inst_16265 = (0);
var state_16322__$1 = (function (){var statearr_16359 = state_16322;
(statearr_16359[(9)] = inst_16265);

(statearr_16359[(27)] = inst_16297);

(statearr_16359[(20)] = inst_16262);

(statearr_16359[(10)] = inst_16263);

(statearr_16359[(21)] = inst_16264);

return statearr_16359;
})();
var statearr_16360_16433 = state_16322__$1;
(statearr_16360_16433[(2)] = null);

(statearr_16360_16433[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (43))){
var state_16322__$1 = state_16322;
var statearr_16361_16434 = state_16322__$1;
(statearr_16361_16434[(2)] = null);

(statearr_16361_16434[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (29))){
var inst_16306 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16362_16435 = state_16322__$1;
(statearr_16362_16435[(2)] = inst_16306);

(statearr_16362_16435[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (44))){
var inst_16315 = (state_16322[(2)]);
var state_16322__$1 = (function (){var statearr_16363 = state_16322;
(statearr_16363[(28)] = inst_16315);

return statearr_16363;
})();
var statearr_16364_16436 = state_16322__$1;
(statearr_16364_16436[(2)] = null);

(statearr_16364_16436[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (6))){
var inst_16254 = (state_16322[(29)]);
var inst_16253 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_16254__$1 = cljs.core.keys(inst_16253);
var inst_16255 = cljs.core.count(inst_16254__$1);
var inst_16256 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_16255) : cljs.core.reset_BANG_.call(null,dctr,inst_16255));
var inst_16261 = cljs.core.seq(inst_16254__$1);
var inst_16262 = inst_16261;
var inst_16263 = null;
var inst_16264 = (0);
var inst_16265 = (0);
var state_16322__$1 = (function (){var statearr_16365 = state_16322;
(statearr_16365[(9)] = inst_16265);

(statearr_16365[(20)] = inst_16262);

(statearr_16365[(29)] = inst_16254__$1);

(statearr_16365[(10)] = inst_16263);

(statearr_16365[(21)] = inst_16264);

(statearr_16365[(30)] = inst_16256);

return statearr_16365;
})();
var statearr_16366_16437 = state_16322__$1;
(statearr_16366_16437[(2)] = null);

(statearr_16366_16437[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (28))){
var inst_16262 = (state_16322[(20)]);
var inst_16281 = (state_16322[(25)]);
var inst_16281__$1 = cljs.core.seq(inst_16262);
var state_16322__$1 = (function (){var statearr_16367 = state_16322;
(statearr_16367[(25)] = inst_16281__$1);

return statearr_16367;
})();
if(inst_16281__$1){
var statearr_16368_16438 = state_16322__$1;
(statearr_16368_16438[(1)] = (33));

} else {
var statearr_16369_16439 = state_16322__$1;
(statearr_16369_16439[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (25))){
var inst_16265 = (state_16322[(9)]);
var inst_16264 = (state_16322[(21)]);
var inst_16267 = (inst_16265 < inst_16264);
var inst_16268 = inst_16267;
var state_16322__$1 = state_16322;
if(cljs.core.truth_(inst_16268)){
var statearr_16370_16440 = state_16322__$1;
(statearr_16370_16440[(1)] = (27));

} else {
var statearr_16371_16441 = state_16322__$1;
(statearr_16371_16441[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (34))){
var state_16322__$1 = state_16322;
var statearr_16372_16442 = state_16322__$1;
(statearr_16372_16442[(2)] = null);

(statearr_16372_16442[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (17))){
var state_16322__$1 = state_16322;
var statearr_16373_16443 = state_16322__$1;
(statearr_16373_16443[(2)] = null);

(statearr_16373_16443[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (3))){
var inst_16320 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16322__$1,inst_16320);
} else {
if((state_val_16323 === (12))){
var inst_16249 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16374_16444 = state_16322__$1;
(statearr_16374_16444[(2)] = inst_16249);

(statearr_16374_16444[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (2))){
var state_16322__$1 = state_16322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16322__$1,(4),ch);
} else {
if((state_val_16323 === (23))){
var state_16322__$1 = state_16322;
var statearr_16375_16445 = state_16322__$1;
(statearr_16375_16445[(2)] = null);

(statearr_16375_16445[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (35))){
var inst_16304 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16376_16446 = state_16322__$1;
(statearr_16376_16446[(2)] = inst_16304);

(statearr_16376_16446[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (19))){
var inst_16221 = (state_16322[(7)]);
var inst_16225 = cljs.core.chunk_first(inst_16221);
var inst_16226 = cljs.core.chunk_rest(inst_16221);
var inst_16227 = cljs.core.count(inst_16225);
var inst_16199 = inst_16226;
var inst_16200 = inst_16225;
var inst_16201 = inst_16227;
var inst_16202 = (0);
var state_16322__$1 = (function (){var statearr_16377 = state_16322;
(statearr_16377[(13)] = inst_16200);

(statearr_16377[(15)] = inst_16199);

(statearr_16377[(16)] = inst_16201);

(statearr_16377[(17)] = inst_16202);

return statearr_16377;
})();
var statearr_16378_16447 = state_16322__$1;
(statearr_16378_16447[(2)] = null);

(statearr_16378_16447[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (11))){
var inst_16221 = (state_16322[(7)]);
var inst_16199 = (state_16322[(15)]);
var inst_16221__$1 = cljs.core.seq(inst_16199);
var state_16322__$1 = (function (){var statearr_16379 = state_16322;
(statearr_16379[(7)] = inst_16221__$1);

return statearr_16379;
})();
if(inst_16221__$1){
var statearr_16380_16448 = state_16322__$1;
(statearr_16380_16448[(1)] = (16));

} else {
var statearr_16381_16449 = state_16322__$1;
(statearr_16381_16449[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (9))){
var inst_16251 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16382_16450 = state_16322__$1;
(statearr_16382_16450[(2)] = inst_16251);

(statearr_16382_16450[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (5))){
var inst_16197 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_16198 = cljs.core.seq(inst_16197);
var inst_16199 = inst_16198;
var inst_16200 = null;
var inst_16201 = (0);
var inst_16202 = (0);
var state_16322__$1 = (function (){var statearr_16383 = state_16322;
(statearr_16383[(13)] = inst_16200);

(statearr_16383[(15)] = inst_16199);

(statearr_16383[(16)] = inst_16201);

(statearr_16383[(17)] = inst_16202);

return statearr_16383;
})();
var statearr_16384_16451 = state_16322__$1;
(statearr_16384_16451[(2)] = null);

(statearr_16384_16451[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (14))){
var state_16322__$1 = state_16322;
var statearr_16385_16452 = state_16322__$1;
(statearr_16385_16452[(2)] = null);

(statearr_16385_16452[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (45))){
var inst_16312 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16386_16453 = state_16322__$1;
(statearr_16386_16453[(2)] = inst_16312);

(statearr_16386_16453[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (26))){
var inst_16254 = (state_16322[(29)]);
var inst_16308 = (state_16322[(2)]);
var inst_16309 = cljs.core.seq(inst_16254);
var state_16322__$1 = (function (){var statearr_16387 = state_16322;
(statearr_16387[(31)] = inst_16308);

return statearr_16387;
})();
if(inst_16309){
var statearr_16388_16454 = state_16322__$1;
(statearr_16388_16454[(1)] = (42));

} else {
var statearr_16389_16455 = state_16322__$1;
(statearr_16389_16455[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (16))){
var inst_16221 = (state_16322[(7)]);
var inst_16223 = cljs.core.chunked_seq_QMARK_(inst_16221);
var state_16322__$1 = state_16322;
if(inst_16223){
var statearr_16390_16456 = state_16322__$1;
(statearr_16390_16456[(1)] = (19));

} else {
var statearr_16391_16457 = state_16322__$1;
(statearr_16391_16457[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (38))){
var inst_16301 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16392_16458 = state_16322__$1;
(statearr_16392_16458[(2)] = inst_16301);

(statearr_16392_16458[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (30))){
var state_16322__$1 = state_16322;
var statearr_16393_16459 = state_16322__$1;
(statearr_16393_16459[(2)] = null);

(statearr_16393_16459[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (10))){
var inst_16200 = (state_16322[(13)]);
var inst_16202 = (state_16322[(17)]);
var inst_16210 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16200,inst_16202);
var inst_16211 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16210,(0),null);
var inst_16212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16210,(1),null);
var state_16322__$1 = (function (){var statearr_16394 = state_16322;
(statearr_16394[(26)] = inst_16211);

return statearr_16394;
})();
if(cljs.core.truth_(inst_16212)){
var statearr_16395_16460 = state_16322__$1;
(statearr_16395_16460[(1)] = (13));

} else {
var statearr_16396_16461 = state_16322__$1;
(statearr_16396_16461[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (18))){
var inst_16247 = (state_16322[(2)]);
var state_16322__$1 = state_16322;
var statearr_16397_16462 = state_16322__$1;
(statearr_16397_16462[(2)] = inst_16247);

(statearr_16397_16462[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (42))){
var state_16322__$1 = state_16322;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16322__$1,(45),dchan);
} else {
if((state_val_16323 === (37))){
var inst_16290 = (state_16322[(23)]);
var inst_16281 = (state_16322[(25)]);
var inst_16190 = (state_16322[(11)]);
var inst_16290__$1 = cljs.core.first(inst_16281);
var inst_16291 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_16290__$1,inst_16190,done);
var state_16322__$1 = (function (){var statearr_16398 = state_16322;
(statearr_16398[(23)] = inst_16290__$1);

return statearr_16398;
})();
if(cljs.core.truth_(inst_16291)){
var statearr_16399_16463 = state_16322__$1;
(statearr_16399_16463[(1)] = (39));

} else {
var statearr_16400_16464 = state_16322__$1;
(statearr_16400_16464[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16323 === (8))){
var inst_16201 = (state_16322[(16)]);
var inst_16202 = (state_16322[(17)]);
var inst_16204 = (inst_16202 < inst_16201);
var inst_16205 = inst_16204;
var state_16322__$1 = state_16322;
if(cljs.core.truth_(inst_16205)){
var statearr_16401_16465 = state_16322__$1;
(statearr_16401_16465[(1)] = (10));

} else {
var statearr_16402_16466 = state_16322__$1;
(statearr_16402_16466[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___16412,cs,m,dchan,dctr,done))
;
return ((function (switch__14923__auto__,c__15047__auto___16412,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__14924__auto__ = null;
var cljs$core$async$mult_$_state_machine__14924__auto____0 = (function (){
var statearr_16406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16406[(0)] = cljs$core$async$mult_$_state_machine__14924__auto__);

(statearr_16406[(1)] = (1));

return statearr_16406;
});
var cljs$core$async$mult_$_state_machine__14924__auto____1 = (function (state_16322){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_16322);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e16407){if((e16407 instanceof Object)){
var ex__14927__auto__ = e16407;
var statearr_16408_16467 = state_16322;
(statearr_16408_16467[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16322);

return cljs.core.cst$kw$recur;
} else {
throw e16407;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__16468 = state_16322;
state_16322 = G__16468;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__14924__auto__ = function(state_16322){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__14924__auto____1.call(this,state_16322);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__14924__auto____0;
cljs$core$async$mult_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__14924__auto____1;
return cljs$core$async$mult_$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___16412,cs,m,dchan,dctr,done))
})();
var state__15049__auto__ = (function (){var statearr_16409 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_16409[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___16412);

return statearr_16409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___16412,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args16469 = [];
var len__8402__auto___16472 = arguments.length;
var i__8403__auto___16473 = (0);
while(true){
if((i__8403__auto___16473 < len__8402__auto___16472)){
args16469.push((arguments[i__8403__auto___16473]));

var G__16474 = (i__8403__auto___16473 + (1));
i__8403__auto___16473 = G__16474;
continue;
} else {
}
break;
}

var G__16471 = args16469.length;
switch (G__16471) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16469.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto__.call(null,m,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__7958__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto__.call(null,m));
} else {
var m__7958__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__7958__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7958__auto__.call(null,m,state_map));
} else {
var m__7958__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__7958__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7957__auto__ = (((m == null))?null:m);
var m__7958__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7958__auto__.call(null,m,mode));
} else {
var m__7958__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__7958__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__8409__auto__ = [];
var len__8402__auto___16486 = arguments.length;
var i__8403__auto___16487 = (0);
while(true){
if((i__8403__auto___16487 < len__8402__auto___16486)){
args__8409__auto__.push((arguments[i__8403__auto___16487]));

var G__16488 = (i__8403__auto___16487 + (1));
i__8403__auto___16487 = G__16488;
continue;
} else {
}
break;
}

var argseq__8410__auto__ = ((((3) < args__8409__auto__.length))?(new cljs.core.IndexedSeq(args__8409__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8410__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__16480){
var map__16481 = p__16480;
var map__16481__$1 = ((((!((map__16481 == null)))?((((map__16481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16481.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16481):map__16481);
var opts = map__16481__$1;
var statearr_16483_16489 = state;
(statearr_16483_16489[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__16481,map__16481__$1,opts){
return (function (val){
var statearr_16484_16490 = state;
(statearr_16484_16490[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__16481,map__16481__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_16485_16491 = state;
(statearr_16485_16491[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq16476){
var G__16477 = cljs.core.first(seq16476);
var seq16476__$1 = cljs.core.next(seq16476);
var G__16478 = cljs.core.first(seq16476__$1);
var seq16476__$2 = cljs.core.next(seq16476__$1);
var G__16479 = cljs.core.first(seq16476__$2);
var seq16476__$3 = cljs.core.next(seq16476__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16477,G__16478,G__16479,seq16476__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__16663 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16663) : cljs.core.atom.call(null,G__16663));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (function (){var G__16664 = cljs.core.cst$kw$mute;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16664) : cljs.core.atom.call(null,G__16664));
})();
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async16665 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16665 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta16666){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta16666 = meta16666;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16667,meta16666__$1){
var self__ = this;
var _16667__$1 = this;
return (new cljs.core.async.t_cljs$core$async16665(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta16666__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_16667){
var self__ = this;
var _16667__$1 = this;
return self__.meta16666;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16668_16834 = self__.cs;
var G__16669_16835 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16668_16834,G__16669_16835) : cljs.core.reset_BANG_.call(null,G__16668_16834,G__16669_16835));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out,cljs.core.cst$sym$cs,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$change,cljs.core.cst$sym$changed,cljs.core.cst$sym$pick,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$meta16666], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async16665.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16665.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16665";

cljs.core.async.t_cljs$core$async16665.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16665");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async16665 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async16665(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta16666){
return (new cljs.core.async.t_cljs$core$async16665(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta16666));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async16665(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15047__auto___16836 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_16771){
var state_val_16772 = (state_16771[(1)]);
if((state_val_16772 === (7))){
var inst_16686 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
var statearr_16773_16837 = state_16771__$1;
(statearr_16773_16837[(2)] = inst_16686);

(statearr_16773_16837[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (20))){
var inst_16698 = (state_16771[(7)]);
var state_16771__$1 = state_16771;
var statearr_16774_16838 = state_16771__$1;
(statearr_16774_16838[(2)] = inst_16698);

(statearr_16774_16838[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (27))){
var state_16771__$1 = state_16771;
var statearr_16775_16839 = state_16771__$1;
(statearr_16775_16839[(2)] = null);

(statearr_16775_16839[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (1))){
var inst_16673 = (state_16771[(8)]);
var inst_16673__$1 = calc_state();
var inst_16675 = (inst_16673__$1 == null);
var inst_16676 = cljs.core.not(inst_16675);
var state_16771__$1 = (function (){var statearr_16776 = state_16771;
(statearr_16776[(8)] = inst_16673__$1);

return statearr_16776;
})();
if(inst_16676){
var statearr_16777_16840 = state_16771__$1;
(statearr_16777_16840[(1)] = (2));

} else {
var statearr_16778_16841 = state_16771__$1;
(statearr_16778_16841[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (24))){
var inst_16745 = (state_16771[(9)]);
var inst_16731 = (state_16771[(10)]);
var inst_16722 = (state_16771[(11)]);
var inst_16745__$1 = (inst_16722.cljs$core$IFn$_invoke$arity$1 ? inst_16722.cljs$core$IFn$_invoke$arity$1(inst_16731) : inst_16722.call(null,inst_16731));
var state_16771__$1 = (function (){var statearr_16779 = state_16771;
(statearr_16779[(9)] = inst_16745__$1);

return statearr_16779;
})();
if(cljs.core.truth_(inst_16745__$1)){
var statearr_16780_16842 = state_16771__$1;
(statearr_16780_16842[(1)] = (29));

} else {
var statearr_16781_16843 = state_16771__$1;
(statearr_16781_16843[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (4))){
var inst_16689 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16689)){
var statearr_16782_16844 = state_16771__$1;
(statearr_16782_16844[(1)] = (8));

} else {
var statearr_16783_16845 = state_16771__$1;
(statearr_16783_16845[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (15))){
var inst_16716 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16716)){
var statearr_16784_16846 = state_16771__$1;
(statearr_16784_16846[(1)] = (19));

} else {
var statearr_16785_16847 = state_16771__$1;
(statearr_16785_16847[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (21))){
var inst_16721 = (state_16771[(12)]);
var inst_16721__$1 = (state_16771[(2)]);
var inst_16722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16721__$1,cljs.core.cst$kw$solos);
var inst_16723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16721__$1,cljs.core.cst$kw$mutes);
var inst_16724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16721__$1,cljs.core.cst$kw$reads);
var state_16771__$1 = (function (){var statearr_16786 = state_16771;
(statearr_16786[(12)] = inst_16721__$1);

(statearr_16786[(13)] = inst_16723);

(statearr_16786[(11)] = inst_16722);

return statearr_16786;
})();
return cljs.core.async.ioc_alts_BANG_(state_16771__$1,(22),inst_16724);
} else {
if((state_val_16772 === (31))){
var inst_16753 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16753)){
var statearr_16787_16848 = state_16771__$1;
(statearr_16787_16848[(1)] = (32));

} else {
var statearr_16788_16849 = state_16771__$1;
(statearr_16788_16849[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (32))){
var inst_16730 = (state_16771[(14)]);
var state_16771__$1 = state_16771;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16771__$1,(35),out,inst_16730);
} else {
if((state_val_16772 === (33))){
var inst_16721 = (state_16771[(12)]);
var inst_16698 = inst_16721;
var state_16771__$1 = (function (){var statearr_16789 = state_16771;
(statearr_16789[(7)] = inst_16698);

return statearr_16789;
})();
var statearr_16790_16850 = state_16771__$1;
(statearr_16790_16850[(2)] = null);

(statearr_16790_16850[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (13))){
var inst_16698 = (state_16771[(7)]);
var inst_16705 = inst_16698.cljs$lang$protocol_mask$partition0$;
var inst_16706 = (inst_16705 & (64));
var inst_16707 = inst_16698.cljs$core$ISeq$;
var inst_16708 = (cljs.core.PROTOCOL_SENTINEL === inst_16707);
var inst_16709 = (inst_16706) || (inst_16708);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16709)){
var statearr_16791_16851 = state_16771__$1;
(statearr_16791_16851[(1)] = (16));

} else {
var statearr_16792_16852 = state_16771__$1;
(statearr_16792_16852[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (22))){
var inst_16731 = (state_16771[(10)]);
var inst_16730 = (state_16771[(14)]);
var inst_16729 = (state_16771[(2)]);
var inst_16730__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16729,(0),null);
var inst_16731__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_16729,(1),null);
var inst_16732 = (inst_16730__$1 == null);
var inst_16733 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_16731__$1,change);
var inst_16734 = (inst_16732) || (inst_16733);
var state_16771__$1 = (function (){var statearr_16793 = state_16771;
(statearr_16793[(10)] = inst_16731__$1);

(statearr_16793[(14)] = inst_16730__$1);

return statearr_16793;
})();
if(cljs.core.truth_(inst_16734)){
var statearr_16794_16853 = state_16771__$1;
(statearr_16794_16853[(1)] = (23));

} else {
var statearr_16795_16854 = state_16771__$1;
(statearr_16795_16854[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (36))){
var inst_16721 = (state_16771[(12)]);
var inst_16698 = inst_16721;
var state_16771__$1 = (function (){var statearr_16796 = state_16771;
(statearr_16796[(7)] = inst_16698);

return statearr_16796;
})();
var statearr_16797_16855 = state_16771__$1;
(statearr_16797_16855[(2)] = null);

(statearr_16797_16855[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (29))){
var inst_16745 = (state_16771[(9)]);
var state_16771__$1 = state_16771;
var statearr_16798_16856 = state_16771__$1;
(statearr_16798_16856[(2)] = inst_16745);

(statearr_16798_16856[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (6))){
var state_16771__$1 = state_16771;
var statearr_16799_16857 = state_16771__$1;
(statearr_16799_16857[(2)] = false);

(statearr_16799_16857[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (28))){
var inst_16741 = (state_16771[(2)]);
var inst_16742 = calc_state();
var inst_16698 = inst_16742;
var state_16771__$1 = (function (){var statearr_16800 = state_16771;
(statearr_16800[(15)] = inst_16741);

(statearr_16800[(7)] = inst_16698);

return statearr_16800;
})();
var statearr_16801_16858 = state_16771__$1;
(statearr_16801_16858[(2)] = null);

(statearr_16801_16858[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (25))){
var inst_16767 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
var statearr_16802_16859 = state_16771__$1;
(statearr_16802_16859[(2)] = inst_16767);

(statearr_16802_16859[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (34))){
var inst_16765 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
var statearr_16803_16860 = state_16771__$1;
(statearr_16803_16860[(2)] = inst_16765);

(statearr_16803_16860[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (17))){
var state_16771__$1 = state_16771;
var statearr_16804_16861 = state_16771__$1;
(statearr_16804_16861[(2)] = false);

(statearr_16804_16861[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (3))){
var state_16771__$1 = state_16771;
var statearr_16805_16862 = state_16771__$1;
(statearr_16805_16862[(2)] = false);

(statearr_16805_16862[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (12))){
var inst_16769 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16771__$1,inst_16769);
} else {
if((state_val_16772 === (2))){
var inst_16673 = (state_16771[(8)]);
var inst_16678 = inst_16673.cljs$lang$protocol_mask$partition0$;
var inst_16679 = (inst_16678 & (64));
var inst_16680 = inst_16673.cljs$core$ISeq$;
var inst_16681 = (cljs.core.PROTOCOL_SENTINEL === inst_16680);
var inst_16682 = (inst_16679) || (inst_16681);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16682)){
var statearr_16806_16863 = state_16771__$1;
(statearr_16806_16863[(1)] = (5));

} else {
var statearr_16807_16864 = state_16771__$1;
(statearr_16807_16864[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (23))){
var inst_16730 = (state_16771[(14)]);
var inst_16736 = (inst_16730 == null);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16736)){
var statearr_16808_16865 = state_16771__$1;
(statearr_16808_16865[(1)] = (26));

} else {
var statearr_16809_16866 = state_16771__$1;
(statearr_16809_16866[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (35))){
var inst_16756 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
if(cljs.core.truth_(inst_16756)){
var statearr_16810_16867 = state_16771__$1;
(statearr_16810_16867[(1)] = (36));

} else {
var statearr_16811_16868 = state_16771__$1;
(statearr_16811_16868[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (19))){
var inst_16698 = (state_16771[(7)]);
var inst_16718 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16698);
var state_16771__$1 = state_16771;
var statearr_16812_16869 = state_16771__$1;
(statearr_16812_16869[(2)] = inst_16718);

(statearr_16812_16869[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (11))){
var inst_16698 = (state_16771[(7)]);
var inst_16702 = (inst_16698 == null);
var inst_16703 = cljs.core.not(inst_16702);
var state_16771__$1 = state_16771;
if(inst_16703){
var statearr_16813_16870 = state_16771__$1;
(statearr_16813_16870[(1)] = (13));

} else {
var statearr_16814_16871 = state_16771__$1;
(statearr_16814_16871[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (9))){
var inst_16673 = (state_16771[(8)]);
var state_16771__$1 = state_16771;
var statearr_16815_16872 = state_16771__$1;
(statearr_16815_16872[(2)] = inst_16673);

(statearr_16815_16872[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (5))){
var state_16771__$1 = state_16771;
var statearr_16816_16873 = state_16771__$1;
(statearr_16816_16873[(2)] = true);

(statearr_16816_16873[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (14))){
var state_16771__$1 = state_16771;
var statearr_16817_16874 = state_16771__$1;
(statearr_16817_16874[(2)] = false);

(statearr_16817_16874[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (26))){
var inst_16731 = (state_16771[(10)]);
var inst_16738 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_16731);
var state_16771__$1 = state_16771;
var statearr_16818_16875 = state_16771__$1;
(statearr_16818_16875[(2)] = inst_16738);

(statearr_16818_16875[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (16))){
var state_16771__$1 = state_16771;
var statearr_16819_16876 = state_16771__$1;
(statearr_16819_16876[(2)] = true);

(statearr_16819_16876[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (38))){
var inst_16761 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
var statearr_16820_16877 = state_16771__$1;
(statearr_16820_16877[(2)] = inst_16761);

(statearr_16820_16877[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (30))){
var inst_16731 = (state_16771[(10)]);
var inst_16723 = (state_16771[(13)]);
var inst_16722 = (state_16771[(11)]);
var inst_16748 = cljs.core.empty_QMARK_(inst_16722);
var inst_16749 = (inst_16723.cljs$core$IFn$_invoke$arity$1 ? inst_16723.cljs$core$IFn$_invoke$arity$1(inst_16731) : inst_16723.call(null,inst_16731));
var inst_16750 = cljs.core.not(inst_16749);
var inst_16751 = (inst_16748) && (inst_16750);
var state_16771__$1 = state_16771;
var statearr_16821_16878 = state_16771__$1;
(statearr_16821_16878[(2)] = inst_16751);

(statearr_16821_16878[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (10))){
var inst_16673 = (state_16771[(8)]);
var inst_16694 = (state_16771[(2)]);
var inst_16695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16694,cljs.core.cst$kw$solos);
var inst_16696 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16694,cljs.core.cst$kw$mutes);
var inst_16697 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16694,cljs.core.cst$kw$reads);
var inst_16698 = inst_16673;
var state_16771__$1 = (function (){var statearr_16822 = state_16771;
(statearr_16822[(16)] = inst_16697);

(statearr_16822[(17)] = inst_16696);

(statearr_16822[(7)] = inst_16698);

(statearr_16822[(18)] = inst_16695);

return statearr_16822;
})();
var statearr_16823_16879 = state_16771__$1;
(statearr_16823_16879[(2)] = null);

(statearr_16823_16879[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (18))){
var inst_16713 = (state_16771[(2)]);
var state_16771__$1 = state_16771;
var statearr_16824_16880 = state_16771__$1;
(statearr_16824_16880[(2)] = inst_16713);

(statearr_16824_16880[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (37))){
var state_16771__$1 = state_16771;
var statearr_16825_16881 = state_16771__$1;
(statearr_16825_16881[(2)] = null);

(statearr_16825_16881[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16772 === (8))){
var inst_16673 = (state_16771[(8)]);
var inst_16691 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16673);
var state_16771__$1 = state_16771;
var statearr_16826_16882 = state_16771__$1;
(statearr_16826_16882[(2)] = inst_16691);

(statearr_16826_16882[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__14923__auto__,c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__14924__auto__ = null;
var cljs$core$async$mix_$_state_machine__14924__auto____0 = (function (){
var statearr_16830 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16830[(0)] = cljs$core$async$mix_$_state_machine__14924__auto__);

(statearr_16830[(1)] = (1));

return statearr_16830;
});
var cljs$core$async$mix_$_state_machine__14924__auto____1 = (function (state_16771){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_16771);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e16831){if((e16831 instanceof Object)){
var ex__14927__auto__ = e16831;
var statearr_16832_16883 = state_16771;
(statearr_16832_16883[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16771);

return cljs.core.cst$kw$recur;
} else {
throw e16831;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__16884 = state_16771;
state_16771 = G__16884;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__14924__auto__ = function(state_16771){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__14924__auto____1.call(this,state_16771);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__14924__auto____0;
cljs$core$async$mix_$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__14924__auto____1;
return cljs$core$async$mix_$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__15049__auto__ = (function (){var statearr_16833 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_16833[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___16836);

return statearr_16833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___16836,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7958__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__7958__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__7958__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7958__auto__.call(null,p,v,ch));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__7958__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args16885 = [];
var len__8402__auto___16888 = arguments.length;
var i__8403__auto___16889 = (0);
while(true){
if((i__8403__auto___16889 < len__8402__auto___16888)){
args16885.push((arguments[i__8403__auto___16889]));

var G__16890 = (i__8403__auto___16889 + (1));
i__8403__auto___16889 = G__16890;
continue;
} else {
}
break;
}

var G__16887 = args16885.length;
switch (G__16887) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16885.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__7958__auto__.call(null,p));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__7958__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7957__auto__ = (((p == null))?null:p);
var m__7958__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__7958__auto__.call(null,p,v));
} else {
var m__7958__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__7958__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args16893 = [];
var len__8402__auto___17021 = arguments.length;
var i__8403__auto___17022 = (0);
while(true){
if((i__8403__auto___17022 < len__8402__auto___17021)){
args16893.push((arguments[i__8403__auto___17022]));

var G__17023 = (i__8403__auto___17022 + (1));
i__8403__auto___17022 = G__17023;
continue;
} else {
}
break;
}

var G__16895 = args16893.length;
switch (G__16895) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args16893.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__16896 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__16896) : cljs.core.atom.call(null,G__16896));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__7289__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__7289__auto__,mults){
return (function (p1__16892_SHARP_){
if(cljs.core.truth_((p1__16892_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16892_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__16892_SHARP_.call(null,topic)))){
return p1__16892_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__16892_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__7289__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async16897 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16897 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta16898){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta16898 = meta16898;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_16899,meta16898__$1){
var self__ = this;
var _16899__$1 = this;
return (new cljs.core.async.t_cljs$core$async16897(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta16898__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_16899){
var self__ = this;
var _16899__$1 = this;
return self__.meta16898;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__16900 = self__.mults;
var G__16901 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__16900,G__16901) : cljs.core.reset_BANG_.call(null,G__16900,G__16901));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta16898], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async16897.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16897.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16897";

cljs.core.async.t_cljs$core$async16897.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async16897");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async16897 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async16897(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16898){
return (new cljs.core.async.t_cljs$core$async16897(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta16898));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async16897(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__15047__auto___17025 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17025,mults,ensure_mult,p){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17025,mults,ensure_mult,p){
return (function (state_16973){
var state_val_16974 = (state_16973[(1)]);
if((state_val_16974 === (7))){
var inst_16969 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_16975_17026 = state_16973__$1;
(statearr_16975_17026[(2)] = inst_16969);

(statearr_16975_17026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (20))){
var state_16973__$1 = state_16973;
var statearr_16976_17027 = state_16973__$1;
(statearr_16976_17027[(2)] = null);

(statearr_16976_17027[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (1))){
var state_16973__$1 = state_16973;
var statearr_16977_17028 = state_16973__$1;
(statearr_16977_17028[(2)] = null);

(statearr_16977_17028[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (24))){
var inst_16952 = (state_16973[(7)]);
var inst_16961 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_16952);
var state_16973__$1 = state_16973;
var statearr_16978_17029 = state_16973__$1;
(statearr_16978_17029[(2)] = inst_16961);

(statearr_16978_17029[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (4))){
var inst_16904 = (state_16973[(8)]);
var inst_16904__$1 = (state_16973[(2)]);
var inst_16905 = (inst_16904__$1 == null);
var state_16973__$1 = (function (){var statearr_16979 = state_16973;
(statearr_16979[(8)] = inst_16904__$1);

return statearr_16979;
})();
if(cljs.core.truth_(inst_16905)){
var statearr_16980_17030 = state_16973__$1;
(statearr_16980_17030[(1)] = (5));

} else {
var statearr_16981_17031 = state_16973__$1;
(statearr_16981_17031[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (15))){
var inst_16946 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_16982_17032 = state_16973__$1;
(statearr_16982_17032[(2)] = inst_16946);

(statearr_16982_17032[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (21))){
var inst_16966 = (state_16973[(2)]);
var state_16973__$1 = (function (){var statearr_16983 = state_16973;
(statearr_16983[(9)] = inst_16966);

return statearr_16983;
})();
var statearr_16984_17033 = state_16973__$1;
(statearr_16984_17033[(2)] = null);

(statearr_16984_17033[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (13))){
var inst_16928 = (state_16973[(10)]);
var inst_16930 = cljs.core.chunked_seq_QMARK_(inst_16928);
var state_16973__$1 = state_16973;
if(inst_16930){
var statearr_16985_17034 = state_16973__$1;
(statearr_16985_17034[(1)] = (16));

} else {
var statearr_16986_17035 = state_16973__$1;
(statearr_16986_17035[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (22))){
var inst_16958 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
if(cljs.core.truth_(inst_16958)){
var statearr_16987_17036 = state_16973__$1;
(statearr_16987_17036[(1)] = (23));

} else {
var statearr_16988_17037 = state_16973__$1;
(statearr_16988_17037[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (6))){
var inst_16952 = (state_16973[(7)]);
var inst_16954 = (state_16973[(11)]);
var inst_16904 = (state_16973[(8)]);
var inst_16952__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_16904) : topic_fn.call(null,inst_16904));
var inst_16953 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16954__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16953,inst_16952__$1);
var state_16973__$1 = (function (){var statearr_16989 = state_16973;
(statearr_16989[(7)] = inst_16952__$1);

(statearr_16989[(11)] = inst_16954__$1);

return statearr_16989;
})();
if(cljs.core.truth_(inst_16954__$1)){
var statearr_16990_17038 = state_16973__$1;
(statearr_16990_17038[(1)] = (19));

} else {
var statearr_16991_17039 = state_16973__$1;
(statearr_16991_17039[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (25))){
var inst_16963 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_16992_17040 = state_16973__$1;
(statearr_16992_17040[(2)] = inst_16963);

(statearr_16992_17040[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (17))){
var inst_16928 = (state_16973[(10)]);
var inst_16937 = cljs.core.first(inst_16928);
var inst_16938 = cljs.core.async.muxch_STAR_(inst_16937);
var inst_16939 = cljs.core.async.close_BANG_(inst_16938);
var inst_16940 = cljs.core.next(inst_16928);
var inst_16914 = inst_16940;
var inst_16915 = null;
var inst_16916 = (0);
var inst_16917 = (0);
var state_16973__$1 = (function (){var statearr_16993 = state_16973;
(statearr_16993[(12)] = inst_16916);

(statearr_16993[(13)] = inst_16917);

(statearr_16993[(14)] = inst_16915);

(statearr_16993[(15)] = inst_16939);

(statearr_16993[(16)] = inst_16914);

return statearr_16993;
})();
var statearr_16994_17041 = state_16973__$1;
(statearr_16994_17041[(2)] = null);

(statearr_16994_17041[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (3))){
var inst_16971 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16973__$1,inst_16971);
} else {
if((state_val_16974 === (12))){
var inst_16948 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_16995_17042 = state_16973__$1;
(statearr_16995_17042[(2)] = inst_16948);

(statearr_16995_17042[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (2))){
var state_16973__$1 = state_16973;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16973__$1,(4),ch);
} else {
if((state_val_16974 === (23))){
var state_16973__$1 = state_16973;
var statearr_16996_17043 = state_16973__$1;
(statearr_16996_17043[(2)] = null);

(statearr_16996_17043[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (19))){
var inst_16954 = (state_16973[(11)]);
var inst_16904 = (state_16973[(8)]);
var inst_16956 = cljs.core.async.muxch_STAR_(inst_16954);
var state_16973__$1 = state_16973;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_16973__$1,(22),inst_16956,inst_16904);
} else {
if((state_val_16974 === (11))){
var inst_16928 = (state_16973[(10)]);
var inst_16914 = (state_16973[(16)]);
var inst_16928__$1 = cljs.core.seq(inst_16914);
var state_16973__$1 = (function (){var statearr_16997 = state_16973;
(statearr_16997[(10)] = inst_16928__$1);

return statearr_16997;
})();
if(inst_16928__$1){
var statearr_16998_17044 = state_16973__$1;
(statearr_16998_17044[(1)] = (13));

} else {
var statearr_16999_17045 = state_16973__$1;
(statearr_16999_17045[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (9))){
var inst_16950 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_17000_17046 = state_16973__$1;
(statearr_17000_17046[(2)] = inst_16950);

(statearr_17000_17046[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (5))){
var inst_16911 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_16912 = cljs.core.vals(inst_16911);
var inst_16913 = cljs.core.seq(inst_16912);
var inst_16914 = inst_16913;
var inst_16915 = null;
var inst_16916 = (0);
var inst_16917 = (0);
var state_16973__$1 = (function (){var statearr_17001 = state_16973;
(statearr_17001[(12)] = inst_16916);

(statearr_17001[(13)] = inst_16917);

(statearr_17001[(14)] = inst_16915);

(statearr_17001[(16)] = inst_16914);

return statearr_17001;
})();
var statearr_17002_17047 = state_16973__$1;
(statearr_17002_17047[(2)] = null);

(statearr_17002_17047[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (14))){
var state_16973__$1 = state_16973;
var statearr_17006_17048 = state_16973__$1;
(statearr_17006_17048[(2)] = null);

(statearr_17006_17048[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (16))){
var inst_16928 = (state_16973[(10)]);
var inst_16932 = cljs.core.chunk_first(inst_16928);
var inst_16933 = cljs.core.chunk_rest(inst_16928);
var inst_16934 = cljs.core.count(inst_16932);
var inst_16914 = inst_16933;
var inst_16915 = inst_16932;
var inst_16916 = inst_16934;
var inst_16917 = (0);
var state_16973__$1 = (function (){var statearr_17007 = state_16973;
(statearr_17007[(12)] = inst_16916);

(statearr_17007[(13)] = inst_16917);

(statearr_17007[(14)] = inst_16915);

(statearr_17007[(16)] = inst_16914);

return statearr_17007;
})();
var statearr_17008_17049 = state_16973__$1;
(statearr_17008_17049[(2)] = null);

(statearr_17008_17049[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (10))){
var inst_16916 = (state_16973[(12)]);
var inst_16917 = (state_16973[(13)]);
var inst_16915 = (state_16973[(14)]);
var inst_16914 = (state_16973[(16)]);
var inst_16922 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_16915,inst_16917);
var inst_16923 = cljs.core.async.muxch_STAR_(inst_16922);
var inst_16924 = cljs.core.async.close_BANG_(inst_16923);
var inst_16925 = (inst_16917 + (1));
var tmp17003 = inst_16916;
var tmp17004 = inst_16915;
var tmp17005 = inst_16914;
var inst_16914__$1 = tmp17005;
var inst_16915__$1 = tmp17004;
var inst_16916__$1 = tmp17003;
var inst_16917__$1 = inst_16925;
var state_16973__$1 = (function (){var statearr_17009 = state_16973;
(statearr_17009[(17)] = inst_16924);

(statearr_17009[(12)] = inst_16916__$1);

(statearr_17009[(13)] = inst_16917__$1);

(statearr_17009[(14)] = inst_16915__$1);

(statearr_17009[(16)] = inst_16914__$1);

return statearr_17009;
})();
var statearr_17010_17050 = state_16973__$1;
(statearr_17010_17050[(2)] = null);

(statearr_17010_17050[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (18))){
var inst_16943 = (state_16973[(2)]);
var state_16973__$1 = state_16973;
var statearr_17011_17051 = state_16973__$1;
(statearr_17011_17051[(2)] = inst_16943);

(statearr_17011_17051[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_16974 === (8))){
var inst_16916 = (state_16973[(12)]);
var inst_16917 = (state_16973[(13)]);
var inst_16919 = (inst_16917 < inst_16916);
var inst_16920 = inst_16919;
var state_16973__$1 = state_16973;
if(cljs.core.truth_(inst_16920)){
var statearr_17012_17052 = state_16973__$1;
(statearr_17012_17052[(1)] = (10));

} else {
var statearr_17013_17053 = state_16973__$1;
(statearr_17013_17053[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17025,mults,ensure_mult,p))
;
return ((function (switch__14923__auto__,c__15047__auto___17025,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17017 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17017[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17017[(1)] = (1));

return statearr_17017;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_16973){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_16973);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17018){if((e17018 instanceof Object)){
var ex__14927__auto__ = e17018;
var statearr_17019_17054 = state_16973;
(statearr_17019_17054[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_16973);

return cljs.core.cst$kw$recur;
} else {
throw e17018;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17055 = state_16973;
state_16973 = G__17055;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_16973){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_16973);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17025,mults,ensure_mult,p))
})();
var state__15049__auto__ = (function (){var statearr_17020 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17020[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17025);

return statearr_17020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17025,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args17056 = [];
var len__8402__auto___17059 = arguments.length;
var i__8403__auto___17060 = (0);
while(true){
if((i__8403__auto___17060 < len__8402__auto___17059)){
args17056.push((arguments[i__8403__auto___17060]));

var G__17061 = (i__8403__auto___17060 + (1));
i__8403__auto___17060 = G__17061;
continue;
} else {
}
break;
}

var G__17058 = args17056.length;
switch (G__17058) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17056.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args17063 = [];
var len__8402__auto___17066 = arguments.length;
var i__8403__auto___17067 = (0);
while(true){
if((i__8403__auto___17067 < len__8402__auto___17066)){
args17063.push((arguments[i__8403__auto___17067]));

var G__17068 = (i__8403__auto___17067 + (1));
i__8403__auto___17067 = G__17068;
continue;
} else {
}
break;
}

var G__17065 = args17063.length;
switch (G__17065) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17063.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args17070 = [];
var len__8402__auto___17141 = arguments.length;
var i__8403__auto___17142 = (0);
while(true){
if((i__8403__auto___17142 < len__8402__auto___17141)){
args17070.push((arguments[i__8403__auto___17142]));

var G__17143 = (i__8403__auto___17142 + (1));
i__8403__auto___17142 = G__17143;
continue;
} else {
}
break;
}

var G__17072 = args17070.length;
switch (G__17072) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17070.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__15047__auto___17145 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_17111){
var state_val_17112 = (state_17111[(1)]);
if((state_val_17112 === (7))){
var state_17111__$1 = state_17111;
var statearr_17113_17146 = state_17111__$1;
(statearr_17113_17146[(2)] = null);

(statearr_17113_17146[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (1))){
var state_17111__$1 = state_17111;
var statearr_17114_17147 = state_17111__$1;
(statearr_17114_17147[(2)] = null);

(statearr_17114_17147[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (4))){
var inst_17075 = (state_17111[(7)]);
var inst_17077 = (inst_17075 < cnt);
var state_17111__$1 = state_17111;
if(cljs.core.truth_(inst_17077)){
var statearr_17115_17148 = state_17111__$1;
(statearr_17115_17148[(1)] = (6));

} else {
var statearr_17116_17149 = state_17111__$1;
(statearr_17116_17149[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (15))){
var inst_17107 = (state_17111[(2)]);
var state_17111__$1 = state_17111;
var statearr_17117_17150 = state_17111__$1;
(statearr_17117_17150[(2)] = inst_17107);

(statearr_17117_17150[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (13))){
var inst_17100 = cljs.core.async.close_BANG_(out);
var state_17111__$1 = state_17111;
var statearr_17118_17151 = state_17111__$1;
(statearr_17118_17151[(2)] = inst_17100);

(statearr_17118_17151[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (6))){
var state_17111__$1 = state_17111;
var statearr_17119_17152 = state_17111__$1;
(statearr_17119_17152[(2)] = null);

(statearr_17119_17152[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (3))){
var inst_17109 = (state_17111[(2)]);
var state_17111__$1 = state_17111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17111__$1,inst_17109);
} else {
if((state_val_17112 === (12))){
var inst_17097 = (state_17111[(8)]);
var inst_17097__$1 = (state_17111[(2)]);
var inst_17098 = cljs.core.some(cljs.core.nil_QMARK_,inst_17097__$1);
var state_17111__$1 = (function (){var statearr_17120 = state_17111;
(statearr_17120[(8)] = inst_17097__$1);

return statearr_17120;
})();
if(cljs.core.truth_(inst_17098)){
var statearr_17121_17153 = state_17111__$1;
(statearr_17121_17153[(1)] = (13));

} else {
var statearr_17122_17154 = state_17111__$1;
(statearr_17122_17154[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (2))){
var inst_17074 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_17075 = (0);
var state_17111__$1 = (function (){var statearr_17123 = state_17111;
(statearr_17123[(9)] = inst_17074);

(statearr_17123[(7)] = inst_17075);

return statearr_17123;
})();
var statearr_17124_17155 = state_17111__$1;
(statearr_17124_17155[(2)] = null);

(statearr_17124_17155[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (11))){
var inst_17075 = (state_17111[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_17111,(10),Object,null,(9));
var inst_17084 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_17075) : chs__$1.call(null,inst_17075));
var inst_17085 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_17075) : done.call(null,inst_17075));
var inst_17086 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_17084,inst_17085);
var state_17111__$1 = state_17111;
var statearr_17125_17156 = state_17111__$1;
(statearr_17125_17156[(2)] = inst_17086);


cljs.core.async.impl.ioc_helpers.process_exception(state_17111__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (9))){
var inst_17075 = (state_17111[(7)]);
var inst_17088 = (state_17111[(2)]);
var inst_17089 = (inst_17075 + (1));
var inst_17075__$1 = inst_17089;
var state_17111__$1 = (function (){var statearr_17126 = state_17111;
(statearr_17126[(7)] = inst_17075__$1);

(statearr_17126[(10)] = inst_17088);

return statearr_17126;
})();
var statearr_17127_17157 = state_17111__$1;
(statearr_17127_17157[(2)] = null);

(statearr_17127_17157[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (5))){
var inst_17095 = (state_17111[(2)]);
var state_17111__$1 = (function (){var statearr_17128 = state_17111;
(statearr_17128[(11)] = inst_17095);

return statearr_17128;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17111__$1,(12),dchan);
} else {
if((state_val_17112 === (14))){
var inst_17097 = (state_17111[(8)]);
var inst_17102 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_17097);
var state_17111__$1 = state_17111;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17111__$1,(16),out,inst_17102);
} else {
if((state_val_17112 === (16))){
var inst_17104 = (state_17111[(2)]);
var state_17111__$1 = (function (){var statearr_17129 = state_17111;
(statearr_17129[(12)] = inst_17104);

return statearr_17129;
})();
var statearr_17130_17158 = state_17111__$1;
(statearr_17130_17158[(2)] = null);

(statearr_17130_17158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (10))){
var inst_17079 = (state_17111[(2)]);
var inst_17080 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_17111__$1 = (function (){var statearr_17131 = state_17111;
(statearr_17131[(13)] = inst_17079);

return statearr_17131;
})();
var statearr_17132_17159 = state_17111__$1;
(statearr_17132_17159[(2)] = inst_17080);


cljs.core.async.impl.ioc_helpers.process_exception(state_17111__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_17112 === (8))){
var inst_17093 = (state_17111[(2)]);
var state_17111__$1 = state_17111;
var statearr_17133_17160 = state_17111__$1;
(statearr_17133_17160[(2)] = inst_17093);

(statearr_17133_17160[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__14923__auto__,c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17137 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17137[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17137[(1)] = (1));

return statearr_17137;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17111){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17111);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17138){if((e17138 instanceof Object)){
var ex__14927__auto__ = e17138;
var statearr_17139_17161 = state_17111;
(statearr_17139_17161[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17111);

return cljs.core.cst$kw$recur;
} else {
throw e17138;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17162 = state_17111;
state_17111 = G__17162;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17111){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17111);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__15049__auto__ = (function (){var statearr_17140 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17140[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17145);

return statearr_17140;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17145,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args17164 = [];
var len__8402__auto___17222 = arguments.length;
var i__8403__auto___17223 = (0);
while(true){
if((i__8403__auto___17223 < len__8402__auto___17222)){
args17164.push((arguments[i__8403__auto___17223]));

var G__17224 = (i__8403__auto___17223 + (1));
i__8403__auto___17223 = G__17224;
continue;
} else {
}
break;
}

var G__17166 = args17164.length;
switch (G__17166) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17164.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17226 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17226,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17226,out){
return (function (state_17198){
var state_val_17199 = (state_17198[(1)]);
if((state_val_17199 === (7))){
var inst_17177 = (state_17198[(7)]);
var inst_17178 = (state_17198[(8)]);
var inst_17177__$1 = (state_17198[(2)]);
var inst_17178__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17177__$1,(0),null);
var inst_17179 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_17177__$1,(1),null);
var inst_17180 = (inst_17178__$1 == null);
var state_17198__$1 = (function (){var statearr_17200 = state_17198;
(statearr_17200[(7)] = inst_17177__$1);

(statearr_17200[(8)] = inst_17178__$1);

(statearr_17200[(9)] = inst_17179);

return statearr_17200;
})();
if(cljs.core.truth_(inst_17180)){
var statearr_17201_17227 = state_17198__$1;
(statearr_17201_17227[(1)] = (8));

} else {
var statearr_17202_17228 = state_17198__$1;
(statearr_17202_17228[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (1))){
var inst_17167 = cljs.core.vec(chs);
var inst_17168 = inst_17167;
var state_17198__$1 = (function (){var statearr_17203 = state_17198;
(statearr_17203[(10)] = inst_17168);

return statearr_17203;
})();
var statearr_17204_17229 = state_17198__$1;
(statearr_17204_17229[(2)] = null);

(statearr_17204_17229[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (4))){
var inst_17168 = (state_17198[(10)]);
var state_17198__$1 = state_17198;
return cljs.core.async.ioc_alts_BANG_(state_17198__$1,(7),inst_17168);
} else {
if((state_val_17199 === (6))){
var inst_17194 = (state_17198[(2)]);
var state_17198__$1 = state_17198;
var statearr_17205_17230 = state_17198__$1;
(statearr_17205_17230[(2)] = inst_17194);

(statearr_17205_17230[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (3))){
var inst_17196 = (state_17198[(2)]);
var state_17198__$1 = state_17198;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17198__$1,inst_17196);
} else {
if((state_val_17199 === (2))){
var inst_17168 = (state_17198[(10)]);
var inst_17170 = cljs.core.count(inst_17168);
var inst_17171 = (inst_17170 > (0));
var state_17198__$1 = state_17198;
if(cljs.core.truth_(inst_17171)){
var statearr_17207_17231 = state_17198__$1;
(statearr_17207_17231[(1)] = (4));

} else {
var statearr_17208_17232 = state_17198__$1;
(statearr_17208_17232[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (11))){
var inst_17168 = (state_17198[(10)]);
var inst_17187 = (state_17198[(2)]);
var tmp17206 = inst_17168;
var inst_17168__$1 = tmp17206;
var state_17198__$1 = (function (){var statearr_17209 = state_17198;
(statearr_17209[(11)] = inst_17187);

(statearr_17209[(10)] = inst_17168__$1);

return statearr_17209;
})();
var statearr_17210_17233 = state_17198__$1;
(statearr_17210_17233[(2)] = null);

(statearr_17210_17233[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (9))){
var inst_17178 = (state_17198[(8)]);
var state_17198__$1 = state_17198;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17198__$1,(11),out,inst_17178);
} else {
if((state_val_17199 === (5))){
var inst_17192 = cljs.core.async.close_BANG_(out);
var state_17198__$1 = state_17198;
var statearr_17211_17234 = state_17198__$1;
(statearr_17211_17234[(2)] = inst_17192);

(statearr_17211_17234[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (10))){
var inst_17190 = (state_17198[(2)]);
var state_17198__$1 = state_17198;
var statearr_17212_17235 = state_17198__$1;
(statearr_17212_17235[(2)] = inst_17190);

(statearr_17212_17235[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17199 === (8))){
var inst_17177 = (state_17198[(7)]);
var inst_17178 = (state_17198[(8)]);
var inst_17168 = (state_17198[(10)]);
var inst_17179 = (state_17198[(9)]);
var inst_17182 = (function (){var cs = inst_17168;
var vec__17173 = inst_17177;
var v = inst_17178;
var c = inst_17179;
return ((function (cs,vec__17173,v,c,inst_17177,inst_17178,inst_17168,inst_17179,state_val_17199,c__15047__auto___17226,out){
return (function (p1__17163_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__17163_SHARP_);
});
;})(cs,vec__17173,v,c,inst_17177,inst_17178,inst_17168,inst_17179,state_val_17199,c__15047__auto___17226,out))
})();
var inst_17183 = cljs.core.filterv(inst_17182,inst_17168);
var inst_17168__$1 = inst_17183;
var state_17198__$1 = (function (){var statearr_17213 = state_17198;
(statearr_17213[(10)] = inst_17168__$1);

return statearr_17213;
})();
var statearr_17214_17236 = state_17198__$1;
(statearr_17214_17236[(2)] = null);

(statearr_17214_17236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17226,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17226,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17218 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17218[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17218[(1)] = (1));

return statearr_17218;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17198){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17198);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17219){if((e17219 instanceof Object)){
var ex__14927__auto__ = e17219;
var statearr_17220_17237 = state_17198;
(statearr_17220_17237[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17198);

return cljs.core.cst$kw$recur;
} else {
throw e17219;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17238 = state_17198;
state_17198 = G__17238;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17198){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17198);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17226,out))
})();
var state__15049__auto__ = (function (){var statearr_17221 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17221[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17226);

return statearr_17221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17226,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args17239 = [];
var len__8402__auto___17288 = arguments.length;
var i__8403__auto___17289 = (0);
while(true){
if((i__8403__auto___17289 < len__8402__auto___17288)){
args17239.push((arguments[i__8403__auto___17289]));

var G__17290 = (i__8403__auto___17289 + (1));
i__8403__auto___17289 = G__17290;
continue;
} else {
}
break;
}

var G__17241 = args17239.length;
switch (G__17241) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17239.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17292 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17292,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17292,out){
return (function (state_17265){
var state_val_17266 = (state_17265[(1)]);
if((state_val_17266 === (7))){
var inst_17247 = (state_17265[(7)]);
var inst_17247__$1 = (state_17265[(2)]);
var inst_17248 = (inst_17247__$1 == null);
var inst_17249 = cljs.core.not(inst_17248);
var state_17265__$1 = (function (){var statearr_17267 = state_17265;
(statearr_17267[(7)] = inst_17247__$1);

return statearr_17267;
})();
if(inst_17249){
var statearr_17268_17293 = state_17265__$1;
(statearr_17268_17293[(1)] = (8));

} else {
var statearr_17269_17294 = state_17265__$1;
(statearr_17269_17294[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (1))){
var inst_17242 = (0);
var state_17265__$1 = (function (){var statearr_17270 = state_17265;
(statearr_17270[(8)] = inst_17242);

return statearr_17270;
})();
var statearr_17271_17295 = state_17265__$1;
(statearr_17271_17295[(2)] = null);

(statearr_17271_17295[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (4))){
var state_17265__$1 = state_17265;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17265__$1,(7),ch);
} else {
if((state_val_17266 === (6))){
var inst_17260 = (state_17265[(2)]);
var state_17265__$1 = state_17265;
var statearr_17272_17296 = state_17265__$1;
(statearr_17272_17296[(2)] = inst_17260);

(statearr_17272_17296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (3))){
var inst_17262 = (state_17265[(2)]);
var inst_17263 = cljs.core.async.close_BANG_(out);
var state_17265__$1 = (function (){var statearr_17273 = state_17265;
(statearr_17273[(9)] = inst_17262);

return statearr_17273;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17265__$1,inst_17263);
} else {
if((state_val_17266 === (2))){
var inst_17242 = (state_17265[(8)]);
var inst_17244 = (inst_17242 < n);
var state_17265__$1 = state_17265;
if(cljs.core.truth_(inst_17244)){
var statearr_17274_17297 = state_17265__$1;
(statearr_17274_17297[(1)] = (4));

} else {
var statearr_17275_17298 = state_17265__$1;
(statearr_17275_17298[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (11))){
var inst_17242 = (state_17265[(8)]);
var inst_17252 = (state_17265[(2)]);
var inst_17253 = (inst_17242 + (1));
var inst_17242__$1 = inst_17253;
var state_17265__$1 = (function (){var statearr_17276 = state_17265;
(statearr_17276[(8)] = inst_17242__$1);

(statearr_17276[(10)] = inst_17252);

return statearr_17276;
})();
var statearr_17277_17299 = state_17265__$1;
(statearr_17277_17299[(2)] = null);

(statearr_17277_17299[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (9))){
var state_17265__$1 = state_17265;
var statearr_17278_17300 = state_17265__$1;
(statearr_17278_17300[(2)] = null);

(statearr_17278_17300[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (5))){
var state_17265__$1 = state_17265;
var statearr_17279_17301 = state_17265__$1;
(statearr_17279_17301[(2)] = null);

(statearr_17279_17301[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (10))){
var inst_17257 = (state_17265[(2)]);
var state_17265__$1 = state_17265;
var statearr_17280_17302 = state_17265__$1;
(statearr_17280_17302[(2)] = inst_17257);

(statearr_17280_17302[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17266 === (8))){
var inst_17247 = (state_17265[(7)]);
var state_17265__$1 = state_17265;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17265__$1,(11),out,inst_17247);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17292,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17292,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17284 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17284[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17284[(1)] = (1));

return statearr_17284;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17265){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17265);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17285){if((e17285 instanceof Object)){
var ex__14927__auto__ = e17285;
var statearr_17286_17303 = state_17265;
(statearr_17286_17303[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17265);

return cljs.core.cst$kw$recur;
} else {
throw e17285;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17304 = state_17265;
state_17265 = G__17304;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17265){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17265);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17292,out))
})();
var state__15049__auto__ = (function (){var statearr_17287 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17287[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17292);

return statearr_17287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17292,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17314 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17314 = (function (f,ch,meta17315){
this.f = f;
this.ch = ch;
this.meta17315 = meta17315;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17316,meta17315__$1){
var self__ = this;
var _17316__$1 = this;
return (new cljs.core.async.t_cljs$core$async17314(self__.f,self__.ch,meta17315__$1));
});

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17316){
var self__ = this;
var _17316__$1 = this;
return self__.meta17315;
});

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async17317 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17317 = (function (f,ch,meta17315,_,fn1,meta17318){
this.f = f;
this.ch = ch;
this.meta17315 = meta17315;
this._ = _;
this.fn1 = fn1;
this.meta17318 = meta17318;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_17319,meta17318__$1){
var self__ = this;
var _17319__$1 = this;
return (new cljs.core.async.t_cljs$core$async17317(self__.f,self__.ch,self__.meta17315,self__._,self__.fn1,meta17318__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_17319){
var self__ = this;
var _17319__$1 = this;
return self__.meta17318;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__17305_SHARP_){
var G__17320 = (((p1__17305_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__17305_SHARP_) : self__.f.call(null,p1__17305_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__17320) : f1.call(null,G__17320));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17315,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async17314], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta17318], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async17317.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17317.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17317";

cljs.core.async.t_cljs$core$async17317.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17317");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async17317 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17317(f__$1,ch__$1,meta17315__$1,___$2,fn1__$1,meta17318){
return (new cljs.core.async.t_cljs$core$async17317(f__$1,ch__$1,meta17315__$1,___$2,fn1__$1,meta17318));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async17317(self__.f,self__.ch,self__.meta17315,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__7277__auto__ = ret;
if(cljs.core.truth_(and__7277__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__7277__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__17321 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__17321) : self__.f.call(null,G__17321));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17314.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async17314.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17315], null);
});

cljs.core.async.t_cljs$core$async17314.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17314.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17314";

cljs.core.async.t_cljs$core$async17314.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17314");
});

cljs.core.async.__GT_t_cljs$core$async17314 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async17314(f__$1,ch__$1,meta17315){
return (new cljs.core.async.t_cljs$core$async17314(f__$1,ch__$1,meta17315));
});

}

return (new cljs.core.async.t_cljs$core$async17314(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async17325 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17325 = (function (f,ch,meta17326){
this.f = f;
this.ch = ch;
this.meta17326 = meta17326;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17327,meta17326__$1){
var self__ = this;
var _17327__$1 = this;
return (new cljs.core.async.t_cljs$core$async17325(self__.f,self__.ch,meta17326__$1));
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17327){
var self__ = this;
var _17327__$1 = this;
return self__.meta17326;
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17325.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async17325.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17326], null);
});

cljs.core.async.t_cljs$core$async17325.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17325.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17325";

cljs.core.async.t_cljs$core$async17325.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17325");
});

cljs.core.async.__GT_t_cljs$core$async17325 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async17325(f__$1,ch__$1,meta17326){
return (new cljs.core.async.t_cljs$core$async17325(f__$1,ch__$1,meta17326));
});

}

return (new cljs.core.async.t_cljs$core$async17325(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async17331 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17331 = (function (p,ch,meta17332){
this.p = p;
this.ch = ch;
this.meta17332 = meta17332;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_17333,meta17332__$1){
var self__ = this;
var _17333__$1 = this;
return (new cljs.core.async.t_cljs$core$async17331(self__.p,self__.ch,meta17332__$1));
});

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_17333){
var self__ = this;
var _17333__$1 = this;
return self__.meta17332;
});

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async17331.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async17331.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta17332], null);
});

cljs.core.async.t_cljs$core$async17331.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17331.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17331";

cljs.core.async.t_cljs$core$async17331.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async/t_cljs$core$async17331");
});

cljs.core.async.__GT_t_cljs$core$async17331 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async17331(p__$1,ch__$1,meta17332){
return (new cljs.core.async.t_cljs$core$async17331(p__$1,ch__$1,meta17332));
});

}

return (new cljs.core.async.t_cljs$core$async17331(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args17334 = [];
var len__8402__auto___17378 = arguments.length;
var i__8403__auto___17379 = (0);
while(true){
if((i__8403__auto___17379 < len__8402__auto___17378)){
args17334.push((arguments[i__8403__auto___17379]));

var G__17380 = (i__8403__auto___17379 + (1));
i__8403__auto___17379 = G__17380;
continue;
} else {
}
break;
}

var G__17336 = args17334.length;
switch (G__17336) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17334.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17382 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17382,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17382,out){
return (function (state_17357){
var state_val_17358 = (state_17357[(1)]);
if((state_val_17358 === (7))){
var inst_17353 = (state_17357[(2)]);
var state_17357__$1 = state_17357;
var statearr_17359_17383 = state_17357__$1;
(statearr_17359_17383[(2)] = inst_17353);

(statearr_17359_17383[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (1))){
var state_17357__$1 = state_17357;
var statearr_17360_17384 = state_17357__$1;
(statearr_17360_17384[(2)] = null);

(statearr_17360_17384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (4))){
var inst_17339 = (state_17357[(7)]);
var inst_17339__$1 = (state_17357[(2)]);
var inst_17340 = (inst_17339__$1 == null);
var state_17357__$1 = (function (){var statearr_17361 = state_17357;
(statearr_17361[(7)] = inst_17339__$1);

return statearr_17361;
})();
if(cljs.core.truth_(inst_17340)){
var statearr_17362_17385 = state_17357__$1;
(statearr_17362_17385[(1)] = (5));

} else {
var statearr_17363_17386 = state_17357__$1;
(statearr_17363_17386[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (6))){
var inst_17339 = (state_17357[(7)]);
var inst_17344 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_17339) : p.call(null,inst_17339));
var state_17357__$1 = state_17357;
if(cljs.core.truth_(inst_17344)){
var statearr_17364_17387 = state_17357__$1;
(statearr_17364_17387[(1)] = (8));

} else {
var statearr_17365_17388 = state_17357__$1;
(statearr_17365_17388[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (3))){
var inst_17355 = (state_17357[(2)]);
var state_17357__$1 = state_17357;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17357__$1,inst_17355);
} else {
if((state_val_17358 === (2))){
var state_17357__$1 = state_17357;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17357__$1,(4),ch);
} else {
if((state_val_17358 === (11))){
var inst_17347 = (state_17357[(2)]);
var state_17357__$1 = state_17357;
var statearr_17366_17389 = state_17357__$1;
(statearr_17366_17389[(2)] = inst_17347);

(statearr_17366_17389[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (9))){
var state_17357__$1 = state_17357;
var statearr_17367_17390 = state_17357__$1;
(statearr_17367_17390[(2)] = null);

(statearr_17367_17390[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (5))){
var inst_17342 = cljs.core.async.close_BANG_(out);
var state_17357__$1 = state_17357;
var statearr_17368_17391 = state_17357__$1;
(statearr_17368_17391[(2)] = inst_17342);

(statearr_17368_17391[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (10))){
var inst_17350 = (state_17357[(2)]);
var state_17357__$1 = (function (){var statearr_17369 = state_17357;
(statearr_17369[(8)] = inst_17350);

return statearr_17369;
})();
var statearr_17370_17392 = state_17357__$1;
(statearr_17370_17392[(2)] = null);

(statearr_17370_17392[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17358 === (8))){
var inst_17339 = (state_17357[(7)]);
var state_17357__$1 = state_17357;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17357__$1,(11),out,inst_17339);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17382,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17382,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17374 = [null,null,null,null,null,null,null,null,null];
(statearr_17374[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17374[(1)] = (1));

return statearr_17374;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17357){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17357);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17375){if((e17375 instanceof Object)){
var ex__14927__auto__ = e17375;
var statearr_17376_17393 = state_17357;
(statearr_17376_17393[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17357);

return cljs.core.cst$kw$recur;
} else {
throw e17375;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17394 = state_17357;
state_17357 = G__17394;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17357){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17357);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17382,out))
})();
var state__15049__auto__ = (function (){var statearr_17377 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17377[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17382);

return statearr_17377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17382,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args17395 = [];
var len__8402__auto___17398 = arguments.length;
var i__8403__auto___17399 = (0);
while(true){
if((i__8403__auto___17399 < len__8402__auto___17398)){
args17395.push((arguments[i__8403__auto___17399]));

var G__17400 = (i__8403__auto___17399 + (1));
i__8403__auto___17399 = G__17400;
continue;
} else {
}
break;
}

var G__17397 = args17395.length;
switch (G__17397) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17395.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__15047__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto__){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto__){
return (function (state_17567){
var state_val_17568 = (state_17567[(1)]);
if((state_val_17568 === (7))){
var inst_17563 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
var statearr_17569_17610 = state_17567__$1;
(statearr_17569_17610[(2)] = inst_17563);

(statearr_17569_17610[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (20))){
var inst_17533 = (state_17567[(7)]);
var inst_17544 = (state_17567[(2)]);
var inst_17545 = cljs.core.next(inst_17533);
var inst_17519 = inst_17545;
var inst_17520 = null;
var inst_17521 = (0);
var inst_17522 = (0);
var state_17567__$1 = (function (){var statearr_17570 = state_17567;
(statearr_17570[(8)] = inst_17520);

(statearr_17570[(9)] = inst_17522);

(statearr_17570[(10)] = inst_17544);

(statearr_17570[(11)] = inst_17521);

(statearr_17570[(12)] = inst_17519);

return statearr_17570;
})();
var statearr_17571_17611 = state_17567__$1;
(statearr_17571_17611[(2)] = null);

(statearr_17571_17611[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (1))){
var state_17567__$1 = state_17567;
var statearr_17572_17612 = state_17567__$1;
(statearr_17572_17612[(2)] = null);

(statearr_17572_17612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (4))){
var inst_17508 = (state_17567[(13)]);
var inst_17508__$1 = (state_17567[(2)]);
var inst_17509 = (inst_17508__$1 == null);
var state_17567__$1 = (function (){var statearr_17573 = state_17567;
(statearr_17573[(13)] = inst_17508__$1);

return statearr_17573;
})();
if(cljs.core.truth_(inst_17509)){
var statearr_17574_17613 = state_17567__$1;
(statearr_17574_17613[(1)] = (5));

} else {
var statearr_17575_17614 = state_17567__$1;
(statearr_17575_17614[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (15))){
var state_17567__$1 = state_17567;
var statearr_17579_17615 = state_17567__$1;
(statearr_17579_17615[(2)] = null);

(statearr_17579_17615[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (21))){
var state_17567__$1 = state_17567;
var statearr_17580_17616 = state_17567__$1;
(statearr_17580_17616[(2)] = null);

(statearr_17580_17616[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (13))){
var inst_17520 = (state_17567[(8)]);
var inst_17522 = (state_17567[(9)]);
var inst_17521 = (state_17567[(11)]);
var inst_17519 = (state_17567[(12)]);
var inst_17529 = (state_17567[(2)]);
var inst_17530 = (inst_17522 + (1));
var tmp17576 = inst_17520;
var tmp17577 = inst_17521;
var tmp17578 = inst_17519;
var inst_17519__$1 = tmp17578;
var inst_17520__$1 = tmp17576;
var inst_17521__$1 = tmp17577;
var inst_17522__$1 = inst_17530;
var state_17567__$1 = (function (){var statearr_17581 = state_17567;
(statearr_17581[(14)] = inst_17529);

(statearr_17581[(8)] = inst_17520__$1);

(statearr_17581[(9)] = inst_17522__$1);

(statearr_17581[(11)] = inst_17521__$1);

(statearr_17581[(12)] = inst_17519__$1);

return statearr_17581;
})();
var statearr_17582_17617 = state_17567__$1;
(statearr_17582_17617[(2)] = null);

(statearr_17582_17617[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (22))){
var state_17567__$1 = state_17567;
var statearr_17583_17618 = state_17567__$1;
(statearr_17583_17618[(2)] = null);

(statearr_17583_17618[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (6))){
var inst_17508 = (state_17567[(13)]);
var inst_17517 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17508) : f.call(null,inst_17508));
var inst_17518 = cljs.core.seq(inst_17517);
var inst_17519 = inst_17518;
var inst_17520 = null;
var inst_17521 = (0);
var inst_17522 = (0);
var state_17567__$1 = (function (){var statearr_17584 = state_17567;
(statearr_17584[(8)] = inst_17520);

(statearr_17584[(9)] = inst_17522);

(statearr_17584[(11)] = inst_17521);

(statearr_17584[(12)] = inst_17519);

return statearr_17584;
})();
var statearr_17585_17619 = state_17567__$1;
(statearr_17585_17619[(2)] = null);

(statearr_17585_17619[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (17))){
var inst_17533 = (state_17567[(7)]);
var inst_17537 = cljs.core.chunk_first(inst_17533);
var inst_17538 = cljs.core.chunk_rest(inst_17533);
var inst_17539 = cljs.core.count(inst_17537);
var inst_17519 = inst_17538;
var inst_17520 = inst_17537;
var inst_17521 = inst_17539;
var inst_17522 = (0);
var state_17567__$1 = (function (){var statearr_17586 = state_17567;
(statearr_17586[(8)] = inst_17520);

(statearr_17586[(9)] = inst_17522);

(statearr_17586[(11)] = inst_17521);

(statearr_17586[(12)] = inst_17519);

return statearr_17586;
})();
var statearr_17587_17620 = state_17567__$1;
(statearr_17587_17620[(2)] = null);

(statearr_17587_17620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (3))){
var inst_17565 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17567__$1,inst_17565);
} else {
if((state_val_17568 === (12))){
var inst_17553 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
var statearr_17588_17621 = state_17567__$1;
(statearr_17588_17621[(2)] = inst_17553);

(statearr_17588_17621[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (2))){
var state_17567__$1 = state_17567;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17567__$1,(4),in$);
} else {
if((state_val_17568 === (23))){
var inst_17561 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
var statearr_17589_17622 = state_17567__$1;
(statearr_17589_17622[(2)] = inst_17561);

(statearr_17589_17622[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (19))){
var inst_17548 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
var statearr_17590_17623 = state_17567__$1;
(statearr_17590_17623[(2)] = inst_17548);

(statearr_17590_17623[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (11))){
var inst_17533 = (state_17567[(7)]);
var inst_17519 = (state_17567[(12)]);
var inst_17533__$1 = cljs.core.seq(inst_17519);
var state_17567__$1 = (function (){var statearr_17591 = state_17567;
(statearr_17591[(7)] = inst_17533__$1);

return statearr_17591;
})();
if(inst_17533__$1){
var statearr_17592_17624 = state_17567__$1;
(statearr_17592_17624[(1)] = (14));

} else {
var statearr_17593_17625 = state_17567__$1;
(statearr_17593_17625[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (9))){
var inst_17555 = (state_17567[(2)]);
var inst_17556 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_17567__$1 = (function (){var statearr_17594 = state_17567;
(statearr_17594[(15)] = inst_17555);

return statearr_17594;
})();
if(cljs.core.truth_(inst_17556)){
var statearr_17595_17626 = state_17567__$1;
(statearr_17595_17626[(1)] = (21));

} else {
var statearr_17596_17627 = state_17567__$1;
(statearr_17596_17627[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (5))){
var inst_17511 = cljs.core.async.close_BANG_(out);
var state_17567__$1 = state_17567;
var statearr_17597_17628 = state_17567__$1;
(statearr_17597_17628[(2)] = inst_17511);

(statearr_17597_17628[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (14))){
var inst_17533 = (state_17567[(7)]);
var inst_17535 = cljs.core.chunked_seq_QMARK_(inst_17533);
var state_17567__$1 = state_17567;
if(inst_17535){
var statearr_17598_17629 = state_17567__$1;
(statearr_17598_17629[(1)] = (17));

} else {
var statearr_17599_17630 = state_17567__$1;
(statearr_17599_17630[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (16))){
var inst_17551 = (state_17567[(2)]);
var state_17567__$1 = state_17567;
var statearr_17600_17631 = state_17567__$1;
(statearr_17600_17631[(2)] = inst_17551);

(statearr_17600_17631[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17568 === (10))){
var inst_17520 = (state_17567[(8)]);
var inst_17522 = (state_17567[(9)]);
var inst_17527 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_17520,inst_17522);
var state_17567__$1 = state_17567;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17567__$1,(13),out,inst_17527);
} else {
if((state_val_17568 === (18))){
var inst_17533 = (state_17567[(7)]);
var inst_17542 = cljs.core.first(inst_17533);
var state_17567__$1 = state_17567;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17567__$1,(20),out,inst_17542);
} else {
if((state_val_17568 === (8))){
var inst_17522 = (state_17567[(9)]);
var inst_17521 = (state_17567[(11)]);
var inst_17524 = (inst_17522 < inst_17521);
var inst_17525 = inst_17524;
var state_17567__$1 = state_17567;
if(cljs.core.truth_(inst_17525)){
var statearr_17601_17632 = state_17567__$1;
(statearr_17601_17632[(1)] = (10));

} else {
var statearr_17602_17633 = state_17567__$1;
(statearr_17602_17633[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto__))
;
return ((function (switch__14923__auto__,c__15047__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____0 = (function (){
var statearr_17606 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17606[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__);

(statearr_17606[(1)] = (1));

return statearr_17606;
});
var cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____1 = (function (state_17567){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17567);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17607){if((e17607 instanceof Object)){
var ex__14927__auto__ = e17607;
var statearr_17608_17634 = state_17567;
(statearr_17608_17634[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17567);

return cljs.core.cst$kw$recur;
} else {
throw e17607;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17635 = state_17567;
state_17567 = G__17635;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__ = function(state_17567){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____1.call(this,state_17567);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__14924__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto__))
})();
var state__15049__auto__ = (function (){var statearr_17609 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17609[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto__);

return statearr_17609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto__))
);

return c__15047__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args17636 = [];
var len__8402__auto___17639 = arguments.length;
var i__8403__auto___17640 = (0);
while(true){
if((i__8403__auto___17640 < len__8402__auto___17639)){
args17636.push((arguments[i__8403__auto___17640]));

var G__17641 = (i__8403__auto___17640 + (1));
i__8403__auto___17640 = G__17641;
continue;
} else {
}
break;
}

var G__17638 = args17636.length;
switch (G__17638) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17636.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args17643 = [];
var len__8402__auto___17646 = arguments.length;
var i__8403__auto___17647 = (0);
while(true){
if((i__8403__auto___17647 < len__8402__auto___17646)){
args17643.push((arguments[i__8403__auto___17647]));

var G__17648 = (i__8403__auto___17647 + (1));
i__8403__auto___17647 = G__17648;
continue;
} else {
}
break;
}

var G__17645 = args17643.length;
switch (G__17645) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17643.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args17650 = [];
var len__8402__auto___17701 = arguments.length;
var i__8403__auto___17702 = (0);
while(true){
if((i__8403__auto___17702 < len__8402__auto___17701)){
args17650.push((arguments[i__8403__auto___17702]));

var G__17703 = (i__8403__auto___17702 + (1));
i__8403__auto___17702 = G__17703;
continue;
} else {
}
break;
}

var G__17652 = args17650.length;
switch (G__17652) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17650.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17705 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17705,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17705,out){
return (function (state_17676){
var state_val_17677 = (state_17676[(1)]);
if((state_val_17677 === (7))){
var inst_17671 = (state_17676[(2)]);
var state_17676__$1 = state_17676;
var statearr_17678_17706 = state_17676__$1;
(statearr_17678_17706[(2)] = inst_17671);

(statearr_17678_17706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (1))){
var inst_17653 = null;
var state_17676__$1 = (function (){var statearr_17679 = state_17676;
(statearr_17679[(7)] = inst_17653);

return statearr_17679;
})();
var statearr_17680_17707 = state_17676__$1;
(statearr_17680_17707[(2)] = null);

(statearr_17680_17707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (4))){
var inst_17656 = (state_17676[(8)]);
var inst_17656__$1 = (state_17676[(2)]);
var inst_17657 = (inst_17656__$1 == null);
var inst_17658 = cljs.core.not(inst_17657);
var state_17676__$1 = (function (){var statearr_17681 = state_17676;
(statearr_17681[(8)] = inst_17656__$1);

return statearr_17681;
})();
if(inst_17658){
var statearr_17682_17708 = state_17676__$1;
(statearr_17682_17708[(1)] = (5));

} else {
var statearr_17683_17709 = state_17676__$1;
(statearr_17683_17709[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (6))){
var state_17676__$1 = state_17676;
var statearr_17684_17710 = state_17676__$1;
(statearr_17684_17710[(2)] = null);

(statearr_17684_17710[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (3))){
var inst_17673 = (state_17676[(2)]);
var inst_17674 = cljs.core.async.close_BANG_(out);
var state_17676__$1 = (function (){var statearr_17685 = state_17676;
(statearr_17685[(9)] = inst_17673);

return statearr_17685;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_17676__$1,inst_17674);
} else {
if((state_val_17677 === (2))){
var state_17676__$1 = state_17676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17676__$1,(4),ch);
} else {
if((state_val_17677 === (11))){
var inst_17656 = (state_17676[(8)]);
var inst_17665 = (state_17676[(2)]);
var inst_17653 = inst_17656;
var state_17676__$1 = (function (){var statearr_17686 = state_17676;
(statearr_17686[(7)] = inst_17653);

(statearr_17686[(10)] = inst_17665);

return statearr_17686;
})();
var statearr_17687_17711 = state_17676__$1;
(statearr_17687_17711[(2)] = null);

(statearr_17687_17711[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (9))){
var inst_17656 = (state_17676[(8)]);
var state_17676__$1 = state_17676;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17676__$1,(11),out,inst_17656);
} else {
if((state_val_17677 === (5))){
var inst_17653 = (state_17676[(7)]);
var inst_17656 = (state_17676[(8)]);
var inst_17660 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17656,inst_17653);
var state_17676__$1 = state_17676;
if(inst_17660){
var statearr_17689_17712 = state_17676__$1;
(statearr_17689_17712[(1)] = (8));

} else {
var statearr_17690_17713 = state_17676__$1;
(statearr_17690_17713[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (10))){
var inst_17668 = (state_17676[(2)]);
var state_17676__$1 = state_17676;
var statearr_17691_17714 = state_17676__$1;
(statearr_17691_17714[(2)] = inst_17668);

(statearr_17691_17714[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17677 === (8))){
var inst_17653 = (state_17676[(7)]);
var tmp17688 = inst_17653;
var inst_17653__$1 = tmp17688;
var state_17676__$1 = (function (){var statearr_17692 = state_17676;
(statearr_17692[(7)] = inst_17653__$1);

return statearr_17692;
})();
var statearr_17693_17715 = state_17676__$1;
(statearr_17693_17715[(2)] = null);

(statearr_17693_17715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17705,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17705,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17697 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_17697[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17697[(1)] = (1));

return statearr_17697;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17676){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17676);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17698){if((e17698 instanceof Object)){
var ex__14927__auto__ = e17698;
var statearr_17699_17716 = state_17676;
(statearr_17699_17716[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17676);

return cljs.core.cst$kw$recur;
} else {
throw e17698;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17717 = state_17676;
state_17676 = G__17717;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17676){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17676);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17705,out))
})();
var state__15049__auto__ = (function (){var statearr_17700 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17700[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17705);

return statearr_17700;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17705,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args17718 = [];
var len__8402__auto___17788 = arguments.length;
var i__8403__auto___17789 = (0);
while(true){
if((i__8403__auto___17789 < len__8402__auto___17788)){
args17718.push((arguments[i__8403__auto___17789]));

var G__17790 = (i__8403__auto___17789 + (1));
i__8403__auto___17789 = G__17790;
continue;
} else {
}
break;
}

var G__17720 = args17718.length;
switch (G__17720) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17718.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17792 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17792,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17792,out){
return (function (state_17758){
var state_val_17759 = (state_17758[(1)]);
if((state_val_17759 === (7))){
var inst_17754 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
var statearr_17760_17793 = state_17758__$1;
(statearr_17760_17793[(2)] = inst_17754);

(statearr_17760_17793[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (1))){
var inst_17721 = (new Array(n));
var inst_17722 = inst_17721;
var inst_17723 = (0);
var state_17758__$1 = (function (){var statearr_17761 = state_17758;
(statearr_17761[(7)] = inst_17722);

(statearr_17761[(8)] = inst_17723);

return statearr_17761;
})();
var statearr_17762_17794 = state_17758__$1;
(statearr_17762_17794[(2)] = null);

(statearr_17762_17794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (4))){
var inst_17726 = (state_17758[(9)]);
var inst_17726__$1 = (state_17758[(2)]);
var inst_17727 = (inst_17726__$1 == null);
var inst_17728 = cljs.core.not(inst_17727);
var state_17758__$1 = (function (){var statearr_17763 = state_17758;
(statearr_17763[(9)] = inst_17726__$1);

return statearr_17763;
})();
if(inst_17728){
var statearr_17764_17795 = state_17758__$1;
(statearr_17764_17795[(1)] = (5));

} else {
var statearr_17765_17796 = state_17758__$1;
(statearr_17765_17796[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (15))){
var inst_17748 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
var statearr_17766_17797 = state_17758__$1;
(statearr_17766_17797[(2)] = inst_17748);

(statearr_17766_17797[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (13))){
var state_17758__$1 = state_17758;
var statearr_17767_17798 = state_17758__$1;
(statearr_17767_17798[(2)] = null);

(statearr_17767_17798[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (6))){
var inst_17723 = (state_17758[(8)]);
var inst_17744 = (inst_17723 > (0));
var state_17758__$1 = state_17758;
if(cljs.core.truth_(inst_17744)){
var statearr_17768_17799 = state_17758__$1;
(statearr_17768_17799[(1)] = (12));

} else {
var statearr_17769_17800 = state_17758__$1;
(statearr_17769_17800[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (3))){
var inst_17756 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17758__$1,inst_17756);
} else {
if((state_val_17759 === (12))){
var inst_17722 = (state_17758[(7)]);
var inst_17746 = cljs.core.vec(inst_17722);
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17758__$1,(15),out,inst_17746);
} else {
if((state_val_17759 === (2))){
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17758__$1,(4),ch);
} else {
if((state_val_17759 === (11))){
var inst_17738 = (state_17758[(2)]);
var inst_17739 = (new Array(n));
var inst_17722 = inst_17739;
var inst_17723 = (0);
var state_17758__$1 = (function (){var statearr_17770 = state_17758;
(statearr_17770[(10)] = inst_17738);

(statearr_17770[(7)] = inst_17722);

(statearr_17770[(8)] = inst_17723);

return statearr_17770;
})();
var statearr_17771_17801 = state_17758__$1;
(statearr_17771_17801[(2)] = null);

(statearr_17771_17801[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (9))){
var inst_17722 = (state_17758[(7)]);
var inst_17736 = cljs.core.vec(inst_17722);
var state_17758__$1 = state_17758;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17758__$1,(11),out,inst_17736);
} else {
if((state_val_17759 === (5))){
var inst_17722 = (state_17758[(7)]);
var inst_17726 = (state_17758[(9)]);
var inst_17731 = (state_17758[(11)]);
var inst_17723 = (state_17758[(8)]);
var inst_17730 = (inst_17722[inst_17723] = inst_17726);
var inst_17731__$1 = (inst_17723 + (1));
var inst_17732 = (inst_17731__$1 < n);
var state_17758__$1 = (function (){var statearr_17772 = state_17758;
(statearr_17772[(12)] = inst_17730);

(statearr_17772[(11)] = inst_17731__$1);

return statearr_17772;
})();
if(cljs.core.truth_(inst_17732)){
var statearr_17773_17802 = state_17758__$1;
(statearr_17773_17802[(1)] = (8));

} else {
var statearr_17774_17803 = state_17758__$1;
(statearr_17774_17803[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (14))){
var inst_17751 = (state_17758[(2)]);
var inst_17752 = cljs.core.async.close_BANG_(out);
var state_17758__$1 = (function (){var statearr_17776 = state_17758;
(statearr_17776[(13)] = inst_17751);

return statearr_17776;
})();
var statearr_17777_17804 = state_17758__$1;
(statearr_17777_17804[(2)] = inst_17752);

(statearr_17777_17804[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (10))){
var inst_17742 = (state_17758[(2)]);
var state_17758__$1 = state_17758;
var statearr_17778_17805 = state_17758__$1;
(statearr_17778_17805[(2)] = inst_17742);

(statearr_17778_17805[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17759 === (8))){
var inst_17722 = (state_17758[(7)]);
var inst_17731 = (state_17758[(11)]);
var tmp17775 = inst_17722;
var inst_17722__$1 = tmp17775;
var inst_17723 = inst_17731;
var state_17758__$1 = (function (){var statearr_17779 = state_17758;
(statearr_17779[(7)] = inst_17722__$1);

(statearr_17779[(8)] = inst_17723);

return statearr_17779;
})();
var statearr_17780_17806 = state_17758__$1;
(statearr_17780_17806[(2)] = null);

(statearr_17780_17806[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17792,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17792,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17784 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17784[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17784[(1)] = (1));

return statearr_17784;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17758){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17758);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17785){if((e17785 instanceof Object)){
var ex__14927__auto__ = e17785;
var statearr_17786_17807 = state_17758;
(statearr_17786_17807[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17758);

return cljs.core.cst$kw$recur;
} else {
throw e17785;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17808 = state_17758;
state_17758 = G__17808;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17758){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17758);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17792,out))
})();
var state__15049__auto__ = (function (){var statearr_17787 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17787[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17792);

return statearr_17787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17792,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args17809 = [];
var len__8402__auto___17883 = arguments.length;
var i__8403__auto___17884 = (0);
while(true){
if((i__8403__auto___17884 < len__8402__auto___17883)){
args17809.push((arguments[i__8403__auto___17884]));

var G__17885 = (i__8403__auto___17884 + (1));
i__8403__auto___17884 = G__17885;
continue;
} else {
}
break;
}

var G__17811 = args17809.length;
switch (G__17811) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args17809.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__15047__auto___17887 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__15047__auto___17887,out){
return (function (){
var f__15048__auto__ = (function (){var switch__14923__auto__ = ((function (c__15047__auto___17887,out){
return (function (state_17853){
var state_val_17854 = (state_17853[(1)]);
if((state_val_17854 === (7))){
var inst_17849 = (state_17853[(2)]);
var state_17853__$1 = state_17853;
var statearr_17855_17888 = state_17853__$1;
(statearr_17855_17888[(2)] = inst_17849);

(statearr_17855_17888[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (1))){
var inst_17812 = [];
var inst_17813 = inst_17812;
var inst_17814 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_17853__$1 = (function (){var statearr_17856 = state_17853;
(statearr_17856[(7)] = inst_17813);

(statearr_17856[(8)] = inst_17814);

return statearr_17856;
})();
var statearr_17857_17889 = state_17853__$1;
(statearr_17857_17889[(2)] = null);

(statearr_17857_17889[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (4))){
var inst_17817 = (state_17853[(9)]);
var inst_17817__$1 = (state_17853[(2)]);
var inst_17818 = (inst_17817__$1 == null);
var inst_17819 = cljs.core.not(inst_17818);
var state_17853__$1 = (function (){var statearr_17858 = state_17853;
(statearr_17858[(9)] = inst_17817__$1);

return statearr_17858;
})();
if(inst_17819){
var statearr_17859_17890 = state_17853__$1;
(statearr_17859_17890[(1)] = (5));

} else {
var statearr_17860_17891 = state_17853__$1;
(statearr_17860_17891[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (15))){
var inst_17843 = (state_17853[(2)]);
var state_17853__$1 = state_17853;
var statearr_17861_17892 = state_17853__$1;
(statearr_17861_17892[(2)] = inst_17843);

(statearr_17861_17892[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (13))){
var state_17853__$1 = state_17853;
var statearr_17862_17893 = state_17853__$1;
(statearr_17862_17893[(2)] = null);

(statearr_17862_17893[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (6))){
var inst_17813 = (state_17853[(7)]);
var inst_17838 = inst_17813.length;
var inst_17839 = (inst_17838 > (0));
var state_17853__$1 = state_17853;
if(cljs.core.truth_(inst_17839)){
var statearr_17863_17894 = state_17853__$1;
(statearr_17863_17894[(1)] = (12));

} else {
var statearr_17864_17895 = state_17853__$1;
(statearr_17864_17895[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (3))){
var inst_17851 = (state_17853[(2)]);
var state_17853__$1 = state_17853;
return cljs.core.async.impl.ioc_helpers.return_chan(state_17853__$1,inst_17851);
} else {
if((state_val_17854 === (12))){
var inst_17813 = (state_17853[(7)]);
var inst_17841 = cljs.core.vec(inst_17813);
var state_17853__$1 = state_17853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17853__$1,(15),out,inst_17841);
} else {
if((state_val_17854 === (2))){
var state_17853__$1 = state_17853;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_17853__$1,(4),ch);
} else {
if((state_val_17854 === (11))){
var inst_17821 = (state_17853[(10)]);
var inst_17817 = (state_17853[(9)]);
var inst_17831 = (state_17853[(2)]);
var inst_17832 = [];
var inst_17833 = inst_17832.push(inst_17817);
var inst_17813 = inst_17832;
var inst_17814 = inst_17821;
var state_17853__$1 = (function (){var statearr_17865 = state_17853;
(statearr_17865[(7)] = inst_17813);

(statearr_17865[(8)] = inst_17814);

(statearr_17865[(11)] = inst_17833);

(statearr_17865[(12)] = inst_17831);

return statearr_17865;
})();
var statearr_17866_17896 = state_17853__$1;
(statearr_17866_17896[(2)] = null);

(statearr_17866_17896[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (9))){
var inst_17813 = (state_17853[(7)]);
var inst_17829 = cljs.core.vec(inst_17813);
var state_17853__$1 = state_17853;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_17853__$1,(11),out,inst_17829);
} else {
if((state_val_17854 === (5))){
var inst_17821 = (state_17853[(10)]);
var inst_17817 = (state_17853[(9)]);
var inst_17814 = (state_17853[(8)]);
var inst_17821__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_17817) : f.call(null,inst_17817));
var inst_17822 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_17821__$1,inst_17814);
var inst_17823 = cljs.core.keyword_identical_QMARK_(inst_17814,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_17824 = (inst_17822) || (inst_17823);
var state_17853__$1 = (function (){var statearr_17867 = state_17853;
(statearr_17867[(10)] = inst_17821__$1);

return statearr_17867;
})();
if(cljs.core.truth_(inst_17824)){
var statearr_17868_17897 = state_17853__$1;
(statearr_17868_17897[(1)] = (8));

} else {
var statearr_17869_17898 = state_17853__$1;
(statearr_17869_17898[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (14))){
var inst_17846 = (state_17853[(2)]);
var inst_17847 = cljs.core.async.close_BANG_(out);
var state_17853__$1 = (function (){var statearr_17871 = state_17853;
(statearr_17871[(13)] = inst_17846);

return statearr_17871;
})();
var statearr_17872_17899 = state_17853__$1;
(statearr_17872_17899[(2)] = inst_17847);

(statearr_17872_17899[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (10))){
var inst_17836 = (state_17853[(2)]);
var state_17853__$1 = state_17853;
var statearr_17873_17900 = state_17853__$1;
(statearr_17873_17900[(2)] = inst_17836);

(statearr_17873_17900[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_17854 === (8))){
var inst_17821 = (state_17853[(10)]);
var inst_17813 = (state_17853[(7)]);
var inst_17817 = (state_17853[(9)]);
var inst_17826 = inst_17813.push(inst_17817);
var tmp17870 = inst_17813;
var inst_17813__$1 = tmp17870;
var inst_17814 = inst_17821;
var state_17853__$1 = (function (){var statearr_17874 = state_17853;
(statearr_17874[(7)] = inst_17813__$1);

(statearr_17874[(14)] = inst_17826);

(statearr_17874[(8)] = inst_17814);

return statearr_17874;
})();
var statearr_17875_17901 = state_17853__$1;
(statearr_17875_17901[(2)] = null);

(statearr_17875_17901[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__15047__auto___17887,out))
;
return ((function (switch__14923__auto__,c__15047__auto___17887,out){
return (function() {
var cljs$core$async$state_machine__14924__auto__ = null;
var cljs$core$async$state_machine__14924__auto____0 = (function (){
var statearr_17879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17879[(0)] = cljs$core$async$state_machine__14924__auto__);

(statearr_17879[(1)] = (1));

return statearr_17879;
});
var cljs$core$async$state_machine__14924__auto____1 = (function (state_17853){
while(true){
var ret_value__14925__auto__ = (function (){try{while(true){
var result__14926__auto__ = switch__14923__auto__(state_17853);
if(cljs.core.keyword_identical_QMARK_(result__14926__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14926__auto__;
}
break;
}
}catch (e17880){if((e17880 instanceof Object)){
var ex__14927__auto__ = e17880;
var statearr_17881_17902 = state_17853;
(statearr_17881_17902[(5)] = ex__14927__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_17853);

return cljs.core.cst$kw$recur;
} else {
throw e17880;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14925__auto__,cljs.core.cst$kw$recur)){
var G__17903 = state_17853;
state_17853 = G__17903;
continue;
} else {
return ret_value__14925__auto__;
}
break;
}
});
cljs$core$async$state_machine__14924__auto__ = function(state_17853){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__14924__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__14924__auto____1.call(this,state_17853);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__14924__auto____0;
cljs$core$async$state_machine__14924__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__14924__auto____1;
return cljs$core$async$state_machine__14924__auto__;
})()
;})(switch__14923__auto__,c__15047__auto___17887,out))
})();
var state__15049__auto__ = (function (){var statearr_17882 = (f__15048__auto__.cljs$core$IFn$_invoke$arity$0 ? f__15048__auto__.cljs$core$IFn$_invoke$arity$0() : f__15048__auto__.call(null));
(statearr_17882[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__15047__auto___17887);

return statearr_17882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__15049__auto__);
});})(c__15047__auto___17887,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;

