// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async.impl.channels');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.buffers');
cljs.core.async.impl.channels.box = (function cljs$core$async$impl$channels$box(val){
if(typeof cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624 = (function (val,meta13625){
this.val = val;
this.meta13625 = meta13625;
this.cljs$lang$protocol_mask$partition0$ = 425984;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_13626,meta13625__$1){
var self__ = this;
var _13626__$1 = this;
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624(self__.val,meta13625__$1));
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_13626){
var self__ = this;
var _13626__$1 = this;
return self__.meta13625;
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.val;
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$meta13625], null);
});

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.cljs$lang$type = true;

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.cljs$lang$ctorStr = "cljs.core.async.impl.channels/t_cljs$core$async$impl$channels13624";

cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async.impl.channels/t_cljs$core$async$impl$channels13624");
});

cljs.core.async.impl.channels.__GT_t_cljs$core$async$impl$channels13624 = (function cljs$core$async$impl$channels$box_$___GT_t_cljs$core$async$impl$channels13624(val__$1,meta13625){
return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624(val__$1,meta13625));
});

}

return (new cljs.core.async.impl.channels.t_cljs$core$async$impl$channels13624(val,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.async.impl.channels.PutBox = (function (handler,val){
this.handler = handler;
this.val = val;
})

cljs.core.async.impl.channels.PutBox.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$handler,cljs.core.cst$sym$val], null);
});

cljs.core.async.impl.channels.PutBox.cljs$lang$type = true;

cljs.core.async.impl.channels.PutBox.cljs$lang$ctorStr = "cljs.core.async.impl.channels/PutBox";

cljs.core.async.impl.channels.PutBox.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async.impl.channels/PutBox");
});

cljs.core.async.impl.channels.__GT_PutBox = (function cljs$core$async$impl$channels$__GT_PutBox(handler,val){
return (new cljs.core.async.impl.channels.PutBox(handler,val));
});

cljs.core.async.impl.channels.put_active_QMARK_ = (function cljs$core$async$impl$channels$put_active_QMARK_(box){
return cljs.core.async.impl.protocols.active_QMARK_(box.handler);
});
cljs.core.async.impl.channels.MAX_DIRTY = (64);

/**
 * @interface
 */
cljs.core.async.impl.channels.MMC = function(){};

cljs.core.async.impl.channels.abort = (function cljs$core$async$impl$channels$abort(this$){
if((!((this$ == null))) && (!((this$.cljs$core$async$impl$channels$MMC$abort$arity$1 == null)))){
return this$.cljs$core$async$impl$channels$MMC$abort$arity$1(this$);
} else {
var x__7957__auto__ = (((this$ == null))?null:this$);
var m__7958__auto__ = (cljs.core.async.impl.channels.abort[goog.typeOf(x__7957__auto__)]);
if(!((m__7958__auto__ == null))){
return (m__7958__auto__.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__7958__auto__.call(null,this$));
} else {
var m__7958__auto____$1 = (cljs.core.async.impl.channels.abort["_"]);
if(!((m__7958__auto____$1 == null))){
return (m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__7958__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__7958__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("MMC.abort",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.async.impl.channels.MMC}
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
*/
cljs.core.async.impl.channels.ManyToManyChannel = (function (takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
this.takes = takes;
this.dirty_takes = dirty_takes;
this.puts = puts;
this.dirty_puts = dirty_puts;
this.buf = buf;
this.closed = closed;
this.add_BANG_ = add_BANG_;
})
cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$channels$MMC$abort$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
while(true){
var putter_13638 = self__.puts.pop();
if((putter_13638 == null)){
} else {
var put_handler_13639 = putter_13638.handler;
var val_13640 = putter_13638.val;
if(put_handler_13639.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null)){
var put_cb_13641 = put_handler_13639.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
cljs.core.async.impl.dispatch.run(((function (put_cb_13641,put_handler_13639,val_13640,putter_13638,this$__$1){
return (function (){
return (put_cb_13641.cljs$core$IFn$_invoke$arity$1 ? put_cb_13641.cljs$core$IFn$_invoke$arity$1(true) : put_cb_13641.call(null,true));
});})(put_cb_13641,put_handler_13639,val_13640,putter_13638,this$__$1))
);
} else {
continue;
}
}
break;
}

self__.puts.cleanup(cljs.core.constantly(false));

return this$__$1.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1(null);
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (this$,val,handler){
var self__ = this;
var this$__$1 = this;
if(!((val == null))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Can't put nil in on a channel"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(not (nil? val))")].join('')));
}

var closed__$1 = self__.closed;
if((closed__$1) || (!(handler.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null)))){
return cljs.core.async.impl.channels.box(!(closed__$1));
} else {
if(cljs.core.truth_((function (){var and__7277__auto__ = self__.buf;
if(cljs.core.truth_(and__7277__auto__)){
return cljs.core.not(self__.buf.cljs$core$async$impl$protocols$Buffer$full_QMARK_$arity$1(null));
} else {
return and__7277__auto__;
}
})())){
handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);

var done_QMARK_ = cljs.core.reduced_QMARK_((self__.add_BANG_.cljs$core$IFn$_invoke$arity$2 ? self__.add_BANG_.cljs$core$IFn$_invoke$arity$2(self__.buf,val) : self__.add_BANG_.call(null,self__.buf,val)));
var take_cbs = (function (){var takers = cljs.core.PersistentVector.EMPTY;
while(true){
if(((self__.takes.length > (0))) && ((cljs.core.count(self__.buf) > (0)))){
var taker = self__.takes.pop();
if(taker.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null)){
var ret = taker.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
var val__$1 = self__.buf.cljs$core$async$impl$protocols$Buffer$remove_BANG_$arity$1(null);
var G__13642 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(takers,((function (takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1){
return (function (){
return (ret.cljs$core$IFn$_invoke$arity$1 ? ret.cljs$core$IFn$_invoke$arity$1(val__$1) : ret.call(null,val__$1));
});})(takers,ret,val__$1,taker,done_QMARK_,closed__$1,this$__$1))
);
takers = G__13642;
continue;
} else {
var G__13643 = takers;
takers = G__13643;
continue;
}
} else {
return takers;
}
break;
}
})();
if(done_QMARK_){
this$__$1.cljs$core$async$impl$channels$MMC$abort$arity$1(null);
} else {
}

if(cljs.core.seq(take_cbs)){
var seq__13627_13644 = cljs.core.seq(take_cbs);
var chunk__13628_13645 = null;
var count__13629_13646 = (0);
var i__13630_13647 = (0);
while(true){
if((i__13630_13647 < count__13629_13646)){
var f_13648 = chunk__13628_13645.cljs$core$IIndexed$_nth$arity$2(null,i__13630_13647);
cljs.core.async.impl.dispatch.run(f_13648);

var G__13649 = seq__13627_13644;
var G__13650 = chunk__13628_13645;
var G__13651 = count__13629_13646;
var G__13652 = (i__13630_13647 + (1));
seq__13627_13644 = G__13649;
chunk__13628_13645 = G__13650;
count__13629_13646 = G__13651;
i__13630_13647 = G__13652;
continue;
} else {
var temp__4657__auto___13653 = cljs.core.seq(seq__13627_13644);
if(temp__4657__auto___13653){
var seq__13627_13654__$1 = temp__4657__auto___13653;
if(cljs.core.chunked_seq_QMARK_(seq__13627_13654__$1)){
var c__8108__auto___13655 = cljs.core.chunk_first(seq__13627_13654__$1);
var G__13656 = cljs.core.chunk_rest(seq__13627_13654__$1);
var G__13657 = c__8108__auto___13655;
var G__13658 = cljs.core.count(c__8108__auto___13655);
var G__13659 = (0);
seq__13627_13644 = G__13656;
chunk__13628_13645 = G__13657;
count__13629_13646 = G__13658;
i__13630_13647 = G__13659;
continue;
} else {
var f_13660 = cljs.core.first(seq__13627_13654__$1);
cljs.core.async.impl.dispatch.run(f_13660);

var G__13661 = cljs.core.next(seq__13627_13654__$1);
var G__13662 = null;
var G__13663 = (0);
var G__13664 = (0);
seq__13627_13644 = G__13661;
chunk__13628_13645 = G__13662;
count__13629_13646 = G__13663;
i__13630_13647 = G__13664;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.core.async.impl.channels.box(true);
} else {
var taker = (function (){while(true){
var taker = self__.takes.pop();
if(cljs.core.truth_(taker)){
if(cljs.core.truth_(taker.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null))){
return taker;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(taker)){
var take_cb = cljs.core.async.impl.protocols.commit(taker);
handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);

cljs.core.async.impl.dispatch.run(((function (take_cb,taker,closed__$1,this$__$1){
return (function (){
return (take_cb.cljs$core$IFn$_invoke$arity$1 ? take_cb.cljs$core$IFn$_invoke$arity$1(val) : take_cb.call(null,val));
});})(take_cb,taker,closed__$1,this$__$1))
);

return cljs.core.async.impl.channels.box(true);
} else {
if((self__.dirty_puts > cljs.core.async.impl.channels.MAX_DIRTY)){
self__.dirty_puts = (0);

self__.puts.cleanup(cljs.core.async.impl.channels.put_active_QMARK_);
} else {
self__.dirty_puts = (self__.dirty_puts + (1));
}

if(cljs.core.truth_(handler.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1(null))){
if((self__.puts.length < cljs.core.async.impl.protocols.MAX_QUEUE_SIZE)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No more than "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.async.impl.protocols.MAX_QUEUE_SIZE),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" pending puts are allowed on a single channel."),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" Consider using a windowed buffer.")].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(< (.-length puts) impl/MAX-QUEUE-SIZE)")].join('')));
}

self__.puts.unbounded_unshift((new cljs.core.async.impl.channels.PutBox(handler,val)));
} else {
}

return null;
}
}
}
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (this$,handler){
var self__ = this;
var this$__$1 = this;
if(!(handler.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null))){
return null;
} else {
if((!((self__.buf == null))) && ((cljs.core.count(self__.buf) > (0)))){
var temp__4655__auto__ = handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
if(cljs.core.truth_(temp__4655__auto__)){
var take_cb = temp__4655__auto__;
var val = self__.buf.cljs$core$async$impl$protocols$Buffer$remove_BANG_$arity$1(null);
var vec__13631 = (((self__.puts.length > (0)))?(function (){var cbs = cljs.core.PersistentVector.EMPTY;
while(true){
var putter = self__.puts.pop();
var put_handler = putter.handler;
var val__$1 = putter.val;
var cb = (function (){var and__7277__auto__ = put_handler.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(and__7277__auto__){
return put_handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__7277__auto__;
}
})();
var cbs__$1 = (cljs.core.truth_(cb)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cbs,cb):cbs);
var done_QMARK_ = (cljs.core.truth_(cb)?cljs.core.reduced_QMARK_((self__.add_BANG_.cljs$core$IFn$_invoke$arity$2 ? self__.add_BANG_.cljs$core$IFn$_invoke$arity$2(self__.buf,val__$1) : self__.add_BANG_.call(null,self__.buf,val__$1))):null);
if((cljs.core.not(done_QMARK_)) && (cljs.core.not(self__.buf.cljs$core$async$impl$protocols$Buffer$full_QMARK_$arity$1(null))) && ((self__.puts.length > (0)))){
var G__13665 = cbs__$1;
cbs = G__13665;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [done_QMARK_,cbs__$1], null);
}
break;
}
})():null);
var done_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13631,(0),null);
var cbs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13631,(1),null);
if(cljs.core.truth_(done_QMARK_)){
this$__$1.cljs$core$async$impl$channels$MMC$abort$arity$1(null);
} else {
}

var seq__13634_13666 = cljs.core.seq(cbs);
var chunk__13635_13667 = null;
var count__13636_13668 = (0);
var i__13637_13669 = (0);
while(true){
if((i__13637_13669 < count__13636_13668)){
var cb_13670 = chunk__13635_13667.cljs$core$IIndexed$_nth$arity$2(null,i__13637_13669);
cljs.core.async.impl.dispatch.run(((function (seq__13634_13666,chunk__13635_13667,count__13636_13668,i__13637_13669,cb_13670,val,vec__13631,done_QMARK_,cbs,take_cb,temp__4655__auto__,this$__$1){
return (function (){
return (cb_13670.cljs$core$IFn$_invoke$arity$1 ? cb_13670.cljs$core$IFn$_invoke$arity$1(true) : cb_13670.call(null,true));
});})(seq__13634_13666,chunk__13635_13667,count__13636_13668,i__13637_13669,cb_13670,val,vec__13631,done_QMARK_,cbs,take_cb,temp__4655__auto__,this$__$1))
);

var G__13671 = seq__13634_13666;
var G__13672 = chunk__13635_13667;
var G__13673 = count__13636_13668;
var G__13674 = (i__13637_13669 + (1));
seq__13634_13666 = G__13671;
chunk__13635_13667 = G__13672;
count__13636_13668 = G__13673;
i__13637_13669 = G__13674;
continue;
} else {
var temp__4657__auto___13675 = cljs.core.seq(seq__13634_13666);
if(temp__4657__auto___13675){
var seq__13634_13676__$1 = temp__4657__auto___13675;
if(cljs.core.chunked_seq_QMARK_(seq__13634_13676__$1)){
var c__8108__auto___13677 = cljs.core.chunk_first(seq__13634_13676__$1);
var G__13678 = cljs.core.chunk_rest(seq__13634_13676__$1);
var G__13679 = c__8108__auto___13677;
var G__13680 = cljs.core.count(c__8108__auto___13677);
var G__13681 = (0);
seq__13634_13666 = G__13678;
chunk__13635_13667 = G__13679;
count__13636_13668 = G__13680;
i__13637_13669 = G__13681;
continue;
} else {
var cb_13682 = cljs.core.first(seq__13634_13676__$1);
cljs.core.async.impl.dispatch.run(((function (seq__13634_13666,chunk__13635_13667,count__13636_13668,i__13637_13669,cb_13682,seq__13634_13676__$1,temp__4657__auto___13675,val,vec__13631,done_QMARK_,cbs,take_cb,temp__4655__auto__,this$__$1){
return (function (){
return (cb_13682.cljs$core$IFn$_invoke$arity$1 ? cb_13682.cljs$core$IFn$_invoke$arity$1(true) : cb_13682.call(null,true));
});})(seq__13634_13666,chunk__13635_13667,count__13636_13668,i__13637_13669,cb_13682,seq__13634_13676__$1,temp__4657__auto___13675,val,vec__13631,done_QMARK_,cbs,take_cb,temp__4655__auto__,this$__$1))
);

var G__13683 = cljs.core.next(seq__13634_13676__$1);
var G__13684 = null;
var G__13685 = (0);
var G__13686 = (0);
seq__13634_13666 = G__13683;
chunk__13635_13667 = G__13684;
count__13636_13668 = G__13685;
i__13637_13669 = G__13686;
continue;
}
} else {
}
}
break;
}

return cljs.core.async.impl.channels.box(val);
} else {
return null;
}
} else {
var putter = (function (){while(true){
var putter = self__.puts.pop();
if(cljs.core.truth_(putter)){
if(cljs.core.async.impl.protocols.active_QMARK_(putter.handler)){
return putter;
} else {
continue;
}
} else {
return null;
}
break;
}
})();
if(cljs.core.truth_(putter)){
var put_cb = cljs.core.async.impl.protocols.commit(putter.handler);
handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);

cljs.core.async.impl.dispatch.run(((function (put_cb,putter,this$__$1){
return (function (){
return (put_cb.cljs$core$IFn$_invoke$arity$1 ? put_cb.cljs$core$IFn$_invoke$arity$1(true) : put_cb.call(null,true));
});})(put_cb,putter,this$__$1))
);

return cljs.core.async.impl.channels.box(putter.val);
} else {
if(cljs.core.truth_(self__.closed)){
if(cljs.core.truth_(self__.buf)){
(self__.add_BANG_.cljs$core$IFn$_invoke$arity$1 ? self__.add_BANG_.cljs$core$IFn$_invoke$arity$1(self__.buf) : self__.add_BANG_.call(null,self__.buf));
} else {
}

if(cljs.core.truth_((function (){var and__7277__auto__ = handler.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__7277__auto__)){
return handler.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__7277__auto__;
}
})())){
var has_val = (function (){var and__7277__auto__ = self__.buf;
if(cljs.core.truth_(and__7277__auto__)){
return (cljs.core.count(self__.buf) > (0));
} else {
return and__7277__auto__;
}
})();
var val = (cljs.core.truth_(has_val)?self__.buf.cljs$core$async$impl$protocols$Buffer$remove_BANG_$arity$1(null):null);
return cljs.core.async.impl.channels.box(val);
} else {
return null;
}
} else {
if((self__.dirty_takes > cljs.core.async.impl.channels.MAX_DIRTY)){
self__.dirty_takes = (0);

self__.takes.cleanup(cljs.core.async.impl.protocols.active_QMARK_);
} else {
self__.dirty_takes = (self__.dirty_takes + (1));
}

if(cljs.core.truth_(handler.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1(null))){
if((self__.takes.length < cljs.core.async.impl.protocols.MAX_QUEUE_SIZE)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No more than "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.async.impl.protocols.MAX_QUEUE_SIZE),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" pending takes are allowed on a single channel.")].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(< (.-length takes) impl/MAX-QUEUE-SIZE)")].join('')));
}

self__.takes.unbounded_unshift(handler);
} else {
}

return null;
}
}
}
}
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.closed;
});

cljs.core.async.impl.channels.ManyToManyChannel.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(self__.closed){
return null;
} else {
self__.closed = true;

if(cljs.core.truth_((function (){var and__7277__auto__ = self__.buf;
if(cljs.core.truth_(and__7277__auto__)){
return (self__.puts.length === (0));
} else {
return and__7277__auto__;
}
})())){
(self__.add_BANG_.cljs$core$IFn$_invoke$arity$1 ? self__.add_BANG_.cljs$core$IFn$_invoke$arity$1(self__.buf) : self__.add_BANG_.call(null,self__.buf));
} else {
}

while(true){
var taker_13687 = self__.takes.pop();
if((taker_13687 == null)){
} else {
if(taker_13687.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null)){
var take_cb_13688 = taker_13687.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
var val_13689 = (cljs.core.truth_((function (){var and__7277__auto__ = self__.buf;
if(cljs.core.truth_(and__7277__auto__)){
return (cljs.core.count(self__.buf) > (0));
} else {
return and__7277__auto__;
}
})())?self__.buf.cljs$core$async$impl$protocols$Buffer$remove_BANG_$arity$1(null):null);
cljs.core.async.impl.dispatch.run(((function (take_cb_13688,val_13689,taker_13687,this$__$1){
return (function (){
return (take_cb_13688.cljs$core$IFn$_invoke$arity$1 ? take_cb_13688.cljs$core$IFn$_invoke$arity$1(val_13689) : take_cb_13688.call(null,val_13689));
});})(take_cb_13688,val_13689,taker_13687,this$__$1))
);
} else {
}

continue;
}
break;
}

if(cljs.core.truth_(self__.buf)){
self__.buf.cljs$core$async$impl$protocols$Buffer$close_buf_BANG_$arity$1(null);
} else {
}

return null;
}
});

cljs.core.async.impl.channels.ManyToManyChannel.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$takes,cljs.core.with_meta(cljs.core.cst$sym$dirty_DASH_takes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$puts,cljs.core.with_meta(cljs.core.cst$sym$dirty_DASH_puts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.with_meta(cljs.core.cst$sym$closed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$add_BANG_], null);
});

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$type = true;

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorStr = "cljs.core.async.impl.channels/ManyToManyChannel";

cljs.core.async.impl.channels.ManyToManyChannel.cljs$lang$ctorPrWriter = (function (this__7900__auto__,writer__7901__auto__,opt__7902__auto__){
return cljs.core._write(writer__7901__auto__,"cljs.core.async.impl.channels/ManyToManyChannel");
});

cljs.core.async.impl.channels.__GT_ManyToManyChannel = (function cljs$core$async$impl$channels$__GT_ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_){
return (new cljs.core.async.impl.channels.ManyToManyChannel(takes,dirty_takes,puts,dirty_puts,buf,closed,add_BANG_));
});

cljs.core.async.impl.channels.ex_handler = (function cljs$core$async$impl$channels$ex_handler(ex){
console.log(ex);

return null;
});
cljs.core.async.impl.channels.handle = (function cljs$core$async$impl$channels$handle(buf,exh,t){
var else$ = (function (){var or__7289__auto__ = exh;
if(cljs.core.truth_(or__7289__auto__)){
return or__7289__auto__;
} else {
return cljs.core.async.impl.channels.ex_handler;
}
})().call(null,t);
if((else$ == null)){
return buf;
} else {
return cljs.core.async.impl.protocols.add_BANG_.cljs$core$IFn$_invoke$arity$2(buf,else$);
}
});
cljs.core.async.impl.channels.chan = (function cljs$core$async$impl$channels$chan(var_args){
var args13690 = [];
var len__8402__auto___13695 = arguments.length;
var i__8403__auto___13696 = (0);
while(true){
if((i__8403__auto___13696 < len__8402__auto___13695)){
args13690.push((arguments[i__8403__auto___13696]));

var G__13697 = (i__8403__auto___13696 + (1));
i__8403__auto___13696 = G__13697;
continue;
} else {
}
break;
}

var G__13692 = args13690.length;
switch (G__13692) {
case 1:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13690.length)].join('')));

}
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf){
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2(buf,null);
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf,xform){
return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(buf,xform,null);
});

cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf,xform,exh){
return (new cljs.core.async.impl.channels.ManyToManyChannel(cljs.core.async.impl.buffers.ring_buffer((32)),(0),cljs.core.async.impl.buffers.ring_buffer((32)),(0),buf,false,(function (){var add_BANG_ = (cljs.core.truth_(xform)?(xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(cljs.core.async.impl.protocols.add_BANG_) : xform.call(null,cljs.core.async.impl.protocols.add_BANG_)):cljs.core.async.impl.protocols.add_BANG_);
return ((function (add_BANG_){
return (function() {
var G__13699 = null;
var G__13699__1 = (function (buf__$1){
try{return (add_BANG_.cljs$core$IFn$_invoke$arity$1 ? add_BANG_.cljs$core$IFn$_invoke$arity$1(buf__$1) : add_BANG_.call(null,buf__$1));
}catch (e13693){var t = e13693;
return cljs.core.async.impl.channels.handle(buf__$1,exh,t);
}});
var G__13699__2 = (function (buf__$1,val){
try{return (add_BANG_.cljs$core$IFn$_invoke$arity$2 ? add_BANG_.cljs$core$IFn$_invoke$arity$2(buf__$1,val) : add_BANG_.call(null,buf__$1,val));
}catch (e13694){var t = e13694;
return cljs.core.async.impl.channels.handle(buf__$1,exh,t);
}});
G__13699 = function(buf__$1,val){
switch(arguments.length){
case 1:
return G__13699__1.call(this,buf__$1);
case 2:
return G__13699__2.call(this,buf__$1,val);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__13699.cljs$core$IFn$_invoke$arity$1 = G__13699__1;
G__13699.cljs$core$IFn$_invoke$arity$2 = G__13699__2;
return G__13699;
})()
;})(add_BANG_))
})()));
});

cljs.core.async.impl.channels.chan.cljs$lang$maxFixedArity = 3;

