// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.encore');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.reader');
goog.require('goog.string');
goog.require('goog.string.format');
goog.require('goog.string.StringBuffer');
goog.require('goog.events');
goog.require('goog.net.XhrIo');
goog.require('goog.net.XhrIoPool');
goog.require('goog.Uri.QueryData');
goog.require('goog.structs');
goog.require('goog.net.EventType');
goog.require('goog.net.ErrorCode');
/**
 * Used for lib-consumer version assertions
 */
taoensso.encore.encore_version = 1.35;
taoensso.encore.assert_min_encore_version = (function taoensso$encore$assert_min_encore_version(min_version){
if((taoensso.encore.encore_version < min_version)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((taoensso.encore.format.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$3("Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version) : taoensso.encore.format.call(null,"Insufficient com.taoensso/encore version: %s < %s. You may have a Leiningen dependency conflict (see http://goo.gl/qBbLvC for solution).",taoensso.encore.encore_version,min_version)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$min_DASH_version,min_version,cljs.core.cst$kw$this_DASH_version,taoensso.encore.encore_version], null));
} else {
return null;
}
});
taoensso.encore.read_edn = (function taoensso$encore$read_edn(s){
return cljs.reader.read_string(s);
});
/**
 * Handles optional docstrings & attr maps for a macro def's name.
 *   Stolen from `clojure.tools.macro`.
 */
taoensso.encore.name_with_attrs = (function taoensso$encore$name_with_attrs(name,macro_args){
var vec__24007 = ((typeof cljs.core.first(macro_args) === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args),cljs.core.next(macro_args)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,macro_args], null));
var docstring = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24007,(0),null);
var macro_args__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24007,(1),null);
var vec__24010 = ((cljs.core.map_QMARK_(cljs.core.first(macro_args__$1)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(macro_args__$1),cljs.core.next(macro_args__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentArrayMap.EMPTY,macro_args__$1], null));
var attr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24010,(0),null);
var macro_args__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24010,(1),null);
var attr__$1 = (cljs.core.truth_(docstring)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(attr,cljs.core.cst$kw$doc,docstring):attr);
var attr__$2 = (cljs.core.truth_(cljs.core.meta(name))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.meta(name),attr__$1):attr__$1);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(name,attr__$2),macro_args__$2], null);
});
taoensso.encore.kw_identical_QMARK_ = cljs.core.keyword_identical_QMARK_;
taoensso.encore.stringy_QMARK_ = (function taoensso$encore$stringy_QMARK_(x){
return ((x instanceof cljs.core.Keyword)) || (typeof x === 'string');
});
taoensso.encore.atom_QMARK_ = (function taoensso$encore$atom_QMARK_(x){
return (x instanceof cljs.core.Atom);
});
taoensso.encore.chan_QMARK_ = (function taoensso$encore$chan_QMARK_(x){
return (x instanceof cljs.core.async.impl.channels.ManyToManyChannel);
});
taoensso.encore.re_pattern_QMARK_ = (function taoensso$encore$re_pattern_QMARK_(x){
return (x instanceof RegExp);
});
taoensso.encore.error_QMARK_ = (function taoensso$encore$error_QMARK_(x){
return (x instanceof Error);
});
/**
 * Returns data map iff `x` is an error of any type on platform.
 */
taoensso.encore.error_data = (function taoensso$encore$error_data(x){
var temp__5457__auto__ = (function (){var or__7960__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
if((x instanceof Error)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return null;
}
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var data_map = temp__5457__auto__;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(function (){var err = x;
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$err_DASH_type,cljs.core.type(err),cljs.core.cst$kw$err_DASH_msg,err.message,cljs.core.cst$kw$err_DASH_cause,err.cause], null);
})(),data_map], 0));
} else {
return null;
}
});
taoensso.encore.nnil_QMARK_ = (function taoensso$encore$nnil_QMARK_(x){
return !((x == null));
});
taoensso.encore.nblank_QMARK_ = (function taoensso$encore$nblank_QMARK_(x){
return !(clojure.string.blank_QMARK_(x));
});
taoensso.encore.nneg_QMARK_ = (function taoensso$encore$nneg_QMARK_(x){
return !((x < (0)));
});
taoensso.encore.pos_int_QMARK_ = (function taoensso$encore$pos_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && ((x > (0)));
});
taoensso.encore.nneg_int_QMARK_ = (function taoensso$encore$nneg_int_QMARK_(x){
return (cljs.core.integer_QMARK_(x)) && (!((x < (0))));
});
taoensso.encore.nvec_QMARK_ = (function taoensso$encore$nvec_QMARK_(n,x){
return (cljs.core.vector_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),n));
});
taoensso.encore.udt_QMARK_ = taoensso.encore.nneg_int_QMARK_;
taoensso.encore.vec2_QMARK_ = (function taoensso$encore$vec2_QMARK_(x){
return taoensso.encore.nvec_QMARK_((2),x);
});
taoensso.encore.vec3_QMARK_ = (function taoensso$encore$vec3_QMARK_(x){
return taoensso.encore.nvec_QMARK_((3),x);
});
taoensso.encore.distinct_elements_QMARK_ = (function taoensso$encore$distinct_elements_QMARK_(x){
return (cljs.core.set_QMARK_(x)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(x),cljs.core.count((taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.set_STAR_.cljs$core$IFn$_invoke$arity$1(x) : taoensso.encore.set_STAR_.call(null,x)))));
});
taoensso.encore.nblank_str_QMARK_ = (function taoensso$encore$nblank_str_QMARK_(x){
return (typeof x === 'string') && (!(clojure.string.blank_QMARK_(x)));
});
taoensso.encore.nneg_num_QMARK_ = (function taoensso$encore$nneg_num_QMARK_(x){
return (typeof x === 'number') && (!((x < (0))));
});
taoensso.encore.pos_num_QMARK_ = (function taoensso$encore$pos_num_QMARK_(x){
return (typeof x === 'number') && ((x > (0)));
});
taoensso.encore.zero_num_QMARK_ = (function taoensso$encore$zero_num_QMARK_(x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),x);
});
taoensso.encore.as__QMARK_nblank = (function taoensso$encore$as__QMARK_nblank(x){
if(typeof x === 'string'){
if(clojure.string.blank_QMARK_(x)){
return null;
} else {
return x;
}
} else {
return null;
}
});
taoensso.encore.as__QMARK_kw = (function taoensso$encore$as__QMARK_kw(x){
if((x instanceof cljs.core.Keyword)){
return x;
} else {
if(typeof x === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(x);
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_name = (function taoensso$encore$as__QMARK_name(x){
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if(typeof x === 'string'){
return x;
} else {
return null;
}
}
});
taoensso.encore.as__QMARK_bool = (function taoensso$encore$as__QMARK_bool(x){
if((x == null)){
return null;
} else {
if((x === true) || (x === false)){
return x;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"false")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"FALSE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"0"))){
return false;
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,(1))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"true")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"TRUE")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,"1"))){
return true;
} else {
return null;
}
}
}
}
});
taoensso.encore.as__QMARK_int = (function taoensso$encore$as__QMARK_int(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return cljs.core.long$(x);
} else {
if(typeof x === 'string'){
var x__$1 = parseInt(x,(10));
if(cljs.core.truth_(isNaN(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.as__QMARK_float = (function taoensso$encore$as__QMARK_float(x){
if((x == null)){
return null;
} else {
if(typeof x === 'number'){
return x;
} else {
if(typeof x === 'string'){
var x__$1 = parseFloat(x);
if(cljs.core.truth_(isNan(x__$1))){
return null;
} else {
return x__$1;
}
} else {
return null;
}
}
}
});
taoensso.encore.nnil_EQ_ = (function taoensso$encore$nnil_EQ_(var_args){
var args24015 = [];
var len__9181__auto___24021 = arguments.length;
var i__9182__auto___24022 = (0);
while(true){
if((i__9182__auto___24022 < len__9181__auto___24021)){
args24015.push((arguments[i__9182__auto___24022]));

var G__24023 = (i__9182__auto___24022 + (1));
i__9182__auto___24022 = G__24023;
continue;
} else {
}
break;
}

var G__24020 = args24015.length;
switch (G__24020) {
case 2:
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24015.slice((2)),(0),null));
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9204__auto__);

}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var and__7948__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7948__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y);
} else {
return and__7948__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
var and__7948__auto__ = taoensso.encore.nnil_QMARK_(x);
if(cljs.core.truth_(and__7948__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more);
} else {
return and__7948__auto__;
}
});

taoensso.encore.nnil_EQ_.cljs$lang$applyTo = (function (seq24016){
var G__24017 = cljs.core.first(seq24016);
var seq24016__$1 = cljs.core.next(seq24016);
var G__24018 = cljs.core.first(seq24016__$1);
var seq24016__$2 = cljs.core.next(seq24016__$1);
return taoensso.encore.nnil_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__24017,G__24018,seq24016__$2);
});

taoensso.encore.nnil_EQ_.cljs$lang$maxFixedArity = (2);

taoensso.encore.vec_STAR_ = (function taoensso$encore$vec_STAR_(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
return cljs.core.vec(x);
}
});
taoensso.encore.set_STAR_ = (function taoensso$encore$set_STAR_(x){
if(cljs.core.set_QMARK_(x)){
return x;
} else {
return cljs.core.set(x);
}
});
taoensso.encore.ks_EQ_ = (function taoensso$encore$ks_EQ_(ks,m){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_LT__EQ_ = (function taoensso$encore$ks_LT__EQ_(ks,m){
return clojure.set.subset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_GT__EQ_ = (function taoensso$encore$ks_GT__EQ_(ks,m){
return clojure.set.superset_QMARK_(cljs.core.set(cljs.core.keys(m)),taoensso.encore.set_STAR_(ks));
});
taoensso.encore.ks_nnil_QMARK_ = (function taoensso$encore$ks_nnil_QMARK_(ks,m){
return cljs.core.every_QMARK_((function (p1__24025_SHARP_){
return taoensso.encore.nnil_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,p1__24025_SHARP_));
}),ks);
});
taoensso.encore.assertion_error = (function taoensso$encore$assertion_error(msg){
return (new Error(msg));
});
/**
 * Implementation detail.
 */
taoensso.encore.hthrow = (function taoensso$encore$hthrow(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24036 = arguments.length;
var i__9182__auto___24037 = (0);
while(true){
if((i__9182__auto___24037 < len__9181__auto___24036)){
args__9188__auto__.push((arguments[i__9182__auto___24037]));

var G__24038 = (i__9182__auto___24037 + (1));
i__9182__auto___24037 = G__24038;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((5) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((5)),(0),null)):null);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__9189__auto__);
});

taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic = (function (hard_QMARK_,ns_str,_QMARK_line,form,val,p__24032){
var vec__24033 = p__24032;
var _QMARK_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24033,(0),null);
var pattern = "Condition failed in `%s:%s` [pred-form, val]: [%s, %s]";
var line_str = (function (){var or__7960__auto__ = _QMARK_line;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return "?";
}
})();
var form_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7960__auto__ = form;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return "<nil>";
}
})())].join('');
var val_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7960__auto__ = val;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return "<nil>";
}
})())].join('');
var _QMARK_err_str = (function (){var temp__5457__auto__ = _QMARK_err;
if(cljs.core.truth_(temp__5457__auto__)){
var e = temp__5457__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('');
} else {
return null;
}
})();
var msg = (function (){var m = (taoensso.encore.format.cljs$core$IFn$_invoke$arity$5 ? taoensso.encore.format.cljs$core$IFn$_invoke$arity$5(pattern,ns_str,line_str,form_str,val_str) : taoensso.encore.format.call(null,pattern,ns_str,line_str,form_str,val_str));
if(cljs.core.not(_QMARK_err_str)){
return m;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(m),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\nPredicate error: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err_str)].join('');
}
})();
throw ((cljs.core.not(hard_QMARK_))?taoensso.encore.assertion_error(msg):cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$ns,ns_str,cljs.core.cst$kw$_QMARK_line,_QMARK_line,cljs.core.cst$kw$form,form,cljs.core.cst$kw$val,val,cljs.core.cst$kw$_QMARK_err,_QMARK_err], null)));
});

taoensso.encore.hthrow.cljs$lang$maxFixedArity = (5);

taoensso.encore.hthrow.cljs$lang$applyTo = (function (seq24026){
var G__24027 = cljs.core.first(seq24026);
var seq24026__$1 = cljs.core.next(seq24026);
var G__24028 = cljs.core.first(seq24026__$1);
var seq24026__$2 = cljs.core.next(seq24026__$1);
var G__24029 = cljs.core.first(seq24026__$2);
var seq24026__$3 = cljs.core.next(seq24026__$2);
var G__24030 = cljs.core.first(seq24026__$3);
var seq24026__$4 = cljs.core.next(seq24026__$3);
var G__24031 = cljs.core.first(seq24026__$4);
var seq24026__$5 = cljs.core.next(seq24026__$4);
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(G__24027,G__24028,G__24029,G__24030,G__24031,seq24026__$5);
});

taoensso.encore.non_throwing = (function taoensso$encore$non_throwing(pred){
return (function (x){
var vec__24043 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(x) : pred.call(null,x))], null);
}catch (e24046){if((e24046 instanceof Error)){
var e__23026__auto__ = e24046;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23026__auto__], null);
} else {
throw e24046;

}
}})();
var _QMARK_r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24043,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24043,(1),null);
return _QMARK_r;
});
});
/**
 * Implementation detail.
 */
taoensso.encore.hpred = (function taoensso$encore$hpred(pred_form){
if(!(cljs.core.vector_QMARK_(pred_form))){
return pred_form;
} else {
var vec__24054 = pred_form;
var seq__24055 = cljs.core.seq(vec__24054);
var first__24056 = cljs.core.first(seq__24055);
var seq__24055__$1 = cljs.core.next(seq__24055);
var type = first__24056;
var first__24056__$1 = cljs.core.first(seq__24055__$1);
var seq__24055__$2 = cljs.core.next(seq__24055__$1);
var p1 = first__24056__$1;
var first__24056__$2 = cljs.core.first(seq__24055__$2);
var seq__24055__$3 = cljs.core.next(seq__24055__$2);
var p2 = first__24056__$2;
var more = seq__24055__$3;
var G__24057 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__24057) {
case "el":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "not=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "ks-nnil?":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return taoensso.encore.ks_nnil_QMARK_(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "ks<=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return taoensso.encore.ks_LT__EQ_(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "or":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
var or__7960__auto__ = (cljs.core.truth_(p1)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1))).call(null,x):null);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
var or__7960__auto____$1 = (cljs.core.truth_(p2)?taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2))).call(null,x):null);
if(cljs.core.truth_(or__7960__auto____$1)){
return or__7960__auto____$1;
} else {
return cljs.core.some(((function (or__7960__auto____$1,or__7960__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (p1__24048_SHARP_){
return taoensso.encore.non_throwing((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__24048_SHARP_) : taoensso.encore.hpred.call(null,p1__24048_SHARP_))).call(null,x);
});})(or__7960__auto____$1,or__7960__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))
,more);
}
}
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "not":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
var and__7948__auto__ = ((cljs.core.not(p1))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x)));
if(and__7948__auto__){
var and__7948__auto____$1 = ((cljs.core.not(p2))?true:cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x)));
if(and__7948__auto____$1){
return cljs.core.every_QMARK_(((function (and__7948__auto____$1,and__7948__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (p1__24047_SHARP_){
return cljs.core.not((taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__24047_SHARP_) : taoensso.encore.hpred.call(null,p1__24047_SHARP_)).call(null,x));
});})(and__7948__auto____$1,and__7948__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))
,more);
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "ks=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return taoensso.encore.ks_EQ_(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "and":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
var and__7948__auto__ = ((cljs.core.not(p1))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1) : taoensso.encore.hpred.call(null,p1)).call(null,x));
if(cljs.core.truth_(and__7948__auto__)){
var and__7948__auto____$1 = ((cljs.core.not(p2))?true:(taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p2) : taoensso.encore.hpred.call(null,p2)).call(null,x));
if(cljs.core.truth_(and__7948__auto____$1)){
return cljs.core.every_QMARK_(((function (and__7948__auto____$1,and__7948__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (p1__24049_SHARP_){
return (taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.hpred.cljs$core$IFn$_invoke$arity$1(p1__24049_SHARP_) : taoensso.encore.hpred.call(null,p1__24049_SHARP_)).call(null,x);
});})(and__7948__auto____$1,and__7948__auto__,G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))
,more);
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "ks>=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return taoensso.encore.ks_GT__EQ_(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "not-in":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "not-el":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return !(cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x));
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1,x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "set<=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return clojure.set.subset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "set>=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return clojure.set.superset_QMARK_(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "set=":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),taoensso.encore.set_STAR_(p1));
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
case "in":
return ((function (G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more){
return (function (x){
return cljs.core.contains_QMARK_(taoensso.encore.set_STAR_(p1),x);
});
;})(G__24057,vec__24054,seq__24055,first__24056,seq__24055__$1,type,first__24056__$1,seq__24055__$2,p1,first__24056__$2,seq__24055__$3,p2,more))

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}
}
});
/**
 * Implementation detail.
 */
taoensso.encore.hcond = (function taoensso$encore$hcond(hard_QMARK_,ns_str,line,x_,x_form,pred,pred_form){
var vec__24067 = (function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x_) : cljs.core.deref.call(null,x_))], null);
}catch (e24073){if((e24073 instanceof Error)){
var e__23026__auto__ = e24073;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23026__auto__], null);
} else {
throw e24073;

}
}})();
var _QMARK_x = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24067,(0),null);
var _QMARK_x_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24067,(1),null);
var have_x_QMARK_ = (_QMARK_x_err == null);
var vec__24070 = ((have_x_QMARK_)?(function (){try{return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hpred(pred).call(null,_QMARK_x)], null);
}catch (e24074){if((e24074 instanceof Error)){
var e__23026__auto__ = e24074;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,e__23026__auto__], null);
} else {
throw e24074;

}
}})():null);
var pass_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24070,(0),null);
var _QMARK_pred_err = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24070,(1),null);
if(cljs.core.truth_(pass_QMARK_)){
return _QMARK_x;
} else {
return taoensso.encore.hthrow.cljs$core$IFn$_invoke$arity$variadic(hard_QMARK_,ns_str,line,(function (){var x__8894__auto__ = pred_form;
return cljs.core._conj((function (){var x__8894__auto____$1 = x_form;
return cljs.core._conj(cljs.core.List.EMPTY,x__8894__auto____$1);
})(),x__8894__auto__);
})(),((have_x_QMARK_)?_QMARK_x:_QMARK_x_err),cljs.core.array_seq([_QMARK_pred_err], 0));
}
});
/**
 * Like `name` but fully qualified: includes namespace in string when present.
 */
taoensso.encore.fq_name = (function taoensso$encore$fq_name(x){
if(typeof x === 'string'){
return x;
} else {
var n = cljs.core.name(x);
var temp__5455__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(temp__5455__auto__)){
var ns = temp__5455__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('');
} else {
return n;
}
}
});
taoensso.encore.explode_keyword = (function taoensso$encore$explode_keyword(k){
return clojure.string.split.cljs$core$IFn$_invoke$arity$2(taoensso.encore.fq_name(k),/[\.\/]/);
});
taoensso.encore.merge_keywords = (function taoensso$encore$merge_keywords(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24081 = arguments.length;
var i__9182__auto___24082 = (0);
while(true){
if((i__9182__auto___24082 < len__9181__auto___24081)){
args__9188__auto__.push((arguments[i__9182__auto___24082]));

var G__24083 = (i__9182__auto___24082 + (1));
i__9182__auto___24082 = G__24083;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic = (function (ks,p__24077){
var vec__24078 = p__24077;
var no_slash_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24078,(0),null);
var parts = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.PersistentVector.EMPTY,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.explode_keyword,cljs.core.filterv(cljs.core.identity,ks)));
if(cljs.core.empty_QMARK_(parts)){
return null;
} else {
if(cljs.core.truth_(no_slash_QMARK_)){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",parts));
} else {
var ppop = cljs.core.pop(parts);
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(((cljs.core.empty_QMARK_(ppop))?null:clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ppop)),cljs.core.peek(parts));
}
}
});

taoensso.encore.merge_keywords.cljs$lang$maxFixedArity = (1);

taoensso.encore.merge_keywords.cljs$lang$applyTo = (function (seq24075){
var G__24076 = cljs.core.first(seq24075);
var seq24075__$1 = cljs.core.next(seq24075);
return taoensso.encore.merge_keywords.cljs$core$IFn$_invoke$arity$variadic(G__24076,seq24075__$1);
});

taoensso.encore.clamp = (function taoensso$encore$clamp(nmin,nmax,n){
if((n < nmin)){
return nmin;
} else {
if((n > nmax)){
return nmax;
} else {
return n;
}
}
});
taoensso.encore.pow = (function taoensso$encore$pow(n,exp){
return Math.pow(n,exp);
});
taoensso.encore.abs = (function taoensso$encore$abs(n){
if((n < (0))){
return (- n);
} else {
return n;
}
});
taoensso.encore.round = (function taoensso$encore$round(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24091 = arguments.length;
var i__9182__auto___24092 = (0);
while(true){
if((i__9182__auto___24092 < len__9181__auto___24091)){
args__9188__auto__.push((arguments[i__9182__auto___24092]));

var G__24093 = (i__9182__auto___24092 + (1));
i__9182__auto___24092 = G__24093;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic = (function (n,p__24086){
var vec__24087 = p__24086;
var type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24087,(0),null);
var nplaces = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24087,(1),null);
var n__$1 = n;
var modifier = (cljs.core.truth_(nplaces)?Math.pow(10.0,nplaces):null);
var n_STAR_ = ((cljs.core.not(modifier))?n__$1:(n__$1 * modifier));
var rounded = (function (){var G__24090 = ((((function (){var or__7960__auto__ = type;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.cst$kw$round;
}
})() instanceof cljs.core.Keyword))?(function (){var or__7960__auto__ = type;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.cst$kw$round;
}
})().fqn:null);
switch (G__24090) {
case "round":
return Math.round(n_STAR_);

break;
case "floor":
return Math.floor(n_STAR_);

break;
case "ceil":
return Math.ceil(n_STAR_);

break;
case "trunc":
return cljs.core.long$(n_STAR_);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unknown round type",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$type,type], null));

}
})();
if(cljs.core.not(modifier)){
return cljs.core.long$(rounded);
} else {
return (rounded / modifier);
}
});

taoensso.encore.round.cljs$lang$maxFixedArity = (1);

taoensso.encore.round.cljs$lang$applyTo = (function (seq24084){
var G__24085 = cljs.core.first(seq24084);
var seq24084__$1 = cljs.core.next(seq24084);
return taoensso.encore.round.cljs$core$IFn$_invoke$arity$variadic(G__24085,seq24084__$1);
});

taoensso.encore.round_STAR_ = taoensso.encore.round;
/**
 * Optimized common case.
 */
taoensso.encore.round1 = (function taoensso$encore$round1(n){
return ((function (){var G__24096 = (n * 10.0);
return Math.round(G__24096);
})() / 10.0);
});
/**
 * Optimized common case.
 */
taoensso.encore.round2 = (function taoensso$encore$round2(n){
return ((function (){var G__24098 = (n * 100.0);
return Math.round(G__24098);
})() / 100.0);
});
/**
 * Returns binary exponential backoff value.
 */
taoensso.encore.exp_backoff = (function taoensso$encore$exp_backoff(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24109 = arguments.length;
var i__9182__auto___24110 = (0);
while(true){
if((i__9182__auto___24110 < len__9181__auto___24109)){
args__9188__auto__.push((arguments[i__9182__auto___24110]));

var G__24111 = (i__9182__auto___24110 + (1));
i__9182__auto___24110 = G__24111;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic = (function (nattempt,p__24101){
var vec__24102 = p__24101;
var map__24105 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24102,(0),null);
var map__24105__$1 = ((((!((map__24105 == null)))?((((map__24105.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24105.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24105):map__24105);
var min_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24105__$1,cljs.core.cst$kw$min);
var max_SINGLEQUOTE_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24105__$1,cljs.core.cst$kw$max);
var factor = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24105__$1,cljs.core.cst$kw$factor,(1000));
var binary_exp = (function (){var G__24107 = (2);
var G__24108 = (nattempt - (1));
return Math.pow(G__24107,G__24108);
})();
var time = (((binary_exp + cljs.core.rand.cljs$core$IFn$_invoke$arity$1(binary_exp)) * 0.5) * factor);
return cljs.core.long$((function (){var time__$1 = (cljs.core.truth_(min_SINGLEQUOTE_)?(function (){var x__8298__auto__ = min_SINGLEQUOTE_;
var y__8299__auto__ = time;
return ((x__8298__auto__ > y__8299__auto__) ? x__8298__auto__ : y__8299__auto__);
})():time);
var time__$2 = (cljs.core.truth_(max_SINGLEQUOTE_)?(function (){var x__8305__auto__ = max_SINGLEQUOTE_;
var y__8306__auto__ = time__$1;
return ((x__8305__auto__ < y__8306__auto__) ? x__8305__auto__ : y__8306__auto__);
})():time__$1);
return time__$2;
})());
});

taoensso.encore.exp_backoff.cljs$lang$maxFixedArity = (1);

taoensso.encore.exp_backoff.cljs$lang$applyTo = (function (seq24099){
var G__24100 = cljs.core.first(seq24099);
var seq24099__$1 = cljs.core.next(seq24099);
return taoensso.encore.exp_backoff.cljs$core$IFn$_invoke$arity$variadic(G__24100,seq24099__$1);
});

taoensso.encore.now_dt = (function taoensso$encore$now_dt(){
return (new Date());
});
taoensso.encore.now_udt = (function taoensso$encore$now_udt(){
return (new Date()).getTime();
});
/**
 * Useful for testing.
 */
taoensso.encore.now_udt_mock_fn = (function taoensso$encore$now_udt_mock_fn(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24117 = arguments.length;
var i__9182__auto___24118 = (0);
while(true){
if((i__9182__auto___24118 < len__9181__auto___24117)){
args__9188__auto__.push((arguments[i__9182__auto___24118]));

var G__24119 = (i__9182__auto___24118 + (1));
i__9182__auto___24118 = G__24119;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p__24113){
var vec__24114 = p__24113;
var mock_udts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24114,(0),null);
var mock_udts__$1 = (function (){var or__7960__auto__ = mock_udts;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}
})();
var idx = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.atom.call(null,(-1)));
return ((function (mock_udts__$1,idx,vec__24114,mock_udts){
return (function (){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(mock_udts__$1,cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(idx,cljs.core.inc));
});
;})(mock_udts__$1,idx,vec__24114,mock_udts))
});

taoensso.encore.now_udt_mock_fn.cljs$lang$maxFixedArity = (0);

taoensso.encore.now_udt_mock_fn.cljs$lang$applyTo = (function (seq24112){
return taoensso.encore.now_udt_mock_fn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24112));
});

taoensso.encore.secs__GT_ms = (function taoensso$encore$secs__GT_ms(secs){
return cljs.core.long$((secs * 1000.0));
});
taoensso.encore.ms__GT_secs = (function taoensso$encore$ms__GT_secs(ms){
return cljs.core.quot(ms,(1000));
});
/**
 * Returns number of milliseconds in period defined by given args.
 */
taoensso.encore.ms = (function taoensso$encore$ms(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24125 = arguments.length;
var i__9182__auto___24126 = (0);
while(true){
if((i__9182__auto___24126 < len__9181__auto___24125)){
args__9188__auto__.push((arguments[i__9182__auto___24126]));

var G__24127 = (i__9182__auto___24126 + (1));
i__9182__auto___24126 = G__24127;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic = (function (p__24121){
var map__24122 = p__24121;
var map__24122__$1 = ((((!((map__24122 == null)))?((((map__24122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24122.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24122):map__24122);
var opts = map__24122__$1;
var years = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$years);
var months = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$months);
var weeks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$weeks);
var days = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$days);
var hours = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$hours);
var mins = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$mins);
var secs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$secs);
var msecs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$msecs);
var ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24122__$1,cljs.core.cst$kw$ms);
if(cljs.core.truth_(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (map__24122,map__24122__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (have_in__24124){
return taoensso.encore.hcond(false,"taoensso.encore",666,(new cljs.core.Delay(((function (map__24122,map__24122__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms){
return (function (){
return have_in__24124;
});})(map__24122,map__24122__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,null)),cljs.core.cst$sym$have_DASH_in__24124,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$kw$msecs,null,cljs.core.cst$kw$secs,null,cljs.core.cst$kw$months,null,cljs.core.cst$kw$days,null,cljs.core.cst$kw$mins,null,cljs.core.cst$kw$hours,null,cljs.core.cst$kw$years,null,cljs.core.cst$kw$ms,null,cljs.core.cst$kw$weeks,null], null), null));
});})(map__24122,map__24122__$1,opts,years,months,weeks,days,hours,mins,secs,msecs,ms))
,cljs.core.keys(opts)))){
} else {
throw (new Error("Assert failed: (have #{:msecs :secs :months :days :mins :hours :years :ms :weeks} :in (keys opts))"));
}

return taoensso.encore.round((((((((((cljs.core.truth_(years)?(((((years * (1000)) * (60)) * (60)) * (24)) * (365)):0.0) + (cljs.core.truth_(months)?(((((months * (1000)) * (60)) * (60)) * (24)) * 29.53):0.0)) + (cljs.core.truth_(weeks)?(((((weeks * (1000)) * (60)) * (60)) * (24)) * (7)):0.0)) + (cljs.core.truth_(days)?((((days * (1000)) * (60)) * (60)) * (24)):0.0)) + (cljs.core.truth_(hours)?(((hours * (1000)) * (60)) * (60)):0.0)) + (cljs.core.truth_(mins)?((mins * (1000)) * (60)):0.0)) + (cljs.core.truth_(secs)?(secs * (1000)):0.0)) + (cljs.core.truth_(msecs)?msecs:0.0)) + (cljs.core.truth_(ms)?ms:0.0)));
});

taoensso.encore.ms.cljs$lang$maxFixedArity = (0);

taoensso.encore.ms.cljs$lang$applyTo = (function (seq24120){
return taoensso.encore.ms.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24120));
});

taoensso.encore.secs = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(taoensso.encore.ms__GT_secs,taoensso.encore.ms);
taoensso.encore.singleton_QMARK_ = (function taoensso$encore$singleton_QMARK_(coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(coll),(1));
} else {
return cljs.core.not(cljs.core.next(coll));
}
});
taoensso.encore.__GT__QMARK_singleton = (function taoensso$encore$__GT__QMARK_singleton(coll){
if(cljs.core.truth_(taoensso.encore.singleton_QMARK_(coll))){
var vec__24135 = coll;
var c1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24135,(0),null);
return c1;
} else {
return null;
}
});
taoensso.encore.__GT_vec = (function taoensso$encore$__GT_vec(x){
if(cljs.core.vector_QMARK_(x)){
return x;
} else {
if(cljs.core.sequential_QMARK_(x)){
return cljs.core.vec(x);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [x], null);

}
}
});
taoensso.encore.vsplit_first = (function taoensso$encore$vsplit_first(v){
var vec__24141 = v;
var v1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24141,(0),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v1,(((cljs.core.count(v) > (1)))?cljs.core.subvec.cljs$core$IFn$_invoke$arity$2(v,(1)):null)], null);
});
taoensso.encore.nnil_set = (function taoensso$encore$nnil_set(x){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(taoensso.encore.set_STAR_(x),null);
});
taoensso.encore.conj_some = (function taoensso$encore$conj_some(var_args){
var args24144 = [];
var len__9181__auto___24150 = arguments.length;
var i__9182__auto___24151 = (0);
while(true){
if((i__9182__auto___24151 < len__9181__auto___24150)){
args24144.push((arguments[i__9182__auto___24151]));

var G__24152 = (i__9182__auto___24151 + (1));
i__9182__auto___24151 = G__24152;
continue;
} else {
}
break;
}

var G__24149 = args24144.length;
switch (G__24149) {
case 2:
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24144.slice((2)),(0),null));
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9204__auto__);

}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2 = (function (coll,_QMARK_x){
if(cljs.core.truth_(taoensso.encore.nnil_QMARK_(_QMARK_x))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x);
} else {
return coll;
}
});

taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic = (function (coll,_QMARK_x,_QMARK_xs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(taoensso.encore.conj_some,taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$2(coll,_QMARK_x),_QMARK_xs);
});

taoensso.encore.conj_some.cljs$lang$applyTo = (function (seq24145){
var G__24146 = cljs.core.first(seq24145);
var seq24145__$1 = cljs.core.next(seq24145);
var G__24147 = cljs.core.first(seq24145__$1);
var seq24145__$2 = cljs.core.next(seq24145__$1);
return taoensso.encore.conj_some.cljs$core$IFn$_invoke$arity$variadic(G__24146,G__24147,seq24145__$2);
});

taoensso.encore.conj_some.cljs$lang$maxFixedArity = (2);

/**
 * `run!` from Clojure 1.7+
 */
taoensso.encore.backport_run_BANG_ = (function taoensso$encore$backport_run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__24155_SHARP_,p2__24154_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__24154_SHARP_) : proc.call(null,p2__24154_SHARP_));
}),null,coll);
});
taoensso.encore.translate_signed_idx = (function taoensso$encore$translate_signed_idx(signed_idx,max_idx){
if((signed_idx >= (0))){
var x__8305__auto__ = signed_idx;
var y__8306__auto__ = max_idx;
return ((x__8305__auto__ < y__8306__auto__) ? x__8305__auto__ : y__8306__auto__);
} else {
var x__8298__auto__ = (0);
var y__8299__auto__ = (signed_idx + max_idx);
return ((x__8298__auto__ > y__8299__auto__) ? x__8298__auto__ : y__8299__auto__);
}
});
/**
 * Returns [<inclusive-start-idx*> <exclusive-end-idx*>] for counted 0-indexed
 *   input (str, vec, etc.) with support for:
 *  * Clamping of indexes beyond limits.
 *  * Max-length -> end-index.
 *  * -ive indexes (as +ive indexes but work from back of input):
 *    (+0) (+1) (+2) (+3) (+4)  ; inclusive +ive indexes
 *      h    e    l    l    o   ; 5 count
 *    (-5) (-4) (-3) (-2) (-1)  ; inclusive -ive indexes
 */
taoensso.encore.sub_indexes = (function taoensso$encore$sub_indexes(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24162 = arguments.length;
var i__9182__auto___24163 = (0);
while(true){
if((i__9182__auto___24163 < len__9181__auto___24162)){
args__9188__auto__.push((arguments[i__9182__auto___24163]));

var G__24164 = (i__9182__auto___24163 + (1));
i__9182__auto___24163 = G__24164;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic = (function (x,start_idx,p__24159){
var map__24160 = p__24159;
var map__24160__$1 = ((((!((map__24160 == null)))?((((map__24160.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24160.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24160):map__24160);
var max_len = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24160__$1,cljs.core.cst$kw$max_DASH_len);
var end_idx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24160__$1,cljs.core.cst$kw$end_DASH_idx);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__24160,map__24160__$1,max_len,end_idx){
return (function (){
return max_len;
});})(map__24160,map__24160__$1,max_len,end_idx))
,null)),cljs.core.cst$sym$max_DASH_len,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] max-len)"));
}

var start_idx__$1 = start_idx;
var xlen = cljs.core.count(x);
var start_idx_STAR_ = taoensso.encore.translate_signed_idx(start_idx__$1,xlen);
var end_idx_STAR_ = (cljs.core.truth_(max_len)?(function (){var n1__23219__auto__ = (start_idx_STAR_ + max_len);
var n2__23220__auto__ = xlen;
if((n1__23219__auto__ > n2__23220__auto__)){
return n2__23220__auto__;
} else {
return n1__23219__auto__;
}
})():(cljs.core.truth_(end_idx)?(taoensso.encore.translate_signed_idx(end_idx,xlen) + (1)):xlen
));
if((start_idx_STAR_ > end_idx_STAR_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_idx_STAR_,end_idx_STAR_], null);
}
});

taoensso.encore.sub_indexes.cljs$lang$maxFixedArity = (2);

taoensso.encore.sub_indexes.cljs$lang$applyTo = (function (seq24156){
var G__24157 = cljs.core.first(seq24156);
var seq24156__$1 = cljs.core.next(seq24156);
var G__24158 = cljs.core.first(seq24156__$1);
var seq24156__$2 = cljs.core.next(seq24156__$1);
return taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(G__24157,G__24158,seq24156__$2);
});

/**
 * Like `subvec` but uses `sub-indexes`.
 */
taoensso.encore.subvec_STAR_ = (function taoensso$encore$subvec_STAR_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24175 = arguments.length;
var i__9182__auto___24176 = (0);
while(true){
if((i__9182__auto___24176 < len__9181__auto___24175)){
args__9188__auto__.push((arguments[i__9182__auto___24176]));

var G__24177 = (i__9182__auto___24176 + (1));
i__9182__auto___24176 = G__24177;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (v,start_idx,p__24168){
var vec__24169 = p__24168;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24169,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24169,_QMARK_max_len){
return (function (){
return v;
});})(vec__24169,_QMARK_max_len))
,null)),cljs.core.cst$sym$v,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? vector? v)"));
}

var vec__24172 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(v,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24172,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24172,(1),null);
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.subvec_STAR_.cljs$lang$maxFixedArity = (2);

taoensso.encore.subvec_STAR_.cljs$lang$applyTo = (function (seq24165){
var G__24166 = cljs.core.first(seq24165);
var seq24165__$1 = cljs.core.next(seq24165);
var G__24167 = cljs.core.first(seq24165__$1);
var seq24165__$2 = cljs.core.next(seq24165__$1);
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__24166,G__24167,seq24165__$2);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.encore.Swapped = (function (new_val,return_val,__meta,__extmap,__hash){
this.new_val = new_val;
this.return_val = return_val;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8635__auto__,k__8636__auto__){
var self__ = this;
var this__8635__auto____$1 = this;
return this__8635__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8636__auto__,null);
});

taoensso.encore.Swapped.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8637__auto__,k24179,else__8638__auto__){
var self__ = this;
var this__8637__auto____$1 = this;
var G__24181 = (((k24179 instanceof cljs.core.Keyword))?k24179.fqn:null);
switch (G__24181) {
case "new-val":
return self__.new_val;

break;
case "return-val":
return self__.return_val;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k24179,else__8638__auto__);

}
});

taoensso.encore.Swapped.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8649__auto__,writer__8650__auto__,opts__8651__auto__){
var self__ = this;
var this__8649__auto____$1 = this;
var pr_pair__8652__auto__ = ((function (this__8649__auto____$1){
return (function (keyval__8653__auto__){
return cljs.core.pr_sequential_writer(writer__8650__auto__,cljs.core.pr_writer,""," ","",opts__8651__auto__,keyval__8653__auto__);
});})(this__8649__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__8650__auto__,pr_pair__8652__auto__,"#taoensso.encore.Swapped{",", ","}",opts__8651__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.encore.Swapped.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__24178){
var self__ = this;
var G__24178__$1 = this;
return (new cljs.core.RecordIter((0),G__24178__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val,cljs.core.cst$kw$return_DASH_val], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.encore.Swapped.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8633__auto__){
var self__ = this;
var this__8633__auto____$1 = this;
return self__.__meta;
});

taoensso.encore.Swapped.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8629__auto__){
var self__ = this;
var this__8629__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8639__auto__){
var self__ = this;
var this__8639__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8630__auto__){
var self__ = this;
var this__8630__auto____$1 = this;
var h__8402__auto__ = self__.__hash;
if(!((h__8402__auto__ == null))){
return h__8402__auto__;
} else {
var h__8402__auto____$1 = cljs.core.hash_imap(this__8630__auto____$1);
self__.__hash = h__8402__auto____$1;

return h__8402__auto____$1;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8631__auto__,other__8632__auto__){
var self__ = this;
var this__8631__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7948__auto__ = other__8632__auto__;
if(cljs.core.truth_(and__7948__auto__)){
return ((this__8631__auto____$1.constructor === other__8632__auto__.constructor)) && (cljs.core.equiv_map(this__8631__auto____$1,other__8632__auto__));
} else {
return and__7948__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.encore.Swapped.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8644__auto__,k__8645__auto__){
var self__ = this;
var this__8644__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$return_DASH_val,null,cljs.core.cst$kw$new_DASH_val,null], null), null),k__8645__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__8644__auto____$1),self__.__meta),k__8645__auto__);
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__8645__auto__)),null));
}
});

taoensso.encore.Swapped.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8642__auto__,k__8643__auto__,G__24178){
var self__ = this;
var this__8642__auto____$1 = this;
var pred__24182 = cljs.core.keyword_identical_QMARK_;
var expr__24183 = k__8643__auto__;
if(cljs.core.truth_((function (){var G__24185 = cljs.core.cst$kw$new_DASH_val;
var G__24186 = expr__24183;
return (pred__24182.cljs$core$IFn$_invoke$arity$2 ? pred__24182.cljs$core$IFn$_invoke$arity$2(G__24185,G__24186) : pred__24182.call(null,G__24185,G__24186));
})())){
return (new taoensso.encore.Swapped(G__24178,self__.return_val,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__24187 = cljs.core.cst$kw$return_DASH_val;
var G__24188 = expr__24183;
return (pred__24182.cljs$core$IFn$_invoke$arity$2 ? pred__24182.cljs$core$IFn$_invoke$arity$2(G__24187,G__24188) : pred__24182.call(null,G__24187,G__24188));
})())){
return (new taoensso.encore.Swapped(self__.new_val,G__24178,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__8643__auto__,G__24178),null));
}
}
});

taoensso.encore.Swapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8647__auto__){
var self__ = this;
var this__8647__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$new_DASH_val,self__.new_val],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$return_DASH_val,self__.return_val],null))], null),self__.__extmap));
});

taoensso.encore.Swapped.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8634__auto__,G__24178){
var self__ = this;
var this__8634__auto____$1 = this;
return (new taoensso.encore.Swapped(self__.new_val,self__.return_val,G__24178,self__.__extmap,self__.__hash));
});

taoensso.encore.Swapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8640__auto__,entry__8641__auto__){
var self__ = this;
var this__8640__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__8641__auto__)){
return this__8640__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__8640__auto____$1,entry__8641__auto__);
}
});

taoensso.encore.Swapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$new_DASH_val,cljs.core.cst$sym$return_DASH_val], null);
});

taoensso.encore.Swapped.cljs$lang$type = true;

taoensso.encore.Swapped.cljs$lang$ctorPrSeq = (function (this__8671__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.encore/Swapped");
});

taoensso.encore.Swapped.cljs$lang$ctorPrWriter = (function (this__8671__auto__,writer__8672__auto__){
return cljs.core._write(writer__8672__auto__,"taoensso.encore/Swapped");
});

taoensso.encore.__GT_Swapped = (function taoensso$encore$__GT_Swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});

taoensso.encore.map__GT_Swapped = (function taoensso$encore$map__GT_Swapped(G__24180){
return (new taoensso.encore.Swapped(cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(G__24180),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(G__24180),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__24180,cljs.core.cst$kw$new_DASH_val,cljs.core.array_seq([cljs.core.cst$kw$return_DASH_val], 0)),null));
});

taoensso.encore.swapped = (function taoensso$encore$swapped(new_val,return_val){
return (new taoensso.encore.Swapped(new_val,return_val,null,null,null));
});
taoensso.encore.swapped_QMARK_ = (function taoensso$encore$swapped_QMARK_(x){
return (x instanceof taoensso.encore.Swapped);
});
taoensso.encore.swapped_STAR_ = (function taoensso$encore$swapped_STAR_(x){
if(cljs.core.truth_(taoensso.encore.swapped_QMARK_(x))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$new_DASH_val.cljs$core$IFn$_invoke$arity$1(x),cljs.core.cst$kw$return_DASH_val.cljs$core$IFn$_invoke$arity$1(x)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [x,x], null);
}
});
/**
 * [<new-val> <return-val>]
 */
taoensso.encore.swapped_STAR__in = (function taoensso$encore$swapped_STAR__in(m,ks,f){
if(cljs.core.truth_((function (){var G__24203 = f;
var G__24204 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24203,G__24204) : taoensso.encore.kw_identical_QMARK_.call(null,G__24203,G__24204));
})())){
return taoensso.encore.swapped_STAR_((function (){var G__24205 = m;
var G__24206 = cljs.core.butlast(ks);
var G__24207 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__24205,G__24206,G__24207) : taoensso.encore.dissoc_in.call(null,G__24205,G__24206,G__24207));
})());
} else {
var old_val_in = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(m,ks);
var vec__24208 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val_in) : f.call(null,old_val_in)));
var new_val_in = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24208,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24208,(1),null);
var new_val = (cljs.core.truth_((function (){var G__24211 = new_val_in;
var G__24212 = cljs.core.cst$kw$swap_SLASH_dissoc;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24211,G__24212) : taoensso.encore.kw_identical_QMARK_.call(null,G__24211,G__24212));
})())?(function (){var G__24213 = m;
var G__24214 = cljs.core.butlast(ks);
var G__24215 = cljs.core.last(ks);
return (taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3 ? taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$3(G__24213,G__24214,G__24215) : taoensso.encore.dissoc_in.call(null,G__24213,G__24214,G__24215));
})():cljs.core.assoc_in(m,ks,new_val_in));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_val,return_val], null);
}
});
/**
 * Reduces input with
 *   [<type> <ks> <reset-val-or-swap-fn>] or
 *       [<ks> <reset-val-or-swap-fn>] ops.
 */
taoensso.encore.replace_in_STAR_ = (function taoensso$encore$replace_in_STAR_(_QMARK_vf_type,m,ops){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (accum,_QMARK_op){
if(cljs.core.not(_QMARK_op)){
return accum;
} else {
var vec__24220 = ((cljs.core.not(_QMARK_vf_type))?_QMARK_op:cljs.core.cons(_QMARK_vf_type,_QMARK_op));
var vf_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24220,(0),null);
var ks = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24220,(1),null);
var valf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24220,(2),null);
var G__24223 = (((vf_type instanceof cljs.core.Keyword))?vf_type.fqn:null);
switch (G__24223) {
case "reset":
if(cljs.core.empty_QMARK_(ks)){
return valf;
} else {
return cljs.core.assoc_in(accum,ks,valf);
}

break;
case "swap":
if(cljs.core.empty_QMARK_(ks)){
return (valf.cljs$core$IFn$_invoke$arity$1 ? valf.cljs$core$IFn$_invoke$arity$1(accum) : valf.call(null,accum));
} else {
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(taoensso.encore.swapped_STAR__in(accum,ks,valf),(0));
}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(vf_type)].join('')));

}
}
}),m,ops);
});
/**
 * Experimental. For use with `swap!`, etc.
 */
taoensso.encore.replace_in = (function taoensso$encore$replace_in(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24227 = arguments.length;
var i__9182__auto___24228 = (0);
while(true){
if((i__9182__auto___24228 < len__9181__auto___24227)){
args__9188__auto__.push((arguments[i__9182__auto___24228]));

var G__24229 = (i__9182__auto___24228 + (1));
i__9182__auto___24228 = G__24229;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ops){
return taoensso.encore.replace_in_STAR_(null,m,ops);
});

taoensso.encore.replace_in.cljs$lang$maxFixedArity = (1);

taoensso.encore.replace_in.cljs$lang$applyTo = (function (seq24225){
var G__24226 = cljs.core.first(seq24225);
var seq24225__$1 = cljs.core.next(seq24225);
return taoensso.encore.replace_in.cljs$core$IFn$_invoke$arity$variadic(G__24226,seq24225__$1);
});

/**
 * More powerful version of `swap!`:
 *  * Supports optional `update-in` semantics.
 *  * Swap fn can return `(swapped <new-val> <return-val>)` rather than just
 *    <new-val>. This is useful when writing atomic pull fns, etc.
 */
taoensso.encore.swap_in_BANG_ = (function taoensso$encore$swap_in_BANG_(var_args){
var args24230 = [];
var len__9181__auto___24243 = arguments.length;
var i__9182__auto___24244 = (0);
while(true){
if((i__9182__auto___24244 < len__9181__auto___24243)){
args24230.push((arguments[i__9182__auto___24244]));

var G__24245 = (i__9182__auto___24244 + (1));
i__9182__auto___24244 = G__24245;
continue;
} else {
}
break;
}

var G__24236 = args24230.length;
switch (G__24236) {
case 3:
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24230.slice((3)),(0),null));
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9204__auto__);

}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,f){
if(cljs.core.empty_QMARK_(ks)){
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__24237 = taoensso.encore.swapped_STAR_((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(old_val) : f.call(null,old_val)));
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24237,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24237,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
} else {
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var vec__24240 = taoensso.encore.swapped_STAR__in(old_val,ks,f);
var new_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24240,(0),null);
var return_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24240,(1),null);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return return_val;
}
break;
}
}
});

taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,f,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,f], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$swap,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val], null);
}
break;
}
});

taoensso.encore.swap_in_BANG_.cljs$lang$applyTo = (function (seq24231){
var G__24232 = cljs.core.first(seq24231);
var seq24231__$1 = cljs.core.next(seq24231);
var G__24233 = cljs.core.first(seq24231__$1);
var seq24231__$2 = cljs.core.next(seq24231__$1);
var G__24234 = cljs.core.first(seq24231__$2);
var seq24231__$3 = cljs.core.next(seq24231__$2);
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24232,G__24233,G__24234,seq24231__$3);
});

taoensso.encore.swap_in_BANG_.cljs$lang$maxFixedArity = (3);

/**
 * Is to `reset!` as `swap-in!` is to `swap!`.
 */
taoensso.encore.reset_in_BANG_ = (function taoensso$encore$reset_in_BANG_(var_args){
var args24247 = [];
var len__9181__auto___24254 = arguments.length;
var i__9182__auto___24255 = (0);
while(true){
if((i__9182__auto___24255 < len__9181__auto___24254)){
args24247.push((arguments[i__9182__auto___24255]));

var G__24256 = (i__9182__auto___24255 + (1));
i__9182__auto___24255 = G__24256;
continue;
} else {
}
break;
}

var G__24253 = args24247.length;
switch (G__24253) {
case 3:
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24247.slice((3)),(0),null));
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__9204__auto__);

}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (atom_,ks,new_val){
if(cljs.core.empty_QMARK_(ks)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,new_val) : cljs.core.reset_BANG_.call(null,atom_,new_val));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(atom_,(function (old_val){
return cljs.core.assoc_in(old_val,ks,new_val);
}));
}
});

taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (atom_,ks,new_val,more){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(more);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$more),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count more))"));
}

var pairs = cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ks,new_val], null)], null),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),more));
while(true){
var old_val = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_val__$1 = taoensso.encore.replace_in_STAR_(cljs.core.cst$kw$reset,old_val,pairs);
if(cljs.core.not(cljs.core.compare_and_set_BANG_(atom_,old_val,new_val__$1))){
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$old,old_val,cljs.core.cst$kw$new,new_val__$1], null);
}
break;
}
});

taoensso.encore.reset_in_BANG_.cljs$lang$applyTo = (function (seq24248){
var G__24249 = cljs.core.first(seq24248);
var seq24248__$1 = cljs.core.next(seq24248);
var G__24250 = cljs.core.first(seq24248__$1);
var seq24248__$2 = cljs.core.next(seq24248__$1);
var G__24251 = cljs.core.first(seq24248__$2);
var seq24248__$3 = cljs.core.next(seq24248__$2);
return taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__24249,G__24250,G__24251,seq24248__$3);
});

taoensso.encore.reset_in_BANG_.cljs$lang$maxFixedArity = (3);

taoensso.encore.dissoc_in = (function taoensso$encore$dissoc_in(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24261 = arguments.length;
var i__9182__auto___24262 = (0);
while(true){
if((i__9182__auto___24262 < len__9181__auto___24261)){
args__9188__auto__.push((arguments[i__9182__auto___24262]));

var G__24263 = (i__9182__auto___24262 + (1));
i__9182__auto___24262 = G__24263;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,ks,dissoc_ks){
if(cljs.core.empty_QMARK_(ks)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m,dissoc_ks);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(cljs.core.update_in,m,ks,cljs.core.dissoc,dissoc_ks);
}
});

taoensso.encore.dissoc_in.cljs$lang$maxFixedArity = (2);

taoensso.encore.dissoc_in.cljs$lang$applyTo = (function (seq24258){
var G__24259 = cljs.core.first(seq24258);
var seq24258__$1 = cljs.core.next(seq24258);
var G__24260 = cljs.core.first(seq24258__$1);
var seq24258__$2 = cljs.core.next(seq24258__$1);
return taoensso.encore.dissoc_in.cljs$core$IFn$_invoke$arity$variadic(G__24259,G__24260,seq24258__$2);
});

taoensso.encore.contains_in_QMARK_ = (function taoensso$encore$contains_in_QMARK_(coll,ks){
return cljs.core.contains_QMARK_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.butlast(ks)),cljs.core.last(ks));
});
/**
 * Assocs each kv iff its value is not nil.
 */
taoensso.encore.assoc_some = (function taoensso$encore$assoc_some(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24284 = arguments.length;
var i__9182__auto___24285 = (0);
while(true){
if((i__9182__auto___24285 < len__9181__auto___24284)){
args__9188__auto__.push((arguments[i__9182__auto___24285]));

var G__24286 = (i__9182__auto___24285 + (1));
i__9182__auto___24285 = G__24286;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7960__auto__ = m;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8822__auto__ = (function taoensso$encore$iter__24266(s__24267){
return (new cljs.core.LazySeq(null,(function (){
var s__24267__$1 = s__24267;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__24267__$1);
if(temp__5457__auto__){
var s__24267__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24267__$2)){
var c__8820__auto__ = cljs.core.chunk_first(s__24267__$2);
var size__8821__auto__ = cljs.core.count(c__8820__auto__);
var b__24269 = cljs.core.chunk_buffer(size__8821__auto__);
if((function (){var i__24268 = (0);
while(true){
if((i__24268 < size__8821__auto__)){
var vec__24278 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8820__auto__,i__24268);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24278,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24278,(1),null);
if(!((v == null))){
cljs.core.chunk_append(b__24269,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__24287 = (i__24268 + (1));
i__24268 = G__24287;
continue;
} else {
var G__24288 = (i__24268 + (1));
i__24268 = G__24288;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24269),taoensso$encore$iter__24266(cljs.core.chunk_rest(s__24267__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24269),null);
}
} else {
var vec__24281 = cljs.core.first(s__24267__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24281,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24281,(1),null);
if(!((v == null))){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__24266(cljs.core.rest(s__24267__$2)));
} else {
var G__24289 = cljs.core.rest(s__24267__$2);
s__24267__$1 = G__24289;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8822__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_some.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_some.cljs$lang$applyTo = (function (seq24264){
var G__24265 = cljs.core.first(seq24264);
var seq24264__$1 = cljs.core.next(seq24264);
return taoensso.encore.assoc_some.cljs$core$IFn$_invoke$arity$variadic(G__24265,seq24264__$1);
});

/**
 * Assocs each kv iff its val is truthy.
 */
taoensso.encore.assoc_when = (function taoensso$encore$assoc_when(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24310 = arguments.length;
var i__9182__auto___24311 = (0);
while(true){
if((i__9182__auto___24311 < len__9181__auto___24310)){
args__9188__auto__.push((arguments[i__9182__auto___24311]));

var G__24312 = (i__9182__auto___24311 + (1));
i__9182__auto___24311 = G__24312;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic = (function (m,kvs){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cljs.core.count(kvs);
}),null)),cljs.core.list(cljs.core.cst$sym$count,cljs.core.cst$sym$kvs),cljs.core.even_QMARK_,cljs.core.cst$sym$even_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? even? (count kvs))"));
}

return cljs.core.into.cljs$core$IFn$_invoke$arity$2((function (){var or__7960__auto__ = m;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),(function (){var iter__8822__auto__ = (function taoensso$encore$iter__24292(s__24293){
return (new cljs.core.LazySeq(null,(function (){
var s__24293__$1 = s__24293;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__24293__$1);
if(temp__5457__auto__){
var s__24293__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24293__$2)){
var c__8820__auto__ = cljs.core.chunk_first(s__24293__$2);
var size__8821__auto__ = cljs.core.count(c__8820__auto__);
var b__24295 = cljs.core.chunk_buffer(size__8821__auto__);
if((function (){var i__24294 = (0);
while(true){
if((i__24294 < size__8821__auto__)){
var vec__24304 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8820__auto__,i__24294);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24304,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24304,(1),null);
if(cljs.core.truth_(v)){
cljs.core.chunk_append(b__24295,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null));

var G__24313 = (i__24294 + (1));
i__24294 = G__24313;
continue;
} else {
var G__24314 = (i__24294 + (1));
i__24294 = G__24314;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24295),taoensso$encore$iter__24292(cljs.core.chunk_rest(s__24293__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24295),null);
}
} else {
var vec__24307 = cljs.core.first(s__24293__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24307,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24307,(1),null);
if(cljs.core.truth_(v)){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,v], null),taoensso$encore$iter__24292(cljs.core.rest(s__24293__$2)));
} else {
var G__24315 = cljs.core.rest(s__24293__$2);
s__24293__$1 = G__24315;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__8822__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),kvs));
})());
});

taoensso.encore.assoc_when.cljs$lang$maxFixedArity = (1);

taoensso.encore.assoc_when.cljs$lang$applyTo = (function (seq24290){
var G__24291 = cljs.core.first(seq24290);
var seq24290__$1 = cljs.core.next(seq24290);
return taoensso.encore.assoc_when.cljs$core$IFn$_invoke$arity$variadic(G__24291,seq24290__$1);
});

taoensso.encore.queue_QMARK_ = (function taoensso$encore$queue_QMARK_(x){
return (x instanceof cljs.core.PersistentQueue);
});
/**
 * Returns a PersistentQueue.
 */
taoensso.encore.queue = (function taoensso$encore$queue(var_args){
var args24316 = [];
var len__9181__auto___24319 = arguments.length;
var i__9182__auto___24320 = (0);
while(true){
if((i__9182__auto___24320 < len__9181__auto___24319)){
args24316.push((arguments[i__9182__auto___24320]));

var G__24321 = (i__9182__auto___24320 + (1));
i__9182__auto___24320 = G__24321;
continue;
} else {
}
break;
}

var G__24318 = args24316.length;
switch (G__24318) {
case 0:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args24316.length)].join('')));

}
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentQueue.EMPTY;
});

taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(taoensso.encore.queue.cljs$core$IFn$_invoke$arity$0(),coll);
});

taoensso.encore.queue.cljs$lang$maxFixedArity = 1;

taoensso.encore.queue_STAR_ = (function taoensso$encore$queue_STAR_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24324 = arguments.length;
var i__9182__auto___24325 = (0);
while(true){
if((i__9182__auto___24325 < len__9181__auto___24324)){
args__9188__auto__.push((arguments[i__9182__auto___24325]));

var G__24326 = (i__9182__auto___24325 + (1));
i__9182__auto___24325 = G__24326;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (items){
return taoensso.encore.queue.cljs$core$IFn$_invoke$arity$1(items);
});

taoensso.encore.queue_STAR_.cljs$lang$maxFixedArity = (0);

taoensso.encore.queue_STAR_.cljs$lang$applyTo = (function (seq24323){
return taoensso.encore.queue_STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24323));
});

/**
 * (seq     {:a :A}) => ([:a :A])
 * (seq-kvs {:a :A}) => (:a :A)
 */
taoensso.encore.seq_kvs = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce,cljs.core.concat);
/**
 * Like `apply` but assumes last arg is a map whose elements should be applied
 *   to `f` as an unpaired seq:
 *  (mapply (fn [x & {:keys [y z]}] (str x y z)) 1 {:y 2 :z 3})
 *    where fn will receive args as: `(1 :y 2 :z 3)`.
 */
taoensso.encore.mapply = (function taoensso$encore$mapply(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24330 = arguments.length;
var i__9182__auto___24331 = (0);
while(true){
if((i__9182__auto___24331 < len__9181__auto___24330)){
args__9188__auto__.push((arguments[i__9182__auto___24331]));

var G__24332 = (i__9182__auto___24331 + (1));
i__9182__auto___24331 = G__24332;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic = (function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(args),(function (){var G__24329 = cljs.core.last(args);
return (taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.seq_kvs.cljs$core$IFn$_invoke$arity$1(G__24329) : taoensso.encore.seq_kvs.call(null,G__24329));
})()));
});

taoensso.encore.mapply.cljs$lang$maxFixedArity = (1);

taoensso.encore.mapply.cljs$lang$applyTo = (function (seq24327){
var G__24328 = cljs.core.first(seq24327);
var seq24327__$1 = cljs.core.next(seq24327);
return taoensso.encore.mapply.cljs$core$IFn$_invoke$arity$variadic(G__24328,seq24327__$1);
});

/**
 * Workaround for Clojure versions [1.4, 1.5) that blow up on `reduce-kv`s
 *   against a nil coll, Ref. http://dev.clojure.org/jira/browse/CLJ-1098.
 */
taoensso.encore.clj1098 = (function taoensso$encore$clj1098(x){
var or__7960__auto__ = x;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
});
taoensso.encore.map_kvs = (function taoensso$encore$map_kvs(kf,vf,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var kf__$1 = ((cljs.core.not((function (){var G__24337 = kf;
var G__24338 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24337,G__24338) : taoensso.encore.kw_identical_QMARK_.call(null,G__24337,G__24338));
})()))?kf:(function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
}));
var vf__$1 = ((cljs.core.not((function (){var G__24339 = vf;
var G__24340 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24339,G__24340) : taoensso.encore.kw_identical_QMARK_.call(null,G__24339,G__24340));
})()))?vf:((function (kf__$1){
return (function (_,v){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(v);
});})(kf__$1))
);
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kf__$1,vf__$1){
return (function (m__$1,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,(cljs.core.truth_(kf__$1)?(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : kf__$1.call(null,k,v)):k),(cljs.core.truth_(vf__$1)?(vf__$1.cljs$core$IFn$_invoke$arity$2 ? vf__$1.cljs$core$IFn$_invoke$arity$2(k,v) : vf__$1.call(null,k,v)):v));
});})(kf__$1,vf__$1))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
}
});
taoensso.encore.map_keys = (function taoensso$encore$map_keys(f,m){
return taoensso.encore.map_kvs((function (k,_){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null,k));
}),null,m);
});
taoensso.encore.map_vals = (function taoensso$encore$map_vals(f,m){
return taoensso.encore.map_kvs(null,(function (_,v){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null,v));
}),m);
});
taoensso.encore.filter_kvs = (function taoensso$encore$filter_kvs(predk,predv,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((function (){var and__7948__auto__ = (predk.cljs$core$IFn$_invoke$arity$1 ? predk.cljs$core$IFn$_invoke$arity$1(k) : predk.call(null,k));
if(cljs.core.truth_(and__7948__auto__)){
return (predv.cljs$core$IFn$_invoke$arity$1 ? predv.cljs$core$IFn$_invoke$arity$1(v) : predv.call(null,v));
} else {
return and__7948__auto__;
}
})())){
return m__$1;
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
}
}),m,m);
}
});
taoensso.encore.filter_keys = (function taoensso$encore$filter_keys(pred,m){
return taoensso.encore.filter_kvs(pred,cljs.core.constantly(true),m);
});
taoensso.encore.filter_vals = (function taoensso$encore$filter_vals(pred,m){
return taoensso.encore.filter_kvs(cljs.core.constantly(true),pred,m);
});
/**
 * Smaller, common-case version of `filter-vals`. Esp useful with `nil?`/`blank?`
 *   pred when constructing maps: {:foo (when _ <...>) :bar (when _ <...>)} in a
 *   way that preservers :or semantics.
 */
taoensso.encore.remove_vals = (function taoensso$encore$remove_vals(pred,m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m__$1,k);
} else {
return m__$1;
}
}),m,m);
}
});
taoensso.encore.keywordize_map = (function taoensso$encore$keywordize_map(m){
if(cljs.core.not(m)){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
return cljs.core.reduce_kv((function (m__$1,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),v);
}),cljs.core.PersistentArrayMap.EMPTY,m);
}
});
/**
 * Cross between `hash-map` & `map-kvs`.
 */
taoensso.encore.as_map = (function taoensso$encore$as_map(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24359 = arguments.length;
var i__9182__auto___24360 = (0);
while(true){
if((i__9182__auto___24360 < len__9181__auto___24359)){
args__9188__auto__.push((arguments[i__9182__auto___24360]));

var G__24361 = (i__9182__auto___24360 + (1));
i__9182__auto___24360 = G__24361;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic = (function (kvs,p__24343){
var vec__24344 = p__24343;
var kf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24344,(0),null);
var vf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24344,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24344,kf,vf){
return (function (){
return kvs;
});})(vec__24344,kf,vf))
,null)),cljs.core.cst$sym$kvs,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.sequential_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$sequential_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? sequential?] kvs)"));
}

if((function (){
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24344,kf,vf){
return (function (){
return kf;
});})(vec__24344,kf,vf))
,null)),cljs.core.cst$sym$kf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null)),taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24344,kf,vf){
return (function (){
return vf;
});})(vec__24344,kf,vf))
,null)),cljs.core.cst$sym$vf,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.ifn_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$ifn_QMARK_], null))], null);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? ifn?] kf vf)"));
}

var _PERCENT_ = ((cljs.core.empty_QMARK_(kvs))?cljs.core.PersistentArrayMap.EMPTY:(function (){var kf__$1 = ((cljs.core.not((function (){var G__24347 = kf;
var G__24348 = cljs.core.cst$kw$keywordize;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24347,G__24348) : taoensso.encore.kw_identical_QMARK_.call(null,G__24347,G__24348));
})()))?kf:((function (vec__24344,kf,vf){
return (function (k,_){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k);
});})(vec__24344,kf,vf))
);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var G__24352 = kvs;
var vec__24353 = G__24352;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24353,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24353,(1),null);
var s = vec__24353;
var m__$1 = m;
var G__24352__$1 = G__24352;
while(true){
var m__$2 = m__$1;
var vec__24356 = G__24352__$1;
var k__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24356,(0),null);
var v__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24356,(1),null);
var s__$1 = vec__24356;
var k__$2 = ((cljs.core.not(kf__$1))?k__$1:(kf__$1.cljs$core$IFn$_invoke$arity$2 ? kf__$1.cljs$core$IFn$_invoke$arity$2(k__$1,v__$1) : kf__$1.call(null,k__$1,v__$1)));
var v__$2 = ((cljs.core.not(vf))?v__$1:(vf.cljs$core$IFn$_invoke$arity$2 ? vf.cljs$core$IFn$_invoke$arity$2(k__$2,v__$1) : vf.call(null,k__$2,v__$1)));
var new_m = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$2,k__$2,v__$2);
var temp__5455__auto__ = cljs.core.nnext(s__$1);
if(cljs.core.truth_(temp__5455__auto__)){
var n = temp__5455__auto__;
var G__24362 = new_m;
var G__24363 = n;
m__$1 = G__24362;
G__24352__$1 = G__24363;
continue;
} else {
return cljs.core.persistent_BANG_(new_m);
}
break;
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__24344,kf,vf){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__24344,kf,vf))
,null)),cljs.core.cst$sym$_PERCENT_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] %)"));
}

return _PERCENT_;
});

taoensso.encore.as_map.cljs$lang$maxFixedArity = (1);

taoensso.encore.as_map.cljs$lang$applyTo = (function (seq24341){
var G__24342 = cljs.core.first(seq24341);
var seq24341__$1 = cljs.core.next(seq24341);
return taoensso.encore.as_map.cljs$core$IFn$_invoke$arity$variadic(G__24342,seq24341__$1);
});

/**
 * Faster `zipmap` using transients.
 */
taoensso.encore.fzipmap = (function taoensso$encore$fzipmap(ks,vs){
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks__$1 = cljs.core.seq(ks);
var vs__$1 = cljs.core.seq(vs);
while(true){
if(!((ks__$1) && (vs__$1))){
return cljs.core.persistent_BANG_(m);
} else {
var G__24364 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cljs.core.first(ks__$1),cljs.core.first(vs__$1));
var G__24365 = cljs.core.next(ks__$1);
var G__24366 = cljs.core.next(vs__$1);
m = G__24364;
ks__$1 = G__24365;
vs__$1 = G__24366;
continue;
}
break;
}
});
/**
 * Like `into` but supports multiple "from"s.
 */
taoensso.encore.into_all = (function taoensso$encore$into_all(var_args){
var args24367 = [];
var len__9181__auto___24373 = arguments.length;
var i__9182__auto___24374 = (0);
while(true){
if((i__9182__auto___24374 < len__9181__auto___24373)){
args24367.push((arguments[i__9182__auto___24374]));

var G__24375 = (i__9182__auto___24374 + (1));
i__9182__auto___24374 = G__24375;
continue;
} else {
}
break;
}

var G__24372 = args24367.length;
switch (G__24372) {
case 2:
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24367.slice((2)),(0),null));
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9204__auto__);

}
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from);
});

taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic = (function (to,from,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.into,cljs.core.into.cljs$core$IFn$_invoke$arity$2(to,from),more);
});

taoensso.encore.into_all.cljs$lang$applyTo = (function (seq24368){
var G__24369 = cljs.core.first(seq24368);
var seq24368__$1 = cljs.core.next(seq24368);
var G__24370 = cljs.core.first(seq24368__$1);
var seq24368__$2 = cljs.core.next(seq24368__$1);
return taoensso.encore.into_all.cljs$core$IFn$_invoke$arity$variadic(G__24369,G__24370,seq24368__$2);
});

taoensso.encore.into_all.cljs$lang$maxFixedArity = (2);

/**
 * Greedy version of `interleave`, Ref. http://goo.gl/KvzqWb.
 */
taoensso.encore.interleave_all = (function taoensso$encore$interleave_all(var_args){
var args24377 = [];
var len__9181__auto___24383 = arguments.length;
var i__9182__auto___24384 = (0);
while(true){
if((i__9182__auto___24384 < len__9181__auto___24383)){
args24377.push((arguments[i__9182__auto___24384]));

var G__24385 = (i__9182__auto___24384 + (1));
i__9182__auto___24384 = G__24385;
continue;
} else {
}
break;
}

var G__24382 = args24377.length;
switch (G__24382) {
case 0:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__9204__auto__ = (new cljs.core.IndexedSeq(args24377.slice((2)),(0),null));
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9204__auto__);

}
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
if(s1){
return s1;
} else {
if(s2){
return s2;
} else {
return null;
}
}
}
}),null,null));
});

taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0))));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.encore.interleave_all,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
}),null,null));
});

taoensso.encore.interleave_all.cljs$lang$applyTo = (function (seq24378){
var G__24379 = cljs.core.first(seq24378);
var seq24378__$1 = cljs.core.next(seq24378);
var G__24380 = cljs.core.first(seq24378__$1);
var seq24378__$2 = cljs.core.next(seq24378__$1);
return taoensso.encore.interleave_all.cljs$core$IFn$_invoke$arity$variadic(G__24379,G__24380,seq24378__$2);
});

taoensso.encore.interleave_all.cljs$lang$maxFixedArity = (2);

taoensso.encore.takev = (function taoensso$encore$takev(n,coll){
if(cljs.core.vector_QMARK_(coll)){
return taoensso.encore.subvec_STAR_.cljs$core$IFn$_invoke$arity$variadic(coll,(0),cljs.core.array_seq([n], 0));
} else {
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll));
}
});
/**
 * Prefer `set` when order doesn't matter (much faster).
 */
taoensso.encore.distinctv = (function taoensso$encore$distinctv(var_args){
var args24387 = [];
var len__9181__auto___24398 = arguments.length;
var i__9182__auto___24399 = (0);
while(true){
if((i__9182__auto___24399 < len__9181__auto___24398)){
args24387.push((arguments[i__9182__auto___24399]));

var G__24400 = (i__9182__auto___24399 + (1));
i__9182__auto___24399 = G__24400;
continue;
} else {
}
break;
}

var G__24389 = args24387.length;
switch (G__24389) {
case 1:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args24387.length)].join('')));

}
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__24390,in$){
var vec__24391 = p__24390;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24391,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24391,(1),null);
if(!(cljs.core.contains_QMARK_(seen,in$))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in$)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.persistent_BANG_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__24394,in$){
var vec__24395 = p__24394;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24395,(0),null);
var seen = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24395,(1),null);
var in_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(in$) : keyfn.call(null,in$));
if(!(cljs.core.contains_QMARK_(seen,in_STAR_))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,in$),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen,in_STAR_)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v,seen], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.transient$(cljs.core.PersistentVector.EMPTY),cljs.core.PersistentHashSet.EMPTY], null),coll),(0)));
});

taoensso.encore.distinctv.cljs$lang$maxFixedArity = 2;

/**
 * Like `sort-by` for distinct. Based on clojure.core/distinct.
 */
taoensso.encore.distinct_by = (function taoensso$encore$distinct_by(keyfn,coll){
var step = (function taoensso$encore$distinct_by_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__24418,seen__$1){
while(true){
var vec__24419 = p__24418;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24419,(0),null);
var xs__$1 = vec__24419;
var temp__5457__auto__ = cljs.core.seq(xs__$1);
if(temp__5457__auto__){
var s = temp__5457__auto__;
var v_STAR_ = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(v) : keyfn.call(null,v));
if(cljs.core.contains_QMARK_(seen__$1,v_STAR_)){
var G__24422 = cljs.core.rest(s);
var G__24423 = seen__$1;
p__24418 = G__24422;
seen__$1 = G__24423;
continue;
} else {
return cljs.core.cons(v,taoensso$encore$distinct_by_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,v_STAR_)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
taoensso.encore.removev = (function taoensso$encore$removev(pred,coll){
return cljs.core.filterv(cljs.core.complement(pred),coll);
});

/**
 * distinctv` transducer.
 */
taoensso.encore.xdistinct = (function taoensso$encore$xdistinct(var_args){
var args24428 = [];
var len__9181__auto___24433 = arguments.length;
var i__9182__auto___24434 = (0);
while(true){
if((i__9182__auto___24434 < len__9181__auto___24433)){
args24428.push((arguments[i__9182__auto___24434]));

var G__24435 = (i__9182__auto___24434 + (1));
i__9182__auto___24434 = G__24435;
continue;
} else {
}
break;
}

var G__24430 = args24428.length;
switch (G__24430) {
case 0:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args24428.length)].join('')));

}
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen_ = (function (){var G__24431 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24431) : cljs.core.atom.call(null,G__24431));
})();
return ((function (seen_){
return (function() {
var G__24437 = null;
var G__24437__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24437__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__24437__2 = (function (acc,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),input)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,input);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__24437 = function(acc,input){
switch(arguments.length){
case 0:
return G__24437__0.call(this);
case 1:
return G__24437__1.call(this,acc);
case 2:
return G__24437__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__24437.cljs$core$IFn$_invoke$arity$0 = G__24437__0;
G__24437.cljs$core$IFn$_invoke$arity$1 = G__24437__1;
G__24437.cljs$core$IFn$_invoke$arity$2 = G__24437__2;
return G__24437;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (function (rf){
var seen_ = (function (){var G__24432 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24432) : cljs.core.atom.call(null,G__24432));
})();
return ((function (seen_){
return (function() {
var G__24438 = null;
var G__24438__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__24438__1 = (function (acc){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(acc) : rf.call(null,acc));
});
var G__24438__2 = (function (acc,input){
var k = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(input) : keyfn.call(null,input));
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen_) : cljs.core.deref.call(null,seen_)),k)){
return acc;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(seen_,cljs.core.conj,k);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(acc,input) : rf.call(null,acc,input));
}
});
G__24438 = function(acc,input){
switch(arguments.length){
case 0:
return G__24438__0.call(this);
case 1:
return G__24438__1.call(this,acc);
case 2:
return G__24438__2.call(this,acc,input);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__24438.cljs$core$IFn$_invoke$arity$0 = G__24438__0;
G__24438.cljs$core$IFn$_invoke$arity$1 = G__24438__1;
G__24438.cljs$core$IFn$_invoke$arity$2 = G__24438__2;
return G__24438;
})()
;})(seen_))
});
});

taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(taoensso.encore.xdistinct.cljs$core$IFn$_invoke$arity$1(keyfn),coll);
});

taoensso.encore.xdistinct.cljs$lang$maxFixedArity = 2;

/**
 * Reverse comparator.
 */
taoensso.encore.rcompare = (function taoensso$encore$rcompare(x,y){
return cljs.core.compare(y,x);
});
taoensso.encore.nested_merge_with = (function taoensso$encore$nested_merge_with(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24441 = arguments.length;
var i__9182__auto___24442 = (0);
while(true){
if((i__9182__auto___24442 < len__9181__auto___24441)){
args__9188__auto__.push((arguments[i__9182__auto___24442]));

var G__24443 = (i__9182__auto___24442 + (1));
i__9182__auto___24442 = G__24443;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var rv = cljs.core.val(e);
if(!(cljs.core.contains_QMARK_(m,k))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,rv);
} else {
var lv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if((cljs.core.map_QMARK_(lv)) && (cljs.core.map_QMARK_(rv))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.array_seq([lv,rv], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(lv,rv) : f.call(null,lv,rv)));
}
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__7960__auto__ = m1;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

taoensso.encore.nested_merge_with.cljs$lang$maxFixedArity = (1);

taoensso.encore.nested_merge_with.cljs$lang$applyTo = (function (seq24439){
var G__24440 = cljs.core.first(seq24439);
var seq24439__$1 = cljs.core.next(seq24439);
return taoensso.encore.nested_merge_with.cljs$core$IFn$_invoke$arity$variadic(G__24440,seq24439__$1);
});

taoensso.encore.nested_merge = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nested_merge_with,(function (x,y){
if((cljs.core.map_QMARK_(x)) && ((y == null))){
return x;
} else {
return y;
}
}));
/**
 * Returns the 'greatest' element in coll in O(n) time.
 */
taoensso.encore.greatest = (function taoensso$encore$greatest(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24452 = arguments.length;
var i__9182__auto___24453 = (0);
while(true){
if((i__9182__auto___24453 < len__9181__auto___24452)){
args__9188__auto__.push((arguments[i__9182__auto___24453]));

var G__24454 = (i__9182__auto___24453 + (1));
i__9182__auto___24453 = G__24454;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__24448){
var vec__24449 = p__24448;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24449,(0),null);
var comparator = (function (){var or__7960__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__24449,_QMARK_comparator){
return (function (p1__24444_SHARP_,p2__24445_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__24444_SHARP_,p2__24445_SHARP_) : comparator.call(null,p1__24444_SHARP_,p2__24445_SHARP_)) > (0))){
return p2__24445_SHARP_;
} else {
return p1__24444_SHARP_;
}
});})(comparator,vec__24449,_QMARK_comparator))
,coll);
});

taoensso.encore.greatest.cljs$lang$maxFixedArity = (1);

taoensso.encore.greatest.cljs$lang$applyTo = (function (seq24446){
var G__24447 = cljs.core.first(seq24446);
var seq24446__$1 = cljs.core.next(seq24446);
return taoensso.encore.greatest.cljs$core$IFn$_invoke$arity$variadic(G__24447,seq24446__$1);
});

/**
 * Returns the 'least' element in coll in O(n) time.
 */
taoensso.encore.least = (function taoensso$encore$least(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24463 = arguments.length;
var i__9182__auto___24464 = (0);
while(true){
if((i__9182__auto___24464 < len__9181__auto___24463)){
args__9188__auto__.push((arguments[i__9182__auto___24464]));

var G__24465 = (i__9182__auto___24464 + (1));
i__9182__auto___24464 = G__24465;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic = (function (coll,p__24459){
var vec__24460 = p__24459;
var _QMARK_comparator = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24460,(0),null);
var comparator = (function (){var or__7960__auto__ = _QMARK_comparator;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.rcompare;
}
})();
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(((function (comparator,vec__24460,_QMARK_comparator){
return (function (p1__24455_SHARP_,p2__24456_SHARP_){
if(((comparator.cljs$core$IFn$_invoke$arity$2 ? comparator.cljs$core$IFn$_invoke$arity$2(p1__24455_SHARP_,p2__24456_SHARP_) : comparator.call(null,p1__24455_SHARP_,p2__24456_SHARP_)) < (0))){
return p2__24456_SHARP_;
} else {
return p1__24455_SHARP_;
}
});})(comparator,vec__24460,_QMARK_comparator))
,coll);
});

taoensso.encore.least.cljs$lang$maxFixedArity = (1);

taoensso.encore.least.cljs$lang$applyTo = (function (seq24457){
var G__24458 = cljs.core.first(seq24457);
var seq24457__$1 = cljs.core.next(seq24457);
return taoensso.encore.least.cljs$core$IFn$_invoke$arity$variadic(G__24458,seq24457__$1);
});

/**
 * Like `repeatedly` but faster and `conj`s items into given collection.
 */
taoensso.encore.repeatedly_into = (function taoensso$encore$repeatedly_into(coll,n,f){
if((coll instanceof clojure.lang.IEditableCollection)){
var v = cljs.core.transient$(coll);
var idx = (0);
while(true){
if((idx >= n)){
return cljs.core.persistent_BANG_(v);
} else {
var G__24466 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__24467 = (idx + (1));
v = G__24466;
idx = G__24467;
continue;
}
break;
}
} else {
var v = coll;
var idx = (0);
while(true){
if((idx >= n)){
return v;
} else {
var G__24468 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
var G__24469 = (idx + (1));
v = G__24468;
idx = G__24469;
continue;
}
break;
}
}
});
taoensso.encore.undefined__GT_nil = (function taoensso$encore$undefined__GT_nil(x){
if((void 0 === x)){
return null;
} else {
return x;
}
});
taoensso.encore.nil__GT_str = (function taoensso$encore$nil__GT_str(x){
if(((void 0 === x)) || ((x == null))){
return "nil";
} else {
return x;
}
});
taoensso.encore.spaced_str_with_nils = (function taoensso$encore$spaced_str_with_nils(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,xs));
});
taoensso.encore.spaced_str = (function taoensso$encore$spaced_str(xs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.undefined__GT_nil,xs));
});
taoensso.encore.format_STAR_ = (function taoensso$encore$format_STAR_(fmt,args){
var fmt__$1 = (function (){var or__7960__auto__ = fmt;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return "";
}
})();
var args__$1 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(taoensso.encore.nil__GT_str,args);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(goog.string.format,fmt__$1,args__$1);
});
/**
 * Like `clojure.core/format` but:
 *  * Returns "" when fmt is nil rather than throwing an NPE.
 *  * Formats nil as "nil" rather than "null".
 *  * Provides ClojureScript support via goog.string.format (this has fewer
 *    formatting options than Clojure's `format`!).
 */
taoensso.encore.format = (function taoensso$encore$format(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24472 = arguments.length;
var i__9182__auto___24473 = (0);
while(true){
if((i__9182__auto___24473 < len__9181__auto___24472)){
args__9188__auto__.push((arguments[i__9182__auto___24473]));

var G__24474 = (i__9182__auto___24473 + (1));
i__9182__auto___24473 = G__24474;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,args){
return taoensso.encore.format_STAR_(fmt,args);
});

taoensso.encore.format.cljs$lang$maxFixedArity = (1);

taoensso.encore.format.cljs$lang$applyTo = (function (seq24470){
var G__24471 = cljs.core.first(seq24470);
var seq24470__$1 = cljs.core.next(seq24470);
return taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(G__24471,seq24470__$1);
});

/**
 * Gives a consistent, flexible, cross-platform substring API built on
 *   `sub-indexes`.
 */
taoensso.encore.substr = (function taoensso$encore$substr(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24485 = arguments.length;
var i__9182__auto___24486 = (0);
while(true){
if((i__9182__auto___24486 < len__9181__auto___24485)){
args__9188__auto__.push((arguments[i__9182__auto___24486]));

var G__24487 = (i__9182__auto___24486 + (1));
i__9182__auto___24486 = G__24487;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic = (function (s,start_idx,p__24478){
var vec__24479 = p__24478;
var _QMARK_max_len = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24479,(0),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (vec__24479,_QMARK_max_len){
return (function (){
return s;
});})(vec__24479,_QMARK_max_len))
,null)),cljs.core.cst$sym$s,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? string? s)"));
}

var vec__24482 = taoensso.encore.sub_indexes.cljs$core$IFn$_invoke$arity$variadic(s,start_idx,cljs.core.array_seq([cljs.core.cst$kw$max_DASH_len,_QMARK_max_len], 0));
var start_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(0),null);
var end_idx_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24482,(1),null);
return s.substring(start_idx_STAR_,end_idx_STAR_);
});

taoensso.encore.substr.cljs$lang$maxFixedArity = (2);

taoensso.encore.substr.cljs$lang$applyTo = (function (seq24475){
var G__24476 = cljs.core.first(seq24475);
var seq24475__$1 = cljs.core.next(seq24475);
var G__24477 = cljs.core.first(seq24475__$1);
var seq24475__$2 = cljs.core.next(seq24475__$1);
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(G__24476,G__24477,seq24475__$2);
});

taoensso.encore.str_contains_QMARK_ = (function taoensso$encore$str_contains_QMARK_(s,substr){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr));
});
taoensso.encore.str_starts_with_QMARK_ = (function taoensso$encore$str_starts_with_QMARK_(s,substr){
return (s.indexOf(substr) === (0));
});
taoensso.encore.str_ends_with_QMARK_ = (function taoensso$encore$str_ends_with_QMARK_(s,substr){
var s_len = s.length;
var substr_len = substr.length;
if((s_len >= substr_len)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((-1),s.indexOf(substr,(s_len - substr_len)));
} else {
return null;
}
});
taoensso.encore.str__QMARK_index = (function taoensso$encore$str__QMARK_index(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24495 = arguments.length;
var i__9182__auto___24496 = (0);
while(true){
if((i__9182__auto___24496 < len__9181__auto___24495)){
args__9188__auto__.push((arguments[i__9182__auto___24496]));

var G__24497 = (i__9182__auto___24496 + (1));
i__9182__auto___24496 = G__24497;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic = (function (s,substr,p__24491){
var vec__24492 = p__24491;
var start_idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24492,(0),null);
var last_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24492,(1),null);
var start_idx__$1 = ((function (){var or__7960__auto__ = start_idx;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return (0);
}
})() | (0));
var result = ((cljs.core.truth_(last_QMARK_)?s.lastIndexOf(substr,start_idx__$1):s.indexOf(substr,start_idx__$1)) | (0));
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(result,(-1))){
return result;
} else {
return null;
}
});

taoensso.encore.str__QMARK_index.cljs$lang$maxFixedArity = (2);

taoensso.encore.str__QMARK_index.cljs$lang$applyTo = (function (seq24488){
var G__24489 = cljs.core.first(seq24488);
var seq24488__$1 = cljs.core.next(seq24488);
var G__24490 = cljs.core.first(seq24488__$1);
var seq24488__$2 = cljs.core.next(seq24488__$1);
return taoensso.encore.str__QMARK_index.cljs$core$IFn$_invoke$arity$variadic(G__24489,G__24490,seq24488__$2);
});

/**
 * Like `clojure.string/join` but ensures no double separators.
 */
taoensso.encore.join_once = (function taoensso$encore$join_once(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24500 = arguments.length;
var i__9182__auto___24501 = (0);
while(true){
if((i__9182__auto___24501 < len__9181__auto___24500)){
args__9188__auto__.push((arguments[i__9182__auto___24501]));

var G__24502 = (i__9182__auto___24501 + (1));
i__9182__auto___24501 = G__24502;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic = (function (separator,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s1,s2){
var s1__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1)].join('');
var s2__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2)].join('');
if(cljs.core.truth_(taoensso.encore.str_ends_with_QMARK_(s1__$1,separator))){
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1.substring((1)))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
} else {
if(cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s2__$1,separator))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s1__$1,"")) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(s2__$1,""))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s1__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(separator),cljs.core.str.cljs$core$IFn$_invoke$arity$1(s2__$1)].join('');
}
}
}
}),null,coll);
});

taoensso.encore.join_once.cljs$lang$maxFixedArity = (1);

taoensso.encore.join_once.cljs$lang$applyTo = (function (seq24498){
var G__24499 = cljs.core.first(seq24498);
var seq24498__$1 = cljs.core.next(seq24498);
return taoensso.encore.join_once.cljs$core$IFn$_invoke$arity$variadic(G__24499,seq24498__$1);
});

/**
 * Joins string paths (URLs, file paths, etc.) ensuring correct "/"
 *   interposition.
 */
taoensso.encore.path = (function taoensso$encore$path(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24504 = arguments.length;
var i__9182__auto___24505 = (0);
while(true){
if((i__9182__auto___24505 < len__9181__auto___24504)){
args__9188__auto__.push((arguments[i__9182__auto___24505]));

var G__24506 = (i__9182__auto___24505 + (1));
i__9182__auto___24505 = G__24506;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.join_once,"/",parts);
});

taoensso.encore.path.cljs$lang$maxFixedArity = (0);

taoensso.encore.path.cljs$lang$applyTo = (function (seq24503){
return taoensso.encore.path.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24503));
});

/**
 * Converts all word breaks of any form and length (including line breaks of any
 *   form, tabs, spaces, etc.) to a single regular space.
 */
taoensso.encore.norm_word_breaks = (function taoensso$encore$norm_word_breaks(s){
return clojure.string.replace([cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/\s+/," ");
});
taoensso.encore.count_words = (function taoensso$encore$count_words(s){
if(clojure.string.blank_QMARK_(s)){
return (0);
} else {
return cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(s,/\s+/));
}
});
/**
 * Returns a UUIDv4 string of form "xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx",
 *   Ref. http://www.ietf.org/rfc/rfc4122.txt,
 *     https://gist.github.com/franks42/4159427
 */
taoensso.encore.uuid_str = (function taoensso$encore$uuid_str(var_args){
var args24507 = [];
var len__9181__auto___24510 = arguments.length;
var i__9182__auto___24511 = (0);
while(true){
if((i__9182__auto___24511 < len__9181__auto___24510)){
args24507.push((arguments[i__9182__auto___24511]));

var G__24512 = (i__9182__auto___24511 + (1));
i__9182__auto___24511 = G__24512;
continue;
} else {
}
break;
}

var G__24509 = args24507.length;
switch (G__24509) {
case 1:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 0:
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args24507.length)].join('')));

}
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1 = (function (max_length){
return taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0(),(0),cljs.core.array_seq([max_length], 0));
});

taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0 = (function (){
var hex = (function (){
return cljs.core.rand_int((15)).toString((16));
});
var rhex = ((8) | ((3) & cljs.core.rand_int((14)))).toString((16));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("4"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(rhex),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(hex())].join('');
});

taoensso.encore.uuid_str.cljs$lang$maxFixedArity = 1;

taoensso.encore.gc_rate = (1.0 / (16000));
taoensso.encore.gc_now_QMARK_ = (function taoensso$encore$gc_now_QMARK_(){
return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0() <= taoensso.encore.gc_rate);
});
/**
 * Swaps associative value at key and returns the new value.
 *   Specialized, fast `swap-in!` for use mostly by memoization utils.
 */
taoensso.encore.swap_val_BANG_ = (function taoensso$encore$swap_val_BANG_(atom_,k,f){
while(true){
var old_m = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(atom_) : cljs.core.deref.call(null,atom_));
var new_v = (function (){var G__24515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(old_m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__24515) : f.call(null,G__24515));
})();
var new_m = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(old_m,k,new_v);
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_(atom_,old_m,new_m))){
return new_v;
} else {
continue;
}
break;
}
});
/**
 * As `clojure.core/memoize` but uses delays to avoid write races.
 */
taoensso.encore.memoize_ = (function taoensso$encore$memoize_(f){
var cache_ = (function (){var G__24518 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24518) : cljs.core.atom.call(null,G__24518));
})();
return ((function (cache_){
return (function() { 
var G__24520__delegate = function (args){
var G__24519 = (function (){var or__7960__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args,((function (or__7960__auto__,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_(_QMARK_dv)){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7960__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7960__auto__,cache_))
,null));
}
});})(or__7960__auto__,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__24519) : cljs.core.deref.call(null,G__24519));
};
var G__24520 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24521__i = 0, G__24521__a = new Array(arguments.length -  0);
while (G__24521__i < G__24521__a.length) {G__24521__a[G__24521__i] = arguments[G__24521__i + 0]; ++G__24521__i;}
  args = new cljs.core.IndexedSeq(G__24521__a,0);
} 
return G__24520__delegate.call(this,args);};
G__24520.cljs$lang$maxFixedArity = 0;
G__24520.cljs$lang$applyTo = (function (arglist__24522){
var args = cljs.core.seq(arglist__24522);
return G__24520__delegate(args);
});
G__24520.cljs$core$IFn$_invoke$arity$variadic = G__24520__delegate;
return G__24520;
})()
;
;})(cache_))
});
/**
 * Great for Reactjs render op caching on mobile devices, etc.
 */
taoensso.encore.memoize1 = (function taoensso$encore$memoize1(f){
var cache_ = (function (){var G__24525 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24525) : cljs.core.atom.call(null,G__24525));
})();
return ((function (cache_){
return (function() { 
var G__24527__delegate = function (args){
var G__24526 = (function (){var or__7960__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache_,((function (or__7960__auto__,cache_){
return (function (cache){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cache,args))){
return cache;
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([args,(new cljs.core.Delay(((function (or__7960__auto__,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
});})(or__7960__auto__,cache_))
,null))]);
}
});})(or__7960__auto__,cache_))
),args);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__24526) : cljs.core.deref.call(null,G__24526));
};
var G__24527 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24528__i = 0, G__24528__a = new Array(arguments.length -  0);
while (G__24528__i < G__24528__a.length) {G__24528__a[G__24528__i] = arguments[G__24528__i + 0]; ++G__24528__i;}
  args = new cljs.core.IndexedSeq(G__24528__a,0);
} 
return G__24527__delegate.call(this,args);};
G__24527.cljs$lang$maxFixedArity = 0;
G__24527.cljs$lang$applyTo = (function (arglist__24529){
var args = cljs.core.seq(arglist__24529);
return G__24527__delegate(args);
});
G__24527.cljs$core$IFn$_invoke$arity$variadic = G__24527__delegate;
return G__24527;
})()
;
;})(cache_))
});
/**
 * Like `(memoize* f)` but takes an explicit cache atom (possibly nil)
 *   and immediately applies memoized f to given arguments.
 */
taoensso.encore.memoized = (function taoensso$encore$memoized(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24535 = arguments.length;
var i__9182__auto___24536 = (0);
while(true){
if((i__9182__auto___24536 < len__9181__auto___24535)){
args__9188__auto__.push((arguments[i__9182__auto___24536]));

var G__24537 = (i__9182__auto___24536 + (1));
i__9182__auto___24536 = G__24537;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic = (function (cache,f,args){
if(cljs.core.not(cache)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
} else {
var G__24534 = taoensso.encore.swap_val_BANG_(cache,args,(function (p1__24530_SHARP_){
if(cljs.core.truth_(p1__24530_SHARP_)){
return p1__24530_SHARP_;
} else {
return (new cljs.core.Delay((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}),null));
}
}));
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__24534) : cljs.core.deref.call(null,G__24534));
}
});

taoensso.encore.memoized.cljs$lang$maxFixedArity = (2);

taoensso.encore.memoized.cljs$lang$applyTo = (function (seq24531){
var G__24532 = cljs.core.first(seq24531);
var seq24531__$1 = cljs.core.next(seq24531);
var G__24533 = cljs.core.first(seq24531__$1);
var seq24531__$2 = cljs.core.next(seq24531__$1);
return taoensso.encore.memoized.cljs$core$IFn$_invoke$arity$variadic(G__24532,G__24533,seq24531__$2);
});

/**
 * Like `clojure.core/memoize` but:
 *  * Uses delays to prevent race conditions on writes.
 *  * Supports auto invalidation & gc with `ttl-ms` option.
 *  * Supports manual invalidation by prepending args with `:mem/del` or `:mem/fresh`.
 *  * Supports cache size limit & gc with `cache-size` option.
 */
taoensso.encore.memoize_STAR_ = (function taoensso$encore$memoize_STAR_(var_args){
var args24540 = [];
var len__9181__auto___24621 = arguments.length;
var i__9182__auto___24622 = (0);
while(true){
if((i__9182__auto___24622 < len__9181__auto___24621)){
args24540.push((arguments[i__9182__auto___24622]));

var G__24623 = (i__9182__auto___24622 + (1));
i__9182__auto___24622 = G__24623;
continue;
} else {
}
break;
}

var G__24542 = args24540.length;
switch (G__24542) {
case 1:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args24540.length)].join('')));

}
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (f){
var cache_ = (function (){var G__24543 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24543) : cljs.core.atom.call(null,G__24543));
})();
return ((function (cache_){
return (function() { 
var G__24625__delegate = function (p__24544){
var vec__24545 = p__24544;
var seq__24546 = cljs.core.seq(vec__24545);
var first__24547 = cljs.core.first(seq__24546);
var seq__24546__$1 = cljs.core.next(seq__24546);
var arg1 = first__24547;
var argn = seq__24546__$1;
var args = vec__24545;
if(cljs.core.truth_((function (){var G__24548 = arg1;
var G__24549 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24548,G__24549) : taoensso.encore.kw_identical_QMARK_.call(null,G__24548,G__24549));
})())){
if(cljs.core.truth_((function (){var G__24550 = cljs.core.first(argn);
var G__24551 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24550,G__24551) : taoensso.encore.kw_identical_QMARK_.call(null,G__24550,G__24551));
})())){
var G__24552_24626 = cache_;
var G__24553_24627 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__24552_24626,G__24553_24627) : cljs.core.reset_BANG_.call(null,G__24552_24626,G__24553_24627));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_,cljs.core.dissoc,argn);
}

return null;
} else {
var fresh_QMARK_ = (function (){var G__24554 = arg1;
var G__24555 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24554,G__24555) : taoensso.encore.kw_identical_QMARK_.call(null,G__24554,G__24555));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var G__24556 = (function (){var or__7960__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cache_) : cljs.core.deref.call(null,cache_)),args__$1);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.swap_val_BANG_(cache_,args__$1,((function (or__7960__auto__,fresh_QMARK_,args__$1,vec__24545,seq__24546,first__24547,seq__24546__$1,arg1,argn,args,cache_){
return (function (_QMARK_dv){
if(cljs.core.truth_((function (){var and__7948__auto__ = _QMARK_dv;
if(cljs.core.truth_(and__7948__auto__)){
return cljs.core.not(fresh_QMARK_);
} else {
return and__7948__auto__;
}
})())){
return _QMARK_dv;
} else {
return (new cljs.core.Delay(((function (or__7960__auto__,fresh_QMARK_,args__$1,vec__24545,seq__24546,first__24547,seq__24546__$1,arg1,argn,args,cache_){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(or__7960__auto__,fresh_QMARK_,args__$1,vec__24545,seq__24546,first__24547,seq__24546__$1,arg1,argn,args,cache_))
,null));
}
});})(or__7960__auto__,fresh_QMARK_,args__$1,vec__24545,seq__24546,first__24547,seq__24546__$1,arg1,argn,args,cache_))
);
}
})();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__24556) : cljs.core.deref.call(null,G__24556));
}
};
var G__24625 = function (var_args){
var p__24544 = null;
if (arguments.length > 0) {
var G__24628__i = 0, G__24628__a = new Array(arguments.length -  0);
while (G__24628__i < G__24628__a.length) {G__24628__a[G__24628__i] = arguments[G__24628__i + 0]; ++G__24628__i;}
  p__24544 = new cljs.core.IndexedSeq(G__24628__a,0);
} 
return G__24625__delegate.call(this,p__24544);};
G__24625.cljs$lang$maxFixedArity = 0;
G__24625.cljs$lang$applyTo = (function (arglist__24629){
var p__24544 = cljs.core.seq(arglist__24629);
return G__24625__delegate(p__24544);
});
G__24625.cljs$core$IFn$_invoke$arity$variadic = G__24625__delegate;
return G__24625;
})()
;
;})(cache_))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


var cache = (function (){var G__24557 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24557) : cljs.core.atom.call(null,G__24557));
})();
return ((function (cache){
return (function() { 
var G__24630__delegate = function (p__24558){
var vec__24559 = p__24558;
var seq__24560 = cljs.core.seq(vec__24559);
var first__24561 = cljs.core.first(seq__24560);
var seq__24560__$1 = cljs.core.next(seq__24560);
var arg1 = first__24561;
var argn = seq__24560__$1;
var args = vec__24559;
if(cljs.core.truth_((function (){var G__24562 = arg1;
var G__24563 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24562,G__24563) : taoensso.encore.kw_identical_QMARK_.call(null,G__24562,G__24563));
})())){
if(cljs.core.truth_((function (){var G__24564 = cljs.core.first(argn);
var G__24565 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24564,G__24565) : taoensso.encore.kw_identical_QMARK_.call(null,G__24564,G__24565));
})())){
var G__24566_24631 = cache;
var G__24567_24632 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__24566_24631,G__24567_24632) : cljs.core.reset_BANG_.call(null,G__24566_24631,G__24567_24632));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_24633 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cache,((function (instant_24633,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache){
return (function (m){
return cljs.core.reduce_kv(((function (instant_24633,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache){
return (function (m_STAR_,k,p__24568){
var vec__24569 = p__24568;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24569,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24569,(1),null);
var cv = vec__24569;
if(((instant_24633 - udt) > ttl_ms)){
return m_STAR_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR_,k,cv);
}
});})(instant_24633,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m));
});})(instant_24633,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache))
);
} else {
}

var fresh_QMARK_ = (function (){var G__24575 = arg1;
var G__24576 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24575,G__24576) : taoensso.encore.kw_identical_QMARK_.call(null,G__24575,G__24576));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var instant = taoensso.encore.now_udt();
var vec__24572 = taoensso.encore.swap_val_BANG_(cache,args__$1,((function (fresh_QMARK_,args__$1,instant,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7948__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7948__auto__)){
var and__7948__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7948__auto____$1){
var vec__24580 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24580,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24580,(1),null);
return ((instant - udt) < ttl_ms);
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,instant,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,instant,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache))
,null)),instant], null);
}
});})(fresh_QMARK_,args__$1,instant,vec__24559,seq__24560,first__24561,seq__24560__$1,arg1,argn,args,cache))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24572,(0),null);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__24630 = function (var_args){
var p__24558 = null;
if (arguments.length > 0) {
var G__24634__i = 0, G__24634__a = new Array(arguments.length -  0);
while (G__24634__i < G__24634__a.length) {G__24634__a[G__24634__i] = arguments[G__24634__i + 0]; ++G__24634__i;}
  p__24558 = new cljs.core.IndexedSeq(G__24634__a,0);
} 
return G__24630__delegate.call(this,p__24558);};
G__24630.cljs$lang$maxFixedArity = 0;
G__24630.cljs$lang$applyTo = (function (arglist__24635){
var p__24558 = cljs.core.seq(arglist__24635);
return G__24630__delegate(p__24558);
});
G__24630.cljs$core$IFn$_invoke$arity$variadic = G__24630__delegate;
return G__24630;
})()
;
;})(cache))
});

taoensso.encore.memoize_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (cache_size,ttl_ms,f){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return ttl_ms;
}),null)),cljs.core.cst$sym$ttl_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.pos_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_], null));


taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return cache_size;
}),null)),cljs.core.cst$sym$cache_DASH_size,taoensso.encore.pos_int_QMARK_,cljs.core.cst$sym$pos_DASH_int_QMARK_);


var state = (function (){var G__24583 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24583) : cljs.core.atom.call(null,G__24583));
})();
return ((function (state){
return (function() { 
var G__24636__delegate = function (p__24584){
var vec__24585 = p__24584;
var seq__24586 = cljs.core.seq(vec__24585);
var first__24587 = cljs.core.first(seq__24586);
var seq__24586__$1 = cljs.core.next(seq__24586);
var arg1 = first__24587;
var argn = seq__24586__$1;
var args = vec__24585;
if(cljs.core.truth_((function (){var G__24588 = arg1;
var G__24589 = cljs.core.cst$kw$mem_SLASH_del;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24588,G__24589) : taoensso.encore.kw_identical_QMARK_.call(null,G__24588,G__24589));
})())){
if(cljs.core.truth_((function (){var G__24590 = cljs.core.first(argn);
var G__24591 = cljs.core.cst$kw$mem_SLASH_all;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24590,G__24591) : taoensso.encore.kw_identical_QMARK_.call(null,G__24590,G__24591));
})())){
var G__24592_24637 = state;
var G__24593_24638 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tick,(0)], null);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__24592_24637,G__24593_24638) : cljs.core.reset_BANG_.call(null,G__24592_24637,G__24593_24638));
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(state,cljs.core.dissoc,argn);
}

return null;
} else {
if(cljs.core.truth_(taoensso.encore.gc_now_QMARK_())){
var instant_24639 = taoensso.encore.now_udt();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (m){
var m_STAR_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,cljs.core.cst$kw$tick);
var m_STAR___$1 = ((cljs.core.not(ttl_ms))?m_STAR_:cljs.core.reduce_kv(((function (m_STAR_,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (m_STAR___$1,k,p__24594){
var vec__24595 = p__24594;
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24595,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24595,(1),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24595,(2),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24595,(3),null);
var cv = vec__24595;
if(((instant_24639 - udt) > ttl_ms)){
return m_STAR___$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$1,k,cv);
}
});})(m_STAR_,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
,cljs.core.PersistentArrayMap.EMPTY,taoensso.encore.clj1098(m_STAR_)));
var n_to_prune = (cljs.core.count(m_STAR___$1) - cache_size);
var m_STAR___$2 = ((!((n_to_prune > (0))))?m_STAR___$1:cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,m_STAR___$1,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (p1__24539_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24539_SHARP_,(1));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n_to_prune,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (p1__24538_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24538_SHARP_,(0));
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (k){
var vec__24598 = (m_STAR___$1.cljs$core$IFn$_invoke$arity$1 ? m_STAR___$1.cljs$core$IFn$_invoke$arity$1(k) : m_STAR___$1.call(null,k));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24598,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24598,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24598,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24598,(3),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(tick_lru + tick_lfu),k], null);
});})(m_STAR_,m_STAR___$1,n_to_prune,instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
,cljs.core.keys(m_STAR___$1)))))));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m_STAR___$2,cljs.core.cst$kw$tick,cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1(m));
});})(instant_24639,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
);
} else {
}

var fresh_QMARK_ = (function (){var G__24604 = arg1;
var G__24605 = cljs.core.cst$kw$mem_SLASH_fresh;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__24604,G__24605) : taoensso.encore.kw_identical_QMARK_.call(null,G__24604,G__24605));
})();
var args__$1 = (cljs.core.truth_(fresh_QMARK_)?argn:args);
var _QMARK_instant = (cljs.core.truth_(ttl_ms)?taoensso.encore.now_udt():null);
var tick_SINGLEQUOTE_ = cljs.core.cst$kw$tick.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)));
var vec__24601 = taoensso.encore.swap_val_BANG_(state,args__$1,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (_QMARK_cv){
if(cljs.core.truth_((function (){var and__7948__auto__ = _QMARK_cv;
if(cljs.core.truth_(and__7948__auto__)){
var and__7948__auto____$1 = cljs.core.not(fresh_QMARK_);
if(and__7948__auto____$1){
var or__7960__auto__ = (_QMARK_instant == null);
if(or__7960__auto__){
return or__7960__auto__;
} else {
var vec__24615 = _QMARK_cv;
var _dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24615,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24615,(1),null);
return ((_QMARK_instant - udt) < ttl_ms);
}
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
})())){
return _QMARK_cv;
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.Delay(((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args__$1);
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
,null)),_QMARK_instant,tick_SINGLEQUOTE_,(1)], null);
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
);
var dv = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24601,(0),null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(state,((function (fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24601,dv,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state){
return (function (m){
var temp__5457__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,args__$1);
if(cljs.core.truth_(temp__5457__auto__)){
var vec__24618 = temp__5457__auto__;
var dv__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24618,(0),null);
var _QMARK_udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24618,(1),null);
var tick_lru = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24618,(2),null);
var tick_lfu = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24618,(3),null);
var cv = vec__24618;
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.PersistentArrayMap.createAsIfByAssoc([cljs.core.cst$kw$tick,(tick_SINGLEQUOTE_ + (1)),args__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [dv__$1,_QMARK_udt,tick_SINGLEQUOTE_,(tick_lfu + (1))], null)])], 0));
} else {
return null;
}
});})(fresh_QMARK_,args__$1,_QMARK_instant,tick_SINGLEQUOTE_,vec__24601,dv,vec__24585,seq__24586,first__24587,seq__24586__$1,arg1,argn,args,state))
);

return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(dv) : cljs.core.deref.call(null,dv));
}
};
var G__24636 = function (var_args){
var p__24584 = null;
if (arguments.length > 0) {
var G__24640__i = 0, G__24640__a = new Array(arguments.length -  0);
while (G__24640__i < G__24640__a.length) {G__24640__a[G__24640__i] = arguments[G__24640__i + 0]; ++G__24640__i;}
  p__24584 = new cljs.core.IndexedSeq(G__24640__a,0);
} 
return G__24636__delegate.call(this,p__24584);};
G__24636.cljs$lang$maxFixedArity = 0;
G__24636.cljs$lang$applyTo = (function (arglist__24641){
var p__24584 = cljs.core.seq(arglist__24641);
return G__24636__delegate(p__24584);
});
G__24636.cljs$core$IFn$_invoke$arity$variadic = G__24636__delegate;
return G__24636;
})()
;
;})(state))
});

taoensso.encore.memoize_STAR_.cljs$lang$maxFixedArity = 3;

/**
 * Takes one or more rate specs of form [ncalls-limit window-ms ?spec-id] and
 *   returns a (fn [& [req-id])) that returns `nil` (=> all rate limits passed), or
 *   [<ms-wait> <worst-offending-spec-id>] / <ms-wait>.
 */
taoensso.encore.rate_limiter_STAR_ = (function taoensso$encore$rate_limiter_STAR_(specs){
if(cljs.core.empty_QMARK_(specs)){
return cljs.core.constantly(null);
} else {
var vspecs = cljs.core.vec(specs);
var vstates_ = (function (){var G__24730 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__24730) : cljs.core.atom.call(null,G__24730));
})();
var max_win_ms = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(0),cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vspecs,vstates_){
return (function (p__24731){
var vec__24732 = p__24731;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24732,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24732,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24732,(2),null);
var spec = vec__24732;
return win_ms;
});})(vspecs,vstates_))
,vspecs));
var nspecs = cljs.core.count(vspecs);
var nid_specs = cljs.core.count(cljs.core.filterv(((function (vspecs,vstates_,max_win_ms,nspecs){
return (function (p__24735){
var vec__24736 = p__24735;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24736,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24736,(1),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24736,(2),null);
return id;
});})(vspecs,vstates_,max_win_ms,nspecs))
,vspecs));
var _ = ((((nid_specs === (0))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(nid_specs,nspecs)))?null:(function(){throw (new Error("Assert failed: (or (zero? nid-specs) (= nid-specs nspecs))"))})());
var return_ids_QMARK_ = !((nid_specs === (0)));
return ((function (vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function() { 
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate = function (p__24739){
var vec__24779 = p__24739;
var req_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24779,(0),null);
var instant = taoensso.encore.now_udt();
if(cljs.core.truth_((function (){var and__7948__auto__ = req_id;
if(cljs.core.truth_(and__7948__auto__)){
return taoensso.encore.gc_now_QMARK_();
} else {
return and__7948__auto__;
}
})())){
taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,cljs.core.PersistentVector.EMPTY,((function (instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function taoensso$encore$rate_limiter_STAR__$_check_rate_limits_$_gc(m){
var m__$1 = taoensso.encore.clj1098(m);
return cljs.core.reduce_kv(((function (m__$1,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (m_STAR_,req_id__$1,vstate){
var max_udt_win_start = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (acc,p__24786){
var vec__24787 = p__24786;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24787,(0),null);
var udt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24787,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24787,(2),null);
var x__8298__auto__ = acc;
var y__8299__auto__ = udt;
return ((x__8298__auto__ > y__8299__auto__) ? x__8298__auto__ : y__8299__auto__);
});})(m__$1,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,(0),vstate);
var min_win_ms_elapsed = (instant - max_udt_win_start);
if((min_win_ms_elapsed > max_win_ms)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m_STAR_,req_id__$1);
} else {
return m_STAR_;
}
});})(m__$1,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,m__$1,m__$1);
});})(instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
} else {
}

return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(vstates_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [req_id], null),((function (instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (_QMARK_vstate){
if(cljs.core.not(_QMARK_vstate)){
return taoensso.encore.swapped(cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(nspecs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1),instant], null))),null);
} else {
var vec__24790 = (function (){var in_vspecs = vspecs;
var in_vstate = _QMARK_vstate;
var out_vstate = cljs.core.PersistentVector.EMPTY;
var _QMARK_worst_limit_offence = null;
while(true){
var vec__24793 = in_vspecs;
var seq__24794 = cljs.core.seq(vec__24793);
var first__24795 = cljs.core.first(seq__24794);
var seq__24794__$1 = cljs.core.next(seq__24794);
var vec__24796 = first__24795;
var ncalls_limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24796,(0),null);
var win_ms = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24796,(1),null);
var _QMARK_spec_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24796,(2),null);
var next_in_vspecs = seq__24794__$1;
var vec__24799 = in_vstate;
var seq__24800 = cljs.core.seq(vec__24799);
var first__24801 = cljs.core.first(seq__24800);
var seq__24800__$1 = cljs.core.next(seq__24800);
var vec__24802 = first__24801;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24802,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24802,(1),null);
var next_in_vstate = seq__24800__$1;
var win_ms_elapsed = (instant - udt_win_start);
var reset_due_QMARK_ = (win_ms_elapsed >= win_ms);
var rate_limited_QMARK_ = (!(reset_due_QMARK_)) && ((ncalls >= ncalls_limit));
var new_out_vstate = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(out_vstate,((reset_due_QMARK_)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),instant], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls,udt_win_start], null)));
var new__QMARK_worst_limit_offence = ((!(rate_limited_QMARK_))?_QMARK_worst_limit_offence:(function (){var ms_wait = (win_ms - win_ms_elapsed);
if((function (){var or__7960__auto__ = (_QMARK_worst_limit_offence == null);
if(or__7960__auto__){
return or__7960__auto__;
} else {
var vec__24808 = _QMARK_worst_limit_offence;
var max_ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24808,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24808,(1),null);
return (ms_wait > max_ms_wait);
}
})()){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ms_wait,_QMARK_spec_id], null);
} else {
return _QMARK_worst_limit_offence;
}
})());
if(cljs.core.not(next_in_vspecs)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_out_vstate,new__QMARK_worst_limit_offence], null);
} else {
var G__24818 = next_in_vspecs;
var G__24819 = next_in_vstate;
var G__24820 = new_out_vstate;
var G__24821 = new__QMARK_worst_limit_offence;
in_vspecs = G__24818;
in_vstate = G__24819;
out_vstate = G__24820;
_QMARK_worst_limit_offence = G__24821;
continue;
}
break;
}
})();
var vstate_with_resets = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24790,(0),null);
var _QMARK_worst_limit_offence = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24790,(1),null);
var all_limits_pass_QMARK_ = (_QMARK_worst_limit_offence == null);
var new_vstate = ((!(all_limits_pass_QMARK_))?vstate_with_resets:cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (vec__24790,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_){
return (function (p__24811){
var vec__24812 = p__24811;
var ncalls = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24812,(0),null);
var udt_win_start = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24812,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(ncalls + (1)),udt_win_start], null);
});})(vec__24790,vstate_with_resets,_QMARK_worst_limit_offence,all_limits_pass_QMARK_,instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
,vstate_with_resets));
var result = (function (){var temp__5457__auto__ = _QMARK_worst_limit_offence;
if(cljs.core.truth_(temp__5457__auto__)){
var wlo = temp__5457__auto__;
if(return_ids_QMARK_){
return wlo;
} else {
var vec__24815 = wlo;
var ms_wait = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24815,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24815,(1),null);
return ms_wait;
}
} else {
return null;
}
})();
return taoensso.encore.swapped(new_vstate,result);
}
});})(instant,vec__24779,req_id,vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
);
};
var taoensso$encore$rate_limiter_STAR__$_check_rate_limits = function (var_args){
var p__24739 = null;
if (arguments.length > 0) {
var G__24822__i = 0, G__24822__a = new Array(arguments.length -  0);
while (G__24822__i < G__24822__a.length) {G__24822__a[G__24822__i] = arguments[G__24822__i + 0]; ++G__24822__i;}
  p__24739 = new cljs.core.IndexedSeq(G__24822__a,0);
} 
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate.call(this,p__24739);};
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$maxFixedArity = 0;
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$lang$applyTo = (function (arglist__24823){
var p__24739 = cljs.core.seq(arglist__24823);
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate(p__24739);
});
taoensso$encore$rate_limiter_STAR__$_check_rate_limits.cljs$core$IFn$_invoke$arity$variadic = taoensso$encore$rate_limiter_STAR__$_check_rate_limits__delegate;
return taoensso$encore$rate_limiter_STAR__$_check_rate_limits;
})()
;
;})(vspecs,vstates_,max_win_ms,nspecs,nid_specs,_,return_ids_QMARK_))
}
});
taoensso.encore.rate_limit = (function taoensso$encore$rate_limit(specs,f){
var rl = taoensso.encore.rate_limiter_STAR_(specs);
return ((function (rl){
return (function() { 
var G__24824__delegate = function (args){
var temp__5455__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__5455__auto__)){
var backoff = temp__5455__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,backoff], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),null], null);
}
};
var G__24824 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__24825__i = 0, G__24825__a = new Array(arguments.length -  0);
while (G__24825__i < G__24825__a.length) {G__24825__a[G__24825__i] = arguments[G__24825__i + 0]; ++G__24825__i;}
  args = new cljs.core.IndexedSeq(G__24825__a,0);
} 
return G__24824__delegate.call(this,args);};
G__24824.cljs$lang$maxFixedArity = 0;
G__24824.cljs$lang$applyTo = (function (arglist__24826){
var args = cljs.core.seq(arglist__24826);
return G__24824__delegate(args);
});
G__24824.cljs$core$IFn$_invoke$arity$variadic = G__24824__delegate;
return G__24824;
})()
;
;})(rl))
});
taoensso.encore.nano_time = (function (){var temp__5455__auto__ = (function (){var and__7948__auto__ = typeof window !== 'undefined';
if(and__7948__auto__){
return (window["performance"]);
} else {
return and__7948__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var perf = temp__5455__auto__;
var temp__5455__auto____$1 = (function (){var or__7960__auto__ = (perf["now"]);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
var or__7960__auto____$1 = (perf["mozNow"]);
if(cljs.core.truth_(or__7960__auto____$1)){
return or__7960__auto____$1;
} else {
var or__7960__auto____$2 = (perf["msNow"]);
if(cljs.core.truth_(or__7960__auto____$2)){
return or__7960__auto____$2;
} else {
var or__7960__auto____$3 = (perf["oNow"]);
if(cljs.core.truth_(or__7960__auto____$3)){
return or__7960__auto____$3;
} else {
return (perf["webkitNow"]);
}
}
}
}
})();
if(cljs.core.truth_(temp__5455__auto____$1)){
var f = temp__5455__auto____$1;
return ((function (f,temp__5455__auto____$1,perf,temp__5455__auto__){
return (function (){
return cljs.core.long$((1000000.0 * f.call(perf)));
});
;})(f,temp__5455__auto____$1,perf,temp__5455__auto__))
} else {
return ((function (temp__5455__auto____$1,perf,temp__5455__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__5455__auto____$1,perf,temp__5455__auto__))
}
} else {
return ((function (temp__5455__auto__){
return (function (){
return (1000000.0 * taoensso.encore.now_udt());
});
;})(temp__5455__auto__))
}
})();
taoensso.encore.qb_min_times = (function taoensso$encore$qb_min_times(times){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,times);
});
taoensso.encore.console_log = (function (){var temp__5455__auto__ = (function (){var and__7948__auto__ = typeof console !== 'undefined';
if(and__7948__auto__){
return console.log;
} else {
return and__7948__auto__;
}
})();
if(cljs.core.truth_(temp__5455__auto__)){
var f = temp__5455__auto__;
return ((function (f,temp__5455__auto__){
return (function (xs){
return f.apply(console,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(xs));
});
;})(f,temp__5455__auto__))
} else {
return ((function (temp__5455__auto__){
return (function (xs){
return null;
});
;})(temp__5455__auto__))
}
})();

taoensso.encore.log = (function taoensso$encore$log(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24838 = arguments.length;
var i__9182__auto___24839 = (0);
while(true){
if((i__9182__auto___24839 < len__9181__auto___24838)){
args__9188__auto__.push((arguments[i__9182__auto___24839]));

var G__24840 = (i__9182__auto___24839 + (1));
i__9182__auto___24839 = G__24840;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(xs) : taoensso.encore.console_log.call(null,xs));
});

taoensso.encore.log.cljs$lang$maxFixedArity = (0);

taoensso.encore.log.cljs$lang$applyTo = (function (seq24827){
return taoensso.encore.log.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24827));
});


taoensso.encore.logp = (function taoensso$encore$logp(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24841 = arguments.length;
var i__9182__auto___24842 = (0);
while(true){
if((i__9182__auto___24842 < len__9181__auto___24841)){
args__9188__auto__.push((arguments[i__9182__auto___24842]));

var G__24843 = (i__9182__auto___24842 + (1));
i__9182__auto___24842 = G__24843;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__24829 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.spaced_str(xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__24829) : taoensso.encore.console_log.call(null,G__24829));
});

taoensso.encore.logp.cljs$lang$maxFixedArity = (0);

taoensso.encore.logp.cljs$lang$applyTo = (function (seq24828){
return taoensso.encore.logp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24828));
});


taoensso.encore.logf = (function taoensso$encore$logf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24844 = arguments.length;
var i__9182__auto___24845 = (0);
while(true){
if((i__9182__auto___24845 < len__9181__auto___24844)){
args__9188__auto__.push((arguments[i__9182__auto___24845]));

var G__24846 = (i__9182__auto___24845 + (1));
i__9182__auto___24845 = G__24846;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__24832 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.encore.format_STAR_(fmt,xs)], null);
return (taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.console_log.cljs$core$IFn$_invoke$arity$1(G__24832) : taoensso.encore.console_log.call(null,G__24832));
});

taoensso.encore.logf.cljs$lang$maxFixedArity = (1);

taoensso.encore.logf.cljs$lang$applyTo = (function (seq24830){
var G__24831 = cljs.core.first(seq24830);
var seq24830__$1 = cljs.core.next(seq24830);
return taoensso.encore.logf.cljs$core$IFn$_invoke$arity$variadic(G__24831,seq24830__$1);
});


taoensso.encore.sayp = (function taoensso$encore$sayp(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24847 = arguments.length;
var i__9182__auto___24848 = (0);
while(true){
if((i__9182__auto___24848 < len__9181__auto___24847)){
args__9188__auto__.push((arguments[i__9182__auto___24848]));

var G__24849 = (i__9182__auto___24848 + (1));
i__9182__auto___24848 = G__24849;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var G__24834 = taoensso.encore.spaced_str(xs);
return alert(G__24834);
});

taoensso.encore.sayp.cljs$lang$maxFixedArity = (0);

taoensso.encore.sayp.cljs$lang$applyTo = (function (seq24833){
return taoensso.encore.sayp.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq24833));
});


taoensso.encore.sayf = (function taoensso$encore$sayf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24850 = arguments.length;
var i__9182__auto___24851 = (0);
while(true){
if((i__9182__auto___24851 < len__9181__auto___24850)){
args__9188__auto__.push((arguments[i__9182__auto___24851]));

var G__24852 = (i__9182__auto___24851 + (1));
i__9182__auto___24851 = G__24852;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
var G__24837 = taoensso.encore.format_STAR_(fmt,xs);
return alert(G__24837);
});

taoensso.encore.sayf.cljs$lang$maxFixedArity = (1);

taoensso.encore.sayf.cljs$lang$applyTo = (function (seq24835){
var G__24836 = cljs.core.first(seq24835);
var seq24835__$1 = cljs.core.next(seq24835);
return taoensso.encore.sayf.cljs$core$IFn$_invoke$arity$variadic(G__24836,seq24835__$1);
});

/**
 * Returns browser window's current location. Forgeable.
 */
taoensso.encore.get_window_location = (function taoensso$encore$get_window_location(){
var loc_STAR_ = window.location;
var loc = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$href,loc_STAR_.href,cljs.core.cst$kw$protocol,loc_STAR_.protocol,cljs.core.cst$kw$hostname,loc_STAR_.hostname,cljs.core.cst$kw$host,loc_STAR_.host,cljs.core.cst$kw$pathname,loc_STAR_.pathname,cljs.core.cst$kw$search,loc_STAR_.search,cljs.core.cst$kw$hash,loc_STAR_.hash], null);
return loc;
});
taoensso.encore.xhr_pool_ = (new cljs.core.Delay((function (){
return (new goog.net.XhrIoPool());
}),null));
/**
 * Returns an immediately available XhrIo instance, or nil. The instance must be
 *   released back to pool manually.
 */
taoensso.encore.get_pooled_xhr_BANG_ = (function taoensso$encore$get_pooled_xhr_BANG_(){
var result = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).getObject();
if((void 0 === result)){
return null;
} else {
return result;
}
});
/**
 * [uri method get-or-post-params] -> [uri post-content]
 */
taoensso.encore.coerce_xhr_params = (function taoensso$encore$coerce_xhr_params(uri,method,params){
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay((function (){
return params;
}),null)),cljs.core.cst$sym$params,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,cljs.core.map_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$map_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? map?] params)"));
}

var _QMARK_pstr = ((cljs.core.empty_QMARK_(params))?null:(function (){var s = (function (){var G__24855 = (new goog.structs.Map(cljs.core.clj__GT_js(params)));
return goog.Uri.QueryData.createFromMap(G__24855);
})().toString();
if(clojure.string.blank_QMARK_(s)){
return null;
} else {
return s;
}
})());
var G__24856 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__24856) {
case "get":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(_QMARK_pstr)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_pstr)].join(''):uri),null], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
case "put":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uri,_QMARK_pstr], null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-lite "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.encore.ajax_lite = (function taoensso$encore$ajax_lite(uri,p__24860,callback){
var map__24891 = p__24860;
var map__24891__$1 = ((((!((map__24891 == null)))?((((map__24891.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24891.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24891):map__24891);
var opts = map__24891__$1;
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24891__$1,cljs.core.cst$kw$method,cljs.core.cst$kw$get);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24891__$1,cljs.core.cst$kw$params);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24891__$1,cljs.core.cst$kw$headers);
var timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24891__$1,cljs.core.cst$kw$timeout_DASH_ms,(10000));
var resp_type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24891__$1,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$auto);
var with_credentials_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24891__$1,cljs.core.cst$kw$with_DASH_credentials_QMARK_);
var progress_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24891__$1,cljs.core.cst$kw$progress_DASH_fn);
var errorf = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__24891__$1,cljs.core.cst$kw$errorf,taoensso.encore.logf);
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (){
return timeout_ms;
});})(map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
,null)),cljs.core.cst$sym$timeout_DASH_ms,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.nil_QMARK_,taoensso.encore.nneg_int_QMARK_], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$or,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$nneg_DASH_int_QMARK_], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:or nil? nneg-int?] timeout-ms)"));
}

var temp__5455__auto__ = taoensso.encore.get_pooled_xhr_BANG_();
if(cljs.core.truth_(temp__5455__auto__)){
var xhr = temp__5455__auto__;
try{var timeout_ms__$1 = (function (){var or__7960__auto__ = cljs.core.cst$kw$timeout.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return timeout_ms;
}
})();
var method_STAR_ = (function (){var G__24897 = (((method instanceof cljs.core.Keyword))?method.fqn:null);
switch (G__24897) {
case "get":
return "GET";

break;
case "post":
return "POST";

break;
case "put":
return "PUT";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(method)].join('')));

}
})();
var params__$1 = taoensso.encore.map_keys(cljs.core.name,params);
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["X-Requested-With","XMLHTTPRequest"], null),taoensso.encore.map_keys(cljs.core.name,headers)], 0));
var vec__24894 = taoensso.encore.coerce_xhr_params(uri,method,params__$1);
var uri_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24894,(0),null);
var post_content_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24894,(1),null);
var headers_STAR_ = cljs.core.clj__GT_js(((cljs.core.not(post_content_STAR_))?headers__$1:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(headers__$1,"Content-Type","application/x-www-form-urlencoded; charset=UTF-8")));
var G__24898_24922 = xhr;
var G__24899_24923 = G__24898_24922;
var G__24900_24924 = goog.net.EventType.READY;
var G__24901_24925 = ((function (G__24899_24923,G__24900_24924,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (_){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);
});})(G__24899_24923,G__24900_24924,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__24899_24923,G__24900_24924,G__24901_24925);

var G__24902_24926 = G__24898_24922;
var G__24903_24927 = goog.net.EventType.COMPLETE;
var G__24904_24928 = ((function (G__24902_24926,G__24903_24927,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function taoensso$encore$ajax_lite_$_wrapped_callback(resp){
var status = xhr.getStatus();
var success_QMARK_ = xhr.isSuccess();
var _QMARK_http_status = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(status,(-1)))?status:null);
var _QMARK_content_type = (cljs.core.truth_(_QMARK_http_status)?xhr.getResponseHeader("Content-Type"):null);
var _QMARK_content = (cljs.core.truth_(_QMARK_http_status)?(function (){var resp_type__$1 = ((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(resp_type,cljs.core.cst$kw$auto)))?resp_type:(function (){var pred__24910 = ((function (status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__24902_24926,G__24903_24927,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (p1__24859_SHARP_,p2__24858_SHARP_){
return taoensso.encore.str_contains_QMARK_(p2__24858_SHARP_,p1__24859_SHARP_);
});})(status,success_QMARK_,_QMARK_http_status,_QMARK_content_type,G__24902_24926,G__24903_24927,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
var expr__24911 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_content_type)].join('');
if(cljs.core.truth_(pred__24910("/edn",expr__24911))){
return cljs.core.cst$kw$edn;
} else {
if(cljs.core.truth_(pred__24910("/json",expr__24911))){
return cljs.core.cst$kw$json;
} else {
if(cljs.core.truth_(pred__24910("/xml",expr__24911))){
return cljs.core.cst$kw$xml;
} else {
if(cljs.core.truth_(pred__24910("/html",expr__24911))){
return cljs.core.cst$kw$text;
} else {
return cljs.core.cst$kw$text;
}
}
}
}
})());
try{var G__24914 = (((resp_type__$1 instanceof cljs.core.Keyword))?resp_type__$1.fqn:null);
switch (G__24914) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
case "xml":
return xhr.getResponseXml();

break;
case "edn":
return cljs.reader.read_string(xhr.getResponseText());

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(resp_type__$1)].join('')));

}
}catch (e24913){if((e24913 instanceof Error)){
var e = e24913;
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ajax_SLASH_bad_DASH_response_DASH_type,resp_type__$1,cljs.core.cst$kw$ajax_SLASH_resp_DASH_as_DASH_text,xhr.getResponseText()], null);
} else {
throw e24913;

}
}})():null);
var cb_arg = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$raw_DASH_resp,resp,cljs.core.cst$kw$xhr,xhr,cljs.core.cst$kw$success_QMARK_,success_QMARK_,cljs.core.cst$kw$_QMARK_content_DASH_type,(cljs.core.truth_(_QMARK_http_status)?_QMARK_content_type:null),cljs.core.cst$kw$_QMARK_content,_QMARK_content,cljs.core.cst$kw$_QMARK_status,_QMARK_http_status,cljs.core.cst$kw$_QMARK_error,(function (){var or__7960__auto__ = (cljs.core.truth_(_QMARK_http_status)?(function (){var n = _QMARK_http_status;
if(cljs.core.truth_(success_QMARK_)){
return null;
} else {
return _QMARK_http_status;
}
})():cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.createAsIfByAssoc([goog.net.ErrorCode.EXCEPTION,cljs.core.cst$kw$exception,goog.net.ErrorCode.HTTP_ERROR,cljs.core.cst$kw$http_DASH_error,goog.net.ErrorCode.ABORT,cljs.core.cst$kw$abort,goog.net.ErrorCode.TIMEOUT,cljs.core.cst$kw$timeout]),xhr.getLastErrorCode(),cljs.core.cst$kw$unknown));
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
if(((_QMARK_content == null)) && (cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(204),null,(1223),null], null), null).call(null,_QMARK_http_status)))){
return cljs.core.cst$kw$no_DASH_content;
} else {
return null;
}
}
})()], null);
return (callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(cb_arg) : callback.call(null,cb_arg));
});})(G__24902_24926,G__24903_24927,G__24898_24922,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listenOnce(G__24902_24926,G__24903_24927,G__24904_24928);


var temp__5457__auto___24930 = progress_fn;
if(cljs.core.truth_(temp__5457__auto___24930)){
var pf_24931 = temp__5457__auto___24930;
var G__24915_24932 = xhr;
var G__24916_24933 = goog.net.EventType.PROGRESS;
var G__24917_24934 = ((function (G__24915_24932,G__24916_24933,pf_24931,temp__5457__auto___24930,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf){
return (function (ev){
var length_computable_QMARK_ = ev.lengthComputable;
var loaded = ev.loaded;
var total = ev.total;
var _QMARK_ratio = (cljs.core.truth_((function (){var and__7948__auto__ = length_computable_QMARK_;
if(cljs.core.truth_(and__7948__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(total,(0));
} else {
return and__7948__auto__;
}
})())?(loaded / total):null);
var G__24918 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$_QMARK_ratio,_QMARK_ratio,cljs.core.cst$kw$length_DASH_computable_QMARK_,length_computable_QMARK_,cljs.core.cst$kw$loaded,loaded,cljs.core.cst$kw$total,total,cljs.core.cst$kw$ev,ev], null);
return (pf_24931.cljs$core$IFn$_invoke$arity$1 ? pf_24931.cljs$core$IFn$_invoke$arity$1(G__24918) : pf_24931.call(null,G__24918));
});})(G__24915_24932,G__24916_24933,pf_24931,temp__5457__auto___24930,timeout_ms__$1,method_STAR_,params__$1,headers__$1,vec__24894,uri_STAR_,post_content_STAR_,headers_STAR_,xhr,temp__5455__auto__,map__24891,map__24891__$1,opts,method,params,headers,timeout_ms,resp_type,with_credentials_QMARK_,progress_fn,errorf))
;
goog.events.listen(G__24915_24932,G__24916_24933,G__24917_24934);
} else {
}

var G__24919_24935 = xhr;
var temp__5457__auto___24936 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__5457__auto___24936)){
var x_24937 = temp__5457__auto___24936;
G__24919_24935.setTimeoutInterval((function (){var or__7960__auto__ = timeout_ms__$1;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return (0);
}
})());
} else {
}

var temp__5457__auto___24938 = with_credentials_QMARK_;
if(cljs.core.truth_(temp__5457__auto___24938)){
var x_24939 = temp__5457__auto___24938;
G__24919_24935.setWithCredentials(true);
} else {
}

var temp__5457__auto___24940 = cljs.core.cst$kw$always;
if(cljs.core.truth_(temp__5457__auto___24940)){
var x_24941 = temp__5457__auto___24940;
G__24919_24935.send(uri_STAR_,method_STAR_,post_content_STAR_,headers_STAR_);
} else {
}


return xhr;
}catch (e24893){if((e24893 instanceof Error)){
var e = e24893;
(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(taoensso.encore.xhr_pool_) : cljs.core.deref.call(null,taoensso.encore.xhr_pool_)).releaseObject(xhr);

return null;
} else {
throw e24893;

}
}} else {
var G__24920_24942 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$_QMARK_error,cljs.core.cst$kw$xhr_DASH_pool_DASH_depleted], null);
(callback.cljs$core$IFn$_invoke$arity$1 ? callback.cljs$core$IFn$_invoke$arity$1(G__24920_24942) : callback.call(null,G__24920_24942));

return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_encode = (function taoensso$encore$url_encode(s){
if(cljs.core.truth_(s)){
return clojure.string.replace(clojure.string.replace((function (){var G__24945 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join('');
var G__24946 = s;
return encodeURIComponent(G__24945,G__24946);
})(),"*","%2A"),"'","%27");
} else {
return null;
}
});
/**
 * Stolen from http://goo.gl/99NSR1.
 */
taoensso.encore.url_decode = (function taoensso$encore$url_decode(var_args){
var args__9188__auto__ = [];
var len__9181__auto___24953 = arguments.length;
var i__9182__auto___24954 = (0);
while(true){
if((i__9182__auto___24954 < len__9181__auto___24953)){
args__9188__auto__.push((arguments[i__9182__auto___24954]));

var G__24955 = (i__9182__auto___24954 + (1));
i__9182__auto___24954 = G__24955;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__24949){
var vec__24950 = p__24949;
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24950,(0),null);
if(cljs.core.truth_(s)){
return decodeURIComponent(s);
} else {
return null;
}
});

taoensso.encore.url_decode.cljs$lang$maxFixedArity = (1);

taoensso.encore.url_decode.cljs$lang$applyTo = (function (seq24947){
var G__24948 = cljs.core.first(seq24947);
var seq24947__$1 = cljs.core.next(seq24947);
return taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(G__24948,seq24947__$1);
});

taoensso.encore.format_query_string = (function taoensso$encore$format_query_string(m){
var param = (function (k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(cljs.core.name(k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.url_encode(v))].join('');
});
var join = ((function (param){
return (function (strs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",strs);
});})(param))
;
if(cljs.core.empty_QMARK_(m)){
return null;
} else {
return join((function (){var iter__8822__auto__ = ((function (param,join){
return (function taoensso$encore$format_query_string_$_iter__24974(s__24975){
return (new cljs.core.LazySeq(null,((function (param,join){
return (function (){
var s__24975__$1 = s__24975;
while(true){
var temp__5457__auto__ = cljs.core.seq(s__24975__$1);
if(temp__5457__auto__){
var s__24975__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(s__24975__$2)){
var c__8820__auto__ = cljs.core.chunk_first(s__24975__$2);
var size__8821__auto__ = cljs.core.count(c__8820__auto__);
var b__24977 = cljs.core.chunk_buffer(size__8821__auto__);
if((function (){var i__24976 = (0);
while(true){
if((i__24976 < size__8821__auto__)){
var vec__24986 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__8820__auto__,i__24976);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24986,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24986,(1),null);
cljs.core.chunk_append(b__24977,((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7960__auto__ = cljs.core.seq(v);
if(or__7960__auto__){
return or__7960__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)));

var G__24992 = (i__24976 + (1));
i__24976 = G__24992;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__24977),taoensso$encore$format_query_string_$_iter__24974(cljs.core.chunk_rest(s__24975__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__24977),null);
}
} else {
var vec__24989 = cljs.core.first(s__24975__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24989,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24989,(1),null);
return cljs.core.cons(((cljs.core.sequential_QMARK_(v))?join(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(param,k),(function (){var or__7960__auto__ = cljs.core.seq(v);
if(or__7960__auto__){
return or__7960__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [""], null);
}
})())):param(k,v)),taoensso$encore$format_query_string_$_iter__24974(cljs.core.rest(s__24975__$2)));
}
} else {
return null;
}
break;
}
});})(param,join))
,null,null));
});})(param,join))
;
return iter__8822__auto__(m);
})());
}
});
taoensso.encore.assoc_conj = (function taoensso$encore$assoc_conj(m,k,v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var temp__5455__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__5455__auto__)){
var cur = temp__5455__auto__;
if(cljs.core.vector_QMARK_(cur)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cur,v);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cur,v], null);
}
} else {
return v;
}
})());
});
/**
 * Based on `ring-codec/form-decode`.
 */
taoensso.encore.parse_query_params = (function taoensso$encore$parse_query_params(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25002 = arguments.length;
var i__9182__auto___25003 = (0);
while(true){
if((i__9182__auto___25003 < len__9181__auto___25002)){
args__9188__auto__.push((arguments[i__9182__auto___25003]));

var G__25004 = (i__9182__auto___25003 + (1));
i__9182__auto___25003 = G__25004;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic = (function (s,p__24995){
var vec__24996 = p__24995;
var keywordize_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24996,(0),null);
var encoding = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24996,(1),null);
var _PERCENT_ = ((clojure.string.blank_QMARK_(s))?cljs.core.PersistentArrayMap.EMPTY:(function (){var s__$1 = (cljs.core.truth_(taoensso.encore.str_starts_with_QMARK_(s,"?"))?taoensso.encore.substr(s,(1)):s);
if(cljs.core.not(taoensso.encore.str_contains_QMARK_(s__$1,"="))){
return cljs.core.PersistentArrayMap.EMPTY;
} else {
var m = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (s__$1,vec__24996,keywordize_QMARK_,encoding){
return (function (m,param){
var temp__5455__auto__ = clojure.string.split.cljs$core$IFn$_invoke$arity$3(param,/=/,(2));
if(cljs.core.truth_(temp__5455__auto__)){
var vec__24999 = temp__5455__auto__;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24999,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24999,(1),null);
return taoensso.encore.assoc_conj(m,taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(k,cljs.core.array_seq([encoding], 0)),taoensso.encore.url_decode.cljs$core$IFn$_invoke$arity$variadic(v,cljs.core.array_seq([encoding], 0)));
} else {
return m;
}
});})(s__$1,vec__24996,keywordize_QMARK_,encoding))
,cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2(s__$1,/&/));
if(cljs.core.not(keywordize_QMARK_)){
return m;
} else {
return taoensso.encore.keywordize_map(m);
}
}
})());
if((function (){
taoensso.encore.hcond(false,"taoensso.encore",null,(new cljs.core.Delay(((function (_PERCENT_,vec__24996,keywordize_QMARK_,encoding){
return (function (){
return _PERCENT_;
});})(_PERCENT_,vec__24996,keywordize_QMARK_,encoding))
,null)),cljs.core.cst$sym$_PERCENT_,cljs.core.map_QMARK_,cljs.core.cst$sym$map_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? map? %)"));
}

return _PERCENT_;
});

taoensso.encore.parse_query_params.cljs$lang$maxFixedArity = (1);

taoensso.encore.parse_query_params.cljs$lang$applyTo = (function (seq24993){
var G__24994 = cljs.core.first(seq24993);
var seq24993__$1 = cljs.core.next(seq24993);
return taoensso.encore.parse_query_params.cljs$core$IFn$_invoke$arity$variadic(G__24994,seq24993__$1);
});

taoensso.encore.merge_url_with_query_string = (function taoensso$encore$merge_url_with_query_string(url,m){
var vec__25008 = clojure.string.split.cljs$core$IFn$_invoke$arity$3([cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join(''),/\?/,(2));
var url__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25008,(0),null);
var _QMARK_qstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25008,(1),null);
var qmap = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([(cljs.core.truth_(_QMARK_qstr)?taoensso.encore.keywordize_map(taoensso.encore.parse_query_params(_QMARK_qstr)):null),taoensso.encore.keywordize_map(m)], 0));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(url__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var temp__5457__auto__ = taoensso.encore.format_query_string(qmap);
if(cljs.core.truth_(temp__5457__auto__)){
var qstr = temp__5457__auto__;
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(qstr)].join('');
} else {
return null;
}
})())].join('');
});
taoensso.encore.memoize_1 = taoensso.encore.memoize1;
taoensso.encore.logging_level = (function (){var G__25011 = cljs.core.cst$kw$debug;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__25011) : cljs.core.atom.call(null,G__25011));
})();
taoensso.encore.set_exp_backoff_timeout_BANG_ = (function taoensso$encore$set_exp_backoff_timeout_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25018 = arguments.length;
var i__9182__auto___25019 = (0);
while(true){
if((i__9182__auto___25019 < len__9181__auto___25018)){
args__9188__auto__.push((arguments[i__9182__auto___25019]));

var G__25020 = (i__9182__auto___25019 + (1));
i__9182__auto___25019 = G__25020;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__25014){
var vec__25015 = p__25014;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25015,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__7960__auto__ = nattempt;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return (0);
}
})()));
});

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq25012){
var G__25013 = cljs.core.first(seq25012);
var seq25012__$1 = cljs.core.next(seq25012);
return taoensso.encore.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__25013,seq25012__$1);
});

taoensso.encore.keys_EQ_ = (function taoensso$encore$keys_EQ_(m,ks){
return taoensso.encore.ks_EQ_(ks,m);
});
taoensso.encore.keys_LT__EQ_ = (function taoensso$encore$keys_LT__EQ_(m,ks){
return taoensso.encore.ks_LT__EQ_(ks,m);
});
taoensso.encore.keys_GT__EQ_ = (function taoensso$encore$keys_GT__EQ_(m,ks){
return taoensso.encore.ks_GT__EQ_(ks,m);
});
taoensso.encore.keys_EQ_nnil_QMARK_ = (function taoensso$encore$keys_EQ_nnil_QMARK_(m,ks){
return taoensso.encore.ks_nnil_QMARK_(ks,m);
});
taoensso.encore.parse_bool = taoensso.encore.as__QMARK_bool;
taoensso.encore.parse_int = taoensso.encore.as__QMARK_int;
taoensso.encore.parse_float = taoensso.encore.as__QMARK_float;
taoensso.encore.as_bool = (function taoensso$encore$as_bool(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2173,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_bool(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_bool,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_int = (function taoensso$encore$as_int(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2174,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_int(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_int,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.as_float = (function taoensso$encore$as_float(x){
if(cljs.core.truth_(x)){
return taoensso.encore.hcond(false,"taoensso.encore",2175,(new cljs.core.Delay((function (){
return taoensso.encore.as__QMARK_float(x);
}),null)),cljs.core.list(cljs.core.cst$sym$as_DASH__QMARK_float,cljs.core.cst$sym$x),taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
} else {
return null;
}
});
taoensso.encore.merge_deep_with = taoensso.encore.nested_merge_with;
taoensso.encore.merge_deep = taoensso.encore.nested_merge;
taoensso.encore.rate_limiter = (function taoensso$encore$rate_limiter(ncalls_limit,window_ms){
return taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
});
taoensso.encore.rate_limited = (function taoensso$encore$rate_limited(ncalls_limit,window_ms,f){
var rl = taoensso.encore.rate_limiter_STAR_(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ncalls_limit,window_ms], null)], null));
return ((function (rl){
return (function() { 
var G__25021__delegate = function (args){
var temp__5455__auto__ = (rl.cljs$core$IFn$_invoke$arity$0 ? rl.cljs$core$IFn$_invoke$arity$0() : rl.call(null));
if(cljs.core.truth_(temp__5455__auto__)){
var backoff_ms = temp__5455__auto__;
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$backoff_DASH_ms,backoff_ms], null);
} else {
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$result,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))], null);
}
};
var G__25021 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__25022__i = 0, G__25022__a = new Array(arguments.length -  0);
while (G__25022__i < G__25022__a.length) {G__25022__a[G__25022__i] = arguments[G__25022__i + 0]; ++G__25022__i;}
  args = new cljs.core.IndexedSeq(G__25022__a,0);
} 
return G__25021__delegate.call(this,args);};
G__25021.cljs$lang$maxFixedArity = 0;
G__25021.cljs$lang$applyTo = (function (arglist__25023){
var args = cljs.core.seq(arglist__25023);
return G__25021__delegate(args);
});
G__25021.cljs$core$IFn$_invoke$arity$variadic = G__25021__delegate;
return G__25021;
})()
;
;})(rl))
});
if(typeof taoensso.encore._STAR_log_level_STAR_ !== 'undefined'){
} else {
/**
 * DEPRECATED
 */
taoensso.encore._STAR_log_level_STAR_ = cljs.core.cst$kw$debug;
}

taoensso.encore.log_QMARK_ = (function (){var __GT_n = new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$trace,(1),cljs.core.cst$kw$debug,(2),cljs.core.cst$kw$info,(3),cljs.core.cst$kw$warn,(4),cljs.core.cst$kw$error,(5),cljs.core.cst$kw$fatal,(6),cljs.core.cst$kw$report,(7)], null);
return ((function (__GT_n){
return (function (level){
return ((__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(level) : __GT_n.call(null,level)) >= (__GT_n.cljs$core$IFn$_invoke$arity$1 ? __GT_n.cljs$core$IFn$_invoke$arity$1(taoensso.encore._STAR_log_level_STAR_) : __GT_n.call(null,taoensso.encore._STAR_log_level_STAR_)));
});
;})(__GT_n))
})();

taoensso.encore.tracef = (function taoensso$encore$tracef(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25045 = arguments.length;
var i__9182__auto___25046 = (0);
while(true){
if((i__9182__auto___25046 < len__9181__auto___25045)){
args__9188__auto__.push((arguments[i__9182__auto___25046]));

var G__25047 = (i__9182__auto___25046 + (1));
i__9182__auto___25046 = G__25047;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25026 = cljs.core.cst$kw$trace;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25026) : taoensso.encore.log_QMARK_.call(null,G__25026));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.tracef.cljs$lang$maxFixedArity = (1);

taoensso.encore.tracef.cljs$lang$applyTo = (function (seq25024){
var G__25025 = cljs.core.first(seq25024);
var seq25024__$1 = cljs.core.next(seq25024);
return taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic(G__25025,seq25024__$1);
});


taoensso.encore.debugf = (function taoensso$encore$debugf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25048 = arguments.length;
var i__9182__auto___25049 = (0);
while(true){
if((i__9182__auto___25049 < len__9181__auto___25048)){
args__9188__auto__.push((arguments[i__9182__auto___25049]));

var G__25050 = (i__9182__auto___25049 + (1));
i__9182__auto___25049 = G__25050;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25029 = cljs.core.cst$kw$debug;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25029) : taoensso.encore.log_QMARK_.call(null,G__25029));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.debugf.cljs$lang$maxFixedArity = (1);

taoensso.encore.debugf.cljs$lang$applyTo = (function (seq25027){
var G__25028 = cljs.core.first(seq25027);
var seq25027__$1 = cljs.core.next(seq25027);
return taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic(G__25028,seq25027__$1);
});


taoensso.encore.infof = (function taoensso$encore$infof(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25051 = arguments.length;
var i__9182__auto___25052 = (0);
while(true){
if((i__9182__auto___25052 < len__9181__auto___25051)){
args__9188__auto__.push((arguments[i__9182__auto___25052]));

var G__25053 = (i__9182__auto___25052 + (1));
i__9182__auto___25052 = G__25053;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25032 = cljs.core.cst$kw$info;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25032) : taoensso.encore.log_QMARK_.call(null,G__25032));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.infof.cljs$lang$maxFixedArity = (1);

taoensso.encore.infof.cljs$lang$applyTo = (function (seq25030){
var G__25031 = cljs.core.first(seq25030);
var seq25030__$1 = cljs.core.next(seq25030);
return taoensso.encore.infof.cljs$core$IFn$_invoke$arity$variadic(G__25031,seq25030__$1);
});


taoensso.encore.warnf = (function taoensso$encore$warnf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25054 = arguments.length;
var i__9182__auto___25055 = (0);
while(true){
if((i__9182__auto___25055 < len__9181__auto___25054)){
args__9188__auto__.push((arguments[i__9182__auto___25055]));

var G__25056 = (i__9182__auto___25055 + (1));
i__9182__auto___25055 = G__25056;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25035 = cljs.core.cst$kw$warn;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25035) : taoensso.encore.log_QMARK_.call(null,G__25035));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("WARN: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.warnf.cljs$lang$maxFixedArity = (1);

taoensso.encore.warnf.cljs$lang$applyTo = (function (seq25033){
var G__25034 = cljs.core.first(seq25033);
var seq25033__$1 = cljs.core.next(seq25033);
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic(G__25034,seq25033__$1);
});


taoensso.encore.errorf = (function taoensso$encore$errorf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25057 = arguments.length;
var i__9182__auto___25058 = (0);
while(true){
if((i__9182__auto___25058 < len__9181__auto___25057)){
args__9188__auto__.push((arguments[i__9182__auto___25058]));

var G__25059 = (i__9182__auto___25058 + (1));
i__9182__auto___25058 = G__25059;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25038 = cljs.core.cst$kw$error;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25038) : taoensso.encore.log_QMARK_.call(null,G__25038));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("ERROR: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.errorf.cljs$lang$maxFixedArity = (1);

taoensso.encore.errorf.cljs$lang$applyTo = (function (seq25036){
var G__25037 = cljs.core.first(seq25036);
var seq25036__$1 = cljs.core.next(seq25036);
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic(G__25037,seq25036__$1);
});


taoensso.encore.fatalf = (function taoensso$encore$fatalf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25060 = arguments.length;
var i__9182__auto___25061 = (0);
while(true){
if((i__9182__auto___25061 < len__9181__auto___25060)){
args__9188__auto__.push((arguments[i__9182__auto___25061]));

var G__25062 = (i__9182__auto___25061 + (1));
i__9182__auto___25061 = G__25062;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25041 = cljs.core.cst$kw$fatal;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25041) : taoensso.encore.log_QMARK_.call(null,G__25041));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("FATAL: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(fmt)].join(''),xs);
} else {
return null;
}
});

taoensso.encore.fatalf.cljs$lang$maxFixedArity = (1);

taoensso.encore.fatalf.cljs$lang$applyTo = (function (seq25039){
var G__25040 = cljs.core.first(seq25039);
var seq25039__$1 = cljs.core.next(seq25039);
return taoensso.encore.fatalf.cljs$core$IFn$_invoke$arity$variadic(G__25040,seq25039__$1);
});


taoensso.encore.reportf = (function taoensso$encore$reportf(var_args){
var args__9188__auto__ = [];
var len__9181__auto___25063 = arguments.length;
var i__9182__auto___25064 = (0);
while(true){
if((i__9182__auto___25064 < len__9181__auto___25063)){
args__9188__auto__.push((arguments[i__9182__auto___25064]));

var G__25065 = (i__9182__auto___25064 + (1));
i__9182__auto___25064 = G__25065;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic = (function (fmt,xs){
if(cljs.core.truth_((function (){var G__25044 = cljs.core.cst$kw$report;
return (taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1 ? taoensso.encore.log_QMARK_.cljs$core$IFn$_invoke$arity$1(G__25044) : taoensso.encore.log_QMARK_.call(null,G__25044));
})())){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(taoensso.encore.logf,fmt,xs);
} else {
return null;
}
});

taoensso.encore.reportf.cljs$lang$maxFixedArity = (1);

taoensso.encore.reportf.cljs$lang$applyTo = (function (seq25042){
var G__25043 = cljs.core.first(seq25042);
var seq25042__$1 = cljs.core.next(seq25042);
return taoensso.encore.reportf.cljs$core$IFn$_invoke$arity$variadic(G__25043,seq25042__$1);
});

