// Compiled by ClojureScript 1.9.518 {:static-fns true, :optimize-constants true}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('taoensso.sente.interfaces');
taoensso.sente.set_logging_level_BANG_ = (function taoensso$sente$set_logging_level_BANG_(level){
return taoensso.encore._STAR_log_level_STAR_ = level;
});
/**
 * Alpha - subject to change.
 *   Simple+lightweight Ajax via Google Closure. Returns nil, or the xhr instance.
 *   Ref. https://developers.google.com/closure/library/docs/xhrio.
 * 
 *   (ajax-call "/my-post-route"
 *  {:method     :post
 *   :params     {:username "Rich Hickey"
 *                :type     "Awesome"}
 *   :headers    {"Foo" "Bar"}
 *   :resp-type  :text
 *   :timeout-ms 7000
 *   :with-credentials? false ; Enable if using CORS (requires xhr v2+)
 *  }
 *  (fn async-callback [resp-map]
 *    (let [{:keys [success? ?status ?error ?content ?content-type]} resp-map]
 *      ;; ?status  - 200, 404, ..., or nil on no response
 *      ;; ?error   - e/o #{:xhr-pool-depleted :exception :http-error :abort
 *      ;;                  :timeout :no-content <http-error-status> nil}
 *      (js/alert (str "Ajax response: " resp-map)))))
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_(x))){
return cljs.core.cst$kw$wrong_DASH_type;
} else {
if(cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count(x)))){
return cljs.core.cst$kw$wrong_DASH_length;
} else {
var vec__29446 = x;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29446,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29446,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return cljs.core.cst$kw$wrong_DASH_id_DASH_type;
} else {
if(cljs.core.not(cljs.core.namespace(ev_id))){
return cljs.core.cst$kw$unnamespaced_DASH_id;
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event(x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_(x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_bad_DASH_event,x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__5457__auto__ = taoensso.sente.validate_event(x);
if(cljs.core.truth_(temp__5457__auto__)){
var _QMARK_err = temp__5457__auto__;
var err_fmt = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__29450 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__29450) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('')));

}
})()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" Event should be of `[ev-id ?ev-data]` form: %s")].join('');
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic(err_fmt,cljs.core.array_seq([[cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')], 0)),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$malformed_DASH_event,x], null));
} else {
return null;
}
});
taoensso.sente.event_msg_QMARK_ = (function taoensso$sente$event_msg_QMARK_(x){
var and__7948__auto__ = cljs.core.map_QMARK_(x);
if(and__7948__auto__){
var and__7948__auto____$1 = taoensso.encore.keys_EQ_(x,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$ch_DASH_recv,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$event,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$_QMARK_data,null,cljs.core.cst$kw$send_DASH_fn,null], null), null));
if(cljs.core.truth_(and__7948__auto____$1)){
var map__29454 = x;
var map__29454__$1 = ((((!((map__29454 == null)))?((((map__29454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29454.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29454):map__29454);
var ch_recv = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29454__$1,cljs.core.cst$kw$ch_DASH_recv);
var send_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29454__$1,cljs.core.cst$kw$send_DASH_fn);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29454__$1,cljs.core.cst$kw$state);
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29454__$1,cljs.core.cst$kw$event);
var and__7948__auto____$2 = taoensso.encore.chan_QMARK_(ch_recv);
if(cljs.core.truth_(and__7948__auto____$2)){
var and__7948__auto____$3 = cljs.core.ifn_QMARK_(send_fn);
if(and__7948__auto____$3){
var and__7948__auto____$4 = taoensso.encore.atom_QMARK_(state);
if(cljs.core.truth_(and__7948__auto____$4)){
return taoensso.sente.event_QMARK_(event);
} else {
return and__7948__auto____$4;
}
} else {
return and__7948__auto____$3;
}
} else {
return and__7948__auto____$2;
}
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
});
/**
 * Note that cb reply need _not_ be `event` form!
 */
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$chsk_SLASH_closed,null,cljs.core.cst$kw$chsk_SLASH_error,null,cljs.core.cst$kw$chsk_SLASH_timeout,null], null), null).call(null,cb_reply_clj));
});
/**
 * pstr->clj
 */
taoensso.sente.unpack_STAR_ = (function taoensso$sente$unpack_STAR_(packer,pstr){
try{return taoensso.sente.interfaces.unpack(packer,taoensso.encore.hcond(false,"taoensso.sente",215,(new cljs.core.Delay((function (){
return pstr;
}),null)),cljs.core.cst$sym$pstr,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_));
}catch (e29457){var t = e29457;
taoensso.encore.debugf.cljs$core$IFn$_invoke$arity$variadic("Bad package: %s (%s)",cljs.core.array_seq([pstr,t], 0));

throw t;
}});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq(_QMARK_m)){
return cljs.core.with_meta(x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack_STAR_ = (function taoensso$sente$pack_STAR_(var_args){
var args29458 = [];
var len__9181__auto___29461 = arguments.length;
var i__9182__auto___29462 = (0);
while(true){
if((i__9182__auto___29462 < len__9181__auto___29461)){
args29458.push((arguments[i__9182__auto___29462]));

var G__29463 = (i__9182__auto___29462 + (1));
i__9182__auto___29462 = G__29463;
continue;
} else {
}
break;
}

var G__29460 = args29458.length;
switch (G__29460) {
case 3:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29458.length)].join('')));

}
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,taoensso.sente.with__QMARK_meta(clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_cb_uuid,cljs.core.cst$kw$ajax_DASH_cb))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("+"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack(packer,taoensso.sente.with__QMARK_meta(wrapped_clj,_QMARK_packer_meta)))].join('');
});

taoensso.sente.pack_STAR_.cljs$lang$maxFixedArity = 4;

taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args__9188__auto__ = [];
var len__9181__auto___29466 = arguments.length;
var i__9182__auto___29467 = (0);
while(true){
if((i__9182__auto___29467 < len__9181__auto___29466)){
args__9188__auto__.push((arguments[i__9182__auto___29467]));

var G__29468 = (i__9182__auto___29467 + (1));
i__9182__auto___29467 = G__29468;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((0) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((0)),(0),null)):null);
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(argseq__9189__auto__);
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic = (function (args){
var pstr = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(taoensso.sente.pack_STAR_,args);
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Packing: %s -> %s",cljs.core.array_seq([args,pstr], 0));

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = (0);

taoensso.sente.pack.cljs$lang$applyTo = (function (seq29465){
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29465));
});

/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return prefixed_pstr;
}),null)),cljs.core.cst$sym$prefixed_DASH_pstr,cljs.core.string_QMARK_,cljs.core.cst$sym$string_QMARK_);


var prefix = taoensso.encore.substr.cljs$core$IFn$_invoke$arity$variadic(prefixed_pstr,(0),cljs.core.array_seq([(1)], 0));
var pstr = taoensso.encore.substr(prefixed_pstr,(1));
var clj = taoensso.sente.unpack_STAR_(packer,pstr);
var wrapped_QMARK_ = (function (){var G__29476 = prefix;
switch (G__29476) {
case "-":
return false;

break;
case "+":
return true;

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefix)].join('')));

}
})();
var vec__29473 = (cljs.core.truth_(wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29473,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29473,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),_QMARK_cb_uuid))?cljs.core.cst$kw$ajax_DASH_cb:_QMARK_cb_uuid);
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Unpacking: %s -> %s",cljs.core.array_seq([prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], 0));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

/**
 * Implementation detail.
 */
taoensso.sente.chsk_init_BANG_ = (function taoensso$sente$chsk_init_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1(chsk);
} else {
var x__8678__auto__ = (((chsk == null))?null:chsk);
var m__8679__auto__ = (taoensso.sente.chsk_init_BANG_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto__.call(null,chsk));
} else {
var m__8679__auto____$1 = (taoensso.sente.chsk_init_BANG_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-init!",chsk);
}
}
}
});

/**
 * Kills socket, stops auto-reconnects.
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1(chsk);
} else {
var x__8678__auto__ = (((chsk == null))?null:chsk);
var m__8679__auto__ = (taoensso.sente.chsk_destroy_BANG_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto__.call(null,chsk));
} else {
var m__8679__auto____$1 = (taoensso.sente.chsk_destroy_BANG_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-destroy!",chsk);
}
}
}
});

/**
 * Drops connection, allows auto-reconnect. Useful for reauthenticating after login/logout.
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__8678__auto__ = (((chsk == null))?null:chsk);
var m__8679__auto__ = (taoensso.sente.chsk_reconnect_BANG_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto__.call(null,chsk));
} else {
var m__8679__auto____$1 = (taoensso.sente.chsk_reconnect_BANG_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$1(chsk) : m__8679__auto____$1.call(null,chsk));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-reconnect!",chsk);
}
}
}
});

/**
 * Implementation detail.
 */
taoensso.sente.chsk_send_BANG__STAR_ = (function taoensso$sente$chsk_send_BANG__STAR_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3(chsk,ev,opts);
} else {
var x__8678__auto__ = (((chsk == null))?null:chsk);
var m__8679__auto__ = (taoensso.sente.chsk_send_BANG__STAR_[goog.typeOf(x__8678__auto__)]);
if(!((m__8679__auto__ == null))){
return (m__8679__auto__.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto__.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__8679__auto__.call(null,chsk,ev,opts));
} else {
var m__8679__auto____$1 = (taoensso.sente.chsk_send_BANG__STAR_["_"]);
if(!((m__8679__auto____$1 == null))){
return (m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__8679__auto____$1.cljs$core$IFn$_invoke$arity$3(chsk,ev,opts) : m__8679__auto____$1.call(null,chsk,ev,opts));
} else {
throw cljs.core.missing_protocol("IChSocket.chsk-send!*",chsk);
}
}
}
});

/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args29478 = [];
var len__9181__auto___29481 = arguments.length;
var i__9182__auto___29482 = (0);
while(true){
if((i__9182__auto___29482 < len__9181__auto___29481)){
args29478.push((arguments[i__9182__auto___29482]));

var G__29483 = (i__9182__auto___29482 + (1));
i__9182__auto___29482 = G__29483;
continue;
} else {
}
break;
}

var G__29480 = args29478.length;
switch (G__29480) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args29478.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3(chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$timeout_DASH_ms,_QMARK_timeout_ms,cljs.core.cst$kw$cb,_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Chsk send: (%s) %s",cljs.core.array_seq([cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$cb,cljs.core.boolean$(cljs.core.cst$kw$cb.cljs$core$IFn$_invoke$arity$1(opts))),ev], 0));

return taoensso.sente.chsk_send_BANG__STAR_(chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;

taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event(x);

if(cljs.core.truth_((function (){var or__7960__auto__ = ((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null));
if(or__7960__auto__){
return or__7960__auto__;
} else {
return taoensso.encore.nneg_int_QMARK_(_QMARK_timeout_ms);
}
})())){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic("cb requires a timeout; timeout-ms should be a +ive integer: %s",cljs.core.array_seq([_QMARK_timeout_ms], 0))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nneg-int? ?timeout-ms)))")].join('')));
}

if(cljs.core.truth_((function (){var or__7960__auto__ = (_QMARK_cb == null);
if(or__7960__auto__){
return or__7960__auto__;
} else {
var or__7960__auto____$1 = cljs.core.ifn_QMARK_(_QMARK_cb);
if(or__7960__auto____$1){
return or__7960__auto____$1;
} else {
return taoensso.encore.chan_QMARK_(_QMARK_cb);
}
}
})())){
return null;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.format.cljs$core$IFn$_invoke$arity$variadic("cb should be nil, an ifn, or a channel: %s",cljs.core.array_seq([cljs.core.type(_QMARK_cb)], 0))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))")].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__5457__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5457__auto__)){
var cb_uuid = temp__5457__auto__;
return taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__5457__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped(cljs.core.cst$kw$swap_SLASH_dissoc,_QMARK_f);
});})(cb_uuid,temp__5457__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__29485,merge_state){
var map__29491 = p__29485;
var map__29491__$1 = ((((!((map__29491 == null)))?((((map__29491.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29491.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29491):map__29491);
var chsk = map__29491__$1;
var chs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29491__$1,cljs.core.cst$kw$chs);
var state_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29491__$1,cljs.core.cst$kw$state_);
var vec__29493 = taoensso.encore.swap_in_BANG_.cljs$core$IFn$_invoke$arity$3(state_,cljs.core.PersistentVector.EMPTY,((function (map__29491,map__29491__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([old_state,merge_state], 0));
var new_state__$1 = ((cljs.core.not((function (){var and__7948__auto__ = cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_.cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__7948__auto__)){
var and__7948__auto____$1 = cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__7948__auto____$1)){
return cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__7948__auto____$1;
}
} else {
return and__7948__auto__;
}
})()))?new_state:cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(new_state,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_),cljs.core.cst$kw$requested_DASH_reconnect_QMARK_,true));
return taoensso.encore.swapped(new_state__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$1], null));
});})(map__29491,map__29491__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29493,(0),null);
var new_state = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29493,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_state,new_state)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(chs),new_state);

return new_state;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_(_QMARK_cb))){
return _QMARK_cb;
} else {
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay((function (){
return _QMARK_cb;
}),null)),cljs.core.cst$sym$_QMARK_cb,taoensso.encore.chan_QMARK_,cljs.core.cst$sym$enc_SLASH_chan_QMARK_);


taoensso.sente.assert_event(ev);

var vec__29499 = ev;
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29499,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29499,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__29499,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.fq_name(ev_id)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".cb")].join('')),reply], null));
});
;})(vec__29499,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("receive-buffered-evs!: %s",cljs.core.array_seq([clj], 0));

var buffered_evs = taoensso.encore.hcond(false,"taoensso.sente",739,(new cljs.core.Delay((function (){
return clj;
}),null)),cljs.core.cst$sym$clj,cljs.core.vector_QMARK_,cljs.core.cst$sym$vector_QMARK_);
var seq__29506 = cljs.core.seq(buffered_evs);
var chunk__29507 = null;
var count__29508 = (0);
var i__29509 = (0);
while(true){
if((i__29509 < count__29508)){
var ev = chunk__29507.cljs$core$IIndexed$_nth$arity$2(null,i__29509);
taoensso.sente.assert_event(ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__29510 = seq__29506;
var G__29511 = chunk__29507;
var G__29512 = count__29508;
var G__29513 = (i__29509 + (1));
seq__29506 = G__29510;
chunk__29507 = G__29511;
count__29508 = G__29512;
i__29509 = G__29513;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq(seq__29506);
if(temp__5457__auto__){
var seq__29506__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__29506__$1)){
var c__8871__auto__ = cljs.core.chunk_first(seq__29506__$1);
var G__29514 = cljs.core.chunk_rest(seq__29506__$1);
var G__29515 = c__8871__auto__;
var G__29516 = cljs.core.count(c__8871__auto__);
var G__29517 = (0);
seq__29506 = G__29514;
chunk__29507 = G__29515;
count__29508 = G__29516;
i__29509 = G__29517;
continue;
} else {
var ev = cljs.core.first(seq__29506__$1);
taoensso.sente.assert_event(ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__29518 = cljs.core.next(seq__29506__$1);
var G__29519 = null;
var G__29520 = (0);
var G__29521 = (0);
seq__29506 = G__29518;
chunk__29507 = G__29519;
count__29508 = G__29520;
i__29509 = G__29521;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handle_when_handshake_BANG_ = (function taoensso$sente$handle_when_handshake_BANG_(chsk,chs,clj){
var handshake_QMARK_ = (cljs.core.vector_QMARK_(clj)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(clj),cljs.core.cst$kw$chsk_SLASH_handshake));
taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("handle-when-handshake (%s): %s",cljs.core.array_seq([((handshake_QMARK_)?cljs.core.cst$kw$handshake:cljs.core.cst$kw$non_DASH_handshake),clj], 0));

if(handshake_QMARK_){
var vec__29528 = clj;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29528,(0),null);
var vec__29531 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29528,(1),null);
var _QMARK_uid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29531,(0),null);
var _QMARK_csrf_token = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29531,(1),null);
var _QMARK_handshake_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29531,(2),null);
var handshake_ev = vec__29528;
if(clojure.string.blank_QMARK_(_QMARK_csrf_token)){
taoensso.encore.warnf("SECURITY WARNING: no CSRF token available for use by Sente");
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_(chsk,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$open_QMARK_,true,cljs.core.cst$kw$uid,_QMARK_uid,cljs.core.cst$kw$csrf_DASH_token,_QMARK_csrf_token], null));

taoensso.sente.assert_event(handshake_ev);

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$internal.cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return cljs.core.cst$kw$handled;
} else {
return null;
}
});
taoensso.sente.set_exp_backoff_timeout_BANG_ = (function taoensso$sente$set_exp_backoff_timeout_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___29540 = arguments.length;
var i__9182__auto___29541 = (0);
while(true){
if((i__9182__auto___29541 < len__9181__auto___29540)){
args__9188__auto__.push((arguments[i__9182__auto___29541]));

var G__29542 = (i__9182__auto___29541 + (1));
i__9182__auto___29541 = G__29542;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (nullary_f,p__29536){
var vec__29537 = p__29536;
var nattempt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29537,(0),null);
return window.setTimeout(nullary_f,taoensso.encore.exp_backoff((function (){var or__7960__auto__ = nattempt;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return (0);
}
})()));
});

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$lang$applyTo = (function (seq29534){
var G__29535 = cljs.core.first(seq29534);
var seq29534__$1 = cljs.core.next(seq29534);
return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29535,seq29534__$1);
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.chs = chs;
this.socket_ = socket_;
this.kalive_ms = kalive_ms;
this.kalive_timer_ = kalive_timer_;
this.kalive_due_QMARK__ = kalive_due_QMARK__;
this.nattempt_ = nattempt_;
this.cbs_waiting_ = cbs_waiting_;
this.state_ = state_;
this.packer = packer;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8635__auto__,k__8636__auto__){
var self__ = this;
var this__8635__auto____$1 = this;
return this__8635__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8636__auto__,null);
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8637__auto__,k29544,else__8638__auto__){
var self__ = this;
var this__8637__auto____$1 = this;
var G__29546 = (((k29544 instanceof cljs.core.Keyword))?k29544.fqn:null);
switch (G__29546) {
case "client-id":
return self__.client_id;

break;
case "kalive-ms":
return self__.kalive_ms;

break;
case "nattempt_":
return self__.nattempt_;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "kalive-due?_":
return self__.kalive_due_QMARK__;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "kalive-timer_":
return self__.kalive_timer_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k29544,else__8638__auto__);

}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8649__auto__,writer__8650__auto__,opts__8651__auto__){
var self__ = this;
var this__8649__auto____$1 = this;
var pr_pair__8652__auto__ = ((function (this__8649__auto____$1){
return (function (keyval__8653__auto__){
return cljs.core.pr_sequential_writer(writer__8650__auto__,cljs.core.pr_writer,""," ","",opts__8651__auto__,keyval__8653__auto__);
});})(this__8649__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__8650__auto__,pr_pair__8652__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__8651__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$socket_,self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_ms,self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_timer_,self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_due_QMARK__,self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$nattempt_,self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cbs_DASH_waiting_,self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29543){
var self__ = this;
var G__29543__$1 = this;
return (new cljs.core.RecordIter((0),G__29543__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8633__auto__){
var self__ = this;
var this__8633__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8629__auto__){
var self__ = this;
var this__8629__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8639__auto__){
var self__ = this;
var this__8639__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8630__auto__){
var self__ = this;
var this__8630__auto____$1 = this;
var h__8402__auto__ = self__.__hash;
if(!((h__8402__auto__ == null))){
return h__8402__auto__;
} else {
var h__8402__auto____$1 = cljs.core.hash_imap(this__8630__auto____$1);
self__.__hash = h__8402__auto____$1;

return h__8402__auto____$1;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8631__auto__,other__8632__auto__){
var self__ = this;
var this__8631__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7948__auto__ = other__8632__auto__;
if(cljs.core.truth_(and__7948__auto__)){
return ((this__8631__auto____$1.constructor === other__8632__auto__.constructor)) && (cljs.core.equiv_map(this__8631__auto____$1,other__8632__auto__));
} else {
return and__7948__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8644__auto__,k__8645__auto__){
var self__ = this;
var this__8644__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$client_DASH_id,null,cljs.core.cst$kw$kalive_DASH_ms,null,cljs.core.cst$kw$nattempt_,null,cljs.core.cst$kw$packer,null,cljs.core.cst$kw$chs,null,cljs.core.cst$kw$socket_,null,cljs.core.cst$kw$url,null,cljs.core.cst$kw$kalive_DASH_due_QMARK__,null,cljs.core.cst$kw$cbs_DASH_waiting_,null,cljs.core.cst$kw$kalive_DASH_timer_,null,cljs.core.cst$kw$state_,null], null), null),k__8645__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__8644__auto____$1),self__.__meta),k__8645__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__8645__auto__)),null));
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8642__auto__,k__8643__auto__,G__29543){
var self__ = this;
var this__8642__auto____$1 = this;
var pred__29547 = cljs.core.keyword_identical_QMARK_;
var expr__29548 = k__8643__auto__;
if(cljs.core.truth_((function (){var G__29550 = cljs.core.cst$kw$client_DASH_id;
var G__29551 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29550,G__29551) : pred__29547.call(null,G__29550,G__29551));
})())){
return (new taoensso.sente.ChWebSocket(G__29543,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29552 = cljs.core.cst$kw$url;
var G__29553 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29552,G__29553) : pred__29547.call(null,G__29552,G__29553));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__29543,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29554 = cljs.core.cst$kw$chs;
var G__29555 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29554,G__29555) : pred__29547.call(null,G__29554,G__29555));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,G__29543,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29556 = cljs.core.cst$kw$socket_;
var G__29557 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29556,G__29557) : pred__29547.call(null,G__29556,G__29557));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,G__29543,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29558 = cljs.core.cst$kw$kalive_DASH_ms;
var G__29559 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29558,G__29559) : pred__29547.call(null,G__29558,G__29559));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,G__29543,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29560 = cljs.core.cst$kw$kalive_DASH_timer_;
var G__29561 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29560,G__29561) : pred__29547.call(null,G__29560,G__29561));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,G__29543,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29562 = cljs.core.cst$kw$kalive_DASH_due_QMARK__;
var G__29563 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29562,G__29563) : pred__29547.call(null,G__29562,G__29563));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,G__29543,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29564 = cljs.core.cst$kw$nattempt_;
var G__29565 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29564,G__29565) : pred__29547.call(null,G__29564,G__29565));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,G__29543,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29566 = cljs.core.cst$kw$cbs_DASH_waiting_;
var G__29567 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29566,G__29567) : pred__29547.call(null,G__29566,G__29567));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,G__29543,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29568 = cljs.core.cst$kw$state_;
var G__29569 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29568,G__29569) : pred__29547.call(null,G__29568,G__29569));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,G__29543,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29570 = cljs.core.cst$kw$packer;
var G__29571 = expr__29548;
return (pred__29547.cljs$core$IFn$_invoke$arity$2 ? pred__29547.cljs$core$IFn$_invoke$arity$2(G__29570,G__29571) : pred__29547.call(null,G__29570,G__29571));
})())){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,G__29543,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__8643__auto__,G__29543),null));
}
}
}
}
}
}
}
}
}
}
}
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8647__auto__){
var self__ = this;
var this__8647__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$socket_,self__.socket_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_ms,self__.kalive_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_timer_,self__.kalive_timer_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$kalive_DASH_due_QMARK__,self__.kalive_due_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$nattempt_,self__.nattempt_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cbs_DASH_waiting_,self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8634__auto__,G__29543){
var self__ = this;
var this__8634__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.url,self__.chs,self__.socket_,self__.kalive_ms,self__.kalive_timer_,self__.kalive_due_QMARK__,self__.nattempt_,self__.cbs_waiting_,self__.state_,self__.packer,G__29543,self__.__extmap,self__.__hash));
});

taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8640__auto__,entry__8641__auto__){
var self__ = this;
var this__8640__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__8641__auto__)){
return this__8640__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__8640__auto____$1,entry__8641__auto__);
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__29572){
var self__ = this;
var map__29573 = p__29572;
var map__29573__$1 = ((((!((map__29573 == null)))?((((map__29573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29573.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29573):map__29573);
var opts = map__29573__$1;
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29573__$1,cljs.core.cst$kw$timeout_DASH_ms);
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29573__$1,cljs.core.cst$kw$cb);
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29573__$1,cljs.core.cst$kw$flush_QMARK_);
var chsk__$1 = this;
taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
taoensso.encore.warnf("Chsk send against closed chsk.");

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__29575 = cljs.core.cst$kw$chsk_SLASH_closed;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__29575) : _QMARK_cb_fn.call(null,G__29575));
} else {
return null;
}
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$1((6)):null);
var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.packer,cljs.core.meta(ev),ev,_QMARK_cb_uuid], 0));
var temp__5457__auto___29622 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5457__auto___29622)){
var cb_uuid_29623 = temp__5457__auto___29622;
taoensso.encore.reset_in_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_29623], null),taoensso.encore.hcond(false,"taoensso.sente",804,(new cljs.core.Delay(((function (cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),cljs.core.cst$sym$_QMARK_cb_DASH_fn,taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_));

var temp__5457__auto___29624__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__5457__auto___29624__$1)){
var timeout_ms_29625 = temp__5457__auto___29624__$1;
var c__26566__auto___29626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (state_29586){
var state_val_29587 = (state_29586[(1)]);
if((state_val_29587 === (1))){
var inst_29576 = cljs.core.async.timeout(timeout_ms_29625);
var state_29586__$1 = state_29586;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29586__$1,(2),inst_29576);
} else {
if((state_val_29587 === (2))){
var inst_29579 = (state_29586[(7)]);
var inst_29578 = (state_29586[(2)]);
var inst_29579__$1 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,_QMARK_cb_uuid);
var state_29586__$1 = (function (){var statearr_29588 = state_29586;
(statearr_29588[(8)] = inst_29578);

(statearr_29588[(7)] = inst_29579__$1);

return statearr_29588;
})();
if(cljs.core.truth_(inst_29579__$1)){
var statearr_29589_29627 = state_29586__$1;
(statearr_29589_29627[(1)] = (3));

} else {
var statearr_29590_29628 = state_29586__$1;
(statearr_29590_29628[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29587 === (3))){
var inst_29579 = (state_29586[(7)]);
var inst_29581 = (function (){var G__29591 = cljs.core.cst$kw$chsk_SLASH_timeout;
return (inst_29579.cljs$core$IFn$_invoke$arity$1 ? inst_29579.cljs$core$IFn$_invoke$arity$1(G__29591) : inst_29579.call(null,G__29591));
})();
var state_29586__$1 = state_29586;
var statearr_29592_29629 = state_29586__$1;
(statearr_29592_29629[(2)] = inst_29581);

(statearr_29592_29629[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29587 === (4))){
var state_29586__$1 = state_29586;
var statearr_29593_29630 = state_29586__$1;
(statearr_29593_29630[(2)] = null);

(statearr_29593_29630[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29587 === (5))){
var inst_29584 = (state_29586[(2)]);
var state_29586__$1 = state_29586;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29586__$1,inst_29584);
} else {
return null;
}
}
}
}
}
});})(c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
return ((function (switch__26440__auto__,c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function() {
var taoensso$sente$state_machine__26441__auto__ = null;
var taoensso$sente$state_machine__26441__auto____0 = (function (){
var statearr_29597 = [null,null,null,null,null,null,null,null,null];
(statearr_29597[(0)] = taoensso$sente$state_machine__26441__auto__);

(statearr_29597[(1)] = (1));

return statearr_29597;
});
var taoensso$sente$state_machine__26441__auto____1 = (function (state_29586){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29586);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29598){if((e29598 instanceof Object)){
var ex__26444__auto__ = e29598;
var statearr_29599_29631 = state_29586;
(statearr_29599_29631[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29586);

return cljs.core.cst$kw$recur;
} else {
throw e29598;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29632 = state_29586;
state_29586 = G__29632;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
taoensso$sente$state_machine__26441__auto__ = function(state_29586){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__26441__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__26441__auto____1.call(this,state_29586);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
taoensso$sente$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__26441__auto____0;
taoensso$sente$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__26441__auto____1;
return taoensso$sente$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
})();
var state__26568__auto__ = (function (){var statearr_29600 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29600[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___29626);

return statearr_29600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___29626,timeout_ms_29625,temp__5457__auto___29624__$1,cb_uuid_29623,temp__5457__auto___29622,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
);

} else {
}
} else {
}

try{(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_)).send(ppstr);

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.kalive_due_QMARK__,false) : cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,false));

return cljs.core.cst$kw$apparent_DASH_success;
}catch (e29601){if((e29601 instanceof Error)){
var e = e29601;
taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk send error: %s",cljs.core.array_seq([e], 0));

var temp__5457__auto___29633 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5457__auto___29633)){
var cb_uuid_29634 = temp__5457__auto___29633;
var cb_fn_STAR__29635 = (function (){var or__7960__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid_29634);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.hcond(false,"taoensso.sente",818,(new cljs.core.Delay(((function (or__7960__auto__,cb_uuid_29634,temp__5457__auto___29633,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function (){
return _QMARK_cb_fn;
});})(or__7960__auto__,cb_uuid_29634,temp__5457__auto___29633,e,_QMARK_cb_uuid,ppstr,_QMARK_cb_fn,chsk__$1,map__29573,map__29573__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
,null)),cljs.core.cst$sym$_QMARK_cb_DASH_fn,taoensso.encore.nnil_QMARK_,cljs.core.cst$sym$taoensso$encore_SLASH_nnil_QMARK_);
}
})();
var G__29602_29636 = cljs.core.cst$kw$chsk_SLASH_error;
(cb_fn_STAR__29635.cljs$core$IFn$_invoke$arity$1 ? cb_fn_STAR__29635.cljs$core$IFn$_invoke$arity$1(G__29602_29636) : cb_fn_STAR__29635.call(null,G__29602_29636));
} else {
}

return false;
} else {
throw e29601;

}
}}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_,true], null));

var temp__5457__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_));
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close((3000),"SENTE_RECONNECT");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,true], null));

var temp__5457__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.socket_) : cljs.core.deref.call(null,self__.socket_));
if(cljs.core.truth_(temp__5457__auto__)){
var s = temp__5457__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});

taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__5457__auto__ = (function (){var or__7960__auto__ = (window["WebSocket"]);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return (window["MozWebSocket"]);
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var WebSocket = temp__5457__auto__;
((function (WebSocket,temp__5457__auto__,chsk__$1){
return (function taoensso$sente$connect_BANG_(){
if(cljs.core.truth_(cljs.core.cst$kw$destroyed_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
return null;
} else {
var retry_BANG_ = ((function (WebSocket,temp__5457__auto__,chsk__$1){
return (function (){
var nattempt_STAR_ = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(self__.nattempt_,cljs.core.inc);
window.clearInterval((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.kalive_timer_) : cljs.core.deref.call(null,self__.kalive_timer_)));

taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Chsk is closed: will try reconnect (%s).",cljs.core.array_seq([nattempt_STAR_], 0));

return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(taoensso$sente$connect_BANG_,cljs.core.array_seq([nattempt_STAR_], 0));
});})(WebSocket,temp__5457__auto__,chsk__$1))
;
var temp__5455__auto__ = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string(self__.url,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$client_DASH_id,self__.client_id], null))));
}catch (e29612){if((e29612 instanceof Error)){
var e = e29612;
taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("WebSocket js/Error: %s",cljs.core.array_seq([e], 0));

return null;
} else {
throw e29612;

}
}})();
if(cljs.core.truth_(temp__5455__auto__)){
var socket = temp__5455__auto__;
var G__29613 = self__.socket_;
var G__29614 = (function (){var G__29615 = socket;
(G__29615["onerror"] = ((function (G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1){
return (function (ws_ev){
return taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("WebSocket error: %s",cljs.core.array_seq([ws_ev], 0));
});})(G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1))
);

(G__29615["onmessage"] = ((function (G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = (ws_ev["data"]);
var vec__29616 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29616,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29616,(1),null);
var or__7960__auto__ = (function (){var and__7948__auto__ = taoensso.sente.handle_when_handshake_BANG_(chsk__$1,self__.chs,clj);
if(cljs.core.truth_(and__7948__auto__)){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.nattempt_,(0)) : cljs.core.reset_BANG_.call(null,self__.nattempt_,(0)));
} else {
return and__7948__auto__;
}
})();
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
var temp__5455__auto____$1 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__5455__auto____$1)){
var cb_uuid = temp__5455__auto____$1;
var temp__5455__auto____$2 = taoensso.sente.pull_unused_cb_fn_BANG_(self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__5455__auto____$2)){
var cb_fn = temp__5455__auto____$2;
return (cb_fn.cljs$core$IFn$_invoke$arity$1 ? cb_fn.cljs$core$IFn$_invoke$arity$1(clj) : cb_fn.call(null,clj));
} else {
return taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Cb reply w/o local cb-fn: %s",cljs.core.array_seq([clj], 0));
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs);
}
}
});})(G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1))
);

(G__29615["onopen"] = ((function (G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1){
return (function (_ws_ev){
var G__29619 = self__.kalive_timer_;
var G__29620 = window.setInterval(((function (G__29619,G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1){
return (function (){
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.kalive_due_QMARK__) : cljs.core.deref.call(null,self__.kalive_due_QMARK__)))){
taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2(chsk__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_ws_DASH_ping], null));
} else {
}

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.kalive_due_QMARK__,true) : cljs.core.reset_BANG_.call(null,self__.kalive_due_QMARK__,true));
});})(G__29619,G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1))
,self__.kalive_ms);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29619,G__29620) : cljs.core.reset_BANG_.call(null,G__29619,G__29620));
});})(G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1))
);

(G__29615["onclose"] = ((function (G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1){
return (function (_ws_ev){
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

return retry_BANG_();
});})(G__29615,G__29613,socket,temp__5455__auto__,retry_BANG_,WebSocket,temp__5457__auto__,chsk__$1))
);

return G__29615;
})();
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29613,G__29614) : cljs.core.reset_BANG_.call(null,G__29613,G__29614));
} else {
return retry_BANG_();
}
}
});})(WebSocket,temp__5457__auto__,chsk__$1))
.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$client_DASH_id,cljs.core.cst$sym$url,cljs.core.cst$sym$chs,cljs.core.cst$sym$socket_,cljs.core.cst$sym$kalive_DASH_ms,cljs.core.cst$sym$kalive_DASH_timer_,cljs.core.cst$sym$kalive_DASH_due_QMARK__,cljs.core.cst$sym$nattempt_,cljs.core.cst$sym$cbs_DASH_waiting_,cljs.core.cst$sym$state_,cljs.core.cst$sym$packer], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__8671__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__8671__auto__,writer__8672__auto__){
return cljs.core._write(writer__8672__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer){
return (new taoensso.sente.ChWebSocket(client_id,url,chs,socket_,kalive_ms,kalive_timer_,kalive_due_QMARK__,nattempt_,cbs_waiting_,state_,packer,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__29545){
return (new taoensso.sente.ChWebSocket(cljs.core.cst$kw$client_DASH_id.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$chs.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$socket_.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$kalive_DASH_ms.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$kalive_DASH_timer_.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$kalive_DASH_due_QMARK__.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$nattempt_.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$cbs_DASH_waiting_.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(G__29545),cljs.core.cst$kw$packer.cljs$core$IFn$_invoke$arity$1(G__29545),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__29545,cljs.core.cst$kw$client_DASH_id,cljs.core.array_seq([cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], 0)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,__meta,__extmap,__hash){
this.client_id = client_id;
this.url = url;
this.chs = chs;
this.timeout_ms = timeout_ms;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.state_ = state_;
this.packer = packer;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8635__auto__,k__8636__auto__){
var self__ = this;
var this__8635__auto____$1 = this;
return this__8635__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8636__auto__,null);
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8637__auto__,k29638,else__8638__auto__){
var self__ = this;
var this__8637__auto____$1 = this;
var G__29640 = (((k29638 instanceof cljs.core.Keyword))?k29638.fqn:null);
switch (G__29640) {
case "client-id":
return self__.client_id;

break;
case "url":
return self__.url;

break;
case "chs":
return self__.chs;

break;
case "timeout-ms":
return self__.timeout_ms;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "state_":
return self__.state_;

break;
case "packer":
return self__.packer;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k29638,else__8638__auto__);

}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8649__auto__,writer__8650__auto__,opts__8651__auto__){
var self__ = this;
var this__8649__auto____$1 = this;
var pr_pair__8652__auto__ = ((function (this__8649__auto____$1){
return (function (keyval__8653__auto__){
return cljs.core.pr_sequential_writer(writer__8650__auto__,cljs.core.pr_writer,""," ","",opts__8651__auto__,keyval__8653__auto__);
});})(this__8649__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__8650__auto__,pr_pair__8652__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__8651__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ajax_DASH_opts,self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$curr_DASH_xhr_,self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__29637){
var self__ = this;
var G__29637__$1 = this;
return (new cljs.core.RecordIter((0),G__29637__$1,8,new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$timeout_DASH_ms,cljs.core.cst$kw$ajax_DASH_opts,cljs.core.cst$kw$curr_DASH_xhr_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8633__auto__){
var self__ = this;
var this__8633__auto____$1 = this;
return self__.__meta;
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8629__auto__){
var self__ = this;
var this__8629__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8639__auto__){
var self__ = this;
var this__8639__auto____$1 = this;
return (8 + cljs.core.count(self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8630__auto__){
var self__ = this;
var this__8630__auto____$1 = this;
var h__8402__auto__ = self__.__hash;
if(!((h__8402__auto__ == null))){
return h__8402__auto__;
} else {
var h__8402__auto____$1 = cljs.core.hash_imap(this__8630__auto____$1);
self__.__hash = h__8402__auto____$1;

return h__8402__auto____$1;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8631__auto__,other__8632__auto__){
var self__ = this;
var this__8631__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7948__auto__ = other__8632__auto__;
if(cljs.core.truth_(and__7948__auto__)){
return ((this__8631__auto____$1.constructor === other__8632__auto__.constructor)) && (cljs.core.equiv_map(this__8631__auto____$1,other__8632__auto__));
} else {
return and__7948__auto__;
}
})())){
return true;
} else {
return false;
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8644__auto__,k__8645__auto__){
var self__ = this;
var this__8644__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$curr_DASH_xhr_,null,cljs.core.cst$kw$client_DASH_id,null,cljs.core.cst$kw$packer,null,cljs.core.cst$kw$chs,null,cljs.core.cst$kw$url,null,cljs.core.cst$kw$ajax_DASH_opts,null,cljs.core.cst$kw$timeout_DASH_ms,null,cljs.core.cst$kw$state_,null], null), null),k__8645__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__8644__auto____$1),self__.__meta),k__8645__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__8645__auto__)),null));
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8642__auto__,k__8643__auto__,G__29637){
var self__ = this;
var this__8642__auto____$1 = this;
var pred__29641 = cljs.core.keyword_identical_QMARK_;
var expr__29642 = k__8643__auto__;
if(cljs.core.truth_((function (){var G__29644 = cljs.core.cst$kw$client_DASH_id;
var G__29645 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29644,G__29645) : pred__29641.call(null,G__29644,G__29645));
})())){
return (new taoensso.sente.ChAjaxSocket(G__29637,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29646 = cljs.core.cst$kw$url;
var G__29647 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29646,G__29647) : pred__29641.call(null,G__29646,G__29647));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__29637,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29648 = cljs.core.cst$kw$chs;
var G__29649 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29648,G__29649) : pred__29641.call(null,G__29648,G__29649));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,G__29637,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29650 = cljs.core.cst$kw$timeout_DASH_ms;
var G__29651 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29650,G__29651) : pred__29641.call(null,G__29650,G__29651));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,G__29637,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29652 = cljs.core.cst$kw$ajax_DASH_opts;
var G__29653 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29652,G__29653) : pred__29641.call(null,G__29652,G__29653));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,G__29637,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29654 = cljs.core.cst$kw$curr_DASH_xhr_;
var G__29655 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29654,G__29655) : pred__29641.call(null,G__29654,G__29655));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,G__29637,self__.state_,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29656 = cljs.core.cst$kw$state_;
var G__29657 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29656,G__29657) : pred__29641.call(null,G__29656,G__29657));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,G__29637,self__.packer,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29658 = cljs.core.cst$kw$packer;
var G__29659 = expr__29642;
return (pred__29641.cljs$core$IFn$_invoke$arity$2 ? pred__29641.cljs$core$IFn$_invoke$arity$2(G__29658,G__29659) : pred__29641.call(null,G__29658,G__29659));
})())){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,G__29637,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__8643__auto__,G__29637),null));
}
}
}
}
}
}
}
}
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8647__auto__){
var self__ = this;
var this__8647__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$client_DASH_id,self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$url,self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$chs,self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ajax_DASH_opts,self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$curr_DASH_xhr_,self__.curr_xhr_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state_,self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$packer,self__.packer],null))], null),self__.__extmap));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8634__auto__,G__29637){
var self__ = this;
var this__8634__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.url,self__.chs,self__.timeout_ms,self__.ajax_opts,self__.curr_xhr_,self__.state_,self__.packer,G__29637,self__.__extmap,self__.__hash));
});

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8640__auto__,entry__8641__auto__){
var self__ = this;
var this__8640__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__8641__auto__)){
return this__8640__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__8641__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__8640__auto____$1,entry__8641__auto__);
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_send_BANG__STAR_$arity$3 = (function (chsk,ev,p__29660){
var self__ = this;
var map__29661 = p__29660;
var map__29661__$1 = ((((!((map__29661 == null)))?((((map__29661.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29661.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29661):map__29661);
var opts = map__29661__$1;
var _QMARK_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29661__$1,cljs.core.cst$kw$timeout_DASH_ms);
var _QMARK_cb = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29661__$1,cljs.core.cst$kw$cb);
var flush_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29661__$1,cljs.core.cst$kw$flush_QMARK_);
var chsk__$1 = this;
taoensso.sente.assert_send_args(ev,_QMARK_timeout_ms,_QMARK_cb);

var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn(_QMARK_cb,ev);
if(cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
taoensso.encore.warnf("Chsk send against closed chsk.");

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__29663 = cljs.core.cst$kw$chsk_SLASH_closed;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__29663) : _QMARK_cb_fn.call(null,G__29663));
} else {
return null;
}
} else {
var G__29664_29715 = self__.url;
var G__29665_29716 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$timeout_DASH_ms,_QMARK_timeout_ms,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$text,cljs.core.cst$kw$params,(function (){var ppstr = taoensso.sente.pack.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.packer,cljs.core.meta(ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?cljs.core.cst$kw$ajax_DASH_cb:null)], 0));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$_,taoensso.encore.now_udt(),cljs.core.cst$kw$csrf_DASH_token,cljs.core.cst$kw$csrf_DASH_token.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))),cljs.core.cst$kw$ppstr,ppstr], null);
})()], null)], 0));
var G__29666_29717 = ((function (G__29664_29715,G__29665_29716,_QMARK_cb_fn,chsk__$1,map__29661,map__29661__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_){
return (function taoensso$sente$ajax_cb(p__29667){
var map__29675 = p__29667;
var map__29675__$1 = ((((!((map__29675 == null)))?((((map__29675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29675.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29675):map__29675);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29675__$1,cljs.core.cst$kw$_QMARK_error);
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29675__$1,cljs.core.cst$kw$_QMARK_content);
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,cljs.core.cst$kw$timeout)){
if(cljs.core.truth_(_QMARK_cb_fn)){
var G__29677 = cljs.core.cst$kw$chsk_SLASH_timeout;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__29677) : _QMARK_cb_fn.call(null,G__29677));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
var G__29678 = cljs.core.cst$kw$chsk_SLASH_error;
return (_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(G__29678) : _QMARK_cb_fn.call(null,G__29678));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__29679 = taoensso.sente.unpack(self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29679,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29679,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
(_QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1 ? _QMARK_cb_fn.cljs$core$IFn$_invoke$arity$1(resp_clj) : _QMARK_cb_fn.call(null,resp_clj));
} else {
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(resp_clj,cljs.core.cst$kw$chsk_SLASH_dummy_DASH_cb_DASH_200)){
taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Cb reply w/o local cb-fn: %s",cljs.core.array_seq([resp_clj], 0));
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,true], null));
}
});})(G__29664_29715,G__29665_29716,_QMARK_cb_fn,chsk__$1,map__29661,map__29661__$1,opts,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_))
;
(taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3(G__29664_29715,G__29665_29716,G__29666_29717) : taoensso.sente.ajax_call.call(null,G__29664_29715,G__29665_29716,G__29666_29717));

return cljs.core.cst$kw$apparent_DASH_success;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$requested_DASH_reconnect_DASH_pending_QMARK_,true], null));

var temp__5457__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.curr_xhr_) : cljs.core.deref.call(null,self__.curr_xhr_));
if(cljs.core.truth_(temp__5457__auto__)){
var x = temp__5457__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_destroy_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,true], null));

var temp__5457__auto__ = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.curr_xhr_) : cljs.core.deref.call(null,self__.curr_xhr_));
if(cljs.core.truth_(temp__5457__auto__)){
var x = temp__5457__auto__;
return x.abort();
} else {
return null;
}
});

taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$chsk_init_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
((function (chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG_(nattempt){
taoensso.encore.tracef("async-poll-for-update!");

if(cljs.core.truth_(cljs.core.cst$kw$destroyed_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))){
return null;
} else {
var retry_BANG_ = ((function (chsk__$1){
return (function (){
var nattempt_STAR_ = (nattempt + (1));
taoensso.encore.warnf.cljs$core$IFn$_invoke$arity$variadic("Chsk is closed: will try reconnect (%s).",cljs.core.array_seq([nattempt_STAR_], 0));

return taoensso.sente.set_exp_backoff_timeout_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso$sente$async_poll_for_update_BANG_,nattempt_STAR_),cljs.core.array_seq([nattempt_STAR_], 0));
});})(chsk__$1))
;
var G__29698 = self__.curr_xhr_;
var G__29699 = (function (){var G__29700 = self__.url;
var G__29701 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$timeout_DASH_ms,self__.timeout_ms,cljs.core.cst$kw$resp_DASH_type,cljs.core.cst$kw$text,cljs.core.cst$kw$params,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$_,taoensso.encore.now_udt(),cljs.core.cst$kw$client_DASH_id,self__.client_id], null),(cljs.core.truth_(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.state_) : cljs.core.deref.call(null,self__.state_))))?null:new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$handshake_QMARK_,true], null))], 0))], null)], 0));
var G__29702 = ((function (G__29700,G__29701,G__29698,retry_BANG_,chsk__$1){
return (function taoensso$sente$async_poll_for_update_BANG__$_ajax_cb(p__29703){
var map__29709 = p__29703;
var map__29709__$1 = ((((!((map__29709 == null)))?((((map__29709.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29709.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29709):map__29709);
var _QMARK_error = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29709__$1,cljs.core.cst$kw$_QMARK_error);
var _QMARK_content = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29709__$1,cljs.core.cst$kw$_QMARK_content);
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(_QMARK_error,cljs.core.cst$kw$timeout)){
return taoensso$sente$async_poll_for_update_BANG_((0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,false], null));

return retry_BANG_();

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__29711 = taoensso.sente.unpack(self__.packer,ppstr);
var clj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29711,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29711,(1),null);
var or__7960__auto___29718 = taoensso.sente.handle_when_handshake_BANG_(chsk__$1,self__.chs,clj);
if(cljs.core.truth_(or__7960__auto___29718)){
} else {
var buffered_evs_29719 = clj;
taoensso.sente.receive_buffered_evs_BANG_(self__.chs,buffered_evs_29719);

taoensso.sente.merge_GT_chsk_state_BANG_(chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$open_QMARK_,true], null));
}

return taoensso$sente$async_poll_for_update_BANG_((0));
}
});})(G__29700,G__29701,G__29698,retry_BANG_,chsk__$1))
;
return (taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3 ? taoensso.sente.ajax_call.cljs$core$IFn$_invoke$arity$3(G__29700,G__29701,G__29702) : taoensso.sente.ajax_call.call(null,G__29700,G__29701,G__29702));
})();
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29698,G__29699) : cljs.core.reset_BANG_.call(null,G__29698,G__29699));
}
});})(chsk__$1))
.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$client_DASH_id,cljs.core.cst$sym$url,cljs.core.cst$sym$chs,cljs.core.cst$sym$timeout_DASH_ms,cljs.core.cst$sym$ajax_DASH_opts,cljs.core.cst$sym$curr_DASH_xhr_,cljs.core.cst$sym$state_,cljs.core.cst$sym$packer], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__8671__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__8671__auto__,writer__8672__auto__){
return cljs.core._write(writer__8672__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer){
return (new taoensso.sente.ChAjaxSocket(client_id,url,chs,timeout_ms,ajax_opts,curr_xhr_,state_,packer,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__29639){
return (new taoensso.sente.ChAjaxSocket(cljs.core.cst$kw$client_DASH_id.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$chs.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$timeout_DASH_ms.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$ajax_DASH_opts.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$curr_DASH_xhr_.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(G__29639),cljs.core.cst$kw$packer.cljs$core$IFn$_invoke$arity$1(G__29639),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__29639,cljs.core.cst$kw$client_DASH_id,cljs.core.array_seq([cljs.core.cst$kw$url,cljs.core.cst$kw$chs,cljs.core.cst$kw$timeout_DASH_ms,cljs.core.cst$kw$ajax_DASH_opts,cljs.core.cst$kw$curr_DASH_xhr_,cljs.core.cst$kw$state_,cljs.core.cst$kw$packer], 0)),null));
});

/**
 * (ƒ [path window-location websocket?]) -> server-side chsk route URL string.
 * 
 *  * path       - As provided to client-side `make-channel-socket!` fn
 *                 (usu. "/chsk").
 *  * websocket? - True for WebSocket connections, false for Ajax (long-polling)
 *                 connections.
 *  * window-location - Map with keys:
 *    :href     ; "http://www.example.org:80/foo/bar?q=baz#bang"
 *    :protocol ; "http:" ; Note the :
 *    :hostname ; "example.org"
 *    :host     ; "example.org:80"
 *    :pathname ; "/foo/bar"
 *    :search   ; "?q=baz"
 *    :hash     ; "#bang"
 * 
 *   Note that the *same* URL is used for: WebSockets, POSTs, GETs. Server-side
 *   routes should be configured accordingly.
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__29720,websocket_QMARK_){
var map__29723 = p__29720;
var map__29723__$1 = ((((!((map__29723 == null)))?((((map__29723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29723.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29723):map__29723);
var window_location = map__29723__$1;
var protocol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29723__$1,cljs.core.cst$kw$protocol);
var host = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29723__$1,cljs.core.cst$kw$host);
var pathname = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29723__$1,cljs.core.cst$kw$pathname);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.not(websocket_QMARK_))?protocol:((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,"https:"))?"wss:":"ws:"))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7960__auto__ = path;
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return pathname;
}
})())].join('');
});
/**
 * Returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *           ; May `put!` (inject) arbitrary `event`s to this channel.
 *  :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *  :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *  :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *  :type         ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto)
 *  :ws-kalive-ms ; Ping to keep a WebSocket conn alive if no activity w/in given
 *                ; number of milliseconds
 *  :lp-kalive-ms ; Ping to keep a long-polling (Ajax) conn alive ''
 *  :chsk-url-fn  ; Please see `default-chsk-url-fn` for details
 *  :packer       ; :edn (default), or an IPacker implementation (experimental)
 *  :ajax-opts    ; Base opts map provided to `ajax-call`
 */
taoensso.sente.make_channel_socket_BANG_ = (function taoensso$sente$make_channel_socket_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___29767 = arguments.length;
var i__9182__auto___29768 = (0);
while(true){
if((i__9182__auto___29768 < len__9181__auto___29767)){
args__9188__auto__.push((arguments[i__9182__auto___29768]));

var G__29769 = (i__9182__auto___29768 + (1));
i__9182__auto___29768 = G__29769;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((1) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__9189__auto__);
});

taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__29727){
var vec__29728 = p__29727;
var map__29731 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29728,(0),null);
var map__29731__$1 = ((((!((map__29731 == null)))?((((map__29731.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29731.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29731):map__29731);
var opts = map__29731__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$type,cljs.core.cst$kw$auto);
var recv_buf_or_n = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$recv_DASH_buf_DASH_or_DASH_n,cljs.core.async.sliding_buffer((2048)));
var ws_kalive_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$ws_DASH_kalive_DASH_ms,(25000));
var lp_timeout_ms = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$lp_DASH_timeout_DASH_ms,(25000));
var chsk_url_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$chsk_DASH_url_DASH_fn,taoensso.sente.default_chsk_url_fn);
var packer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$packer,cljs.core.cst$kw$edn);
var client_id = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__29731__$1,cljs.core.cst$kw$client_DASH_id,(function (){var or__7960__auto__ = cljs.core.cst$kw$client_DASH_uuid.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
return taoensso.encore.uuid_str.cljs$core$IFn$_invoke$arity$0();
}
})());
var ajax_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29731__$1,cljs.core.cst$kw$ajax_DASH_opts);
var _deprecated_more_opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29728,(1),null);
if((function (){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (){
return type;
});})(vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,null)),cljs.core.cst$sym$type,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$in,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$ws,null,cljs.core.cst$kw$ajax,null,cljs.core.cst$kw$auto,null], null), null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$in,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$ws,null,cljs.core.cst$kw$ajax,null,cljs.core.cst$kw$auto,null], null), null)], null));

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? [:in #{:ws :ajax :auto}] type)"));
}

if((function (){
taoensso.encore.hcond(false,"taoensso.sente",null,(new cljs.core.Delay(((function (vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (){
return client_id;
});})(vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,null)),cljs.core.cst$sym$client_DASH_id,taoensso.encore.nblank_str_QMARK_,cljs.core.cst$sym$enc_SLASH_nblank_DASH_str_QMARK_);

return true;
})()
){
} else {
throw (new Error("Assert failed: (have? enc/nblank-str? client-id)"));
}

if(!((_deprecated_more_opts == null))){
taoensso.encore.warnf("`make-channel-socket!` fn signature CHANGED with Sente v0.10.0.");
} else {
}

if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$lp_DASH_timeout)){
taoensso.encore.warnf(":lp-timeout opt has CHANGED; please use :lp-timout-ms.");
} else {
}

var packer__$1 = taoensso.sente.interfaces.coerce_packer(packer);
var window_location = taoensso.encore.get_window_location();
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$state,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((10))),cljs.core.cst$kw$internal,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((10))),cljs.core.cst$kw$_LT_server,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(recv_buf_or_n)], null);
var ever_opened_QMARK__ = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(false) : cljs.core.atom.call(null,false));
var state_STAR_ = ((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (state){
if(cljs.core.truth_((function (){var or__7960__auto__ = cljs.core.not(cljs.core.cst$kw$open_QMARK_.cljs$core$IFn$_invoke$arity$1(state));
if(or__7960__auto__){
return or__7960__auto__;
} else {
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ever_opened_QMARK__) : cljs.core.deref.call(null,ever_opened_QMARK__));
}
})())){
return state;
} else {
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(ever_opened_QMARK__,true) : cljs.core.reset_BANG_.call(null,ever_opened_QMARK__,true));

return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$first_DASH_open_QMARK_,true);
}
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
;
var public_ch_recv = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$internal.cljs$core$IFn$_invoke$arity$1(private_chs),cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (state){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_state,state_STAR_(state)], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(private_chs)),cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$chsk_SLASH_recv,ev], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,cljs.core.cst$kw$_LT_server.cljs$core$IFn$_invoke$arity$1(private_chs))], null));
var chsk = (function (){var or__7960__auto__ = (function (){var and__7948__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(type,cljs.core.cst$kw$ajax);
if(and__7948__auto__){
return taoensso.sente.chsk_init_BANG_(taoensso.sente.map__GT_ChWebSocket(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$client_DASH_id,cljs.core.cst$kw$kalive_DASH_ms,cljs.core.cst$kw$nattempt_,cljs.core.cst$kw$packer,cljs.core.cst$kw$chs,cljs.core.cst$kw$socket_,cljs.core.cst$kw$url,cljs.core.cst$kw$kalive_DASH_due_QMARK__,cljs.core.cst$kw$cbs_DASH_waiting_,cljs.core.cst$kw$kalive_DASH_timer_,cljs.core.cst$kw$state_],[client_id,ws_kalive_ms,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0))),packer__$1,private_chs,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),(function (){var G__29748 = path;
var G__29749 = window_location;
var G__29750 = cljs.core.cst$kw$ws;
return (chsk_url_fn.cljs$core$IFn$_invoke$arity$3 ? chsk_url_fn.cljs$core$IFn$_invoke$arity$3(G__29748,G__29749,G__29750) : chsk_url_fn.call(null,G__29748,G__29749,G__29750));
})(),(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true)),(function (){var G__29751 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29751) : cljs.core.atom.call(null,G__29751));
})(),(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),(function (){var G__29752 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$ws,cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,false], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29752) : cljs.core.atom.call(null,G__29752));
})()])));
} else {
return and__7948__auto__;
}
})();
if(cljs.core.truth_(or__7960__auto__)){
return or__7960__auto__;
} else {
var and__7948__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(type,cljs.core.cst$kw$ws);
if(and__7948__auto__){
return taoensso.sente.chsk_init_BANG_(taoensso.sente.map__GT_ChAjaxSocket(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$client_DASH_id,client_id,cljs.core.cst$kw$url,(function (){var G__29757 = path;
var G__29758 = window_location;
var G__29759 = cljs.core.not(cljs.core.cst$kw$ws);
return (chsk_url_fn.cljs$core$IFn$_invoke$arity$3 ? chsk_url_fn.cljs$core$IFn$_invoke$arity$3(G__29757,G__29758,G__29759) : chsk_url_fn.call(null,G__29757,G__29758,G__29759));
})(),cljs.core.cst$kw$chs,private_chs,cljs.core.cst$kw$packer,packer__$1,cljs.core.cst$kw$timeout_DASH_ms,lp_timeout_ms,cljs.core.cst$kw$ajax_DASH_opts,ajax_opts,cljs.core.cst$kw$curr_DASH_xhr_,(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null)),cljs.core.cst$kw$state_,(function (){var G__29760 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$ajax,cljs.core.cst$kw$open_QMARK_,false,cljs.core.cst$kw$destroyed_QMARK_,false], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29760) : cljs.core.atom.call(null,G__29760));
})()], null)));
} else {
return and__7948__auto__;
}
}
})();
var _ = (cljs.core.truth_(chsk)?null:(function(){throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Failed to create channel socket"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("chsk")].join('')))})());
var send_fn = cljs.core.partial.cljs$core$IFn$_invoke$arity$2(taoensso.sente.chsk_send_BANG_,chsk);
var public_ch_recv__$1 = cljs.core.async.map_LT_(((function (packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts){
return (function taoensso$sente$ev__GT_ev_msg(ev){
var vec__29764 = taoensso.sente.as_event(ev);
var ev_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29764,(0),null);
var ev__QMARK_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29764,(1),null);
var ev__$1 = vec__29764;
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$ch_DASH_recv,public_ch_recv,cljs.core.cst$kw$send_DASH_fn,send_fn,cljs.core.cst$kw$state,cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(chsk),cljs.core.cst$kw$event,ev__$1,cljs.core.cst$kw$id,ev_id,cljs.core.cst$kw$_QMARK_data,ev__QMARK_data], null);
});})(packer__$1,window_location,private_chs,ever_opened_QMARK__,state_STAR_,public_ch_recv,chsk,_,send_fn,vec__29728,map__29731,map__29731__$1,opts,type,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,chsk_url_fn,packer,client_id,ajax_opts,_deprecated_more_opts))
,public_ch_recv);
if(cljs.core.truth_(chsk)){
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$chsk,chsk,cljs.core.cst$kw$ch_DASH_recv,public_ch_recv__$1,cljs.core.cst$kw$send_DASH_fn,send_fn,cljs.core.cst$kw$state,cljs.core.cst$kw$state_.cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return null;
}
});

taoensso.sente.make_channel_socket_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_BANG_.cljs$lang$applyTo = (function (seq29725){
var G__29726 = cljs.core.first(seq29725);
var seq29725__$1 = cljs.core.next(seq29725);
return taoensso.sente.make_channel_socket_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29726,seq29725__$1);
});

/**
 * Creates a go-loop to call `(event-msg-handler <event-msg>)` and returns a
 *   `(fn stop! [])`. Catches & logs errors. Advanced users may choose to instead
 *   write their own loop against `ch-recv`.
 */
taoensso.sente.start_chsk_router_BANG_ = (function taoensso$sente$start_chsk_router_BANG_(var_args){
var args__9188__auto__ = [];
var len__9181__auto___29905 = arguments.length;
var i__9182__auto___29906 = (0);
while(true){
if((i__9182__auto___29906 < len__9181__auto___29905)){
args__9188__auto__.push((arguments[i__9182__auto___29906]));

var G__29907 = (i__9182__auto___29906 + (1));
i__9182__auto___29906 = G__29907;
continue;
} else {
}
break;
}

var argseq__9189__auto__ = ((((2) < args__9188__auto__.length))?(new cljs.core.IndexedSeq(args__9188__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__9189__auto__);
});

taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__29773){
var vec__29774 = p__29773;
var map__29777 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29774,(0),null);
var map__29777__$1 = ((((!((map__29777 == null)))?((((map__29777.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29777.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29777):map__29777);
var opts = map__29777__$1;
var trace_evs_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29777__$1,cljs.core.cst$kw$trace_DASH_evs_QMARK_);
var ch_ctrl = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var c__26566__auto___29908 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_){
return (function (){
var f__26567__auto__ = (function (){var switch__26440__auto__ = ((function (c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_){
return (function (state_29854){
var state_val_29855 = (state_29854[(1)]);
if((state_val_29855 === (7))){
var inst_29792 = (state_29854[(2)]);
var inst_29793 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792,(0),null);
var inst_29794 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29792,(1),null);
var inst_29795 = (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(inst_29794,ch_ctrl) : taoensso.encore.kw_identical_QMARK_.call(null,inst_29794,ch_ctrl));
var state_29854__$1 = (function (){var statearr_29856 = state_29854;
(statearr_29856[(7)] = inst_29793);

return statearr_29856;
})();
if(cljs.core.truth_(inst_29795)){
var statearr_29857_29909 = state_29854__$1;
(statearr_29857_29909[(1)] = (8));

} else {
var statearr_29858_29910 = state_29854__$1;
(statearr_29858_29910[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (20))){
var inst_29840 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
var statearr_29859_29911 = state_29854__$1;
(statearr_29859_29911[(2)] = inst_29840);

(statearr_29859_29911[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (27))){
var inst_29819 = (state_29854[(8)]);
var inst_29836 = (event_msg_handler.cljs$core$IFn$_invoke$arity$1 ? event_msg_handler.cljs$core$IFn$_invoke$arity$1(inst_29819) : event_msg_handler.call(null,inst_29819));
var state_29854__$1 = state_29854;
var statearr_29860_29912 = state_29854__$1;
(statearr_29860_29912[(2)] = inst_29836);

(statearr_29860_29912[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (1))){
var state_29854__$1 = state_29854;
var statearr_29861_29913 = state_29854__$1;
(statearr_29861_29913[(2)] = null);

(statearr_29861_29913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (24))){
var state_29854__$1 = state_29854;
var statearr_29862_29914 = state_29854__$1;
(statearr_29862_29914[(2)] = null);

(statearr_29862_29914[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (4))){
var inst_29844 = (state_29854[(2)]);
var inst_29845 = (function (){var G__29863 = cljs.core.cst$kw$taoensso$sente_SLASH_stop;
var G__29864 = inst_29844;
return (taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2 ? taoensso.encore.kw_identical_QMARK_.cljs$core$IFn$_invoke$arity$2(G__29863,G__29864) : taoensso.encore.kw_identical_QMARK_.call(null,G__29863,G__29864));
})();
var state_29854__$1 = state_29854;
if(cljs.core.truth_(inst_29845)){
var statearr_29865_29915 = state_29854__$1;
(statearr_29865_29915[(1)] = (29));

} else {
var statearr_29866_29916 = state_29854__$1;
(statearr_29866_29916[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (15))){
var state_29854__$1 = state_29854;
var statearr_29867_29917 = state_29854__$1;
(statearr_29867_29917[(2)] = false);

(statearr_29867_29917[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (21))){
var inst_29820 = (state_29854[(9)]);
var inst_29821 = (state_29854[(2)]);
var inst_29822 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk router handling error (%s): %s",cljs.core.array_seq([inst_29820,inst_29821], 0));
var state_29854__$1 = state_29854;
var statearr_29868_29918 = state_29854__$1;
(statearr_29868_29918[(2)] = inst_29822);


cljs.core.async.impl.ioc_helpers.process_exception(state_29854__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (31))){
var inst_29850 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
var statearr_29869_29919 = state_29854__$1;
(statearr_29869_29919[(2)] = inst_29850);

(statearr_29869_29919[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (13))){
var inst_29814 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
if(cljs.core.truth_(inst_29814)){
var statearr_29870_29920 = state_29854__$1;
(statearr_29870_29920[(1)] = (17));

} else {
var statearr_29871_29921 = state_29854__$1;
(statearr_29871_29921[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (22))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29854,(21),Error,null,(20));
var state_29854__$1 = state_29854;
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_29872_29922 = state_29854__$1;
(statearr_29872_29922[(1)] = (23));

} else {
var statearr_29873_29923 = state_29854__$1;
(statearr_29873_29923[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (29))){
var state_29854__$1 = state_29854;
var statearr_29874_29924 = state_29854__$1;
(statearr_29874_29924[(2)] = null);

(statearr_29874_29924[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (6))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_29854,(5),Error,null,(4));
var inst_29788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29789 = [ch_recv,ch_ctrl];
var inst_29790 = (new cljs.core.PersistentVector(null,2,(5),inst_29788,inst_29789,null));
var state_29854__$1 = state_29854;
return cljs.core.async.ioc_alts_BANG_(state_29854__$1,(7),inst_29790);
} else {
if((state_val_29855 === (28))){
var inst_29838 = (state_29854[(2)]);
var state_29854__$1 = (function (){var statearr_29875 = state_29854;
(statearr_29875[(10)] = inst_29838);

return statearr_29875;
})();
var statearr_29876_29925 = state_29854__$1;
(statearr_29876_29925[(2)] = null);


cljs.core.async.impl.ioc_helpers.process_exception(state_29854__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (25))){
var inst_29819 = (state_29854[(8)]);
var inst_29830 = (state_29854[(2)]);
var inst_29831 = taoensso.sente.event_msg_QMARK_(inst_29819);
var inst_29832 = cljs.core.not(inst_29831);
var state_29854__$1 = (function (){var statearr_29877 = state_29854;
(statearr_29877[(11)] = inst_29830);

return statearr_29877;
})();
if(inst_29832){
var statearr_29878_29926 = state_29854__$1;
(statearr_29878_29926[(1)] = (26));

} else {
var statearr_29879_29927 = state_29854__$1;
(statearr_29879_29927[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (17))){
var inst_29793 = (state_29854[(7)]);
var inst_29816 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29793);
var state_29854__$1 = state_29854;
var statearr_29880_29928 = state_29854__$1;
(statearr_29880_29928[(2)] = inst_29816);

(statearr_29880_29928[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (3))){
var inst_29852 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29854__$1,inst_29852);
} else {
if((state_val_29855 === (12))){
var state_29854__$1 = state_29854;
var statearr_29881_29929 = state_29854__$1;
(statearr_29881_29929[(2)] = false);

(statearr_29881_29929[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (2))){
var state_29854__$1 = state_29854;
var statearr_29882_29930 = state_29854__$1;
(statearr_29882_29930[(2)] = null);

(statearr_29882_29930[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (23))){
var inst_29820 = (state_29854[(9)]);
var inst_29827 = taoensso.encore.tracef.cljs$core$IFn$_invoke$arity$variadic("Pre-handler event: %s",cljs.core.array_seq([inst_29820], 0));
var state_29854__$1 = state_29854;
var statearr_29883_29931 = state_29854__$1;
(statearr_29883_29931[(2)] = inst_29827);

(statearr_29883_29931[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (19))){
var inst_29819 = (state_29854[(8)]);
var inst_29819__$1 = (state_29854[(2)]);
var inst_29820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29819__$1,cljs.core.cst$kw$event);
var state_29854__$1 = (function (){var statearr_29884 = state_29854;
(statearr_29884[(9)] = inst_29820);

(statearr_29884[(8)] = inst_29819__$1);

return statearr_29884;
})();
var statearr_29885_29932 = state_29854__$1;
(statearr_29885_29932[(2)] = null);

(statearr_29885_29932[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (11))){
var inst_29793 = (state_29854[(7)]);
var inst_29803 = inst_29793.cljs$lang$protocol_mask$partition0$;
var inst_29804 = (inst_29803 & (64));
var inst_29805 = inst_29793.cljs$core$ISeq$;
var inst_29806 = (cljs.core.PROTOCOL_SENTINEL === inst_29805);
var inst_29807 = (inst_29804) || (inst_29806);
var state_29854__$1 = state_29854;
if(cljs.core.truth_(inst_29807)){
var statearr_29886_29933 = state_29854__$1;
(statearr_29886_29933[(1)] = (14));

} else {
var statearr_29887_29934 = state_29854__$1;
(statearr_29887_29934[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (9))){
var inst_29793 = (state_29854[(7)]);
var inst_29800 = (inst_29793 == null);
var inst_29801 = cljs.core.not(inst_29800);
var state_29854__$1 = state_29854;
if(inst_29801){
var statearr_29888_29935 = state_29854__$1;
(statearr_29888_29935[(1)] = (11));

} else {
var statearr_29889_29936 = state_29854__$1;
(statearr_29889_29936[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (5))){
var inst_29780 = (state_29854[(2)]);
var inst_29781 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Chsk router channel error (%s)!",cljs.core.array_seq([inst_29780], 0));
var state_29854__$1 = state_29854;
var statearr_29890_29937 = state_29854__$1;
(statearr_29890_29937[(2)] = inst_29781);


cljs.core.async.impl.ioc_helpers.process_exception(state_29854__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (14))){
var state_29854__$1 = state_29854;
var statearr_29891_29938 = state_29854__$1;
(statearr_29891_29938[(2)] = true);

(statearr_29891_29938[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (26))){
var inst_29820 = (state_29854[(9)]);
var inst_29834 = taoensso.encore.errorf.cljs$core$IFn$_invoke$arity$variadic("Bad event: %s",cljs.core.array_seq([inst_29820], 0));
var state_29854__$1 = state_29854;
var statearr_29892_29939 = state_29854__$1;
(statearr_29892_29939[(2)] = inst_29834);

(statearr_29892_29939[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (16))){
var inst_29811 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
var statearr_29893_29940 = state_29854__$1;
(statearr_29893_29940[(2)] = inst_29811);

(statearr_29893_29940[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (30))){
var state_29854__$1 = state_29854;
var statearr_29894_29941 = state_29854__$1;
(statearr_29894_29941[(2)] = null);

(statearr_29894_29941[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (10))){
var inst_29842 = (state_29854[(2)]);
var state_29854__$1 = state_29854;
var statearr_29895_29942 = state_29854__$1;
(statearr_29895_29942[(2)] = inst_29842);


cljs.core.async.impl.ioc_helpers.process_exception(state_29854__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (18))){
var inst_29793 = (state_29854[(7)]);
var state_29854__$1 = state_29854;
var statearr_29896_29943 = state_29854__$1;
(statearr_29896_29943[(2)] = inst_29793);

(statearr_29896_29943[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29855 === (8))){
var state_29854__$1 = state_29854;
var statearr_29897_29944 = state_29854__$1;
(statearr_29897_29944[(2)] = cljs.core.cst$kw$taoensso$sente_SLASH_stop);

(statearr_29897_29944[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_))
;
return ((function (switch__26440__auto__,c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_){
return (function() {
var taoensso$sente$state_machine__26441__auto__ = null;
var taoensso$sente$state_machine__26441__auto____0 = (function (){
var statearr_29901 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29901[(0)] = taoensso$sente$state_machine__26441__auto__);

(statearr_29901[(1)] = (1));

return statearr_29901;
});
var taoensso$sente$state_machine__26441__auto____1 = (function (state_29854){
while(true){
var ret_value__26442__auto__ = (function (){try{while(true){
var result__26443__auto__ = switch__26440__auto__(state_29854);
if(cljs.core.keyword_identical_QMARK_(result__26443__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__26443__auto__;
}
break;
}
}catch (e29902){if((e29902 instanceof Object)){
var ex__26444__auto__ = e29902;
var statearr_29903_29945 = state_29854;
(statearr_29903_29945[(5)] = ex__26444__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_29854);

return cljs.core.cst$kw$recur;
} else {
throw e29902;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__26442__auto__,cljs.core.cst$kw$recur)){
var G__29946 = state_29854;
state_29854 = G__29946;
continue;
} else {
return ret_value__26442__auto__;
}
break;
}
});
taoensso$sente$state_machine__26441__auto__ = function(state_29854){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__26441__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__26441__auto____1.call(this,state_29854);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
taoensso$sente$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__26441__auto____0;
taoensso$sente$state_machine__26441__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__26441__auto____1;
return taoensso$sente$state_machine__26441__auto__;
})()
;})(switch__26440__auto__,c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_))
})();
var state__26568__auto__ = (function (){var statearr_29904 = (f__26567__auto__.cljs$core$IFn$_invoke$arity$0 ? f__26567__auto__.cljs$core$IFn$_invoke$arity$0() : f__26567__auto__.call(null));
(statearr_29904[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__26566__auto___29908);

return statearr_29904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__26568__auto__);
});})(c__26566__auto___29908,ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_))
);


return ((function (ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_){
return (function taoensso$sente$stop_BANG_(){
return cljs.core.async.close_BANG_(ch_ctrl);
});
;})(ch_ctrl,vec__29774,map__29777,map__29777__$1,opts,trace_evs_QMARK_))
});

taoensso.sente.start_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_chsk_router_BANG_.cljs$lang$applyTo = (function (seq29770){
var G__29771 = cljs.core.first(seq29770);
var seq29770__$1 = cljs.core.next(seq29770);
var G__29772 = cljs.core.first(seq29770__$1);
var seq29770__$2 = cljs.core.next(seq29770__$1);
return taoensso.sente.start_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__29771,G__29772,seq29770__$2);
});

/**
 * DEPRECATED: Please use `start-chsk-router!` instead.
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_chsk_router_BANG_(ch_recv,(function (ev_msg){
var G__29949 = cljs.core.cst$kw$event.cljs$core$IFn$_invoke$arity$1(ev_msg);
var G__29950 = cljs.core.cst$kw$ch_DASH_recv.cljs$core$IFn$_invoke$arity$1(ev_msg);
return (event_handler.cljs$core$IFn$_invoke$arity$2 ? event_handler.cljs$core$IFn$_invoke$arity$2(G__29949,G__29950) : event_handler.call(null,G__29949,G__29950));
}));
});
