# pca

A small Clojure library to do principal component analysis built on core.matrix.

Provides means to use principal components to compress and decompress vectors.

There is a function to calculate covariance matrix. This function can take a lazyseq
as input. Which means you can input very large datasets! :D

Note: Covariance has not been tested on matrices, and does not take two vectors as inputs.

Currently requires clatrix as dependency because it provides usable implementation of eigenvector
calculation. However, it is planned in future versions to sit on top of the core.matrix protocol
in general.

## Installation


## Usage

```clojure
(ns foo.core
  (:require [pca.core :refer :all]))

(def test-data (let [v [1 2 3 4 5]]
                 (repeat 5 v)))

(def cv (covariance test-data))

(def components
  (principal-components cv 2))

(def xy (compress components [1 2 3 4 5]))

(def reconstruct-xy (decompress components xy))
```

## License

Copyright © 2016 FIXME

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
