(ns plotly-clj.core
  (:require [clojure.data.json :as json]
            [clojure.java.io :as io])
  (:import [java.awt Desktop]
           [java.net URL]))

(def d (Desktop/getDesktop))

(defn plot
  ([w h data layout] (plot w h data layout "index.html"))
  ([w h data layout filename]
   (spit filename
        (str
         "<html><head><script src=\"https://cdn.plot.ly/plotly-1.2.0.min.js\"></script></head><body>"
         "<div id='plot' style=\"width:" w "px;height:" h "px;\"></div>"
         "<script> p = document.getElementById('plot'); Plotly.plot(p,"
         (json/write-str data)
         ","
         (json/write-str layout)
         "); </script> </body> </html>"))
   (.browse d (URI. (str "file://" (.getAbsolutePath (clojure.java.io/file filename)))))))
