# plotly-clj

A simple interface to plotly for clojure. [plotly.js](https://plot.ly/javascript/) api is simply a JSON object. This wrapper converts Clojure data (maps, vecs) into JSON. All the user has to do is follow the conventions of plotly in order to make sweet graphs!

Offline support will be added later.

PR's are welcome!

### Installation

Install with Leiningen:
```clojure
[hswick/plotly-clj "0.1.2"]
```

## Usage

```clojure
(ns foo.core
  (:require [plotly-clj.core :refer :all]))

(def group-a {:type "scatter"
              :x [1 2 3]
              :y [1 2 3]
              :text ["foo" "bar" "foobar"]
              :name "Group A"
              :mode "markers"})

(def group-b {:type "scatter"
              :x [3 2 1]
              :y [1 2 3]
              :text ["fooboo" "boo" "barfoo"]
              :name "Group B"
              :mode "markers"})

;;Data has to be an array of JSON objects (vec/list of maps in Clojure)
(def data [group-a group-b])

;;See plotly.js api on how to use layout
(def layout {})

(plot 800 800 data layout);;This opens up a plot with your default browser
```

## API
```clojure
(plot [w h data])
(plot [w h data layout]);;uses index.html as filename by default
(plot [w h data layout filename])
```

## License

Copyright © 2016

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
