/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.dbcp;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.httpkit.dbcp.DBCPException;
import org.httpkit.dbcp.NoCloseConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalConnection
extends ThreadLocal<Connection> {
    private final String url;
    private final String username;
    private final String password;
    private final Map<WeakReference<Thread>, Connection> connections = new HashMap<WeakReference<Thread>, Connection>();
    private final ReferenceQueue<Thread> queue = new ReferenceQueue();
    private final AtomicInteger counter = new AtomicInteger(0);

    public ThreadLocalConnection(String url, String username, String password) {
        this.url = url;
        this.username = username;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SQLException ex = null;
        Map<WeakReference<Thread>, Connection> map = this.connections;
        synchronized (map) {
            for (Connection c : this.connections.values()) {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    ex = e;
                }
            }
            this.connections.clear();
        }
        if (ex != null) {
            throw new DBCPException("close connection error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayList<String> names;
        int active = 0;
        Map<WeakReference<Thread>, Connection> map = this.connections;
        synchronized (map) {
            active = this.connections.size();
            names = new ArrayList<String>(active);
            for (WeakReference<Thread> r : this.connections.keySet()) {
                Thread t = (Thread)r.get();
                if (t != null) {
                    names.add(t.getName());
                    continue;
                }
                names.add("null");
            }
        }
        return "opened=" + this.counter.get() + ", active=" + active + ", threads=" + names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDiedThreadConnection() {
        Reference<Thread> r;
        while ((r = this.queue.poll()) != null) {
            Map<WeakReference<Thread>, Connection> map = this.connections;
            synchronized (map) {
                Connection c = this.connections.get(r);
                this.connections.remove(r);
                try {
                    c.close();
                }
                catch (SQLException e) {
                    throw new DBCPException("closed died thread connecton", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeBrokenConnections() {
        Map<WeakReference<Thread>, Connection> map = this.connections;
        synchronized (map) {
            Iterator<Connection> ite = this.connections.values().iterator();
            while (ite.hasNext()) {
                Connection con = ite.next();
                try {
                    Statement stat = con.createStatement();
                    stat.executeQuery("select 1").close();
                    stat.close();
                }
                catch (Exception e1) {
                    ite.remove();
                    try {
                        con.close();
                    }
                    catch (SQLException ignore) {}
                }
            }
        }
    }

    @Override
    public Connection get() {
        this.closeDiedThreadConnection();
        Connection con = (Connection)super.get();
        try {
            if (con.isClosed()) {
                this.closeBrokenConnections();
                this.remove();
                return (Connection)super.get();
            }
        }
        catch (SQLException e) {
            throw new DBCPException("error when asking isClosed ??", e);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Connection initialValue() {
        this.counter.incrementAndGet();
        try {
            Connection con = DriverManager.getConnection(this.url, this.username, this.password);
            if (con.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql")) {
                int timeout;
                Statement stat = con.createStatement();
                ResultSet rs = stat.executeQuery("show variables like 'wait_timeout'");
                if (rs.next() && (timeout = rs.getInt(2)) == 28800) {
                    stat.executeUpdate("set wait_timeout = 259200");
                }
                rs.close();
                stat.close();
            }
            Map<WeakReference<Thread>, Connection> map = this.connections;
            synchronized (map) {
                this.connections.put(new WeakReference<Thread>(Thread.currentThread(), this.queue), con);
            }
            return new NoCloseConnection(con);
        }
        catch (SQLException e) {
            throw new DBCPException("connect to mysql error", e);
        }
    }
}

